/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:10:27 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import javax.swing.DebugGraphics;
import org.apache.xmlgraphics.java2d.DefaultGraphics2D;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.chado.FeatureLocLazyQualifierValue;
import uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.LazyQualifierValue;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierLazyLoading;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ProteinMapPanel_ESTest extends ProteinMapPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Selection selection0 = new Selection((Clipboard) null);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel((Feature) null, chadoCanonicalGene0, selection0);
      DebugGraphics debugGraphics0 = new DebugGraphics();
      // Undeclared exception!
      try { 
        proteinMapPanel0.paintComponent(debugGraphics0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.DebugGraphics", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        ProteinMapPanel.isProteinMapElement((Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(6);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(databaseInferredFeature0, chadoCanonicalGene0, selection0);
      // Undeclared exception!
      try { 
        proteinMapPanel0.getToolTipText((MouseEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        ProteinMapPanel.getProteinsWithProteinMapElement((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        ProteinMapPanel.getProteinMapQualifiers((uk.ac.sanger.artemis.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel((Feature) null, chadoCanonicalGene0, selection0);
      // Undeclared exception!
      try { 
        proteinMapPanel0.drawPrediction((Feature) null, (Graphics2D) null, 4586, 1185, 0, 1185, (String[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(genbankStreamFeature0, chadoCanonicalGene0, selection0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (LazyQualifierValue) null);
      // Undeclared exception!
      try { 
        proteinMapPanel0.drawGPIArrow((Graphics2D) null, qualifierLazyLoading0, 1282, (-269), 1282, 750);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierLazyLoading", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(6);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(databaseInferredFeature0, chadoCanonicalGene0, selection0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(true);
      Qualifier qualifier0 = new Qualifier("7M8mI,WOtUw8");
      // Undeclared exception!
      try { 
        proteinMapPanel0.drawGPIArrow(defaultGraphics2D0, qualifier0, 32, 32, (-2021708368), 0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Qualifier cannot be cast to uk.ac.sanger.artemis.io.QualifierLazyLoading
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel((Feature) null, chadoCanonicalGene0, selection0);
      // Undeclared exception!
      try { 
        proteinMapPanel0.drawDomain((Feature) null, (Graphics2D) null, 0, 0, 0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      uk.ac.sanger.artemis.Feature feature0 = new uk.ac.sanger.artemis.Feature(genbankStreamFeature0);
      QualifierVector qualifierVector0 = ProteinMapPanel.getProteinMapQualifiers(feature0);
      assertNull(qualifierVector0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue((org.gmod.schema.sequence.Feature) null, 5);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("polypeptide_domain", featureLocLazyQualifierValue0);
      boolean boolean0 = ProteinMapPanel.isProteinMapElement(qualifierLazyLoading0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("uk.ac.sanger.artemis.components.genebuilder.ProteinMapPanel$1", (List) null);
      boolean boolean0 = ProteinMapPanel.isProteinMapElement(qualifierLazyLoading0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(6);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      List<Feature> list0 = ProteinMapPanel.getProteinsWithProteinMapElement(databaseInferredFeature0);
      assertNull(list0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(genbankStreamFeature0, chadoCanonicalGene0, selection0);
      MouseWheelEvent mouseWheelEvent0 = new MouseWheelEvent(proteinMapPanel0, 59, 59, (-2021730580), 59, (-30), (-2147483645), 1282, (-269), false, (-2147483645), 1282, (-1058), (-2147483645));
      String string0 = proteinMapPanel0.getToolTipText((MouseEvent) mouseWheelEvent0);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(6);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(databaseInferredFeature0, chadoCanonicalGene0, selection0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(true);
      proteinMapPanel0.drawPrediction(databaseInferredFeature0, defaultGraphics2D0, 6, (-1215), 32, 0, proteinMapPanel0.TMHMM);
      assertFalse(databaseInferredFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(6);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(databaseInferredFeature0, chadoCanonicalGene0, selection0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(true);
      proteinMapPanel0.drawDomain(databaseInferredFeature0, defaultGraphics2D0, 32, 32, (-1215), (-2503));
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      ProteinMapPanel proteinMapPanel0 = new ProteinMapPanel(genbankStreamFeature0, chadoCanonicalGene0, selection0);
      int int0 = proteinMapPanel0.drawDomain(genbankStreamFeature0, (Graphics2D) null, (-30), (-30), (-30), (-30));
      assertEquals((-30), int0);
  }
}
