/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 17:12:42 GMT 2018
 */

package uk.ac.sanger.artemis.circular.digest;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.circular.digest.CutSite;
import uk.ac.sanger.artemis.circular.digest.FragmentBand;
import uk.ac.sanger.artemis.circular.digest.ReportDetails;
import uk.ac.sanger.artemis.circular.digest.Utils;
import uk.ac.sanger.artemis.io.EmblStreamFeature;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Utils_ESTest extends Utils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      StringReader stringReader0 = new StringReader("FtAJEO|");
      assertNotNull(stringReader0);
      
      ReportDetails reportDetails0 = Utils.findCutSitesFromEmbossReport(stringReader0);
      assertNotNull(reportDetails0);
      
      List<FragmentBand> list0 = Utils.findCutSitesFromExperiment(stringReader0);
      assertEquals(0, list0.size());
      assertTrue(list0.isEmpty());
      assertNotNull(list0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      Feature feature0 = new Feature(emblStreamFeature0);
      assertTrue(feature0.isProteinFeature());
      assertTrue(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertNotNull(feature0);
      
      Reader reader0 = feature0.toReader();
      assertTrue(feature0.isProteinFeature());
      assertTrue(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertNotNull(reader0);
      
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromExperiment(reader0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"FT   CDS             uk.ac.sanger.artemis.io.Range@0000000006\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromExperiment((Reader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      assertNotNull(pipedReader0);
      
      try { 
        Utils.findCutSitesFromExperiment(pipedReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromEmbossReport((Reader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ReportDetails reportDetails0 = new ReportDetails();
      assertNotNull(reportDetails0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertNotNull(simpleEntryGroup0);
      
      reportDetails0.length = (-2161);
      // Undeclared exception!
      try { 
        Utils.createDNADrawFromReportDetails(reportDetails0, simpleEntryGroup0);
        fail("Expecting exception: ArithmeticException");
      
      } catch(ArithmeticException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ReportDetails reportDetails0 = new ReportDetails();
      assertNotNull(reportDetails0);
      
      reportDetails0.length = 24576;
      ArrayList<CutSite> arrayList0 = new ArrayList<CutSite>();
      assertTrue(arrayList0.isEmpty());
      assertEquals(0, arrayList0.size());
      assertNotNull(arrayList0);
      
      reportDetails0.cutSites = (List<CutSite>) arrayList0;
      assertTrue(arrayList0.isEmpty());
      assertEquals(0, arrayList0.size());
      assertTrue(reportDetails0.cutSites.isEmpty());
      assertEquals(0, reportDetails0.cutSites.size());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertNotNull(simpleEntryGroup0);
      
      // Undeclared exception!
      try { 
        Utils.createDNADrawFromReportDetails(reportDetails0, simpleEntryGroup0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      BufferedReader bufferedReader0 = new BufferedReader(stringReader0);
      ReportDetails reportDetails0 = Utils.findCutSitesFromEmbossReport(bufferedReader0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, "");
      // Undeclared exception!
      Utils.createDNADrawFromReportDetails(reportDetails0, filteredEntryGroup0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      ReportDetails reportDetails0 = new ReportDetails();
      reportDetails0.length = 24576;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        Utils.createDNADrawFromReportDetails(reportDetails0, simpleEntryGroup0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.digest.Utils", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      StringReader stringReader0 = new StringReader("5");
      List<FragmentBand> list0 = Utils.findCutSitesFromExperiment(stringReader0);
      assertEquals(1, list0.size());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader(1530);
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromEmbossReport(pipedReader0);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Couldn't read, or parse results
         //
         verifyException("uk.ac.sanger.artemis.circular.digest.Utils", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Utils utils0 = new Utils();
  }
}
