/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 22:26:42 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.MSPcrunchComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class MSPcrunchComparisonData_ESTest extends MSPcrunchComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(8, 8, 8, 8, 8, 8);
      // Undeclared exception!
      try { 
        MSPcrunchComparisonData.writeMatchFromAlignMatch(alignMatch0, "uk.ac.sanger.artemis.sequence.Bases", "uk.ac.sanger.artemis.sequence.Bases", (Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
      try { 
        mSPcrunchComparisonData0.makeMatchFromString("LinePushBackReader.pushBack () called twice before calling readLine ()");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading MSPcrunch data: failed to parse a number from this string: For input string: \"LinePushBackReader.pushBack\"
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      // Undeclared exception!
      try { 
        MSPcrunchComparisonData.formatCorrect((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("uk.ac.sanger.artemis.MSPcrunchComparisonData").when(linePushBackReader0).readLine();
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // while reading MSPcrunch data: not enough fields in this line: uk.ac.sanger.artemis.MSPcrunchComparisonData
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("", (String) null).when(linePushBackReader0).readLine();
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("while reading MSPcrunch data: failed to parse a number from this string: ").when(linePushBackReader0).readLine();
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // while reading MSPcrunch data: failed to parse a number from this string: For input string: \"while\"
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      try { 
        mSPcrunchComparisonData0.makeMatchFromString("");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading MSPcrunch data: not enough fields in this line: 
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      boolean boolean0 = MSPcrunchComparisonData.formatCorrect("while reading MSPcrunch data: failed to parse a number from this string: ");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
      // Undeclared exception!
      try { 
        mSPcrunchComparisonData0.makeMatchFromString((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(3, 3, (-3583), (-3583), 3, 120);
      Writer writer0 = mock(Writer.class, new ViolatedAssumptionAnswer());
      MSPcrunchComparisonData.writeMatchFromAlignMatch(alignMatch0, "&KPH {\u0005\"n@Q{Q6F", "zS\"-", writer0);
      assertEquals(120, alignMatch0.getPercentID());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
      SimpleComparisonData simpleComparisonData0 = mSPcrunchComparisonData0.getNewSimpleComparisonData();
      assertNotSame(mSPcrunchComparisonData0, simpleComparisonData0);
  }
}
