import React from 'react';
import {
    Grid,
    GridItem,
    Radio,
    Text,
    TextContent,
    TextVariants,
    Tooltip
}   from '@patternfly/react-core';
import {
    InfoCircleIcon
} from '@patternfly/react-icons';
import AddCosDefinition from './operations/addCosDefinition.jsx';
import AddCosTemplate from './operations/addCosTemplate.jsx';

class CoSEntryWizard extends React.Component {
    constructor (props) {
        super(props);

        this.state = {
            stepIdReached: 1,
            getStartedStepRadio: 'CoSDefinition'
        };
    }

    handleOnChange = (_, event) => {
        // console.log('event.currentTarget.value = ' + event.currentTarget.value);
        this.setState({ getStartedStepRadio: event.currentTarget.value });
    };

    createInitialLayout=() => {
        // Creation of a CoS entry
        return ([
            {
                id: 1,
                name: 'Get Started',
                component: (
                    <div>
                        <Grid>
                            <GridItem span={12}>
                                <TextContent>
                                    <Text component={TextVariants.h3}>Select CoS Type</Text>
                                </TextContent>
                            </GridItem>
                            <GridItem span={12}>
                                <TextContent className="ds-margin-top">
                                    <Text>
                                        A class of service definition (CoS) shares attributes between
                                        entries in a way that is transparent to applications.
                                        CoS simplifies entry management and reduces storage requirements.
                                    </Text>
                                    <Text>
                                        Clients of the Directory Server read the attributes in a user's entry.
                                        With CoS, some attribute values may not be stored within the entry itself.
                                        Instead, these attribute values are generated by class of service logic
                                        as the entry is sent to the client application.
                                    </Text>
                                </TextContent>
                            </GridItem>
                        </Grid>
                        <Radio
                          className="ds-margin-top-lg"
                          value="CoSDefinition"
                          isChecked={this.state.getStartedStepRadio === 'CoSDefinition'}
                          onChange={this.handleOnChange}
                          label="Create a new CoS Definition"
                          description="The CoS definition entry identifies the type of CoS used. The CoS definition entry is below the branch at which it is effective."
                          name="radio-new-step-start"
                          id="radio-new-step-start-1"
                        />
                        <Radio
                          className="ds-margin-top-lg"
                          value="CoSTemplate"
                          isChecked={this.state.getStartedStepRadio === 'CoSTemplate'}
                          onChange={this.handleOnChange}
                          label="Create a new CoS Template"
                          description="The CoS template entry contains a list of the shared attribute values. Changes to the template entry attribute values are automatically applied to all the entries within the scope of the CoS."
                          name="radio-new-step-start"
                          id="radio-new-step-start-2"
                        />
                    </div>
                )
            }
        ])
    }

    render () {
        const {
            getStartedStepRadio
        } = this.state;

        const initialStep = this.createInitialLayout();

        const wizardProps = {
            isWizardOpen: this.props.isWizardOpen,
            toggleOpenWizard: this.props.toggleOpenWizard,
            wizardEntryDn: this.props.wizardEntryDn,
            editorLdapServer: this.props.editorLdapServer,
            setWizardOperationInfo: this.props.setWizardOperationInfo,
            firstStep: initialStep,
            onReload: this.props.onReload
        };

        if (getStartedStepRadio === 'CoSDefinition') {
            return <AddCosDefinition
                {...wizardProps}
                allObjectclasses={this.props.allObjectclasses}
                treeViewRootSuffixes={this.props.treeViewRootSuffixes}
                createdTemplateDN=""
                stepReached={1}
                cosDefName=""
                cosDefDesc=""
                cosDefType="pointer"
            />
        } else if (getStartedStepRadio === 'CoSTemplate') {
            return <AddCosTemplate
                {...wizardProps}
                allObjectclasses={this.props.allObjectclasses}
                treeViewRootSuffixes={this.props.treeViewRootSuffixes}
                definitionWizardEntryDn=""
                stepReached={1}
            />
        }
    }
}

export default CoSEntryWizard;
