.\" Man page for manpath
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.TH manpath 1 "Jan 5, 1991"
.LO 1
.SH NAME
manpath \- determine user's search path for man pages
.SH SYNOPSIS
manpath [\-q]
.SH DESCRIPTION
manpath tries to determine the user's manpath from a set of system
defaults and the user's
.B PATH ,
echoing the result to the standard output.  Warnings and errors are
written to the standard error.
If a directory in the user's path is not listed in the manpath.config
file, manpath looks for the subdirectories man or MAN.  If they exist,
they are added to the search path.
.PP
manpath is used by
.B man
to determine the search path, so user's normally don't need to set the
.B MANPATH
environment variable directly.
.SH OPTIONS
.TP
.B \-\^q
Operate quietly.  Only echo the final manpath.
.SH ENVIRONMENT
.TP \w'MANPATH\ \ 'u
.B MANPATH
If
.B MANPATH
is set,
.B manpath
echoes its value on the standard output and issues a warning on the
standard error.
.SH FILES
.TP \w'%manpath_config_file%'u+2n
.BI %manpath_config_file%
System configuration file.
.SH "SEE ALSO"
apropos(1), whatis(1), man(1).
.SH BUGS
None known.
