#!/usr/bin/env perl
#
# Copyright (C) 2002, 2003  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test-date.pl,v 1.7 2003/02/09 21:38:32 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use Data::Dumper;
use Time::HiRes qw (gettimeofday);

use ISC::Date qw(:all);

print "Timezone is " . $ENV{TZ} . "\n" if (defined($ENV{TZ}));

my $start = gettimeofday;
my $t;

print "Now in Unix is $start\n";

my $now_ansi = date_ansi($start);
print "Now in ANSI is $now_ansi\n";

my $now_rrp = date_rrp($start);
print "Now in RRP is $now_rrp\n";

my $now_epp = date_epp($start);
print "Now in EPP is $now_epp\n";

my $now_ts_ansi = from_date_ansi($now_ansi);
my $diff = $start - $now_ts_ansi;
$diff = "< 0" if (abs($diff) < 1.0);
print "Now from ANSI is $now_ts_ansi (difference $diff)\n";

my $now_ts_rrp = from_date_rrp($now_rrp);
$diff = $start - $now_ts_rrp;
$diff = "< 0" if (abs($diff) < 1.0);
print "Now from RRP is $now_ts_rrp (difference $diff)\n";

my $now_ts_epp = from_date_epp($now_epp);
$diff = $start - $now_ts_epp;
$diff = "< 0" if (abs($diff) < 1.0);
print "Now from EPP is $now_ts_epp (difference $diff)\n";

foreach $t ( qw(2002-01-01T11:22:33.0Z 2000-02-29T12:23:34.5Z) ) {
    my $now = from_date_epp($t);
    my $then = date_add($now, 5);
    print "$t +  5 months gives " . date_epp($then) . "\n";

    $then = date_add($now, 12);
    print "$t + 12 months gives " . date_epp($then) . "\n";

    $then = date_add($now, 48);
    print "$t + 48 months gives " . date_epp($then) . "\n";
}

foreach $t (
    "9999-01-02 18:34:15.569504",
    "2010-01-01 00:00:00",
    "2037-01-01 00:00:00" ) {
    my $now = from_date_ansi($t);
    my $then = date_add($now, 5);
    print "$t +  5 months gives " . date_epp($then) . "\n";

    $then = date_add($now, 12);
    print "$t + 12 months gives " . date_epp($then) . "\n";

# this will hang!
#    $then = date_add($now, 48);
#    print "$t + 48 months gives " . date_epp($then) . "\n";
}

print "Timezone is " . $ENV{TZ} . "\n" if (defined($ENV{TZ}));
