#!/bin/sh
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: make-graphs.sh,v 1.8 2002/12/06 21:38:44 lidl Exp $
#
# An initial attempt to produce some graphs of some description
# for web-page beautification purposes.

RRDTOOL=/usr/local/rrdtool/bin/rrdtool
RRD=/var/org/stats
PNG=/rc0/host/httpd/virtual/www.isc.org/htdocs/openreg/graphs

for period in day week month year; do

# whois graphs for each data source
for n in ${RRD}/*:43.rrd; do
  name=`basename ${n}`
  host=`echo ${n} | cut -f2 -d:`
  rrd=`echo ${n} | sed 's/:/\\\\:/g`

  ${RRDTOOL} graph ${PNG}/${name}.queries.${period}.png -a PNG    \
    -s -1${period}                                      \
    -t "WHOIS Query Activity for ${host}"               \
    -v "average query/s"                                \
    DEF:dhit=${rrd}:whois_domain_hits:AVERAGE           \
    DEF:nhit=${rrd}:whois_ns_hits:AVERAGE               \
    DEF:miss=${rrd}:whois_misses:AVERAGE                \
    AREA:miss#ff0000:"Misses"                       \
    STACK:nhit#0000ff:"Hits on nameservers"         \
    STACK:dhit#00ff00:"Hits on domains"             \
      >/dev/null

  ${RRDTOOL} graph ${PNG}/${name}.sessions.${period}.png -a PNG   \
    -s -1${period}                                      \
    -t "WHOIS Active Sessions for ${host}"              \
    -v "sessions"                                       \
    DEF:tcp_avg=${rrd}:whois_tcp:AVERAGE                \
    DEF:tcp_max=${rrd}:whois_tcp:MAX                    \
    LINE2:tcp_avg#ff0000:"Average number of active sessions"   \
    LINE2:tcp_max#00ff00:"Maximum number of active sessions"   \
      >/dev/null

done

# epp graphs for each data source
for n in ${RRD}/*:5544.rrd; do
  name=`basename ${n}`
  host=`echo ${n} | cut -f2 -d:`
  rrd=`echo ${n} | sed 's/:/\\\\:/g`

  ${RRDTOOL} graph ${PNG}/${name}.commands.${period}.png -a PNG   \
    -s -1${period}                                      \
    -t "EPP Activity by Command for ${host}"            \
    -v "command/s"                                      \
    DEF:badcmd=${rrd}:epp_badcmd:AVERAGE                \
    DEF:describe=${rrd}:epp_describe:AVERAGE            \
    DEF:dom_add=${rrd}:epp_dom_add:AVERAGE              \
    DEF:dom_check=${rrd}:epp_dom_check:AVERAGE          \
    DEF:dom_del=${rrd}:epp_dom_del:AVERAGE              \
    DEF:dom_mod=${rrd}:epp_dom_mod:AVERAGE              \
    DEF:dom_renew=${rrd}:epp_dom_renew:AVERAGE          \
    DEF:dom_status=${rrd}:epp_dom_status:AVERAGE        \
    DEF:dom_transfer=${rrd}:epp_dom_transfer:AVERAGE    \
    DEF:ns_add=${rrd}:epp_ns_add:AVERAGE                \
    DEF:ns_check=${rrd}:epp_ns_check:AVERAGE            \
    DEF:ns_del=${rrd}:epp_ns_del:AVERAGE                \
    DEF:ns_mod=${rrd}:epp_ns_mod:AVERAGE                \
    DEF:ns_status=${rrd}:epp_ns_status:AVERAGE          \
    DEF:quit=${rrd}:epp_quit:AVERAGE                    \
    DEF:session=${rrd}:epp_session:AVERAGE              \
    AREA:badcmd#404040:"Invalid Commands"               \
    STACK:describe#404080:"DESCRIBE"                \
    STACK:dom_add#4040ff:"ADD domain"               \
    STACK:dom_check#408040:"CHECK domain"           \
    STACK:dom_del#408080:"DEL domain"               \
    STACK:dom_mod#4080ff:"MOD domain"               \
    STACK:dom_renew#40ff40:"RENEW"                  \
    STACK:dom_status#40ff80:"STATUS domain"         \
    STACK:dom_transfer#40ffff:"TRANSFER"            \
    STACK:ns_add#804040:"ADD nameserver"            \
    STACK:ns_check#804080:"CHECK nameserver"        \
    STACK:ns_del#8040ff:"DEL nameserver"            \
    STACK:ns_mod#808040:"MOD nameserver"            \
    STACK:ns_status#808080:"STATUS nameserver"      \
    STACK:quit#8080ff:"QUIT"                        \
    STACK:session#80ff40:"SESSION"                  \
      >/dev/null

  ${RRDTOOL} graph ${PNG}/${name}.sessions.${period}.png -a PNG   \
    -s -1${period}                                      \
    -t "EPP Active Sessions for ${host}"                \
    -v "sessions"                                       \
    DEF:tcp_avg=${rrd}:epp_tcp:AVERAGE                  \
    DEF:tcp_max=${rrd}:epp_tcp:MAX                      \
    LINE2:tcp_avg#ff0000:"Average number of active sessions"   \
    LINE2:tcp_max#00ff00:"Maximum number of active sessions"   \
      >/dev/null

done

# transaction latency graphs
for n in ${RRD}/*:5544:op.rrd; do
  name=`basename ${n}`
  host=`echo ${n} | cut -f2 -d:`
  rrd=`echo ${n} | sed 's/:/\\\\:/g`

  ${RRDTOOL} graph ${PNG}/${name}.latency.${period}.png -a PNG  \
    -s -1${period}                                        \
    -t "Transaction Completion Times for ${host}"         \
    -v "seconds"                                          \
    DEF:describe=${rrd}:epp_describe:AVERAGE            \
    DEF:dom_add=${rrd}:epp_dom_add:AVERAGE              \
    DEF:dom_check=${rrd}:epp_dom_check:AVERAGE          \
    DEF:dom_del=${rrd}:epp_dom_del:AVERAGE              \
    DEF:dom_mod=${rrd}:epp_dom_mod:AVERAGE              \
    DEF:dom_renew=${rrd}:epp_dom_renew:AVERAGE          \
    DEF:dom_status=${rrd}:epp_dom_status:AVERAGE        \
    DEF:dom_transfer=${rrd}:epp_dom_transfer:AVERAGE    \
    DEF:ns_add=${rrd}:epp_ns_add:AVERAGE                \
    DEF:ns_check=${rrd}:epp_ns_check:AVERAGE            \
    DEF:ns_del=${rrd}:epp_ns_del:AVERAGE                \
    DEF:ns_mod=${rrd}:epp_ns_mod:AVERAGE                \
    DEF:ns_status=${rrd}:epp_ns_status:AVERAGE          \
    DEF:quit=${rrd}:epp_quit:AVERAGE                    \
    DEF:session=${rrd}:epp_session:AVERAGE              \
    CDEF:describe_s=describe,1000000,/                  \
    CDEF:dom_add_s=dom_add,1000000,/                    \
    CDEF:dom_check_s=dom_check,1000000,/                \
    CDEF:dom_del_s=dom_del,1000000,/                    \
    CDEF:dom_mod_s=dom_mod,1000000,/                    \
    CDEF:dom_renew_s=dom_renew,1000000,/                \
    CDEF:dom_status_s=dom_status,1000000,/              \
    CDEF:dom_transfer_s=dom_transfer,1000000,/          \
    CDEF:ns_add_s=ns_add,1000000,/                      \
    CDEF:ns_check_s=ns_check,1000000,/                  \
    CDEF:ns_del_s=ns_del,1000000,/                      \
    CDEF:ns_mod_s=ns_mod,1000000,/                      \
    CDEF:ns_status_s=ns_status,1000000,/                \
    CDEF:quit_s=quit,1000000,/                          \
    CDEF:session_s=session,1000000,/                    \
    LINE1:describe_s#404080:"DESCRIBE"                \
    LINE1:dom_add_s#4040ff:"ADD domain"               \
    LINE1:dom_check_s#408040:"CHECK domain"           \
    LINE1:dom_del_s#408080:"DEL domain"               \
    LINE1:dom_mod_s#4080ff:"MOD domain"               \
    LINE1:dom_renew_s#40ff40:"RENEW"                  \
    LINE1:dom_status_s#40ff80:"STATUS domain"         \
    LINE1:dom_transfer_s#40ffff:"TRANSFER"            \
    LINE1:ns_add_s#804040:"ADD nameserver"            \
    LINE1:ns_check_s#804080:"CHECK nameserver"        \
    LINE1:ns_del_s#8040ff:"DEL nameserver"            \
    LINE1:ns_mod_s#808040:"MOD nameserver"            \
    LINE1:ns_status_s#808080:"STATUS nameserver"      \
    LINE1:quit_s#8080ff:"QUIT"                        \
    LINE1:session_s#80ff40:"SESSION"                  \
        >/dev/null

done

# dns query time graphs
for n in ${RRD}/*:dig.rrd; do
  name=`basename ${n}`
  host=`echo ${name} | cut -f1 -d:`
  rrd=`echo ${n} | sed 's/:/\\\\:/g`

  ${RRDTOOL} graph ${PNG}/${name}.dig.${period}.png -a PNG   \
    -s -1${period}                                 \
    -t "DNS Query Time for ${host}"                \
    -v "seconds"                                   \
    DEF:dig_time_avg=${rrd}:dig_time_ms:AVERAGE    \
    DEF:dig_time_max=${rrd}:dig_time_ms:MAX        \
    CDEF:dig_time_avg_s=dig_time_avg,1000,/        \
    CDEF:dig_time_max_s=dig_time_max,1000,/        \
    LINE2:dig_time_avg_s#ff0000:"Average query time"  \
    LINE2:dig_time_max_s#00ff00:"Maximum query time"  \
      >/dev/null

done

done


