# Copyright (C) 2002, 2003  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: EPPResultCode.pm,v 1.10 2003/02/11 22:17:24 lidl Exp $

package ISC::SRS::EPPResultCode;

use strict;
use warnings;

use ISC::SRS::EPPResultCode ":all";

our %_totext;
our @_langs;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION = do { my @r = (q$Revision: 1.10 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};
    @ISA = qw(Exporter);
    @EXPORT = qw(epp_result_totext epp_languages epp_success);
    @EXPORT_OK = qw(epp_result_totext epp_languages epp_success);
    %EXPORT_TAGS = (all => \@EXPORT_OK);

    my %langhash;

    sub _d {
	my ($numeric, $code, $text) = @_;

	eval "sub ${code}() { $numeric; }";
        foreach my $lang (keys %{$text}) {
	    $_totext{$numeric}->{$lang} = $text->{$lang};
            $langhash{$lang} = 1;
        }
	push(@EXPORT, $code);
	push(@EXPORT_OK, $code);
    }

    _d(1000, "EPP_RS_SUCCESS", {
        "en" => "Command completed successfully",
        "fr" => "la commande terminée avec succès" });

    _d(1001, "EPP_RS_PENDING", {
       "en" => "Command completed successfully; action pending",
       "fr" => "la commande terminée avec succès ; l;'action est en suspens" });

    _d(1300, "EPP_RS_NOMSG", {
       "en" => "Command completed successfully; no messages",
       "fr" => "la commande terminée avec succès ; il n'ya acun message" });

    _d(1301, "EPP_RS_ACK", {
       "en" => "Command completed successfully; ack to dequeue",
       "fr" => "la commande terminé avec succès ; ack à retirer de la file d'attente" });

    _d(1500, "EPP_RS_END", {
       "en" => "Command completed successfully; ending session",
       "fr" => "la commande terminé avec succès ; la session termine" });

    _d(2000, "EPP_RF_UNKCMD", {
        "en" => "Unknown command",
        "fr" => "la commande est inconnue" });

    _d(2001, "EPP_RF_SYNTAX", {
        "en" => "Command syntax error",
        "fr" => "erreur de syntaxe à la commande" });

    _d(2002, "EPP_RF_CMDUSE", {
        "en" => "Command use error",
        "fr" => "erreur d'utilisation à la commande" });

    _d(2003, "EPP_RF_PARAM", {
        "en" => "Required parameter missing",
        "fr" => "paramètre exigé est manquant" });

    _d(2004, "EPP_RF_VALRANGE", {
        "en" => "Parameter value range error",
        "fr" => "la valeur de paramètre est hors d'intervalle" });

    _d(2005, "EPP_RF_VALSYNTAX", {
        "en" => "Parameter value syntax error",
        "fr" => "erreur de syntaxe en valeur de paramètre" });

    _d(2100, "EPP_RF_PROTVERS", {
        "en" => "Unimplemented protocol version",
        "fr" => "la version de protocole n'est pas mise en application" });

    _d(2101, "EPP_RF_UNIMPCMD", {
        "en" => "Unimplemented command",
        "fr" => "la commande n'est pas mise en application" });

    _d(2102, "EPP_RF_UNIMPOPT", {
        "en" => "Unimplemented option",
        "fr" => "l'option n'est pas mise en application" });

    _d(2103, "EPP_RF_UNIMPEXT", {
        "en" => "Unimplemented extension",
        "fr" => "l'extension n'est pas mise en application" });

    _d(2104, "EPP_RF_BILLING", {
        "en" => "Billing failure",
        "fr" => "panne de facturation" });

    _d(2105, "EPP_RF_NORENEW", {
        "en" => "Object is not eligible for renewal",
        "fr" => "l'objet n'est pas habilité au renouvellement" });

    _d(2106, "EPP_RF_NOTRANSFER", {
       "en" => "Object is not eligible for transfer",
       "fr" => "l'objet n'est pas éligible pour être transféré" });

    _d(2200, "EPP_RF_AUTHENTICATION", {
        "en" => "Authentication error",
        "fr" => "erreur d'authentification" });

    _d(2201, "EPP_RF_AUTHORIZATION", {
        "en" => "Authorization error",
        "fr" => "erreur d'autorisation" });

    _d(2202, "EPP_RF_INVAUTHOR", {
        "en" => "Invalid authorization information",
        "fr" => "l'information d'autorisation est incorrecte" });

    _d(2300, "EPP_RF_PENDINGTRANSFER", {
        "en" => "Object pending transfer",
        "fr" => "l'objet est transfert en suspens" });

    _d(2301, "EPP_RF_NOTPENDINGTRANSFER", {
        "en" => "Object not pending transfer",
        "fr" => "l'objet n'est pas transfert en suspens" });

    _d(2302, "EPP_RF_EXISTS", {
        "en" => "Object exists",
        "fr" => "l'objet existe" });

    _d(2303, "EPP_RF_NOTEXISTS", {
        "en" => "Object does not exist",
        "fr" => "l'objet n'existe pas" });

    _d(2304, "EPP_RF_STATUS", {
        "en" => "Object status prohibits operation",
        "fr" => "le statut de l'objet interdit cette exécution" });

    _d(2305, "EPP_RF_INUSE", {
        "en" => "Object association prohibits operation",
        "fr" => "l'assocation de l'objet interdit cette exécution" });

    _d(2306, "EPP_RF_POLICYPARAM", {
        "en" => "Parameter value policy error",
        "fr" => "erreur de politique en valeur du paramètre" });

    _d(2307, "EPP_RF_UNIMPLSERVICE", {
        "en" => "Unimplemented object service",
        "fr" => "le service d'objet n'est pas mis en application" });

    _d(2308, "EPP_RF_DATAMGT", {
        "en" => "Data management policy violation",
        "fr" => "violation de la politique de gestion des données" });

    _d(2400, "EPP_RF_FAIL", {
        "en" => "Command failed",
        "fr" => "la commande a échoué" });

    _d(2500, "EPP_RF_CLOSING", {
        "en" => "Command failed; server closing connection",
        "fr" => "la commande a échoué ; le serveur ferme la connexion" });

    _d(2501, "EPP_RF_AUTHCLOSING", {
        "en" => "Authentiction error; server closing connection",
        "fr" => "erreur d'authentification ; le serveur ferme la connexion" });

    _d(2502, "EPP_RF_SESSIONLIMIT", {
        "en" => "Session limit exceeded; server closing connection",
        "fr" => "la limite de session a été dépassée ; le serveur ferme la connexion" });

    @_langs = keys %langhash;
}

our @EXPORT_OK;

sub epp_result_totext {
    my ($res, $lang) = @_;

    if (defined($lang) && defined($_totext{$res}->{$lang})) {
        return $_totext{$res}->{$lang};
    } else {
        return $_totext{$res}->{"en"};
    }
}

sub epp_languages {
    return @_langs;
}

sub epp_success {
    my ($code) = @_;

    return (($code >= 1000) && ($code < 2000));
}

1;
