#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test-wire.pl,v 1.2 2002/12/06 21:59:08 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use Data::Dumper;
use Time::HiRes qw (gettimeofday);
use ISC::CC::Message;

my $msg = { iter => 0,
	    liter => 0,
	    msg => "msg",
	    body => [ "a", 5, "6" ]
};

my $start = gettimeofday;
my $i;
my $enc;

for ($i = 0 ; $i < 50000 ; $i++) {
    $msg->{iter}++;
    $enc = ISC::CC::Message::towire($msg);
}

my $interval = gettimeofday - $start;
printf("%d towire done in %8.3f seconds (%8.4f/sec)\n",
       $i, $interval, $i / $interval);

print "Size of encoded data: " . length($enc) . " bytes\n";

$start = gettimeofday;

for ($i = 0 ; $i < 50000 ; $i++) {
    $msg = ISC::CC::Message::fromwire($enc);
    $msg->{liter}++;
}

$interval = gettimeofday - $start;
printf("%d fromwire done in %8.3f seconds (%8.4f/sec)\n",
       $i, $interval, $i / $interval);

$start = gettimeofday;

for ($i = 0 ; $i < 50000 ; $i++) {
    $msg->{liter}++;
    $enc = ISC::CC::Message::towire($msg);
    $msg = ISC::CC::Message::fromwire($enc);
}

$interval = gettimeofday - $start;
printf("%d towire/fromwire done in %8.3f seconds (%8.4f/sec)\n",
       $i, $interval, $i / $interval);
