#!/usr/bin/awk -f
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: daily-summary.awk,v 1.4 2002/12/06 21:38:44 lidl Exp $
#
# Generate a summary of a day's data. Pipe a stats file through it.


function min(a, b) {
  if (a == "")
    return (b);
  if (a < b)
    return (a);
  return (b);
}

function max(a, b) {
  if (a == "")
    return (b);
  if (a > b)
    return (a);
  return (b);
}


function record(e, h, l) {
  hr = int(h);
  type[e] = 1;
  events[e, hr]++;
  latency_s[e, hr] += l;
  latency_n[e, hr]++;

  latency_min[e, hr] = min(latency_min[e], l);
  latency_max[e, hr] = max(latency_max[e], l);
  latency_s[e, hr] += l;
  latency_n[e, hr]++;
}

function lat(e, h,   lat) {
  if (latency_n[e, h] > 0)
    return (sprintf("[%2d/%2d/%2d]", latency_min[e, h], \
      latency_s[e, h]/latency_n[e, h], latency_max[e, h]));
  return ("[  /  /  ]");
}

function disp(e, h) {
  return sprintf("%02d:00-%02d:59 %12d   %s  ", \
    h, h, events[e, h], lat(e, h));
}


(banner == 0) {
  f = FILENAME;
  sub(/^.*\//, "", f);
  sub(/\.log$/, "", f);
  print "Summary statistics for log", f;
  print "All times and dates are UTC";
  banner = 1;
}

{
  record($1, $6, $9);
  record("ALL", $6, $9);
}

END {
  for (e in type)
    if (e != "ALL") {
      printf "\nTransaction: %s\n\n", e;

      for (h = 0; h < 12; h++)
        printf " %s %s\n", disp(e, h), disp(e, h+12);
    }

  printf "\nTransaction Summary (All Types)\n\n";
  for (h = 0; h < 12; h++)
    printf " %s %s\n", disp("ALL", h), disp("ALL", h+12);
}

