#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test-epp-writer.pl,v 1.2 2002/12/06 21:59:08 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use ISC::SRS::EPPWriter;


# various contrived tests follow

my $tests = {
    "greeting response" => {
        "command" => "hello" },

    "login response" => {
        "command" => "login" },

    "logout response" => {
        "command" => "logout" },

    "contact:check response, single valid id" => {
        "command" => "contact_check",
        "ids" => [ [ "HANDLE1-ISC", 1, undef ] ] },

    "contact:check response, single invalid id" => {
        "command" => "contact_check",
        "ids" => [ [ "HANDLE1-ISC", 0, undef ] ] },

    "contact:check response, multiple mixed ids" => {
        "command" => "contact_check",
        "ids" => [ [ "HANDLE1-ISC", 1, undef ],
                   [ "HANDLE2-ISC", 0, "unhelpful error message" ] ] },

    "contact:check response, multiple valid ids" => {
        "command" => "contact_check",
        "ids" => [ [ "HANDLE1-ISC", 1, undef ],
                   [ "HANDLE2-ISC", 1, undef ] ] },

    "contact:check response, multiple invalid ids" => {
        "command" => "contact_check",
        "ids" => [ [ "HANDLE1-ISC", 0, "first unhelpful error message" ],
                   [ "HANDLE2-ISC", 0, "second unhelpful error message" ] ] },

    "contact:info response" => {
        "command" => "contact_info",
        "roid" =>    "ROID-OF-DOOM",
        "status" =>  [ "RandomStatus1", "RandomStatus2" ],
        "postal" =>  {
            "loc" => {
                "name"   => "Marmaduke Wildebeeste",
                "org"    => "Ubiquitous Liason, Inc",
                "street" => [ "5 Mouldy Tendrils", "Minor Barking" ],
                "city"   => "Spoon",
                "sp"     => "Mitochondrion",
                "pc"     => "42",
                "cc"     => "AQ" },
            "int" => {
                "name"   => "Mårmaduké Wildebèèste",
                "org"    => "Ubiquitous Liasøn, Inc",
                "street" => [ "5 Mouldy Tendrils", "Minor Barking" ],
                "city"   => "Spoon",
                "sp"     => "Mitochondrion",
                "pc"     => "42",
                "cc"     => "AQ" } },
        "voice"      => "+64 21 625-182",
        "voice_ext"  => "1234",
        "fax"        => "+28 15 261-246",
        "email"      => "spamtrap\@automagic.org",
        "crID"       => "HANDLE1-ISC",
        "crDate"     => "1997-06-30T00:00:00+12:00",
        "upID"       => "HANDLE2-ISC",
        "upDate"     => "1998-06-30T00:00:00+12:00",
        "trDate"     => "1999-06-30T00:00:00+12:00",
        "authInfo"   => {
            type => "pw",
            roid => "haemar",
            _val => "sssshhhh" } } };


foreach my $name (sort keys %{$tests}) {
    $tests->{$name}->{svTRID} = "some-server-id";
    $tests->{$name}->{clTRID} = "some-client-id";
    $tests->{$name}->{resultCode} = "1000";
    print "\n============\n$name\n============\n";
    print epp_writer($tests->{$name}) . "\n";
}

