#!/bin/sh

prefix=/usr/local
# Include utilities. Use installed version if available and
# use build version if it isn't.
if [ -e ${prefix}/share/kea/scripts/admin-utils.sh ]; then
    . ${prefix}/share/kea/scripts/admin-utils.sh
else
    . /home/jenkins/workspace/kea-dev/tarball-internal/kea/src/bin/admin/admin-utils.sh
fi

VERSION=`pgsql_version "$@"`

if [ "$VERSION" != "5.1" ]; then
    printf "This script upgrades 5.1 to 6.0. Reported version is $VERSION. Skipping upgrade.\n"
    exit 0
fi

psql "$@" >/dev/null <<EOF

START TRANSACTION;

-- Create a lower case hostname index for hosts.
CREATE INDEX hosts_by_hostname ON hosts (lower(hostname))
WHERE hostname IS NOT NULL;

-- Create a hostname index for lease4.
CREATE INDEX lease4_by_hostname ON lease4 (lower(hostname))
WHERE hostname IS NOT NULL;

-- Create a hostname index for lease6.
CREATE INDEX lease6_by_hostname ON lease6 (lower(hostname))
WHERE hostname IS NOT NULL;

-- Move to lower case hostnames in lease4 table.
-- Not required so in comment
-- UPDATE lease4 SET hostname = lower(hostname)
-- WHERE lower(hostname) != hostname;

-- Move to lower case hostnames in lease6 table.
-- Not required so in comment
-- UPDATE lease6 SET hostname = lower(hostname)
-- WHERE lower(hostname) != hostname;

-- Set 6.0 schema version.
UPDATE schema_version
    SET version = '6', minor = '0';

-- Schema 5.1a specification ends here.

-- Commit the script transaction
COMMIT;

EOF

exit $RESULT

