//  $Id: roe.cc 1.16 Wed, 03 Mar 1999 17:07:43 -0800 wlee $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>

#include "config.h"
#include <cstdlib>

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif
#include <tcl.h>
#include <tk.h>
}
#include <iostream.h>
#include <cstring>
#include <cctype>

#include "util/net.hh"      // for class ipAddr
#include "util/debug.hh"
#include "util/trace.hh"
#include "util/rusage.hh"
#include "util/version.hh"
#include "util/Argv.hh"
#include "irr/irr.hh"
#include "roe_tcl.hh"
#include "route-list.hh"
#include "roe_config.hh"
// Added by wlee@isi.edu
#include "irr/rawhoisc.hh"
#include "irr/ripewhoisc.hh"
#include "irr/birdwhoisc.hh"
#include "rpsl/rpsl.hh"     // For ASt
#include "rpsl/schema.hh"   // For schema

// Modified by wlee@isi.edu
IRR *whois;
// roe needs another rawhoisd connection
IRR *RLWhois;

bool opt_rusage        = false;
Rusage ru(clog, &opt_rusage);
Configure configure;

char *opt_my_as        = NULL;
char *opt_rcfile       = ".roerc";
char opt_default_rcfile[256] = "";
char *display  = NULL;
char *geometry = NULL;
ASt myAS;


void usage(char *argv[]) {
   cerr << "Usage: " << argv[0] << " to be written later" << endl;
   exit(1);
}

int start_tracing(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      trace.enable(nextArg);
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0; 
}

int start_debugging(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      Debug(dbg.enable(atoi(nextArg)));
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0;
}

void init_and_set_options (int argc, char **argv, char **envp) {
   ArgvInfo argTable[] = {
      // RAToolSet common arguments
      // key, type, src, dst, help
      {"-T", ARGV_FUNC, (char *) &start_tracing,      (char *) NULL, 
       "Start tracing the next argument"},
      {"-D", ARGV_FUNC, (char *) &start_debugging,    (char *) NULL, 
       "Start debugging the next argument"},
      {"-version", ARGV_FUNC, (char *) &version,      (char *) NULL,
       "Show version"},
      {"-rusage", ARGV_BOOL, (char *) NULL,          (char *) &opt_rusage,
       "On termination print resource usage"},

      IRR_COMMAND_LINE_OPTIONS,

      // roe specific arguments
      {"-as",  ARGV_STRING,    (char *) NULL,    (char *) &opt_my_as,
       "AS number of the aut-num object to use."},
      {"-rcfile", ARGV_STRING, (char *)NULL, (char *)&opt_rcfile,
       "roe resource file"},
      {"-display", ARGV_STRING, (char *)NULL, (char *)&display,
       "X display"},
      {"-geometry", ARGV_STRING, (char *)NULL, (char *)&geometry,
       "Geometry for xterm"},

      {(char *) NULL, ARGV_END, (char *) NULL, (char *) NULL, (char *) NULL}
   };

   IRR::handleEnvironmentVariables(envp);

   // Extra env. variable checking other than defaults
   char *p = getenv("HOME");
   if (p) 
     {
     strcpy(opt_default_rcfile, p);
     strcat(opt_default_rcfile, "/.roerc");
     opt_rcfile = opt_default_rcfile;
     }

   if (ParseArgv(&argc, argv, argTable, 0) != ARGV_OK) {
      cerr << endl;
      exit(1);
   }

   // if there are remaining arguments
   // the first one is my as number
   switch (argc) {
   case 2 :
      opt_my_as = argv[1];
      break;
   case 1:
      break;
   default:
      cerr << "Wrong number of arguments..." << endl;
      exit(-1);
   }

  if (! (whois = IRR::newClient())) {
      cerr << "Unknown protocol!" << endl;
      exit(1);
   }

   if (! (RLWhois = IRR::newClient())) {
      cerr << "Unknown protocol!" << endl;
      exit(1);
   }

   if (opt_my_as)
     myAS = atoi(opt_my_as + 2);
   else {
      ipAddr myip;
      myip.setToMyHost();
      if ((myAS = whois->getOrigin("%s/32", myip.getIpaddr())) == 0)
	{
	cerr << "roe could not guess your AS number, "
	        "please specify an AS number on the command line." 
	     << endl;
	delete whois;
	delete RLWhois;
	exit(1);
	}
   }      
}


main (int argc, char **argv, char **envp) {

   schema.initialize();

   init_and_set_options(argc, argv, envp);

   configure.load();

   // Invoke tcl and initialize GUI
   roe_initialize_GUI();

   routelist.load(myAS);
   routelist.display();

   Tk_MainLoop();
   Tcl_DeleteInterp(interp);

   delete whois;
   delete RLWhois;
}
