/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2025 Intel Corporation
 */

#ifndef _XE_EU_STALL_REGS_H_
#define _XE_EU_STALL_REGS_H_

#include "regs/xe_reg_defs.h"

#define XEHPC_EUSTALL_BASE			XE_REG_MCR(0xe520)
#define   XEHPC_EUSTALL_BASE_BUF_ADDR		REG_GENMASK(31, 6)
#define   XEHPC_EUSTALL_BASE_XECORE_BUF_SZ	REG_GENMASK(5, 3)
#define   XEHPC_EUSTALL_BASE_ENABLE_SAMPLING	REG_BIT(1)

#define XEHPC_EUSTALL_BASE_UPPER		XE_REG_MCR(0xe524)

#define XEHPC_EUSTALL_REPORT			XE_REG_MCR(0xe528, XE_REG_OPTION_MASKED)
#define   XEHPC_EUSTALL_REPORT_WRITE_PTR_MASK	REG_GENMASK(15, 2)
#define   XEHPC_EUSTALL_REPORT_OVERFLOW_DROP	REG_BIT(1)

#define XEHPC_EUSTALL_REPORT1			XE_REG_MCR(0xe52c, XE_REG_OPTION_MASKED)
#define   XEHPC_EUSTALL_REPORT1_READ_PTR_MASK	REG_GENMASK(15, 2)

#define XEHPC_EUSTALL_CTRL			XE_REG_MCR(0xe53c, XE_REG_OPTION_MASKED)
#define   EUSTALL_MOCS				REG_GENMASK(9, 3)
#define   EUSTALL_SAMPLE_RATE			REG_GENMASK(2, 0)

#endif
