
#include "stringify.h"
#include "util.h"

struct si_action {
	struct si_cmd	* a_cmd;
	int		a_argc;
	char		** a_argv;
	void		* a_data;

	int	a_show_objs;
	int	a_show_attrs;
	int	a_show_links;
	int	a_header;
	int	a_quiet;
	int	a_delim;

	struct record_col	* a_records;
};


struct si_cmd {
	char	* c_name;
	int	(*c_init)(struct si_action *);
	int	(*c_exec)(struct si_action *);
	void	(*c_exit)(struct si_action *);

	const char	** c_help;
	const char	** c_usage;
};

#define SI_CMD_MAX	32

#define decl_cmd(name)				\
	struct si_cmd name##_cmd = {		\
		.c_name	= __stringify(name),	\
		.c_init = name##_init,		\
		.c_exec	= name##_exec,		\
		.c_exit	= name##_exit,		\
		.c_help	= &name##_help,		\
		.c_usage= &name##_usage,	\
	}


