/******************************************************************************
 *
 * Name:	skdrv2nd.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.6 $
 * Date:	$Date: 2001/10/05 13:41:38 $
 * Purpose:	Second header file for driver and all other modules
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skdrv2nd.h,v $
 *	Revision 1.6  2001/10/05 13:41:38  rschmidt
 *	Moved defines fro Rx Replenish Treshold from HWAC
 *	
 *	Revision 1.5  2001/08/23 08:19:12  mlindner
 *	Send and receive ring structures removed
 *	Physical address of buffer changed
 *	
 *	Revision 1.4  2001/08/14 14:19:21  rschmidt
 *	Renamed Rx and Tx descriptor structures.
 *	New defines for descriptor rings.
 *	Editorial changes.
 *	
 *	Revision 1.3  2001/08/08 13:07:08  rschmidt
 *	Changed DMA descriptors (address field) and moved some register values
 *	into HW-structure.
 *	
 *	Revision 1.2  2001/06/05 15:09:40  rassmann
 *	Kernel 2.4 support.
 *	
 *	Revision 1.1  2001/06/05 08:28:24  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 ******************************************************************************/

#ifndef __INC_SKDRV2ND_H
#define __INC_SKDRV2ND_H

#include "h/sktypes.h"
#include "h/skqueue.h"
#include "h/sktimer.h"
#include "h/skaddr.h"
#include "h/skgihw.h"
#include "h/skgiauto.h"
#include "h/skgipnmi.h"
#include "h/skrlmt.h"


/******************************************************************************
 *
 * Defines
 */
/*
 * ioctl definitions
 */
#define		SK_IOCTL_BASE		(SIOCDEVPRIVATE)
#define		SK_IOCTL_GETMIB		(SK_IOCTL_BASE + 0)
#define		SK_IOCTL_SETMIB		(SK_IOCTL_BASE + 1)
#define		SK_IOCTL_PRESETMIB	(SK_IOCTL_BASE + 2)

#if 0
#define		SK_IOCTL_GETROM		(SK_IOCTL_BASE + 3)
#define		SK_IOCTL_SETROM		(SK_IOCTL_BASE + 4)
#endif	/* 0 */


/****************************************************/
/* Default and max values for "integer" parameters. */
/****************************************************/
#define	RX_COPY_SIZE_DEF			256
#ifdef SK_EXT_MEM
#define	RX_COPY_SIZE_MAX			9036
#else	/* !SK_EXT_MEM */
#define	RX_COPY_SIZE_MAX			768
#endif	/* !SK_EXT_MEM */

#define RX_MIN_PRD_RING_ENTRIES		1024
#define RX_STD_PRD_RING_ENTRIES		 512
#define RX_JMB_PRD_RING_ENTRIES		 256

#define RX_RETURN_RING_ENTRIES		1024
#define TX_RING_ENTRIES				 512

#define RX_MIN_PRD_RING_BUF_SIZE	 256
#define RX_STD_PRD_RING_BUF_SIZE	1536	/* Eth + CRC + VLAN + ... */

#define	DIV_MIN_RX_REPLEN_TRESH		8
#define	DIV_STD_RX_REPLEN_TRESH		8
#define	DIV_JUM_RX_REPLEN_TRESH		8

#define	TASK_OFFLOAD_CAP_NONE		0
#define	TASK_OFFLOAD_CAP_RX			1
#define	TASK_OFFLOAD_CAP_TX			2
#define	TASK_OFFLOAD_CAP_BOTH		3

#define	MBUF_DESC_LOW_DEF			24
#define	MBUF_RX_LOW_DEF				24
#define	MBUF_HIGH_DEF				48

#define	RX_COAL_TICKS_DEF			150
#define	RX_COAL_TICKS_MAX			500
#define	TX_COAL_TICKS_DEF			150
#define	TX_COAL_TICKS_MAX			500
#define	RX_COAL_FRAMES_DEF			10
#define	RX_COAL_FRAMES_MAX			50
#define	TX_COAL_FRAMES_DEF			10
#define	TX_COAL_FRAMES_MAX			50
#define	RX_COAL_TICKS_INT_DEF		0
#define	RX_COAL_TICKS_INT_MAX		500
#define	TX_COAL_TICKS_INT_DEF		0
#define	TX_COAL_TICKS_INT_MAX		500
#define	RX_COAL_FRAMES_INT_DEF		0
#define	RX_COAL_FRAMES_INT_MAX		50
#define	TX_COAL_FRAMES_INT_DEF		0
#define	TX_COAL_FRAMES_INT_MAX		50
#define	STATS_COAL_TICKS_DEF		1000000
#define	STATS_COAL_TICKS_MAX		5000000

#define RUN_AT(x)	(jiffies + (x))


/******************************************************************************
 *
 *	Types
 */
typedef struct s_IOCTL	SK_GI_IOCTL;

struct s_IOCTL {
	char			*pData;
	unsigned int	Len;
};


typedef struct s_SK_RX_PACKET	SK_RX_PACKET, *P_SK_RX_PACKET;

/* Receive Packet Descriptor */
struct s_SK_RX_PACKET {
	P_SK_RX_PACKET	pNext;         /* Pointer to next Rx Packet Descriptor */
	P_RX_DESC		pRbd;			/* Pointer to Rx Buffer Descriptor */
	P_REC_RING		pRecPrdRing;	/* Pointer to producer ring where  */
									/* Rx Packet Desc. is put in */
	struct sk_buff	*pMsg;			/* Pointer to message buffer */
#ifndef SK_KERNEL_22
	SK_PHYS_ADDR	Phys;			/* Physical address of buffer */
#endif	/* !SK_KERNEL_22 */
};

/* Send Packet Descriptor */

struct s_SK_TX_PACKET {
	struct sk_buff	*pMsg;			/* Pointer to message buffer */
#ifndef SK_KERNEL_22
	SK_PHYS_ADDR		Phys;			/* Physical address of buffer */
#endif	/* !SK_KERNEL_22 */
};


typedef P_SK_RX_PACKET	SK_RX_PACKET_QUEUE;

typedef struct net_device_stats NET_STATS;

/****************************************************************************
 * Per-board structure / Adapter Context structure:
 *	Allocated within attach(9e) and freed within detach(9e).
 *	Contains all 'per-device' necessary handles, flags, locks etc.:
 */
struct s_AC  {
	SK_AC				*pNext;			/* Link all devices (for clearing) */
	NET_DEV				*dev;			/* Pointer to device struct */
	SK_IOC				IoBase;			/* Register set of adapter */
	int					Index;			/* Internal board index number */
#ifdef DEBUG
	SK_U32				DbgComp;
	SK_U32				DbgCat;
#endif	/* DEBUG */
	SK_U32				PciDevId;		/* PCI device id */
	struct pci_dev		PciDev;			/* For access to pci config space */
	char				DeviceStr[80];
	char				Name[30];		/* Driver name */
	SK_U32				AllocFlags;

	SK_BOOL				Filler1;
	SK_BOOL				Filler2;
	SK_BOOL				Filler3;

	SK_SPINLOCK			SlowPathLock;

	int					NumRpds;		/* Number of SK_RX_PACKETs to allocate */
	P_SK_RX_PACKET		pRpds;			/* pointer to Rx Packet Descriptors */
	SK_RX_PACKET_QUEUE	RpdQ;
#ifdef SK_EXT_MEM
	REC_RING			RecMinPrdRing;	/* Mini Receive Producer Ring */
#endif	/* SK_EXT_MEM */
	REC_RING			RecStdPrdRing;	/* Standard Receive Producer Ring */
	REC_RING			RecJumPrdRing;	/* Jumbo Receive Producer Ring */
	REC_RING			RecRetRing[SK_NUM_RX_RINGS];
	SND_RING			SndPrdRing[SK_NUM_TX_RINGS];

	STATUS_BLOCK		*pStatusBlock;
	dma_addr_t			StatusBlockPhys;

	PNMI_STAT_BLOCK		*pPnmiStatBlock;
	dma_addr_t			StatisticsPhys;

	NET_STATS			Stats;		/* Linux 'netstat -i' statistics */

	SK_ADDR				Addr;		/* ADDR info */
	SK_GI_CONFIG		Config;		/* Configuration info */
	SK_GI_HW			Hw;			/* HWAC info */
	SK_PNMI				Pnmi;		/* PNMI struct for data counted by macros */
	SK_PNMI_STRUCT_DATA PnmiStruct;	/* Structure to get all PNMI-Data */
	SK_QUEUE			Event;		/* QUEUE info */
	SK_RLMT				Rlmt;		/* RLMT info */
	SK_TIMCTRL			Tim;		/* TIMER info */
	struct timer_list	Timer;

//	SK_TIMER			TestTimer;
};	/* s_AC */


struct s_DrvRlmtMbuf {
	SK_MBUF			*pNext;		/* Pointer to next RLMT Mbuf. */
	SK_U8			*pData;		/* Data buffer (virtually contig.). */
	unsigned		Size;		/* Data buffer size. */
	unsigned		Length;		/* Length of packet (<= Size). */
#ifdef SK_RLMT_MBUF_PRIVATE
	SK_RLMT_MBUF	Rlmt;		/* Private part for RLMT. */
#endif  /* SK_RLMT_MBUF_PRIVATE */
	struct sk_buff	*pOs;		/* Pointer to message block. */
};


/******************************************************************************
 *
 * External functions
 */
extern SK_MBUF	*SkDrvAllocRlmtMbuf(
	SK_AC		*pAC,
	SK_IOC		IoC,
	unsigned	Length);
extern void		SkDrvFreeRlmtMbuf(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_MBUF		*pMb);
#if 0
extern SK_U64	SkOsGetTime(
	SK_AC		*pAC);
#endif	/* 0 */
#ifdef SK_OSTIMER_STOPPABLE
extern void		SkOsTimerStart(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Delta);
extern void		SkOsTimerStop(
	SK_AC		*pAC,
	SK_IOC		IoC);
#endif	/* SK_OSTIMER_STOPPABLE */
extern void		SkOsTimerInit(
	SK_AC		*pAC,
	SK_IOC		IoC);
extern int		SkGiDrvEvent(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Event,
	SK_EVPARA	Para);
#endif /* __INC_SKDRV2ND_H */

