/************************************ */
/* Rule Set Based Access Control      */
/* Author and (c) 1999-2002: Amon Ott */
/* MS decision module:                */
/*  Malware scan strings              */
/* Last modified: 22/Feb/2002         */
/************************************ */

#ifndef __RSBAC_MS_STRINGS_H
#define __RSBAC_MS_STRINGS_H

/* Scanner level, increase for every increase in detected malware */
#define RSBAC_MS_LEVEL 10

#define RSBAC_MS_MAX_STR_LEN 52
#define RSBAC_MS_CHUNK_SIZE (8192 - RSBAC_MS_MAX_STR_LEN)
#define RSBAC_MS_NR_STRINGS 2
/* if NR_MALWARE is changed, adjust IPC default aci in aci_data_structures.h! */
#define RSBAC_MS_NR_MALWARE 8

struct ms_malware_entry_t {
      char name[RSBAC_MS_MAX_STR_LEN];
      char string[RSBAC_MS_NR_STRINGS][RSBAC_MS_MAX_STR_LEN];
  };

typedef struct ms_malware_entry_t rsbac_ms_all_malware_t[RSBAC_MS_NR_MALWARE];

#define RSBAC_MS_ALL_STRINGS { \
     {"Eicar Test", \
      {"6CC)7", \
       "EICAR-STANDARD-ANTIVIRUS-TEST-FILE" \
      } \
     }, \
     {"Bliss.A", \
      {"hnfected by bliss", \
       "replacing ourselves with newer version" \
      } \
     }, \
     {"Bliss.B", \
      {"hnfected by bliss", \
       "newer vers, replacing self (size %d)" \
      } \
     }, \
     {"VHP-648", \
      {"OATH=DANGER!.COM.EM.COM", \
       "DANGER!.COM" \
      } \
     }, \
     {"Israeli", \
      {"rUMsDos", \
       "Hello, world!$" \
      } \
     }, \
     {"Eddie2", \
      {"YY[X", \
       "Eddie lives" \
      } \
     }, \
     {"Dark Avenger", \
      {"romewhere in time!", \
       "city of Sofia (C) 1988-89 Dark Avenger" \
      } \
     }, \
     {"1704C", \
      {"gjhnzji", \
       "ib6tjTp" \
      } \
     } \
  }
#endif
