// **********************************************************************
// * IBMASM HEADER FILE                                                 *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************

#ifndef __Sysapi_H_
#define __Sysapi_H_


#ifndef _OS2_
   #undef APIENTRY
   #define APIENTRY
#endif

extern unsigned int APIENTRY OpenSPDriver(SYS_HANDLE    *Handle,
                                 unsigned int  BfrLgth,
                                 unsigned long Reserved);


extern unsigned int APIENTRY CloseSPDriver(SYS_HANDLE    Handle,
                                  unsigned long Reserved);

extern unsigned int APIENTRY SystemDataIO(SYS_HANDLE    Handle,
                                 void          *CmdBlock,
                                 unsigned long Reserved);

extern unsigned int APIENTRY  RegisterForEvents(SYS_HANDLE    Handle,
                                       void          *CmdBlock,
                                       short int     count,
                                       unsigned char **CmdArray,
                                       unsigned long Reserved);

extern unsigned int APIENTRY DeregisterForEvents(SYS_HANDLE    Handle,
                                        unsigned long Reserved);

extern unsigned int APIENTRY RegisterForReverseHB(SYS_HANDLE    Handle,
                                                  unsigned long Reserved);

extern unsigned int APIENTRY DeRegisterForReverseHB(SYS_HANDLE    Handle,
                                                    unsigned long Reserved);

extern unsigned int APIENTRY DebugCmd(SYS_HANDLE    Handle,
                                      unsigned char SubCommand,
                                      unsigned char *pBuffer);

extern unsigned int APIENTRY AsrCmd(SYS_HANDLE    Handle,
                                    unsigned char SubCommand,
                                    unsigned char *pBuffer);

extern unsigned int APIENTRY OpenSPDriverNode(SYS_HANDLE    *Handle,
                                              unsigned int  BfrLgth,
                                              unsigned int  SPNode,
                                              unsigned int  *pNumPCISPs,
                                              unsigned long Reserved);



//  ***  New APIs for CIM provider ***
//  ***  only available for windows ***

#ifdef _WINDOWS_

//chassis status return values
typedef enum { 
				SP_UNKNOWN_INTRUSION_STATUS	= 0x00,
				SP_NO_INTRUSION	= 0x01,
				SP_INTRUSION_DETECTED = 0x02
			}  SP_INTRUSION_STATUS;

typedef enum {
	     SP_UNKNOWN_INTRUSION = 0x00,
	     SP_CHASSIS_INTRUSION = 0x01,
     }  SP_INTRUSION_TYPE;

typedef enum {
        SP_UNKNOWN_VOLTAGE_STATUS = 0x00,
        SP_VOLTAGE_LOW_CRITICAL = 0x01,
        SP_VOLTAGE_LOW_WARNING = 0x02,
        SP_VOLTAGE_NORMAL = 0x03,
        SP_VOLTAGE_HIGH_WARNING = 0x04,
        SP_VOLTAGE_HIGH_CRITICAL = 0x05,
	}  SP_VOLTAGE_STATUS;

typedef enum {
       SP_UNKNOWN_VOLTAGE = 0x00,
       SP_PLUS_2_5_VOLTS_A = 0x01,
       SP_PLUS_2_5_VOLTS_B = 0x02,
       SP_PLUS_3_3_VOLTS = 0x03,
       SP_PLUS_5_VOLTS = 0x04,
       SP_PLUS_12_VOLTS = 0x05,
       SP_MINUS_12_VOLTS = 0x06,
       SP_MINUS_5_VOLTS = 0x07,
       SP_VIO = 0x08,
       SP_Vcore = 0x09,
       SP_BUS_TERM_VOLTAGE = 0x0A
	} SP_VOLTAGE_TYPE;

typedef enum {
          SP_UNKNOWN_FAN = 0x00,
		  SP_SYSTEM_FAN = 0x01,
		  SP_POWER_SUPPLY_FAN = 0x02,
		  SP_CPU_FAN = 0x03,
	} SP_FAN_TYPE;

typedef enum {
	     SP_SENSOR_LOC_UNKNOWN = 0x00,
	     SP_SENSOR_LOC_MOTHERBOARD = 0x01,
	     SP_SENSOR_LOC_CPU = 0x02
	}  SP_SENSOR_LOCATION;


typedef enum {  //fan status return values
				SP_UNKNOWN_FAN_STATUS = 0x00,
				SP_FAN_NORMAL = 0x01,
				SP_FAN_SLOW_WARNING	= 0x02,
				SP_FAN_SLOW_CRITICAL = 0x03
			} SP_FAN_STATUS;

typedef  enum   {  //temp value constants
                  SP_UNKNOWN_TEMP_STATUS = 0x00,
                  SP_TEMP_NORMAL = 0x01,
                  SP_TEMP_WARNING = 0x02,
                  SP_TEMP_CRITICAL = 0x03
				}  SP_TEMPERATURE_STATUS;


#ifndef ntdcim_
// VOLT
extern int APIENTRY SPGetNumVoltageSensors( );
extern BOOL APIENTRY SPGetVoltageType(int sensor, SP_VOLTAGE_TYPE *type);
extern BOOL APIENTRY SPReadVoltage(int sensor, float *voltage);
extern BOOL APIENTRY SPReadVoltageLimits(int sensor, 
                                         float *lowCritical,
			          							  float *lowWarning,
                                         float *highWarning,
                                         float *highCritical);
extern int APIENTRY SPReadVoltageStatus(int sensor, SP_VOLTAGE_STATUS *status);

// TEMP
extern int APIENTRY SPGetNumSensors();
extern BOOL APIENTRY SPGetSensorLocation(int sensor, SP_SENSOR_LOCATION *loc);
extern BOOL APIENTRY SPReadTemperature(int sensor, int *temperature);
extern BOOL APIENTRY SPReadWarningLimit(int sensor, int *temperature);
extern BOOL APIENTRY SPReadCriticalLimit(int sensor, int *temperature);
extern int APIENTRY SPReadTempStatus(int sensor,SP_TEMPERATURE_STATUS *status);

//  CHASIS
extern int APIENTRY SPGetNumIntrusionSensors();
extern BOOL APIENTRY SPGetIntrusionType(int sensor, SP_INTRUSION_TYPE *type);
extern int APIENTRY SPReadIntrusionStatus(int sensor, SP_INTRUSION_STATUS *status);
extern int APIENTRY SPResetIntrusionStatus(int sensor);

//  FANS
extern int APIENTRY SPGetNumFanSensors();
extern BOOL APIENTRY SPGetFanType(int sensor, SP_FAN_TYPE *type);
extern BOOL APIENTRY SPGetFanNominal(int sensor, int *nominal);
extern int APIENTRY SPReadFanSpeed(int sensor, int *speed);
extern int APIENTRY SPReadFanLimits(int sensor,
                                    int *warning,
                                    int *critical);
extern int APIENTRY SPReadFanStatus(int sensor, SP_FAN_STATUS *status);


// Multi-Node APIs


extern int SPGetNodeCount();

//  VOLTAGE
extern int APIENTRY SPGetNumVoltageSensorsNode(unsigned int SPNode );
extern BOOL  APIENTRY SPGetVoltageTypeNode(unsigned int SPNode, int sensor, SP_VOLTAGE_TYPE *type);
extern BOOL  APIENTRY SPReadVoltageNode(unsigned int SPNode, int sensor, float *voltage);
extern BOOL  APIENTRY SPReadVoltageLimitsNode(unsigned int SPNode, int sensor, 
                                                          float *lowCritical,
											                         float *lowWarning,
                                                          float *highWarning,
                                                          float *highCritical);
extern int APIENTRY SPReadVoltageStatusNode(unsigned int SPNode, int sensor, SP_VOLTAGE_STATUS *status);

//  TEMP 
extern int APIENTRY SPGetNumSensorsNode(unsigned int SPNode);
extern BOOL APIENTRY SPGetSensorLocationNode(unsigned int SPNode, int sensor, SP_SENSOR_LOCATION *loc);
extern BOOL APIENTRY SPReadTemperatureNode(unsigned int SPNode, int sensor, int *temperature);
extern BOOL APIENTRY SPReadWarningLimitNode(unsigned int SPNode, int sensor, int *temperature);
extern BOOL APIENTRY SPReadCriticalLimitNode(unsigned int SPNode, int sensor, int *temperature);
extern int APIENTRY SPReadTempStatusNode(unsigned int SPNode, int sensor,SP_TEMPERATURE_STATUS *status);

//  CHASIS
extern int APIENTRY SPGetNumIntrusionSensorsNode(unsigned int SPNode);
extern BOOL APIENTRY SPGetIntrusionTypeNode(unsigned int SPNode, int sensor, SP_INTRUSION_TYPE *type);
extern int APIENTRY SPReadIntrusionStatusNode(unsigned int SPNode, int sensor, SP_INTRUSION_STATUS *status);
extern int APIENTRY SPResetIntrusionStatusNode(unsigned int SPNode, int sensor);

//  FANS
extern int APIENTRY SPGetNumFanSensorsNode(unsigned int SPNode);
extern BOOL APIENTRY SPGetFanTypeNode(unsigned int SPNode, int sensor, SP_FAN_TYPE *type);
extern BOOL APIENTRY SPGetFanNominalNode(unsigned int SPNode, int sensor, int *nominal);
extern int APIENTRY SPReadFanSpeedNode(unsigned int SPNode, int sensor, int *speed);
extern int APIENTRY SPReadFanLimitsNode(unsigned int SPNode, int sensor,
                                                     int *warning,
                                                     int *critical);
extern int APIENTRY SPReadFanStatusNode(unsigned int SPNode, int sensor, SP_FAN_STATUS *status);


#endif

#endif

#endif

