/***********************************************************************
/ Copyright (c) 2001, Nishan Systems, Inc.
/ All rights reserved.
/ 
/ Redistribution and use in source and binary forms, with or without 
/ modification, are permitted provided that the following conditions are 
/ met:
/ 
/ - Redistributions of source code must retain the above copyright notice, 
/   this list of conditions and the following disclaimer. 
/ 
/ - Redistributions in binary form must reproduce the above copyright 
/   notice, this list of conditions and the following disclaimer in the 
/   documentation and/or other materials provided with the distribution. 
/ 
/ - Neither the name of the Nishan Systems, Inc. nor the names of its 
/   contributors may be used to endorse or promote products derived from 
/   this software without specific prior written permission. 
/ 
/ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
/ AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
/ IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A 
/ PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NISHAN SYSTEMS, INC. 
/ OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
/ EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
/ PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
/ OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
/ WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
/ OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
/ ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
/
/***********************************************************************/
/* This file contains sample code for iSCSI devices                    */

#include "isns.h"
#include "iscsi.h"
#include "comm.h"
#include "util.h"

static ISNS_CMD cmd; /* Used for msgs */
extern int replaceFlag;

/********************************************
This will query for iSCSI Node(s) attributes.
********************************************/
int
GetISCSI (void)
{
   char buffer[8192];
   char cmdLine[256];
   int c_size;
   int key_type;
   int ip;
   int port;

   /* Query for all Node */
   printf ("Query for ISCSI Nodes.\n");
   ISNSCreateHdr (ISNS_DEV_ATTR_QRY_REQ, &cmd, sizeof (cmd), 0);

   /* Append Src field*/
   if (-1 == GetSrc (&cmd, 0))
      return;

   /* Delimiter */
   ISNSAppendAttr (&cmd, 0, 0, NULL, 0);

   /* These are the operational attributes */
   /* These will be returned in a response */

   /* Note order does not matter, but to query for 
      an iSCSI device, put an iSCSI attribute as the
      the first op attr */
   ISNSAppendAttr (&cmd, ISNS_ISCSI_NODE_ID, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_ISCSI_IDX, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_ISCSI_TYPE, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_ISCSI_ALIAS, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_DD_ID, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_ENTITY_ID, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_ENTITY_IDX, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_PROT_VER, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_PORTAL_IDX, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_PORTAL_IP, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_PORTAL_PORT, 0, NULL, 0);
   ISNSAppendAttr (&cmd, ISNS_PG_PORTAL_GROUP, 0, NULL, 0);

   if (0 == ISNSSendCmd2 (&cmd, buffer, sizeof (buffer)))
   {
      /* This will parse the query rsp msg into 
         a human readable format. */
      ParseISCSIQuery (buffer);
   }
}

/***********************************************
This will parse the response msg from an iSCSI
query msg.
***********************************************/
void
ParseISCSIQuery (char *buffer)
{
   ISNS_Attr *p_attr;
   ISNS_HDR *pdu;
   char *ptr;

   pdu = (struct isns_hdr *)buffer;
   ptr = buffer + sizeof (ISNS_HDR) + 4 /* Error Code Length */;

   while (ptr < (char *) buffer + sizeof (ISNS_HDR) + pdu->len)
   {
      p_attr = (struct ISNS_attr *)ptr;
      p_attr->tag = htonl (p_attr->tag);
      p_attr->len = htonl (p_attr->len);
      /*Attributes can come back in any order */
      switch (p_attr->tag)
      {
      case ISNS_ISCSI_NODE_ID:
         printf ("---------------------------------\n");
         printf ("iSCSI ID  : %s\n", &p_attr->val);
         break;
      case ISNS_ISCSI_IDX:
         p_attr->val.etype = ntohl (p_attr->val.etype);
         printf ("iSCSI Index: %d\n", p_attr->val.etype);
         break;
      case ISNS_ISCSI_TYPE:
         p_attr->val.etype = ntohl (p_attr->val.etype);
         printf ("Type: %#x (", p_attr->val.etype);
         if (p_attr->val.etype & 1)
            printf ("Target ");
         if (p_attr->val.etype & 2)
            printf ("Initiator");
         printf (")\n");
         break;
      case ISNS_ISCSI_ALIAS:
         printf ("Alias      : %s\n", &p_attr->val);
         break;
      case ISNS_DD_ID:
         p_attr->val.etype = ntohl (p_attr->val.etype);
         printf ("DD ID      : %d\n", p_attr->val.etype);
         break;
      case ISNS_ENTITY_ID:
         printf ("Entity ID  : %s\n", &p_attr->val);
         break;
      case ISNS_ENTITY_IDX:
         p_attr->val.etype = ntohl (p_attr->val.etype);
         printf ("Entity Idx : %d\n", p_attr->val.etype);
         break;
      case ISNS_PORTAL_IP:
         {
            struct in_addr ip;
            ip.s_addr = *(uint32_t *) ((char *) &p_attr->val + 12);
            printf ("Portal IP     : %s\n", inet_ntoa (ip));
         }
         break;
      case ISNS_PORTAL_PORT:
         p_attr->val.etype = ntohl (p_attr->val.etype);
         printf ("Portal Port    : %d\n", p_attr->val.etype & 0xFFFF);
         printf ("Portal Type    : %s\n",
                 p_attr->val.etype & 0x10000 ? "UDP" : "TCP");
         break;
      case ISNS_PG_PORTAL_GROUP:
	 p_attr->val.etype = ntohl (p_attr->val.etype);
	 printf("Portal Group Tag: %d\n", p_attr->val.etype & 0xFFFF);
	 break;
      case ISNS_PORTAL_IDX:
         p_attr->val.etype = ntohl (p_attr->val.etype);
         printf ("Portal Idx : %d\n", p_attr->val.etype);
         break;
      case ISNS_PROT_VER:
         p_attr->val.ver.max = ntohs (p_attr->val.ver.max);
         p_attr->val.ver.min = ntohs (p_attr->val.ver.min);
         printf ("Version: Max=%d, Min=%d\n", p_attr->val.ver.max,
                 p_attr->val.ver.min);
         break;
      default:
         break;
      }
      ptr = (char *) ptr + p_attr->len + 8/* Size of tag and length fields*/;
   }
}
