###
### -- PYX - CONFIDENTIAL --
###
### Copyright (c) 2005 PyX Technologies, Inc.
###

### To build utils:
###
### From driver source root execute make tarball
### redhat:   copy isnsclient.spec file to /usr/src/redhat/SPECS
### suse:     copy isnsclient.spec file to /usr/src/packages/SPECS
### mandrake: copy isnsclient.spec file to /usr/src/RPMS/SPECS
###
### Repeat the process for isnsclient.tar.bz2 to the respective
### "SOURCES" directory.
###

%define redhat 1
%define suse 0
%define mandrake 0
%define debian 0
%define centos 0
%define fedora 0

%define pyx 1
%define lsi 0

# allow --with[out] <feature|release> at rpm command line build
# e.g. --with pyx --without lsi
# --with overrides --without

%{?_without_redhat: %{expand: %%define redhat 0}}
%{?_without_suse: %{expand: %%define suse 0}}
%{?_without_mandrake: %{expand: %%define mandrake 0}}
%{?_without_debian: %{expand: %%define debian 0}}
%{?_without_centos: %{expand: %%define centos 0}}
%{?_without_fedora: %{expand: %%define fedora 0}}
%{?_with_redhat: %{expand: %%define redhat 1}}
%{?_with_redhat: %{expand: %%define suse 0}}
%{?_with_redhat: %{expand: %%define mandrake 0}}
%{?_with_redhat: %{expand: %%define debian 0}}
%{?_with_redhat: %{expand: %%define centos 0}}
%{?_with_redhat: %{expand: %%define fedora 0}}
%{?_with_redhat: %{expand: %%define redhatbase 1}}
%{?_with_suse: %{expand: %%define redhat 0}}
%{?_with_suse: %{expand: %%define suse 1}}
%{?_with_suse: %{expand: %%define mandrake 0}}
%{?_with_suse: %{expand: %%define debian 0}}
%{?_with_suse: %{expand: %%define centos 0}}
%{?_with_suse: %{expand: %%define fedora 0}}
%{?_with_suse: %{expand: %%define redhatbase 0}}
%{?_with_mandrake: %{expand: %%define redhat 0}}
%{?_with_mandrake: %{expand: %%define suse 0}}
%{?_with_mandrake: %{expand: %%define mandrake 1}}
%{?_with_mandrake: %{expand: %%define debian 0}}
%{?_with_mandrake: %{expand: %%define centos 0}}
%{?_with_mandrake: %{expand: %%define fedora 0}}
%{?_with_mandrake: %{expand: %%define redhatbase 1}}
%{?_with_debian: %{expand: %%define redhat 0}}
%{?_with_debian: %{expand: %%define suse 0}}
%{?_with_debian: %{expand: %%define mandrake 0}}
%{?_with_debian: %{expand: %%define debian 1}}
%{?_with_debian: %{expand: %%define centos 0}}
%{?_with_debian: %{expand: %%define fedora 0}}
%{?_with_debian: %{expand: %%define redhatbase 0}}
%{?_with_centos: %{expand: %%define redhat 0}}
%{?_with_centos: %{expand: %%define suse 0}}
%{?_with_centos: %{expand: %%define mandrake 0}}
%{?_with_centos: %{expand: %%define debian 0}}
%{?_with_centos: %{expand: %%define centos 1}}
%{?_with_centos: %{expand: %%define fedora 0}}
%{?_with_centos: %{expand: %%define redhatbase 1}}
%{?_with_fedora: %{expand: %%define redhat 0}}
%{?_with_fedora: %{expand: %%define suse 0}}
%{?_with_fedora: %{expand: %%define mandrake 0}}
%{?_with_fedora: %{expand: %%define debian 0}}
%{?_with_fedora: %{expand: %%define centos 0}}
%{?_with_fedora: %{expand: %%define fedora 1}}
%{?_with_fedora: %{expand: %%define redhatbase 1}}

%{?_without_pyx: %{expand: %%define pyx 0}}
%{?_without_lsi: %{expand: %%define lsi 0}}
%{?_without_lsi: %{expand: %%define pyx 1}}
%{?_without_pyx: %{expand: %%define lsi 1}}
%{?_with_pyx: %{expand: %%define pyx  1}}
%{?_with_pyx: %{expand: %%define lsi 0}}
%{?_with_lsi: %{expand: %%define lsi 1}}
%{?_with_lsi: %{expand: %%define pyx 0}}

%define buildsysvinit 0
%define buildtarget 1
%define buildinitiator 1

%if %{pyx}
%define product_name PyX Technologies
%define vendor_flag pyx
%endif ### pyx
%if %{lsi}
%define product_name LSI Logic
%define vendor_flag lsi
%endif ### lsi

Summary: %{product_name} iSNS Client Toolkit for iSCSI
Name: isnsclient
Version: %{isns_version}
Release: 1
License: %{product_name}, Commerial
Group: Applications/System
Source: %{name}-v%{version}.tar.bz2
Vendor: %{product_name}
%if %{fedora}
Distribution: Fedora Core
%define redhatbase 1
%endif ### fedora
%if %{centos}
Distribution: CentOS
%define redhatbase 1
%endif ### centos
%if %{debian}
Distribution: Debian
%endif ### debian
%if %{mandrake}
Distribution: Mandrake
%define redhatbase 1
%endif ### mandrake
%if %{suse}
Distribution: SuSE
%endif ### suse
%if %{redhat}
Distribution: RedHat
%define redhatbase 1
%endif ### redhat

%if %{pyx}
Packager: Andre Hedrick <andreh@sbei.com>
%endif ### pyx

Summary: %{product_name} iSNS Client Toolkit for iSCSI

Buildroot: %{_tmppath}/%{name}-%{version}-root
%if %{redhatbase}
Prereq: /sbin/chkconfig /etc/init.d
ExcludeArch: ccris
%endif ### redhatbase

###
### Packages
###

%if %{buildinitiator}
%package -n %{name}-initiator
Group: Applications/System
Summary: %{product_name} iSNS Client Toolkit for iSCSI Initiator
Provides: %{name}-initiator = %{version}
Conflicts: %{name}-target
%endif ### buildinitiator

%if %{buildtarget}
%package -n %{name}-target
Group: Applications/System
Summary: %{product_name} iSNS Client Toolkit for iSCSI Target
Provides: %{name}-target = %{version}
Conflicts: %{name}-initiator
%endif ### buildtarget

###
### Descriptions
###

%description -n %{name}
%{product_name} iSNS Client Toolkit for iSCSI

%if %{buildinitiator}
%description -n %{name}-initiator
%{product_name} iSNS Client Toolkit for iSCSI Initiator
%endif ### buildinitiator

%if %{buildtarget}
%description -n %{name}-target
%{product_name} iSNS Client Toolkit for iSCSI Target
%endif ### buildtarget

%prep
%setup -q

%build
%if %{fedora}
perl -pi -e "-s,-O2,-g" Makefile
%else
perl -pi -e "s,-O2,$RPM_OPT_FLAGS,g" Makefile
%endif
make VENDOR=%{vendor_flag}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/var/spool/isns

%if %{buildsysvinit}
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc{0,1,2,3,4,5,6}.d
%if %{redhatbase}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
%endif ### redhatbase
%endif ### buildsysvinit

install -c -s -m 755 isnsc $RPM_BUILD_ROOT/sbin/isnsc
install -c -m 755 scripts/isns_register $RPM_BUILD_ROOT/sbin/isns_register
install -c -m 755 scripts/isns_deregister $RPM_BUILD_ROOT/sbin/isns_deregister
install -c -m 755 scripts/isns_reregister $RPM_BUILD_ROOT/sbin/isns_reregister
install -c -m 755 scripts/isns_iscsi_index $RPM_BUILD_ROOT/sbin/isns_iscsi_index
install -c -m 755 scripts/isns_nodes $RPM_BUILD_ROOT/sbin/isns_nodes
install -c -m 755 scripts/isns_network_portals $RPM_BUILD_ROOT/sbin/isns_network_portals
install -c -m 755 scripts/isns_update_portals $RPM_BUILD_ROOT/sbin/isns_update_portals

%if %{buildinitiator}
install -c -m 755 scripts/isns_initiators $RPM_BUILD_ROOT/sbin/isns_initiators
install -c -m 755 scripts/isns_register_initiator $RPM_BUILD_ROOT/sbin/isns_register_initiator
install -c -m 755 scripts/isns_deregister_initiator $RPM_BUILD_ROOT/sbin/isns_deregister_initiator
install -c -m 755 scripts/isns_initiator_node_status $RPM_BUILD_ROOT/sbin/isns_initiator_node_status
%endif ### buildinitiator

%if %{buildtarget}
install -c -m 755 scripts/isns_register_target $RPM_BUILD_ROOT/sbin/isns_register_target
install -c -m 755 scripts/isns_deregister_target $RPM_BUILD_ROOT/sbin/isns_deregister_target
install -c -m 755 scripts/isns_target_node_status $RPM_BUILD_ROOT/sbin/isns_target_node_status
install -c -m 755 scripts/isns_create_dd $RPM_BUILD_ROOT/sbin/isns_create_dd
install -c -m 755 scripts/isns_delete_dd $RPM_BUILD_ROOT/sbin/isns_delete_dd
install -c -m 755 scripts/isns_add_node_to_dd $RPM_BUILD_ROOT/sbin/isns_add_node_to_dd
install -c -m 755 scripts/isns_remove_node_from_dd $RPM_BUILD_ROOT/sbin/isns_remove_node_from_dd
install -c -m 755 scripts/isns_list_dd_all $RPM_BUILD_ROOT/sbin/isns_list_dd_all
install -c -m 755 scripts/isns_list_dd_members $RPM_BUILD_ROOT/sbin/isns_list_dd_members
install -c -m 755 scripts/isns_create_dds $RPM_BUILD_ROOT/sbin/isns_create_dds
install -c -m 755 scripts/isns_delete_dds $RPM_BUILD_ROOT/sbin/isns_delete_dds
install -c -m 755 scripts/isns_enable_dds $RPM_BUILD_ROOT/sbin/isns_enable_dds
install -c -m 755 scripts/isns_disable_dds $RPM_BUILD_ROOT/sbin/isns_disable_dds
install -c -m 755 scripts/isns_add_dd_to_dds $RPM_BUILD_ROOT/sbin/isns_add_dd_to_dds
install -c -m 755 scripts/isns_remove_dd_from_dds $RPM_BUILD_ROOT/sbin/isns_remove_dd_from_dds
install -c -m 755 scripts/isns_list_dds_all $RPM_BUILD_ROOT/sbin/isns_list_dds_all
install -c -m 755 scripts/isns_list_dds_members $RPM_BUILD_ROOT/sbin/isns_list_dds_members
install -c -m 755 scripts/isns_is_control_node $RPM_BUILD_ROOT/sbin/isns_is_control_node
install -c -m 755 scripts/isns_is_node_registered $RPM_BUILD_ROOT/sbin/isns_is_node_registered
install -c -m 755 scripts/isns_list_node_detail $RPM_BUILD_ROOT/sbin/isns_list_node_detail
install -c -m 755 scripts/isns_list_nodes_all $RPM_BUILD_ROOT/sbin/isns_list_nodes_all
install -c -m 755 scripts/isns_save_config $RPM_BUILD_ROOT/sbin/isns_save_config
%endif ### buildtarget

%if %{buildsysvinit}
%if %{debian}
%if %{buildinitiator}
install -c -m 755 sysvinit/debian.initiator_isns $RPM_BUILD_ROOT/etc/rc.d/initiator_isns
%endif ### buildinitiator
%if %{buildtarget}
install -c -m 755 sysvinit/debian.target_isns $RPM_BUILD_ROOT/etc/rc.d/target_isns
%endif ### buildtarget
%endif ### debian

%if %{mandrake}
%if %{buildinitiator}
install -c -m 755 sysvinit/mandrake.initiator_isns $RPM_BUILD_ROOT/etc/rc.d/initiator_isns
%endif ### buildinitiator
%if %{buildtarget}
install -c -m 755 sysvinit/mandrake.target_isns $RPM_BUILD_ROOT/etc/rc.d/target_isns
%endif ### buildtarget
%endif ### mandrake

%if %{suse}
%if %{buildinitiator}
install -c -m 755 sysvinit/suse.initiator_isns $RPM_BUILD_ROOT/etc/rc.d/initiator_isns
%endif ### buildinitiator
%if %{buildtarget}
install -c -m 755 sysvinit/suse.target_isns $RPM_BUILD_ROOT/etc/rc.d/target_isns
%endif ### buildtarget
%endif ### suse

%if %{redhatbase}
%if %{buildinitiator}
install -c -m 755 sysvinit/redhat.initiator_isns $RPM_BUILD_ROOT/etc/rc.d/init.d/initiator_isns
%endif ### buildinitiator
%if %{buildtarget}
install -c -m 755 sysvinit/redhat.target_isns $RPM_BUILD_ROOT/etc/rc.d/init.d/target_isns
%endif ### buildtarget
%endif ### redhatbase

%if %{buildinitiator}
%post -n %{name}-initiator
# /etc/sysconfig/initiator_isns.rpmsave
if [ -f /etc/sysconfig/initiator_isns.rpmsave ]; then
	echo "Restoring previous /etc/sysconfig/initiator_isns settings"
	mv /etc/sysconfig/initiator_isns /etc/sysconfig/initiator_isns.rpmnew
	mv /etc/sysconfig/initiator_isns.rpmsave /etc/sysconfig/initiator_isns
fi
%if %{redhatbase}
chkconfig --add initiator_isns
chkconfig initiator_isns on
%endif ### redhatbase
%if %{suse}
insserv initiator_isns
%endif ### suse
%endif ### buildinitiator

%if %{buildtarget}
%post -n %{name}-target
# /etc/sysconfig/target_isns.rpmsave
if [ -f /etc/sysconfig/target_isns.rpmsave ]; then
	echo "Restoring previous /etc/sysconfig/target_isns settings"
	mv /etc/sysconfig/target_isns /etc/sysconfig/target_isns.rpmnew
	mv /etc/sysconfig/target_isns.rpmsave /etc/sysconfig/target_isns
fi
%if %{redhatbase}
chkconfig --add target_isns
chkconfig target_isns on
%endif ### redhatbase
%if %{suse}
insserv target_isns
%endif ### suse
%endif ### buildtarget

%if %{buildinitiator}
%preun -n %{name}-initiator
%if %{redhatbase}
chkconfig initiator_isns off
chkconfig --del initiator_isns
%endif ### redhatbase
%if %{suse}
insserv -r initiator_isns
%endif ### suse
%endif ### buildinitiator

%if %{buildtarget}
%preun -n %{name}-target
%if %{redhatbase}
chkconfig target_isns off
chkconfig --del target_isns
%endif ### redhatbase
%if %{suse}
insserv -r target_isns
%endif ### suse
%endif ### buildtarget
%endif ### buildsysvinit

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}

###
### file lists
###

%if %{buildinitiator}
%files -n %{name}-initiator
%defattr(-,root,root)
%dir /sbin
%dir /var/spool/isns
%if %{buildsysvinit}
%dir /etc/sysconfig
%dir /etc/rc.d
%if %{redhatbase}
%dir /etc/rc.d/init.d
%endif ### redhatbase
%config(noreplace) /etc/sysconfig/initiator_isns
%if %{suse}
/etc/rc.d/initiator_isns
%endif ### suse
%if %{redhatbase}
/etc/rc.d/init.d/initiator_isns
%endif ### redhatbase
%endif ### buildsysvinit

/sbin/isnsc
### Common Callers
/sbin/isns_register
/sbin/isns_deregister
/sbin/isns_reregister
/sbin/isns_iscsi_index
/sbin/isns_nodes
/sbin/isns_network_portals
/sbin/isns_update_portals

/sbin/isns_initiators
/sbin/isns_register_initiator
/sbin/isns_deregister_initiator
/sbin/isns_initiator_node_status

%if %{buildtarget}
/sbin/isns_register_target
/sbin/isns_deregister_target
/sbin/isns_target_node_status
/sbin/isns_create_dd
/sbin/isns_delete_dd
/sbin/isns_add_node_to_dd
/sbin/isns_remove_node_from_dd
/sbin/isns_list_dd_all
/sbin/isns_list_dd_members
/sbin/isns_create_dds
/sbin/isns_delete_dds
/sbin/isns_enable_dds
/sbin/isns_disable_dds
/sbin/isns_add_dd_to_dds
/sbin/isns_remove_dd_from_dds
/sbin/isns_list_dds_all
/sbin/isns_list_dds_members
/sbin/isns_is_control_node
/sbin/isns_is_node_registered
/sbin/isns_list_node_detail
/sbin/isns_list_nodes_all
/sbin/isns_save_config
%endif ### buildtarget

%endif ### buildinitiator

%if %{buildtarget}
%files -n %{name}-target
%defattr(-,root,root)
%dir /sbin
%dir /var/spool/isns
%if %{buildsysvinit}
%dir /etc/sysconfig
%dir /etc/rc.d
%if %{redhatbase}
%dir /etc/rc.d/init.d
%endif ### redhatbase
%config(noreplace) /etc/sysconfig/target_isns
%if %{suse}
/etc/rc.d/target_isns
%endif ### suse
%if %{redhatbase}
/etc/rc.d/init.d/target_isns
%endif ### redhatbase
%endif ### buildsysvinit

/sbin/isnsc
### Common Callers
/sbin/isns_register
/sbin/isns_deregister
/sbin/isns_reregister
/sbin/isns_iscsi_index
/sbin/isns_nodes
/sbin/isns_network_portals
/sbin/isns_update_portals

/sbin/isns_register_target
/sbin/isns_deregister_target
/sbin/isns_target_node_status

/sbin/isns_create_dd
/sbin/isns_delete_dd
/sbin/isns_add_node_to_dd
/sbin/isns_remove_node_from_dd
/sbin/isns_list_dd_all
/sbin/isns_list_dd_members
/sbin/isns_create_dds
/sbin/isns_delete_dds
/sbin/isns_enable_dds
/sbin/isns_disable_dds
/sbin/isns_add_dd_to_dds
/sbin/isns_remove_dd_from_dds
/sbin/isns_list_dds_all
/sbin/isns_list_dds_members
/sbin/isns_is_control_node
/sbin/isns_is_node_registered
/sbin/isns_list_node_detail
/sbin/isns_list_nodes_all
/sbin/isns_save_config

%if %{buildinitiator}
/sbin/isns_initiators
/sbin/isns_register_initiator
/sbin/isns_deregister_initiator
/sbin/isns_initiator_node_status
%endif ### initiator

%endif ### buildtarget

%changelog

