/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class SuperShapeGenerator
extends GeometryGenerator {
    private static final int DEFAULT_FACETS = 50;
    private int facetCount;
    private float[] curveCoordinates;
    private int numCurveValues;
    private boolean curveChanged;
    private double m;
    private double n1;
    private double n2;
    private double n3;
    private double one_on_a;
    private double one_on_b;
    private double maxAngle;

    public SuperShapeGenerator() {
        this(50);
    }

    public SuperShapeGenerator(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.curveChanged = true;
        this.facetCount = n;
        this.numCurveValues = 0;
        this.one_on_a = 1.0;
        this.one_on_b = 1.0;
        this.m = 1.0;
        this.n1 = 1.0;
        this.n2 = 1.0;
        this.n3 = 1.0;
        this.maxAngle = Math.PI * 2;
        this.curveCoordinates = new float[(n + 1) * 3];
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (this.facetCount != n) {
            this.curveChanged = true;
        }
        this.facetCount = n;
    }

    public void setCoefficients(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d5 == 0.0) {
            throw new IllegalArgumentException("a is zero");
        }
        if (d6 == 0.0) {
            throw new IllegalArgumentException("b is zero");
        }
        this.m = d;
        this.n1 = d2;
        this.n2 = d3;
        this.n3 = d4;
        this.one_on_a = 1.0 / d5;
        this.one_on_b = 1.0 / d6;
    }

    public void setMaxAngle(double d) {
        this.maxAngle = d;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 9: {
                n = (this.facetCount + 1) * 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n = this.facetCount + 1;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 9: {
                this.unindexedLines(geometryData);
                break;
            }
            case 10: {
                this.lineStrips(geometryData);
                break;
            }
            case 11: {
                this.indexedLines(geometryData);
                break;
            }
            case 12: {
                this.indexedLineStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedLines(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
    }

    private void indexedLines(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Index values", geometryData.coordinates.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3++] = n2++;
            nArray[n3++] = n2;
        }
    }

    private void lineStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[1];
        } else if (geometryData.stripCounts.length < 1) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 1);
        }
        geometryData.numStrips = 1;
        geometryData.stripCounts[0] = this.facetCount + 1;
    }

    private void indexedLineStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Index values", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3++] = n2++;
            nArray[n3++] = n2;
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[1];
        } else if (geometryData.stripCounts.length < 1) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 1);
        }
        geometryData.numStrips = 1;
        geometryData.stripCounts[0] = this.facetCount + 1;
    }

    private void generateUnindexedLineCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateCurve();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.facetCount; ++i) {
            fArray[n2] = this.curveCoordinates[n3];
            fArray[++n2] = this.curveCoordinates[n3 + 1];
            fArray[++n2] = this.curveCoordinates[n3 + 2];
            fArray[++n2] = this.curveCoordinates[n3 + 3];
            fArray[++n2] = this.curveCoordinates[n3 + 4];
            fArray[++n2] = this.curveCoordinates[n3 + 5];
            ++n2;
            n3 += 3;
        }
    }

    private void generateIndexedLineCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateCurve();
        System.arraycopy(this.curveCoordinates, 0, fArray, 0, this.numCurveValues);
    }

    private void generateUnindexedLineNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateIndexedLineNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateLineTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateLineTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regenerateCurve() {
        if (!this.curveChanged) {
            return;
        }
        this.curveChanged = false;
        this.numCurveValues = (this.facetCount + 1) * 3;
        if (this.curveCoordinates == null || this.numCurveValues > this.curveCoordinates.length) {
            this.curveCoordinates = new float[this.numCurveValues];
        }
        double d = this.maxAngle / (double)(this.facetCount + 1);
        int n = 0;
        for (int i = 0; i < this.facetCount; ++i) {
            this.calculatePoint(d * (double)i, n);
            n += 3;
        }
        this.curveCoordinates[n++] = this.curveCoordinates[0];
        this.curveCoordinates[n++] = this.curveCoordinates[1];
    }

    private void calculatePoint(double d, int n) {
        double d2 = Math.cos(this.m * d / 4.0) * this.one_on_a;
        d2 = Math.abs(d2);
        d2 = Math.pow(d2, this.n2);
        double d3 = Math.sin(this.m * d / 4.0) * this.one_on_b;
        d3 = Math.abs(d3);
        double d4 = Math.pow(d2 + (d3 = Math.pow(d3, this.n3)), 1.0 / this.n1);
        if (Math.abs(d4) == 0.0) {
            this.curveCoordinates[n] = 0.0f;
            this.curveCoordinates[n + 1] = 0.0f;
        } else {
            d4 = 1.0 / d4;
            this.curveCoordinates[n] = (float)(d4 * Math.cos(d));
            this.curveCoordinates[n + 1] = (float)(d4 * Math.sin(d));
        }
    }
}

