/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.scripting;

import java.util.ArrayList;
import java.util.List;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.nodes.AbstractDynamicFieldNode;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.util.URLChecker;

public abstract class BaseScript
extends AbstractDynamicFieldNode
implements VRMLScriptNodeType {
    private static final Integer ZERO_SIZE;
    private static final Integer SINGLE_SIZE;
    private static final String VRML97_FIELD_MSG = "Field type not supported in VRML97: ";
    private static final String VRML97_EXPOSED_MSG = "VRML97 Does not allow script fields to be declared as exposedField";
    private static final String[] VRML97_MIME_TYPES;
    private static final String[] X3D_MIME_TYPES;
    private static final int[] SECONDARY_TYPE;
    private static final HashSet validVrml97Types;
    private static final HashSet validX3DTypes;
    private static final HashSet forbiddenFields;
    private final int FIELD_METADATA;
    private final int FIELD_URL;
    private final int FIELD_MUST_EVALUATE;
    private final int FIELD_DIRECT_OUTPUT;
    private final int LAST_FIXED_INDEX;
    private IntHashMap fieldValueMap;
    private IntHashMap fieldSizeMap;
    private IntHashMap fieldChangedMap;
    private IntHashMap userData;
    private String worldURL;
    private int loadState;
    private boolean isDEF = false;
    private boolean isStatic;
    private boolean eventOutProcessingInProgress;
    protected int majorVersion;
    protected int minorVersion;
    private boolean[] hasChanged;
    private double[] lastChangedTime;
    private String[] vfUrl;
    private boolean vfMustEvaluate;
    private boolean vfDirectOutput;
    private ScriptWrapper realScript;
    private VRMLExecutionSpace execSpace;
    private ArrayList urlListeners;
    private ArrayList contentListeners;

    protected BaseScript() {
        super("Script");
        this.inSetup = true;
        this.vfMustEvaluate = false;
        this.vfDirectOutput = false;
        this.urlListeners = new ArrayList(1);
        this.contentListeners = new ArrayList(1);
        this.fieldSizeMap = new IntHashMap();
        this.fieldValueMap = new IntHashMap();
        this.fieldChangedMap = new IntHashMap();
        this.userData = new IntHashMap();
        int n = 0;
        this.loadState = 1;
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.FIELD_METADATA = n;
        vRMLFieldDeclaration = new VRMLFieldDeclaration(3, "MFString", "url");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.FIELD_URL = n;
        vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "SFBool", "mustEvaluate");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.FIELD_MUST_EVALUATE = n;
        vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "SFBool", "directOutput");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.LAST_FIXED_INDEX = this.FIELD_DIRECT_OUTPUT = n;
        this.fieldChangedMap = new IntHashMap();
        this.hasChanged = new boolean[this.LAST_FIXED_INDEX + 1];
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
        this.eventOutProcessingInProgress = false;
    }

    protected BaseScript(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((BaseScript)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("url");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("mustEvaluate");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMustEvaluate = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("directOutput");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirectOutput = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        System.out.println("Script needs to handle notifyExternProtoLoaded");
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfUrl = this.worldURL != null ? URLChecker.checkURLs(this.worldURL, stringArray, false) : stringArray;
        this.hasChanged[this.FIELD_URL] = true;
        this.fireFieldChanged(this.FIELD_URL);
        this.fireUrlChanged();
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        this.loadState = n;
        this.fireContentStateChanged();
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            URLChecker.checkURLsInPlace(this.worldURL, this.vfUrl, false);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        if (!(object instanceof ScriptWrapper)) {
            throw new IllegalArgumentException("Not a script wrapper");
        }
        this.realScript = (ScriptWrapper)object;
    }

    public void setLoadedURI(String string) {
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public void setExecutionSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        this.execSpace = vRMLExecutionSpace;
    }

    public VRMLExecutionSpace getExecutionSpace() {
        return this.execSpace;
    }

    public void initialize(double d) {
        try {
            if (this.realScript != null) {
                this.realScript.setTimestamp(d);
                this.realScript.initialize(this);
                this.eventOutProcessingInProgress = true;
                this.realScript.updateEventOuts();
                this.eventOutProcessingInProgress = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Script failed to initialize: " + this.vfUrl[0]);
            exception.printStackTrace();
        }
    }

    public void prepareEvents(double d) {
        if (this.realScript != null) {
            this.realScript.setTimestamp(d);
            if (this.realScript.prepareEvents() && this.realScript.sendEvents()) {
                this.eventOutProcessingInProgress = true;
                this.realScript.updateEventOuts();
                this.eventOutProcessingInProgress = false;
            }
        }
    }

    public void processEvents() {
        if (this.realScript != null && this.realScript.sendEvents()) {
            this.eventOutProcessingInProgress = true;
            this.realScript.updateEventOuts();
            this.eventOutProcessingInProgress = false;
        }
    }

    public void eventsProcessed() {
        if (this.realScript != null) {
            this.realScript.eventsProcessed();
            this.eventOutProcessingInProgress = true;
            this.realScript.updateEventOuts();
            this.eventOutProcessingInProgress = false;
        }
    }

    public void shutdown() {
        if (this.realScript != null) {
            this.realScript.shutdown();
            if (this.realScript.sendEvents()) {
                this.eventOutProcessingInProgress = true;
                this.realScript.updateEventOuts();
                this.eventOutProcessingInProgress = false;
            }
            this.realScript = null;
        }
    }

    public void shutdownAll() {
    }

    public boolean isSetupFinished() {
        return !this.inSetup;
    }

    public void setupFinished() {
        super.setupFinished();
        int n = this.getFieldCount();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType[] vRMLNodeTypeArray;
            int n2;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(i);
            this.fieldChangedMap.put(i, Boolean.FALSE);
            int n3 = vRMLFieldDeclaration.getAccessType();
            if (n3 == 1 || n3 == 4 || (n2 = vRMLFieldDeclaration.getFieldType()) != 12 && n2 != 11) continue;
            Object object = this.fieldValueMap.get(i);
            if (object instanceof VRMLNodeType) {
                vRMLNodeTypeArray = (VRMLNodeType[])object;
                if (vRMLNodeTypeArray == this) continue;
                vRMLNodeTypeArray.setupFinished();
                continue;
            }
            if (!(object instanceof VRMLNodeType[])) continue;
            vRMLNodeTypeArray = (VRMLNodeType[])object;
            int n4 = (Integer)this.fieldSizeMap.get(i);
            for (int j = 0; j < n4; ++j) {
                if (vRMLNodeTypeArray[j] == this || vRMLNodeTypeArray[j] == null) continue;
                vRMLNodeTypeArray[j].setupFinished();
            }
        }
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Can't set DEF now");
        }
        this.isDEF = true;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        if (n >= 0 && n <= this.LAST_FIXED_INDEX) {
            if (n == this.FIELD_URL) {
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.stringArrayValue = this.vfUrl;
                vRMLFieldData.numElements = this.vfUrl == null ? 0 : this.vfUrl.length;
            } else if (n == this.FIELD_DIRECT_OUTPUT) {
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfDirectOutput;
            } else if (n == this.FIELD_MUST_EVALUATE) {
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfMustEvaluate;
            } else if (n == this.FIELD_METADATA) {
                vRMLFieldData.nodeValue = this.vfMetadata;
                vRMLFieldData.dataType = (short)7;
            }
        } else if (!this.fetchValue(n)) {
            return null;
        }
        return vRMLFieldData;
    }

    public boolean hasFieldChanged(int n) {
        boolean bl = false;
        Boolean bl2 = (Boolean)this.fieldChangedMap.get(n);
        bl = bl2;
        this.fieldChangedMap.put(n, Boolean.FALSE);
        return bl;
    }

    public int getPrimaryType() {
        return 41;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        Object object = this.fieldValueMap.get(n);
        if (object == null) {
            return;
        }
        Integer n3 = (Integer)this.fieldSizeMap.get(n);
        try {
            this.sendValue(vRMLNodeType, n2, object, n3);
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Script route to invalid event: " + invalidFieldException.getFieldName());
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Script route sending out of range values " + invalidFieldValueException.getFieldName());
            invalidFieldValueException.printStackTrace();
            System.out.println("URL: " + this.vfUrl[0]);
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(int): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, new Integer(n2));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(3, vRMLFieldDeclaration.getName(), n2);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(int[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, new Integer(n2));
        if (n2 != 0) {
            int[] nArray2 = (int[])this.fieldValueMap.get(n);
            if (nArray2 == null || nArray2.length < n2) {
                nArray2 = new int[n2];
                this.fieldValueMap.put(n, nArray2);
            }
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), nArray, n2);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        if (n >= 0 && n <= this.LAST_FIXED_INDEX) {
            if (n == this.FIELD_URL) {
                throw new InvalidFieldException("setValue(boolean): URL field not a boolean");
            }
            if (!this.inSetup) {
                throw new InvalidFieldException("Cannot change initialise  only fields");
            }
            if (n == this.FIELD_DIRECT_OUTPUT) {
                this.vfDirectOutput = bl;
                return;
            } else {
                if (n != this.FIELD_MUST_EVALUATE) throw new InvalidFieldException("Unknown fixed field");
                this.vfMustEvaluate = bl;
            }
            return;
        } else {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("setValue(int): Invalid Index: " + n);
            }
            this.fieldValueMap.put(n, new Boolean(bl));
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(1, vRMLFieldDeclaration.getName(), bl);
            }
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(boolean[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, new Integer(n2));
        if (n2 != 0) {
            boolean[] blArray2 = (boolean[])this.fieldValueMap.get(n);
            if (blArray2 == null || blArray2.length < n2) {
                blArray2 = new boolean[n2];
                this.fieldValueMap.put(n, blArray2);
            }
            System.arraycopy(blArray, 0, blArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(2, vRMLFieldDeclaration.getName(), blArray, n2);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(float): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, new Float(f));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), f);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(float[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, new Integer(n2));
        if (n2 != 0) {
            float[] fArray2 = (float[])this.fieldValueMap.get(n);
            if (fArray2 == null || fArray2.length < n2) {
                fArray2 = new float[n2];
                this.fieldValueMap.put(n, fArray2);
            }
            System.arraycopy(fArray, 0, fArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), fArray, n2);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(long): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, new Long(l));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), l);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(long): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, new Integer(n2));
        if (n2 != 0) {
            long[] lArray2 = (long[])this.fieldValueMap.get(n);
            if (lArray2 == null || lArray2.length < n2) {
                lArray2 = new long[n2];
                this.fieldValueMap.put(n, lArray2);
            }
            System.arraycopy(lArray, 0, lArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), lArray, n2);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(double): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, new Double(d));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), d);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(double): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, new Integer(n2));
        if (n2 != 0) {
            double[] dArray2 = (double[])this.fieldValueMap.get(n);
            if (dArray2 == null || dArray2.length < n2) {
                dArray2 = new double[n2];
                this.fieldValueMap.put(n, dArray2);
            }
            System.arraycopy(dArray, 0, dArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), dArray, n2);
        }
        this.fieldChangedMap.put(n, Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        if (n == this.FIELD_URL) {
            this.setUrl(new String[]{string}, 1);
        } else {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("setValue(String): Invalid Index: " + n);
            }
            this.fieldValueMap.put(n, string);
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(27, vRMLFieldDeclaration.getName(), string);
            }
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        if (n == this.FIELD_URL) {
            this.setUrl(stringArray, n2);
        } else {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("setValue(String[]): Invalid Index: " + n);
            }
            this.fieldSizeMap.put(n, new Integer(n2));
            if (n2 != 0) {
                String[] stringArray2 = (String[])this.fieldValueMap.get(n);
                if (stringArray2 == null || stringArray2.length < n2) {
                    stringArray2 = new String[n2];
                    this.fieldValueMap.put(n, stringArray2);
                }
                System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            }
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(28, vRMLFieldDeclaration.getName(), stringArray, n2);
            }
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(node): Invalid Index: " + n);
        }
        if (this.inSetup && vRMLFieldDeclaration.getFieldType() == 12) {
            Object object = this.fieldValueMap.get(n);
            if (object == null) {
                this.fieldValueMap.put(n, vRMLNodeType);
                this.fieldSizeMap.put(n, new Integer(1));
            } else if (object instanceof VRMLNodeType) {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[]{(VRMLNodeType)object, vRMLNodeType};
                this.fieldValueMap.put(n, vRMLNodeTypeArray);
                this.fieldSizeMap.put(n, new Integer(2));
            } else {
                VRMLNodeType[] vRMLNodeTypeArray = (VRMLNodeType[])object;
                Integer n2 = (Integer)this.fieldSizeMap.get(n);
                int n3 = n2;
                if (vRMLNodeTypeArray.length == n3) {
                    VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[n3 + 4];
                    System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray2, 0, n3);
                    vRMLNodeTypeArray = vRMLNodeTypeArray2;
                    this.fieldValueMap.put(n, vRMLNodeTypeArray2);
                }
                vRMLNodeTypeArray[n3] = vRMLNodeType;
                this.fieldSizeMap.put(n, new Integer(n3 + 1));
            }
        } else {
            if (n == this.FIELD_METADATA) {
                this.vfMetadata = vRMLNodeType;
            } else {
                this.fieldValueMap.put(n, vRMLNodeType);
            }
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                if (vRMLFieldDeclaration.getFieldType() == 11) {
                    this.realScript.queueEvent(11, vRMLFieldDeclaration.getName(), vRMLNodeType);
                } else {
                    this.realScript.queueEvent(12, vRMLFieldDeclaration.getName(), vRMLNodeType);
                }
            }
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
            this.fieldSizeMap.put(n, SINGLE_SIZE);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(node[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, new Integer(n2));
        if (this.inSetup) {
            Object object = this.fieldValueMap.get(n);
            if (object == null) {
                this.fieldValueMap.put(n, vRMLNodeTypeArray);
            } else if (object instanceof VRMLNodeType) {
                VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[vRMLNodeTypeArray.length + 1];
                vRMLNodeTypeArray2[0] = (VRMLNodeType)object;
                System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray2, 1, vRMLNodeTypeArray.length);
                this.fieldValueMap.put(n, vRMLNodeTypeArray2);
            } else {
                VRMLNodeType[] vRMLNodeTypeArray3 = (VRMLNodeType[])object;
                int n3 = vRMLNodeTypeArray3.length + vRMLNodeTypeArray.length;
                VRMLNodeType[] vRMLNodeTypeArray4 = new VRMLNodeType[n3];
                System.arraycopy(vRMLNodeTypeArray3, 0, vRMLNodeTypeArray4, 0, vRMLNodeTypeArray3.length);
                System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray4, vRMLNodeTypeArray3.length, vRMLNodeTypeArray.length);
                this.fieldValueMap.put(n, vRMLNodeTypeArray4);
            }
        } else {
            if (n2 != 0) {
                VRMLNodeType[] vRMLNodeTypeArray5 = (VRMLNodeType[])this.fieldValueMap.get(n);
                if (vRMLNodeTypeArray5 == null || vRMLNodeTypeArray5.length < n2) {
                    vRMLNodeTypeArray5 = new VRMLNodeType[n2];
                    this.fieldValueMap.put(n, vRMLNodeTypeArray5);
                }
                System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray5, 0, n2);
            }
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(12, vRMLFieldDeclaration.getName(), vRMLNodeTypeArray, n2);
            }
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public boolean isDEF() {
        return this.isDEF;
    }

    public boolean checkValidContentType(String string) {
        if (this.majorVersion == 2) {
            return validVrml97Types.contains(string);
        }
        return validX3DTypes.contains(string);
    }

    public int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException, InvalidFieldException {
        if (this.majorVersion == 2) {
            if (vRMLFieldDeclaration.getAccessType() == 3) {
                throw new InvalidFieldException(VRML97_EXPOSED_MSG + vRMLFieldDeclaration.getName());
            }
            switch (vRMLFieldDeclaration.getFieldType()) {
                case 2: 
                case 7: 
                case 8: 
                case 17: 
                case 18: 
                case 23: 
                case 24: 
                case 26: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    throw new InvalidFieldException(VRML97_FIELD_MSG + vRMLFieldDeclaration.getFieldTypeString() + " field name " + vRMLFieldDeclaration.getName());
                }
            }
        }
        int n = super.appendField(vRMLFieldDeclaration);
        this.fieldChangedMap.put(n, Boolean.FALSE);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                this.fieldValueMap.put(n, new Integer(0));
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 4: {
                this.fieldValueMap.put(n, FieldConstants.EMPTY_MFINT32);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 5: {
                this.fieldValueMap.put(n, new Float(0.0f));
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 7: {
                this.fieldValueMap.put(n, new Double(0.0));
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 31: {
                this.fieldValueMap.put(n, new Long(0L));
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 32: {
                this.fieldValueMap.put(n, FieldConstants.EMPTY_MFLONG);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 1: {
                this.fieldValueMap.put(n, Boolean.TRUE);
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 2: {
                this.fieldValueMap.put(n, FieldConstants.EMPTY_MFBOOL);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 9: {
                this.fieldValueMap.put(n, new Double(0.0));
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 11: {
                this.fieldValueMap.put(n, null);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 12: {
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 21: {
                this.fieldValueMap.put(n, new float[3]);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 23: {
                this.fieldValueMap.put(n, new float[4]);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 27: {
                this.fieldValueMap.put(n, "");
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                break;
            }
            case 28: {
                this.fieldValueMap.put(n, FieldConstants.EMPTY_MFSTRING);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.fieldValueMap.put(n, new float[0]);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 8: 
            case 10: 
            case 17: 
            case 18: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.fieldValueMap.put(n, new double[0]);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 25: {
                this.fieldValueMap.put(n, new int[3]);
                this.fieldSizeMap.put(n, ZERO_SIZE);
                break;
            }
            case 26: {
                this.fieldValueMap.put(n, FieldConstants.EMPTY_MFIMAGE);
                this.fieldSizeMap.put(n, ZERO_SIZE);
            }
        }
        return n;
    }

    public void setVersion(int n, int n2, boolean bl) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.isStatic = bl;
        this.isVrml97 = n == 2;
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length + this.fieldCount) {
            throw new InvalidFieldException("Invalid index in setUserData");
        }
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length + this.fieldCount) {
            throw new InvalidFieldException("Invalid index in getUserData");
        }
        return this.userData.get(n);
    }

    protected void copy(BaseScript baseScript) {
        List list = baseScript.getAllFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)list.get(i);
            if (vRMLFieldDeclaration == null || forbiddenFields.contains(vRMLFieldDeclaration.getName())) continue;
            try {
                int n2 = this.appendField(vRMLFieldDeclaration);
                int n3 = vRMLFieldDeclaration.getAccessType();
                if (n3 == 1 || n3 == 4) continue;
                VRMLFieldData vRMLFieldData = baseScript.getFieldValue(i);
                this.copyField(i, vRMLFieldData);
                continue;
            }
            catch (FieldException fieldException) {
                System.out.println("Error copying field in abstract node");
                fieldException.printStackTrace();
            }
        }
    }

    private void sendValue(VRMLNodeType vRMLNodeType, int n, Object object, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                vRMLNodeType.setValue(n, (Integer)object);
                break;
            }
            case 4: 
            case 25: 
            case 26: {
                vRMLNodeType.setValue(n, (int[])object, n2);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, ((Float)object).floatValue());
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 33: 
            case 37: 
            case 39: {
                vRMLNodeType.setValue(n, (float[])object, n2);
                break;
            }
            case 7: {
                vRMLNodeType.setValue(n, (Double)object);
                break;
            }
            case 8: 
            case 17: 
            case 35: 
            case 41: 
            case 43: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 31: {
                vRMLNodeType.setValue(n, (Long)object);
                break;
            }
            case 32: {
                vRMLNodeType.setValue(n, (long[])object, n2);
                break;
            }
            case 1: {
                vRMLNodeType.setValue(n, (Boolean)object);
                break;
            }
            case 2: {
                vRMLNodeType.setValue(n, (boolean[])object, n2);
                break;
            }
            case 27: {
                vRMLNodeType.setValue(n, (String)object);
                break;
            }
            case 28: {
                vRMLNodeType.setValue(n, (String[])object, n2);
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, (Double)object);
                break;
            }
            case 10: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 11: {
                vRMLNodeType.setValue(n, (VRMLNodeType)object);
                break;
            }
            case 12: {
                vRMLNodeType.setValue(n, (VRMLNodeType[])object, n2);
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 34: 
            case 38: 
            case 40: {
                vRMLNodeType.setValue(n, (float[])object, n2);
                break;
            }
            case 18: 
            case 36: 
            case 42: 
            case 44: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            default: {
                System.out.println("Unhandled case in Script.sendValue" + vRMLFieldDeclaration.getFieldTypeString());
            }
        }
    }

    private boolean fetchValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(this.nodeName, n);
        }
        Object object = this.fieldValueMap.get(n);
        Integer n2 = (Integer)this.fieldSizeMap.get(n);
        int n3 = n2 == null ? 0 : n2;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                vRMLFieldData.intValue = (Integer)object;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 4: {
                vRMLFieldData.intArrayValue = (int[])object;
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)9;
                break;
            }
            case 5: {
                vRMLFieldData.floatValue = ((Float)object).floatValue();
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 6: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 7: {
                vRMLFieldData.doubleValue = (Double)object;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 8: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 31: {
                vRMLFieldData.longValue = (Long)object;
                vRMLFieldData.dataType = (short)3;
                break;
            }
            case 32: {
                vRMLFieldData.longArrayValue = (long[])object;
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)10;
                break;
            }
            case 1: {
                vRMLFieldData.booleanValue = (Boolean)object;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.booleanArrayValue = (boolean[])object;
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)8;
                break;
            }
            case 9: {
                vRMLFieldData.doubleValue = (Double)object;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 10: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 27: {
                vRMLFieldData.stringValue = (String)object;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 28: {
                if (object instanceof String[]) {
                    vRMLFieldData.stringArrayValue = (String[])object;
                    vRMLFieldData.numElements = n3;
                    vRMLFieldData.dataType = (short)14;
                    break;
                }
                vRMLFieldData.stringValue = (String)object;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 11: {
                vRMLFieldData.nodeValue = (VRMLNodeType)object;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 12: {
                if (object instanceof VRMLNodeType) {
                    vRMLFieldData.nodeArrayValue = new VRMLNodeType[1];
                    vRMLFieldData.nodeArrayValue[0] = (VRMLNodeType)object;
                } else {
                    vRMLFieldData.nodeArrayValue = (VRMLNodeType[])object;
                }
                vRMLFieldData.numElements = n3;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 13: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = object == null || vRMLFieldData.floatArrayValue.length < 2 ? 0 : 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 14: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = n3 / 2;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 15: 
            case 21: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = object == null || vRMLFieldData.floatArrayValue.length < 3 ? 0 : 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 19: 
            case 23: 
            case 33: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = object == null || vRMLFieldData.floatArrayValue.length < 4 ? 0 : 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 16: 
            case 22: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = n3 / 3;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 20: 
            case 24: 
            case 34: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = n3 / 4;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 29: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = object == null || vRMLFieldData.doubleArrayValue.length < 2 ? 0 : 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 17: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = object == null || vRMLFieldData.doubleArrayValue.length < 3 ? 0 : 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 35: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = object == null || vRMLFieldData.doubleArrayValue.length < 4 ? 0 : 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 30: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3 / 2;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 18: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3 / 3;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 36: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3 / 4;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 37: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 39: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 41: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 43: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 38: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = n3 / 9;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 40: {
                vRMLFieldData.floatArrayValue = (float[])object;
                vRMLFieldData.numElements = n3 / 16;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 42: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3 / 9;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 44: {
                vRMLFieldData.doubleArrayValue = (double[])object;
                vRMLFieldData.numElements = n3 / 16;
                vRMLFieldData.dataType = (short)12;
                break;
            }
            case 25: 
            case 26: {
                vRMLFieldData.intArrayValue = (int[])object;
                vRMLFieldData.numElements = object != null ? vRMLFieldData.intArrayValue.length : 0;
                vRMLFieldData.dataType = (short)9;
            }
        }
        return true;
    }

    private void copyField(int n, VRMLFieldData vRMLFieldData) throws FieldException {
        int n2 = 0;
        switch (vRMLFieldData.dataType) {
            case 1: {
                this.setValue(n, vRMLFieldData.booleanValue);
                break;
            }
            case 8: {
                boolean[] blArray = null;
                if (vRMLFieldData.numElements != 0) {
                    blArray = new boolean[vRMLFieldData.numElements];
                    System.arraycopy(vRMLFieldData.booleanArrayValue, 0, blArray, 0, vRMLFieldData.numElements);
                }
                this.setValue(n, blArray, vRMLFieldData.numElements);
                break;
            }
            case 2: {
                this.setValue(n, vRMLFieldData.intValue);
                break;
            }
            case 9: {
                int[] nArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.intArrayValue.length;
                    nArray = new int[n2];
                    System.arraycopy(vRMLFieldData.intArrayValue, 0, nArray, 0, n2);
                }
                this.setValue(n, nArray, n2);
                break;
            }
            case 3: {
                this.setValue(n, vRMLFieldData.longValue);
                break;
            }
            case 10: {
                long[] lArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.longArrayValue.length;
                    lArray = new long[n2];
                    System.arraycopy(vRMLFieldData.longArrayValue, 0, lArray, 0, n2);
                }
                this.setValue(n, lArray, n2);
                break;
            }
            case 4: {
                this.setValue(n, vRMLFieldData.floatValue);
                break;
            }
            case 11: {
                float[] fArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.floatArrayValue.length;
                    fArray = new float[n2];
                    System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, n2);
                }
                this.setValue(n, fArray, n2);
                break;
            }
            case 5: {
                this.setValue(n, vRMLFieldData.doubleValue);
                break;
            }
            case 12: {
                double[] dArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.doubleArrayValue.length;
                    dArray = new double[n2];
                    System.arraycopy(vRMLFieldData.doubleArrayValue, 0, dArray, 0, n2);
                }
                this.setValue(n, dArray, n2);
                break;
            }
            case 6: {
                this.setValue(n, vRMLFieldData.stringValue);
                break;
            }
            case 14: {
                String[] stringArray = null;
                if (vRMLFieldData.numElements != 0) {
                    stringArray = new String[vRMLFieldData.numElements];
                    System.arraycopy(vRMLFieldData.stringArrayValue, 0, stringArray, 0, vRMLFieldData.numElements);
                }
                this.setValue(n, stringArray, vRMLFieldData.numElements);
                break;
            }
        }
    }

    protected void fireUrlChanged() {
        int n = this.urlListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged(this, this.FIELD_URL);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged(this, this.FIELD_URL, this.loadState);
        }
    }

    private boolean shouldUpdate(int n, VRMLFieldDeclaration vRMLFieldDeclaration) {
        boolean bl = true;
        if (this.eventOutProcessingInProgress) {
            switch (vRMLFieldDeclaration.getAccessType()) {
                case 1: 
                case 3: {
                    Boolean bl2 = (Boolean)this.fieldChangedMap.get(n);
                    bl = bl2 == false;
                    break;
                }
                case 2: 
                case 4: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    static {
        int n;
        ZERO_SIZE = new Integer(0);
        SINGLE_SIZE = new Integer(1);
        VRML97_MIME_TYPES = new String[]{"application/x-javascript", "application/javascript", "application/x-java", "application/java"};
        X3D_MIME_TYPES = new String[]{"application/x-ecmascript", "application/ecmascript", "application/x-java", "application/java"};
        SECONDARY_TYPE = new int[]{44};
        validVrml97Types = new HashSet();
        for (n = 0; n < VRML97_MIME_TYPES.length; ++n) {
            validVrml97Types.add(VRML97_MIME_TYPES[n]);
        }
        validX3DTypes = new HashSet();
        for (n = 0; n < X3D_MIME_TYPES.length; ++n) {
            validX3DTypes.add(X3D_MIME_TYPES[n]);
        }
        forbiddenFields = new HashSet();
        forbiddenFields.add("metadata");
        forbiddenFields.add("url");
        forbiddenFields.add("mustEvaluate");
        forbiddenFields.add("directOutput");
    }
}

