/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.browser;

import java.applet.Applet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.web3d.x3d.sai.BrowserFactoryImpl;
import org.web3d.x3d.sai.ConnectionException;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.NoSuchBrowserException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DComponent;

public class X3DBrowserFactoryImpl
implements BrowserFactoryImpl {
    private static final boolean PREFER_JAVA3D = false;
    private static BrowserFactoryImpl openglFactory;
    private static BrowserFactoryImpl java3dFactory;
    private static BrowserFactoryImpl defaultFactory;
    private static final String RENDERER_TYPE_PARAM = "Xj3D_RendererType";
    private static final String NULL_PARAMETER_ERROR = "Null parameter strings not allowed.";
    private static final String MALFORMED_PARAMETER_STRING_ERROR = "Malformed parameter string.  Expecting strings of the form A=B";
    private static final String OPENGL_FACTORY_CLASS = "org.xj3d.ui.awt.browser.ogl.X3DOGLBrowserFactoryImpl";
    private static final String JAVA3D_FACTORY_CLASS = "org.xj3d.ui.awt.browser.j3d.X3DJ3DBrowserFactoryImpl";

    public X3DComponent createComponent(Map map) throws NotSupportedException {
        BrowserFactoryImpl browserFactoryImpl = defaultFactory;
        if (map != null) {
            Object v = map.get(RENDERER_TYPE_PARAM);
            if (v != null && !(v instanceof String)) {
                throw new IllegalArgumentException("createComponent.Xj3D_RendererType must be a String");
            }
            if (v != null) {
                String string = (String)v;
                if (string.equalsIgnoreCase("opengl")) {
                    browserFactoryImpl = openglFactory;
                } else if (string.equalsIgnoreCase("java3d")) {
                    browserFactoryImpl = java3dFactory;
                }
            }
        }
        if (browserFactoryImpl == null) {
            browserFactoryImpl = defaultFactory;
        }
        return browserFactoryImpl.createComponent(map);
    }

    public ExternalBrowser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        throw new NotSupportedException();
    }

    static {
        try {
            openglFactory = (BrowserFactoryImpl)Class.forName(OPENGL_FACTORY_CLASS).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        try {
            java3dFactory = (BrowserFactoryImpl)Class.forName(JAVA3D_FACTORY_CLASS).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        defaultFactory = openglFactory != null ? openglFactory : java3dFactory;
    }
}

