from typing import IO, Any, Dict, Iterable, Pattern, Set

from paramiko.ssh_exception import ConfigParseError as ConfigParseError, CouldNotCanonicalize as CouldNotCanonicalize

SSH_PORT: int

class SSHConfig:
    SETTINGS_REGEX: Pattern[str]
    TOKENS_BY_CONFIG_KEY: dict[str, list[str]]
    def __init__(self) -> None: ...
    @classmethod
    def from_text(cls, text: str) -> SSHConfig: ...
    @classmethod
    def from_path(cls, path: str) -> SSHConfig: ...
    @classmethod
    def from_file(cls, flo: IO[str]) -> SSHConfig: ...
    def parse(self, file_obj: IO[str]) -> None: ...
    def lookup(self, hostname: str) -> SSHConfigDict: ...
    def canonicalize(self, hostname: str, options: SSHConfigDict, domains: Iterable[str]) -> str: ...
    def get_hostnames(self) -> Set[str]: ...

class LazyFqdn:
    fqdn: str | None
    config: SSHConfig
    host: str | None
    def __init__(self, config: SSHConfigDict, host: str | None = ...) -> None: ...

class SSHConfigDict(Dict[str, str]):
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def as_bool(self, key: str) -> bool: ...
    def as_int(self, key: str) -> int: ...
