/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SORTSAFE_H
#define _SC_SORTSAFE_H

// qt
class Q3ListView;

/**
 * This is a helper class to remember QListView sort settings. Under
 * certain conditions qt calls the compare method on a list view item
 * from its own constructor before the object is fully constructed.
 * This crashes.
 * This happens in updateNew in RpViewFlat, RpViewTree, WcViewFlat and
 * WcViewTree. Since QListView doesn't have a single method to disable
 * and enable sorting we use this 'scoped' class to hide it.
 */
class SortSafe
{
public:
  SortSafe( Q3ListView* );
  ~SortSafe();

private:
  Q3ListView* _view;
  int         _col;    ///< sort column
  bool        _asc;    ///< sort order ascending
};

#endif // _SC_SORTSAFE_H
