/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "RpView.h"
#include "RpViewTreeWidget.h"
#include "RpViewWhatsThis.h"
#include "RpViewModel.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QWhatsThis>


RpView::RpView( ID id, RpViewModel* model, ActionStorage* actions,
  QWidget* parent )
: super(parent), _id(id), _model(model)
{
  QGridLayout* gl = new QGridLayout( this, 1, 1 );
  gl->setMargin(0);

  gl->addWidget( new RpViewTreeWidget(model,actions,this), 0, 0 );
  gl->setRowStretch( 0, 3 );

  QWhatsThis::add( this, RpViewWhatsThis::get() );
}

ID RpView::getId() const
{
  return _id;
}
