/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHNODE_H
#define _SC_LOGGRAPHNODE_H

// sc
#include "util/String.h"
#include "svn/LogEntryTypes.h"

// boost
#include <boost/shared_ptr.hpp>


class LogGraphNode
{
public:
  enum Type {
    Unknown,
    Added,
    Deleted,
    Moved,
    Copied,
    ParentCopied,
    Modified,
    CopyFrom 
  };

  LogGraphNode( Type type, const sc::String& name, const svn::LogEntryPtr log );

  const Type getType() const;
  const sc::String& getName() const;
  const svn::LogEntryPtr getLog() const;

private:
  Type                   _type;
  sc::String             _name;
  const svn::LogEntryPtr _log;
};

typedef boost::shared_ptr<LogGraphNode> LogGraphNodePtr;

#endif // _SC_LOGGRAPHNODE_H
