/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_WCSTATUSTYPES_H
#define _SVN_WCSTATUSTYPES_H

// svn
#include <svn_wc.h>

// boost
#include <boost/shared_ptr.hpp>

// sys
#include <vector>


namespace svn
{
class WcStatus;

typedef boost::shared_ptr<WcStatus>  WcStatusPtr;
typedef std::vector< WcStatusPtr >   WcStatuss;


/** wc/svn_wc_status_kind */
enum WcStatusKind
{
  WcStatus_None        = svn_wc_status_none,
  WcStatus_Unversioned = svn_wc_status_unversioned,
  WcStatus_Normal      = svn_wc_status_normal,
  WcStatus_Added       = svn_wc_status_added,
  WcStatus_Missing     = svn_wc_status_missing,
  WcStatus_Deleted     = svn_wc_status_deleted,
  WcStatus_Replaced    = svn_wc_status_replaced,
  WcStatus_Modified    = svn_wc_status_modified,
  WcStatus_Merged      = svn_wc_status_merged,
  WcStatus_Conflicted  = svn_wc_status_conflicted,
  WcStatus_Ignored     = svn_wc_status_ignored,
  WcStatus_Obstructed  = svn_wc_status_obstructed,
  WcStatus_External    = svn_wc_status_external,
  WcStatus_Incomplete  = svn_wc_status_incomplete
};

/** The Status of the Lock if any. */
enum WcStatusLockKind
{
  WcStatusLock_None,
  WcStatusLock_Locked,
  WcStatusLock_Stolen,
  WcStatusLock_Other,
  WcStatusLock_Broken
};


} // namespace

#endif // _SVN_WCSTATUSTYPES_H

