/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CLEANUPPARAM_H
#define _SC_CLEANUPPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"

/**
 * Parameter class for CleanupCmd.
 */
class CleanupParam : public ScParam
{
public:
  CleanupParam( const sc::String& path )
    : _path(path)
  {
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  ScParamAccept(CleanupParam);

private:
  // in
  sc::String _path;
};

#endif // _SC_CLEANUPPARAM_H
