/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOCKDIALOG_H
#define _SC_LOCKDIALOG_H

// sc
class ScModel;

// qt
#include <QtGui/QDialog>
class QCheckBox;
class QPushButton;
class QTextEdit;
class QLabel;


class LockDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  LockDialog( ScModel* model, QWidget *parent = 0 );
  virtual ~LockDialog();

  QString getLogMessage() const;
  bool    isStealLock() const;

public slots:
  void cursorChanged( int x, int y );

private:
  ScModel*     _model;

  QTextEdit*   _edit;
  QLabel*      _pos;
  QCheckBox*   _steal;
  QPushButton* _ok;
};

#endif // _SC_LOCKDIALOG_H
