-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SparkLex.Lex)
procedure LTIntro (Curr_Line : in out Line_Context;
                   Token     :    out SP_Symbols.SP_Terminal) is
   Ch : Character;
begin
   LineManager.Accept_Char (Curr_Line => Curr_Line); -- less_than already recognised
   case E_Strings.Get_Element (E_Str => Curr_Line.Conts,
                               Pos   => Curr_Line.Curr_Pos) is
      when '=' =>
         Token := SP_Symbols.less_or_equal;
         LineManager.Accept_Char (Curr_Line => Curr_Line);
      when '>' =>
         Token := SP_Symbols.box;
         LineManager.Accept_Char (Curr_Line => Curr_Line);
      when '<' =>
         Token := SP_Symbols.left_label_paren;
         LineManager.Accept_Char (Curr_Line => Curr_Line);
      when '-' =>
         LineManager.Lookahead_Char (Curr_Line => Curr_Line,
                                     Ch        => Ch);
         if Ch = '>' then
            Token := SP_Symbols.is_equivalent_to;
            LineManager.Accept_Lookahead (Curr_Line => Curr_Line);
         else
            Token := SP_Symbols.less_than;
            LineManager.Reject_Lookahead (Curr_Line => Curr_Line);
         end if;
      when others =>
         Token := SP_Symbols.less_than;
   end case;
end LTIntro;
