-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with LexTokenManager.Seq_Algebra;

--# inherit Heap,
--#         LexTokenManager,
--#         LexTokenManager.Relation_Algebra,
--#         LexTokenManager.Seq_Algebra,
--#         RelationAlgebra,
--#         Statistics;

package LexTokenManager.Relation_Algebra.String is

   type Relation is private;

   procedure Create_Relation (The_Heap : in out Heap.HeapRecord;
                              R        :    out Relation);
   --# global in out Statistics.TableUsage;
   --# derives R,
   --#         The_Heap              from The_Heap &
   --#         Statistics.TableUsage from *,
   --#                                    The_Heap;

   -- Objects of type Relations utilize storage managed by the package Heap.
   -- The storage used by a relation R must be returned to the Heap  by calling
   -- DisposeOfRelation before R goes out of scope.
   procedure Dispose_Of_Relation (The_Heap : in out Heap.HeapRecord;
                                  R        : in     Relation);
   --# derives The_Heap from *,
   --#                       R;

   -- InsertPair provides the basic means to build a relation.
   -- Each pair in the relation R represented by the row value, I, and the
   -- column value J may be inserted individually.  The pair is only inserted
   -- if it is not already present.  There are no duplicates.
   procedure Insert_Pair (The_Heap : in out Heap.HeapRecord;
                          R        : in     Relation;
                          I, J     : in     LexTokenManager.Lex_String);
   --# global in     LexTokenManager.State;
   --#        in out Statistics.TableUsage;
   --# derives Statistics.TableUsage,
   --#         The_Heap              from *,
   --#                                    I,
   --#                                    J,
   --#                                    LexTokenManager.State,
   --#                                    R,
   --#                                    The_Heap;

   -- Creates a new set S containing all the column value
   -- entries for the row of a relation R specified by GivenIndex.
   -- If a row specified by the GivenIndex is not present in R,
   -- S is the empty set.
   procedure Row_Extraction
     (The_Heap    : in out Heap.HeapRecord;
      R           : in     Relation;
      Given_Index : in     LexTokenManager.Lex_String;
      S           :    out Seq_Algebra.Seq);
   --# global in     LexTokenManager.State;
   --#        in out Statistics.TableUsage;
   --# derives S                     from The_Heap &
   --#         Statistics.TableUsage,
   --#         The_Heap              from *,
   --#                                    Given_Index,
   --#                                    LexTokenManager.State,
   --#                                    R,
   --#                                    The_Heap;

   -- AddCol adds an entire column to a relation R.
   -- The column index J is applied to each of the values in the set S to obtain
   -- a set of pairs that are added to the relation R if they are not already
   -- present in R.
   -- R and S must have been initialized using their corresponding Create ops.
   procedure Add_Col
     (The_Heap : in out Heap.HeapRecord;
      R        : in     Relation;
      J        : in     LexTokenManager.Lex_String;
      S        : in     Seq_Algebra.Seq);
   --# global in     LexTokenManager.State;
   --#        in out Statistics.TableUsage;
   --# derives Statistics.TableUsage,
   --#         The_Heap              from *,
   --#                                    J,
   --#                                    LexTokenManager.State,
   --#                                    R,
   --#                                    S,
   --#                                    The_Heap;

   -- AugmentRelation performs the same operation as Sum except that it is
   -- performed in place and the augmented set is the final value of A.
   procedure Augment_Relation (The_Heap : in out Heap.HeapRecord;
                               A, B     : in     Relation);
   --# global in     LexTokenManager.State;
   --#        in out Statistics.TableUsage;
   --# derives Statistics.TableUsage,
   --#         The_Heap              from *,
   --#                                    A,
   --#                                    B,
   --#                                    LexTokenManager.State,
   --#                                    The_Heap;

   procedure Debug (The_Heap : in Heap.HeapRecord;
                    R        : in Relation);
   --# derives null from R,
   --#                   The_Heap;

private

   type Relation is record
      The_Relation : RelationAlgebra.Relation;
   end record;

end LexTokenManager.Relation_Algebra.String;
