-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure AddLoop
  (Scope         : in     Scopes;
   Comp_Unit     : in     ContextManager.UnitDescriptors;
   LoopStatement : in     Location;
   TheLoop       :    out Symbol) is
   CompilationUnit, Previous : Symbol;
begin
   RawDict.CreateLoop
     (Region    => GetRegion (Scope),
      Comp_Unit => Comp_Unit,
      Loc       => LoopStatement.Start_Position,
      TheLoop   => TheLoop);

   CompilationUnit := GetEnclosingCompilationUnit (Scope);
   case RawDict.GetSymbolDiscriminant (CompilationUnit) is
      when Subprogram_Symbol =>
         Previous :=
           RawDict.Get_Subprogram_Last_Loop (The_Subprogram => RawDict.Get_Subprogram_Info_Ref (Item => CompilationUnit));
         if Previous = NullSymbol then
            RawDict.Set_Subprogram_First_Loop
              (The_Subprogram => RawDict.Get_Subprogram_Info_Ref (Item => CompilationUnit),
               The_Loop       => TheLoop);
         else
            RawDict.SetNextLoop (Previous, TheLoop);
         end if;
         RawDict.Set_Subprogram_Last_Loop
           (The_Subprogram => RawDict.Get_Subprogram_Info_Ref (Item => CompilationUnit),
            The_Loop       => TheLoop);
      when Type_Symbol =>
         -- must be task body, no other type could have a loop in it
         Previous := RawDict.Get_Task_Type_Last_Loop (The_Task_Type => RawDict.Get_Type_Info_Ref (Item => CompilationUnit));
         if Previous = NullSymbol then
            RawDict.Set_Task_Type_First_Loop
              (The_Task_Type => RawDict.Get_Type_Info_Ref (Item => CompilationUnit),
               The_Loop      => TheLoop);
         else
            RawDict.SetNextLoop (Previous, TheLoop);
         end if;
         RawDict.Set_Task_Type_Last_Loop
           (The_Task_Type => RawDict.Get_Type_Info_Ref (Item => CompilationUnit),
            The_Loop      => TheLoop);
      when Package_Symbol =>
         Previous := RawDict.Get_Package_Last_Loop (The_Package => RawDict.Get_Package_Info_Ref (Item => CompilationUnit));
         if Previous = NullSymbol then
            RawDict.Set_Package_First_Loop
              (The_Package => RawDict.Get_Package_Info_Ref (Item => CompilationUnit),
               The_Loop    => TheLoop);
         else
            RawDict.SetNextLoop (Previous, TheLoop);
         end if;
         RawDict.Set_Package_Last_Loop
           (The_Package => RawDict.Get_Package_Info_Ref (Item => CompilationUnit),
            The_Loop    => TheLoop);
      when others => -- non-exec code
         SystemErrors.Fatal_Error (Sys_Err => SystemErrors.Invalid_Symbol_Table,
                                   Msg     => "in Dictionary.AddLoop");
   end case;

   if SPARK_IO.Is_Open (Dict.TemporaryFile) then
      Write_String (Dict.TemporaryFile, "loop statement for ");
      Write_Name (File => Dict.TemporaryFile,
                  Item => TheLoop);
      Write_String (Dict.TemporaryFile, " is at ");
      Write_Location (File => Dict.TemporaryFile,
                      Loc  => LoopStatement);
      Write_Line (Dict.TemporaryFile, " ;");
   end if;
end AddLoop;
