/************************************************************************
 *
 * Copyright (C) 2009-2022 IRCAD France
 * Copyright (C) 2012-2016 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#pragma once

#include <data/SeriesSet.hpp>

#include <service/macros.hpp>

#include <cppunit/extensions/HelperMacros.h>

namespace sight::io::dicom::ut
{

class WriterReaderTest : public CPPUNIT_NS::TestFixture
{
CPPUNIT_TEST_SUITE(WriterReaderTest);
CPPUNIT_TEST(writeReadImageSeriesTest);
CPPUNIT_TEST_SUITE_END();

public:

    // interface
    void setUp() override;
    void tearDown() override;

    static void writeReadImageSeriesTest();

private:

    /**
     * Create a series set containing an ImageSeries with landmarks and distance
     * and a ModelSeries with one reconstruction.
     */
    static data::SeriesSet::sptr createSeriesSet();
};

} // namespace sight::io::dicom::ut
