/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_GRID_H_
#define _STUB_GRID_H_

#include "stub_view.h"

namespace mforms {
namespace stub {

class GridImpl : public ViewImpl
{
 protected:
  GridImpl(::mforms::Grid *self)
    : ViewImpl(self)
  {
  }


  static bool __stdcall create(Grid*)
  {
    return true;
  }

  static int __stdcall add_column(Grid*, const std::string& name)
  {
    return 0;
  }

  static GridPath __stdcall append_header(Grid*, const std::string& gid)
  {
    GridPath dummy;
    return dummy;
  }

  static GridPath __stdcall append_row(Grid*, const GridPath& path)
  {
    GridPath dummy;
    return dummy;
  }

  static bool __stdcall set_str_value(Grid*, const GridPath& rid, const int col_id, const std::string& cv, const bool editable)
  {
    return true;
  }

  static bool __stdcall set_bool_value(Grid*, const GridPath& rid, const int col_id, bool cv, const bool editable)
  {
    return true;
  }

  static std::string __stdcall get_value(Grid*, const GridPath& rid, const int col_id, mforms::CellType* type)
  {
    return "";
  }

  static bool __stdcall set_fg(Grid*, const GridPath& rid, const int col_id, const double r, const double g, const double b)
  {
    return true;
  }

  static bool __stdcall set_bg(Grid*, const GridPath& rid, const int col_id, const double r, const double g, const double b)
  {
    return true;
  }

  static bool __stdcall set_enum(Grid*, const GridPath& rid, const int col_id, const std::vector<std::string>& list)
  {
    return true;
  }

  static bool __stdcall set_enum_def(Grid*, const GridPath& rid, const int col_id, std::vector<std::string>* list)
  {
    return true;
  }

  static bool __stdcall set_enum_def_c(Grid*, const GridPath& rid, const int col_id, const char** const list)
  {
    return true;
  }

  static void __stdcall shade(Grid*, const GridPath& rid, const Shade shade, const int col_id)
  {
  }

  static void __stdcall unshade(Grid*, const GridPath& rid, const Shade shade, const int col_id)
  {
  }

  static bool __stdcall has_shade(Grid*, const GridPath& rid, const int col_id, const Shade s)
  {
    return true;
  }

  static void __stdcall scroll_to_row(Grid*, const GridPath& rid)
  {
  }



public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_grid_impl.add_column= &GridImpl::add_column;
    f->_grid_impl.append_header= &GridImpl::append_header;
    f->_grid_impl.append_row= &GridImpl::append_row;
    f->_grid_impl.create= &GridImpl::create;
    f->_grid_impl.get_value= &GridImpl::get_value;
    f->_grid_impl.has_shade= &GridImpl::has_shade;
    f->_grid_impl.scroll_to_row= &GridImpl::scroll_to_row;
    f->_grid_impl.set_bg= &GridImpl::set_bg;
    f->_grid_impl.set_bool_value= &GridImpl::set_bool_value;
    f->_grid_impl.set_enum= &GridImpl::set_enum;
    f->_grid_impl.set_enum_def= &GridImpl::set_enum_def;
    f->_grid_impl.set_enum_def_c= &GridImpl::set_enum_def_c;
    f->_grid_impl.set_fg= &GridImpl::set_fg;
    f->_grid_impl.set_str_value= &GridImpl::set_str_value;
    f->_grid_impl.shade= &GridImpl::shade;
    f->_grid_impl.unshade= &GridImpl::unshade;
  }
};

}
}

#endif
