/*
    JSON library
    Copyright (C) 2014 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include <libziaint.h>

#include <zjson.h>
#include <zstr.h>

#include <zdebug.h>

#include <ctype.h>
#include <string.h>

static char *zjson_get1(const char *str, int ofs, int len){
	char *ret, *c, *d;
	int backslash = 0;
	if (len <= 0) return NULL;

	ret = g_strndup(str + ofs, len + 1);
	z_trim_end(ret);

	len = strlen(ret);
	if (ret[len - 1] == '"') ret[len - 1] = '\0';

	// apply backslashes
	for (c = ret, d = ret; *c != '\0'; c++){
		if (backslash){
			backslash = 0;
			switch (*c){
				case '\\':
					*d++ = '\\';
					break;
				case 'n':
					*d++ = '\n';
					break;
				case '\r':
					*d++ = '\r';
					break;
			}
		}else{
			if (*c == '\\'){
				backslash = 1;
				continue;
			}
			*d++ = *c;
		}
	}
	*d = '\0';


	return ret;
}

char *zjson_get_str(const char *str, int len, const char *path){
	char *ret = NULL, *key, *val;
	int i, level = 0, ko, kl, vo, vl, po;
	char *search = g_strdup(path);
	char *remains = NULL;
//	char *xx  = zjson_get1(str, 0, len);
	char *c;

	if (path == NULL) return NULL;

	if (len < 0) len = strlen(str);
		
	c = strchr(search, '.');
	if (c != NULL) {
		*c = '\0';
		remains = c + 1;
	}

	ko = 0;
	for (i = 1; i < len && ret == NULL; i++){
		key = val = NULL;

		while (i < len && isspace((unsigned char)str[i])) i++;
		ko = i + 1;
		while (i < len && str[i] != ':') i++;
		kl = i - ko - 1;
		while (i < len && isspace((unsigned char)str[i])) i++;
		vo = i + 2;
		while (i < len && str[i] != ',' && str[i] != '{') i++;
		vl = i - vo - 1;
		key = zjson_get1(str, ko, kl); 
		val = zjson_get1(str, vo, vl); 
		if (val != NULL && strcmp(search, key) == 0) {
			g_free(key);
			ret = val;
			break;
		}
		if (str[i] == '{') {
			po = i;
			level++;
			for (i++ ;i < len && level > 0; i++){
				if (str[i] == '{') level++;
				if (str[i] == '}') level--;
			}
			
			if (strcmp(search, key) == 0) ret = zjson_get_str(str + po, i - po - 1, remains);
		}
		g_free(key);
		g_free(val);
	}
	g_free(search);
	//dbg("\n");
	return ret;
}

void zjson_test(void){
	char *key;
	char *val;
	char *s = "{\"login\":{\"result\":\"NeedToken\",\"token\":\"b03a54f2c660eae532eaaab9a272973b\",\"cookieprefix\":\"wiki_krq\",\"sessionid\":\"99611b7e82e04d8a7e2542030d5f18a1\"},\"second\":\"secval\"}";

	/*key = "login.result";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);

	key = "login.token";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);

	key = "login";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);

	key = "neni";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);	 

	key = "login.sessionid";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);

	key = "second";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);
	  */

	s = "{\"query\":{\"pages\":{\"-1\":{\"ns\":0,\"title\":\"Main Page\",\"missing\":\"\",\"starttimestamp\":\"2014-07-15T06:21:10Z\",\"edittoken\":\"43cf06841bc074e7922cece1617f1504+\\\\\"}}}}";
	key = "query.pages.-1.edittoken";
	val = zjson_get_str(s, strlen(s), key);
	dbg("key='%s'  val='%s'\n", key, val);



}
