/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include <libsyncml/syncml.h>
#include <libsyncml/syncml_internals.h>
#include <libsyncml/sml_error_internals.h>
#include <libsyncml/sml_transport_internals.h>
#include "obex_client_internals.h"

SmlBool smlTransportObexVendorSamsungInit(SmlTransportObexClientEnv *env)
{
	smlTrace(TRACE_EXIT, "%s(%p, %s)", __func__, VA_STRING(env->model));

	/* Samsung uses several different ways of implementing SyncML.
	 * Actually this is only one dialect.
	 * If you need more then add model based detection via env->model.
	 */

	/* Notice - the information here are taken from
	 * 
	 *      www.traud.de/gsm/samsung.htm
	 *
	 * Many thanks for this nice work goes to Alexander Traud.
	 */
	if (
	    // PC Sync 2
	    !g_strcasecmp("SGH-Z500", env->model) ||
	    !g_strcasecmp("SGH-ZM60", env->model) ||

	    // PC Studio 3
	    !g_strcasecmp("SGH-D347", env->model) ||
	    !g_strcasecmp("SGH-D357", env->model) ||
	    !g_strcasecmp("SGH-D520", env->model) ||
	    !g_strcasecmp("SGH-D830", env->model) ||
	    !g_strcasecmp("SGH-D840", env->model) ||
	    !g_strcasecmp("SGH-E770", env->model) ||
	    !g_strcasecmp("SGH-E860", env->model) ||
	    !g_strcasecmp("SGH-E900", env->model) ||
	    !g_strcasecmp("SGH-F480", env->model) ||
	    !g_strcasecmp("SGH-S500i", env->model) ||
	    !g_strcasecmp("SGH-T609", env->model) ||
	    !g_strcasecmp("SGH-X800", env->model) ||
	    !g_strcasecmp("SGH-X810", env->model) ||
	    !g_strcasecmp("SGH-X820", env->model) ||
	    !g_strcasecmp("SGH-Z150", env->model) ||
	    !g_strcasecmp("SGH-Z310", env->model) ||
	    !g_strcasecmp("SGH-Z320i", env->model) ||
	    !g_strcasecmp("SGH-Z400", env->model) ||
	    !g_strcasecmp("SGH-Z510", env->model) ||
	    !g_strcasecmp("SGH-Z540", env->model) ||
	    !g_strcasecmp("SGH-Z560", env->model) ||
	    !g_strcasecmp("SGH-ZV30", env->model)
	   )
	{
		smlTrace(TRACE_INTERNAL, "%s: WebSync WiDESYNC III (Gumi, Suwon 3G)", __func__);
		smlTrace(TRACE_INTERNAL, "%s: %i datastores" , __func__, g_list_length(env->datastores));

		/* Example: AT+SyncML=4061062063064
		 *          1.    byte: number of datastores
		 *          2.+3. byte: 200+number => 206 == TWO-WAY-SYNC-BY-SERVER
		 *          4.    byte: database
		 *                      1 contacts/addressbook
		 *                      2 events/calendar
		 *                      3 notes/memos
		 *                      4 todos/tasks
		 *          repeat with 2.+3.
		 */
		env->at_command = g_strdup_printf("AT+SyncML=%i", g_list_length(env->datastores));
		unsigned int i;
		for(i = 0; i < g_list_length(env->datastores); i++)
		{
			char *tmp = g_strjoin("", env->at_command, "06", NULL);
			SmlTransportObexDatastoreType *type;
			type = g_list_nth_data(env->datastores, i);
                        switch(*type)
			{
				case SML_TRANSPORT_OBEX_DATASTORE_CONTACT:
					env->at_command = g_strjoin ("", tmp, "1", NULL);
					break;
				case SML_TRANSPORT_OBEX_DATASTORE_EVENT:
					env->at_command = g_strjoin ("", tmp, "2", NULL);
					break;
				case SML_TRANSPORT_OBEX_DATASTORE_NOTE:
					env->at_command = g_strjoin ("", tmp, "3", NULL);
					break;
				case SML_TRANSPORT_OBEX_DATASTORE_TODO:
					env->at_command = g_strjoin ("", tmp, "4", NULL);
					break;
				default:
					smlSafeCFree(&tmp);
					g_warning("Unkown datastore type %d for Samsung mobiles.",
						*type);
					return FALSE;
			}
			smlSafeCFree(&tmp);
		}
	} else {
		g_warning("Unknown Samsung mobile device %s - using default AT command.",
			env->model);
		return TRUE;
	}
	/* add the CR */
	char *tmp = g_strjoin("", env->at_command, "\r", NULL);
	smlSafeCFree(&(env->at_command));
	env->at_command = tmp;
	tmp = NULL;

	smlTrace(TRACE_EXIT, "%s - %s", __func__, VA_STRING(env->at_command));
	return TRUE;
}
