/*
 * $Id: LineGraph.java,v 1.3 2007-03-11 20:40:58 larry Exp $ 
 */
package com.representqueens.web.tags.spark;

/*
 * 
 * Copyright 2007 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import java.io.IOException;

/**
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.3 $ $Date: 2007-03-11 20:40:58 $
 */
public final class LineGraph extends AbstractServerGraph
{
  @Override
  public int doEndTag()
  {
    try
    {
      this.pageContext.getOut().write(constructImagePath());
    }
    catch (final IOException ioe)
    {
      // nothing to do...
    }
    
    return EVAL_PAGE;
  }
  
  public String constructImagePath()
  {
    final StringBuilder sb = new StringBuilder();
    
    sb.append(String.format("%s?type=line%s", getRealPath(), getQueryParams()));
    
    return sb.toString();
  }
  

}
