/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  SBML's <em>SBase</em> class, base class of most SBML objects.
 <p>
 * Most components in SBML are derived from a single abstract base type,
 * {@link SBase}.  In addition to serving as the parent class for most other
 * classes of objects in SBML, this base type is designed to allow a
 * modeler or a software package to attach arbitrary information to each
 * major element or list in an SBML model.
 <p>
 * {@link SBase} has an optional subelement called 'notes'.  It is intended to
 * serve as a place for storing optional information intended to be seen by
 * humans.  An example use of the 'notes' element would be to contain
 * formatted user comments about the model element in which the 'notes'
 * element is enclosed.  There are certain conditions on the XHTML content
 * permitted inside the 'notes' element; please consult the <a
 * target='_blank' href='http://sbml.org/Documents/Specifications'>SBML
 * specification document</a> corresponding to the SBML Level and Version
 * of your model for more information about the requirements for 'notes'
 * content.
 <p>
 * {@link SBase} has another optional subelement called 'annotation'.  Whereas the
 * 'notes' element described above is a container for content to be shown
 * directly to humans, the 'annotation' element is a container for optional
 * software-generated content <em>not</em> meant to be shown to humans.  The
 * element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary data content.  SBML places
 * only a few restrictions on the organization of the content; these are
 * intended to help software tools read and write the data as well as help
 * reduce conflicts between annotations added by different tools.  As is
 * the case with 'notes', it is important to refer to the <a
 * target='_blank' href='http://sbml.org/Documents/Specifications'>SBML
 * specification document</a> corresponding to the SBML Level and Version
 * of your model for more information about the requirements for
 * 'annotation' content.
 <p>
 * It is worth pointing out that the 'annotation' element in the definition
 * of {@link SBase} exists in order that software developers may attach optional
 * application-specific data to the elements in an SBML model.  However, it
 * is important that this facility not be misused.  In particular, it is
 * <em>critical</em> that data essential to a model definition or that can
 * be encoded in existing SBML elements is <em>not</em> stored in
 * 'annotation'. {@link Parameter} values, functional dependencies between model
 * elements, etc., should not be recorded as annotations.  It is crucial to
 * keep in mind the fact that data placed in annotations can be freely
 * ignored by software applications.  If such data affects the
 * interpretation of a model, then software interoperability is greatly
 * impeded.
 <p>
 * SBML Level 2 introduced an optional {@link SBase} attribute named 'metaid' for
 * supporting metadata annotations using RDF (<a target='_blank'
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>). The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML identifier
 * type, which means each 'metaid' value must be globally unique within an
 * SBML file.  (Importantly, this uniqueness criterion applies across any
 * attribute with type <a href='http://www.w3.org/TR/REC-xml/#id'>XML
 * ID</a>, not just the 'metaid' attribute used by SBML&mdash;something to
 * be aware of if your application-specific XML content inside the
 * 'annotation' subelement happens to use <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)  The 'metaid' value
 * serves to identify a model component for purposes such as referencing
 * that component from metadata placed within 'annotation' subelements.
 <p>
 * Beginning with SBML Level 2 Version 2, {@link SBase} has an optional
 * attribute named 'sboTerm' for supporting the use of the Systems Biology
 * Ontology.  In SBML proper, the data type of the attribute is a string of
 * the form 'SBO:NNNNNNN', where 'NNNNNNN' is a seven digit integer number;
 * libSBML simplifies the representation by only storing the 'NNNNNNN'
 * integer portion.  Thus, in libSBML, the 'sboTerm' attribute on {@link SBase} has
 * data type <code>int</code>, and {@link SBO} identifiers are stored simply as integers.
 * (For convenience, {@link SBase} offers methods for returning both the integer
 * form and a text-string form of the {@link SBO} identifier.)  {@link SBO} terms are a
 * type of optional annotation, and each different class of SBML object
 * derived from {@link SBase} imposes its own requirements about the values
 * permitted for 'sboTerm'.  More details can be found in SBML specifications
 * for Level&nbsp;2 Version&nbsp;2 and above.
 <p>
 * Finally, note that, in the list of methods on {@link SBase}, there is no public
 * constructor because {@link SBase} is an abstract class.  The constructors reside
 * in the subclasses derived from {@link SBase}.
 <p>
 * <h2>Standard format for annotations linking data resources</h2>
 <p>
 * SBML Level 2 Versions 2, 3 and 4, and Level&nbsp;3, define a proposed
 * regular format for encoding two particular categories of annotations:
 * (a) references to controlled vocabulary terms and database identifiers
 * which define and describe biological and biochemical entities in a
 * model; and (b) descriptions of the provenance of a model, including its
 * author(s) and modification history.
 */

public class SBase {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBase(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBase obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBase obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBase(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for SBase.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((SBase)(sb));
  }

  /**
   * Returns a hashcode for this SBase object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates and returns a deep copy of this {@link SBase} object.
   <p>
   * @return the (deep) copy of this {@link SBase} object.
   */ public
 SBase cloneObject() {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_cloneObject(swigCPtr, this), true);
}

  
/**
   * Returns the first child element found that has the given <code>id</code> in the
   * model-wide <code>SId</code> namespace, or <code>null</code> if no such object is found.
   <p>
   * @param id string representing the 'id' attribute value of the object
   * to find.
   <p>
   * @return pointer to the first element found with the given identifier.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getElementBySId__SWIG_0(swigCPtr, this, id), false);
}

  
/**
   * Returns the first child element it can find with a specific 'metaid'
   * attribute value, or <code>null</code> if no such object is found.
   <p>
   * <p>
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML&mdash;something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
   <p>
   * @param metaid string representing the 'metaid' attribute value of the
   * object to find.
   <p>
   * @return pointer to the first element found with the given meta-identifier.
   */ public
 SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getElementByMetaId__SWIG_0(swigCPtr, this, metaid), false);
}

  
/**
   * <p>
 * Replaces all uses of a given <code>SIdRef</code> type attribute value with another
 * value.
 <p>
 * <p>
 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of <code>oldid</code>.  If any matches are found, the
 * matching values are replaced with <code>newid</code>.  The method does <em>not</em>
 * descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.SBase_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * <p>
 * Replaces all uses of a given meta identifier attribute value with
 * another value.
 <p>
 * <p>
 * In SBML, object 'meta' identifiers are of the XML data type <code>ID</code>;
 * the SBML object attribute itself is typically named <code>metaid</code>.  All
 * attributes that hold values <em>referring</em> to values of type
 * <code>ID</code> are of the XML data type <code>IDREF</code>.  They are also
 * sometimes informally referred to as 'metaid refs', in analogy to the
 * SBML-defined type <code>SIdRef</code>.
 <p>
 * This method works by looking at all meta-identifier attribute values,
 * comparing the identifiers to the value of <code>oldid</code>.  If any matches are
 * found, the matching identifiers are replaced with <code>newid</code>.  The method
 * does <em>not</em> descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameMetaIdRefs(String oldid, String newid) {
    libsbmlJNI.SBase_renameMetaIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>UnitSIdRef</code> type attribute value with
 * another value.
 <p>
 * <p>
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of <code>oldid</code>.  If any matches
 * are found, the matching values are replaced with <code>newid</code>.  The method
 * does <em>not</em> descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.SBase_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/** * @internal */ public
 void replaceSIDWithFunction(String id, ASTNode function) {
    libsbmlJNI.SBase_replaceSIDWithFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/** * @internal */ public
 void divideAssignmentsToSIdByFunction(String id, ASTNode function) {
    libsbmlJNI.SBase_divideAssignmentsToSIdByFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/** * @internal */ public
 void multiplyAssignmentsToSIdByFunction(String id, ASTNode function) {
    libsbmlJNI.SBase_multiplyAssignmentsToSIdByFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/** * @internal */ public
 SBase getElementFromPluginsBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getElementFromPluginsBySId(swigCPtr, this, id), false);
}

  
/** * @internal */ public
 SBase getElementFromPluginsByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getElementFromPluginsByMetaId(swigCPtr, this, metaid), false);
}

  
/** * @internal */ public
 boolean hasNonstandardIdentifierBeginningWith(String prefix) {
    return libsbmlJNI.SBase_hasNonstandardIdentifierBeginningWith(swigCPtr, this, prefix);
  }

  
/** * @internal */ public
 int prependStringToAllIdentifiers(String prefix) {
    return libsbmlJNI.SBase_prependStringToAllIdentifiers(swigCPtr, this, prefix);
  }

  
/** * @internal */ public
 int transformIdentifiers(IdentifierTransformer idTransformer) {
    return libsbmlJNI.SBase_transformIdentifiers(swigCPtr, this, IdentifierTransformer.getCPtr(idTransformer), idTransformer);
  }

  
/**
   * Returns the value of the 'metaid' attribute of this SBML object.
   <p>
   * <p>
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML&mdash;something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
   <p>
   * @return the meta-identifier of this SBML object.
   <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   */ public
 String getMetaId() {
    return libsbmlJNI.SBase_getMetaId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'id' attribute of this SBML object, if it has one, 
   * or the 'variable' attribute of a {@link Rule}, or the 'symbol' attribute of
   * an {@link InitialAssignment}.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
   <p>
   * @return the id of this SBML object, or the 'variable' if the object is a
   * {@link Rule}, or the 'symbol' if the object is an {@link InitialAssignment}.
   <p>
   * @note Because of the inconsistent behavior of this function with respect
   * to assignments and rules, callers should use getIdAttribute() instead.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getId() {
    return libsbmlJNI.SBase_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'id' attribute of this SBML object.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
   <p>
   * @return the id of this SBML object, if set and valid for this
   * level and version of SBML; an empty string otherwise.
   <p>
   * @note Because of the inconsistent behavior of this function with respect
   * to assignments and rules, callers should use getIdAttribute() instead.
   <p>
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getIdAttribute() {
    return libsbmlJNI.SBase_getIdAttribute(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this SBML object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 <p>
 * @see #getIdAttribute()
 * @see #isSetName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 String getName() {
    return libsbmlJNI.SBase_getName(swigCPtr, this);
  }

  
/**
   * Returns the content of the 'notes' subelement of this object as
   * a tree of {@link XMLNode} objects.
   <p>
   * <p>
 * The optional SBML element named 'notes', present on every major SBML
 * component type (and in SBML Level&nbsp;3, the 'message' subelement of
 * {@link Constraint}), is intended as a place for storing optional information
 * intended to be seen by humans.  An example use of the 'notes' element
 * would be to contain formatted user comments about the model element in
 * which the 'notes' element is enclosed.  Every object derived directly or
 * indirectly from type {@link SBase} can have a separate value for 'notes', allowing
 * users considerable freedom when adding comments to their models.
 <p>
 * The format of 'notes' elements conform to the definition of <a
 * target='_blank' href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.
 * However, the content cannot be <em>entirely</em> free-form; it must satisfy
 * certain requirements defined in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specifications</a>
 * for specific SBML Levels.  To help verify the formatting of 'notes'
 * content, libSBML provides the static utility method
 * {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; this
 * method implements a verification process that lets callers check whether
 * the content of a given {@link XMLNode} object conforms to the SBML requirements
 * for 'notes' and 'message' structure.  Developers are urged to consult the
 * appropriate <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specification
 * document</a> for the Level and Version of their model for more in-depth
 * explanations of using 'notes' in SBML.  The SBML Level&nbsp;2 and&nbsp;3
 * specifications have considerable detail about how 'notes' element content
 * must be structured. 
   <p>
   * The 'notes' element content returned by this method will be in XML
   * form, but libSBML does not provide an object model specifically for
   * the content of notes.  Callers will need to traverse the XML tree
   * structure using the facilities available on {@link XMLNode} and related
   * objects.  For an alternative method of accessing the notes, see
   * getNotesString().
   <p>
   * @return the content of the 'notes' subelement of this SBML object as a
   * tree structure composed of {@link XMLNode} objects.
   <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 XMLNode getNotes() {
    long cPtr = libsbmlJNI.SBase_getNotes__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
/**
   * Returns the content of the 'notes' subelement of this object as a
   * string.
   <p>
   * <p>
 * The optional SBML element named 'notes', present on every major SBML
 * component type (and in SBML Level&nbsp;3, the 'message' subelement of
 * {@link Constraint}), is intended as a place for storing optional information
 * intended to be seen by humans.  An example use of the 'notes' element
 * would be to contain formatted user comments about the model element in
 * which the 'notes' element is enclosed.  Every object derived directly or
 * indirectly from type {@link SBase} can have a separate value for 'notes', allowing
 * users considerable freedom when adding comments to their models.
 <p>
 * The format of 'notes' elements conform to the definition of <a
 * target='_blank' href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.
 * However, the content cannot be <em>entirely</em> free-form; it must satisfy
 * certain requirements defined in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specifications</a>
 * for specific SBML Levels.  To help verify the formatting of 'notes'
 * content, libSBML provides the static utility method
 * {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; this
 * method implements a verification process that lets callers check whether
 * the content of a given {@link XMLNode} object conforms to the SBML requirements
 * for 'notes' and 'message' structure.  Developers are urged to consult the
 * appropriate <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specification
 * document</a> for the Level and Version of their model for more in-depth
 * explanations of using 'notes' in SBML.  The SBML Level&nbsp;2 and&nbsp;3
 * specifications have considerable detail about how 'notes' element content
 * must be structured. 
   <p>
   * For an alternative method of accessing the notes, see getNotes(),
   * which returns the content as an {@link XMLNode} tree structure.  Depending on
   * an application's needs, one or the other method may be more
   * convenient.
   <p>
   * @return the content of the 'notes' subelement of this SBML object as a
   * string.
   <p>
   * @see #getNotes()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 String getNotesString() {
    return libsbmlJNI.SBase_getNotesString__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns the content of the 'annotation' subelement of this object as
   * a tree of {@link XMLNode} objects.
   <p>
   * <p>
 * Whereas the SBML 'notes' subelement is a container for content to be
 * shown directly to humans, the 'annotation' element is a container for
 * optional software-generated content <em>not</em> meant to be shown to
 * humans.  Every object derived from {@link SBase} can have its own value for
 * 'annotation'.  The element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary well-formed XML data
 * content.
 <p>
 * SBML places a few restrictions on the organization of the content of
 * annotations; these are intended to help software tools read and write
 * the data as well as help reduce conflicts between annotations added by
 * different tools.  Please see the SBML specifications for more details. 
   <p>
   * The annotations returned by this method will be in XML form.  LibSBML
   * provides an object model and related interfaces for certain specific
   * kinds of annotations, namely model history information and RDF
   * content.  See the {@link ModelHistory}, {@link CVTerm} and {@link RDFAnnotationParser} classes
   * for more information about the facilities available.
   <p>
   * @return the annotation of this SBML object as a tree of {@link XMLNode} objects.
   <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */ public
 XMLNode getAnnotation() {
    long cPtr = libsbmlJNI.SBase_getAnnotation__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
/**
   * Returns the content of the 'annotation' subelement of this object as a
   * character string.
   <p>
   * <p>
 * Whereas the SBML 'notes' subelement is a container for content to be
 * shown directly to humans, the 'annotation' element is a container for
 * optional software-generated content <em>not</em> meant to be shown to
 * humans.  Every object derived from {@link SBase} can have its own value for
 * 'annotation'.  The element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary well-formed XML data
 * content.
 <p>
 * SBML places a few restrictions on the organization of the content of
 * annotations; these are intended to help software tools read and write
 * the data as well as help reduce conflicts between annotations added by
 * different tools.  Please see the SBML specifications for more details. 
   <p>
   * The annotations returned by this method will be in string form.  See the
   * method getAnnotation() for a version that returns annotations in XML form.
   <p>
   * @return the annotation of this SBML object as a character string.
   <p>
   * @see #getAnnotation()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */ public
 String getAnnotationString() {
    return libsbmlJNI.SBase_getAnnotationString__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns a list of the XML Namespaces declared on the SBML document
   * owning this object.
   <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and (in
   * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   <p>
   * @return the XML Namespaces associated with this SBML object, or <code>null</code>
   * in certain very usual circumstances where a namespace is not set.
   <p>
   * @see #getLevel()
   * @see #getVersion()
   */ public
 XMLNamespaces getNamespaces() {
    long cPtr = libsbmlJNI.SBase_getNamespaces(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNamespaces(cPtr, false);
  }

  
/**
   * Returns the {@link SBMLDocument} object containing this object instance.
   <p>
   * <p>
 * LibSBML uses the class {@link SBMLDocument} as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * {@link SBMLDocument} object.  {@link SBMLDocument} corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
   <p>
   * This method allows the caller to obtain the {@link SBMLDocument} for the
   * current object.
   <p>
   * @return the parent {@link SBMLDocument} object of this SBML object.
   <p>
   * @see #getParentSBMLObject()
   * @see #getModel()
   */ public
 SBMLDocument getSBMLDocument() {
    long cPtr = libsbmlJNI.SBase_getSBMLDocument__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, false);
  }

  
/**
   * Returns the parent SBML object containing this object.
   <p>
   * This returns the immediately-containing object.  This method is
   * convenient when holding an object nested inside other objects in an
   * SBML model.  
   <p>
   * @return the parent SBML object of this SBML object.
   <p>
   * @see #getSBMLDocument()
   * @see #getModel()
   */ public
 SBase getParentSBMLObject() {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getParentSBMLObject__SWIG_0(swigCPtr, this), false);
}

  
/**
   * Returns the first ancestor object that has the given SBML type code from the given package.
   <p>
   * LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters <code>SBML_.</code> 
   <p>
   * This method searches the tree of objects that are parents of this
   * object, and returns the first one that has the given SBML type code from 
   * the given <code>pkgName</code>.
   <p>
   * @param type the SBML type code of the object sought.
   <p>
   * @param pkgName (optional) the short name of an SBML Level&nbsp;3
   * package to which the sought-after object must belong.
   <p>
   * @return the ancestor SBML object of this SBML object that corresponds
   * to the given SBML object type
   * code, or <code>null</code> if no ancestor exists.
   <p>
   * @warning The optional argument <code>pkgName</code> must be used for all type codes
   * from SBML Level&nbsp;3 packages.  Otherwise, the function will search the 
   * 'core' namespace alone, not find any corresponding elements, and return 
   * null.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBase getAncestorOfType(int type, String pkgName) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getAncestorOfType__SWIG_0(swigCPtr, this, type, pkgName), false);
}

  
/**
   * Returns the first ancestor object that has the given SBML type code from the given package.
   <p>
   * LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters <code>SBML_.</code> 
   <p>
   * This method searches the tree of objects that are parents of this
   * object, and returns the first one that has the given SBML type code from 
   * the given <code>pkgName</code>.
   <p>
   * @param type the SBML type code of the object sought.
   <p>
   * @param pkgName (optional) the short name of an SBML Level&nbsp;3
   * package to which the sought-after object must belong.
   <p>
   * @return the ancestor SBML object of this SBML object that corresponds
   * to the given SBML object type
   * code, or <code>null</code> if no ancestor exists.
   <p>
   * @warning The optional argument <code>pkgName</code> must be used for all type codes
   * from SBML Level&nbsp;3 packages.  Otherwise, the function will search the 
   * 'core' namespace alone, not find any corresponding elements, and return 
   * null.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBase getAncestorOfType(int type) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getAncestorOfType__SWIG_1(swigCPtr, this, type), false);
}

  
/**
   * Returns the integer portion of the value of the 'sboTerm' attribute of
   * this object.
   <p>
   * <p>
 * Beginning with SBML Level 2 Version 2, objects derived from {@link SBase} have
 * an optional attribute named 'sboTerm' for supporting the use of the
 * Systems Biology Ontology.  In SBML proper, the data type of the
 * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
 * seven digit integer number; libSBML simplifies the representation by
 * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
 * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
 * are stored simply as integers.
   * <p>
 * {@link SBO} terms are a type of optional annotation, and each different class
 * of SBML object derived from {@link SBase} imposes its own requirements about
 * the values permitted for 'sboTerm'. More details can be found in SBML
 * specifications for Level&nbsp;2 Version&nbsp;2 and above.
   <p>
   * @return the value of the 'sboTerm' attribute as an integer, or <code>-1</code>
   * if the value is not set.
   */ public
 int getSBOTerm() {
    return libsbmlJNI.SBase_getSBOTerm(swigCPtr, this);
  }

  
/**
   * Returns the string representation of the 'sboTerm' attribute of
   * this object.
   <p>
   * <p>
 * Beginning with SBML Level 2 Version 2, objects derived from {@link SBase} have
 * an optional attribute named 'sboTerm' for supporting the use of the
 * Systems Biology Ontology.  In SBML proper, the data type of the
 * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
 * seven digit integer number; libSBML simplifies the representation by
 * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
 * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
 * are stored simply as integers.
   * <p>
 * {@link SBO} terms are a type of optional annotation, and each different class
 * of SBML object derived from {@link SBase} imposes its own requirements about
 * the values permitted for 'sboTerm'. More details can be found in SBML
 * specifications for Level&nbsp;2 Version&nbsp;2 and above.
   <p>
   * @return the value of the 'sboTerm' attribute as a string (its value
   * will be of the form 'SBO:NNNNNNN'), or an empty string if
   * the value is not set.
   */ public
 String getSBOTermID() {
    return libsbmlJNI.SBase_getSBOTermID(swigCPtr, this);
  }

  
/**
   * Returns the URL representation of the 'sboTerm' attribute of this
   * object.
   <p>
   * This method returns the entire {@link SBO} identifier as a text string in the
   * form <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://identifiers.org/biomodels.sbo/SBO:NNNNNNN'</code>.
   <p>
   * <p>
 * {@link SBO} terms are a type of optional annotation, and each different class
 * of SBML object derived from {@link SBase} imposes its own requirements about
 * the values permitted for 'sboTerm'. More details can be found in SBML
 * specifications for Level&nbsp;2 Version&nbsp;2 and above.
   <p>
   * @return the value of the 'sboTerm' attribute as an identifiers.org URL,
   * or an empty string if the value is not set.
   */ public
 String getSBOTermAsURL() {
    return libsbmlJNI.SBase_getSBOTermAsURL(swigCPtr, this);
  }

  
/**
   * Returns the line number where this object first appears in the XML
   * representation of the SBML document.
   <p>
   * @return the line number of this SBML object.  If this object was
   * created programmatically and not read from a file, this method will
   * return the value <code>0.</code>
   <p>
   * @note The line number for each construct in an SBML model is set upon
   * reading the model.  The accuracy of the line number depends on the
   * correctness of the XML representation of the model, and on the
   * particular XML parser library being used.  The former limitation
   * relates to the following problem: if the model is actually invalid
   * XML, then the parser may not be able to interpret the data correctly
   * and consequently may not be able to establish the real line number.
   * The latter limitation is simply that different parsers seem to have
   * their own accuracy limitations, and out of all the parsers supported
   * by libSBML, none have been 100% accurate in all situations. (At this
   * time, libSBML supports the use of <a target='_blank'
   * href='http://xmlsoft.org'>libxml2</a>, <a target='_blank'
   * href='http://expat.sourceforge.net/'>Expat</a> and <a target='_blank'
   * href='http://xerces.apache.org/xerces-c/'>Xerces</a>.)
   <p>
   * @see #getColumn()
   */ public
 long getLine() {
    return libsbmlJNI.SBase_getLine(swigCPtr, this);
  }

  
/**
   * Returns the column number where this object first appears in the XML
   * representation of the SBML document.
   <p>
   * @return the column number of this SBML object.  If this object was
   * created programmatically and not read from a file, this method will
   * return the value <code>0.</code>
   <p>
   * @note The column number for each construct in an SBML model is set
   * upon reading the model.  The accuracy of the column number depends on
   * the correctness of the XML representation of the model, and on the
   * particular XML parser library being used.  The former limitation
   * relates to the following problem: if the model is actually invalid
   * XML, then the parser may not be able to interpret the data correctly
   * and consequently may not be able to establish the real column number.
   * The latter limitation is simply that different parsers seem to have
   * their own accuracy limitations, and out of all the parsers supported
   * by libSBML, none have been 100% accurate in all situations. (At this
   * time, libSBML supports the use of <a target='_blank'
   * href='http://xmlsoft.org'>libxml2</a>, <a target='_blank'
   * href='http://expat.sourceforge.net/'>Expat</a> and <a target='_blank'
   * href='http://xerces.apache.org/xerces-c/'>Xerces</a>.)
   <p>
   * @see #getLine()
   */ public
 long getColumn() {
    return libsbmlJNI.SBase_getColumn(swigCPtr, this);
  }

  
/**
   * Returns the {@link ModelHistory} object, if any, attached to this object.
   <p>
   * @return the {@link ModelHistory} object attached to this object, or <code>null</code> if
   * none exist.
   <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */ public
 ModelHistory getModelHistory() {
    long cPtr = libsbmlJNI.SBase_getModelHistory__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelHistory(cPtr, false);
  }

  
/**
   * Predicate returning <code>true</code> if this object's 'metaid' attribute is set.
   <p>
   * <p>
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML&mdash;something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support. 
   <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object is
   * set, <code>false</code> otherwise.
   <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   */ public
 boolean isSetMetaId() {
    return libsbmlJNI.SBase_isSetMetaId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if a call to getId() returns a
   * non-empty string.
   <p>
   * For most objects, this function will return <code>true</code> if its 'id'
   * attribute is set, and <code>false</code> if it is not, or if the object has no
   * 'id' attribute at all.  However, for an {@link EventAssignment} or a {@link Rule},
   * isSetId() checks whether the 'variable' attribute is set, and for an
   * {@link InitialAssignment}, it checks whether the 'symbol' attribute is set.
   * Because those elements will also have an 'id' attribute in SBML
   * Level&nbsp;3 Version&nbsp;2 which isSetId() will not check, the function
   * itself is deprecated, and it is recommended to use isSetIdAttribute() in
   * all cases where one needs to know whether the 'id' attribute is set, and
   * to use {@link EventAssignment#isSetVariable()}, {@link Rule#isSetVariable()} and
   * {@link InitialAssignment#isSetSymbol()} when the status of the 'variable' or
   * 'symbol' attributes need to be checked.
   <p>
   * <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * @return <code>true</code> if the 'id' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #unsetIdAttribute()
 * @see #isSetIdAttribute()
   */ public
 boolean isSetId() {
    return libsbmlJNI.SBase_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this object's 'id' attribute is set.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
   <p>
   * @return <code>true</code> if the 'id' attribute of this SBML object is
   * set, <code>false</code> otherwise.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #unsetIdAttribute()
   */ public
 boolean isSetIdAttribute() {
    return libsbmlJNI.SBase_isSetIdAttribute(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * object's 'name' attribute is set.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'name' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 boolean isSetName() {
    return libsbmlJNI.SBase_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * object's 'notes' subelement exists and has content.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * @return <code>true</code> if a 'notes' subelement exists, <code>false</code> otherwise.
   <p>
   * @see #getNotes()
   * @see #getNotesString()
   * @see #setNotes(XMLNode notes)
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 boolean isSetNotes() {
    return libsbmlJNI.SBase_isSetNotes(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * object's 'annotation' subelement exists and has content.
   <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * @return <code>true</code> if a 'annotation' subelement exists, <code>false</code>
   * otherwise.
   <p>
   * @see #getAnnotation()
   * @see #getAnnotationString()
   * @see #setAnnotation(XMLNode annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */ public
 boolean isSetAnnotation() {
    return libsbmlJNI.SBase_isSetAnnotation(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * object's 'sboTerm' attribute is set.
   <p>
   * @return <code>true</code> if the 'sboTerm' attribute of this SBML object is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetSBOTerm() {
    return libsbmlJNI.SBase_isSetSBOTerm(swigCPtr, this);
  }

  
/**
   * Sets the value of the meta-identifier attribute of this SBML object.
   <p>
   * <p>
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML&mdash;something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support. 
   <p>
   * The string <code>metaid</code> is copied.  
   <p>
   * @param metaid the identifier string to use as the value of the
   * 'metaid' attribute.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #getMetaId()
   * @see #isSetMetaId()
   */ public
 int setMetaId(String metaid) {
    return libsbmlJNI.SBase_setMetaId(swigCPtr, this, metaid);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * object has a {@link ModelHistory} object attached to it.
   <p>
   * @return <code>true</code> if the {@link ModelHistory} of this object is set,
   * <code>false</code> otherwise.
   <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */ public
 boolean isSetModelHistory() {
    return libsbmlJNI.SBase_isSetModelHistory(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this SBML object.
   <p>
   * <p>
 * The string <code>sid</code> is copied.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * @param sid the string to use as the identifier of this object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int setId(String sid) {
    return libsbmlJNI.SBase_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'id' attribute of this SBML object.
   <p>
   * <p>
 * The string <code>sid</code> is copied.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * @param sid the string to use as the identifier of this object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int setIdAttribute(String sid) {
    return libsbmlJNI.SBase_setIdAttribute(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this SBML object.
   <p>
   * <p>
 * The string in <code>name</code> is copied.
 <p>
 * @param name the new name for the SBML object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 *
 * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.SBase_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object.
   <p>
   * The content of <code>annotation</code> is copied, and any previous content of
   * this object's 'annotation' subelement is deleted.
   <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the 
   * <code>annotation</code> that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use {@link SBase#appendAnnotation(XMLNode annotation)} or
   * {@link SBase#appendAnnotation(String annotation)}.
   <p>
   * @param annotation an XML structure that is to be used as the new content
   * of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */ public
 int setAnnotation(XMLNode annotation) {
    return libsbmlJNI.SBase_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object.
   <p>
   * The content of <code>annotation</code> is copied, and any previous content of
   * this object's 'annotation' subelement is deleted.
   <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the 
   * <code>annotation</code> that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use {@link SBase#appendAnnotation(XMLNode annotation)} or
   * {@link SBase#appendAnnotation(String annotation)}.
   <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */ public
 int setAnnotation(String annotation) {
    return libsbmlJNI.SBase_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
/**
   * Appends the given <code>annotation</code> to the 'annotation' subelement of this
   * object.
   <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a
   * target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type 'any'</a>,
   * allowing essentially arbitrary well-formed XML data content.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Unlike {@link SBase#setAnnotation(XMLNode annotation)} or
   * {@link SBase#setAnnotation(String annotation)}, this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * (if the parent element does not have the 'metaid' attribute set)
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_ANNOTATION_NS LIBSBML_DUPLICATE_ANNOTATION_NS}
   * (if the parent was already annotated with the annotation in question)
   *
   * </ul> <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */ public
 int appendAnnotation(XMLNode annotation) {
    return libsbmlJNI.SBase_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
/**
   * Appends the given <code>annotation</code> to the 'annotation' subelement of this
   * object.
   <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a
   * target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type 'any'</a>,
   * allowing essentially arbitrary well-formed XML data content.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Unlike {@link SBase#setAnnotation(XMLNode annotation)} or
   * {@link SBase#setAnnotation(String annotation)}, this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * (if the parent element does not have the 'metaid' attribute set)
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_ANNOTATION_NS LIBSBML_DUPLICATE_ANNOTATION_NS}
   * (if the parent was already annotated with the annotation in question)
   *
   * </ul> <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #unsetAnnotation()
   */ public
 int appendAnnotation(String annotation) {
    return libsbmlJNI.SBase_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
/**
   * Removes the top-level element within the 'annotation' subelement of this
   * SBML object with the given name and optional URI.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Calling this method allows a particular annotation element to be removed
   * whilst the remaining annotations remain intact.
   <p>
   * @param elementName a string representing the name of the top level
   * annotation element that is to be removed.
   * @param elementURI an optional string that is used to check both the name
   * and URI of the top level element to be removed.
   * @param removeEmpty if after removing of the element, the annotation is 
   * empty, and the removeEmpty argument is true, the annotation node will be 
   * deleted (default). 
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND}
   * <li> {@link libsbmlConstants#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND}
   *
   * </ul> <p>
   * @see #replaceTopLevelAnnotationElement(XMLNode )
   * @see #replaceTopLevelAnnotationElement(String)
   */ public
 int removeTopLevelAnnotationElement(String elementName, String elementURI, boolean removeEmpty) {
    return libsbmlJNI.SBase_removeTopLevelAnnotationElement__SWIG_0(swigCPtr, this, elementName, elementURI, removeEmpty);
  }

  
/**
   * Removes the top-level element within the 'annotation' subelement of this
   * SBML object with the given name and optional URI.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Calling this method allows a particular annotation element to be removed
   * whilst the remaining annotations remain intact.
   <p>
   * @param elementName a string representing the name of the top level
   * annotation element that is to be removed.
   * @param elementURI an optional string that is used to check both the name
   * and URI of the top level element to be removed.
   * @param removeEmpty if after removing of the element, the annotation is 
   * empty, and the removeEmpty argument is true, the annotation node will be 
   * deleted (default). 
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND}
   * <li> {@link libsbmlConstants#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND}
   *
   * </ul> <p>
   * @see #replaceTopLevelAnnotationElement(XMLNode )
   * @see #replaceTopLevelAnnotationElement(String)
   */ public
 int removeTopLevelAnnotationElement(String elementName, String elementURI) {
    return libsbmlJNI.SBase_removeTopLevelAnnotationElement__SWIG_1(swigCPtr, this, elementName, elementURI);
  }

  
/**
   * Removes the top-level element within the 'annotation' subelement of this
   * SBML object with the given name and optional URI.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * Calling this method allows a particular annotation element to be removed
   * whilst the remaining annotations remain intact.
   <p>
   * @param elementName a string representing the name of the top level
   * annotation element that is to be removed.
   * @param elementURI an optional string that is used to check both the name
   * and URI of the top level element to be removed.
   * @param removeEmpty if after removing of the element, the annotation is 
   * empty, and the removeEmpty argument is true, the annotation node will be 
   * deleted (default). 
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND}
   * <li> {@link libsbmlConstants#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND}
   *
   * </ul> <p>
   * @see #replaceTopLevelAnnotationElement(XMLNode )
   * @see #replaceTopLevelAnnotationElement(String)
   */ public
 int removeTopLevelAnnotationElement(String elementName) {
    return libsbmlJNI.SBase_removeTopLevelAnnotationElement__SWIG_2(swigCPtr, this, elementName);
  }

  
/**
   * Replaces the given top-level element within the 'annotation' 
   * subelement of this SBML object and with the annotation element supplied.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * This method determines the name of the element to be replaced from the
   * annotation argument. Functionally it is equivalent to calling <code>
   * removeTopLevelAnnotationElement(name)</code> followed by calling
   * <code>appendAnnotation(annotation_with_name)</code>, with the exception
   * that the placement of the annotation element remains the same.
   <p>
   * @param annotation {@link XMLNode} representing the replacement top level annotation.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @see #removeTopLevelAnnotationElement(String elementName, String elementURI, boolean removeEmpty)
   * @see #replaceTopLevelAnnotationElement(String)
   */ public
 int replaceTopLevelAnnotationElement(XMLNode annotation) {
    return libsbmlJNI.SBase_replaceTopLevelAnnotationElement__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
/**
   * Replaces the given top-level element within the 'annotation' 
   * subelement of this SBML object and with the annotation element supplied.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * This method determines the name of the element to be replaced from the
   * annotation argument. Functionally it is equivalent to calling <code>
   * removeTopLevelAnnotationElement(name)</code> followed by calling
   * <code>appendAnnotation(annotation_with_name)</code>, with the exception
   * that the placement of the annotation element remains the same.
   <p>
   * @param annotation string representing the replacement top level annotation.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @see #removeTopLevelAnnotationElement(String elementName, String elementURI)
   * @see #replaceTopLevelAnnotationElement(XMLNode)
   */ public
 int replaceTopLevelAnnotationElement(String annotation) {
    return libsbmlJNI.SBase_replaceTopLevelAnnotationElement__SWIG_1(swigCPtr, this, annotation);
  }

  
/**
   * Sets the value of the 'notes' subelement of this SBML object.
   <p>
   * The content of <code>notes</code> is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * @param notes an XML structure that is to be used as the content of the
   * 'notes' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 int setNotes(XMLNode notes) {
    return libsbmlJNI.SBase_setNotes__SWIG_0(swigCPtr, this, XMLNode.getCPtr(notes), notes);
  }

  
/**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the string <code>notes</code>.
   <p>
   * The content of <code>notes</code> is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * The following code illustrates a very simple way of setting the notes
   * using this method.  Here, the object being annotated is the whole SBML
   * document, but that is for illustration purposes only; you could of
   * course use this same approach to annotate any other SBML component.
   <p>
<pre class='fragment'>
{@link SBMLDocument} s = new {@link SBMLDocument}(3, 1);
s.setNotes('&lt;body xmlns='http://www.w3.org/1999/xhtml'&gt;here is my note&lt;/p&gt;&lt;/body&gt;');
</pre>
<p>
   * @param notes an XML string that is to be used as the content of the
   * 'notes' subelement of this object.
   <p>
   * @param addXHTMLMarkup a boolean indicating whether to wrap the contents
   * of the <code>notes</code> argument with XHTML paragraph (<code>&lt;p&gt;</code>)
   * tags.  This is appropriate when the string in <code>notes</code> does not already
   * containg the appropriate XHTML markup.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 int setNotes(String notes, boolean addXHTMLMarkup) {
    return libsbmlJNI.SBase_setNotes__SWIG_1(swigCPtr, this, notes, addXHTMLMarkup);
  }

  
/**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the string <code>notes</code>.
   <p>
   * The content of <code>notes</code> is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * The following code illustrates a very simple way of setting the notes
   * using this method.  Here, the object being annotated is the whole SBML
   * document, but that is for illustration purposes only; you could of
   * course use this same approach to annotate any other SBML component.
   <p>
<pre class='fragment'>
{@link SBMLDocument} s = new {@link SBMLDocument}(3, 1);
s.setNotes('&lt;body xmlns='http://www.w3.org/1999/xhtml'&gt;here is my note&lt;/p&gt;&lt;/body&gt;');
</pre>
<p>
   * @param notes an XML string that is to be used as the content of the
   * 'notes' subelement of this object.
   <p>
   * @param addXHTMLMarkup a boolean indicating whether to wrap the contents
   * of the <code>notes</code> argument with XHTML paragraph (<code>&lt;p&gt;</code>)
   * tags.  This is appropriate when the string in <code>notes</code> does not already
   * containg the appropriate XHTML markup.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 int setNotes(String notes) {
    return libsbmlJNI.SBase_setNotes__SWIG_2(swigCPtr, this, notes);
  }

  
/**
   * Appends the given <code>notes</code> to the 'notes' subelement of this object.
   <p>
   * The content of <code>notes</code> is copied.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * @param notes an XML node structure that is to appended to the content
   * of the 'notes' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 int appendNotes(XMLNode notes) {
    return libsbmlJNI.SBase_appendNotes__SWIG_0(swigCPtr, this, XMLNode.getCPtr(notes), notes);
  }

  
/**
   * Appends the given <code>notes</code> to the 'notes' subelement of this object.
   <p>
   * The content of the parameter <code>notes</code> is copied.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * @param notes an XML string that is to appended to the content of
   * the 'notes' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(XMLNode notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 int appendNotes(String notes) {
    return libsbmlJNI.SBase_appendNotes__SWIG_1(swigCPtr, this, notes);
  }

  
/**
   * Sets the {@link ModelHistory} of this object.
   <p>
   * The content of <code>history</code> is copied, and this object's existing model
   * history content is deleted.
   <p>
   * @param history {@link ModelHistory} of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */ public
 int setModelHistory(ModelHistory history) {
    return libsbmlJNI.SBase_setModelHistory(swigCPtr, this, ModelHistory.getCPtr(history), history);
  }

  
/** * @internal */ public
 void connectToParent(SBase parent) {
    libsbmlJNI.SBase_connectToParent(swigCPtr, this, SBase.getCPtr(parent), parent);
  }

  public void connectToChild() {
    libsbmlJNI.SBase_connectToChild(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'sboTerm' attribute.
   <p>
   * <p>
 * Beginning with SBML Level 2 Version 2, objects derived from {@link SBase} have
 * an optional attribute named 'sboTerm' for supporting the use of the
 * Systems Biology Ontology.  In SBML proper, the data type of the
 * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
 * seven digit integer number; libSBML simplifies the representation by
 * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
 * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
 * are stored simply as integers.
   * <p>
 * {@link SBO} terms are a type of optional annotation, and each different class
 * of SBML object derived from {@link SBase} imposes its own requirements about
 * the values permitted for 'sboTerm'. More details can be found in SBML
 * specifications for Level&nbsp;2 Version&nbsp;2 and above.
   <p>
   * @param value the NNNNNNN integer portion of the {@link SBO} identifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #setSBOTerm(String sboid)
   */ public
 int setSBOTerm(int value) {
    return libsbmlJNI.SBase_setSBOTerm__SWIG_0(swigCPtr, this, value);
  }

  
/**
   * Sets the value of the 'sboTerm' attribute by string.
   <p>
   * <p>
 * Beginning with SBML Level 2 Version 2, objects derived from {@link SBase} have
 * an optional attribute named 'sboTerm' for supporting the use of the
 * Systems Biology Ontology.  In SBML proper, the data type of the
 * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
 * seven digit integer number; libSBML simplifies the representation by
 * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
 * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
 * are stored simply as integers.
   * <p>
 * {@link SBO} terms are a type of optional annotation, and each different class
 * of SBML object derived from {@link SBase} imposes its own requirements about
 * the values permitted for 'sboTerm'. More details can be found in SBML
 * specifications for Level&nbsp;2 Version&nbsp;2 and above.
   <p>
   * @param sboid the {@link SBO} identifier string of the form 'SBO:NNNNNNN'.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #setSBOTerm(int value)
   */ public
 int setSBOTerm(String sboid) {
    return libsbmlJNI.SBase_setSBOTerm__SWIG_1(swigCPtr, this, sboid);
  }

  
/**
   * Sets the namespaces relevant of this SBML object.
   <p>
   * The content of <code>xmlns</code> is copied, and this object's existing
   * namespace content is deleted.
   <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   <p>
   * @param xmlns the namespaces to set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setNamespaces(XMLNamespaces xmlns) {
    return libsbmlJNI.SBase_setNamespaces(swigCPtr, this, XMLNamespaces.getCPtr(xmlns), xmlns);
  }

  
/**
   * Unsets the value of the 'metaid' attribute of this SBML object.
   <p>
   * <p>
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML&mdash;something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support. 
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetMetaId() {
    return libsbmlJNI.SBase_unsetMetaId(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'id' attribute of this SBML object.
   <p>
   * <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int unsetId() {
    return libsbmlJNI.SBase_unsetId(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'id' attribute of this SBML object.
   <p>
   * Most (but not all) objects in SBML include two common attributes: 'id'
   * and 'name'.  The identifier given by an object's 'id' attribute value
   * is used to identify the object within the SBML model definition.
   * Other objects can refer to the component using this identifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   */ public
 int unsetIdAttribute() {
    return libsbmlJNI.SBase_unsetIdAttribute(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'name' attribute of this SBML object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #isSetName()
   */ public
 int unsetName() {
    return libsbmlJNI.SBase_unsetName(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'notes' subelement of this SBML object.
   <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode notes)
   * @see #setNotes(String notes, boolean addXHTMLMarkup)
   * @see #appendNotes(XMLNode notes)
   * @see #appendNotes(String notes)
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode)
   */ public
 int unsetNotes() {
    return libsbmlJNI.SBase_unsetNotes(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'annotation' subelement of this SBML object.
   <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #getAnnotation()
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   */ public
 int unsetAnnotation() {
    return libsbmlJNI.SBase_unsetAnnotation(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'sboTerm' attribute of this SBML object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * </ul>
   */ public
 int unsetSBOTerm() {
    return libsbmlJNI.SBase_unsetSBOTerm(swigCPtr, this);
  }

  
/**
   * Adds a copy of the given {@link CVTerm} object to this SBML object.
   <p>
   * @param term the {@link CVTerm} to assign.
   <p>
   * @param newBag if <code>true</code>, creates a new RDF bag with the same identifier
   * as a previous bag, and if <code>false</code>, adds the term to an existing
   * RDF bag with the same type of qualifier as the term being added.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}, if
   * this object lacks a 'metaid' attribute
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @note Since the CV Term uses the 'metaid' attribute of the object as a
   * reference, if the object has no 'metaid' attribute value set, then the
   * {@link CVTerm} will not be added.
   <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addCVTerm(CVTerm term, boolean newBag) {
    return libsbmlJNI.SBase_addCVTerm__SWIG_0(swigCPtr, this, CVTerm.getCPtr(term), term, newBag);
  }

  
/**
   * Adds a copy of the given {@link CVTerm} object to this SBML object.
   <p>
   * @param term the {@link CVTerm} to assign.
   <p>
   * @param newBag if <code>true</code>, creates a new RDF bag with the same identifier
   * as a previous bag, and if <code>false</code>, adds the term to an existing
   * RDF bag with the same type of qualifier as the term being added.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}, if
   * this object lacks a 'metaid' attribute
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @note Since the CV Term uses the 'metaid' attribute of the object as a
   * reference, if the object has no 'metaid' attribute value set, then the
   * {@link CVTerm} will not be added.
   <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addCVTerm(CVTerm term) {
    return libsbmlJNI.SBase_addCVTerm__SWIG_1(swigCPtr, this, CVTerm.getCPtr(term), term);
  }

  
/**
   * Returns a list of {@link CVTerm} objects in the annotations of this SBML
   * object.
   <p>
   * @return the list of CVTerms for this SBML object.
   */ public
  CVTermList  getCVTerms() { 
  long cPtr = libsbmlJNI.SBase_getCVTerms__SWIG_0(swigCPtr, this);
  return (cPtr == 0) ? null : new  CVTermList(cPtr, true);
}

  
/**
   * Returns the number of {@link CVTerm} objects in the annotations of this SBML
   * object.
   <p>
   * @return the number of CVTerms for this SBML object.
   */ public
 long getNumCVTerms() {
    return libsbmlJNI.SBase_getNumCVTerms(swigCPtr, this);
  }

  
/**
   * Returns the nth {@link CVTerm} in the list of CVTerms of this SBML
   * object.
   <p>
   * @param n long the index of the {@link CVTerm} to retrieve.
   <p>
   * @return the nth {@link CVTerm} in the list of CVTerms for this SBML object.
   * If the index <code>n</code> is invalid, <code>null</code> is returned.
   */ public
 CVTerm getCVTerm(long n) {
    long cPtr = libsbmlJNI.SBase_getCVTerm(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CVTerm(cPtr, false);
  }

  
/**
   * Clears the list of {@link CVTerm} objects attached to this SBML object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetCVTerms() {
    return libsbmlJNI.SBase_unsetCVTerms(swigCPtr, this);
  }

  
/**
   * Unsets the {@link ModelHistory} object attached to this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */ public
 int unsetModelHistory() {
    return libsbmlJNI.SBase_unsetModelHistory(swigCPtr, this);
  }

  
/**
   * Returns the MIRIAM <em>biological qualifier</em> associated with the
   * given resource.
   <p>
   * In <a target='_blank' href='http://biomodels.net/miriam'>MIRIAM</a>,
   * qualifiers are an optional means of indicating the relationship
   * between a model component and its annotations.  There are two broad
   * kinds of annotations: <em>model</em> and <em>biological</em>.  The
   * latter kind is used to qualify the relationship between a model
   * component and a biological entity which it represents.  Examples of
   * relationships include 'is' and 'has part', but many others are
   * possible.  MIRIAM defines <a target='_blank'
   * href='http://www.ebi.ac.uk/miriam/main/qualifiers/'>numerous
   * relationship qualifiers</a> to enable different software tools to
   * qualify biological annotations in the same standardized way.  In
   * libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
   * element are represented using lists of {@link CVTerm} objects, and the
   * the MIRIAM biological qualifiers are represented using
   * values whose
   * names begin with <code>BQB_</code> in the interface class
   * {@link libsbmlConstants}.
   <p>
   * This method searches the controlled-vocabulary annotations
   * (i.e., the list of {@link CVTerm} objects) on the present object, then out of
   * those that have biological qualifiers, looks for an annotation to the
   * given <code>resource</code>.  If such an annotation is found, it returns the
   * type of biological qualifier associated with that resource as a 
   * value whose name
   * begins with <code>BQB_</code> from the interface
   * class {@link libsbmlConstants}.
   <p>
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   <p>
   * @return the qualifier associated with the resource,
   * or {@link libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN} if the
   * resource does not exist.
   <p>
   * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQB_</code> constants defined in {@link libsbmlConstants}
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   */ public
 int getResourceBiologicalQualifier(String resource) {
    return libsbmlJNI.SBase_getResourceBiologicalQualifier(swigCPtr, this, resource);
  }

  
/**
   * Returns the MIRIAM <em>model qualifier</em> associated with the
   * given resource.
   <p>
   * In <a target='_blank' href='http://biomodels.net/miriam'>MIRIAM</a>,
   * qualifiers are an optional means of indicating the relationship
   * between a model component and its annotations.  There are two broad
   * kinds of annotations: <em>model</em> and <em>biological</em>.  The
   * former kind is used to qualify the relationship between a model
   * component and another modeling object.  An example qualifier is
   * 'isDerivedFrom', to indicate that a given component of the model is
   * derived from the modeling object represented by the referenced
   * resource.  MIRIAM defines <a target='_blank'
   * href='http://www.ebi.ac.uk/miriam/main/qualifiers/'>numerous
   * relationship qualifiers</a> to enable different software tools to
   * qualify model annotations in the same standardized way.  In libSBML,
   * the MIRIAM controlled-vocabulary annotations on an SBML model element
   * are represented using lists of {@link CVTerm} objects, and the 
   * the MIRIAM model qualifiers are represented using
   * values whose
   * names begin with <code>BQM_</code> in the interface class
   * {@link libsbmlConstants}.
   <p>
   * This method method searches the controlled-vocabulary annotations
   * (i.e., the list of {@link CVTerm} objects) on the present object, then out of
   * those that have model qualifiers, looks for an annotation to the given
   * <code>resource</code>.  If such an annotation is found, it returns the type of
   * type of model qualifier associated with that resource as a 
   * value whose name
   * begins with <code>BQM_</code> from the interface
   * class {@link libsbmlConstants}.
   <p>
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   <p>
   * @return the model qualifier
   * type associated with the resource, or {@link libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN} if the resource does not exist.
   <p>
   * @note The set of MIRIAM model qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQM_</code> constants defined in {@link libsbmlConstants}
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   */ public
 int getResourceModelQualifier(String resource) {
    return libsbmlJNI.SBase_getResourceModelQualifier(swigCPtr, this, resource);
  }

  
/**
   * Returns the {@link Model} object for the SBML Document in which the current object is located.
   <p>
   * @return the {@link Model} object for the SBML Document of this SBML object.
   <p>
   * @see #getParentSBMLObject()
   * @see #getSBMLDocument()
   */ public
 Model getModel() {
    long cPtr = libsbmlJNI.SBase_getModel(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
/**
   * Returns the SBML Level of the {@link SBMLDocument} object containing <em>this</em>
   * object.
   <p>
   * <p>
 * LibSBML uses the class {@link SBMLDocument} as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * {@link SBMLDocument} object.  {@link SBMLDocument} corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
   <p>
   * @return the SBML level of this SBML object.
   <p>
   * @see #getVersion()
   * @see #getNamespaces()
   * @see #getPackageVersion()
   */ public
 long getLevel() {
    return libsbmlJNI.SBase_getLevel(swigCPtr, this);
  }

  
/**
   * Returns the Version within the SBML Level of the {@link SBMLDocument} object
   * containing <em>this</em> object.
   <p>
   * <p>
 * LibSBML uses the class {@link SBMLDocument} as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * {@link SBMLDocument} object.  {@link SBMLDocument} corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
   <p>
   * @return the SBML version of this SBML object.
   <p>
   * @see #getLevel()
   * @see #getNamespaces()
   */ public
 long getVersion() {
    return libsbmlJNI.SBase_getVersion(swigCPtr, this);
  }

  
/**
  * Returns the SBML Core Version within the SBML Level of the actual object.
  <p>
  * <p>
 * LibSBML uses the class {@link SBMLDocument} as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * {@link SBMLDocument} object.  {@link SBMLDocument} corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
  <p>
  * @return the SBML core version of this SBML object.
  */ public
 long getPackageCoreVersion() {
    return libsbmlJNI.SBase_getPackageCoreVersion(swigCPtr, this);
  }

  
/**
   * Returns the Version of the SBML Level&nbsp;3 package to which this
   * element belongs to.
   <p>
   * @return the version of the SBML Level&nbsp;3 package to which this
   * element belongs. The value <code>0</code> will be returned if this element
   * belongs to the SBML Level&nbsp;3 Core package.
   <p>
   * @see #getLevel()
   * @see #getVersion()
   */ public
 long getPackageVersion() {
    return libsbmlJNI.SBase_getPackageVersion(swigCPtr, this);
  }

  
/**
   * Returns the name of the SBML Level&nbsp;3 package in which this element
   * is defined.
   <p>
   * @return the name of the SBML package in which this element is defined.
   * The string <code>&quot;core&quot;</code> will be returned if this
   * element is defined in SBML Level&nbsp;3 Core. The string
   * <code>&quot;unknown&quot;</code> will be returned if this element is
   * not defined in any SBML package.
   */ public
 String getPackageName() {
    return libsbmlJNI.SBase_getPackageName(swigCPtr, this);
  }

  
/**
   * Returns the libSBML type code for this object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>{@link SBase#getPackageName()}
 * </code>
 * method on the object.
 <p>
 * The exception to this is lists:  all SBML-style list elements have the type 
 * {@link libsbmlConstants#SBML_LIST_OF SBML_LIST_OF}, regardless of what package they 
 * are from.
   <p>
   * <p>
 * Here follow some additional general information about libSBML type codes:
 <p>
 * <ul>
 * <li> The codes are the possible return values (integers) for the following
 * functions:
 * <ul>
 *     <li> {@link SBase#getTypeCode()}
 *     <li> {@link ListOf#getItemTypeCode()}
 * </ul>
 * (Compatibility note: in libSBML 5, the type of return values of these
 * functions changed from an enumeration to an integer for extensibility
 * in the face of different programming languages.)
 <p>
 * <li> Each package extension must define similar sets of values for each
 * {@link SBase} subclass (e.g. <code>SBMLLayoutTypeCode_t</code> for the SBML Level&nbsp;3
 * Layout extension, <code>SBMLFbcTypeCode_t</code> for the SBML Level&nbsp;3 Flux
 * Balance Constraints extension, etc.).
 <p>
 * <li> The value of each package-specific type code can be duplicated between
 * those of different packages.  (This is necessary because the development
 * of libSBML extensions for different SBML packages may be undertaken by
 * different developers at different times; requiring the developers to
 * coordinate their use of type codes would be nettlesome and probably
 * doomed to failure.)
 <p>
 * <li> To distinguish between the type codes of different packages, both the
 * return value of {@link SBase#getTypeCode()} and {@link SBase#getPackageName()} must be
 * checked.  This is particularly important for functions that take an SBML
 * type code as an argument, such as
 * {@link SBase#getAncestorOfType(int, String)}, which by
 * default assumes you are handing it a core type, and will return <code>null</code> if
 * the value you give it is actually from a package.
 *
 * </ul> <p>
 * The following example code illustrates the combined use of
 * {@link SBase#getPackageName()} and {@link SBase#getTypeCode()}:
 <p>
<pre class='fragment'>
void example (SBase sb)
{
  String pkgName = sb.getPackageName();
  if (pkgName.equals('core'))
  {
    switch (sb.getTypeCode())
    {
      case libsbml.SBML_MODEL:
         ....
         break;
      case libsbml.SBML_REACTION:
         ....
    }
  }
  else if (pkgName.equals('layout'))
  {
    switch (sb.getTypeCode())
    {
      case libsbml.SBML_LAYOUT_LAYOUT:
         ....
         break;
      case libsbml.SBML_LAYOUT_REACTIONGLYPH:
         ....
    }
  }
  ...
}
</pre>
   <p>
   * @return the SBML object type
   * code of this SBML object, or {@link libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (the default).  The latter is possible because
   * subclasses of {@link SBase} are not required to implement this method to return
   * a type code.
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * {@link ListOf#getItemTypeCode()}).</span>
   <p>
   * @see #getPackageName()
   * @see #getElementName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.SBase_getTypeCode(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this object's level/version and namespace
   * values correspond to a valid SBML specification.
   <p>
   * The valid combinations of SBML Level, Version and Namespace as of this
   * release of libSBML are the following:
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level1</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;1: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;2: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version2</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;3: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version3</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;4: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version4</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;5: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version5</code>&quot;
   * <li> Level&nbsp;3 Version&nbsp;1 Core: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version1/core</code>&quot;
   * <li> Level&nbsp;3 Version&nbsp;2 Core: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version2/core</code>&quot;
   * </ul>
   <p>
   * @return <code>true</code> if the level, version and namespace values of this 
   * SBML object correspond to a valid set of values, <code>false</code> otherwise.
   */ public
 boolean hasValidLevelVersionNamespaceCombination() {
    return libsbmlJNI.SBase_hasValidLevelVersionNamespaceCombination(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object.
   <p>
   * This is overridden by subclasses to return a string appropriate to the
   * SBML component.  For example, {@link Model} defines it as returning
   * <code>'model'</code>, {@link CompartmentType} defines it as returning <code>'compartmentType'</code>,
   * and so on.
   */ public
 String getElementName() {
    return libsbmlJNI.SBase_getElementName(swigCPtr, this);
  }

  
/**
   * Returns a string consisting of a partial SBML corresponding to just
   * this object.
   <p>
   * @return the partial SBML that describes this SBML object.
   <p>
   * @warning <span class='warning'>This is primarily provided for testing
   * and debugging purposes.  It may be removed in a future version of
   * libSBML.</span>
   */ public
 String toSBML() {
    return libsbmlJNI.SBase_toSBML(swigCPtr, this);
  }

  
/**
   * Returns this element as an {@link XMLNode}.
   <p>
   * @return this element as an {@link XMLNode}.
   <p>
   * @warning <span class='warning'>This operation is computationally
   * expensive, because the element has to be fully serialized to a string
   * and then parsed into the {@link XMLNode} structure.  Attempting to convert a
   * large tree structure (e.g., a large {@link Model}) may consume significant
   * computer memory and time.</span>
   */ public
 XMLNode toXMLNode() {
    long cPtr = libsbmlJNI.SBase_toXMLNode(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
/**
   * Reads (initializes) this SBML object by reading from the given {@link XMLNode}.
   <p>
   * @param node the {@link XMLNode} to read from.
   <p>
   * @param flag an optional flag that determines how how errors are logged
   * during the reading process.
   <p>
   * @warning <span class='warning'>This method is computationally expensive,
   * because the given node has to be serialized to a string first.
   * Attempting to serialize a large tree structure (e.g., a large {@link Model}) may
   * consume significant computer memory and time.</span>
   */ public
 void read(XMLNode node, int flag) {
    libsbmlJNI.SBase_read__SWIG_0(swigCPtr, this, XMLNode.getCPtr(node), node, flag);
  }

  
/**
   * Reads (initializes) this SBML object by reading from the given {@link XMLNode}.
   <p>
   * @param node the {@link XMLNode} to read from.
   <p>
   * @param flag an optional flag that determines how how errors are logged
   * during the reading process.
   <p>
   * @warning <span class='warning'>This method is computationally expensive,
   * because the given node has to be serialized to a string first.
   * Attempting to serialize a large tree structure (e.g., a large {@link Model}) may
   * consume significant computer memory and time.</span>
   */ public
 void read(XMLNode node) {
    libsbmlJNI.SBase_read__SWIG_1(swigCPtr, this, XMLNode.getCPtr(node), node);
  }

  
/**
   * Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension with the given package name or URI.
   * The returned plug-in will be the appropriate type of plugin requested:
   * calling {@link Model#getPlugin('fbc')} will return an FbcModelPlugin; calling
   * {@link Parameter#getPlugin('comp')} will return CompSBasePlugin, etc.
   <p>
   * If no such plugin exists, null is returned.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * @param package the name or URI of the package.
   <p>
   * @return the plug-in object (the libSBML extension interface) of
   * a package extension with the given package name or URI.
   <p>
   * @see #getPlugin(long n)
   */ public
 SBasePlugin getPlugin(String _package) {
	return libsbml.DowncastSBasePlugin(libsbmlJNI.SBase_getPlugin__SWIG_0(swigCPtr, this, _package), false);
}

  
/**
   * Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension.
   * The returned plug-in will be the appropriate type of plugin requested:
   * calling {@link Model#getPlugin('fbc')} will return an FbcModelPlugin; calling
   * {@link Parameter#getPlugin('comp')} will return CompSBasePlugin, etc.
   <p>
   * If no such plugin exists, null is returned.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * @param n the index of the plug-in to return.
   <p>
   * @return the nth plug-in object (the libSBML extension interface) of a
   * package extension.
   * If the index <code>n</code> is invalid, <code>null</code> is returned.
   <p>
   * @see #getNumPlugins()
   * @see #getPlugin(String package)
   */ public
 SBasePlugin getPlugin(long n) {
	return libsbml.DowncastSBasePlugin(libsbmlJNI.SBase_getPlugin__SWIG_2(swigCPtr, this, n), false);
}

  
/**
   * Returns the nth disabled plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension.  If no such plugin exists, null is returned.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * <p>
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
   <p>
   * @param n the index of the disabled plug-in to return.
   <p>
   * @return the nth disabled plug-in object (the libSBML extension interface) of a
   * package extension.
   * If the index <code>n</code> is invalid, <code>null</code> is returned.
   <p>
   * @see #getNumDisabledPlugins()
   * @see #getPlugin(String package)
   */ public
 SBasePlugin getDisabledPlugin(long n) {
	return libsbml.DowncastSBasePlugin(libsbmlJNI.SBase_getDisabledPlugin__SWIG_0(swigCPtr, this, n), false);
}

  
/**
   * Returns the number of plug-in objects (extenstion interfaces) for SBML
   * Level&nbsp;3 package extensions known.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * @return the number of plug-in objects (extension interfaces) of
   * package extensions known by this instance of libSBML.
   <p>
   * @see #getPlugin(long n)
   */ public
 long getNumPlugins() {
    return libsbmlJNI.SBase_getNumPlugins(swigCPtr, this);
  }

  
/**
   * Returns the number of disabled plug-in objects (extension interfaces) 
   * for SBML Level&nbsp;3 package extensions known.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * <p>
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
   <p>
   * @return the number of disabled plug-in objects (extension interfaces) 
   * of package extensions known by this instance of libSBML.
   */ public
 long getNumDisabledPlugins() {
    return libsbmlJNI.SBase_getNumDisabledPlugins(swigCPtr, this);
  }

  
/**
   * Deletes all information stored in disabled plugins.  If the plugin is 
   * re-enabled later, it will then not have any previously-stored information.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * <p>
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
   <p>
   * @param recursive if <code>true</code>, the disabled information will be deleted
   * also from all child elements, otherwise only from this {@link SBase} element.
   <p>
   * @see #getNumDisabledPlugins()
   */ public
 void deleteDisabledPlugins(boolean recursive) {
    libsbmlJNI.SBase_deleteDisabledPlugins__SWIG_0(swigCPtr, this, recursive);
  }

  
/**
   * Deletes all information stored in disabled plugins.  If the plugin is 
   * re-enabled later, it will then not have any previously-stored information.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * <p>
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
   <p>
   * @param recursive if <code>true</code>, the disabled information will be deleted
   * also from all child elements, otherwise only from this {@link SBase} element.
   <p>
   * @see #getNumDisabledPlugins()
   */ public
 void deleteDisabledPlugins() {
    libsbmlJNI.SBase_deleteDisabledPlugins__SWIG_1(swigCPtr, this);
  }

  
/**
   * Enables or disables the given SBML Level&nbsp;3 package on this object.
   <p>
   * This method enables the specified package on this object and other
   * objects connected by child-parent links in the same {@link SBMLDocument} object.
   * This method is the converse of
   * {@link SBase#disablePackage(String pkgURI, String pkgPrefix)}.
   <p>
   * @param pkgURI the URI of the package.
   <p>
   * @param pkgPrefix the XML prefix of the package.
   <p>
   * @param flag whether to enable (<code>true</code>) or disable (<code>false</code>) the package.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION}
   *
   * </ul> <p>
   * @see #disablePackage(String pkgURI, String pkgPrefix)
   */ public
 int enablePackage(String pkgURI, String pkgPrefix, boolean flag) {
    return libsbmlJNI.SBase_enablePackage(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
/**
   * Disables the given SBML Level&nbsp;3 package on this object.
   <p>
   * This method disables the specified package on this object
   * and other objects connected by child-parent links in the same
   * {@link SBMLDocument} object.
   <p>
   * An example of when this may be useful is during construction of model
   * components when mixing existing and new models.  Suppose your
   * application read an SBML document containing a model that used the SBML
   * Hierarchical Model Composition (&ldquo;comp&rdquo;) package, and
   * extracted parts of that model in order to construct a new model in
   * memory.  The new, in-memory model will not accept a component drawn from
   * an other {@link SBMLDocument} with different package namespace declarations.
   * You could reconstruct the same namespaces in the in-memory model first,
   * but as a shortcut, you could also disable the package namespace on the
   * object being added.  Here is a code example to help clarify this:
   <p>
<pre class='fragment'>
// We read in an SBML L3V1 model that uses the 'comp' package namespace
{@link SBMLReader} reader = new {@link SBMLReader}();
{@link SBMLDocument} doc = reader.readSBML('sbml-file-with-comp-elements.xml');

// We extract one of the species from the model we just read in.
{@link Species} s1 = doc.getModel().getSpecies(0);

// We construct a new model.  This model does not use the 'comp' package.
{@link Model} newModel = new {@link Model}(3,1);

// The following will fail with an error, because addSpecies() will
// first check that the parent of the given object has namespaces
// declared, and will discover that s1 does but newModel does not.

// newModel-&gt;addSpecies(s1);

// However, if we disable the 'comp' package on s1, then the call
// to addSpecies will work.

s1-&gt;disablePackage('http://www.sbml.org/sbml/level3/version1/comp/version1',
                   'comp');
newModel.addSpecies(s1);
</pre>
<p>
   * @param pkgURI the URI of the package.
   <p>
   * @param pkgPrefix the XML prefix of the package.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION}
   *
   * </ul> <p>
   * @see #enablePackage(String pkgURI, String pkgPrefix, boolean flag)
   */ public
 int disablePackage(String pkgURI, String pkgPrefix) {
    return libsbmlJNI.SBase_disablePackage(swigCPtr, this, pkgURI, pkgPrefix);
  }

  
/** * @internal */ public
 void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.SBase_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
/**
   * Predicate returning <code>true</code> if an SBML Level&nbsp;3 package with the
   * given URI is enabled with this object.
   <p>
   * @param pkgURI the URI of the package.
   <p>
   * @return <code>true</code> if the given package is enabled within this object, @c 
   * false otherwise.
   <p>
   * @see #isPackageEnabled(String)
   */ public
 boolean isPackageURIEnabled(String pkgURI) {
    return libsbmlJNI.SBase_isPackageURIEnabled(swigCPtr, this, pkgURI);
  }

  
/**
   * Predicate returning <code>true</code> if the given SBML Level&nbsp;3 package is
   * enabled with this object.
   <p>
   * The search ignores the package version.
   <p>
   * @param pkgName the name of the package.
   <p>
   * @return <code>true</code> if the given package is enabled within this object,
   * <code>false</code> otherwise.
   <p>
   * @see #isPackageURIEnabled(String)
   */ public
 boolean isPackageEnabled(String pkgName) {
    return libsbmlJNI.SBase_isPackageEnabled(swigCPtr, this, pkgName);
  }

  
/**
   * Predicate returning <code>true</code> if an SBML Level&nbsp;3 package with the
   * given URI is enabled with this object.
   <p>
   * @param pkgURI the URI of the package.
   <p>
   * @return <code>true</code> if the given package is enabled within this object, @c 
   * false otherwise.
   <p>
   * @deprecated <div class='deprecated'>Replaced in libSBML 5.2.0 by
   * {@link SBase#isPackageURIEnabled(String)}.
   * </div>
   <p>
   * @see #isPkgEnabled(String)
   */ public
 boolean isPkgURIEnabled(String pkgURI) {
    return libsbmlJNI.SBase_isPkgURIEnabled(swigCPtr, this, pkgURI);
  }

  
/**
   * Predicate returning <code>true</code> if the given SBML Level&nbsp;3 package is
   * enabled with this object.
   <p>
   * The search ignores the package version.
   <p>
   * @param pkgName the name of the package.
   <p>
   * @return <code>true</code> if the given package is enabled within this object,
   * <code>false</code> otherwise.
   <p>
   * @deprecated <div class='deprecated'>Replaced in libSBML 5.2.0 by
   * {@link SBase#isPackageEnabled(String)}.
   * </div>
   <p>
   * @see #isPkgURIEnabled(String)
   */ public
 boolean isPkgEnabled(String pkgName) {
    return libsbmlJNI.SBase_isPkgEnabled(swigCPtr, this, pkgName);
  }

  
/** * @internal */ public
 void writeExtensionElements(XMLOutputStream stream) {
    libsbmlJNI.SBase_writeExtensionElements(swigCPtr, this, XMLOutputStream.getCPtr(stream), stream);
  }

  
/** * @internal */ public
 void read(XMLInputStream stream) {
    libsbmlJNI.SBase_read__SWIG_2(swigCPtr, this, XMLInputStream.getCPtr(stream), stream);
  }

  
/** * @internal */ public
 void write(XMLOutputStream stream) {
    libsbmlJNI.SBase_write(swigCPtr, this, XMLOutputStream.getCPtr(stream), stream);
  }

  
/** * @internal */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.SBase_hasRequiredAttributes(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean hasRequiredElements() {
    return libsbmlJNI.SBase_hasRequiredElements(swigCPtr, this);
  }

  
/** * @internal */ public
 int checkCompatibility(SBase object) {
    return libsbmlJNI.SBase_checkCompatibility(swigCPtr, this, SBase.getCPtr(object), object);
  }

  
/** * @internal */ public
 void setSBMLNamespacesAndOwn(SBMLNamespaces disownedNs) {
    libsbmlJNI.SBase_setSBMLNamespacesAndOwn(swigCPtr, this, SBMLNamespaces.getCPtrAndDisown(disownedNs), disownedNs);
  }

  
/** * @internal */ public
 SBMLNamespaces getSBMLNamespaces() {
  return libsbml.DowncastSBMLNamespaces(libsbmlJNI.SBase_getSBMLNamespaces(swigCPtr, this), false);
}

  
/** * @internal */ public
 void removeDuplicateAnnotations() {
    libsbmlJNI.SBase_removeDuplicateAnnotations(swigCPtr, this);
  }

  
/** * @internal */ public
 String checkMathMLNamespace(XMLToken elem) {
    return libsbmlJNI.SBase_checkMathMLNamespace(swigCPtr, this, XMLToken.getCPtr(elem), elem);
  }

  
/** * @internal */ public
 UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.SBase_getDerivedUnitDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/** * @internal */ public
 boolean containsUndeclaredUnits() {
    return libsbmlJNI.SBase_containsUndeclaredUnits(swigCPtr, this);
  }

  
/**
   * Removes this object from its parent.
   <p>
   * If the parent was storing this object as a pointer, it is deleted.  If
   * not, it is simply cleared (as in {@link ListOf} objects).  This is a pure
   * virtual method, as every {@link SBase} element has different parents, and
   * therefore different methods of removing itself.  Will fail (and not
   * delete itself) if it has no parent object.  This function is designed to
   * be overridden, but for all objects whose parent is of the class {@link ListOf},
   * the default implementation will work.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int removeFromParentAndDelete() {
    return libsbmlJNI.SBase_removeFromParentAndDelete(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this object's set of XML namespaces are the same
   * as the given object's XML namespaces.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * @param sb an object to compare with respect to namespaces.
   <p>
   * @return boolean, <code>true</code> if this object's collection of namespaces is
   * the same as <code>sb's</code>, <code>false</code> otherwise.
   */ public
 boolean matchesSBMLNamespaces(SBase sb) {
    return libsbmlJNI.SBase_matchesSBMLNamespaces__SWIG_0(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
/**
   * Returns <code>true</code> if this object's set of XML namespaces are a subset
   * of the given object's XML namespaces.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * @param sb an object to compare with respect to namespaces.
   <p>
   * @return boolean, <code>true</code> if this object's collection of namespaces is
   * a subset of <code>sb's</code>, <code>false</code> otherwise.
   */ public
 boolean matchesRequiredSBMLNamespacesForAddition(SBase sb) {
    return libsbmlJNI.SBase_matchesRequiredSBMLNamespacesForAddition__SWIG_0(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
/**
   * Predicate returning true or false depending on whether
   * the user data of this element has been set.
   <p>
   * <p>
 * The user data associated with an SBML object can be used by an application
 * developer to attach custom information to that object in the model.  In case
 * of a deep copy, this data will passed as-is.  The data attribute will never
 * be interpreted by libSBML.
   <p>
   * @return boolean, <code>true</code> if this object's user data has been set,
   * <code>false</code> otherwise.
   */ public
 boolean isSetUserData() {
    return libsbmlJNI.SBase_isSetUserData(swigCPtr, this);
  }

  
/**
   * Unsets the user data of this element.
   <p>
   * <p>
 * The user data associated with an SBML object can be used by an application
 * developer to attach custom information to that object in the model.  In case
 * of a deep copy, this data will passed as-is.  The data attribute will never
 * be interpreted by libSBML.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetUserData() {
    return libsbmlJNI.SBase_unsetUserData(swigCPtr, this);
  }

  
/**
   * Returns the namespace URI to which this element belongs to.
   <p>
   * For example, all elements that belong to SBML Level&nbsp;3 Version&nbsp;1 Core
   * must would have the URI <code>'http://www.sbml.org/sbml/level3/version1/core'</code>;
   * all elements that belong to Layout Extension Version 1 for SBML Level&nbsp;3
   * Version&nbsp;1 Core must would have the URI
   * <code>'http://www.sbml.org/sbml/level3/version1/layout/version1'</code>.
   <p>
   * This function first returns the URI for this element by looking into the
   * {@link SBMLNamespaces} object of the document with the its package name.  If not
   * found, it will then look for the namespace associated with the element
   * itself.
   <p>
   * @return the URI of this element, as a text string.
   <p>
   * @see #getSBMLDocument()
   * @see #getPackageName()
   */ public
 String getURI() {
    return libsbmlJNI.SBase_getURI(swigCPtr, this);
  }

  
/**
   * Returns the XML namespace prefix of this element.
   <p>
   * This reports the XML namespace prefix chosen for this class of object in
   * the current SBML document.  This may be an empty string if the component
   * has no explicit prefix (for instance, if it is a core SBML object placed
   * in the default SBML namespace of the document).  If it is not empty, then
   * it corresponds to the XML namespace prefix used set the object, whatever
   * that may be in a given SBML document.
   <p>
   * @return a text string representing the XML namespace prefix.
   */ public
 String getPrefix() {
    return libsbmlJNI.SBase_getPrefix(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean hasOptionalAttributes() {
    return libsbmlJNI.SBase_hasOptionalAttributes(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean hasOptionalElements() {
    return libsbmlJNI.SBase_hasOptionalElements(swigCPtr, this);
  }

  
/** * @internal */ public
 void updateSBMLNamespace(String _package, long level, long version) {
    libsbmlJNI.SBase_updateSBMLNamespace(swigCPtr, this, _package, level, version);
  }

  
  /**
   * Returns an {@link SBaseList} of all child {@link SBase} objects,
   * including those nested to an arbitrary depth.
   *
   * @return a pointer to an {@link SBaseList} of pointers to all children objects.
   */
 public SBaseList getListOfAllElements(ElementFilter filter) {
    return new SBaseList(libsbmlJNI.SBase_getListOfAllElements__SWIG_0(swigCPtr, this, ElementFilter.getCPtr(filter), filter), true);
  }

  
  /**
   * Returns an {@link SBaseList} of all child {@link SBase} objects,
   * including those nested to an arbitrary depth.
   *
   * @return a pointer to an {@link SBaseList} of pointers to all children objects.
   */
 public SBaseList getListOfAllElements() {
    return new SBaseList(libsbmlJNI.SBase_getListOfAllElements__SWIG_1(swigCPtr, this), true);
  }

  
  /**
   * Returns an {@link SBaseList} of all child {@link SBase} objects
   * contained in SBML package plugins.
   *
   * This method walks down the list of all packages used by the model and
   * returns all objects contained in them.
   *
   * @return a pointer to a {@link SBaseList} of pointers to all children
   * objects from plugins.
   */
 public SBaseList getListOfAllElementsFromPlugins(ElementFilter filter) {
    return new SBaseList(libsbmlJNI.SBase_getListOfAllElementsFromPlugins__SWIG_0(swigCPtr, this, ElementFilter.getCPtr(filter), filter), true);
  }

  
  /**
   * Returns an {@link SBaseList} of all child {@link SBase} objects
   * contained in SBML package plugins.
   *
   * This method walks down the list of all packages used by the model and
   * returns all objects contained in them.
   *
   * @return a pointer to a {@link SBaseList} of pointers to all children
   * objects from plugins.
   */
 public SBaseList getListOfAllElementsFromPlugins() {
    return new SBaseList(libsbmlJNI.SBase_getListOfAllElementsFromPlugins__SWIG_1(swigCPtr, this), true);
  }

}
