/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  An SBML compartment, where species are located.
 <p>
 * A compartment in SBML represents a bounded space in which species are
 * located.  Compartments do not necessarily have to correspond to actual
 * structures inside or outside of a biological cell.
 <p>
 * It is important to note that although compartments are optional in the
 * overall definition of {@link Model}, every species in an SBML model must be
 * located in a compartment.  This in turn means that if a model defines
 * any species, the model must also define at least one compartment.  The
 * reason is simply that species represent physical things, and therefore
 * must exist <em>somewhere</em>.  Compartments represent the <em>somewhere</em>.
 <p>
 * {@link Compartment} has one required attribute, 'id', to give the compartment a
 * unique identifier by which other parts of an SBML model definition can
 * refer to it.  A compartment can also have an optional 'name' attribute
 * of type <code>string.</code>  Identifiers and names must be used according to the
 * guidelines described in the SBML specifications.
 <p>
 * {@link Compartment} also has an optional attribute 'spatialDimensions' that is
 * used to indicate the number of spatial dimensions possessed by the
 * compartment.  Most modeling scenarios involve compartments with integer
 * values of 'spatialDimensions' of <code>3</code> (i.e., a three-dimensional
 * compartment, which is to say, a volume), or 2 (a two-dimensional
 * compartment, a surface), or <code>1</code> (a one-dimensional compartment, a
 * line).  In SBML Level&nbsp;3, the type of this attribute is <code>double</code>,
 * there are no restrictions on the permitted values of the
 * 'spatialDimensions' attribute, and there are no default values.  In SBML
 * Level&nbsp;2, the value must be a positive <code>integer</code>, and the default
 * value is <code>3</code>; the permissible values in SBML Level&nbsp;2 are <code>3</code>,
 * <code>2</code>, <code>1</code>, and <code>0</code> (for a point).
 <p>
 * Another optional attribute on {@link Compartment} is 'size', representing the 
 * <em>initial</em> total size of that compartment in the model.  The 'size' attribute
 * must be a floating-point value and may represent a volume (if the
 * compartment is a three-dimensional one), or an area (if the compartment is
 * two-dimensional), or a length (if the compartment is one-dimensional).
 * There is no default value of compartment size in SBML Level&nbsp;2 or
 * Level&nbsp;3.  In particular, a missing 'size' value <em>does not imply
 * that the compartment size is 1</em>.  (This is unlike the definition of
 * compartment 'volume' in SBML Level&nbsp;1.)  When the compartment's
 * 'spatialDimensions' attribute does not have a value of <code>0</code>, a missing
 * value of 'size' for a given compartment signifies that the value either is
 * unknown, or to be obtained from an external source, or determined by an
 * {@link InitialAssignment}, {@link AssignmentRule}, {@link AlgebraicRule} or {@link RateRule}
 * object elsewhere in the model.  In SBML
 * Level&nbsp;2, there are additional special requirements on the values of
 * 'size'; we discuss them in a <a href='#comp-l2'>separate section
 * below</a>.
 <p>
 * The units associated with a compartment's 'size' attribute value may be
 * set using the optional attribute 'units'.  The rules for setting and
 * using compartment size units differ between SBML Level&nbsp;2 and
 * Level&nbsp;3, and are discussed separately below.
 <p>
 * Finally, the {@link Compartment} attribute named 'constant' is used to
 * indicate whether the compartment's size stays constant after simulation
 * begins.  A value of <code>true</code> indicates the compartment's 'size' cannot be
 * changed by any other construct except {@link InitialAssignment}; a value of
 * <code>false</code> indicates the compartment's 'size' can be changed by other
 * constructs in SBML.  In SBML Level&nbsp;2, there is an additional
 * explicit restriction that if 'spatialDimensions'=<code>'0'</code>, the value
 * cannot be changed by {@link InitialAssignment} either.  Further, in
 * Level&nbsp;2, 'constant' is optional, and has a default value of <code>true.</code>  In SBML
 * Level&nbsp;3, there is no default value for the 'constant' attribute,
 * and it is required.
 <p>
 * <h2>Additional considerations in SBML Level&nbsp;2</h2>
 <p>
 * In SBML Level&nbsp;2, the default units of compartment size, and the kinds
 * of units allowed as values of the attribute 'units', interact with the
 * number of spatial dimensions of the compartment.  The value of the 'units'
 * attribute of a {@link Compartment} object must
 * be one of the base units (see {@link Unit}), or the predefined unit identifiers
 * <code>volume</code>, <code>area</code>, <code>length</code> or <code>dimensionless</code>, or a new unit defined by a
 * {@link UnitDefinition} object in the enclosing
 * {@link Model}, subject to the restrictions detailed in the following table:
 <p>
 * <table border='0' class='centered text-table width80 normal-font alt-row-colors'
 *        style='padding-bottom: 0.5em'>
 * <caption class='top-caption'>Restrictions on values permitted for
 * compartment <code>size</code> and <code>units</code> attributes.</caption>
 *  <tr>
 *      <th align='left' valign='bottom'>
 *        Value of<br><code>spatialDimensions</code>
 *      </th>
 *      <th align='left' valign='bottom'>
 *        <code>size</code><br>allowed?
 *      </th>
 *      <th align='left' valign='bottom'>
 *        <code>units</code><br>allowed?
 *      </th>
 *      <th align='left' valign='bottom'>
 * 	  Allowable kinds of units
 *      </th>
 *      <th align='left' valign='bottom'>
 * 	  Default value of attribute <code>units</code>
 *      </th>
 *  </tr>
 *  <tr>
 *      <td><code>3</code></td>
 *      <td>yes</td>
 *      <td>yes</td>
 *      <td>units of volume, or <code>dimensionless</code></td>
 *      <td><code>volume</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>2</code></td>
 *      <td>yes</td>
 *      <td>yes</td>
 *      <td>units of area, or <code>dimensionless</code></td>
 *      <td><code>area</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>1</code></td>
 *      <td>yes</td>
 *      <td>yes</td>
 *      <td>units of length, or <code>dimensionless</code></td>
 *      <td><code>length</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>0</code></td>
 *      <td>no</td>
 *      <td>no</td>
 *      <td>(no units allowed)</td>
 *      <td></td>
 *  </tr>
 *  </tr>
 * </table>
 <p>
 * In SBML Level&nbsp;2, the units of the compartment size, as defined by the
 * 'units' attribute or (if 'units' is not set) the default value listed in
 * the table above, are used in the following ways when the compartment has
 * a 'spatialDimensions' value greater than <code>0:</code>
 * <ul>
 * <li> The value of the 'units' attribute is used as the units of the
 * compartment identifier when the identifier appears as a numerical
 * quantity in a mathematical formula expressed in MathML.
 <p>
 * <li> The <code>math</code> element of an {@link AssignmentRule} or {@link InitialAssignment}
 * referring to this compartment <em>must</em> (in Level&nbsp;2 Versions&nbsp;1-3)
 * or <em>should</em> (in Level&nbsp;2 Version 4) have identical units.
 <p>
 * <li> In {@link RateRule} objects that set the rate of change of the compartment's
 * size, the units of the rule's <code>math</code> element <em>must</em> (in Level&nbsp;2 
 * Versions&nbsp;1&ndash;3) or <em>should</em> (in Level&nbsp;2 Version 4) be identical to the
 * compartment's units (whether defined by the 'units' attribute or by taking the 
 * default value from the {@link Model}) divided by the default <em>time</em> units.
 * (In other words, the units for the rate of change of compartment size
 * are <em>compartment size</em>/<em>time</em> units.
 <p>
 * <li> When a {@link Species} is to be treated in terms of concentrations or
 * density, the units of the spatial size portion of the concentration
 * value (i.e., the denominator in the units formula <em>substance</em>/
 * <em>size</em>) are those indicated by the value of the 'units' attribute on the
 * compartment in which the species is located.
 * </ul>
 <p>
 * Compartments with 'spatialDimensions'=<code>0</code> require special treatment in
 * this framework.  As implied above, the 'size' attribute must not have a
 * value on an SBML Level&nbsp;2 {@link Compartment}
 * object if the 'spatialDimensions'
 * attribute has a value of <code>0.</code>  An additional related restriction is that
 * the 'constant' attribute must default to or be set to <code>true</code> if the value
 * of the 'spatialDimensions' attribute is <code>0</code>, because a zero-dimensional
 * compartment cannot ever have a size.
 <p>
 * If a compartment has no size or dimensional units, how should such a
 * compartment's identifier be interpreted when it appears in mathematical
 * formulas?  The answer is that such a compartment's identifier should not
 * appear in mathematical formulas in the first place&mdash;it has no
 * value, and its value cannot change.  Note also that a zero-dimensional
 * compartment is a point, and species located at points can only be
 * described in terms of amounts, not spatially-dependent measures such as
 * concentration.  Since SBML {@link KineticLaw} formulas are already in terms of
 * <em>substance</em>/<em>time</em> and not (say) <em>concentration</em>/<em>time</em>, volume
 * or other factors in principle are not needed for species located in
 * zero-dimensional compartments.
 <p>
 * Finally, in SBML Level&nbsp;2 Versions 2&ndash;4, each compartment in a
 * model may optionally be designated as belonging to a particular
 * compartment <em>type</em>.  The optional attribute 'compartmentType' is used
 * identify the compartment type represented by the {@link Compartment} structure.
 * The 'compartmentType' attribute's value must be the identifier of a
 * {@link CompartmentType} instance defined in the model.  If the 'compartmentType'
 * attribute is not present on a particular compartment definition, a
 * unique virtual compartment type is assumed for that compartment, and no
 * other compartment can belong to that compartment type.  The values of
 * 'compartmentType' attributes on compartments have no effect on the
 * numerical interpretation of a model.  Simulators and other numerical
 * analysis software may ignore 'compartmentType' attributes.  The
 * 'compartmentType' attribute and the {@link CompartmentType}
 * class of objects are
 * not present in SBML Level&nbsp;3 Core nor in SBML Level&nbsp;1.
 <p>
 * <h2>Additional considerations in SBML Level&nbsp;3</h2>
 <p>
 * One difference between SBML Level&nbsp;3 and lower Levels of SBML is
 * that there are no restrictions on the permissible values of the
 * 'spatialDimensions' attribute, and there is no default value defined for
 * the attribute.  The value of 'spatialDimensions' does not have to be an
 * integer, either; this is to allow for the possibility of representing
 * structures with fractal dimensions.
 <p>
 * The number of spatial dimensions possessed by a compartment cannot enter
 * into mathematical formulas, and therefore cannot directly alter the
 * numerical interpretation of a model.  However, the value of
 * 'spatialDimensions' <em>does</em> affect the interpretation of the units
 * associated with a compartment's size.  Specifically, the value of
 * 'spatialDimensions' is used to select among the {@link Model} attributes
 * 'volumeUnits', 'areaUnits' and 'lengthUnits' when a {@link Compartment}
 * structure does not define a value for its
 * 'units' attribute.
 <p>
 * The 'units' attribute may be left unspecified for a given compartment in a
 * model; in that case, the compartment inherits the unit of measurement
 * specified by one of the attributes on the enclosing {@link Model}
 * object instance.  The applicable
 * attribute on {@link Model} depends on the value of the compartment's
 * 'spatialDimensions' attribute; the relationship is shown in the table
 * below.  If the {@link Model} object does not
 * define the relevant attribute ('volumeUnits', 'areaUnits' or
 * 'lengthUnits') for a given 'spatialDimensions' value, the unit associated
 * with that {@link Compartment} object's size is
 * undefined.  If a given {@link Compartment}'s 'units' are left unset and 
 * the 'spatialDimensions' either has a value other than <code>1</code>, <code>2</code>, or 
 * <code>3</code> or is left unset itself (as it has no default value),
 * then no unit can be chosen from among the {@link Model}'s 'volumeUnits',
 * 'areaUnits' or 'lengthUnits' attributes (even if the {@link Model} instance
 * provides values for those attributes), because there is no basis to select
 * between them.
 * Leaving the units of compartments' sizes undefined in an SBML model does
 * not render the model invalid; however, as a matter of best practice, we
 * strongly recommend that all models specify the units of measurement for
 * all compartment sizes.
 <p>
 * <table border='0' class='centered text-table width80 normal-font alt-row-colors'
 *        style='padding-bottom: 0.5em'>
 * <caption class='top-caption'>Interpretation of the {@link Compartment} 'units' attribute.</caption>
 *  <tr>
 *      <th align='left' valign='bottom'>
 *        Value of attribute<br>'spatialDimensions'
 *      </th>
 *      <th align='left' valign='bottom'>
 *        Attribute of {@link Model} used<br>for inheriting the unit
 *      </th>
 *      <th align='left' valign='bottom'>
 *        Recommended candidate units
 *      </th>
 *  </tr>
 *  <tr>
 *      <td><code>3</code></td>
 *      <td>&quot;volumeUnits&quot;</td>
 *      <td>units of volume, or <code>dimensionless</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>2</code></td>
 *      <td>&quot;areaUnits&quot;</td>
 *      <td>units of area, or <code>dimensionless</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>1</code></td>
 *      <td>&quot;lengthUnits&quot;</td>
 *      <td>units of length, or <code>dimensionless</code></td>
 *  </tr>
 *  <tr>
 *      <td><em>other</em></td>
 *      <td><em>no units inherited</em></td>
 *      <td><em>no specific recommendations</em></td>
 *  </tr>
 *  </tr>
 * </table>
 <p>
 * The unit of measurement associated with a compartment's size, as defined
 * by the 'units' attribute or (if 'units' is not set) the inherited value
 * from {@link Model} according to the table above, is used in the following ways:
 <p>
 * <ul>
 <p>
 * <li> When the identifier of the compartment appears as a numerical
 * quantity in a mathematical formula expressed in MathML, it represents
 * the size of the compartment, and the unit associated with the size is
 * the value of the 'units' attribute.
 <p>
 * <li> When a {@link Species} is to be treated in terms of concentrations or
 * density, the unit associated with the spatial size portion of the
 * concentration value (i.e., the denominator in the formula
 * <em>amount</em>/<em>size</em>) is specified by the value of the 'units'
 * attribute on the compartment in which the species is located.
 <p>
 * <li> The 'math' elements of {@link AssignmentRule}, {@link InitialAssignment} and
 * {@link EventAssignment} objects setting the
 * value of the compartment size should all have the same units as the unit
 * associated with the compartment's size.
 <p>
 * <li> In a {@link RateRule} object that defines a
 * rate of change for a compartment's size, the unit of the rule's 'math'
 * element should be identical to the compartment's 'units' attribute divided
 * by the model-wide unit of <em>time</em>.  (In other words, {<em>unit of
 * compartment size</em>}/{<em>unit of time</em>}.)
 <p>
 * </ul>
 <p>
 * <h2>Other aspects of {@link Compartment}</h2>
 <p>
 * In SBML Level&nbsp;1 and Level&nbsp;2, {@link Compartment} has an optional
 * attribute named 'outside', whose value can be the identifier of another
 * {@link Compartment} object defined in the
 * enclosing {@link Model} object.  Doing so means
 * that the other compartment contains it or is outside of it.  This enables
 * the representation of simple topological relationships between
 * compartments, for those simulation systems that can make use of the
 * information (e.g., for drawing simple diagrams of compartments).  It is
 * worth noting that in SBML, there is no relationship between compartment
 * sizes when compartment positioning is expressed using the 'outside'
 * attribute.  The size of a given compartment does not in any sense include
 * the sizes of other compartments having it as the value of their 'outside'
 * attributes.  In other words, if a compartment <em>B</em> has the identifier of
 * compartment <em>A</em> as its 'outside' attribute value, the size of <em>A</em> does
 * not include the size of <em>B</em>.  The compartment sizes are separate.
 <p>
 * In Level&nbsp;2, there are two restrictions on the 'outside' attribute.
 * First, because a compartment with 'spatialDimensions' of <code>0</code> has no
 * size, such a compartment cannot act as the container of any other
 * compartment <em>except</em> compartments that <em>also</em> have
 * 'spatialDimensions' values of <code>0.</code>  Second, the directed graph formed
 * by representing {@link Compartment} structures as vertexes and the 'outside'
 * attribute values as edges must be acyclic.  The latter condition is
 * imposed to prevent a compartment from being contained inside itself.  In
 * the absence of a value for 'outside', compartment definitions in SBML
 * Level&nbsp;2 do not have any implied spatial relationships between each
 * other.
 */

public class Compartment extends SBase {
   private long swigCPtr;

   protected Compartment(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Compartment_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Compartment obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Compartment obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Compartment(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link Compartment} object using the given SBML <code>level</code> and 
   * <code>version</code> values.
   <p>
   * @param level a long integer, the SBML Level to assign to this {@link Compartment}.
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Compartment}.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 Compartment(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link Compartment} object using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * It is worth emphasizing that although this constructor does not take an
   * identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Compartment} object is required to have a
   * value.  Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link Compartment#setId(String id)}.
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 Compartment(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor.
   <p>
   * This creates a copy of a {@link Compartment} object.
   <p>
   * @param orig the {@link Compartment} instance to copy.
   */ public
 Compartment(Compartment orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_2(Compartment.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link Compartment} object.
   <p>
   * @return the (deep) copy of this {@link Compartment} object.
   */ public
 Compartment cloneObject() {
    long cPtr = libsbmlJNI.Compartment_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Compartment(cPtr, true);
  }

  
/**
   * Initializes the fields of this {@link Compartment} object to 'typical' default
   * values.
   <p>
   * The SBML {@link Compartment} component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   <p>
   * <ul>
   * <li> Sets attribute 'spatialDimensions' to <code>3</code>
   * <li> Sets attribute 'constant' to <code>true</code>
   * <li> (Applies to Level&nbsp;1 models only) Sets attribute 'volume' to <code>1.0</code>
   * <li> (Applies to Level&nbsp;3 models only) Sets attribute 'units' to <code>litre</code>
   * </ul>
   */ public
 void initDefaults() {
    libsbmlJNI.Compartment_initDefaults(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'id' attribute of this {@link Compartment}.
   <p>
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
   <p>
   * @return the id of this {@link Compartment}.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getId() {
    return libsbmlJNI.Compartment_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 <p>
 * @see #getIdAttribute()
 * @see #isSetName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 String getName() {
    return libsbmlJNI.Compartment_getName(swigCPtr, this);
  }

  
/**
   * Get the value of the 'compartmentType' attribute of this {@link Compartment}
   * object.
   <p>
   * @return the value of the 'compartmentType' attribute of this
   * {@link Compartment} object as a string.
   <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   <p>
   * @see #isSetCompartmentType()
   * @see #setCompartmentType(String)
   * @see #unsetCompartmentType()
   */ public
 String getCompartmentType() {
    return libsbmlJNI.Compartment_getCompartmentType(swigCPtr, this);
  }

  
/**
   * Get the number of spatial dimensions of this {@link Compartment} object.
   <p>
   * @return the value of the 'spatialDimensions' attribute of this
   * {@link Compartment} object as a long integereger.
   <p>
   * <p>
 * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
 * attribute is <code>double</code>, whereas in Level&nbsp;2, it is <code>integer.</code>  To
 * avoid backward compatibility issues, libSBML provides two separate methods
 * for obtaining the value as either an integer or a type <code>double</code>, for
 * models where it is relevant.
   <p>
   * @see #getSpatialDimensionsAsDouble()
   * @see #setSpatialDimensions(long)
   * @see #isSetSpatialDimensions()
   * @see #unsetSpatialDimensions()
   */ public
 long getSpatialDimensions() {
    return libsbmlJNI.Compartment_getSpatialDimensions(swigCPtr, this);
  }

  
/**
   * Get the number of spatial dimensions of this {@link Compartment} object,
   * as a double.
   <p>
   * @return the value of the 'spatialDimensions' attribute of this
   * {@link Compartment} object as a double, or <code>NaN</code> if this model is not in SBML
   * Level&nbsp;3 format.
   <p>
   * <p>
 * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
 * attribute is <code>double</code>, whereas in Level&nbsp;2, it is <code>integer.</code>  To
 * avoid backward compatibility issues, libSBML provides two separate methods
 * for obtaining the value as either an integer or a type <code>double</code>, for
 * models where it is relevant.
   <p>
   * @see #getSpatialDimensions()
   * @see #setSpatialDimensions(long)
   * @see #isSetSpatialDimensions()
   * @see #unsetSpatialDimensions()
   */ public
 double getSpatialDimensionsAsDouble() {
    return libsbmlJNI.Compartment_getSpatialDimensionsAsDouble(swigCPtr, this);
  }

  
/**
   * Get the size of this {@link Compartment} object.
   <p>
   * <p>
 * In SBML Level&nbsp;1, compartments are always three-dimensional
 * constructs and only have volumes, whereas in SBML Level&nbsp;2 and higher,
 * compartments may be other than three-dimensional, and therefore the
 * 'volume' attribute is named 'size' in Level&nbsp;2 and above.  LibSBML
 * provides both getSize() and getVolume()
 * for easier support of different SBML Levels.
   <p>
   * @return the value of the 'size' attribute ('volume' in Level&nbsp;1) of
   * this {@link Compartment} object as a floating-point number.
   <p>
   * @note This method is identical to
   * {@link Compartment#getVolume()}.
   <p>
   * @see #getVolume()
   * @see #isSetSize()
   * @see #setSize(double)
   * @see #unsetSize()
   */ public
 double getSize() {
    return libsbmlJNI.Compartment_getSize(swigCPtr, this);
  }

  
/**
   * Get the volume of this {@link Compartment} object.
   <p>
   * <p>
 * In SBML Level&nbsp;1, compartments are always three-dimensional
 * constructs and only have volumes, whereas in SBML Level&nbsp;2 and higher,
 * compartments may be other than three-dimensional, and therefore the
 * 'volume' attribute is named 'size' in Level&nbsp;2 and above.  LibSBML
 * provides both getSize() and getVolume()
 * for easier support of different SBML Levels.
   <p>
   * @return the value of the 'volume' attribute ('size' in Level&nbsp;2) of
   * this {@link Compartment} object, as a floating-point number.
   <p>
   * <p>
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (<code>1.0</code>) and therefore methods such as
 * isSetVolume()
 * will always return <code>true</code> for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
   <p>
   * @note This method is identical to
   * {@link Compartment#getSize()}.
   <p>
   * @see #getSize()
   * @see #isSetVolume()
   * @see #setVolume(double)
   * @see #unsetVolume()
   */ public
 double getVolume() {
    return libsbmlJNI.Compartment_getVolume(swigCPtr, this);
  }

  
/**
   * Get the units of this {@link Compartment} object's size.
   <p>
   * The value of an SBML compartment's 'units' attribute establishes the
   * unit of measurement associated with the compartment's size.
   <p>
   * @return the value of the 'units' attribute of this {@link Compartment} object,
   * as a string.  An empty string indicates that no units have been assigned
   * to the value of the size.
   <p>
   * <p>
 * @note There is an important distinction to be made between <em>no units
 * assigned</em>, and assuming a value without units has any specific unit
 * such as <code>dimensionless</code>.  In SBML, default units are never
 * attributed to numbers, and numbers without units are not automatically
 * assumed to have the unit <code>dimensionless</code>.  Please consult the
 * relevant SBML specification document for a more in-depth explanation of
 * this topic and the SBML unit system.
   <p>
   * @see #isSetUnits()
   * @see #setUnits(String)
   * @see #unsetUnits()
   */ public
 String getUnits() {
    return libsbmlJNI.Compartment_getUnits(swigCPtr, this);
  }

  
/**
   * Get the identifier, if any, of the {@link Compartment} object that is designated
   * as being outside of <em>this</em> one.
   <p>
   * @return the value of the 'outside' attribute of this {@link Compartment} object.
   <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   <p>
   * @see #isSetOutside()
   * @see #setOutside(String)
   * @see #unsetOutside()
   */ public
 String getOutside() {
    return libsbmlJNI.Compartment_getOutside(swigCPtr, this);
  }

  
/**
   * Get the value of the 'constant' attribute of this {@link Compartment} object.
   <p>
   * @return <code>true</code> if this {@link Compartment} object's size is flagged as being
   * constant, <code>false</code> otherwise.
   <p>
   * @see #isSetConstant()
   * @see #setConstant(boolean)
   */ public
 boolean getConstant() {
    return libsbmlJNI.Compartment_getConstant(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'id' attribute
   * is set.
   <p>
   * <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * @return <code>true</code> if the 'id' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #unsetIdAttribute()
 * @see #isSetIdAttribute()
   */ public
 boolean isSetId() {
    return libsbmlJNI.Compartment_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'name'
   * attribute is set.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'name' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 boolean isSetName() {
    return libsbmlJNI.Compartment_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's
   * 'compartmentType' attribute is set.
   <p>
   * @return <code>true</code> if the 'compartmentType' attribute of this {@link Compartment}
   * is set, <code>false</code> otherwise.
   <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   <p>
   * @see #setCompartmentType(String)
   * @see #getCompartmentType()
   * @see #unsetCompartmentType()
   */ public
 boolean isSetCompartmentType() {
    return libsbmlJNI.Compartment_isSetCompartmentType(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'size'
   * attribute is set.
   <p>
   * This method is similar but not identical to
   * {@link Compartment#isSetVolume()}.  The latter
   * should be used in the context of SBML Level&nbsp;1 models instead of
   * {@link Compartment#isSetSize()}
   * because {@link Compartment#isSetVolume()}
   * performs extra processing to take into account the difference in
   * default values between SBML Levels&nbsp;1 and&nbsp;2.
   <p>
   * @return <code>true</code> if the 'size' attribute ('volume' in Level&nbsp;2) of
   * this {@link Compartment} object is set, <code>false</code> otherwise.
   <p>
   * @see #isSetVolume()
   * @see #setSize(double)
   * @see #getSize()
   * @see #unsetSize()
   */ public
 boolean isSetSize() {
    return libsbmlJNI.Compartment_isSetSize(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'volume'
   * attribute is set.
   <p>
   * This method is similar but not identical to
   * {@link Compartment#isSetSize()}.  The latter
   * should not be used in the context of SBML Level&nbsp;1 models because the
   * present method performs extra processing to take into account
   * the difference in default values between SBML Levels&nbsp;1 and&nbsp;2.
   <p>
   * @return <code>true</code> if the 'volume' attribute ('size' in Level&nbsp;2 and
   * above) of this {@link Compartment} object is set, <code>false</code> otherwise.
   <p>
   * <p>
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (<code>1.0</code>) and therefore methods such as
 * isSetVolume()
 * will always return <code>true</code> for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
   <p>
   * @see #isSetSize()
   * @see #getVolume()
   * @see #setVolume(double)
   * @see #unsetVolume()
   */ public
 boolean isSetVolume() {
    return libsbmlJNI.Compartment_isSetVolume(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'units'
   * attribute is set.
   <p>
   * @return <code>true</code> if the 'units' attribute of this {@link Compartment} object is
   * set, <code>false</code> otherwise.
   <p>
   * <p>
 * @note There is an important distinction to be made between <em>no units
 * assigned</em>, and assuming a value without units has any specific unit
 * such as <code>dimensionless</code>.  In SBML, default units are never
 * attributed to numbers, and numbers without units are not automatically
 * assumed to have the unit <code>dimensionless</code>.  Please consult the
 * relevant SBML specification document for a more in-depth explanation of
 * this topic and the SBML unit system.
   <p>
   * @see #setUnits(String)
   * @see #getUnits()
   * @see #unsetUnits()
   */ public
 boolean isSetUnits() {
    return libsbmlJNI.Compartment_isSetUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'outside'
   * attribute is set.
   <p>
   * @return <code>true</code> if the 'outside' attribute of this {@link Compartment} object is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   <p>
   * @see #getOutside()
   * @see #setOutside(String)
   * @see #unsetOutside()
   */ public
 boolean isSetOutside() {
    return libsbmlJNI.Compartment_isSetOutside(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's
   * 'spatialDimensions' attribute is set.
   <p>
   * @return <code>true</code> if the 'spatialDimensions' attribute of this
   * {@link Compartment} object is set, <code>false</code> otherwise.
   <p>
   * @see #getSpatialDimensions()
   * @see #setSpatialDimensions(long)
   * @see #unsetSpatialDimensions()
   */ public
 boolean isSetSpatialDimensions() {
    return libsbmlJNI.Compartment_isSetSpatialDimensions(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link Compartment} object's 'constant'
   * attribute is set.
   <p>
   * @return <code>true</code> if the 'constant' attribute of this {@link Compartment} object is
   * set, <code>false</code> otherwise.
   <p>
   * @see #getConstant()
   * @see #setConstant(boolean)
   */ public
 boolean isSetConstant() {
    return libsbmlJNI.Compartment_isSetConstant(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link Compartment} object.
   <p>
   * The string <code>sid</code> is copied.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
   <p>
   * @param sid the string to use as the identifier of this {@link Compartment} object. If
   * the string is <code>null</code>, this method will return
   * {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @see #getId()
   * @see #unsetId()
   * @see #isSetId()
   */ public
 int setId(String sid) {
    return libsbmlJNI.Compartment_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * The string in <code>name</code> is copied.
 <p>
 * @param name the new name for the SBML object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 *
 * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.Compartment_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the 'compartmentType' attribute of this {@link Compartment} object.
   <p>
   * @param sid the identifier of a {@link CompartmentType} object defined elsewhere
   * in this {@link Model}. If the string is <code>null</code>, this method will return
   * {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   <p>
   * @see #isSetCompartmentType()
   * @see #getCompartmentType()
   * @see #unsetCompartmentType()
   */ public
 int setCompartmentType(String sid) {
    return libsbmlJNI.Compartment_setCompartmentType(swigCPtr, this, sid);
  }

  
/**
   * Sets the 'spatialDimensions' attribute of this {@link Compartment} object.
   <p>
   * @param value a long integereger indicating the number of dimensions
   * of this compartment.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #getSpatialDimensions()
   * @see #isSetSpatialDimensions()
   * @see #unsetSpatialDimensions()
   */ public
 int setSpatialDimensions(long value) {
    return libsbmlJNI.Compartment_setSpatialDimensions__SWIG_0(swigCPtr, this, value);
  }

  
/**
   * Sets the 'spatialDimensions' attribute of this {@link Compartment} object as a double.
   <p>
   * @param value a double indicating the number of dimensions
   * of this compartment.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #getSpatialDimensions()
   * @see #isSetSpatialDimensions()
   * @see #unsetSpatialDimensions()
   */ public
 int setSpatialDimensions(double value) {
    return libsbmlJNI.Compartment_setSpatialDimensions__SWIG_1(swigCPtr, this, value);
  }

  
/**
   * Sets the 'size' attribute (or 'volume' in SBML Level&nbsp;1) of this
   * {@link Compartment} object.
   <p>
   * @param value a <code>double</code> representing the size of this compartment
   * instance in whatever units are in effect for the compartment.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @note This method is identical to
   * {@link Compartment#setVolume(double value)}.
   <p>
   * @see #setVolume(double)
   * @see #getSize()
   * @see #isSetSize()
   * @see #unsetSize()
   */ public
 int setSize(double value) {
    return libsbmlJNI.Compartment_setSize(swigCPtr, this, value);
  }

  
/**
   * Sets the 'volume' attribute (or 'size' in SBML Level&nbsp;2) of this
   * {@link Compartment} object.
   <p>
   * This method is identical to
   * {@link Compartment#setSize(double value)}
   * and is provided for compatibility between SBML Level&nbsp;1 and
   * higher Levels of SBML.
   <p>
   * @param value a <code>double</code> representing the volume of this compartment
   * instance in whatever units are in effect for the compartment.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * <p>
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (<code>1.0</code>) and therefore methods such as
 * isSetVolume()
 * will always return <code>true</code> for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
   <p>
   * @see #setSize(double)
   * @see #getVolume()
   * @see #isSetVolume()
   * @see #unsetVolume()
   */ public
 int setVolume(double value) {
    return libsbmlJNI.Compartment_setVolume(swigCPtr, this, value);
  }

  
/**
   * Sets the 'units' attribute of this {@link Compartment} object.
   <p>
   * @param sid the identifier of the defined units to use.  If <code>sid</code> is
   * <code>null</code>, then this method will return
   * {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @see #isSetUnits()
   * @see #getUnits()
   * @see #unsetUnits()
   */ public
 int setUnits(String sid) {
    return libsbmlJNI.Compartment_setUnits(swigCPtr, this, sid);
  }

  
/**
   * Sets the 'outside' attribute of this {@link Compartment} object.
   <p>
   * @param sid the identifier of a compartment that encloses this one. If 
   * <code>sid</code> is <code>null</code>, then this method will return
   * {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   <p>
   * @see #isSetOutside()
   * @see #getOutside()
   * @see #unsetOutside()
   */ public
 int setOutside(String sid) {
    return libsbmlJNI.Compartment_setOutside(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'constant' attribute of this {@link Compartment} object.
   <p>
   * @param value a boolean indicating whether the size/volume of this
   * compartment should be considered constant (<code>true</code>) or variable
   * (<code>false</code>).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #isSetConstant()
   * @see #getConstant()
   */ public
 int setConstant(boolean value) {
    return libsbmlJNI.Compartment_setConstant(swigCPtr, this, value);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>SIdRef</code> type attribute value with another
 * value.
 <p>
 * <p>
 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of <code>oldid</code>.  If any matches are found, the
 * matching values are replaced with <code>newid</code>.  The method does <em>not</em>
 * descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.Compartment_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>UnitSIdRef</code> type attribute value with
 * another value.
 <p>
 * <p>
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of <code>oldid</code>.  If any matches
 * are found, the matching values are replaced with <code>newid</code>.  The method
 * does <em>not</em> descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.Compartment_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #isSetName()
   */ public
 int unsetName() {
    return libsbmlJNI.Compartment_unsetName(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'compartmentType' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   <p>
   * @see #setCompartmentType(String)
   * @see #isSetCompartmentType()
   * @see #getCompartmentType()
   */ public
 int unsetCompartmentType() {
    return libsbmlJNI.Compartment_unsetCompartmentType(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'constant' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #isSetConstant()
   * @see #setConstant(boolean)
   * @see #getConstant()
   */ public
 int unsetConstant() {
    return libsbmlJNI.Compartment_unsetConstant(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'size' attribute of this {@link Compartment} object.
   <p>
   * In SBML Level&nbsp;1, a compartment's volume has a default value
   * (<code>1.0</code>) and therefore <em>should always be set</em>.  Calling this method
   * on a Level&nbsp;1 model resets the value to <code>1.0</code> rather than actually
   * unsetting it.  In Level&nbsp;2, a compartment's 'size' is optional with
   * no default value, and unsetting it will result in the compartment having
   * no defined size.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note This method is identical to
   * {@link Compartment#unsetVolume()}.
   <p>
   * @see #unsetVolume()
   * @see #getSize()
   * @see #isSetSize()
   * @see #setSize(double)
   */ public
 int unsetSize() {
    return libsbmlJNI.Compartment_unsetSize(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'volume' attribute of this {@link Compartment} object.
   <p>
   * This method is identical to
   * {@link Compartment#unsetSize()}.  Please refer
   * to that method's documentation for more information about its behavior.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (<code>1.0</code>) and therefore methods such as
 * isSetVolume()
 * will always return <code>true</code> for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
   <p>
   * @see #unsetSize()
   * @see #getVolume()
   * @see #setVolume(double)
   * @see #isSetVolume()
   */ public
 int unsetVolume() {
    return libsbmlJNI.Compartment_unsetVolume(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'units' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #isSetUnits()
   * @see #setUnits(String)
   * @see #getUnits()
   */ public
 int unsetUnits() {
    return libsbmlJNI.Compartment_unsetUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'outside' attribute of this {@link Compartment} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   <p>
   * @see #isSetOutside()
   * @see #getOutside()
   * @see #setOutside(String)
   */ public
 int unsetOutside() {
    return libsbmlJNI.Compartment_unsetOutside(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'spatialDimensions' attribute of this
   * {@link Compartment} object.
   <p>
   * In SBML Levels prior to Level&nbsp;3, compartments must always have a
   * value for the number of dimensions.  Consequently, calling this method
   * on a model of SBML Level 1&ndash;2 will result in a return value of
   * {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @note This function is only valid for SBML Level&nbsp;3.
   <p>
   * @see #getSpatialDimensions()
   * @see #isSetSpatialDimensions()
   * @see #setSpatialDimensions(long)
   */ public
 int unsetSpatialDimensions() {
    return libsbmlJNI.Compartment_unsetSpatialDimensions(swigCPtr, this);
  }

  
/**
   * Constructs and returns a {@link UnitDefinition} that corresponds to the units
   * of this {@link Compartment} object's designated size.
   <p>
   * <p>
 * Compartments in SBML have an attribute ('units') for declaring the
 * units of measurement intended for the value of the compartment's size.  In
 * the absence of a value given for this attribute, the units are inherited
 * from values either defined on the enclosing {@link Model} (in SBML Level&nbsp;3)
 * or in defaults (in SBML Level&nbsp;2).  This method returns a
 * {@link UnitDefinition} object
 * based on how this compartment's units are interpreted according to the
 * relevant SBML guidelines, or it returns <code>null</code> if no units have been
 * declared and no defaults are defined by the relevant SBML specification.
 <p>
 * Note that unit declarations for
 * {@link Compartment} objects 
 * are specified in terms of the <em>identifier</em> of a unit,
 * but <em>this</em> method returns an object ,
 * not a unit identifier.  It does this by constructing an appropriate
 * {@link UnitDefinition} object.  For
 * SBML Level&nbsp;2 models, it will do this even when the value of the
 * 'units' attribute is one of the special SBML Level&nbsp;2 unit identifiers
 * <code>'substance'</code>, <code>'volume'</code>, <code>'area'</code>, <code>'length'</code> or <code>'time'.</code>  Callers
 * may find this useful in conjunction with the helper methods provided by
 * the {@link UnitDefinition}
 * class for comparing different {@link UnitDefinition} objects.
   <p>
   * @return a {@link UnitDefinition} that expresses the units of this
   * {@link Compartment} object, or <code>null</code> if one cannot be constructed.
   <p>
   * <p>
 * @note The libSBML system for unit analysis depends on the model as a
 * whole.  In cases where the
 * {@link Compartment} object has not
 * yet been added to a model, or the model itself is incomplete, unit
 * analysis is not possible, and consequently this method will return
 * <code>null.</code>
   <p>
   * @see #isSetUnits()
   * @see #getUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.Compartment_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>{@link SBase#getPackageName()}
 * </code>
 * method on the object.
 <p>
 * The exception to this is lists:  all SBML-style list elements have the type 
 * {@link libsbmlConstants#SBML_LIST_OF SBML_LIST_OF}, regardless of what package they 
 * are from.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_COMPARTMENT SBML_COMPARTMENT} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * {@link ListOf#getItemTypeCode()}).</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.Compartment_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object
   <p>
   * For {@link Compartment}, the XML element name is always <code>'compartment'.</code>
   <p>
   * @return the name of this element.
   */ public
 String getElementName() {
    return libsbmlJNI.Compartment_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required attributes for this
   * {@link Compartment} object have been set.
   <p>
   * The required attributes for a {@link Compartment} object are:
   * <ul>
   * <li> 'id' (or 'name' in SBML Level&nbsp;1)
   * <li> 'constant' (in SBML Level&nbsp;3 only)
   *
   * </ul> <p>
   * @return <code>true</code> if the required attributes have been set, <code>false</code>
   * otherwise.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.Compartment_hasRequiredAttributes(swigCPtr, this);
  }

}
