/*
    libmaus2
    Copyright (C) 2009-2015 German Tischler
    Copyright (C) 2011-2015 Genome Research Limited

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* this code is inspired by the samtools_irods project */
#if ! defined(LIBMAUS2_IRODS_IRODSFILEBASE_HPP)
#define LIBMAUS2_IRODS_IRODSFILEBASE_HPP

#include <libmaus2/exception/LibMausException.hpp>
#include <libmaus2/irods/IRodsCommProvider.hpp>

#if defined(LIBMAUS2_HAVE_IRODS)
#if defined(LIBMAUS2_IRODS_NEED_PREFIX)
#include <irods/rodsClient.h>
#else
#include <rodsClient.h>
#endif
#endif

namespace libmaus2
{
	namespace irods
	{
		struct IRodsSystem;

		struct IRodsFileBase
		{
			typedef IRodsFileBase this_type;
			typedef libmaus2::util::unique_ptr<this_type>::type unique_ptr_type;
			typedef libmaus2::util::shared_ptr<this_type>::type shared_ptr_type;

			friend struct IRodsSystem;

			bool fdvalid;
			long fd; /* file descriptor returned by rcDataObjCreate() */

			#if defined(LIBMAUS2_HAVE_IRODS)
			rcComm_t * comm;
			#endif

			private:
			IRodsFileBase();

			public:
			~IRodsFileBase();

			// read block of data
			uint64_t read(char * buffer, uint64_t len);

			// perform seek operation and return new position in stream
			uint64_t seek(long offset, int whence);

			// get size of file
			uint64_t size();
		};
	}
}
#endif
