package org.jboss.cache.commands.write;

import static org.easymock.EasyMock.expect;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.annotations.Test;

import java.util.Collections;

/**
 * tester class for {@link ClearDataCommand}.
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
@Test(groups = "unit")
public class ClearDataCommandTest extends AbstractVersionedDataCommandTest
{

   ClearDataCommand command;

   public AbstractVersionedDataCommand moreSetUp()
   {
      command = new ClearDataCommand(globalTransaction, fqn);
      command.setDataVersion(dataVersion);
      return command;
   }

   public void testNonexistentNode()
   {
      expect(container.peekVersioned(fqn, dataVersion)).andReturn(null);
      control.replay();
      assert null == command.perform(ctx);
      control.verify();
   }

   public void testExistentData()
   {
      nodes.adfgNode.put("key", "value");
      expect(container.peekVersioned(fqn, dataVersion)).andReturn(nodes.adfgNode);
      notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, nodes.adfgNode.getDataDirect(), ctx);
      notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, Collections.EMPTY_MAP, ctx);
      control.replay();
      assert null == command.perform(ctx);
      assert nodes.adfgNode.getData().isEmpty();
      control.verify();

      //now do a rollback
      control.reset();
      expect(container.peek(fqn, false, true)).andReturn(nodes.aNode);
      control.replay();
      command.rollback();
      assert nodes.aNode.dataSize() == 1;
      assert nodes.aNode.getData().get("key").equals("value");
   }

   /**
    * If clearing data on an inexistent node, the rollback should not fail
    */
   public void testNoOpRollback()
   {
      expect(container.peek(fqn, false, true)).andReturn(null);
      control.replay();
      try
      {
         command.rollback();
      }
      catch (Exception e)
      {
         assert false : "should not fail but expect this scenarion";
      }
   }
}
