/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__TRANSIENTSTORAGE_HPP)
#include <TransientStorage.hpp>
#endif

namespace corelinux
{
   // Constructor

   TransientStorage::TransientStorage( void )
      :
      Storage()
   {
      ;  // do nothing
   }

   // Copy constructor

   TransientStorage::TransientStorage( TransientStorageCref aRef )
      :
      Storage( aRef )
   {
      ;  // vacuous, do nothing
   }

   // Destructor

   TransientStorage::~TransientStorage( void )
   {
      ;  // vacuous, do nothing
   }

   // Operator assignment

   TransientStorageRef  TransientStorage::operator=( TransientStorageCref aRef )
   {
      return TransientStorageRef(Storage::operator=(aRef));
   }

   // Equality operator

   bool TransientStorage::operator==( TransientStorageCref aRef ) const
   {
      return Storage::operator==( aRef );
   }
}


/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/14 12:55:43 $
   $Locker:  $
*/


