# - Try to find GNU TLS
# Once done this will define
#
#  GSASL_FOUND - system has GSASL
#  GSASL_INCLUDE_DIR - the GSASL include directory
#  GSASL_LIBRARIES - the libraries needed to use GSASL

# Copyright (c) 2009, Gregory Haynes <greg@greghaynes.net>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


IF (GSASL_INCLUDE_DIR AND GSASL_LIBRARIES)
   # in cache already
   SET(GSASL_FIND_QUIETLY TRUE)
ELSE (GSASL_INCLUDE_DIR AND GSASL_LIBRARIES)
   SET(GSASL_FIND_QUIETLY FALSE)
ENDIF (GSASL_INCLUDE_DIR AND GSASL_LIBRARIES)

IF (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   FIND_PACKAGE(PkgConfig)
   PKG_CHECK_MODULES(PC_GSASL gsasl) 
   #MESSAGE(STATUS "DEBUG: GSASL include directory = ${GSASL_INCLUDE_DIRS}")
   #MESSAGE(STATUS "DEBUG: GSASL link directory = ${GSASL_LIBRARY_DIRS}")
   #MESSAGE(STATUS "DEBUG: GSASL CFlags = ${GSASL_CFLAGS}")
   SET(GSASL_DEFINITIONS ${PC_GSASL_CFLAGS_OTHER})
ENDIF (NOT WIN32)

FIND_PATH(GSASL_INCLUDE_DIR gsasl.h
   PATHS
   ${PC_GSASL_INCLUDEDIR}
   ${PC_GSASL_INCLUDE_DIRS}
   PATH_SUFFIXES gsasl/
   )

FIND_LIBRARY(_GSASLLibs NAMES gsasl
   PATHS
   ${PC_GSASL_LIBDIR}
   ${PC_GSASL_LIBRARY_DIRS}
   )

SET( GSASL_LIBRARIES ${_GSASLLibs} )

IF (GSASL_INCLUDE_DIR AND GSASL_LIBRARIES)
   SET(GSASL_FOUND TRUE)
ELSE (GSASL_INCLUDE_DIR AND GSASL_LIBRARIES)
   SET(GSASL_FOUND FALSE)
ENDIF (GSASL_INCLUDE_DIR AND GSASL_LIBRARIES)

IF (GSASL_FOUND)
   IF (NOT GSASL_FIND_QUIETLY)
      MESSAGE(STATUS "Found GSASL libraries: ${GSASL_LIBRARIES}")
      MESSAGE(STATUS "Found GSASL includes : ${GSASL_INCLUDE_DIR}")
   ENDIF (NOT GSASL_FIND_QUIETLY)
ELSE (GSASL_FOUND)
    IF (GSASL_FIND_REQUIRED)
      MESSAGE(STATUS "Could NOT find GSASL")
    ENDIF(GSASL_FIND_REQUIRED)
ENDIF (GSASL_FOUND)

MARK_AS_ADVANCED(GSASL_INCLUDE_DIR _GSASLLibs)
