#---------------------------------------------------------------------------------------
# Bundle: KLayoutAna3.app
#
# Descriptions:
#  This script invokes "klayout.app" that shares the Anaconda3 development environment.
#  More precisely, it uses the Qt5, Ruby, and Python package of Anaconda3 installed in
#  the standard location.
#
#  Because the standard installation location is $HOME/opt/anaconda3/, and you need to
#  have a symbolic link: /Applications/andconda3 ---> $HOME/opt/anaconda3/
#---------------------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Localizing the language
# Workaround discussed in https://github.com/KLayout/klayout/issues/1213
#--------------------------------------------------------------------------
export LANG=$(defaults read -g AppleLocale).UTF-8

#--------------------------------------------------------------------------
# Your setups
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Export the 'KLAYOUT_GIT_HTTP_PROXY' environment variable if you need to
# use the git-based Salt Package Manager through a proxy server.
#--------------------------------------------------------------------------
#export KLAYOUT_GIT_HTTP_PROXY="http://111.222.333.444:5678"

#--------------------------------------------------------------------------
# Export the 'PYTHONHOME' environment variable
#--------------------------------------------------------------------------
export PYTHONHOME=/Applications/anaconda3

#--------------------------------------------------------------------------
# With "-n" option, you can invoke multiple instances
#--------------------------------------------------------------------------
myklayout=/Applications/klayout.app
myconfig=$HOME/.klayout/klayoutrc

open -n -a $myklayout --args -e -c $myconfig -style=fusion $@
