/*****************************************************************************
 Copyright (c) 2022-2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* Vectors from https://github.com/google/wycheproof */
/* CHACHA20-POLY1305, 0.8r12 */
#include "aead_test.h"
const struct aead_test chacha20_poly1305_test_json[] = {
        { 96, 256, 128, 1,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x07\x00\x00\x00\x40\x41\x42\x43\x44\x45\x46\x47",
          "\x50\x51\x52\x53\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7",
          "\x4c\x61\x64\x69\x65\x73\x20\x61\x6e\x64\x20\x47\x65\x6e\x74\x6c\x65"
          "\x6d\x65\x6e\x20\x6f\x66\x20\x74\x68\x65\x20\x63\x6c\x61\x73\x73\x20"
          "\x6f\x66\x20\x27\x39\x39\x3a\x20\x49\x66\x20\x49\x20\x63\x6f\x75\x6c"
          "\x64\x20\x6f\x66\x66\x65\x72\x20\x79\x6f\x75\x20\x6f\x6e\x6c\x79\x20"
          "\x6f\x6e\x65\x20\x74\x69\x70\x20\x66\x6f\x72\x20\x74\x68\x65\x20\x66"
          "\x75\x74\x75\x72\x65\x2c\x20\x73\x75\x6e\x73\x63\x72\x65\x65\x6e\x20"
          "\x77\x6f\x75\x6c\x64\x20\x62\x65\x20\x69\x74\x2e",
          "\xd3\x1a\x8d\x34\x64\x8e\x60\xdb\x7b\x86\xaf\xbc\x53\xef\x7e\xc2\xa4"
          "\xad\xed\x51\x29\x6e\x08\xfe\xa9\xe2\xb5\xa7\x36\xee\x62\xd6\x3d\xbe"
          "\xa4\x5e\x8c\xa9\x67\x12\x82\xfa\xfb\x69\xda\x92\x72\x8b\x1a\x71\xde"
          "\x0a\x9e\x06\x0b\x29\x05\xd6\xa5\xb6\x7e\xcd\x3b\x36\x92\xdd\xbd\x7f"
          "\x2d\x77\x8b\x8c\x98\x03\xae\xe3\x28\x09\x1b\x58\xfa\xb3\x24\xe4\xfa"
          "\xd6\x75\x94\x55\x85\x80\x8b\x48\x31\xd7\xbc\x3f\xf4\xde\xf0\x8e\x4b"
          "\x7a\x9d\xe5\x76\xd2\x65\x86\xce\xc6\x4b\x61\x16",
          "\x1a\xe1\x0b\x59\x4f\x09\xe2\x6a\x7e\x90\x2e\xcb\xd0\x60\x06\x91", 1,
          96, 912 },
        { 96, 256, 128, 2,
          "\x80\xba\x31\x92\xc8\x03\xce\x96\x5e\xa3\x71\xd5\xff\x07\x3c\xf0\xf4"
          "\x3b\x6a\x2a\xb5\x76\xb2\x08\x42\x6e\x11\x40\x9c\x09\xb9\xb0",
          "\x4d\xa5\xbf\x8d\xfd\x58\x52\xc1\xea\x12\x37\x9d", "", "", "",
          "\x76\xac\xb3\x42\xcf\x31\x66\xa5\xb6\x3c\x0c\x0e\xa1\x38\x3c\x8d", 1,
          0, 0 },
        { 96, 256, 128, 3,
          "\x7a\x4c\xd7\x59\x17\x2e\x02\xeb\x20\x4d\xb2\xc3\xf5\xc7\x46\x22\x7d"
          "\xf5\x84\xfc\x13\x45\x19\x63\x91\xdb\xb9\x57\x7a\x25\x07\x42",
          "\xa9\x2e\xf0\xac\x99\x1d\xd5\x16\xa3\xc6\xf6\x89",
          "\xbd\x50\x67\x64\xf2\xd2\xc4\x10", "", "",
          "\x90\x6f\xa6\x28\x4b\x52\xf8\x7b\x73\x59\xcb\xaa\x75\x63\xc7\x09", 1,
          64, 0 },
        { 96, 256, 128, 4,
          "\xcc\x56\xb6\x80\x55\x2e\xb7\x50\x08\xf5\x48\x4b\x4c\xb8\x03\xfa\x50"
          "\x63\xeb\xd6\xea\xb9\x1f\x6a\xb6\xae\xf4\x91\x6a\x76\x62\x73",
          "\x99\xe2\x3e\xc4\x89\x85\xbc\xcd\xee\xab\x60\xf1", "", "\x2a",
          "\x3a",
          "\xca\xc2\x7d\xec\x09\x68\x80\x1e\x9f\x6e\xde\xd6\x9d\x80\x75\x22", 1,
          0, 8 },
        { 96, 256, 128, 5,
          "\x46\xf0\x25\x49\x65\xf7\x69\xd5\x2b\xdb\x4a\x70\xb4\x43\x19\x9f\x8e"
          "\xf2\x07\x52\x0d\x12\x20\xc5\x5e\x4b\x70\xf0\xfd\xa6\x20\xee",
          "\xab\x0d\xca\x71\x6e\xe0\x51\xd2\x78\x2f\x44\x03",
          "\x91\xca\x6c\x59\x2c\xbc\xca\x53", "\x51", "\xc4",
          "\x16\x83\x10\xca\x45\xb1\xf7\xc6\x6c\xad\x4e\x99\xe4\x3f\x72\xb9", 1,
          64, 8 },
        { 96, 256, 128, 6,
          "\x2f\x7f\x7e\x4f\x59\x2b\xb3\x89\x19\x49\x89\x74\x35\x07\xbf\x3e\xe9"
          "\xcb\xde\x17\x86\xb6\x69\x5f\xe6\xc0\x25\xfd\x9b\xa4\xc1\x00",
          "\x46\x1a\xf1\x22\xe9\xf2\xe0\x34\x7e\x03\xf2\xdb", "", "\x5c\x60",
          "\x4d\x13",
          "\x91\xe8\xb6\x1e\xfb\x39\xc1\x22\x19\x54\x53\x07\x7b\x22\xe5\xe2", 1,
          0, 16 },
        { 96, 256, 128, 7,
          "\xc8\x83\x3d\xce\x5e\xa9\xf2\x48\xaa\x20\x30\xea\xcf\xe7\x2b\xff\xe6"
          "\x9a\x62\x0c\xaf\x79\x33\x44\xe5\x71\x8f\xe0\xd7\xab\x1a\x58",
          "\x61\x54\x6b\xa5\xf1\x72\x05\x90\xb6\x04\x0a\xc6",
          "\x88\x36\x4f\xc8\x06\x05\x18\xbf", "\xdd\xf2", "\xb6\x0d",
          "\xea\xd0\xfd\x46\x97\xec\x2e\x55\x58\x23\x77\x19\xd0\x24\x37\xa2", 1,
          64, 16 },
        { 96, 256, 128, 8,
          "\xbd\x8e\xd7\xfb\x0d\x60\x75\x22\xf0\x4d\x0b\x12\xd4\x2c\x92\x57\x0b"
          "\xcc\xc5\xba\x24\x86\x95\x3d\x70\xba\x2e\x81\x93\xf6\x22\x5a",
          "\xd2\xab\x0a\xbb\x50\xa8\xe9\xfb\xa2\x54\x29\xe1", "",
          "\x20\x12\x21", "\x3c\xf4\x70",
          "\xa2\x7a\x69\xc9\xd7\xee\x84\x58\x6f\x11\x38\x8c\x68\x84\xe6\x3a", 1,
          0, 24 },
        { 96, 256, 128, 9,
          "\x1c\x8b\x59\xb1\x7a\x5c\xec\xed\x31\xbd\xe9\x7d\x4c\xef\xd9\xaa\xaa"
          "\x63\x36\x2e\x09\x6e\x86\x3e\xc1\xc8\x95\x80\xbc\xa7\x9b\x7a",
          "\x94\xf3\x2a\x6d\xff\x58\x8f\x2b\x5a\x2e\xad\x45",
          "\x6c\x8c\xf2\xab\x38\x20\xb6\x95", "\x45\x3f\x95", "\x61\x09\x25",
          "\xa8\xa7\x88\x3e\xb7\xe4\x0b\xc4\x0e\x2e\x59\x22\xae\x95\xdd\xc3", 1,
          64, 24 },
        { 96, 256, 128, 10,
          "\xe4\x91\x2c\xb7\x5a\x11\x74\x34\x5f\x1a\x45\x73\x66\xf1\x88\x85\xfe"
          "\x84\x60\xb0\x64\x78\xe0\x4b\xe2\xf7\xfb\x4e\xc9\xc1\x13\xe5",
          "\x7a\xa5\xad\x8b\xf5\x25\x47\x62\x17\x1e\xc8\x69", "",
          "\x9e\x4c\x1d\x03", "\xfe\x68\x49\xaa",
          "\x99\xad\x07\x87\x1b\x25\xc2\x7d\xef\xc3\x1a\x54\x1b\xd5\xc4\x18", 1,
          0, 32 },
        { 96, 256, 128, 11,
          "\xe0\x57\x77\xef\x3d\x98\x9a\xce\x7d\x2a\xbf\xba\x45\x2b\xfd\xed\x54"
          "\x80\x1d\xbd\x5c\x66\xe9\x1c\x0c\x2e\xf0\x04\x79\xd8\x55\x72",
          "\xb7\xf5\x26\xe3\xfd\x71\xcf\x57\x20\x96\x1a\xec",
          "\x15\xd9\x3a\x96\xd0\xe6\xc5\xa9", "\x17\xbf\xda\x03",
          "\xf4\x71\x0e\x51",
          "\xb9\x57\xc6\xa3\x7b\x6a\x4c\x94\x99\x6c\x00\x21\x86\xd6\x3b\x2b", 1,
          64, 32 },
        { 96, 256, 128, 12,
          "\x1a\x4c\x4f\x39\xab\xe8\x90\xe6\x23\x45\xc9\x47\xbc\xf7\xde\x7c\x2e"
          "\x33\xbd\x5c\xee\xda\x0a\x0a\xbf\x0e\x7e\xf9\x35\xdd\xf3\xee",
          "\x94\x47\xbf\x85\xd5\xb9\x7d\x8a\xee\x0f\x8e\x51", "",
          "\xc1\x5a\x59\x3b\xd0", "\xf7\x11\x64\x7f\xf1",
          "\x22\xb1\x2d\xc3\x8c\xb7\x96\x29\xf8\x4c\xdb\xdc\x24\x25\xc0\x9d", 1,
          0, 40 },
        { 96, 256, 128, 13,
          "\x80\x0e\x9a\x24\x79\x17\x00\xc9\x60\x97\x36\x69\x5b\xa2\xa8\xb9\x9b"
          "\x2d\x57\xf1\xc3\xbf\xb6\x1e\xd4\x9d\xb1\xc6\xc5\x21\x95\x83",
          "\x3d\xbe\x87\x6b\xd8\x80\xec\x8e\xa2\x01\x70\x43",
          "\x96\x22\x48\x35\x61\x0b\x78\x2b", "\xa7\xbf\xd0\x41\xe3",
          "\xd1\x71\xf0\x46\xea",
          "\xd1\x79\xb1\xb9\xc4\x18\x43\x78\xdf\x00\x90\x19\xdb\xb8\xc2\x49", 1,
          64, 40 },
        { 96, 256, 128, 14,
          "\x20\x8c\x2c\x37\x6c\x94\x30\x43\x3d\xb2\x0e\x1a\x6b\x7b\xa8\x17\xf8"
          "\xff\xbf\xa6\x82\x7f\x26\x75\x9c\xce\xde\x42\xe5\x91\xd3\xec",
          "\x27\xfb\x58\xec\x6a\x21\xe8\x46\x96\xcb\x88\x30", "",
          "\xaf\x10\x4b\x5c\xcd\x0e", "\x93\x51\xb1\xb1\xb0\x82",
          "\x56\x07\x85\x50\x9f\x60\xf2\x6b\x68\x19\x33\xd9\xcd\xbf\xd2\x9f", 1,
          0, 48 },
        { 96, 256, 128, 15,
          "\x2e\xb1\x68\xe5\x3b\x07\xab\x04\x35\x5e\xa7\x92\xfe\x11\xa6\xbe\x2c"
          "\xe9\xc3\x9c\xfe\x15\xa9\x97\x07\x6b\x1e\x38\xc1\x7a\xd6\x20",
          "\xb5\x96\x54\x70\xc3\x83\xfd\x29\xfe\x7e\xae\xe7",
          "\x6d\x52\xfe\xb2\x50\x9f\x7f\xbf", "\x6f\xdf\x29\x27\xe1\x69",
          "\x41\xab\xff\x7b\x71\xcc",
          "\x9b\x51\x74\x29\x7c\x03\xcf\x89\x02\xd1\xf7\x06\xfd\x00\x89\x02", 1,
          64, 48 },
        { 96, 256, 128, 16,
          "\x55\x56\x81\x58\xd3\xa6\x48\x3f\x1f\x70\x21\xea\xb6\x9b\x70\x3f\x61"
          "\x42\x51\xca\xdc\x1a\xf5\xd3\x4a\x37\x4f\xdb\xfc\x5a\xda\xc7",
          "\x3c\x4e\x65\x4d\x66\x3f\xa4\x59\x6d\xc5\x5b\xb7", "",
          "\xab\x85\xe9\xc1\x57\x17\x31", "\x5d\xfe\x34\x40\xdb\xb3\xc3",
          "\xed\x7a\x43\x4e\x26\x02\xd3\x94\x28\x1e\x0a\xfa\x9f\xb7\xaa\x42", 1,
          0, 56 },
        { 96, 256, 128, 17,
          "\xe3\xc0\x9e\x7f\xab\x1a\xef\xb5\x16\xda\x6a\x33\x02\x2a\x1d\xd4\xeb"
          "\x27\x2c\x80\xd5\x40\xc5\xda\x52\xa7\x30\xf3\x4d\x84\x0d\x7f",
          "\x58\x38\x93\x75\xc6\x9e\xe3\x98\xde\x94\x83\x96",
          "\x84\xe4\x6b\xe8\xc0\x91\x90\x53", "\x4e\xe5\xcd\xa2\x0d\x42\x90",
          "\x4b\xd4\x72\x12\x94\x1c\xe3",
          "\x18\x5f\x14\x08\xee\x7f\xbf\x18\xf5\xab\xad\x6e\x22\x53\xa1\xba", 1,
          64, 56 },
        { 96, 256, 128, 18,
          "\x51\xe4\xbf\x2b\xad\x92\xb7\xaf\xf1\xa4\xbc\x05\x55\x0b\xa8\x1d\xf4"
          "\xb9\x6f\xab\xf4\x1c\x12\xc7\xb0\x0e\x60\xe4\x8d\xb7\xe1\x52",
          "\x4f\x07\xaf\xed\xfd\xc3\xb6\xc2\x36\x18\x23\xd3", "",
          "\xbe\x33\x08\xf7\x2a\x2c\x6a\xed",
          "\x8e\x94\x39\xa5\x6e\xee\xc8\x17",
          "\xfb\xe8\xa6\xed\x8f\xab\xb1\x93\x75\x39\xdd\x6c\x00\xe9\x00\x21", 1,
          0, 64 },
        { 96, 256, 128, 19,
          "\x11\x31\xc1\x41\x85\x77\xa0\x54\xde\x7a\x4a\xc5\x51\x95\x0f\x1a\x05"
          "\x3f\x9a\xe4\x6e\x5b\x75\xfe\x4a\xbd\x56\x08\xd7\xcd\xda\xdd",
          "\xb4\xea\x66\x6e\xe1\x19\x56\x33\x66\x48\x4a\x78",
          "\x66\xc0\xae\x70\x07\x6c\xb1\x4d",
          "\xa4\xc9\xc2\x80\x1b\x71\xf7\xdf",
          "\xb9\xb9\x10\x43\x3a\xf0\x52\xb0",
          "\x45\x30\xf5\x1a\xee\xe0\x24\xe0\xa4\x45\xa6\x32\x8f\xa6\x7a\x18", 1,
          64, 64 },
        { 96, 256, 128, 20,
          "\xe1\x09\x49\x67\xf8\x6d\x89\x3c\xdf\xe2\xe2\xe6\xd5\xc7\xee\x4d\xfe"
          "\xf6\x7d\xa3\xc9\xc5\xd6\x4e\x6a\xd7\xc1\x57\x7d\xcb\x38\xc5",
          "\x80\x92\xfc\x24\x5b\x33\x26\xcd\xdb\xd1\x42\x4c", "",
          "\xc3\x7a\xa7\x91\xdd\xd6\xac\xcf\x91",
          "\xd9\xd8\x97\xa9\xc1\xc5\xbb\x9f\x01",
          "\x08\x5a\x43\x03\x73\x05\x8f\x1a\x12\xa0\xd5\x89\xfd\x5b\xe6\x8b", 1,
          0, 72 },
        { 96, 256, 128, 21,
          "\x23\x6f\x9b\xae\xe4\xf9\xda\x15\xbe\xec\xa4\x0f\xf4\xaf\x7c\x76\x0f"
          "\x25\x4a\x64\xbc\x3a\x3d\x7f\x4f\xad\x55\x7e\x61\xb6\x85\x86",
          "\xf1\xca\x81\x33\x86\x29\x58\x7a\xcf\x93\x72\xbf",
          "\x8c\x32\xf4\x7a\x38\x61\x52\xec",
          "\xd7\xf2\x6d\x52\x52\xe1\x76\x5f\x5b",
          "\x8f\xdb\x42\x9d\x47\x76\x1c\xbf\x8e",
          "\x8e\xf6\x47\xed\x33\x4f\xde\xbb\xc2\xbe\xf8\x0b\xe0\x28\x84\xe0", 1,
          64, 72 },
        { 96, 256, 128, 22,
          "\x4d\xe2\x07\xa3\xb7\x0c\x51\xe5\xf2\x30\x48\xee\xd5\xa5\xda\x9b\xb6"
          "\x5e\x91\x7a\x69\xaa\x93\xe7\xc8\xb4\xa8\x15\xcd\x97\x24\xde",
          "\x4c\x15\xa7\x1d\xc6\x79\x1a\x8c\x00\x5a\xd5\x02", "",
          "\xf2\xc5\x4b\x6b\x5e\x49\x0d\xa1\x86\x59",
          "\x70\x0d\x35\xad\xf5\x10\x0a\x22\xa1\xde",
          "\x10\x2d\x99\x2f\xfa\xff\x59\x9b\x5b\xdd\xdd\xeb\x2d\xfb\x39\x9b", 1,
          0, 80 },
        { 96, 256, 128, 23,
          "\x6d\x66\x7f\xd7\x9e\x5f\xb7\x25\xf5\x03\x43\xdc\xcc\x48\x63\x22\x7c"
          "\x75\xee\x3f\x7a\x57\x84\x76\xe3\xe9\xf3\x25\x98\xd8\x15\x59",
          "\x62\x20\x52\x7a\xba\x88\xe2\x7f\x76\x66\x58\xb2",
          "\xe1\xe2\x7c\xcd\xdb\x3c\xb4\x07",
          "\x0c\x8c\x5a\x25\x26\x81\xf2\xb5\xb4\xc0",
          "\x04\xaa\xd6\x6c\x60\xe0\xbf\x8e\xbb\xa9",
          "\xc1\x5f\x69\xa4\xd2\xae\xf9\x7d\x77\x48\x75\x6f\xf4\x9d\x89\x4b", 1,
          64, 80 },
        { 96, 256, 128, 24,
          "\x8f\x4b\xd9\x4e\xf7\x3e\x75\xd1\xe0\x68\xc3\x0b\x37\xea\xd5\x76\xc5"
          "\x34\x4e\x09\x3e\xce\x13\x30\xe9\x10\x1c\x82\xf7\x93\xcf\x05",
          "\xec\x1e\x29\x67\xf0\xf6\x97\x9e\x5f\x5b\x07\xfb", "",
          "\xb8\x98\x12\xb3\x4d\x9b\xce\xd4\xa0\xba\x07",
          "\x1c\x3d\x53\xba\xaa\x36\xea\xa1\xd8\xec\x4d",
          "\x4d\x94\xeb\xf9\x60\xf1\x24\x33\xbe\xc4\x3a\xa8\x6d\x7e\x6e\x6d", 1,
          0, 88 },
        { 96, 256, 128, 25,
          "\x2a\xa3\xbc\x70\x33\x35\x1c\xac\x51\x36\x4c\xda\xf6\xff\xac\x2c\x20"
          "\xf6\x40\x46\xe1\x55\x0a\x7b\x1c\x65\xf4\x18\x00\x59\x90\x19",
          "\x28\xcc\xe5\x7a\x5d\xb2\xcd\x20\x63\x21\xe3\x40",
          "\xa9\xbc\x35\x0e\xaf\x2e\x6e\x3d",
          "\x83\x01\x68\x23\x12\x34\x84\xb5\x60\x95\xb0",
          "\x1c\x85\x78\xf8\xe7\x52\x03\xd0\x33\x6a\x52",
          "\x59\x10\xf7\xa9\xd5\xe4\xdf\x05\xd7\x24\x8b\xd7\xa8\xd6\x5e\x63", 1,
          64, 88 },
        { 96, 256, 128, 26,
          "\x99\xb6\x2b\xd5\xaf\xbe\x3f\xb0\x15\xbd\xe9\x3f\x0a\xbf\x48\x39\x57"
          "\xa1\xc3\xeb\x3c\xa5\x9c\xb5\x0b\x39\xf7\xf8\xa9\xcc\x51\xbe",
          "\x9a\x59\xfc\xe2\x6d\xf0\x00\x5e\x07\x53\x86\x56", "",
          "\x42\xba\xae\x59\x78\xfe\xaf\x5c\x36\x8d\x14\xe0",
          "\xff\x7d\xc2\x03\xb2\x6c\x46\x7a\x6b\x50\xdb\x33",
          "\x57\x8c\x0f\x27\x58\xc2\xe1\x4e\x36\xd4\xfc\x10\x6d\xcb\x29\xb4", 1,
          0, 96 },
        { 96, 256, 128, 27,
          "\x85\xf3\x5b\x62\x82\xcf\xf4\x40\xbc\x10\x20\xc8\x13\x6f\xf2\x70\x31"
          "\x11\x0f\xa6\x3e\xc1\x6f\x1e\x82\x51\x18\xb0\x06\xb9\x12\x57",
          "\x58\xdb\xd4\xad\x2c\x4a\xd3\x5d\xd9\x06\xe9\xce",
          "\xa5\x06\xe1\xa5\xc6\x90\x93\xf9",
          "\xfd\xc8\x5b\x94\xa4\xb2\xa6\xb7\x59\xb1\xa0\xda",
          "\x9f\x88\x16\xde\x09\x94\xe9\x38\xd9\xe5\x3f\x95",
          "\xd0\x86\xfc\x6c\x9d\x8f\xa9\x15\xfd\x84\x23\xa7\xcf\x05\x07\x2f", 1,
          64, 96 },
        { 96, 256, 128, 28,
          "\xfa\xf4\xbf\xe8\x01\x9a\x89\x1c\x74\x90\x1b\x17\xf4\xf4\x8c\xee\x5c"
          "\xd0\x65\xd5\x5f\xde\xa6\x01\x18\xaa\xf6\xc4\x31\x9a\x0e\xa5",
          "\xb7\x76\xc3\xfd\xdb\xa7\xc8\x13\x62\xce\x6e\x1b", "",
          "\x8d\xad\xff\x8d\x60\xc8\xe8\x8f\x60\x4f\x27\x48\x33",
          "\xe6\xb3\x3a\x74\xa4\xac\x44\x3b\xd9\x3f\x9c\x1b\x94",
          "\x0c\x11\x51\x72\xbd\xb0\x2b\xba\xd3\x13\x0f\xff\x22\x79\x0d\x60", 1,
          0, 104 },
        { 96, 256, 128, 29,
          "\x84\x10\x20\xd1\x60\x6e\xdc\xfc\x53\x6a\xbf\xb1\xa6\x38\xa7\xb9\x58"
          "\xe2\x1e\xfc\x10\xc3\x86\xac\x45\xa1\x84\x93\x45\x0a\xfd\x5f",
          "\x6d\x62\xf1\x59\x73\x1b\x14\x0e\xb1\x8c\xe0\x74",
          "\x5a\x8e\x1c\x7a\xa3\x98\x10\xd5",
          "\xd6\xaf\x13\x8f\x70\x1b\x80\x1e\x60\xc8\x5f\xfd\x5c",
          "\xb0\xa7\x50\x0a\xca\x45\xbb\x15\xf0\x1e\xce\x43\x89",
          "\x01\x60\xe8\x3a\xdb\xec\x7f\x6a\x2e\xe2\xff\x02\x15\xf9\xef\x00", 1,
          64, 104 },
        { 96, 256, 128, 30,
          "\x47\x0f\x9c\xe3\xd2\x25\x0b\xd6\x0c\xbb\xef\xdb\x2e\x6a\x11\x78\xc0"
          "\x12\x29\x9b\x55\x90\x63\x9c\x77\x97\xb6\x02\x4f\xa7\x03\xd8",
          "\xa9\xea\x4d\x61\x9f\xe4\x05\xd0\x4c\xba\x7d\x7a", "",
          "\x6c\xa6\x7d\xd0\x23\xfb\xa6\x50\x7b\x9f\x9a\x1f\x66\x7e",
          "\xd3\x01\x7e\x0b\xb1\x70\x5b\x38\x0b\x34\xcc\x33\x34\x50",
          "\x57\x08\xe7\x2c\xa2\xbd\x35\x4f\x48\x7f\x82\xf6\x7f\xbc\x3a\xcb", 1,
          0, 112 },
        { 96, 256, 128, 31,
          "\xe4\xb9\x7e\x91\xe4\xc8\xe8\x5e\xb7\xce\x0a\x7f\x30\xbf\x8a\x0a\xbf"
          "\x44\x68\x25\x1e\x4c\x63\x86\xc0\xe7\xaa\xcb\x8e\x87\x9a\xa8",
          "\x0e\x23\xc9\x42\xa0\xc9\xfb\x52\x65\x86\xee\xad",
          "\xea\xaa\xea\xb2\x69\x57\xf9\xa1",
          "\xb8\x4b\x3f\x74\xcd\x23\x06\x4b\xb4\x26\xfe\x2c\xed\x2b",
          "\x52\xe9\x67\x2b\x41\x6d\x84\xd9\x70\x33\x79\x60\x72\xd0",
          "\xe8\x38\x39\xdc\x1f\xd9\xb8\xb9\xd1\x44\x4c\x40\xe4\x88\xd4\x93", 1,
          64, 112 },
        { 96, 256, 128, 32,
          "\x67\x11\x96\x27\xbd\x98\x8e\xda\x90\x62\x19\xe0\x8c\x0d\x0d\x77\x9a"
          "\x07\xd2\x08\xce\x8a\x4f\xe0\x70\x9a\xf7\x55\xee\xec\x6d\xcb",
          "\x68\xab\x7f\xdb\xf6\x19\x01\xda\xd4\x61\xd2\x3c", "",
          "\x51\xf8\xc1\xf7\x31\xea\x14\xac\xdb\x21\x0a\x6d\x97\x3e\x07",
          "\x0b\x29\x63\x8e\x1f\xbd\xd6\xdf\x53\x97\x0b\xe2\x21\x00\x42",
          "\x2a\x91\x34\x08\x7d\x67\xa4\x6e\x79\x17\x8d\x0a\x93\xf5\xe1\xd2", 1,
          0, 120 },
        { 96, 256, 128, 33,
          "\xe6\xf1\x11\x8d\x41\xe4\xb4\x3f\xb5\x82\x21\xb7\xed\x79\x67\x38\x34"
          "\xe0\xd8\xac\x5c\x4f\xa6\x0b\xbc\x8b\xc4\x89\x3a\x58\x89\x4d",
          "\xd9\x5b\x32\x43\xaf\xae\xf7\x14\xc5\x03\x5b\x6a",
          "\x64\x53\xa5\x33\x84\x63\x22\x12",
          "\x97\x46\x9d\xa6\x67\xd6\x11\x0f\x9c\xbd\xa1\xd1\xa2\x06\x73",
          "\x32\xdb\x66\xc4\xa3\x81\x9d\x81\x55\x74\x55\xe5\x98\x0f\xed",
          "\xfe\xae\x30\xde\xc9\x4e\x6a\xd3\xa9\xee\xa0\x6a\x0d\x70\x39\x17", 1,
          64, 120 },
        { 96, 256, 128, 34,
          "\x59\xd4\xea\xfb\x4d\xe0\xcf\xc7\xd3\xdb\x99\xa8\xf5\x4b\x15\xd7\xb3"
          "\x9f\x0a\xcc\x8d\xa6\x97\x63\xb0\x19\xc1\x69\x9f\x87\x67\x4a",
          "\x2f\xcb\x1b\x38\xa9\x9e\x71\xb8\x47\x40\xad\x9b", "",
          "\x54\x9b\x36\x5a\xf9\x13\xf3\xb0\x81\x13\x1c\xcb\x6b\x82\x55\x88",
          "\xe9\x11\x0e\x9f\x56\xab\x3c\xa4\x83\x50\x0c\xea\xba\xb6\x7a\x13",
          "\x83\x6c\xca\xbf\x15\xa6\xa2\x2a\x51\xc1\x07\x1c\xfa\x68\xfa\x0c", 1,
          0, 128 },
        { 96, 256, 128, 35,
          "\xb9\x07\xa4\x50\x75\x51\x3f\xe8\xa8\x01\x9e\xde\xe3\xf2\x59\x14\x87"
          "\xb2\xa0\x30\xb0\x3c\x6e\x1d\x77\x1c\x86\x25\x71\xd2\xea\x1e",
          "\x11\x8a\x69\x64\xc2\xd3\xe3\x80\x07\x1f\x52\x66",
          "\x03\x45\x85\x62\x1a\xf8\xd7\xff",
          "\x55\xa4\x65\x64\x4f\x5b\x65\x09\x28\xcb\xee\x7c\x06\x32\x14\xd6",
          "\xe4\xb1\x13\xcb\x77\x59\x45\xf3\xd3\xa8\xae\x9e\xc1\x41\xc0\x0c",
          "\x7c\x43\xf1\x6c\xe0\x96\xd0\xdc\x27\xc9\x58\x49\xdc\x38\x3b\x7d", 1,
          64, 128 },
        { 96, 256, 128, 36,
          "\x3b\x24\x58\xd8\x17\x6e\x16\x21\xc0\xcc\x24\xc0\xc0\xe2\x4c\x1e\x80"
          "\xd7\x2f\x7e\xe9\x14\x9a\x4b\x16\x61\x76\x62\x96\x16\xd0\x11",
          "\x45\xaa\xa3\xe5\xd1\x6d\x2d\x42\xdc\x03\x44\x5d", "",
          "\x3f\xf1\x51\x4b\x1c\x50\x39\x15\x91\x8f\x0c\x0c\x31\x09\x4a\x6e"
          "\x1f",
          "\x02\xcc\x3a\xcb\x5e\xe1\xfc\xdd\x12\xa0\x3b\xb8\x57\x97\x64\x74"
          "\xd3",
          "\xd8\x3b\x74\x63\xa2\xc3\x80\x0f\xe9\x58\xc2\x8e\xaa\x29\x08\x13", 1,
          0, 136 },
        { 96, 256, 128, 37,
          "\xf6\x0c\x6a\x1b\x62\x57\x25\xf7\x6c\x70\x37\xb4\x8f\xe3\x57\x7f\xa7"
          "\xf7\xb8\x7b\x1b\xd5\xa9\x82\x17\x6d\x18\x23\x06\xff\xb8\x70",
          "\xf0\x38\x4f\xb8\x76\x12\x14\x10\x63\x3d\x99\x3d",
          "\x9a\xaf\x29\x9e\xee\xa7\x8f\x79",
          "\x63\x85\x8c\xa3\xe2\xce\x69\x88\x7b\x57\x8a\x3c\x16\x7b\x42\x1c"
          "\x9c",
          "\x35\x76\x64\x88\xd2\xbc\x7c\x2b\x8d\x17\xcb\xbb\x9a\xbf\xad\x9e"
          "\x6d",
          "\x1f\x39\x1e\x65\x7b\x27\x38\xdd\xa0\x84\x48\xcb\xa2\x81\x1c\xeb", 1,
          64, 136 },
        { 96, 256, 128, 38,
          "\x37\xce\xb5\x74\xcc\xb0\xb7\x01\xdd\x11\x36\x93\x88\xca\x27\x10\x17"
          "\x32\x33\x9f\x49\xd8\xd9\x08\xac\xe4\xb2\x3a\xf0\xb7\xce\x89",
          "\x37\x27\x0b\x36\x8f\x6b\x1e\x3e\x2c\xa5\x17\x44", "",
          "\xf2\x69\x91\x53\x72\x57\x37\x81\x51\xf4\x77\x6a\xad\x28\xae\x8b\xd1"
          "\x6b",
          "\xb6\x21\xd7\x6a\x8d\xac\xff\x00\xb3\xf8\x40\xcd\xf2\x6c\x89\x4c\xc5"
          "\xd1",
          "\xe0\xa2\x17\x16\xed\x94\xc0\x38\x2f\xa9\xb0\x90\x3d\x15\xbb\x68", 1,
          0, 144 },
        { 96, 256, 128, 39,
          "\x68\x88\x83\x61\x91\x9b\xc1\x06\x22\xf4\x5d\xf1\x68\xe5\xf6\xa0\x3b"
          "\xd8\xe8\x84\xc0\x61\x1b\xea\x2f\x34\xc1\x88\x2e\xd9\x83\x2b",
          "\xbf\xd6\xff\x40\xf2\xdf\x8c\xa7\x84\x59\x80\xcc",
          "\xb8\x37\x34\x38\xdd\xb2\xd6\xc3",
          "\xff\x97\xf2\xee\xfb\x34\x01\xac\x31\xfc\x8d\xc1\x59\x0d\x1a\x92\xcb"
          "\xc1",
          "\xe0\xa7\x45\x18\x6c\x1a\x7b\x14\x7f\x74\xfa\xff\x2a\x71\x5d\xf5\xc1"
          "\x9d",
          "\x91\x7b\xaf\x70\x3e\x35\x5d\x4d\x95\x0e\x6c\x05\xfe\x8f\x34\x9f", 1,
          64, 144 },
        { 96, 256, 128, 40,
          "\x1b\x35\xb8\x56\xb5\xa8\x6d\x34\x03\xd2\x8f\xc2\x10\x3a\x63\x1d\x42"
          "\xde\xca\x51\x75\xcd\xb0\x66\x9a\x5e\x5d\x90\xb2\xca\xaf\xc5",
          "\x23\x43\xde\x88\xbe\x6c\x71\x96\xd3\x3b\x86\x94", "",
          "\x21\xef\x18\x5c\x3a\xe9\xa9\x6f\xa5\xeb\x47\x38\x78\xf4\xd0\xb2\x42"
          "\x78\x1d",
          "\xd6\xe0\xed\x54\xfc\xce\xf3\x0b\xd6\x05\xd7\x2d\xa3\x32\x0e\x24\x9a"
          "\x9c\xb5",
          "\xc6\x8b\xc6\x72\x4e\xc8\x03\xc4\x39\x84\xce\x42\xf6\xbd\x09\xff", 1,
          0, 152 },
        { 96, 256, 128, 41,
          "\xd6\x48\x4e\x39\x73\xf6\xbe\x8c\x83\xed\x32\x08\xd5\xbe\x5c\xfa\x06"
          "\xfd\xa7\x2f\xbf\xdc\x5b\x19\xd0\x9b\xe3\xf4\xe4\xeb\xa2\x9d",
          "\x1a\xf1\xd9\x0e\x87\x7e\x11\xa4\x96\xef\xa3\xdf",
          "\xcc\x4e\xfd\x83\x64\xfb\x11\x4a",
          "\x73\x35\xab\x04\xb0\x3e\x70\x61\x09\xec\x3e\xe8\x35\xdb\x9a\x24\x6e"
          "\xa0\xad",
          "\x29\xe5\x4d\x60\x82\x37\xc3\xc3\x60\x9d\xba\x16\xe6\xed\xf4\x38\x42"
          "\xd7\x2f",
          "\xd3\x36\x5f\xdc\xd5\x06\xaa\xaa\x53\x68\x66\x1e\x80\xe9\xd9\x9b", 1,
          64, 152 },
        { 96, 256, 128, 42,
          "\x42\x2a\xdd\x37\x84\x9d\x6e\x4c\x3d\xfd\x80\x20\xdc\x6a\x07\xe8\xa2"
          "\x49\x78\x8f\x3d\x6a\x83\xb9\xcb\x4d\x80\x23\x62\xc9\x75\x42",
          "\x1e\x7e\x67\xbe\x94\x8d\xe7\x35\x2f\xfd\xb7\x27", "",
          "\xd7\xf5\xe6\x11\xdd\x3a\x27\x50\xfb\x84\x3f\xc1\xb6\xb9\x30\x87\x31"
          "\x0d\xc8\x7d",
          "\x7f\xe6\x06\x65\x2d\x85\x8f\x59\x5e\xc2\xe7\x06\x75\x4f\xa3\xd9\x33"
          "\xfc\xc8\x34",
          "\x78\xd5\x92\x35\xaa\x5d\x03\xa4\xc3\x25\x90\xe5\x90\xc0\x4d\x22", 1,
          0, 160 },
        { 96, 256, 128, 43,
          "\xcd\xcc\xfe\x3f\x46\xd7\x82\xef\x47\xdf\x4e\x72\xf0\xc0\x2d\x9c\x7f"
          "\x77\x4d\xef\x97\x0d\x23\x48\x6f\x11\xa5\x7f\x54\x24\x7f\x17",
          "\x37\x61\x87\x89\x46\x05\xa8\xd4\x5e\x30\xde\x51",
          "\x95\x68\x46\xa2\x09\xe0\x87\xed",
          "\xe2\x8e\x0e\x9f\x9d\x22\x46\x3a\xc0\xe4\x26\x39\xb5\x30\xf4\x21\x02"
          "\xfd\xed\x75",
          "\x14\xf7\x07\xc4\x46\x98\x8a\x49\x03\x77\x5e\xc7\xac\xec\x6d\xa1\x14"
          "\xd4\x31\x12",
          "\x98\x7d\x4b\x14\x7c\x49\x0d\x43\xd3\x76\xa1\x98\xca\xb3\x83\xf0", 1,
          64, 160 },
        { 96, 256, 128, 44,
          "\xe7\x9d\xfc\x6d\x2f\xc4\x65\xb8\x43\x9e\x1c\x5b\xac\xcb\x5d\x8e\xf2"
          "\x85\x38\x99\xfc\x19\x75\x3b\x39\x7e\x6c\x25\xb3\x5e\x97\x7e",
          "\xf9\xd6\x32\x0d\x7c\xe5\x1d\x8e\xd0\x67\x7d\x3a", "",
          "\x4f\x54\x3e\x79\x38\xd1\xb8\x78\xda\xca\xee\xc8\x1d\xce\x48\x99\x97"
          "\x48\x16\x81\x3b",
          "\x10\x03\xf1\x3e\xa1\x32\x9c\xbb\x18\x73\x16\xf6\x4c\x3f\xf3\xa8\x7c"
          "\xf5\xb9\x66\x61",
          "\xd2\x32\x3a\xd6\x25\x09\x4b\xec\x84\x79\x0d\x79\x58\xd5\x58\x3f", 1,
          0, 168 },
        { 96, 256, 128, 45,
          "\x1d\x7b\x8f\x1d\x96\xa1\x42\x49\x23\xae\xf8\xa9\x84\x86\x9d\x4a\x77"
          "\x7a\x11\x09\x90\xba\x46\x56\x27\xac\xf8\x03\x96\xc7\xf3\x76",
          "\x50\xba\x19\x62\xcd\xc3\x2a\x5a\x2d\x36\xe6\x40",
          "\x09\x30\x53\xe2\x02\x61\xda\xab",
          "\x5d\x3e\xfd\x57\x67\xf3\xc1\x2e\xfd\x08\xaf\x9a\x44\xe0\x28\xae\x68"
          "\xc9\xef\xf8\x43",
          "\x2d\x48\xb0\x83\x4e\x9f\xfe\x30\x46\x10\x3e\xf7\xa2\x14\xf0\x2e\x8e"
          "\x4d\x33\x36\x0e",
          "\xd5\x33\xad\x08\x9b\xe2\x29\xea\x60\x6e\xc0\xf3\xfa\x22\xeb\x33", 1,
          64, 168 },
        { 96, 256, 128, 46,
          "\xdd\x43\x3e\x28\xcf\xbc\xb5\xde\x4a\xb3\x6a\x02\xbf\x38\x68\x6d\x83"
          "\x20\x87\x71\xa0\xe6\x3d\xcd\x08\xb4\xdf\x1a\x07\xac\x47\xa1",
          "\xc9\xcc\x0a\x1a\xfc\x38\xec\x6c\x30\xc3\x8c\x68", "",
          "\x8a\x3e\x17\xab\xa9\x60\x6d\xd4\x9e\x3b\x1a\x4d\x9e\x5e\x42\xf1\x74"
          "\x23\x73\x63\x24\x89",
          "\xe9\x91\x7f\xf3\xe6\x4b\xbe\x17\x83\x57\x93\x75\xe7\x5e\xa8\x23\x97"
          "\x6b\x35\x53\x99\x49",
          "\x07\x4a\x89\x06\x69\xb2\x51\x05\x43\x4c\x75\xbe\xed\x32\x48\xdb", 1,
          0, 176 },
        { 96, 256, 128, 47,
          "\xa6\x09\x24\x10\x1b\x42\xac\x24\x15\x4a\x88\xde\x42\x14\x2b\x23\x34"
          "\xcf\x59\x91\x76\xca\xf4\xd1\x22\x6f\x71\x2d\xd9\x17\x29\x30",
          "\x8b\xa7\x76\x44\xb0\x8d\x65\xd5\xe9\xf3\x19\x42",
          "\xb2\xa4\xe1\x2a\x19\xa6\x1c\x75",
          "\xc9\x49\x95\x7e\x66\x43\x9d\xee\xe4\xb2\xac\x1d\x4a\x6c\x98\xa6\xc5"
          "\x27\xb9\x0f\x52\xab",
          "\xdb\x4c\x70\x05\x13\x81\x89\x72\xb0\xdc\x0e\x53\x1b\x1c\x28\x1c\xa0"
          "\x3e\x40\xc6\x0d\xea",
          "\x63\xf4\x47\x8b\xba\x2a\xf4\x69\xa7\xa4\xdc\x3b\x4f\x14\x13\x60", 1,
          64, 176 },
        { 96, 256, 128, 48,
          "\x1a\xa4\x20\x27\x83\x69\x65\xb1\xe6\x08\x6f\xa1\x37\xf9\xcf\x7f\x1f"
          "\xf4\x86\x76\x69\x68\x29\xbd\x28\x1f\xf8\x1c\x8e\xa0\xa4\xa9",
          "\x4b\x3d\xca\x84\xec\xc4\x07\xf4\x24\xf2\x81\xa9", "",
          "\x37\x25\x2a\x3e\xb5\xc8\x96\x0f\x05\x67\xe5\x03\xa9\x03\x57\x83\xb3"
          "\xd0\xa1\x9a\x4b\x9a\x47",
          "\xb5\xf1\x46\x17\x49\x1f\xc9\x23\xb6\x83\xe2\xcc\x95\x62\xd0\x43\xdd"
          "\x59\x86\xb9\x7d\xbd\xbd",
          "\x97\x2c\xe5\x47\x13\xc0\x5c\x4b\xb4\xd0\x88\xc0\xa3\x0c\xac\xd3", 1,
          0, 184 },
        { 96, 256, 128, 49,
          "\x5d\x40\xdb\x0c\xc1\x8e\xf2\xe4\x28\x15\xd3\xb6\x24\x5a\x46\x6a\x0b"
          "\x30\xa0\xf9\x3e\x31\x8a\xc1\x0e\xdd\xe3\xbf\x8a\xd9\x81\x60",
          "\xac\xad\x61\x80\x39\xb3\x17\x47\x0d\x21\x62\x1b",
          "\x41\x30\x36\x41\x1a\xf7\x57\x45",
          "\x95\x9d\xde\x1e\xf3\x12\x9b\x27\x70\x2c\x55\x88\x49\xe4\x66\xf2\xba"
          "\xca\x1a\x45\xbd\xf4\xb2",
          "\xb7\xca\x38\x79\xf9\x51\x40\xbf\x6a\x97\xb3\x21\x22\x18\xb7\xbf\x86"
          "\x4a\x51\xe5\xbb\x0b\x3e",
          "\xfe\x55\x8f\xb5\x70\x14\x54\x70\xea\x69\x3e\xb7\x6e\xb7\x31\x71", 1,
          64, 184 },
        { 96, 256, 128, 50,
          "\x02\x12\xa8\xde\x50\x07\xed\x87\xb3\x3f\x1a\x70\x90\xb6\x11\x4f\x9e"
          "\x08\xce\xfd\x96\x07\xf2\xc2\x76\xbd\xcf\xdb\xc5\xce\x9c\xd7",
          "\xe6\xb1\xad\xf2\xfd\x58\xa8\x76\x2c\x65\xf3\x1b", "",
          "\x10\xf1\xec\xf9\xc6\x05\x84\x66\x5d\x9a\xe5\xef\xe2\x79\xe7\xf7\x37"
          "\x7e\xea\x69\x16\xd2\xb1\x11",
          "\x42\xf2\x6c\x56\xcb\x4b\xe2\x1d\x9d\x8d\x0c\x80\xfc\x99\xdd\xe0\x0d"
          "\x75\xf3\x80\x74\xbf\xe7\x64",
          "\x54\xaa\x7e\x13\xd4\x8f\xff\x7d\x75\x57\x03\x94\x57\x04\x0a\x3a", 1,
          0, 192 },
        { 96, 256, 128, 51,
          "\xc5\xbc\x09\x56\x56\x46\xe7\xed\xda\x95\x4f\x1f\x73\x92\x23\xda\xda"
          "\x20\xb9\x5c\x44\xab\x03\x3d\x0f\xae\x4b\x02\x83\xd1\x8b\xe3",
          "\x6b\x28\x2e\xbe\xcc\x54\x1b\xcd\x78\x34\xed\x55",
          "\x3e\x8b\xc5\xad\xe1\x82\xff\x08",
          "\x92\x22\xf9\x01\x8e\x54\xfd\x6d\xe1\x20\x08\x06\xa9\xee\x8e\x4c\xc9"
          "\x04\xd2\x9f\x25\xcb\xa1\x93",
          "\x12\x30\x32\x43\x7b\x4b\xfd\x69\x20\xe8\xf7\xe7\xe0\x08\x7a\xe4\x88"
          "\x9e\xbe\x7a\x0a\xd0\xe9\x00",
          "\x3c\xf6\x8f\x17\x95\x50\xda\x63\xd3\xb9\x6c\x2d\x55\x41\x18\x65", 1,
          64, 192 },
        { 96, 256, 128, 52,
          "\x94\x60\xb3\xc4\x4e\xd8\x6e\x70\xf3\xbd\xa6\x63\x85\xe1\xca\x10\xb0"
          "\xc1\x67\x7e\xf4\xf1\x36\x05\x32\x83\x0d\x17\x53\x5f\x99\x6f",
          "\xab\xfa\xf4\x2e\x0d\xba\x88\x4e\xfc\xf0\x78\x23", "",
          "\x5c\x5c\xce\x88\x1b\x93\xfb\x7a\x1b\x79\x39\xaf\x1f\xfc\x5f\x84\xd3"
          "\x28\x0a\xda\x77\x8c\xca\x09\x53",
          "\x1d\x21\x8c\x9f\x1f\x9f\x02\xf2\x48\xa6\xf9\x76\xa7\x55\x70\x57\xf3"
          "\x7d\x93\x93\xd9\xf2\x13\xc1\xf3",
          "\xbc\x88\x34\x4c\x6f\xdc\x89\x8f\xee\xd3\x94\xfb\x28\x51\x13\x16", 1,
          0, 200 },
        { 96, 256, 128, 53,
          "\xc1\x11\xd6\xd5\xd7\x8a\x07\x1b\x15\xab\x37\xcc\x8c\x38\x19\x19\x93"
          "\x87\xab\x7c\x19\x33\xaa\x97\xb1\x48\x9f\x65\x84\xba\x8e\x2a",
          "\x85\xf1\x8a\xd8\xff\x72\xca\xfe\xe2\x45\x2a\xb8",
          "\x84\xcd\xff\x93\x93\x91\xc0\x22",
          "\x69\x89\xc6\x46\xa1\x0b\x7c\x76\xf4\xd9\xf7\xd5\x74\xda\x40\xe1\x52"
          "\x01\x3c\xf0\xdd\x78\xf5\xaa\x8a",
          "\x97\x15\xd3\x44\xe8\xd3\xf3\xa3\xea\xa9\x8a\x9c\xea\x57\xc0\xcd\x71"
          "\x7c\x6e\xf5\x07\x60\x27\xc9\xec",
          "\x30\x56\xff\x5e\xe0\xaa\x86\x36\xbb\x63\x99\x84\xed\xb5\x23\x6b", 1,
          64, 200 },
        { 96, 256, 128, 54,
          "\x8a\x1b\x1e\x69\x9a\x0c\x4a\x3e\x61\x0b\x10\x90\x2d\xae\xda\xb1\xbf"
          "\x1e\xa0\xd5\x05\xc4\x7d\x78\x42\xcb\xce\xe0\xd3\xb1\xb6\xe6",
          "\xa6\xf9\xa8\xd3\x35\xfa\x84\xc3\xb2\x7d\xcd\x2a", "",
          "\xee\x6a\x15\xfc\x18\x31\x08\xf0\x87\x7e\x7f\x2b\x8a\x96\x15\xf4\xb3"
          "\xfc\x36\xe1\xc8\x34\x40\xf6\x6a\xad",
          "\x90\x89\xbb\xdb\x8b\xcf\xd1\x24\xe2\x27\xbf\x75\xc4\xbf\xe1\xcb\xa2"
          "\x00\x4a\x27\x4f\xc3\x1a\xa3\x23\x58",
          "\xfd\x2e\x21\xc6\x4a\x01\x96\x21\xc6\x85\x94\x82\x6c\xd7\xb1\xcd", 1,
          0, 208 },
        { 96, 256, 128, 55,
          "\x74\xb3\x84\xe6\xe0\x13\xec\x41\x72\xed\x7a\x28\xa1\x0f\xb9\xbb\x79"
          "\xb4\xbe\x2a\x24\xf6\x99\x9e\x3d\x3c\xaa\x28\xe6\x4a\x86\x56",
          "\xeb\xc1\x9f\xc9\xec\xb2\x33\x99\x08\xea\x38\x36",
          "\x85\x07\x3f\x2e\xdc\x13\xd3\xa1",
          "\x3a\xa9\xf7\x37\x2f\x05\x6e\x5a\x07\x29\x75\x2d\x9a\x37\x13\x2d\x6d"
          "\xd0\x7c\x56\x79\x2e\x1c\x75\x82\xa9",
          "\x79\x6f\xfb\x70\xab\x43\xe7\xfa\x79\xf9\x55\x83\xe3\x84\x52\x47\x27"
          "\xbb\x3e\x47\xfc\x45\xb9\x69\xf7\x14",
          "\xc3\x32\x2b\x44\x45\xde\x5f\x3c\x9f\x18\xdc\xc8\x47\xcc\x94\xc3", 1,
          64, 208 },
        { 96, 256, 128, 56,
          "\x77\xd8\x24\x79\x5d\x20\x29\xf0\xeb\x0e\x0b\xaa\xb5\xcf\xeb\x32\xf7"
          "\xe9\x34\x74\x91\x3a\x7f\x95\xc7\x37\xa6\x67\xa3\xc3\x33\x14",
          "\xf3\x30\x74\x30\xf4\x92\xd2\xb8\xa7\x2d\x3a\x81", "",
          "\x0c\x41\x79\xa4\x97\xd8\xfd\xd7\x27\x96\xfb\x72\x56\x92\xb8\x05\xd6"
          "\x3b\x7c\x71\x83\x59\xcf\x10\x51\x8a\xee",
          "\x49\xc8\x1d\x17\xd6\x7d\x7b\xa9\x95\x4f\x49\x7d\x0b\x0d\xdc\x21\xf3"
          "\xf8\x39\xc9\xd2\xcc\x19\x8d\x30\xbc\x2c",
          "\x50\x00\x98\x99\xe5\xb2\xa9\x72\x6c\x8f\x35\x56\xca\xdf\xbe\x84", 1,
          0, 216 },
        { 96, 256, 128, 57,
          "\xbe\xc5\xea\xc6\x8f\x89\x39\x51\xcb\xd7\xd1\xec\xd3\xee\x66\x11\x13"
          "\x0d\xd9\xc3\xf8\x0c\xdd\xf9\x51\x11\xd0\x7d\x5e\xdd\x76\xd1",
          "\x34\x2a\xda\x4f\x0c\x11\x51\x24\xb2\x22\xdf\x80",
          "\x73\x36\x5f\x6d\x80\xed\xb1\xd8",
          "\x48\x14\x33\xd8\xb1\xcd\x38\xaf\x4a\x75\x0e\x13\xa6\x4b\x7a\x4e\x85"
          "\x07\x68\x2b\x35\x17\x59\x59\x38\xa2\x0e",
          "\x4c\x12\x9f\xc1\x3c\xbd\xd9\xd3\xfe\x81\xac\x75\x5b\xf4\xfb\xea\x2f"
          "\xdd\x7e\x0a\xca\x05\x05\xa6\xee\x96\x37",
          "\x9c\xed\xe1\xd3\x0a\x03\xdb\x5d\x55\x26\x5d\x36\x48\xbc\x40\xd4", 1,
          64, 216 },
        { 96, 256, 128, 58,
          "\xa5\x9c\x1e\x13\x06\x4d\xf8\xf2\xb8\xdf\x77\xa4\x92\xb0\xca\x2e\xae"
          "\x92\x1b\x52\xa8\x4b\x30\x5a\x3a\x9a\x51\x40\x8a\x9e\xcb\x69",
          "\x95\x44\xd4\x1e\xce\x0c\x92\xef\x01\xcf\xac\x2d", "",
          "\x1c\x35\xb8\x98\x82\x1b\xa5\x5c\x26\x17\xc2\x5d\xf9\xe6\xdf\x2a\x80"
          "\x02\xb3\x84\x90\x21\x86\xcd\x69\xdf\xd2\x0e",
          "\xa6\xfa\x8f\x57\xdd\xc8\x1d\x60\x99\xf6\x67\xdd\x62\x40\x2b\x6a\x5d"
          "\x5b\x7d\x05\xa3\x29\x29\x80\x29\x11\x31\x69",
          "\xbb\x24\xe3\x8b\x31\xdb\xbc\x3e\x57\x5b\x9e\x3e\xe0\x76\xaf\x2a", 1,
          0, 224 },
        { 96, 256, 128, 59,
          "\x08\x4b\x5d\x73\x65\xf1\xa8\xfe\xc6\x36\x59\x39\xed\x74\x1e\x6e\xa5"
          "\x89\x3e\x03\x18\xd8\x2a\xb4\x75\x00\xa9\x7d\x77\xaa\xa0\x41",
          "\x82\x9f\x00\x5e\x98\x0f\x0a\x6e\x2f\x98\x3e\xaa",
          "\x77\x0f\x6e\x6e\x89\xa3\xfe\x8e",
          "\x75\x10\x01\x6e\xfa\xdc\x38\x5a\x71\xed\x68\x9c\xeb\x59\x0c\x8e\xa9"
          "\xcc\x1e\x81\xb7\x93\x33\x8b\xdd\xf5\xf1\x0c",
          "\xfd\x42\xcb\x5c\xf8\x94\xf8\x79\xe3\xcf\x75\x16\x62\xaa\xa5\x8a\x22"
          "\x88\xcc\x53\x54\x88\x02\xbe\xca\xf4\x23\x59",
          "\x18\x83\x29\x43\x8a\xfe\x1c\xd7\x22\x5d\x04\x78\xaa\x90\xc7\x73", 1,
          64, 224 },
        { 96, 256, 128, 60,
          "\x5a\x7f\x85\x0a\x1d\x9a\xaf\xa7\x7d\x59\xae\x1b\x73\x19\x65\xe8\xaa"
          "\xec\x63\x52\x28\x0f\xc7\x6a\x7b\x5e\x23\xef\x36\x10\xcf\xe4",
          "\x49\x46\xa0\xd6\xad\xea\x93\xb8\x2d\x43\x32\xe5", "",
          "\x3c\x16\x1d\x79\x1f\x62\x4f\xb0\x38\x8e\x80\x8f\x0f\x69\xed\x79\x0d"
          "\xbe\x4c\xbd\x08\x9e\xba\xc4\x66\x27\xbc\xf0\x1d",
          "\x40\x23\x02\xb5\x61\x40\xc4\xdc\xc3\x97\x74\x73\x2c\x55\x88\x3d\xe1"
          "\x24\xce\x4b\xf0\xa0\x26\x1c\xfa\x15\x69\xe2\xcf",
          "\xe8\x30\xbf\xe9\x33\xa9\x67\x86\xcf\xf2\xdd\x72\xb8\x2c\x4b\xd5", 1,
          0, 232 },
        { 96, 256, 128, 61,
          "\xe6\xd5\xa4\x24\x6f\x6f\x05\x61\x8b\x59\xc8\xf9\xec\x3a\xc8\x06\x8c"
          "\xc0\xd3\xf3\x51\xc5\x71\xaa\x52\xb0\x9c\xb2\x51\xf9\xc2\xf6",
          "\x2f\x90\xa6\x5e\x9e\x48\x72\x5d\xe6\xff\xc7\x27",
          "\xf2\x41\x53\x77\xad\x28\x3f\xd8",
          "\x96\x4f\xc9\xe0\xe8\x35\x59\x47\xaa\x1c\x2c\xaa\xdd\x7b\x3d\xbe\xf8"
          "\x2a\x10\x24\xe6\x23\x60\x6f\xac\x43\x6e\xf5\x73",
          "\xd0\x52\x93\x2b\xad\x6e\x6c\x4f\x83\x5f\x02\x01\x9e\x52\xd7\xff\x80"
          "\x7d\xc2\xa5\xaa\xc2\x04\x08\x83\xc7\x9d\xd3\xd5",
          "\x65\x5f\x93\x39\x6b\x4d\x75\x5d\xc4\x47\x57\x21\x66\x5f\xed\x91", 1,
          64, 232 },
        { 96, 256, 128, 62,
          "\x09\xe8\x22\x12\x3a\xdb\xb1\xed\x89\xb7\x9a\x58\x61\x9c\x64\x85\x39"
          "\x92\xf8\x37\x1d\x46\x33\x87\x12\xf6\xc9\x1a\xb1\x1a\x68\xbb",
          "\xa7\x97\x20\x5a\x6c\xac\xdd\x7e\x47\xa4\x78\x9d", "",
          "\x80\xb7\x1b\xbe\x83\x36\x29\x84\x1b\xd3\xae\xae\xb9\xdb\x61\x23\xe5"
          "\x1d\x36\x7b\x43\x6f\xe9\xd2\xd3\x45\x4b\x62\xcf\xad",
          "\x83\xf5\xc7\x73\x96\xca\xbd\x28\xdf\xcc\x00\x2c\xba\x07\x56\xd4\xea"
          "\x54\x55\xe0\x26\x1d\x84\x7d\x57\x08\xaa\xc2\x1e\x8d",
          "\x70\x5a\x05\x82\x0a\x21\xf3\x81\xd2\x44\xd4\x0e\x58\xd2\xf1\x6b", 1,
          0, 240 },
        { 96, 256, 128, 63,
          "\x62\x57\x35\xfe\x7f\x8f\xc8\x1b\x0c\x1e\xdc\x3d\x08\xa7\x8b\x41\x26"
          "\x8f\x87\xa3\xc6\x84\x88\xb6\x74\x22\x26\x30\xc1\xd5\x87\xa5",
          "\x9d\x8c\xdf\x28\x9d\xdd\xd0\x9a\xfd\xc1\xb0\x2f",
          "\x20\x0a\x9c\x95\x94\x6f\xf0\x5c",
          "\x67\xae\x18\x82\xd0\xb1\xc1\xb2\x48\x5b\xec\x98\x11\x5e\xcf\x53\xb9"
          "\xb4\x38\xde\xb1\xd0\x40\x05\x31\x70\x50\x38\x87\x3a",
          "\x20\x9b\x75\x39\x38\x5c\x8b\x19\xec\xd0\xfd\x8b\x50\x11\xb2\x99\x6e"
          "\x31\x6f\x19\x42\x06\x4e\x68\xed\xfa\x36\x3a\xcb\xcd",
          "\xfa\x2f\x45\x4b\x9f\xa2\x60\x8f\x78\x0f\x7c\x6f\x9b\x78\x0f\xe1", 1,
          64, 240 },
        { 96, 256, 128, 64,
          "\x2e\xb5\x1c\x46\x9a\xa8\xeb\x9e\x6c\x54\xa8\x34\x9b\xae\x50\xa2\x0f"
          "\x0e\x38\x27\x11\xbb\xa1\x15\x2c\x42\x4f\x03\xb6\x67\x1d\x71",
          "\x04\xa9\xbe\x03\x50\x8a\x5f\x31\x37\x1a\x6f\xd2", "",
          "\xb0\x53\x99\x92\x86\xa2\x82\x4f\x42\xcc\x8c\x20\x3a\xb2\x4e\x2c\x97"
          "\xa6\x85\xad\xcc\x2a\xd3\x26\x62\x55\x8e\x55\xa5\xc7\x29",
          "\x45\xc7\xd6\xb5\x3a\xca\xd4\xab\xb6\x88\x76\xa6\xe9\x6a\x48\xfb\x59"
          "\x52\x4d\x2c\x92\xc9\xd8\xa1\x89\xc9\xfd\x2d\xb9\x17\x46",
          "\x56\x6d\x3c\xa1\x0e\x31\x1b\x69\x5f\x3e\xae\x15\x51\x65\x24\x93", 1,
          0, 248 },
        { 96, 256, 128, 65,
          "\x7f\x5b\x74\xc0\x7e\xd1\xb4\x0f\xd1\x43\x58\xfe\x2f\xf2\xa7\x40\xc1"
          "\x16\xc7\x70\x65\x10\xe6\xa4\x37\xf1\x9e\xa4\x99\x11\xce\xc4",
          "\x47\x0a\x33\x9e\xcb\x32\x19\xb8\xb8\x1a\x1f\x8b",
          "\x37\x46\x18\xa0\x6e\xa9\x8a\x48",
          "\xf4\x52\x06\xab\xc2\x55\x52\xb2\xab\xc9\xab\x7f\xa2\x43\x03\x5f\xed"
          "\xaa\xdd\xc3\xb2\x29\x39\x56\xf1\xea\x6e\x71\x56\xe7\xeb",
          "\x46\xa8\x0c\x41\x87\x02\x47\x20\x08\x46\x27\x58\x00\x80\xdd\xe5\xa3"
          "\xf4\xa1\x10\x93\xa7\x07\x6e\xd6\xf3\xd3\x26\xbc\x7b\x70",
          "\x53\x4d\x4a\xa2\x83\x5a\x52\xe7\x2d\x14\xdf\x0e\x4f\x47\xf2\x5f", 1,
          64, 248 },
        { 96, 256, 128, 66,
          "\xe1\x73\x1d\x58\x54\xe1\xb7\x0c\xb3\xff\xe8\xb7\x86\xa2\xb3\xeb\xf0"
          "\x99\x43\x70\x95\x47\x57\xb9\xdc\x8c\x7b\xc5\x35\x46\x34\xa3",
          "\x72\xcf\xd9\x0e\xf3\x02\x6c\xa2\x2b\x7e\x6e\x6a", "",
          "\xb9\xc5\x54\xcb\xc3\x6a\xc1\x8a\xe8\x97\xdf\x7b\xee\xca\xc1\xdb\xeb"
          "\x4e\xaf\xa1\x56\xbb\x60\xce\x2e\x5d\x48\xf0\x57\x15\xe6\x78",
          "\xea\x29\xaf\xa4\x9d\x36\xe8\x76\x0f\x5f\xe1\x97\x23\xb9\x81\x1e\xd5"
          "\xd5\x19\x93\x4a\x44\x0f\x50\x81\xac\x43\x0b\x95\x3b\x0e\x21",
          "\x22\x25\x41\xaf\x46\xb8\x65\x33\xc6\xb6\x8d\x2f\xf1\x08\xa7\xea", 1,
          0, 256 },
        { 96, 256, 128, 67,
          "\x27\xd8\x60\x63\x1b\x04\x85\xa4\x10\x70\x2f\xea\x61\xbc\x87\x3f\x34"
          "\x42\x26\x0c\xad\xed\x4a\xbd\xe2\x5b\x78\x6a\x2d\x97\xf1\x45",
          "\x26\x28\x80\xd4\x75\xf3\xda\xc5\x34\x0d\xd1\xb8",
          "\x23\x33\xe5\xce\x0f\x93\xb0\x59",
          "\x6b\x26\x04\x99\x6c\xd3\x0c\x14\xa1\x3a\x52\x57\xed\x6c\xff\xd3\xbc"
          "\x5e\x29\xd6\xb9\x7e\xb1\x79\x9e\xb3\x35\xe2\x81\xea\x45\x1e",
          "\x6d\xad\x63\x78\x97\x54\x4d\x8b\xf6\xbe\x95\x07\xed\x4d\x1b\xb2\xe9"
          "\x54\xbc\x42\x7e\x5d\xe7\x29\xda\xf5\x07\x62\x84\x6f\xf2\xf4",
          "\x7b\x99\x7d\x93\xc9\x82\x18\x9d\x70\x95\xdc\x79\x4c\x74\x62\x32", 1,
          64, 256 },
        { 96, 256, 128, 68,
          "\x51\x55\xde\xe9\xaa\xde\x1c\xc6\x1e\xe7\xe3\xf9\x26\x60\xf7\x59\x0f"
          "\x5e\x5b\xa8\x2f\x1b\x59\xb8\x50\xe3\xfa\x45\x3d\x2f\xa6\xb3",
          "\xc2\x6c\x4b\x3b\xfd\xb9\x7e\xe6\xb0\xf6\x3c\xa1", "",
          "\x27\x34\xe0\x8e\xff\x8f\x5c\x4f\x84\xfa\x0c\x20\x7f\x49\xc7\xfd\x78"
          "\xaf\x1a\xd5\x12\x3f\xf8\x1f\x83\xf5\x00\xed\xf4\xed\xa0\x9e\xdf",
          "\xf5\x98\x2b\x60\x1c\x7a\x18\xfc\x72\xa6\x5b\x21\x8c\x44\x97\x4d\xc5"
          "\x64\xd8\x31\x4c\xbe\x6f\x87\xfc\xf6\xc6\xcf\xbe\x61\x8b\x34\xb1",
          "\xc4\x36\x32\xf5\x57\x60\xb5\xd1\xed\x37\x55\x6a\x94\xd0\x49\xb5", 1,
          0, 264 },
        { 96, 256, 128, 69,
          "\x57\x3f\x08\xeb\xbe\x0c\xce\x4a\xc9\x61\x8e\x8c\x3b\x22\x4b\xea\x0a"
          "\x32\xf0\x55\xc6\x99\x68\x38\xa3\x2f\x52\x7c\xa3\xc3\xb6\x95",
          "\xad\x80\x50\xdc\x6d\x12\x2d\xce\x3e\x56\x39\xed",
          "\xe9\x96\x98\x24\x1c\x59\x9b\x5f",
          "\x66\x8d\x5e\x3f\x95\xfe\x03\x0d\xaf\x43\x2a\x5f\xc5\x83\x7a\xf3\xa7"
          "\x9c\x81\xe9\x4b\x28\xd8\x20\x4c\x5e\xe2\x62\xab\x3c\x99\x08\xa7",
          "\xea\xf6\x81\x0e\x6e\xc1\xcb\x7a\x29\x18\x85\x62\x57\xd1\xaa\x3d\x51"
          "\xa8\x27\x87\x91\x46\xc6\x33\x7e\xcf\x53\x5e\x9c\x89\xb1\x49\xc5",
          "\xa2\x95\x0c\x2f\x39\x4a\x34\x66\xc3\x45\xf7\x96\x32\x3c\x1a\xa7", 1,
          64, 264 },
        { 96, 256, 128, 70,
          "\xcf\x0d\x40\xa4\x64\x4e\x5f\x51\x81\x51\x65\xd5\x30\x1b\x22\x63\x1f"
          "\x45\x44\xc4\x9a\x18\x78\xe3\xa0\xa5\xe8\xe1\xaa\xe0\xf2\x64",
          "\xe7\x4a\x51\x5e\x7e\x21\x02\xb9\x0b\xef\x55\xd2", "",
          "\x97\x3d\x0c\x75\x38\x26\xba\xe4\x66\xcf\x9a\xbb\x34\x93\x15\x2e\x9d"
          "\xe7\x81\x9e\x2b\xd0\xc7\x11\x71\x34\x6b\x4d\x2c\xeb\xf8\x04\x1a\xa3"
          "\xce\xdc\x0d\xfd\x7b\x46\x7e\x26\x22\x8b\xc8\x6c\x9a",
          "\xfb\xa7\x8a\xe4\xf9\xd8\x08\xa6\x2e\x3d\xa4\x0b\xe2\xcb\x77\x00\xc3"
          "\x61\x3d\x9e\xb2\xc5\x29\xc6\x52\xe7\x6a\x43\x2c\x65\x8d\x27\x09\x5f"
          "\x0e\xb8\xf9\x40\xc3\x24\x98\x1e\xa9\x35\xe5\x07\xf9",
          "\x8f\x04\x69\x56\xdb\x3a\x51\x29\x08\xbd\x7a\xfc\x8f\x2a\xb0\xa9", 1,
          0, 376 },
        { 96, 256, 128, 71,
          "\x6c\xbf\xd7\x1c\x64\x5d\x18\x4c\xf5\xd2\x3c\x40\x2b\xdb\x0d\x25\xec"
          "\x54\x89\x8c\x8a\x02\x73\xd4\x2e\xb5\xbe\x10\x9f\xdc\xb2\xac",
          "\xd4\xd8\x07\x34\x16\x83\x82\x5b\x31\xcd\x4d\x95",
          "\xb3\xe4\x06\x46\x83\xb0\x2d\x84",
          "\xa9\x89\x95\x50\x4d\xf1\x6f\x74\x8b\xfb\x77\x85\xff\x91\xee\xb3\xb6"
          "\x60\xea\x9e\xd3\x45\x0c\x3d\x5e\x7b\x0e\x79\xef\x65\x36\x59\xa9\x97"
          "\x8d\x75\x54\x2e\xf9\x1c\x45\x67\x62\x21\x56\x40\xb9",
          "\xa1\xff\xed\x80\x76\x18\x29\xec\xce\x24\x2e\x0e\x88\xb1\x38\x04\x90"
          "\x16\xbc\xa0\x18\xda\x2b\x6e\x19\x98\x6b\x3e\x31\x8c\xae\x8d\x80\x61"
          "\x98\xfb\x4c\x52\x7c\xc3\x93\x50\xeb\xdd\xea\xc5\x73",
          "\xc4\xcb\xf0\xbe\xfd\xa0\xb7\x02\x42\xc6\x40\xd7\xcd\x02\xd7\xa3", 1,
          64, 376 },
        { 96, 256, 128, 72,
          "\x5b\x1d\x10\x35\xc0\xb1\x7e\xe0\xb0\x44\x47\x67\xf8\x0a\x25\xb8\xc1"
          "\xb7\x41\xf4\xb5\x0a\x4d\x30\x52\x22\x6b\xaa\x1c\x6f\xb7\x01",
          "\xd6\x10\x40\xa3\x13\xed\x49\x28\x23\xcc\x06\x5b", "",
          "\xd0\x96\x80\x31\x81\xbe\xef\x9e\x00\x8f\xf8\x5d\x5d\xdc\x38\xdd\xac"
          "\xf0\xf0\x9e\xe5\xf7\xe0\x7f\x1e\x40\x79\xcb\x64\xd0\xdc\x8f\x5e\x67"
          "\x11\xcd\x49\x21\xa7\x88\x7d\xe7\x6e\x26\x78\xfd\xc6\x76\x18\xf1\x18"
          "\x55\x86\xbf\xea\x9d\x4c\x68\x5d\x50\xe4\xbb\x9a\x82",
          "\x9a\x4e\xf2\x2b\x18\x16\x77\xb5\x75\x5c\x08\xf7\x47\xc0\xf8\xd8\xe8"
          "\xd4\xc1\x8a\x9c\xc2\x40\x5c\x12\xbb\x51\xbb\x18\x72\xc8\xe8\xb8\x77"
          "\x67\x8b\xec\x44\x2c\xfc\xbb\x0f\xf4\x64\xa6\x4b\x74\x33\x2c\xf0\x72"
          "\x89\x8c\x7e\x0e\xdd\xf6\x23\x2e\xa6\xe2\x7e\xfe\x50",
          "\x9f\xf3\x42\x7a\x0f\x32\xfa\x56\x6d\x9c\xa0\xa7\x8a\xef\xc0\x13", 1,
          0, 512 },
        { 96, 256, 128, 73,
          "\x97\xd6\x35\xc4\xf4\x75\x74\xd9\x99\x8a\x90\x87\x5d\xa1\xd3\xa2\x84"
          "\xb7\x55\xb2\xd3\x92\x97\xa5\x72\x52\x35\x19\x0e\x10\xa9\x7e",
          "\xd3\x1c\x21\xab\xa1\x75\xb7\x0d\xe4\xeb\xb1\x9c",
          "\x71\x93\xf6\x23\x66\x33\x21\xa2",
          "\x94\xee\x16\x6d\x6d\x6e\xcf\x88\x32\x43\x71\x36\xb4\xae\x80\x5d\x42"
          "\x88\x64\x35\x95\x86\xd9\x19\x3a\x25\x01\x62\x93\xed\xba\x44\x3c\x58"
          "\xe0\x7e\x7b\x71\x95\xec\x5b\xd8\x45\x82\xa9\xd5\x6c\x8d\x4a\x10\x8c"
          "\x7d\x7c\xe3\x4e\x6c\x6f\x8e\xa1\xbe\xc0\x56\x73\x17",
          "\x5f\xbb\xde\xcc\x34\xbe\x20\x16\x14\xf6\x36\x03\x1e\xeb\x42\xf1\xca"
          "\xce\x3c\x79\xa1\x2c\xff\xd8\x71\xee\x8e\x73\x82\x0c\x82\x97\x49\xf1"
          "\xab\xb4\x29\x43\x67\x84\x9f\xb6\xc2\xaa\x56\xbd\xa8\xa3\x07\x8f\x72"
          "\x3d\x7c\x1c\x85\x20\x24\xb0\x17\xb5\x89\x73\xfb\x1e",
          "\x09\x26\x3d\xa7\xb4\xcb\x92\x14\x52\xf9\x7d\xca\x40\xf5\x80\xec", 1,
          64, 512 },
        { 96, 256, 128, 74,
          "\xfe\x6e\x55\xbd\xae\xd1\xf7\x28\x4c\xa5\xfc\x0f\x8c\x5f\x2b\x8d\xf5"
          "\x6d\xc0\xf4\x9e\x8c\xa6\x6a\x41\x99\x5e\x78\x33\x51\xf9\x01",
          "\x17\xc8\x6a\x8a\xbb\xb7\xe0\x03\xac\xde\x27\x99", "",
          "\xb4\x29\xeb\x80\xfb\x8f\xe8\xba\xed\xa0\xc8\x5b\x9c\x33\x34\x58\xe7"
          "\xc2\x99\x2e\x55\x84\x75\x06\x9d\x12\xd4\x5c\x22\x21\x75\x64\x12\x15"
          "\x88\x03\x22\x97\xef\xf5\x67\x83\x74\x2a\x5f\xc2\x2d\x74\x10\xff\xb2"
          "\x9d\x66\x09\x86\x61\xd7\x6f\x12\x6c\x3c\x27\x68\x9e\x43\xb3\x72\x67"
          "\xca\xc5\xa3\xa6\xd3\xab\x49\xe3\x91\xda\x29\xcd\x30\x54\xa5\x69\x2e"
          "\x28\x07\xe4\xc3\xea\x46\xc8\x76\x1d\x50\xf5\x92",
          "\xd0\x10\x2f\x6c\x25\x8b\xf4\x97\x42\xce\xc3\x4c\xf2\xd0\xfe\xdf\x23"
          "\xd1\x05\xfb\x4c\x84\xcf\x98\x51\x5e\x1b\xc9\xa6\x4f\x8a\xd5\xbe\x8f"
          "\x07\x21\xbd\xe5\x06\x45\xd0\x00\x83\xc3\xa2\x63\xa3\x10\x53\xb7\x60"
          "\x24\x5f\x52\xae\x28\x66\xa5\xec\x83\xb1\x9f\x61\xbe\x1d\x30\xd5\xc5"
          "\xd9\xfe\xcc\x4c\xbb\xe0\x8f\xd3\x85\x81\x3a\x2a\xa3\x9a\x00\xff\x9c"
          "\x10\xf7\xf2\x37\x02\xad\xd1\xe4\xb2\xff\xa3\x1c",
          "\x41\x86\x5f\xc7\x1d\xe1\x2b\x19\x61\x21\x27\xce\x49\x99\x3b\xb0", 1,
          0, 776 },
        { 96, 256, 128, 75,
          "\xaa\xbc\x06\x34\x74\xe6\x5c\x4c\x3e\x9b\xdc\x48\x0d\xea\x97\xb4\x51"
          "\x10\xc8\x61\x88\x46\xff\x6b\x15\xbd\xd2\xa4\xa5\x68\x2c\x4e",
          "\x46\x36\x2f\x45\xd6\x37\x9e\x63\xe5\x22\x94\x60",
          "\xa1\x1c\x40\xb6\x03\x76\x73\x30",
          "\xce\xb5\x34\xce\x50\xdc\x23\xff\x63\x8a\xce\x3e\xf6\x3a\xb2\xcc\x29"
          "\x73\xee\xad\xa8\x07\x85\xfc\x16\x5d\x06\xc2\xf5\x10\x0f\xf5\xe8\xab"
          "\x28\x82\xc4\x75\xaf\xcd\x05\xcc\xd4\x9f\x2e\x7d\x8f\x55\xef\x3a\x72"
          "\xe3\xdc\x51\xd6\x85\x2b\x8e\x6b\x9e\x7a\xec\xe5\x7b\xe6\x55\x6b\x0b"
          "\x6d\x94\x13\xe3\x3f\xc5\xfc\x24\xa9\xa2\x05\xad\x59\x57\x4b\xb3\x9d"
          "\x94\x4a\x92\xdc\x47\x97\x0d\x84\xa6\xad\x31\x76",
          "\x75\x45\x39\x1b\x51\xde\x01\xd5\xc5\x3d\xfa\xca\x77\x79\x09\x06\x3e"
          "\x58\xed\xee\x4b\xb1\x22\x7e\x71\x10\xac\x4d\x26\x20\xc2\xae\xc2\xf8"
          "\x48\xf5\x6d\xee\xb0\x37\xa8\xdc\xed\x75\xaf\xa8\xa6\xc8\x90\xe2\xde"
          "\xe4\x2f\x95\x0b\xb3\x3d\x9e\x24\x24\xd0\x8a\x50\x5d\x89\x95\x63\x97"
          "\x3e\xd3\x88\x70\xf3\xde\x6e\xe2\xad\xc7\xfe\x07\x2c\x36\x6c\x14\xe2"
          "\xcf\x7c\xa6\x2f\xb3\xd3\x6b\xee\x11\x68\x54\x61",
          "\xb7\x0d\x44\xef\x8c\x66\xc5\xc7\xbb\xf1\x0d\xca\xdd\x7f\xac\xf6", 1,
          64, 776 },
        { 96, 256, 128, 76,
          "\xd7\xad\xdd\x38\x89\xfa\xdf\x8c\x89\x3e\xee\x14\xba\x2b\x7e\xa5\xbf"
          "\x56\xb4\x49\x90\x48\x69\x61\x5b\xd0\x5d\x5f\x11\x4c\xf3\x77",
          "\x8a\x3a\xd2\x6b\x28\xcd\x13\xba\x65\x04\xe2\x60", "",
          "\xc8\x77\xa7\x6b\xf5\x95\x56\x07\x72\x16\x7c\x6e\x3b\xcc\x70\x53\x05"
          "\xdb\x9c\x6f\xcb\xeb\x90\xf4\xfe\xa8\x51\x16\x03\x8b\xc5\x3c\x3f\xa5"
          "\xb4\xb4\xea\x0d\xe5\xcc\x53\x4f\xbe\x1c\xf9\xae\x44\x82\x4c\x6c\x2c"
          "\x0a\x5c\x88\x5b\xd8\xc3\xcd\xc9\x06\xf1\x26\x75\x73\x7e\x43\x4b\x98"
          "\x3e\x1e\x23\x1a\x52\xa2\x75\xdb\x5f\xb1\xa0\xca\xc6\xa0\x7b\x3b\x7d"
          "\xcb\x19\x48\x2a\x5d\x3b\x06\xa9\x31\x7a\x54\x82\x6c\xea\x6b\x36\xfc"
          "\xe4\x52\xfa\x9b\x54\x75\xe2\xaa\xf2\x54\x99\x49\x9d\x8a\x89\x32\xa1"
          "\x9e\xb9\x87\xc9\x03\xbd\x85\x02\xfe",
          "\x29\x4a\x76\x4c\x03\x35\x3f\x5f\x4f\x6e\x93\xcd\x7e\x97\x74\x80\xd6"
          "\xc3\x43\x07\x1d\xb0\xb7\xc1\xf0\xdb\x1e\x95\xb8\x5e\x60\x53\xf0\x42"
          "\x31\x68\xa9\xc7\x53\x32\x68\xdb\x9a\x19\x4e\x76\x65\x35\x9d\x14\x48"
          "\x9b\xc4\x71\x72\xa9\xf2\x13\x70\xe8\x9b\x0b\xd0\xe5\xef\x96\x61\x73"
          "\x8d\xe2\x82\x57\x2b\xcc\x3e\x54\x12\x47\x62\x6e\x57\xe7\x5d\xec\x0f"
          "\x91\xac\x5c\x53\x0b\xd1\xa5\x32\x71\x84\x29\x96\xdc\xd0\x4d\x86\x53"
          "\x21\xb1\xec\xb6\xe7\x63\x01\x14\xfe\x78\x02\x91\xb8\xdc\x3e\x5d\x0a"
          "\xbc\x8e\x65\xb1\xc5\x49\x3e\x9a\xf0",
          "\xf2\xb9\x74\xca\x0f\x14\xfb\x9f\x92\x01\x4b\xff\x18\x57\x3c\xff", 1,
          0, 1024 },
        { 96, 256, 128, 77,
          "\x80\xbe\x86\xfb\x6f\xc4\x9b\xc7\x34\x28\xca\xb5\x76\xf6\xad\x72\xff"
          "\x6a\xca\x04\x00\x1b\x8b\x1c\x57\xa7\x12\x8b\xe7\x39\x00\xaa",
          "\x90\x31\x88\x43\x3c\x1c\xe8\x97\x1a\xa1\x9b\x9d",
          "\x05\x87\xaf\x85\x30\xad\x05\x47",
          "\x67\xce\x49\x9c\xd8\xed\x68\xbd\x71\x7d\xfe\x61\xc6\x0f\x27\xd2\x60"
          "\xb1\xc1\x63\xa7\x2e\x8c\xc8\x59\x72\x53\xd3\xd9\x87\xc2\xdb\xe1\xbf"
          "\xf2\xe4\x4d\x9b\xd4\x76\x5d\x3e\x53\xd9\xc3\xf8\xeb\x3b\x90\xe7\x51"
          "\xf4\x7c\x71\x57\xbd\xc1\x14\x2b\xc3\x3f\x58\x33\xac\x1c\xd1\x26\x2c"
          "\xbb\x23\x90\x66\xb3\x34\xa4\xed\x99\xae\x82\xc7\x4f\x2b\x49\x54\x0f"
          "\x1a\x61\x4b\xc2\x39\xd8\xfc\x5a\xdd\x8c\x17\x81\x84\xe4\x12\x81\xf6"
          "\xe6\x6c\x5c\x31\x17\xfd\x95\x35\x47\xf7\xc8\x29\x42\x5b\x50\x82\xaa"
          "\x69\x68\x68\x47\xea\xf5\x78\x46\x92",
          "\x2b\x90\xb4\xf3\xde\x28\x0c\x44\x91\x3d\x19\x84\xbd\xd5\xdf\xa0\x56"
          "\x6c\x6a\x14\xa0\x58\x65\x9a\x9b\x62\x32\x77\xb0\xbb\x6e\x82\x10\x1e"
          "\x79\x39\x5d\x12\xe6\x43\xf6\x2d\x9a\x82\x2b\xae\x49\x79\x07\x49\x3e"
          "\x4f\x82\x13\xfc\xf9\x9d\xa8\xa7\x8f\xdf\x86\x7a\xf3\x6b\xc8\xb0\x93"
          "\x1c\x18\x86\xb4\xf0\xae\x57\x29\x98\x64\x94\xdb\xd5\x97\x37\xe9\x56"
          "\xcd\x8f\x22\x6c\x7c\x52\x26\x89\xd0\x82\xf0\x23\x89\x4d\x54\xac\xab"
          "\x0c\x4d\x60\x9f\x37\x46\xa6\x73\x69\xbb\x88\x76\x00\x8f\x7f\xd3\xdc"
          "\x66\x81\xc5\xfb\x9d\x72\x8c\x59\x11",
          "\xf0\x05\xeb\xe1\xc1\xad\xa7\x5a\x9c\xee\x8d\x63\x08\x81\xd5\xb8", 1,
          64, 1024 },
        { 96, 256, 128, 78,
          "\x7d\x00\xb4\x80\x95\xad\xfa\x32\x72\x05\x06\x07\xb2\x64\x18\x50\x02"
          "\xba\x99\x95\x7c\x49\x8b\xe0\x22\x77\x0f\x2c\xe2\xf3\x14\x3c",
          "\x87\x34\x5f\x10\x55\xfd\x9e\x21\x02\xd5\x06\x56", "\x02",
          "\xe5\xcc\xaa\x44\x1b\xc8\x14\x68\x8f\x8f\x6e\x8f\x28\xb5\x00\xb2",
          "\x7e\x72\xf5\xa1\x85\xaf\x16\xa6\x11\x92\x1b\x43\x8f\x74\x9f\x0b",
          "\x12\x42\xc6\x70\x73\x23\x34\x02\x9a\xdf\xe1\xc5\x00\x16\x51\xe4", 1,
          8, 128 },
        { 96, 256, 128, 79,
          "\x64\x32\x71\x7f\x1d\xb8\x5e\x41\xac\x78\x36\xbc\xe2\x51\x85\xa0\x80"
          "\xd5\x76\x2b\x9e\x2b\x18\x44\x4b\x6e\xc7\x2c\x3b\xd8\xe4\xdc",
          "\x87\xa3\x16\x3e\xc0\x59\x8a\xd9\x5b\x3a\xa7\x13", "\xb6\x48",
          "\x02\xcd\xe1\x68\xfb\xa3\xf5\x44\xbb\xd0\x33\x2f\x7a\xde\xad\xa8",
          "\x85\xf2\x9a\x71\x95\x57\xcd\xd1\x4d\x1f\x8f\xff\xab\x6d\x9e\x60",
          "\x73\x2c\xa3\x2b\xec\xd5\x15\xa1\xed\x35\x3f\x54\x2e\x99\x98\x58", 1,
          16, 128 },
        { 96, 256, 128, 80,
          "\x7a\xfa\x0f\x59\xdf\xcb\x5a\xd3\xa7\x64\x90\xc5\xc8\x04\x32\x7c\x8d"
          "\x05\x2b\xe7\x37\xa6\x0f\xa8\xbc\xbf\x0a\x2c\x36\x63\x0a\x43",
          "\x25\xb7\xbd\xf4\xa6\xdc\xbf\x7c\x9a\x3e\xc2\xb3", "\x8b\x71\xac",
          "\x62\x3e\x6b\xa6\xd3\x16\x6a\x33\x8b\xfc\xc7\xaf\x90\xa2\x30\xc8",
          "\xd4\x6e\x82\x65\xa8\xc6\xa2\x53\x93\xdd\x95\x6b\xb4\x43\x97\xad",
          "\xe2\x8f\x3a\xd9\xe3\xef\x4a\x3d\x94\xee\x07\xbf\x53\x8e\xaa\xfb", 1,
          24, 128 },
        { 96, 256, 128, 81,
          "\x2e\xc2\x5b\x0e\xc7\xac\x24\x42\x24\xe9\xc7\xfc\x2f\xa5\xd3\xef\x17"
          "\x80\x9e\x19\xfd\x6e\x95\x41\x58\xdd\x0d\x72\x73\x8a\x4c\xc8",
          "\x6f\xb0\xd1\x41\x7c\xdf\xff\x4d\xf3\x7d\xb0\x8c",
          "\x3a\x5d\xdf\x40",
          "\xa1\xc9\x33\x76\x8a\x6d\x57\x3e\xbf\x68\xa9\x9e\x5e\x18\xda\xe8",
          "\x2d\x3c\xb2\xd9\x30\x34\x91\xe2\x64\xf2\x90\x4f\x0e\x07\x53\xf4",
          "\x6c\x1d\xb9\x59\x36\x2d\x21\x7b\x23\x22\xb4\x66\x53\x6b\xfe\xa0", 1,
          32, 128 },
        { 96, 256, 128, 82,
          "\x0a\x2c\xf5\x23\x71\xcf\x9d\x9f\x95\xb1\x01\x08\xfc\x82\xb4\xfd\x61"
          "\x10\xa8\xba\x9a\x88\xa2\x60\x83\x68\x5a\xd2\x98\x26\x89\x1a",
          "\x25\x38\xfc\x67\xaf\xb9\xea\xb3\x33\xf8\x32\x90",
          "\x9e\xec\x54\x0b\xb0",
          "\x0d\x8c\x69\x1d\x04\x4a\x39\x78\xd7\x90\x43\x2d\xc7\x1d\x69\xf8",
          "\xa9\x88\xc0\x3c\x71\xb9\x56\xff\x08\x6d\x04\x70\xd7\x06\xbd\x34",
          "\xb3\x5d\x7c\xbf\x2b\xeb\x89\x4b\x0c\x74\x6e\x07\x30\x42\x9e\x15", 1,
          40, 128 },
        { 96, 256, 128, 83,
          "\x30\x7e\x88\x6b\x38\xbb\x18\xb4\x45\xf8\xa2\xc6\xd6\xf8\x93\x24\x92"
          "\xa9\xce\xa8\xd0\x41\xba\x72\xeb\x5e\xfd\xfa\x70\xd0\xb8\xd2",
          "\xa0\x71\xbe\x99\x91\x51\xe2\xa1\xc4\x1c\x81\xe9",
          "\x56\xe0\x14\xd9\x7c\x74",
          "\x9a\xba\x22\xb4\x95\xcb\x7e\xc8\x87\xdd\xaa\x62\x01\x9a\xa1\x4d",
          "\x32\xbf\x95\xd4\xc1\x95\xdb\xaf\x58\xd9\xaf\x40\x01\xc6\xe5\x7d",
          "\x43\x93\x80\x87\x03\xd6\x7a\x90\x87\x05\x78\x04\x6c\xd8\xb5\x25", 1,
          48, 128 },
        { 96, 256, 128, 84,
          "\xda\xcd\x51\xa8\xa8\xe4\xd5\x90\x5b\x4c\xbb\x94\x7e\xf4\x01\x3e\xb2"
          "\x96\x88\x93\x53\xf3\xc9\xee\x35\xf5\x57\x7b\x26\x73\x7a\x51",
          "\x3f\xa3\x78\xa1\xbe\xfd\xdd\xd6\x1a\xe6\x8c\xf4",
          "\xbb\x5a\x38\x12\xf0\xae\xfd",
          "\xe1\x48\x31\x38\x83\xa7\x7d\xa1\x21\x12\x4d\x06\xb1\xc7\x7d\xca",
          "\x2a\x20\x7c\xa7\xe9\xda\x6b\x13\xa2\x29\x60\x43\x04\xd8\x7e\xb1",
          "\x8a\x6b\x6a\xfe\xc8\x7d\x93\xec\x6e\x8d\xbe\x13\xd8\x4c\x0f\x8c", 1,
          56, 128 },
        { 96, 256, 128, 85,
          "\x7b\x5f\xbb\xb2\x02\xc1\x61\x08\xfd\x13\x06\x64\x46\x85\x3a\x85\x0d"
          "\x8b\x34\xe9\xda\x40\x51\x95\x80\xda\x44\x6a\x92\x2f\x91\x62",
          "\xaa\x07\x7a\x5c\xe9\x16\x1b\xde\x8d\x8e\xdc\x40",
          "\xf9\x4b\xb9\x2c\x1c\x66\x8a\x69\x5b",
          "\xda\x47\x1c\xd6\x93\x5a\x0c\xa8\x30\x7d\xde\xdc\x6b\x95\x99\x62",
          "\x54\x8a\x5c\xa0\xae\x49\x21\x1c\xdf\x30\xbb\xdc\xb1\x35\x2d\x31",
          "\x20\x4d\xac\xb9\x8f\x8c\x89\x08\xcc\x5e\xa2\x2b\xb2\x3f\x90\x1f", 1,
          72, 128 },
        { 96, 256, 128, 86,
          "\x1f\xfd\x10\x1e\xb9\x75\x31\xf6\xfa\xa8\x21\xec\x4d\x5c\x57\x02\x72"
          "\x5d\xd0\x33\xd3\xb8\x30\xbb\x76\x0c\x4e\xf2\x7b\xa9\x83\xdf",
          "\x59\x81\x14\xe8\xcf\x7f\xbd\xea\x8a\xd2\x96\x83",
          "\x21\x55\x62\x7e\xc1\x5a\x97\x8f\xbc\xb2",
          "\x28\x66\x8c\xa8\xdb\x53\x5c\x7e\x8e\xb2\x74\x91\xad\x0f\xb7\xcb",
          "\x28\xce\xda\xc2\x4f\x14\xca\xa3\x26\xc7\xfe\x40\x1f\x68\xa8\x7c",
          "\x2b\xf1\xb2\xc4\x3d\x30\x39\xf8\xf5\xce\x35\x9c\x11\x02\xf8\x79", 1,
          80, 128 },
        { 96, 256, 128, 87,
          "\xd2\xd0\xa9\x73\xd5\x95\x1a\xf3\x52\xcb\xee\x57\xac\x9d\xab\x1c\x28"
          "\x4c\x99\xaf\x3b\x99\x2c\xe0\x15\xf2\x19\x50\x6f\x64\x88\x8d",
          "\x9a\xcd\x21\x35\x70\xce\x9b\xb9\xd8\x86\xc6\xef",
          "\x37\xad\x66\x8d\x4d\x4f\xe8\x89\x94\x97\x63",
          "\x3f\x3f\x00\x76\x25\x03\x52\xe1\xb6\xb5\xc1\x2c\xfa\x12\x62\x5e",
          "\x72\x56\xe8\x56\x87\x2a\xd3\xa5\x4b\x34\xa2\xa6\xbd\xca\x88\x38",
          "\x3b\x12\xe4\x58\x6e\x45\x22\x3f\x78\xa6\xee\xa8\x11\xef\xb8\x63", 1,
          88, 128 },
        { 96, 256, 128, 88,
          "\xad\xcc\x52\x0b\x38\x13\x82\x23\x7d\x05\xa6\x40\x0a\x7d\xfb\xcd\x07"
          "\x71\xb6\xaa\x9e\xdb\x79\x66\x13\x1d\xde\xf6\xaf\x21\xf1\xbe",
          "\x91\x83\xcd\xf3\xa8\xba\x73\x97\xb6\xb2\xd5\xd5",
          "\xb3\x34\x37\x54\x15\xf6\x21\x5c\x0b\xf8\x9a\x9a",
          "\x95\x82\x95\x61\x9c\xf1\xb3\x6f\x0b\x47\x46\x63\xc0\xbc\x79\xeb",
          "\x85\x2c\x14\x1b\x42\x39\xa3\x1f\xee\xda\x03\x55\x0d\x70\xa2\xbe",
          "\x5f\xc5\x92\x87\xb9\x2d\x3f\xcf\x7d\x66\xf1\x3d\xef\xb1\x1b\x0d", 1,
          96, 128 },
        { 96, 256, 128, 89,
          "\xbd\x53\x4f\x7a\xde\xca\x46\x68\x44\xfb\x3b\xa3\x46\x58\xbe\x80\x7f"
          "\x15\xc5\x29\x1e\xd6\x02\x68\x60\xa2\x4f\x17\x9b\x71\x2c\x89",
          "\x41\x2c\x3e\x13\xee\x1f\x78\x64\xbd\x15\xce\x39",
          "\x28\x66\xaf\xff\x0b\xcc\x61\x35\xdc\x63\xaf\x88\xc8",
          "\xd9\x2f\x8c\xe5\xd8\xd0\xad\x2e\xb5\xf1\x1a\xf0\x2e\xf6\x39\x49",
          "\x89\xd6\xd0\x89\xc4\xa2\x55\x95\x2a\xca\x11\xb2\x4a\x01\xff\x95",
          "\xf8\x8f\xa4\x53\x12\x04\xda\x31\x5e\x73\x17\x97\x02\x40\xce\x9e", 1,
          104, 128 },
        { 96, 256, 128, 90,
          "\x91\x0a\xde\x7d\x32\x4d\x2c\x96\x88\x43\x9e\x1f\x14\x2e\x0e\x5f\x9d"
          "\x13\x0f\xf8\x32\xe5\x07\xfe\x19\x85\xe5\xa2\x64\x52\xa6\xd0",
          "\x9b\xe0\x90\xdb\xa9\x3d\xef\xf2\x7a\xdf\x99\xee",
          "\xea\x25\x75\xf1\x23\x26\x8e\x93\x6c\x8e\x4c\x8c\x1b\xb8",
          "\x6e\x35\x60\x94\xed\x9d\x9a\x70\x53\xc7\x90\x6c\x48\xba\x3d\x9f",
          "\x01\xff\xb3\x43\xc7\x57\xb2\x78\x43\xd8\xa9\x00\xa3\x6c\xe3\x9d",
          "\xa3\x15\x54\x1b\x7d\x63\x13\xc6\xfd\xdf\x64\xb3\x03\xd7\x1d\x60", 1,
          112, 128 },
        { 96, 256, 128, 91,
          "\x8e\x34\xcf\x73\xd2\x45\xa1\x08\x2a\x92\x0b\x86\x36\x4e\xb8\x96\xc4"
          "\x94\x64\x67\xbc\xb3\xd5\x89\x29\xfc\xb3\x66\x90\xe6\x39\x4f",
          "\x6f\x57\x3a\xa8\x6b\xaa\x49\x2b\xa4\x65\x96\xdf",
          "\xbd\x4c\xd0\x2f\xc7\x50\x2b\xbd\xbd\xf6\xc9\xa3\xcb\xe8\xf0",
          "\x16\xdd\xd2\x3f\xf5\x3f\x3d\x23\xc0\x63\x34\x48\x70\x40\xeb\x47",
          "\xc1\xb2\x95\x93\x6d\x56\xfa\xda\xc0\x3e\x5f\x74\x2b\xff\x73\xa1",
          "\x39\xc4\x57\xdb\xab\x66\x38\x2b\xab\xb3\xb5\x58\x00\xcd\xa5\xb8", 1,
          120, 128 },
        { 96, 256, 128, 92,
          "\xcb\x55\x75\xf5\xc7\xc4\x5c\x91\xcf\x32\x0b\x13\x9f\xb5\x94\x23\x75"
          "\x60\xd0\xa3\xe6\xf8\x65\xa6\x7d\x4f\x63\x3f\x2c\x08\xf0\x16",
          "\x1a\x65\x18\xf0\x2e\xde\x1d\xa6\x80\x92\x66\xd9",
          "\x89\xcc\xe9\xfb\x47\x44\x1d\x07\xe0\x24\x5a\x66\xfe\x8b\x77\x8b",
          "\x62\x3b\x78\x50\xc3\x21\xe2\xcf\x0c\x6f\xbc\xc8\xdf\xd1\xaf\xf2",
          "\xc8\x4c\x9b\xb7\xc6\x1c\x1b\xcb\x17\x77\x2a\x1c\x50\x0c\x50\x95",
          "\xdb\xad\xf7\xa5\x13\x8c\xa0\x34\x59\xa2\xcd\x65\x83\x1e\x09\x2f", 1,
          128, 128 },
        { 96, 256, 128, 93,
          "\xa5\x56\x9e\x72\x9a\x69\xb2\x4b\xa6\xe0\xff\x15\xc4\x62\x78\x97\x43"
          "\x68\x24\xc9\x41\xe9\xd0\x0b\x2e\x93\xfd\xdc\x4b\xa7\x76\x57",
          "\x56\x4d\xee\x49\xab\x00\xd2\x40\xfc\x10\x68\xc3",
          "\xd1\x9f\x2d\x98\x90\x95\xf7\xab\x03\xa5\xfd\xe8\x44\x16\xe0\x0c"
          "\x0e",
          "\x87\xb3\xa4\xd7\xb2\x6d\x8d\x32\x03\xa0\xde\x1d\x64\xef\x82\xe3",
          "\x94\xbc\x80\x62\x1e\xd1\xe7\x1b\x1f\xd2\xb5\xc3\xa1\x5e\x35\x68",
          "\x33\x35\x11\x86\x17\x96\x97\x84\x01\x59\x8b\x96\x37\x22\xf5\xb3", 1,
          136, 128 },
        { 96, 256, 128, 94,
          "\x56\x20\x74\x65\xb4\xe4\x8e\x6d\x04\x63\x0f\x4a\x42\xf3\x5c\xfc\x16"
          "\x3a\xb2\x89\xc2\x2a\x2b\x47\x84\xf6\xf9\x29\x03\x30\xbe\xe0",
          "\xdf\x87\x13\xe8\x7e\xc3\xdb\xcf\xad\x14\xd5\x3e",
          "\x5e\x64\x70\xfa\xcd\x99\xc1\xd8\x1e\x37\xcd\x44\x01\x5f\xe1\x94\x80"
          "\xa2\xa4\xd3\x35\x2a\x4f\xf5\x60\xc0\x64\x0f\xdb\xda",
          "\xe6\x01\xb3\x85\x57\x79\x7d\xa2\xf8\xa4\x10\x6a\x08\x9d\x1d\xa6",
          "\x29\x9b\x5d\x3f\x3d\x03\xc0\x87\x20\x9a\x16\xe2\x85\x14\x31\x11",
          "\x4b\x45\x4e\xd1\x98\xde\x11\x7e\x83\xec\x49\xfa\x8d\x85\x08\xd6", 1,
          240, 128 },
        { 96, 256, 128, 95,
          "\x07\x74\x33\x02\x2a\xb3\x4d\x38\x0f\xc1\x92\xfc\x24\xc2\xed\xc6\x30"
          "\x1f\xec\x6f\x24\x44\x2f\x57\x2a\x10\x87\xff\x2e\x05\xb3\x9a",
          "\x28\xad\xcb\xc7\x43\x64\xf2\x6d\xd4\xb3\x10\x8b",
          "\xe0\x10\x0e\xb1\x16\xcd\xc5\xe2\x2a\x3b\x9f\x9b\x41\x26\xc1\x49\x59"
          "\x5e\x75\x10\x7f\x6e\x23\x7c\x69\xe8\x29\x60\x05\x22\x70",
          "\x03\xc8\x74\xee\xaa\xa6\xfa\x9f\x0d\xa6\x2c\x75\x8f\xb0\xad\x04",
          "\x1e\x96\x87\xb3\x5f\xbc\x8e\xaa\x18\x25\xed\x38\x47\x79\x8f\x76",
          "\x07\x88\xbf\x70\xfd\x04\x03\x0e\xcd\x1c\x96\xd0\xbc\x1f\xcd\x5d", 1,
          248, 128 },
        { 96, 256, 128, 96,
          "\x39\x37\x98\x6a\xf8\x6d\xaf\xc1\xba\x0c\x46\x72\xd8\xab\xc4\x6c\x20"
          "\x70\x62\x68\x2d\x9c\x26\x4a\xb0\x6d\x6c\x58\x07\x20\x51\x30",
          "\x8d\xf4\xb1\x5a\x88\x8c\x33\x28\x6a\x7b\x76\x51",
          "\xba\x44\x6f\x6f\x9a\x0c\xed\x22\x45\x0f\xeb\x10\x73\x7d\x90\x07\xfd"
          "\x69\xab\xc1\x9b\x1d\x4d\x90\x49\xa5\x55\x1e\x86\xec\x2b\x37",
          "\xdc\x9e\x9e\xaf\x11\xe3\x14\x18\x2d\xf6\xa4\xeb\xa1\x7a\xec\x9c",
          "\x60\x5b\xbf\x90\xae\xb9\x74\xf6\x60\x2b\xc7\x78\x05\x6f\x0d\xca",
          "\x38\xea\x23\xd9\x90\x54\xb4\x6b\x42\xff\xe0\x04\x12\x9d\x22\x04", 1,
          256, 128 },
        { 96, 256, 128, 97,
          "\x36\x37\x2a\xbc\xdb\x78\xe0\x27\x96\x46\xac\x3d\x17\x6b\x96\x74\xe9"
          "\x15\x4e\xec\xf0\xd5\x46\x9c\x65\x1e\xc7\xe1\x6b\x4c\x11\x99",
          "\xbe\x40\xe5\xf1\xa1\x18\x17\xa0\xa8\xfa\x89\x49",
          "\xd4\x1a\x82\x8d\x5e\x71\x82\x92\x47\x02\x19\x05\x40\x2e\xa2\x57\xdc"
          "\xcb\xc3\xb8\x0f\xcd\x56\x75\x05\x6b\x68\xbb\x59\xe6\x2e\x88\x73",
          "\x81\xce\x84\xed\xe9\xb3\x58\x59\xcc\x8c\x49\xa8\xf6\xbe\x7d\xc6",
          "\x7b\x7c\xe0\xd8\x24\x80\x9a\x70\xde\x32\x56\x2c\xcf\x2c\x2b\xbd",
          "\x15\xd4\x4a\x00\xce\x0d\x19\xb4\x23\x1f\x92\x1e\x22\xbc\x0a\x43", 1,
          264, 128 },
        { 96, 256, 128, 98,
          "\x9f\x14\x79\xed\x09\x7d\x7f\xe5\x29\xc1\x1f\x2f\x5a\xdd\x9a\xaf\xf4"
          "\xa1\xca\x0b\x68\x99\x7a\x2c\xb7\xf7\x97\x49\xbd\x90\xaa\xf4",
          "\x84\xc8\x7d\xae\x4e\xee\x27\x73\x0e\xc3\x5d\x12",
          "\x3f\x2d\xd4\x9b\xbf\x09\xd6\x9a\x78\xa3\xd8\x0e\xa2\x56\x66\x14\xfc"
          "\x37\x94\x74\x19\x6c\x1a\xae\x84\x58\x3d\xa7\x3d\x7f\xf8\x5c\x6f\x42"
          "\xca\x42\x05\x6a\x97\x92\xcc\x1b\x9f\xb3\xc7\xd2\x61",
          "\xa6\x67\x47\xc8\x9e\x85\x7a\xf3\xa1\x8e\x2c\x79\x50\x00\x87\xed",
          "\xca\x82\xbf\xf3\xe2\xf3\x10\xcc\xc9\x76\x67\x2c\x44\x15\xe6\x9b",
          "\x57\x63\x8c\x62\xa5\xd8\x5d\xed\x77\x4f\x91\x3c\x81\x3e\xa0\x32", 1,
          376, 128 },
        { 96, 256, 128, 99,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x65\xb6\x3b\xf0\x74\xb7\x28\x39\x92\xe2\x4b\x1a\xc0\xdf\x0d\x22\xb5"
          "\x55\xdb\xe2\x25\x4d\x94\xa4\x3f\x1d\xe7\x48\xd3\xcc\x6f\x0d",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x39\xf4\xfc\xe3\x02\x6d\x83\x78\x9f\xfd\x1e\xe6\xf2\xcd\x7c\x4f", 1,
          128, 256 },
        { 96, 256, 128, 100,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x65\xb6\x3b\xf0\x74\xb7\x28\x39\x92\xe2\x4b\x1a\xc0\xdf\x0d\x22\xb5"
          "\x55\xdb\xe2\x25\x4d\x94\xa4\x3f\x1d\xe7\x48\xd3\xcc\x6f\x0d\x20\xc1"
          "\x42\xfe\x89\x8f\xbb\xe6\x68\xd4\x32\x43\x94\x43\x4c\x1b\x18\xb5\x8e"
          "\xad\x71\x0a\xed\x9c\x31\xdb\x1f\x2a\x8a\x1f\x1b\xb2",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xf5\xea\xa8\x04\x60\x5c\x3a\x47\x85\xf9\xd7\xf1\x3b\x6f\x67\xd6", 1,
          128, 512 },
        { 96, 256, 128, 101,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x65\xb6\x3b\xf0\x74\xb7\x28\x39\x92\xe2\x4b\x1a\xc0\xdf\x0d\x22\xb5"
          "\x55\xdb\xe2\x25\x4d\x94\xa4\x3f\x1d\xe7\x48\xd3\xcc\x6f\x0d\x20\xc1"
          "\x42\xfe\x89\x8f\xbb\xe6\x68\xd4\x32\x43\x94\x43\x4c\x1b\x18\xb5\x8e"
          "\xad\x71\x0a\xed\x9c\x31\xdb\x1f\x2a\x8a\x1f\x1b\xb2\x44\x05\xc1\x83"
          "\xaf\x94\xee\x1a\xd6\x30\xcd\x93\x11\x58\xa6\x21\x3d\x48\xc8\xff\xf1"
          "\x0d\x0a\x1f\x9e\xf7\x60\x18\x8e\x65\x88\x02\xaa\xd5\x5e\x41\xa1\xd9"
          "\x90\x69\xa1\x8d\xb5\x5c\x56\xaf\x7c\x10\xa6\xf2\x1e\xcc\x8a\xf9\xb7"
          "\xce\x0a\x7e\xa0\xb6\x74\x26\xe9\x25",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x9b\x5c\x43\xa7\x8d\x95\x4e\x8a\x3c\x65\x9e\xeb\xc1\x3d\x5d\x55", 1,
          128, 1024 },
        { 96, 256, 128, 102,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x9a\x49\xc4\x0f\x8b\x48\xd7\xc6\x6d\x1d\xb4\xe5\x3f\x20\xf2\xdd\x4a"
          "\xaa\x24\x1d\xda\xb2\x6b\x5b\xc0\xe2\x18\xb7\x2c\x33\x90\xf2",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x37\xe3\x39\x9d\x9c\xa6\x96\x79\x9f\x08\xf4\xf7\x2b\xc0\xcd\xd8", 1,
          128, 256 },
        { 96, 256, 128, 103,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x9a\x49\xc4\x0f\x8b\x48\xd7\xc6\x6d\x1d\xb4\xe5\x3f\x20\xf2\xdd\x4a"
          "\xaa\x24\x1d\xda\xb2\x6b\x5b\xc0\xe2\x18\xb7\x2c\x33\x90\xf2\xdf\x3e"
          "\xbd\x01\x76\x70\x44\x19\x97\x2b\xcd\xbc\x6b\xbc\xb3\xe4\xe7\x4a\x71"
          "\x52\x8e\xf5\x12\x63\xce\x24\xe0\xd5\x75\xe0\xe4\x4d",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x3d\x52\x71\x0b\xec\x86\xd4\xea\x9f\xea\x2f\xf2\x69\x54\x91\x91", 1,
          128, 512 },
        { 96, 256, 128, 104,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x9a\x49\xc4\x0f\x8b\x48\xd7\xc6\x6d\x1d\xb4\xe5\x3f\x20\xf2\xdd\x4a"
          "\xaa\x24\x1d\xda\xb2\x6b\x5b\xc0\xe2\x18\xb7\x2c\x33\x90\xf2\xdf\x3e"
          "\xbd\x01\x76\x70\x44\x19\x97\x2b\xcd\xbc\x6b\xbc\xb3\xe4\xe7\x4a\x71"
          "\x52\x8e\xf5\x12\x63\xce\x24\xe0\xd5\x75\xe0\xe4\x4d\xbb\xfa\x3e\x7c"
          "\x50\x6b\x11\xe5\x29\xcf\x32\x6c\xee\xa7\x59\xde\xc2\xb7\x37\x00\x0e"
          "\xf2\xf5\xe0\x61\x08\x9f\xe7\x71\x9a\x77\xfd\x55\x2a\xa1\xbe\x5e\x26"
          "\x6f\x96\x5e\x72\x4a\xa3\xa9\x50\x83\xef\x59\x0d\xe1\x33\x75\x06\x48"
          "\x31\xf5\x81\x5f\x49\x8b\xd9\x16\xda",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x51\x35\x63\x29\xe2\x80\xb1\x2d\x55\xd3\xd9\x8f\x0a\x58\x0c\xbe", 1,
          128, 1024 },
        { 96, 256, 128, 105,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80",
          "\x65\xb6\x3b\x70\x74\xb7\x28\xb9\x92\xe2\x4b\x9a\xc0\xdf\x0d\xa2\xb5"
          "\x55\xdb\x62\x25\x4d\x94\x24\x3f\x1d\xe7\xc8\xd3\xcc\x6f\x8d",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80",
          "\xc1\x52\xa4\xb9\x0c\x54\x8c\x71\xdc\x47\x9e\xde\xaf\x92\x11\xbf", 1,
          128, 256 },
        { 96, 256, 128, 106,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80",
          "\x65\xb6\x3b\x70\x74\xb7\x28\xb9\x92\xe2\x4b\x9a\xc0\xdf\x0d\xa2\xb5"
          "\x55\xdb\x62\x25\x4d\x94\x24\x3f\x1d\xe7\xc8\xd3\xcc\x6f\x8d\x20\xc1"
          "\x42\x7e\x89\x8f\xbb\x66\x68\xd4\x32\xc3\x94\x43\x4c\x9b\x18\xb5\x8e"
          "\x2d\x71\x0a\xed\x1c\x31\xdb\x1f\xaa\x8a\x1f\x1b\x32",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00"
          "\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00"
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80",
          "\x40\xef\x63\x83\x05\x2d\x91\xc2\xe4\xb4\x61\x1b\x0e\x32\xc5\xff", 1,
          128, 512 },
        { 96, 256, 128, 107,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80",
          "\x65\xb6\x3b\x70\x74\xb7\x28\xb9\x92\xe2\x4b\x9a\xc0\xdf\x0d\xa2\xb5"
          "\x55\xdb\x62\x25\x4d\x94\x24\x3f\x1d\xe7\xc8\xd3\xcc\x6f\x8d\x20\xc1"
          "\x42\x7e\x89\x8f\xbb\x66\x68\xd4\x32\xc3\x94\x43\x4c\x9b\x18\xb5\x8e"
          "\x2d\x71\x0a\xed\x1c\x31\xdb\x1f\xaa\x8a\x1f\x1b\x32\x44\x05\xc1\x03"
          "\xaf\x94\xee\x9a\xd6\x30\xcd\x13\x11\x58\xa6\xa1\x3d\x48\xc8\x7f\xf1"
          "\x0d\x0a\x9f\x9e\xf7\x60\x98\x8e\x65\x88\x82\xaa\xd5\x5e\xc1\xa1\xd9"
          "\x90\xe9\xa1\x8d\xb5\xdc\x56\xaf\x7c\x90\xa6\xf2\x1e\x4c\x8a\xf9\xb7"
          "\x4e\x0a\x7e\xa0\x36\x74\x26\xe9\xa5",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00"
          "\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00"
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80"
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00"
          "\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00"
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80",
          "\xae\x9b\x54\x25\x41\xe8\x4f\xc7\x45\x42\xee\xd6\xbe\x63\x8f\xee", 1,
          128, 1024 },
        { 96, 256, 128, 108,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00",
          "\xe5\xb6\x3b\xf0\xf4\xb7\x28\x39\x12\xe2\x4b\x1a\x40\xdf\x0d\x22\x35"
          "\x55\xdb\xe2\xa5\x4d\x94\xa4\xbf\x1d\xe7\x48\x53\xcc\x6f\x0d",
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80"
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00",
          "\x10\xfe\xe3\xec\xfb\xa9\xcd\xf7\x97\xba\xe3\x7a\x62\x6e\xc8\x3b", 1,
          128, 256 },
        { 96, 256, 128, 109,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00",
          "\xe5\xb6\x3b\xf0\xf4\xb7\x28\x39\x12\xe2\x4b\x1a\x40\xdf\x0d\x22\x35"
          "\x55\xdb\xe2\xa5\x4d\x94\xa4\xbf\x1d\xe7\x48\x53\xcc\x6f\x0d\xa0\xc1"
          "\x42\xfe\x09\x8f\xbb\xe6\xe8\xd4\x32\x43\x14\x43\x4c\x1b\x98\xb5\x8e"
          "\xad\xf1\x0a\xed\x9c\xb1\xdb\x1f\x2a\x0a\x1f\x1b\xb2",
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80"
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00"
          "\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00",
          "\x74\x90\x79\x5b\xdb\xbb\xf5\xd0\xae\xcb\x9a\x4f\x65\xaa\x37\x9f", 1,
          128, 512 },
        { 96, 256, 128, 110,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00",
          "\xe5\xb6\x3b\xf0\xf4\xb7\x28\x39\x12\xe2\x4b\x1a\x40\xdf\x0d\x22\x35"
          "\x55\xdb\xe2\xa5\x4d\x94\xa4\xbf\x1d\xe7\x48\x53\xcc\x6f\x0d\xa0\xc1"
          "\x42\xfe\x09\x8f\xbb\xe6\xe8\xd4\x32\x43\x14\x43\x4c\x1b\x98\xb5\x8e"
          "\xad\xf1\x0a\xed\x9c\xb1\xdb\x1f\x2a\x0a\x1f\x1b\xb2\xc4\x05\xc1\x83"
          "\x2f\x94\xee\x1a\x56\x30\xcd\x93\x91\x58\xa6\x21\xbd\x48\xc8\xff\x71"
          "\x0d\x0a\x1f\x1e\xf7\x60\x18\x0e\x65\x88\x02\x2a\xd5\x5e\x41\x21\xd9"
          "\x90\x69\x21\x8d\xb5\x5c\xd6\xaf\x7c\x10\x26\xf2\x1e\xcc\x0a\xf9\xb7"
          "\xce\x8a\x7e\xa0\xb6\xf4\x26\xe9\x25",
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80"
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00"
          "\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00"
          "\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80"
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00"
          "\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00"
          "\x00\x80\x00\x00\x00\x80\x00\x00\x00",
          "\x1d\x10\x96\xa8\xca\x9e\x2b\xda\x27\x62\xc4\x1d\x5b\x16\xf6\x2f", 1,
          128, 1024 },
        { 96, 256, 128, 111,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f",
          "\x9a\x49\xc4\x8f\x8b\x48\xd7\x46\x6d\x1d\xb4\x65\x3f\x20\xf2\x5d\x4a"
          "\xaa\x24\x9d\xda\xb2\x6b\xdb\xc0\xe2\x18\x37\x2c\x33\x90\x72",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f",
          "\xaf\x84\x92\xc7\x92\xbf\x8d\x80\x62\xbe\x74\xff\x6e\xfb\x38\x69", 1,
          128, 256 },
        { 96, 256, 128, 112,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f",
          "\x9a\x49\xc4\x8f\x8b\x48\xd7\x46\x6d\x1d\xb4\x65\x3f\x20\xf2\x5d\x4a"
          "\xaa\x24\x9d\xda\xb2\x6b\xdb\xc0\xe2\x18\x37\x2c\x33\x90\x72\xdf\x3e"
          "\xbd\x81\x76\x70\x44\x99\x97\x2b\xcd\x3c\x6b\xbc\xb3\x64\xe7\x4a\x71"
          "\xd2\x8e\xf5\x12\xe3\xce\x24\xe0\x55\x75\xe0\xe4\xcd",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff"
          "\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff"
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f",
          "\xf2\x4d\xb6\x8c\x46\xb6\x7d\x6f\x40\x2f\xa6\xc8\x97\x91\x33\x68", 1,
          128, 512 },
        { 96, 256, 128, 113,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f",
          "\x9a\x49\xc4\x8f\x8b\x48\xd7\x46\x6d\x1d\xb4\x65\x3f\x20\xf2\x5d\x4a"
          "\xaa\x24\x9d\xda\xb2\x6b\xdb\xc0\xe2\x18\x37\x2c\x33\x90\x72\xdf\x3e"
          "\xbd\x81\x76\x70\x44\x99\x97\x2b\xcd\x3c\x6b\xbc\xb3\x64\xe7\x4a\x71"
          "\xd2\x8e\xf5\x12\xe3\xce\x24\xe0\x55\x75\xe0\xe4\xcd\xbb\xfa\x3e\xfc"
          "\x50\x6b\x11\x65\x29\xcf\x32\xec\xee\xa7\x59\x5e\xc2\xb7\x37\x80\x0e"
          "\xf2\xf5\x60\x61\x08\x9f\x67\x71\x9a\x77\x7d\x55\x2a\xa1\x3e\x5e\x26"
          "\x6f\x16\x5e\x72\x4a\x23\xa9\x50\x83\x6f\x59\x0d\xe1\xb3\x75\x06\x48"
          "\xb1\xf5\x81\x5f\xc9\x8b\xd9\x16\x5a",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff"
          "\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff"
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f"
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff"
          "\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff"
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f",
          "\x43\xf6\x51\xab\x2e\x2e\xb0\xf0\x4b\xf6\x89\xa4\x0d\x32\xda\x24", 1,
          128, 1024 },
        { 96, 256, 128, 114,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff",
          "\x1a\x49\xc4\x0f\x0b\x48\xd7\xc6\xed\x1d\xb4\xe5\xbf\x20\xf2\xdd\xca"
          "\xaa\x24\x1d\x5a\xb2\x6b\x5b\x40\xe2\x18\xb7\xac\x33\x90\xf2",
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f"
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff",
          "\x60\xd9\x52\x94\xa3\x69\x4c\xfa\xa6\x4b\x2f\x63\xbc\x1f\x82\xec", 1,
          128, 256 },
        { 96, 256, 128, 115,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff",
          "\x1a\x49\xc4\x0f\x0b\x48\xd7\xc6\xed\x1d\xb4\xe5\xbf\x20\xf2\xdd\xca"
          "\xaa\x24\x1d\x5a\xb2\x6b\x5b\x40\xe2\x18\xb7\xac\x33\x90\xf2\x5f\x3e"
          "\xbd\x01\xf6\x70\x44\x19\x17\x2b\xcd\xbc\xeb\xbc\xb3\xe4\x67\x4a\x71"
          "\x52\x0e\xf5\x12\x63\x4e\x24\xe0\xd5\xf5\xe0\xe4\x4d",
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f"
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff"
          "\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff",
          "\xbe\xac\xa0\xb4\x70\x27\x19\x61\x76\x18\x6d\x94\x40\x19\xc1\xc8", 1,
          128, 512 },
        { 96, 256, 128, 116,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff",
          "\x1a\x49\xc4\x0f\x0b\x48\xd7\xc6\xed\x1d\xb4\xe5\xbf\x20\xf2\xdd\xca"
          "\xaa\x24\x1d\x5a\xb2\x6b\x5b\x40\xe2\x18\xb7\xac\x33\x90\xf2\x5f\x3e"
          "\xbd\x01\xf6\x70\x44\x19\x17\x2b\xcd\xbc\xeb\xbc\xb3\xe4\x67\x4a\x71"
          "\x52\x0e\xf5\x12\x63\x4e\x24\xe0\xd5\xf5\xe0\xe4\x4d\x3b\xfa\x3e\x7c"
          "\xd0\x6b\x11\xe5\xa9\xcf\x32\x6c\x6e\xa7\x59\xde\x42\xb7\x37\x00\x8e"
          "\xf2\xf5\xe0\xe1\x08\x9f\xe7\xf1\x9a\x77\xfd\xd5\x2a\xa1\xbe\xde\x26"
          "\x6f\x96\xde\x72\x4a\xa3\x29\x50\x83\xef\xd9\x0d\xe1\x33\xf5\x06\x48"
          "\x31\x75\x81\x5f\x49\x0b\xd9\x16\xda",
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f"
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff"
          "\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff"
          "\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f"
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff"
          "\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff"
          "\xff\x7f\xff\xff\xff\x7f\xff\xff\xff",
          "\xd4\x81\x10\x28\xa5\x77\xd4\xdd\x69\xd6\xb3\x5d\x71\x7f\x73\xe3", 1,
          128, 1024 },
        { 96, 256, 128, 117,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x65\xb6\x3b\xf0\x8b\x48\xd7\xc6\x92\xe2\x4b\x1a\x3f\x20\xf2\xdd\xb5"
          "\x55\xdb\xe2\xda\xb2\x6b\x5b\x3f\x1d\xe7\x48\x2c\x33\x90\xf2",
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00"
          "\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x10\xfb\x61\x27\x2b\x55\x5b\xee\x10\x4f\x5a\x71\x81\x87\x16\xd6", 1,
          128, 256 },
        { 96, 256, 128, 118,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x65\xb6\x3b\xf0\x8b\x48\xd7\xc6\x92\xe2\x4b\x1a\x3f\x20\xf2\xdd\xb5"
          "\x55\xdb\xe2\xda\xb2\x6b\x5b\x3f\x1d\xe7\x48\x2c\x33\x90\xf2\x20\xc1"
          "\x42\xfe\x76\x70\x44\x19\x68\xd4\x32\x43\x6b\xbc\xb3\xe4\x18\xb5\x8e"
          "\xad\x8e\xf5\x12\x63\x31\xdb\x1f\x2a\x75\xe0\xe4\x4d",
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00"
          "\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00"
          "\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00"
          "\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x47\x56\x76\x4e\x59\x58\x35\x04\x18\x28\x77\xd8\xc3\x31\x20\xf0", 1,
          128, 512 },
        { 96, 256, 128, 119,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x65\xb6\x3b\xf0\x8b\x48\xd7\xc6\x92\xe2\x4b\x1a\x3f\x20\xf2\xdd\xb5"
          "\x55\xdb\xe2\xda\xb2\x6b\x5b\x3f\x1d\xe7\x48\x2c\x33\x90\xf2\x20\xc1"
          "\x42\xfe\x76\x70\x44\x19\x68\xd4\x32\x43\x6b\xbc\xb3\xe4\x18\xb5\x8e"
          "\xad\x8e\xf5\x12\x63\x31\xdb\x1f\x2a\x75\xe0\xe4\x4d\x44\x05\xc1\x83"
          "\x50\x6b\x11\xe5\xd6\x30\xcd\x93\xee\xa7\x59\xde\x3d\x48\xc8\xff\x0e"
          "\xf2\xf5\xe0\x9e\xf7\x60\x18\x71\x9a\x77\xfd\xaa\xd5\x5e\x41\x5e\x26"
          "\x6f\x96\xa1\x8d\xb5\x5c\xa9\x50\x83\xef\xa6\xf2\x1e\xcc\x75\x06\x48"
          "\x31\x0a\x7e\xa0\xb6\x8b\xd9\x16\xda",
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00"
          "\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00"
          "\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00"
          "\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00"
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff"
          "\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff"
          "\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff"
          "\xff\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x95\xa2\xb1\x2a\x4a\x28\x00\x89\xd4\xbd\x4f\x90\x42\x53\xe7\x54", 1,
          128, 1024 },
        { 96, 256, 128, 120,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00",
          "\x9a\x49\xc4\x0f\x74\xb7\x28\x39\x6d\x1d\xb4\xe5\xc0\xdf\x0d\x22\x4a"
          "\xaa\x24\x1d\x25\x4d\x94\xa4\xc0\xe2\x18\xb7\xd3\xcc\x6f\x0d",
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff"
          "\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00",
          "\x60\xdc\xd4\x59\x74\xbe\xbe\x03\x2e\xb7\xb8\x6c\x9d\x06\x34\x52", 1,
          128, 256 },
        { 96, 256, 128, 121,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00",
          "\x9a\x49\xc4\x0f\x74\xb7\x28\x39\x6d\x1d\xb4\xe5\xc0\xdf\x0d\x22\x4a"
          "\xaa\x24\x1d\x25\x4d\x94\xa4\xc0\xe2\x18\xb7\xd3\xcc\x6f\x0d\xdf\x3e"
          "\xbd\x01\x89\x8f\xbb\xe6\x97\x2b\xcd\xbc\x94\x43\x4c\x1b\xe7\x4a\x71"
          "\x52\x71\x0a\xed\x9c\xce\x24\xe0\xd5\x8a\x1f\x1b\xb2",
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff"
          "\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff"
          "\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff"
          "\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00",
          "\xf0\xe6\xa3\xc1\xf2\x8a\xd9\x2d\x0d\xbc\x90\x0b\xe2\x91\xd8\x77", 1,
          128, 512 },
        { 96, 256, 128, 122,
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90"
          "\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00",
          "\x9a\x49\xc4\x0f\x74\xb7\x28\x39\x6d\x1d\xb4\xe5\xc0\xdf\x0d\x22\x4a"
          "\xaa\x24\x1d\x25\x4d\x94\xa4\xc0\xe2\x18\xb7\xd3\xcc\x6f\x0d\xdf\x3e"
          "\xbd\x01\x89\x8f\xbb\xe6\x97\x2b\xcd\xbc\x94\x43\x4c\x1b\xe7\x4a\x71"
          "\x52\x71\x0a\xed\x9c\xce\x24\xe0\xd5\x8a\x1f\x1b\xb2\xbb\xfa\x3e\x7c"
          "\xaf\x94\xee\x1a\x29\xcf\x32\x6c\x11\x58\xa6\x21\xc2\xb7\x37\x00\xf1"
          "\x0d\x0a\x1f\x61\x08\x9f\xe7\x8e\x65\x88\x02\x55\x2a\xa1\xbe\xa1\xd9"
          "\x90\x69\x5e\x72\x4a\xa3\x56\xaf\x7c\x10\x59\x0d\xe1\x33\x8a\xf9\xb7"
          "\xce\xf5\x81\x5f\x49\x74\x26\xe9\x25",
          "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff"
          "\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff"
          "\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff"
          "\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff"
          "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00"
          "\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00"
          "\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00"
          "\x00\xff\xff\xff\xff\x00\x00\x00\x00",
          "\x57\xef\xf4\xa5\x25\xee\xff\x2e\xbd\x7a\x28\xeb\x89\x42\x82\xbe", 1,
          128, 1024 },
        { 96, 256, 128, 123,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf5\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 124,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf6\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 125,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\x74\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 126,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x41\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 127,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\x37\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 128,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x28\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 129,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x2b\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 130,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x88\x14\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 131,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x15\xac\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 132,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\x8c\x51\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 133,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x50\x40\x54\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 134,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x55\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 135,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x56\x32\x3f\x44", 0,
          24, 0 },
        { 96, 256, 128, 136,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x45", 0,
          24, 0 },
        { 96, 256, 128, 137,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x46", 0,
          24, 0 },
        { 96, 256, 128, 138,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\x04", 0,
          24, 0 },
        { 96, 256, 128, 139,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x08\x14\xac\x51\x40\x54\x32\x3f\xc4", 0,
          24, 0 },
        { 96, 256, 128, 140,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xf4\x40\x9b\xb7\x29\x03\x9d\x88\x14\xac\x51\x40\x54\x32\x3f\xc4", 0,
          24, 0 },
        { 96, 256, 128, 141,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          24, 0 },
        { 96, 256, 128, 142,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "", "",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          24, 0 },
        { 96, 256, 128, 143,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x28\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 144,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x2b\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 145,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\xa9\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 146,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x90\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 147,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x87\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 148,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa7\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 149,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa4\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 150,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\x53\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 151,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf0\x09\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 152,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x29\xbb\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 153,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xba\xa2\x1c\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 154,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1d\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 155,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1e\xe9\xa7\xd6", 0,
          24, 128 },
        { 96, 256, 128, 156,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd7", 0,
          24, 128 },
        { 96, 256, 128, 157,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\xd4", 0,
          24, 128 },
        { 96, 256, 128, 158,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\x96", 0,
          24, 128 },
        { 96, 256, 128, 159,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\xd3\xf1\x09\xbb\xa2\x1c\xe9\xa7\x56", 0,
          24, 128 },
        { 96, 256, 128, 160,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x29\x91\x40\x07\xa6\x11\x9d\x53\xf1\x09\xbb\xa2\x1c\xe9\xa7\x56", 0,
          24, 128 },
        { 96, 256, 128, 161,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          24, 128 },
        { 96, 256, 128, 162,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          24, 128 },
        { 96, 256, 128, 163,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x67\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 164,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x64\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 165,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\xe6\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 166,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x41\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 167,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x96\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 168,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe9\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 169,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xea\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 170,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\x3a\x92\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 171,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x93\xaa\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 172,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\x8a\x47\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 173,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x46\xf5\xce\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 174,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xcf\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 175,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xcc\xa5\x2b\x7a", 0,
          24, 264 },
        { 96, 256, 128, 176,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x7b", 0,
          24, 264 },
        { 96, 256, 128, 177,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x78", 0,
          24, 264 },
        { 96, 256, 128, 178,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\x3a", 0,
          24, 264 },
        { 96, 256, 128, 179,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\xba\x92\xaa\x47\xf5\xce\xa5\x2b\xfa", 0,
          24, 264 },
        { 96, 256, 128, 180,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x66\x40\x5a\x16\xe8\xb4\x4e\x3a\x92\xaa\x47\xf5\xce\xa5\x2b\xfa", 0,
          24, 264 },
        { 96, 256, 128, 181,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          24, 264 },
        { 96, 256, 128, 182,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b", "\x00\x01\x02",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\xd0\x3b\xcb\x3c\xa5\x2d\x48\xd1\xd2\x03\xb1\xe7\xb1\xa5\x99\x5a\xf1"
          "\xa0\x46\x6a\x61\xbb\x38\x6a\x2e\x12\xd1\x89\xa2\xc4\xea\x15\xe9",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          24, 264 },
        { 96, 256, 128, 183,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x8c"
          "\x38\x2c\xf0\x71\x74\x14\x2e\xa5\x64\x92\x06\x12\x99\x7b\x1c\x2e\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x0f\xf9\xbc"
          "\x3b\x94\x58\x29\x7b\xa0\x96\x7d\x86\xed\x09\x0b\x43\x51\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x03\xf3\xb7\x35\xb7"
          "\x34\x54\x28\xeb\x93\xb3\xdb\x1d\x9b\x51\x87\xce\xbb\x88\x9a\xa1\x77"
          "\xd8\x3e\x4f\x63\xfc\x9a\x5c\x05\x96\xee\xd9\x39\x88\x3d\x06\xaa\xcd"
          "\xfd\xea\x44\xfd\xec\xdf\x5c\xb7\xfc",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xc2\x96\x43\x62\x46\xc3\xa7\xc4\xb3\xba\x09\xab\x2a\x6a\x08\x89", 1,
          512, 1024 },
        { 96, 256, 128, 184,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x05\x1e\x93\x73",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x93\x12\x27\x27\x4a\x89\xd0\xb3\xaa\xde\x7f\xac\x62\xc9\x62\x62\xc1"
          "\xe7\x7b\x8d\xaf\xd2\x48\xf1\x0a\xd3\x7c\x6c\xcb\x69\xcb\x71\x31\xb0"
          "\x41\x59\x3c\x8b\xb8\xc3\xdb\x38\xf3\x9d\xd8\xa1\x24\xc4\x24\xfc\xe4"
          "\x38\x9d\xed\xe1\xd3\xcb\x9d\x46\xcf\x95\x97\x0a\xea\x98\x56\xb6\xe3"
          "\x13\xd7\x56\x19\x7b\xaf\x4f\xcb\x58\xdf\x27\x5b\xca\x8a\x21\x88\xf9"
          "\xe8\xa1\xad\x04\x35\x4e\xde\x54\x2d\xdc\x30\xe8\xb7\x35\xb2\xf5\x90"
          "\x5f\x58\x11\x79\x92\x82\xbe\x94\xae\x84\x2e\xc1\x26\xc5\x5d\x2e\x66"
          "\x72\x35\xe9\xac\xf1\xd4\x87\x98\xf0",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x99\xa3\xb0\xff\xf6\xfd\xcb\xcc\xe9\xdc\x58\x20\xf2\xa6\x48\x61", 1,
          512, 1024 },
        { 96, 256, 128, 185,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x04\x8c\x3c\x5f",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x0d\xf9\x1f\x31\x23\x0e\x89\x41\xe7\x00\xa7\x52\xfe\xf0\x8c\x89\x7c"
          "\x51\x1e\xd6\x18\xfd\xf8\xa3\x78\xa1\xf4\x39\x01\x3b\x40\xa4\x8d\x46"
          "\x34\xc2\x7d\x9a\xda\x7c\x0b\xb6\xf3\xfa\x92\xe3\x41\x42\x59\x03\xd7"
          "\xec\xd0\xc4\x9b\xee\x4c\x77\xe8\x4b\x11\xf1\xc7\x21\x92\x23\x08\x64"
          "\x28\x85\xb8\x13\xfa\xe3\x64\xda\x32\xea\xf1\x20\xd6\xa4\x3a\x74\xfb"
          "\x16\x32\x44\x36\x67\xbf\xea\x6e\xef\x1b\xe7\x3e\xb1\xc3\xc0\xb5\xa5"
          "\x7c\xee\x8d\xc4\xfe\xed\x4a\x1f\xb9\xae\x02\xf7\xb1\x69\x55\x88\xc3"
          "\xc8\x78\x45\x1c\xb6\xee\x0c\xb3\xdc",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xea\xff\x8f\x47\xef\x92\x68\xfd\x0d\x94\xe8\xa9\xc4\xb7\x8d\x24", 1,
          512, 1024 },
        { 96, 256, 128, 186,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x42"
          "\x8a\x85\x43\x14\x30\xea\xda\x56\xa2\xc5\xdc\x94\x4b\x6a\xa6\xce\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x58\xe0\x94"
          "\x3e\x30\xf9\x1b\xa4\x1b\x43\x62\xfa\x9e\xd6\x03\x7b\x21\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xe2\x59\x0a\xf1\x20"
          "\x1c\x7c\xfe\xc2\x29\x0c\xfc\xe9\x8a\x82\x2e\xbb\x8d\x1e\xd9\xdc\x4e"
          "\x20\xd2\x41\x75\x5a\xff\x91\xcd\xfd\x10\xfd\xb6\x9e\xfa\x0d\x5c\x80"
          "\x82\x69\x26\x01\xcb\xfb\xb9\x55\xc7",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x86\xed\x21\xfd\xa0\x80\xa7\xd1\x39\x81\x07\x8d\x86\xb3\xe3\xcd", 1,
          512, 1024 },
        { 96, 256, 128, 187,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x66\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x66"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xe8\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x50\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x64\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\x98\x00\xac\x4e\xf9"
          "\xd4\xe4\x01\x45\x24\xbc\x7c\xd3\x38\x72\x42\xe7\x74\xf4\xd1\xa7\xa0"
          "\x52\x1e\x42\xec\x44\x84\x4d\x0b\xd8\xb9\xd7\x3f\xec\x95\x92\x12\xfd"
          "\x7e\x8e\xac\xf4\xd9\x84\x99\x6d\x9b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x34\xf9\xe0\xfa\xa5\x15\xee\xe0\xe7\x84\xe6\xef\x26\x78\xbe\xfa", 1,
          512, 1024 },
        { 96, 256, 128, 188,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x26\xc6\x96\x1b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xe9\x72\x44\x25\x9a\xf5\xa3\x79\x23\x8d\xa0\xca\xd2\xa5\xf4\x93\x65"
          "\x5e\xc0\xe5\x02\x4f\xd5\x53\xbb\xb3\xde\xb6\x6a\x94\x03\x6d\x10\x6c"
          "\x3d\x51\x34\x07\xb2\xdd\x1c\xc5\x93\x6c\x4c\x9c\x1e\x4f\x4b\x37\xb5"
          "\x4d\xec\x26\x1c\x60\x1d\xc9\x9e\x90\x68\x0e\x23\xe2\xdc\x5c\x9a\x8d"
          "\x50\x3d\x8b\xea\x49\xa8\xcd\xca\x37\x06\xbf\xd2\xa3\xda\xa0\xaf\xb1"
          "\x9a\x70\xfd\x3d\x35\x5f\xc3\x7c\x13\xf3\xf9\xe5\xc8\xd0\x86\x4a\x5f"
          "\x80\xa7\x80\xb3\x6d\x46\x98\xec\x2c\xe9\xcc\xc2\x7b\x97\xec\xbe\x67"
          "\x2e\x41\x62\x8e\xbd\x77\x3a\xcb\x81",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x3c\x94\xb9\xfe\x60\xbd\xb3\x5c\x6b\x7b\x73\xb7\x65\x08\x34\x92", 1,
          512, 1024 },
        { 96, 256, 128, 189,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x01\x3d\xa0\x60",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x94\x53\xaa\x15\x9c\x3d\x87\xf1\x7e\x21\xe8\x8a\xda\xbc\x37\xe5\x53"
          "\xb9\x04\xd0\x0e\xef\xc6\x6b\x8e\x09\x05\xe2\x35\x76\xfb\xdc\x9c\x7b"
          "\xea\x97\x77\xf3\xb8\x36\x84\x81\x93\x25\x34\xb3\x34\x4d\x30\x9e\x63"
          "\x07\xcd\xdf\xe7\xb3\x54\x93\x00\xdd\x9c\xda\x7e\xfe\x9d\x43\xc8\xa1"
          "\x15\x91\x2a\x39\x29\x04\x07\x9e\xe9\x2b\xcd\x33\x09\x9f\x70\x22\xea"
          "\x94\xc1\xe7\x35\x3b\x89\xbf\xc5\x4d\xe3\xce\xb5\x6f\x52\x9a\x1a\x60"
          "\x8b\xb5\xa9\x70\xe1\x35\x96\x09\xd1\xf5\x68\x06\xb3\x7f\x86\x05\xf4"
          "\xc2\x74\x51\xda\x60\x66\xfc\x55\x7a",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x2b\x11\xcf\x9f\x8d\xb8\x49\x0d\x40\x9f\xc6\x2a\xfd\x73\x79\xf3", 1,
          512, 1024 },
        { 96, 256, 128, 190,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x07\xdb\x33\xde",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x2e\x18\x36\x64\x0d\x81\x0c\x27\x09\xfb\x83\xcc\xf1\xae\xf3\xa9\x71"
          "\x08\x5d\x1b\xbf\xb5\x8a\x42\x5a\xbf\x75\xcc\xec\x70\xb3\xab\xde\x0e"
          "\x80\x53\x9e\x83\xa8\x25\x46\xe7\x37\x2a\x19\x48\x15\x47\x05\x33\x08"
          "\xdd\x78\x42\x67\x5e\x9c\x4f\x61\x30\x24\x26\xda\x0d\x71\xc1\xda\x31"
          "\x02\x03\x10\x30\xed\x92\x81\x52\xbe\x00\x9b\x15\xb5\x2f\x71\xb5\x91"
          "\x19\x91\xd3\x9f\x68\xa8\x65\x8d\x99\x72\x9d\xf2\xbb\xef\x31\xc8\x98"
          "\x9f\x96\x04\x55\x8d\xf9\xf2\xab\xa4\xb3\x76\x6c\x58\xaa\xef\x35\x48"
          "\xde\x54\x5e\xc1\xf0\x80\x22\x5a\x88",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xc9\xc8\x36\x69\x20\xf8\x83\x81\x40\x77\x12\xce\xc6\x1e\x66\x07", 1,
          512, 1024 },
        { 96, 256, 128, 191,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x02\xa1\x19\x42",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x0e\xcb\x4d\x85\xc9\x56\xb5\x26\x8c\x9b\x35\xa8\xc6\x3b\x4e\x9d\x3e"
          "\x5c\xb7\x2b\x64\xef\x98\x77\x38\x41\xb9\x47\xbd\x7d\x59\xef\x7d\x0e"
          "\xb0\xe1\xc0\x50\xd4\x9a\x54\x24\xce\x7d\xeb\x52\x7d\x76\x08\x7e\x47"
          "\x46\x67\x4c\x95\x89\x65\xdf\x32\xd9\xe5\xfb\x03\xb4\x65\x01\x70\x61"
          "\x28\xd4\x81\x21\x7a\xae\xae\x2f\x78\xf9\x25\x92\x73\x35\x8a\x29\x54"
          "\xca\xc0\xbc\x2f\xbf\xe7\x74\x47\xd1\xd3\x87\xb9\x31\x4c\x65\x41\xb6"
          "\x9f\x12\x70\xb3\x43\x8b\x10\x42\xb2\xb4\x66\x3e\x62\xba\x4d\x49\xc0"
          "\x7a\xc6\xf1\x63\x03\x4a\xfa\x80\xaf",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x23\x73\xcf\xa2\xab\x24\x44\x6a\xd5\xa2\x36\x16\x7b\x80\x27\xfe", 1,
          512, 1024 },
        { 96, 256, 128, 192,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x3c\x0d\xf6\x37",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x2e\x8e\x45\xe9\x03\xbf\xab\x32\xf2\xf0\xd4\x9d\x9a\x3e\x44\x9b\xef"
          "\x6f\x40\x93\xe2\x72\x2c\xda\xb2\xcf\x93\x5c\x18\x22\xb8\x30\xfb\x5a"
          "\x40\x56\x51\x6d\x56\x0d\xfc\x86\x38\xc9\xa5\x7d\x29\x27\x20\x0a\x56"
          "\xf0\xb6\x71\x53\x27\x1d\x49\x8e\x8f\x08\xdc\x88\x8c\x61\xef\x63\x4f"
          "\x7a\xe4\x0f\x46\x08\xf9\x6f\x92\xfe\xa5\xa1\xe5\xbd\x45\x13\x11\x20"
          "\x09\x8d\xc5\xde\x03\x78\xe5\x8f\x2d\xdb\x46\xfa\x4a\xa5\xad\xb3\x8f"
          "\xe0\x06\xbb\x19\xb6\x91\x46\x38\x2f\x77\xa7\x9e\x06\x21\x4d\xef\x54"
          "\x7c\xfb\x5c\xe3\x7a\x70\x08\xb9\xb6",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x5f\x93\x94\x64\x78\xd8\x08\x1e\x72\x47\xf4\x14\xad\x39\xa5\x15", 1,
          512, 1024 },
        { 96, 256, 128, 193,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x0b\xc6\x72\xc3",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x36\x19\xcb\x47\x0a\xf8\x6d\xce\xce\xb6\x94\x0f\x2d\x9a\xbb\x34\xc9"
          "\xa9\x13\x14\x76\x05\x33\x87\x44\x5f\xfe\xbb\xe2\x40\xd4\xf9\x81\x83"
          "\x77\x85\x56\x52\xf4\x6a\x82\x19\xc7\xf7\x1c\x35\x54\xf8\xac\xef\x82"
          "\x58\xde\x4b\x7d\x17\xc0\xf3\xd3\x53\xac\x98\x1c\xc6\xa1\x32\x87\xbe"
          "\x1e\x6b\x41\xdc\x6d\x13\x3d\xf4\xab\xab\xeb\xdf\x43\xd6\x65\xce\x7a"
          "\x4a\x5c\x98\x2a\x0b\x13\x9c\xb8\x20\x2e\xeb\xc7\x41\x73\xe3\x22\x4a"
          "\x44\x0e\x4c\x37\xd2\xb5\x95\xf3\x84\x29\x0e\x93\x9b\xa0\x16\xdf\x0d"
          "\x49\xb3\x6c\xdb\x4b\xd9\x1c\x39",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x13\x3f\xe6\x23\x91\x74\x4d\x11\xce\x44\x59\x4b\x96\xc5\x3b\xaf", 1,
          512, 1016 },
        { 96, 256, 128, 194,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x03\xe9\xb9\xa4",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xaf\x20\x5b\xda\x81\x9f\x74\x51\xbe\x0f\x28\x66\x7d\x4b\x01\xb5\x9f"
          "\xf2\xda\xa8\x17\x3c\xab\x52\x04\x6c\x3c\x9e\x0d\x98\x98\x89\xc5\xe0"
          "\x21\xef\x7a\xfd\x06\xe9\xce\x6c\xc3\x0e\x3a\x6e\xba\xb5\x09\x13\x4b"
          "\xa1\x0d\x10\xe5\x70\xc5\x55\x87\xc1\x3e\xee\x53\xe7\x3b\xe5\x48\x04"
          "\xc8\x53\x9f\xfb\xf2\x3b\x35\x92\x2b\x1c\xa3\x7b\x9e\x9b\xc2\x4e\xe2"
          "\x04\x83\x7c\xa5\xa2\x94\xce\x05\xd1\x26\x00\xc7\xef\xf6\xae\xe3\x22"
          "\x70\xdb\x2f\xef\xf4\x7d\xc5\xa0\x41\x76\x16\x9e\x15\x85\x06\x28\xe6"
          "\x03\x5f\x78\x99\x4f\x9f\x56\x03",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xe3\x45\x1a\xdb\x9d\x23\xa7\x71\x0a\x1a\xaf\xba\x26\xf5\x63\x87", 1,
          512, 1016 },
        { 96, 256, 128, 195,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x07\x00\xb9\x82",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x68\xc6\x72\x72\x03\x6f\xb6\x52\xa0\x18\x2e\xeb\x47\x81\x35\x8e\x47"
          "\x04\xa4\xa7\x02\xfd\x73\x1b\xf3\xb3\xea\x99\x47\x17\x98\x9e\x7d\x91"
          "\x04\xe0\xae\x81\x73\x2a\x8c\x7e\x9a\x82\xb3\xd3\x1d\x54\x17\x61\xa3"
          "\x66\xb6\x7c\x33\x96\xf1\xa6\xc6\x7e\x29\x3d\xdb\x65\xa5\x9e\x42\x54"
          "\x1d\xda\x14\x4d\xc6\xc7\x83\x88\xcf\xca\x98\x2e\x23\x35\x09\x58\xac"
          "\x5b\x3d\x54\xa1\x72\x2f\xd6\x47\x33\x57\x78\x62\xe1\x87\x9c\x9e\x94"
          "\x45\xeb\xde\xc5\x31\x5d\x17\x06\xdb\x7e\xbb\xed\xd4\xc7\x79\x93\x5e"
          "\x72\x05\x7e\x5b\x0e\xcd\xe0\x81",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xb0\xbb\x8a\x55\xff\x5f\x52\xa5\x04\x3c\x6e\x77\x95\x84\x75\x57", 1,
          512, 1016 },
        { 96, 256, 128, 196,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x01\x98\x36\xbb",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xc4\x83\xb7\x33\x4e\xbe\x2e\x87\x9b\x0c\x3f\x9d\xb4\xfc\xd9\xf5\x21"
          "\x90\x62\x36\x0d\x6c\xe4\x4c\xda\xe0\xf9\x4e\x04\xc8\x34\x5e\xa7\xe3"
          "\xae\x33\x85\x51\x18\x74\x1d\xca\xfe\x0d\xe4\xae\x98\xc4\xe4\x3a\xf7"
          "\xb1\x2b\x04\xee\x8a\xb1\x75\x62\x58\x23\xac\x04\x0e\x5a\xba\xc4\x40"
          "\x3f\x1d\x45\x23\x8a\xdc\xb8\xc0\xcf\x44\xbd\x56\x91\x7f\x9f\x5d\x93"
          "\x97\x4c\x82\xb5\x69\x51\x98\x6a\x9c\x04\x50\xbd\x90\x47\xb5\xa6\x16"
          "\xe8\x14\x52\x6a\xd0\x58\x0e\x3e\xcd\x81\x89\xc9\xfe\xf2\xcd\xb9\x79"
          "\xa2\x2a\xd3\xa0\x19\x30\xfb\xd1",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xf4\xfc\x25\xf4\xc5\x54\x3a\x9a\xfe\xe9\x81\x9e\x29\x04\xfb\x68", 1,
          512, 1016 },
        { 96, 256, 128, 197,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x1d\x59\xf2\x88",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xbc\x7f\x4f\x15\xfd\x1e\x4c\x13\x99\x74\x08\x36\x67\x0a\xbe\x39\xa0"
          "\x57\x07\xbe\x19\x95\x6c\xe1\x69\xb3\x23\x21\x75\x9e\x0f\x21\x3a\xe1"
          "\x9a\xd3\x4a\xa6\x12\xb3\xa2\x9f\x02\xc4\xbb\xac\x9f\x78\x5a\x55\xa3"
          "\xad\xfe\x41\x9a\xb8\x91\xbb\xe0\xac\xee\x99\x21\x32\x2e\xa2\x10\x02"
          "\xc9\xdd\x3d\xcd\xd1\x3a\x7f\x85\x54\xdd\xdc\x10\xf9\xb5\x29\xce\x94"
          "\xbe\x70\x50\x93\x7d\xab\x76\x55\x7b\x7e\xb1\x7c\x68\x5a\xad\x8f\x07"
          "\x97\xe3\x9d\x62\x55\x39\x88\x98\x9a\xab\x1d\x97\x64\xfe\x43\x1c\xc1"
          "\xd4\xc5\x95\x06\x2c\xe9\x3c\xe9",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x5e\x67\xa7\xb8\x73\x3e\x0e\x4b\x01\xac\x21\x78\xa2\x05\xae\x7e", 1,
          512, 1016 },
        { 96, 256, 128, 198,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x05\x52\xa4\x11",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xea\xcc\xaa\x77\x89\x35\xef\x24\x9e\x09\x00\x14\x9d\xd8\x89\x46\x2d"
          "\x2a\x06\x14\x86\xba\x10\x2b\x8c\xae\xbe\x46\x5f\x39\x59\xfb\x31\x19"
          "\xeb\xb5\x68\x96\x76\xff\xdd\x6d\x85\x1a\x26\x73\x9e\x77\x2b\x54\xa2"
          "\xf5\xf4\x73\xea\x9c\x7e\x58\xcc\xbc\x4c\xfc\x95\x3e\x8c\x42\x0b\x21"
          "\x75\xd9\xdd\x51\x92\x65\x63\x0b\xb7\x9b\xd8\x7a\x60\x1b\x11\x32\x31"
          "\xa8\xb1\x6c\xe5\x4c\x33\x13\x47\xec\x04\xc2\xb1\xc9\x16\x0f\x38\x20"
          "\x7a\xa4\x6e\x96\xfe\xb0\x6d\xee\x88\x3e\xb4\x22\xfa\x14\x90\x8d\xf3"
          "\x00\xbb\x1a\x1e\xf7\x58\xc4\x08",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x17\x7a\x77\xfc\xe1\x14\xa4\x34\x9c\x4f\x8d\x5e\xc8\x25\xd0\x6f", 1,
          512, 1016 },
        { 96, 256, 128, 199,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x0c\x80\x7a\x72",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xa7\x6c\x33\x0e\x01\x50\x60\xa1\x7e\x64\xcb\x7b\x6d\x75\x3f\x20\x1f"
          "\x75\xbe\x87\x59\xfd\x75\x39\xfb\x92\xb2\x2a\xef\x54\xc9\xd3\x02\x9d"
          "\xba\x0c\x15\xcb\xf7\xc9\x51\x35\x88\x83\x19\xc6\xb2\xe6\x27\x6d\xa2"
          "\x1e\x0c\x35\x1f\xd5\x22\xb2\x9a\xab\xb5\x88\x3a\x32\x91\xd6\xf4\x27"
          "\xde\x77\x3b\x12\x43\x90\xef\x6f\xd9\x66\x21\xff\xbc\x42\xdf\xbf\x7a"
          "\x34\xda\x27\x2c\xbc\x9c\xcb\x1a\x49\x8d\x07\x80\x33\xd1\xac\x3b\xf7"
          "\xe9\x27\x15\x94\x8b\x06\xd6\x9d\x5c\x50\x39\xe9\x16\x4b\xa9\xc3\xa0"
          "\x22\x19\xec\x59\x08\x20\x6b\x3b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x62\x3c\x7d\x44\x24\xf5\x49\x7a\xed\xfd\x13\x39\xcf\x8c\xec\xce", 1,
          512, 1016 },
        { 96, 256, 128, 200,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x03\x97\xa1\x43",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x22\x8a\x7e\x15\xbc\xce\x13\x05\x1d\xe9\x14\x5f\x77\xf7\xf4\xff\x79"
          "\x21\x82\x8b\x4f\x99\xef\xc4\xff\x55\xee\x0d\x93\x44\x95\x5b\x69\xec"
          "\x2d\x47\x98\xb0\x51\x7f\x02\x73\xc4\x45\x6a\xe5\xff\xc5\x92\x9c\xbe"
          "\x74\xdd\xb0\xda\x51\xd4\xf2\xb4\xdf\x75\x78\xa3\x12\x40\xc8\x8a\xe9"
          "\x22\xc3\xc5\xec\xa7\xb9\x7d\x72\xd4\x97\x06\x20\x50\xa5\x87\x44\x7c"
          "\x56\x2b\x34\x3d\x5c\x71\x92\x19\x44\x87\x2f\x9f\xd0\x6b\x8f\x34\xb3"
          "\xeb\x5d\x43\x41\xf5\xff\x8a\x90\x7d\xd7\xc2\xe1\x67\x6b\x81\x25\x27"
          "\x26\xba\x54\x81\x4d\xa5\x1e\xab",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x1c\x18\xb6\x93\x54\xb1\x89\x73\x1a\x1a\x83\xfe\x8f\x0d\x57\xc9", 1,
          512, 1016 },
        { 96, 256, 128, 201,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x08\xcb\x0f\x3f",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xc7\xd8\x43\x18\x8a\xb1\x93\xdf\xef\x5c\x4d\xaf\x58\x3f\x95\x2c\xd4"
          "\xb1\x95\xf2\x40\xfa\x2e\x70\x4d\x02\x17\x23\x02\x3c\x12\x33\x71\xa4"
          "\x1e\x87\xdf\xc6\xe6\xc3\x87\x4a\x42\xf3\x31\xcf\x03\x59\x88\xa3\x8c"
          "\x72\xba\x2d\xa8\x54\xb1\x20\x8f\x98\xbf\x8c\xc2\x99\x48\x16\x94\x81"
          "\xab\x3a\x40\x2d\x5f\xcc\x7f\xf7\x8f\x9e\x31\x92\x55\x76\xdc\x39\x38"
          "\x07\x4b\x8c\x5b\x27\x96\x0e\x3a\xfc\x75\x0a\xd6\x86\x56\x36\x88\xb7"
          "\x44\x17\x87\x28\x8d\x52\x56\xc1\x30\x1d\x56\x3b\x77\x44\x84\x3b\xd1"
          "\xab\x4e\xff\x5b\xe6\xf1\x65\x3d",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x20\x45\x81\x5b\x82\x11\xb9\xa2\x99\x5e\xff\xe0\xb8\xed\x98\x68", 1,
          512, 1016 },
        { 96, 256, 128, 202,
          "\x9d\xe8\x36\xaa\x57\x95\x85\x08\x1f\x33\x0a\x7c\x40\x36\xe2\x0e\x38"
          "\xef\x15\xef\xf3\x94\x51\x84\xd2\x31\x86\x7f\x50\x5f\xff\xdf",
          "\x00\x00\x00\x00\x10\x11\x12\x13\x0d\x8f\xcf\x4e",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xcf\xc3\xdb\x86\x31\xc8\x1c\x69\x02\x3a\x3c\x8a\x9a\xd6\x6c\x35\x05"
          "\x36\x85\x14\x4c\x4f\xa2\xa9\x51\x0a\xdd\x72\xe2\x11\xda\xd9\xca\x5b"
          "\x98\x2e\x4c\x19\x45\x91\xfd\xb7\x41\x16\x28\x03\x11\xd1\x29\x9a\xd8"
          "\x12\x27\x25\x8c\xb5\x2f\x07\x9b\xbc\xb1\x2a\xff\x16\x1d\x27\x8d\xec"
          "\x33\xa3\x26\xd7\x12\x76\xb3\xde\x01\xa8\x32\x7e\xe7\xf4\x5f\x94\x17"
          "\x9d\xff\x18\xa3\xfe\x64\x3e\x56\xc3\x0c\xfd\x03\x87\x1c\x81\x10\xab"
          "\x00\xf6\x61\x2b\x9e\x17\xa4\x64\x73\x60\xd7\x84\x7b\xb6\x3a\x31\x22"
          "\x61\x3c\x2e\x7c\xdd\xdd\x08\xae",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x1a\xe2\xed\x84\xea\x97\x74\xd7\x8d\x78\x2b\xf8\xd9\x72\xa8\xb8", 1,
          512, 1016 },
        { 96, 256, 128, 203,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41"
          "\x57\x71\xfd\xa4\xfb\xcc\x55\xc3\x77\xf7\x32\x03\xe6\x02\x26",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f", 1,
          256, 512 },
        { 96, 256, 128, 204,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xf1\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61"
          "\x5a\xf3\x9e\xdd\xb5\xfc\xd2\x51\x91\x90\xd5\x50\x7d\x3b\x06",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          256, 512 },
        { 96, 256, 128, 205,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xb5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x76"
          "\x4e\x5d\x82\xce\x7d\xa0\xd4\x41\x48\x48\x4f\xd9\x6a\x61\x07",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          256, 512 },
        { 96, 256, 128, 206,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xfd\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b"
          "\xdb\xf1\x6d\x8e\xa4\xd3\x9d\xab\x8d\xcb\x3d\x4b\xc4\xe1\x04",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80\x00\x00\x00\x80", 1,
          256, 512 },
        { 96, 256, 128, 207,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xa9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xac"
          "\xcd\x5e\xb3\x1d\x8f\xc9\x09\xe8\x4b\x0d\xe7\xde\x23\xbb\x08",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f\xff\xff\xff\x7f", 1,
          256, 512 },
        { 96, 256, 128, 208,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xd2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdd"
          "\x4b\x93\x3e\x7b\x1a\x7e\xd9\x3c\xc7\xc0\x50\xdb\x71\xdc\x03",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x01\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00", 1,
          256, 512 },
        { 96, 256, 128, 209,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50"
          "\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa0"
          "\x81\x64\x42\x5d\x76\x42\xe9\xe9\x0f\xc8\xd5\xc3\x2d\x2c\xf6",
          "\xe4\x8c\xaf\x8a\x76\x18\x33\x27\xc9\x56\x1a\x46\x51\xc0\x7c\x82\x2c"
          "\xcd\x16\x42\xc0\x66\x07\xd0\xd4\xbc\x0a\xfb\x4d\xe1\x59\x15\xdb\xfa"
          "\x3b\x0b\x42\x2e\x77\xe1\x5c\x64\xbf\x62\x47\x03\x1f\x15\xfd\xb6\x43"
          "\x11\x78\x09\x82\x18\x70\x00\x0a\xdf\x83\x83\x4d\xa5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          256, 512 },
        { 96, 256, 128, 210,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xc6\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x7b"
          "\xb6\x6f\x80\x90\xc1\x49\xe4\x52\xec\x7f\x20\x32\x7e\xb2\xea\x2e\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x0f\xf9\xbc"
          "\x23\xc8\x97\xdf\x6b\x00\xaf\x86\x93\x1d\x6c\x81\x55\x51\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x03\xf3\xb7\x2d\xeb"
          "\xfb\xa2\x38\x4b\xaa\x48\xce\xed\xfe\xdb\x91",
          "\xe5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x08"
          "\x71\xbc\x8f\x1e\x4a\xa2\x35\x08\x77\x12\xd9\xdf\x18\x36\x09\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xe7\xa3\x30\x09\xef\x5f\xc6\x04\xea\x0f\x9a\x75\xe9\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe7\xa3"
          "\x30\x09\xef\x5f\xc6\x04\xea\x0f\x9a\x75\xe9",
          "\x35\x72\x16\x27\x77\x26\x2c\x51\x8e\xef\x57\x3b\x72\x0e\x8e\x64", 1,
          32, 768 },
        { 96, 256, 128, 211,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xc7\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x76"
          "\x20\x9e\xef\x14\x16\x91\xfb\xa5\xd1\x0e\xaf\x58\x1a\xff\xe6\x2e\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x0e\x73\xd2"
          "\xdc\x3b\xbd\x95\x49\x89\xcb\x84\x33\xb7\xd6\x59\x7b\x51\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x02\x79\xd9\xd2\x18"
          "\xd1\xe8\x1a\xc2\xce\x4a\x6e\x47\x44\x03\xbf",
          "\xe4\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x05"
          "\xe7\x4d\xe0\x9a\x9d\x7a\x2a\xff\x4a\x63\x56\xb5\x7c\x7b\x05\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\x75\x91"
          "\x18\x50\x1a\x43\xcd\xd6\xa2\x06\x4a\xa5\x20\xad\xc7\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\x75\x91\x18\x50"
          "\x1a\x43\xcd\xd6\xa2\x06\x4a\xa5\x20\xad\xc7",
          "\x34\x72\x16\x37\x5f\x5b\x7b\x5c\x4e\x6b\xff\x49\x12\xfd\x94\x73", 1,
          32, 768 },
        { 96, 256, 128, 212,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xfc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x8b"
          "\x79\x40\x3d\xfa\xab\xc0\xd8\xc1\x8d\x23\xa3\x46\x9c\x13\xe6\x2e\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x0a\x4b\x94"
          "\x1e\x6b\x66\xfc\xc2\xed\x7d\x8c\xb3\xe8\xcc\x7f\xfc\x51\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x06\x41\x9f\x10\x48"
          "\x0a\x81\x91\xa6\x78\x42\xee\x18\x5e\x25\x38",
          "\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf8"
          "\xbe\x93\x32\x74\x20\x2b\x09\x9b\x16\x4e\x5a\xab\xfa\x97\x05\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfa\x4d\xd7"
          "\xda\x00\xc1\x2a\x46\xb2\x14\x0e\xca\xfa\x3a\x8b\x40\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfa\x4d\xd7\xda\x00"
          "\xc1\x2a\x46\xb2\x14\x0e\xca\xfa\x3a\x8b\x40",
          "\x30\x72\x16\x77\xff\x2e\xb8\x89\x4e\x5a\x9d\x84\x92\xb7\xb0\xaf", 1,
          32, 768 },
        { 96, 256, 128, 213,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xfa\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x9b"
          "\xcb\xb8\xda\x47\x7d\x58\x0d\x77\x2d\xe4\x22\x9b\xba\x7d\xe2\x29\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x1e\x9d\xed"
          "\xf9\xdd\x64\xa0\x68\x1b\xac\x29\x69\x54\x94\x25\xbc\x56\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x12\x97\xe6\xf7\xfe"
          "\x08\xdd\x3b\x50\xa9\xe7\x34\xa4\x06\x7f\x78",
          "\xd9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8"
          "\x0c\x6b\xd5\xc9\xf6\xb3\xdc\x2d\xb6\x89\xdb\x76\xdc\xf9\x01\xf8\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xee\x9b\xae"
          "\x3d\xb6\xc3\x76\xec\x44\xc5\xab\x10\x46\x62\xd1\x00\xf8\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xee\x9b\xae\x3d\xb6"
          "\xc3\x76\xec\x44\xc5\xab\x10\x46\x62\xd1\x00",
          "\x2b\x72\x16\xc7\x87\x37\x44\xc2\x0e\xc5\xe2\xcd\xb2\x60\xd3\xfa", 1,
          32, 768 },
        { 96, 256, 128, 214,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xee\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xb9"
          "\xf5\x5b\xd5\x6e\x0f\xd7\x4b\x46\x06\x3a\x96\x35\x4c\xfb\xee\x32\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x20\xc7\x88"
          "\x86\xa6\xf6\x29\x2d\x6c\xc5\xfb\xdd\xb5\x46\xa2\xb0\x4d\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x2c\xcd\x83\x88\x85"
          "\x9a\x54\x7e\x27\xc0\x35\x80\x45\xd4\xf8\x74",
          "\xcd\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xca"
          "\x32\x88\xda\xe0\x84\x3c\x9a\x1c\x9d\x57\x6f\xd8\x2a\x7f\x0d\xe3\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd0\xc1\xcb"
          "\x42\xcd\x51\xff\xa9\x33\xac\x79\xa4\xa7\xb0\x56\x0c\xe3\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd0\xc1\xcb\x42\xcd"
          "\x51\xff\xa9\x33\xac\x79\xa4\xa7\xb0\x56\x0c",
          "\x22\x72\x16\x57\xb0\x13\x0d\x28\xcf\x1e\xc6\x51\x53\xc4\x11\x82", 1,
          32, 768 },
        { 96, 256, 128, 215,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xef\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xb4"
          "\x6f\xca\x24\xd3\x53\xff\x5e\x49\xea\xc5\x15\x40\xe8\x40\xea\x30\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x3d\x31\x1e"
          "\x57\x22\x02\x01\x1a\x75\xe9\x48\x58\x6f\xe2\x68\xb4\x4f\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x31\x3b\x15\x59\x01"
          "\x6e\x7c\x49\x3e\xec\x86\x05\x9f\x70\x32\x70",
          "\xcc\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc7"
          "\xa8\x19\x2b\x5d\xd8\x14\x8f\x13\x71\xa8\xec\xad\x8e\xc4\x09\xe1\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcd\x37\x5d"
          "\x93\x49\xa5\xd7\x9e\x2a\x80\xca\x21\x7d\x14\x9c\x08\xe1\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcd\x37\x5d\x93\x49"
          "\xa5\xd7\x9e\x2a\x80\xca\x21\x7d\x14\x9c\x08",
          "\x21\x72\x16\x67\x98\x48\x5c\x33\x8f\x9a\x6d\x60\xf3\xb2\x18\x91", 1,
          32, 768 },
        { 96, 256, 128, 216,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf5\x9d\x56\x15\x1d\xe2\x8b\xef\x83\x50\x5f\x6d\x89\xc0\xb0\xf7\xf7"
          "\x5b\x2f\xa8\xe6\xdc\xe3\x86\x07\x5d\xb2\x83\xec\x85\xee\x62\x55\x5b"
          "\xaf\xfa\xd4\x23\xaf\x25\xf6\x60\x69\xbb\x69\xfb\x6f\x4d",
          "\xd6\xee\x4e\xe2\x5d\x3b\xde\xa8\x1e\x76\xde\x89\x34\xcc\x51\xfb\x84"
          "\x9c\xfc\xa7\x68\x57\x08\x57\x5d\xc6\xdf\x7a\x01\xe3\x6a\x81\x84\x9c"
          "\xfc\xa7\x68\x57\x08\x57\x5d\xc6\xdf\x7a\x01\xe3\x6a\x81",
          "\x83\x13\x12\xcb\xb0\xf1\x65\xdc\x3e\x8f\xf5\x21\x25\xf4\x86\x40", 1,
          32, 384 },
        { 96, 256, 128, 217,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf7\x17\xf8\xd5\xb2\x80\x32\xd5\xc8\xe8\x06\x1c\xd4\x4d\x71\xe4\xf2"
          "\xd5\x5d\xe7\x72\xfe\x7a\x91\xce\x85\xe4\x10\xdb\x3e\x2d\x8d\x50\xd5"
          "\xdd\xb5\x40\x01\x36\x32\x3f\xb8\x3f\x28\x5e\x40\xac\xa2",
          "\xd4\x64\xe0\x22\xf2\x59\x67\x92\x55\xce\x87\xf8\x69\x41\x90\xe8\x81"
          "\x12\x8e\xe8\xfc\x75\x91\x40\x94\x1e\x89\xe9\x36\x58\xa9\x6e\x81\x12"
          "\x8e\xe8\xfc\x75\x91\x40\x94\x1e\x89\xe9\x36\x58\xa9\x6e",
          "\x82\x13\x12\xdb\x98\x26\xb5\xe7\xfe\x0a\x9d\x30\xc5\xe2\x8d\x4f", 1,
          32, 384 },
        { 96, 256, 128, 218,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf2\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xe6"
          "\x8a\x92\x2c\x92\x19\xd3\x0f\x07\x55\x4d\x7d\x99\xf2\xbd\xe9\x2c\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\xe2\x4c\x07"
          "\xdd\x98\xf9\xb2\x53\xab\x0c\x31\x8d\x9b\x14\xf6\xb1\x53\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\xee\x46\x0c\xd3\xbb"
          "\x95\xcf\x00\xe0\x09\xff\xd0\x6b\x86\xac\x75",
          "\xd1\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x95"
          "\x4d\x41\x23\x1c\x92\x38\xde\x5d\xce\x20\x84\x74\x94\x39\x0a\xfd\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x4a\x44"
          "\x19\xf3\x5e\x64\xd7\xf4\x65\xb3\xf4\x89\xe2\x02\x0d\xfd\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x4a\x44\x19\xf3"
          "\x5e\x64\xd7\xf4\x65\xb3\xf4\x89\xe2\x02\x0d",
          "\xc1\x04\x57\x69\xd4\x87\xd5\x45\xce\xf3\xf0\xd3\x4b\x7a\x87\x33", 1,
          32, 768 },
        { 96, 256, 128, 219,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x2e"
          "\x67\x84\xd8\x57\xdf\x07\x54\x3d\x0d\xc7\x2f\x17\x99\x35\xfb\xed\xe8"
          "\xc8\xba\xf0\x1e\xe2\x04\x4b\x16\x2c\xbb\x34\x3b\x35\x5a\xcc\x29\xd8"
          "\x23\x27\xcd\x93\xf2\xbf\xd9\x18\x03\x4e\xd5\xc4\x2a",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5d"
          "\xa0\x57\xd7\xd9\x54\xec\x85\x67\x96\xaa\xd6\xfa\xff\xb1\x18\x3c\x2f"
          "\x9b\xe7\x4c\x6a\x45\x76\xe0\xb0\x9a\x7a\x5c\x23\x30\x96\x3c\x2f\x9b"
          "\xe7\x4c\x6a\x45\x76\xe0\xb0\x9a\x7a\x5c\x23\x30\x96",
          "\x64\xe7\xef\xd2\x45\x16\xa8\x3e\x2c\x87\xe0\x6a\x76\xe2\xde\xa3", 1,
          32, 512 },
        { 96, 256, 128, 220,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf7\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x4c"
          "\x6e\xad\x26\xf8\x4a\x02\x25\xd5\x57\x74\x5d\x32\xfc\x72\xe7\x2c\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x64\xdb\x33"
          "\x4b\x69\xbe\xe5\x79\x38\x3e\x61\xae\x74\x2c\x71\xbb\x53\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x68\xd1\x38\x45\x4a"
          "\xd2\x98\x2a\x73\x3b\xaf\xf3\x84\xbe\x2b\x7f",
          "\xd4\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f"
          "\xa9\x7e\x29\x76\xc1\xe9\xf4\x8f\xcc\x19\xa4\xdf\x9a\xf6\x04\xfd\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x94\xdd\x70"
          "\x8f\x02\x19\x33\xfd\x67\x57\xe3\xd7\x66\xda\x85\x07\xfd\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x94\xdd\x70\x8f\x02"
          "\x19\x33\xfd\x67\x57\xe3\xd7\x66\xda\x85\x07",
          "\xe6\xcc\x67\x29\xd7\x9b\xa5\x58\xcd\x73\xb0\x3c\xba\x54\xd6\x60", 1,
          32, 768 },
        { 96, 256, 128, 221,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf0\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x4f"
          "\xd8\xc3\x75\x7c\x9f\x29\x38\xdc\x3b\x07\xd8\x58\x98\xbf\xe2\x2a\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x61\x55\x41"
          "\x24\x15\xcb\xdd\x76\x01\x42\xb6\x2c\x2e\xc8\x3f\xbf\x55\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x6d\x5f\x4a\x2a\x36"
          "\xa7\xa0\x25\x4a\x47\x78\x71\xde\x5a\x65\x7b",
          "\xd3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3c"
          "\x1f\x10\x7a\xf2\x14\xc2\xe9\x86\xa0\x6a\x21\xb5\xfe\x3b\x01\xfb\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x91\x53\x02"
          "\xe0\x7e\x6c\x0b\xf2\x5e\x2b\x34\x55\x3c\x3e\xcb\x03\xfb\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x91\x53\x02\xe0\x7e"
          "\x6c\x0b\xf2\x5e\x2b\x34\x55\x3c\x3e\xcb\x03",
          "\xe5\xcc\x67\x39\xbf\xd0\xf4\x63\x8d\xef\x57\x4b\x5a\x43\xdd\x6f", 1,
          32, 768 },
        { 96, 256, 128, 222,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf2\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xdf"
          "\x03\xca\x84\x08\x2f\x7f\x70\xad\x8e\x40\x04\xca\xbd\x2c\xe4\x2b\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x28\xfd\x41"
          "\x3c\xaa\xb1\xd0\x2b\xf1\xc6\x57\x53\xaa\x2a\xd3\xb9\x54\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x24\xf7\x4a\x32\x89"
          "\xdd\xad\x78\xba\xc3\x99\x0e\x5a\xb8\x89\x7d",
          "\xd1\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xac"
          "\xc4\x19\x8b\x86\xa4\x94\xa1\xf7\x15\x2d\xfd\x27\xdb\xa8\x07\xfa\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\xfb\x02"
          "\xf8\xc1\x16\x06\xaf\xae\xaf\xd5\x2a\xb8\xdc\x27\x05\xfa\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\xfb\x02\xf8\xc1"
          "\x16\x06\xaf\xae\xaf\xd5\x2a\xb8\xdc\x27\x05",
          "\x0f\xca\x70\x22\x28\x81\x7d\x53\xee\x64\xd1\x42\xb1\x92\xe6\x65", 1,
          32, 768 },
        { 96, 256, 128, 223,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf3\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x1f"
          "\xfc\x31\xae\x69\x39\x93\x94\xb8\xc3\x38\x67\x4c\x3d\xfd\xe9\x29\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x47\x7e\xc8"
          "\xcf\x3e\xa3\xd4\xd5\xd7\x6d\x85\xad\x2b\x7f\x0b\xb8\x56\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x4b\x74\xc3\xc1\x1d"
          "\xcf\xa9\x86\x9c\x68\x4b\xf0\xdb\xed\x51\x7c",
          "\xd0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c"
          "\x3b\xe2\xa1\xe7\xb2\x78\x45\xe2\x58\x55\x9e\xa1\x5b\x79\x0a\xf8\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb7\x78\x8b"
          "\x0b\x55\x04\x02\x51\x88\x04\x07\xd4\x39\x89\xff\x04\xf8\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb7\x78\x8b\x0b\x55"
          "\x04\x02\x51\x88\x04\x07\xd4\x39\x89\xff\x04",
          "\xef\xc3\xb0\x35\xde\xd6\xb4\x60\xbf\xce\x6f\x49\x49\x55\xe6\x77", 1,
          32, 768 },
        { 96, 256, 128, 224,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\x2b\xfd\x0d\x56\xec\xe9\x87\x71\x75\x6d\x60\xd9\xd9\x10\x6c\xd0\xc6"
          "\xfc\x10\x69\x36\xc7\xef\x34\x7c\x07\x8f\xd7\x1c\x54\x22\x81\x64\xfc"
          "\x90\x3b\x04\x38\xa3\x97\x8d\x3a\x54\xef\x99\x2a\xa3\xae",
          "\x08\x8e\x15\xa1\xac\x30\xd2\x36\xe8\x4b\xe1\x3d\x64\x1c\x8d\xdc\xb5"
          "\x3b\xc3\x66\xb8\x4c\x04\xe5\x26\x9c\xe2\x2e\xf1\x32\xa6\x62\xb5\x3b"
          "\xc3\x66\xb8\x4c\x04\xe5\x26\x9c\xe2\x2e\xf1\x32\xa6\x62",
          "\x34\x5f\xc9\xfe\x57\x3c\x13\x6c\x1b\xe8\x37\x30\x50\x0c\xe6\x62", 1,
          32, 384 },
        { 96, 256, 128, 225,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf6\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x7c"
          "\xc2\x25\x5d\xec\xdf\x8e\x0f\xe1\x37\x35\x91\xda\x0e\x28\xe4\x28\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\xe2\x91\xfb"
          "\x48\x38\x01\x9c\x51\xdf\xb7\x14\x15\x15\xbb\x53\xb1\x57\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\xee\x9b\xf0\x46\x1b"
          "\x6d\xe1\x02\x94\xb2\xda\x48\xe5\x29\x09\x75",
          "\xd5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f"
          "\x05\xf6\x52\x62\x54\x65\xde\xbb\xac\x58\x68\x37\x68\xac\x07\xf9\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x97\xb8"
          "\x8c\x53\xa6\x4a\xd5\x80\xde\x96\x6c\x07\x4d\xa7\x0d\xf9\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x97\xb8\x8c\x53"
          "\xa6\x4a\xd5\x80\xde\x96\x6c\x07\x4d\xa7\x0d",
          "\x33\x6f\x97\xa5\xfa\xa9\x95\xa2\xa0\x37\x81\xb5\x91\x58\x8d\xa8", 1,
          32, 768 },
        { 96, 256, 128, 226,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xc6\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x7a"
          "\xb6\x6f\x80\x90\xc1\x49\xe4\x52\xec\x7f\x20\x32\x7e\xb2\xea\x04\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x8d\x26\x13"
          "\xea\x0e\xf8\xb6\x56\xb2\x47\x37\x3e\xce\xc0\x15\xbc\x7b\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x81\x2c\x18\xe4\x2d"
          "\x94\xcb\x05\xf9\x42\xf9\x63\x3e\x52\x4f\x78",
          "\xe5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09"
          "\x71\xbc\x8f\x1e\x4a\xa2\x35\x08\x77\x12\xd9\xdf\x18\x36\x09\xd5\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7d\x20\x50"
          "\x2e\x65\x5f\x60\xd2\xed\x2e\xb5\x47\xdc\x36\xe1\x00\xd5\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7d\x20\x50\x2e\x65"
          "\x5f\x60\xd2\xed\x2e\xb5\x47\xdc\x36\xe1\x00",
          "\x93\x51\xc6\x80\xc8\xa5\xd3\x48\x82\xd4\x21\x45\xe8\x97\x45\xc4", 1,
          32, 768 },
        { 96, 256, 128, 227,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xc6\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x74"
          "\xb6\x6f\x80\x90\xc1\x49\xe4\x52\xec\x7f\x20\x32\x7e\xb2\xea\x2e\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\xac\xd9\xec"
          "\x85\x9e\x08\x66\x62\x0c\xc2\x4c\x8a\x97\xd5\xd9\xf5\x51\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\xa0\xd3\xe7\x8b\xbd"
          "\x64\x1b\x31\x47\xc7\x82\xd7\x67\x47\x83\x31",
          "\xe5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x07"
          "\x71\xbc\x8f\x1e\x4a\xa2\x35\x08\x77\x12\xd9\xdf\x18\x36\x09\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\xdf\xaf"
          "\x41\xf5\xaf\xb0\xe6\x53\xab\xce\xf3\x85\x23\x2d\x49\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\xdf\xaf\x41\xf5"
          "\xaf\xb0\xe6\x53\xab\xce\xf3\x85\x23\x2d\x49",
          "\xd7\x92\x66\xcd\x25\xa7\x84\x59\x9a\x0a\x8e\x31\xfc\x84\xd6\x04", 1,
          32, 768 },
        { 96, 256, 128, 228,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf7\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x42"
          "\x51\xcd\x29\xb0\xaa\xa9\x60\x55\x7c\x9e\xa2\x82\x83\x34\xe4\xe4\xe2"
          "\x31\xdb\x0a\x27\xfa\xc9\xec\x9e\x74\x48\x86\xeb\x01\x33\xc5\x23\x21"
          "\x42\xdd\xf4\x8b\x3f\x18\x51\x40\xf0\xfc\x05\xf0\x43",
          "\xd4\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31"
          "\x96\x1e\x26\x3e\x21\x42\xb1\x0f\xe7\xf3\x5b\x6f\xe5\xb0\x07\x35\x25"
          "\x62\x86\xb6\x53\x5d\xbb\x47\x38\xc2\x89\xee\xf3\x04\xff\x35\x25\x62"
          "\x86\xb6\x53\x5d\xbb\x47\x38\xc2\x89\xee\xf3\x04\xff",
          "\x9d\x67\x1d\x40\x7d\x76\x60\x45\x9d\x5d\x58\x2d\x83\x91\x5e\xfe", 1,
          32, 512 },
        { 96, 256, 128, 229,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xf5\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x73"
          "\xbd\x9f\x01\xbf\x33\x31\xb1\x2e\x31\xdd\x14\xcf\x11\xfe\xee\x1d\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x62\x5c\x69"
          "\x65\xf6\x1a\x1c\x36\x11\x8c\x74\x70\x76\xd5\xb7\xb7\x62\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x6e\x56\x62\x6b\xd5"
          "\x76\x61\x65\x5a\x89\xba\x2d\x86\x47\xed\x73",
          "\xd6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00"
          "\x7a\x4c\x0e\x31\xb8\xda\x60\x74\xaa\xb0\xed\x22\x77\x7a\x0d\xcc\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x92\x5a\x2a"
          "\xa1\x9d\xbd\xca\xb2\x4e\xe5\xf6\x09\x64\x23\x43\x0b\xcc\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x92\x5a\x2a\xa1\x9d"
          "\xbd\xca\xb2\x4e\xe5\xf6\x09\x64\x23\x43\x0b",
          "\x7b\x20\x7c\x2c\x32\x78\xc6\x4f\x0d\x6b\x91\x3f\xe3\x71\xfe\x63", 1,
          32, 768 },
        { 96, 256, 128, 230,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xec"
          "\x09\x33\xf0\xbf\xb9\x12\x18\xce\xa0\xd7\x4e\x06\x1f\x55\x9e\x2d\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x8d\x5b\x67"
          "\xe0\xac\xee\x53\x4c\xe2\xd9\x79\x14\x87\xb1\xec\xb2\x52\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x81\x51\x6c\xee\x8f"
          "\x82\x2e\x1f\xa9\xdc\xb7\x49\x77\x23\xb6\x76",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9f"
          "\xce\xe0\xff\x31\x32\xf9\xc9\x94\x3b\xba\xb7\xeb\x79\xd1\x7d\xfc\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7d\x5d\x24"
          "\x24\xc7\x49\x85\xc8\xbd\xb0\xfb\x6d\x95\x47\x18\x0e\xfc\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7d\x5d\x24\x24\xc7"
          "\x49\x85\xc8\xbd\xb0\xfb\x6d\x95\x47\x18\x0e",
          "\x36\x72\x16\x2b\xb1\xf3\xff\x53\x7e\xce\x01\x3f\x1a\xca\x4f\x68", 1,
          32, 768 },
        { 96, 256, 128, 231,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xee"
          "\x83\xa1\x4f\x48\xdb\x69\x62\x91\x08\x0e\xdf\xcc\x89\x8b\x88\x2b\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x8a\xd5\xf6"
          "\xb0\x28\x3a\x8b\x39\xeb\xed\xce\x92\x78\x5d\xa9\xb6\x54\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x86\xdf\xfd\xbe\x0b"
          "\x56\xf6\x6a\xa0\xe8\x00\xcf\x88\xcf\xf3\x72",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9d"
          "\x44\x72\x40\xc6\x50\x82\xb3\xcb\x93\x63\x26\x21\xef\x0f\x6b\xfa\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\xd3\xb5"
          "\x74\x43\x9d\x5d\xbd\xb4\x84\x4c\xeb\x6a\xab\x5d\x0a\xfa\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\xd3\xb5\x74\x43"
          "\x9d\x5d\xbd\xb4\x84\x4c\xeb\x6a\xab\x5d\x0a",
          "\x35\x72\x16\x3b\x99\x28\x4f\x5f\x3e\x4a\xa9\x4d\xba\xb8\x56\x77", 1,
          32, 768 },
        { 96, 256, 128, 232,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xe8"
          "\x7d\xd0\x8e\xd4\xe4\xe0\x4c\x58\x77\x61\x6c\xbb\x02\xca\xbb\x29\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x87\x4f\x04"
          "\x01\xd4\x57\xe3\x36\xf4\x31\x1f\x11\x52\xf9\x57\xba\x56\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x8b\x45\x0f\x0f\xf7"
          "\x3b\x9e\x65\xbf\x34\xd1\x4c\xa2\x6b\x0d\x7e",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9b"
          "\xba\x03\x81\x5a\x6f\x0b\x9d\x02\xec\x0c\x95\x56\x64\x4e\x58\xf8\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x77\x49\x47"
          "\xc5\xbf\xf0\x35\xb2\xab\x58\x9d\x68\x40\x0f\xa3\x06\xf8\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x77\x49\x47\xc5\xbf"
          "\xf0\x35\xb2\xab\x58\x9d\x68\x40\x0f\xa3\x06",
          "\x34\x72\x16\x4b\x81\x5d\x9e\x6a\xfe\xc5\x50\x5c\x5a\xa7\x5d\x86", 1,
          32, 768 },
        { 96, 256, 128, 233,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xc8\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x6b"
          "\xe4\x36\xe3\x46\xf8\xf2\xb3\x2f\x4c\xbb\xae\xf9\x51\x50\xef\x04\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x2f\xb7\x6b"
          "\x51\x32\xe9\x30\xf6\xd0\xac\xf7\x08\x75\xe9\x77\xb5\x7b\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x23\xbd\x60\x5f\x11"
          "\x85\x4d\xa5\x9b\xa9\x39\x55\x85\x7b\x2d\x71",
          "\xeb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18"
          "\x23\xe5\xec\xc8\x73\x19\x62\x75\xd7\xd6\x57\x14\x37\xd4\x0c\xd5\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\xb1\x28"
          "\x95\x59\x4e\xe6\x72\x8f\xc5\x75\x71\x67\x1f\x83\x09\xd5\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\xb1\x28\x95\x59"
          "\x4e\xe6\x72\x8f\xc5\x75\x71\x67\x1f\x83\x09",
          "\x3a\x72\x16\xd7\xee\x1d\xa0\x18\xce\x84\x12\xf2\x51\x65\x6b\x19", 1,
          32, 768 },
        { 96, 256, 128, 234,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xc5\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x78"
          "\x3c\xf9\x30\x2c\x7d\x22\x91\x4b\x38\xac\xa2\xe7\xd3\x74\xef\x1d\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x22\x8f\x2d"
          "\x23\x59\x76\x40\xd5\x74\xf8\xe2\x0c\x4f\x6b\x6b\xb5\x62\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x2e\x85\x26\x2d\x7a"
          "\x1a\x3d\x86\x3f\xfd\x2c\x51\xbf\xf9\x31\x71",
          "\xe6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b"
          "\xfb\x2a\x3f\xa2\xf6\xc9\x40\x11\xa3\xc1\x5b\x0a\xb5\xf0\x0c\xcc\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x89\x6e"
          "\xe7\x32\xd1\x96\x51\x2b\x91\x60\x75\x5d\x9d\x9f\x09\xcc\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x89\x6e\xe7\x32"
          "\xd1\x96\x51\x2b\x91\x60\x75\x5d\x9d\x9f\x09",
          "\x36\x72\x16\x17\x8f\xf1\xdc\x45\xce\x73\xb0\x2c\xd2\x1f\x87\x55", 1,
          32, 768 },
        { 96, 256, 128, 235,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x5d"
          "\xb7\x2f\x89\xd1\x40\x2b\x1a\x03\x73\xff\x0a\x9c\x5c\xd4\x4b\x6d\x67"
          "\xaf\x40\x79\x8f\x54\x55\x50\x17\x92\x95\x32\x48\xec\x23\x4c\xa6\xbf"
          "\xd9\xae\x5c\x25\xa3\xa4\xd8\xa6\x2d\x48\xa6\x1d\x53",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e"
          "\x70\xfc\x86\x5f\xcb\xc0\xcb\x59\xe8\x92\xf3\x71\x3a\x50\xa8\xbc\xa0"
          "\xfc\x1d\xc5\xfb\xf3\x27\xfb\xb1\x24\x54\x5a\x50\xe9\xef\xbc\xa0\xfc"
          "\x1d\xc5\xfb\xf3\x27\xfb\xb1\x24\x54\x5a\x50\xe9\xef",
          "\x0b\x49\x61\xc9\x52\x5e\xa2\xf2\xcd\xad\x62\x73\xe1\xc7\x82\x4c", 1,
          32, 512 },
        { 96, 256, 128, 236,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\x5f"
          "\x21\x5e\xc8\x7d\x62\xa2\x64\xca\xdb\x51\x9b\x4a\xc9\x0a\x76\x68\xd1"
          "\xdd\x03\xe5\x6e\xda\x63\x99\xac\x78\x03\xe7\xdd\x22\x11\x49\x10\xcd"
          "\x9a\x32\xbd\xab\x95\x6d\x63\x4c\xbb\x9d\x33\xd3\x61",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2c"
          "\xe6\x8d\xc7\xf3\xe9\x49\xb5\x90\x40\x3c\x62\xa7\xaf\x8e\x95\xb9\x16"
          "\x8e\x5e\x59\x1a\x7d\x11\x32\x0a\xce\xc2\x8f\xc5\x27\xdd\xb9\x16\x8e"
          "\x5e\x59\x1a\x7d\x11\x32\x0a\xce\xc2\x8f\xc5\x27\xdd",
          "\x0a\x49\x61\xd9\x3a\x93\xf1\xfd\x8d\x29\x0a\x82\x81\xb6\x89\x5b", 1,
          32, 512 },
        { 96, 256, 128, 237,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x10\xab\xb1\x65",
          "\xff\xff\xff\xff",
          "\xdc\x8c\xe7\x08\xbf\x26\xaa\xb8\x62\xd9\x7e\x1b\x42\xf3\x1e\xf3\xd1"
          "\x5a\xd5\x90\xdd\x0f\x40\xba\x18\xac\xd1\x68\xf6\xac\x77\x7a\x0f\x38"
          "\xac\xa2\x43\x8b\x58\x8d\x54\x59\x49\x3e\x97\xe7\xfa\x33\x93\x2a\x09"
          "\x7f\x1d\x39\xa0\x4a\xd3\x0f\x1b\x6c\x65\x02\x60\xbf\x70\x03\x47\x8f"
          "\x28\x69\xb9\x3e\xe2\x9c\x83\x7e\x95\xfb\x6b\x99\x9f\x20\x02\x71\x3e"
          "\x55\xdd\x19\x98\x0a\xd5\x31\x95\x90\x3a\x7b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2"
          "\x9d\x06\x9f\x53\x84\xab\x6b\x42\x37\xbc\x91\x1b\xca\xf3\x99\xde\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x63\x2c\x4a"
          "\xbb\x76\x9e\x76\xce\x8c\x66\x99\x15\x77\xf4\x94\x03\xde\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x63\x2c\x4a\xbb\x76"
          "\x9e\x76\xce\x8c\x66\x99\x15\x77\xf4\x94\x03",
          "\x35\x72\x16\x13\x55\x24\x09\x43\xde\x94\x06\x29\x2a\x64\xc5\x51", 1,
          32, 768 },
        { 96, 256, 128, 238,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x40\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x39"
          "\x0e\xf9\x3a\xeb\x61\xaa\x30\x7f\x14\x13\x23\xc3\x8e\x06\x85\xfa\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x25\x94\x45"
          "\xf4\xff\xc3\x1b\xce\x54\x01\x90\xed\xd6\xad\x20\x78\x76\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xed\xa1\xa5\xb6\x13"
          "\x97\x50\xf9\x73\xf0\xd4\x84\x1b\xaa\x2c\xb8",
          "\xd9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa0"
          "\x09\xd7\x3c\x65\x44\x42\x8c\xfa\xc0\xb2\xd8\xc7\xbb\xef\x0b\xed\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x5e\xf6"
          "\x07\x15\xbc\x4b\x07\xc9\x2b\x97\x07\x37\x6d\xa1\x05\xed\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x5e\xf6\x07\x15"
          "\xbc\x4b\x07\xc9\x2b\x97\x07\x37\x6d\xa1\x05",
          "\x19\x53\x2d\x9f\xa0\xb5\xfb\xd5\x82\xaa\xed\xa8\x30\x60\x2f\x1d", 1,
          32, 768 },
        { 96, 256, 128, 239,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x49\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\xe0"
          "\x2b\x87\xae\xae\x8c\x3d\xa8\x89\x5f\x8c\xb0\xf6\xb9\xcc\x80\xf4\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\xcc\x4b\x7b"
          "\x80\x3a\x5f\x8f\x46\x47\xdf\x16\x90\x80\xfe\x56\x7a\x78\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\x04\x7e\x9b\xc2\xd6"
          "\x0b\xc4\x71\x60\x2e\x52\xf9\x4d\xf9\x5a\xba",
          "\xd0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79"
          "\x2c\xa9\xa8\x20\xa9\xd5\x14\x0c\x8b\x2d\x4b\xf2\x8c\x25\x0e\xe3\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x63\x81\xc8"
          "\x73\xd0\x20\xdf\x8f\xda\xf5\x11\x7a\x61\x3e\xd7\x07\xe3\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x63\x81\xc8\x73\xd0"
          "\x20\xdf\x8f\xda\xf5\x11\x7a\x61\x3e\xd7\x07",
          "\xad\xbd\x2c\xaf\xc8\xc8\xf0\xe5\x12\x50\xe7\xb8\x1c\x9d\x0a\x2d", 1,
          32, 768 },
        { 96, 256, 128, 240,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x43\xea\xda\xe0\x36\xf7\x33\xea\x9b\x5b\x7e\xb2\x2a\xee\x39\x5d\xb6"
          "\xf5\x1a\x4d\x10\xbc\x24\x60\x81\x0c\x22\x96\x51\x55\x6a\xcf\x38\x4a"
          "\xd8\x2e\x3e\x28\x0c\xad\x69\xf0\xdf\x25\xb4\x2b\x83\xb0",
          "\xda\x04\x7b\x78\x25\xdb\x18\x02\xe8\xe8\xe1\xaa\xc6\xba\x88\xfc\x2f"
          "\xf2\x34\x4b\x9e\x99\xcc\xdc\x04\xd8\x83\x6d\x55\x60\x83\x41\x2f\xf2"
          "\x34\x4b\x9e\x99\xcc\xdc\x04\xd8\x83\x6d\x55\x60\x83\x41",
          "\x97\x3e\x27\x0a\x7a\xfc\xab\x75\x34\x8e\x14\xdb\xe1\x9c\x51\x56", 1,
          32, 384 },
        { 96, 256, 128, 241,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x66\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x89"
          "\x1b\x79\x75\x21\xba\x92\x5b\x24\x09\x0a\xaf\x6c\x44\x82\xba\xe8\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x6d\x50\xc3"
          "\x2d\x05\xa9\x46\xcb\x8c\xea\x57\xc9\xf1\x44\x2c\xb1\x64\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xa5\x65\x23\x6f\xe9"
          "\xfd\x0d\xfc\xab\x1b\x13\xa0\x3c\x43\x20\x71",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x10"
          "\x1c\x57\x73\xaf\x9f\x7a\xe7\xa1\xdd\xab\x54\x68\x71\x6b\x34\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x9a\x70"
          "\xde\xef\xd6\x16\x02\x11\xc0\x50\x23\x10\x84\xad\xcc\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc2\x9a\x70\xde\xef"
          "\xd6\x16\x02\x11\xc0\x50\x23\x10\x84\xad\xcc",
          "\xe1\x7c\x27\x3f\x31\x75\x8e\x75\x23\x22\xae\x48\x69\xc1\xbf\xbb", 1,
          32, 768 },
        { 96, 256, 128, 242,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x6a\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x51"
          "\x9c\xcc\xeb\xf7\x25\x73\xdb\xee\x8c\x12\xf7\x42\x55\xd1\x8c\x0a\xdd"
          "\x10\x35\x86\x1f\xfc\x0b\x7f\x40\x07\x9b\x96\x9f\x8c\x63\xb2\xaf\x4f"
          "\xa3\xcc\xd1\x6c\xb3\x8f\x42\x5c\x39\x96\x14\x0d\xef",
          "\xf3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc8"
          "\x9b\xe2\xed\x79\x00\x9b\x67\x6b\x58\xb3\x0c\x46\x60\x38\x02\x1d\x65"
          "\xfc\x50\x26\xae\x3c\x7a\x12\x68\x5b\xd3\x77\xd4\x8c\x92\x1d\x65\xfc"
          "\x50\x26\xae\x3c\x7a\x12\x68\x5b\xd3\x77\xd4\x8c\x92",
          "\xa2\x23\x90\x22\x4c\x5d\xb0\xf0\x16\x96\x74\x3d\x87\x07\x25\xc5", 1,
          32, 512 },
        { 96, 256, 128, 243,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\xe2\x35\xb8\xc2\x13\x84\x55\x70\x85\xc3\xf2\xeb\x2a\x8f\xa3\x60\x58"
          "\xcf\xfd\x2a\xf7\x43\xda\xcf\x96\xb4\xae\x4d\x51\xb4\xe4\x88\xd6\x70"
          "\x3f\x49\xd9\xd7\xf2\x02\x7e\x48\x53\xfe\xb4\xca\x0d\xf7",
          "\x7b\xdb\x19\x5a\x00\xa8\x7e\x98\xf6\x70\x6d\xf3\xc6\xdb\x12\xc1\xc1"
          "\xc8\xd3\x2c\x79\x66\x32\x73\x13\x60\x0f\xb6\x55\x81\x0d\x06\xc1\xc8"
          "\xd3\x2c\x79\x66\x32\x73\x13\x60\x0f\xb6\x55\x81\x0d\x06",
          "\x43\x7d\x1e\xfa\xd2\x1b\x08\x65\xa5\x41\xb5\xca\xb6\x2e\x2a\x44", 1,
          32, 384 },
        { 96, 256, 128, 244,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x66\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x8f"
          "\xab\x58\x57\x4a\x32\x2b\xac\x6f\x39\x44\x74\xe4\xce\x7e\xae\xc3\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x71\x53\x2d"
          "\xfb\x0e\x91\x41\xb0\x09\x83\x39\x47\x22\x82\x9e\x7c\x4f\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xb9\x66\xcd\xb9\xe2"
          "\xc5\x0a\x87\x2e\x72\x7d\x2e\xef\x85\x92\xbc",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16"
          "\xac\x76\x51\xc4\x17\xc3\x10\xea\xed\xe5\x8f\xe0\xfb\x97\x20\xd4\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xde\x99\x9e"
          "\x08\xe4\xee\x11\x79\x94\xa9\x3e\xad\xc3\x42\x1f\x01\xd4\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xde\x99\x9e\x08\xe4"
          "\xee\x11\x79\x94\xa9\x3e\xad\xc3\x42\x1f\x01",
          "\xac\xf4\xff\xa2\x0c\x0d\x06\xd6\x1a\x18\xe9\xa8\xd4\xc8\x4d\x1d", 1,
          32, 768 },
        { 96, 256, 128, 245,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x61\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x5e"
          "\xfe\x67\x9b\xa1\x73\x84\xc5\x5e\xb8\xcc\x19\x36\x66\xfe\x8d\x04\x60"
          "\x8c\x35\x03\xd2\x17\xaa\x3f\x90\xa9\xb0\xe1\xb3\xb3\x13\xbc\x12\xd3"
          "\xa3\x49\x1c\x87\x12\xcf\x92\xf2\x12\xe1\x38\x32\x9f",
          "\xf8\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc7"
          "\xf9\x49\x9d\x2f\x56\x6c\x79\xdb\x6c\x6d\xe2\x32\x53\x17\x03\x13\xd8"
          "\x60\x50\xa3\x63\xd7\xdb\x52\xb8\xf5\xf8\x00\xf8\xb3\xe2\x13\xd8\x60"
          "\x50\xa3\x63\xd7\xdb\x52\xb8\xf5\xf8\x00\xf8\xb3\xe2",
          "\xcd\x46\x6d\x06\xe7\x5b\x7f\xd1\x8d\x5f\xe2\x1d\x92\x27\xd9\xa7", 1,
          32, 512 },
        { 96, 256, 128, 246,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x90\x64\xb8\x8a\x28\x20\x52\xa1\xee\x44\xdf\x05\xad\x21\x3d\xa6\x79"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\x51\xb2"
          "\x65\x0e\xc9\x45\xfe\xc7\x05\x88\xbc\x65\xa6\x16\xa5\xf2\x4f\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\xdd\x55\x7e\xc8"
          "\xa4\xd6\x3d\xf7\x27\x45\x94\x36\x7b\xef\x09\xcd",
          "\x09\x8a\x19\x12\x3b\x0c\x79\x49\x9d\xf7\x40\x1d\x41\x75\x8c\x07\xe0"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x0a"
          "\x89\x6b\x69\xf4\x3e\xb6\x68\xa0\xe0\x2d\x47\x5d\xa5\x03\xe0\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x0a\x89\x6b"
          "\x69\xf4\x3e\xb6\x68\xa0\xe0\x2d\x47\x5d\xa5\x03",
          "\xce\x8a\x3d\x4d\x88\x7d\x95\x61\x3d\x82\x9b\x53\x8e\xd0\x11\x96", 1,
          32, 640 },
        { 96, 256, 128, 247,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x43\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\xee"
          "\xf6\x7b\xd4\x79\x5b\x74\x01\x5a\x34\x93\x90\x5d\x54\x4a\x86\xe8\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x31\x97\xbe"
          "\x28\xef\xf8\x43\x59\x2b\xd8\xfc\x8d\x57\x84\x21\xd6\x64\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xf9\xa2\x5e\x6a\x03"
          "\xac\x08\x6e\x0c\x29\xb8\xe4\x9a\x83\x2d\x16",
          "\xda\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x77"
          "\xf1\x55\xd2\xf7\x7e\x9c\xbd\xdf\xe0\x32\x6b\x59\x61\xa3\x08\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9e\x5d\x0d"
          "\xdb\x05\x87\x13\x90\xb6\xf2\xfb\x67\xb6\x44\xa0\xab\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9e\x5d\x0d\xdb\x05"
          "\x87\x13\x90\xb6\xf2\xfb\x67\xb6\x44\xa0\xab",
          "\x08\x28\x9f\x51\x99\xdf\x47\x6f\xe9\x04\x75\xcb\x95\x22\x55\x66", 1,
          32, 768 },
        { 96, 256, 128, 248,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x6b\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x1e"
          "\x34\x41\x2a\xb0\xa0\x56\xe8\x09\xd5\xd4\xb9\x2b\xe1\x12\x8a\x4b\x2a"
          "\x65\x1a\x62\xae\xab\x26\xcf\x43\x7f\xb1\x95\x40\x75\x74\xf3\x58\x3a"
          "\x8c\x28\x60\x3b\x9e\x3f\x41\x24\x13\x95\xcb\xf4\xf8",
          "\xf2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87"
          "\x33\x6f\x2c\x3e\x85\xbe\x54\x8c\x01\x75\x42\x2f\xd4\xfb\x04\x5c\x92"
          "\x89\x7f\xc2\x1f\x6b\x57\xa2\x6b\x23\xf9\x74\x0b\x75\x85\x5c\x92\x89"
          "\x7f\xc2\x1f\x6b\x57\xa2\x6b\x23\xf9\x74\x0b\x75\x85",
          "\x06\xdf\x93\xf6\x51\xea\x5c\xc5\x69\x11\xf3\x0d\x3e\x58\xf9\x97", 1,
          32, 512 },
        { 96, 256, 128, 249,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x3f\xe6\x06\x10\x8f\x35\x86\x9d\xf4\xc7\xaa\x01\x28\x46\x4a\x12\x65"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xfd\xbe"
          "\x84\x3a\x0a\xd9\xbe\x25\x05\x59\x92\xab\x6d\xcb\xc9\xf1\x53\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x71\x59\x9f\xfc"
          "\x67\x4a\x7d\x15\x27\x94\xba\xf8\xb0\x32\x65\xce",
          "\xa6\x08\xa7\x88\x9c\x19\xad\x75\x87\x74\x35\x19\xc4\x12\xfb\xb3\xfc"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x06"
          "\x68\x5f\xaa\x68\x7e\x54\x68\x71\xce\xe3\x8c\x80\xc9\x00\xfc\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x06\x68\x5f"
          "\xaa\x68\x7e\x54\x68\x71\xce\xe3\x8c\x80\xc9\x00",
          "\x92\x64\xfc\x0f\x47\xfe\xbb\x30\x66\x12\x54\xda\xf9\xa0\x61\x89", 1,
          32, 640 },
        { 96, 256, 128, 250,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x6e\x8e\xb9\x8c\xf7\xff\xfe\x4c\xd6\x83\x56\x8c\xf8\x92\x99\x15\x64"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xc7\x0f"
          "\x5d\x8b\x30\xc6\x4b\xf2\xe6\xd1\xd6\x13\xf4\x0e\x0b\xf0\x52\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x4b\xe8\x46\x4d"
          "\x5d\x55\x88\xc2\xc4\x1c\xfe\x40\x29\xf7\xa7\xcf",
          "\xf7\x60\x18\x14\xe4\xd3\xd5\xa4\xa5\x30\xc9\x94\x14\xc6\x28\xb4\xfd"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd0\xb7"
          "\xb1\xee\x90\x77\x8b\x83\x8b\xf9\x8a\x5b\x15\x45\x0b\x01\xfd\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd0\xb7\xb1\xee"
          "\x90\x77\x8b\x83\x8b\xf9\x8a\x5b\x15\x45\x0b\x01",
          "\x69\xa1\x24\xfc\x7f\x96\xe2\x20\xd1\xa0\x31\xce\xd5\x52\x72\x79", 1,
          32, 640 },
        { 96, 256, 128, 251,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x4f\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x41"
          "\x56\x26\x9f\xe3\xda\x10\x1e\xeb\x0a\xbf\x8d\xda\x20\xfe\x8f\xff\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x6a\xec\xe9"
          "\x83\xe6\x4f\x97\xe4\x3f\xf5\x29\x5b\xc8\x84\xfa\x77\x73\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xa2\xd9\x09\xc1\x0a"
          "\x1b\xdc\xd3\x18\x04\x6d\x32\x05\x83\xf6\xb7",
          "\xd6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8"
          "\x51\x08\x99\x6d\xff\xf8\xa2\x6e\xde\x1e\x76\xde\x15\x17\x01\xe8\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc5\x26\x5a"
          "\x70\x0c\x30\xc7\x2d\xa2\xdf\x2e\xb1\x29\x44\x7b\x0a\xe8\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc5\x26\x5a\x70\x0c"
          "\x30\xc7\x2d\xa2\xdf\x2e\xb1\x29\x44\x7b\x0a",
          "\x3e\xa8\xf9\xb2\x01\x23\x21\xe6\x3d\x5f\xb5\xbc\x2c\x5d\x33\x2d", 1,
          32, 768 },
        { 96, 256, 128, 252,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x66\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x18"
          "\xf1\x25\xef\x37\x4c\x14\x54\xb6\x80\xe2\x34\x27\xe7\xdc\x69\xe4\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x85\x8b\x08"
          "\xeb\x1d\x58\x15\x70\xa7\xcd\x1e\x48\x59\x3b\x75\x75\x68\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\x4d\xbe\xe8\xa9\xf1"
          "\x0c\x5e\x47\x80\x3c\x5a\x21\x94\x3c\x79\xb5",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x81"
          "\xf6\x0b\xe9\xb9\x69\xfc\xe8\x33\x54\x43\xcf\x23\xd2\x35\xe7\xf3\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x41\xbb"
          "\x18\xf7\x27\x45\xb9\x3a\xe7\x19\xa2\xb8\xfb\xf4\x08\xf3\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x41\xbb\x18\xf7"
          "\x27\x45\xb9\x3a\xe7\x19\xa2\xb8\xfb\xf4\x08",
          "\xdf\xaf\x8a\x3a\x15\xd4\x5e\x7f\x4c\x34\x30\x04\x8d\x85\x89\xf0", 1,
          32, 768 },
        { 96, 256, 128, 253,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\xb0\x2a\xb7\x47\xa3\x10\xd6\xa3\xbb\xdb\x97\x01\x8a\x3b\xe8\xb3\x41"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xb7\xa3"
          "\x38\xbc\x34\x23\x89\x5f\x0f\xd9\x6c\xdb\x27\xa7\x87\xf2\x77\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x3b\x44\x23\x7a"
          "\x59\xb0\x4a\x6f\x2d\x14\x44\x88\xfa\x5e\x2b\xcd",
          "\x29\xc4\x16\xdf\xb0\x3c\xfd\x4b\xc8\x68\x08\x19\x66\x6f\x59\x12\xd8"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa0\x1b"
          "\xd4\xd9\x94\x92\x49\x2e\x62\xf1\x30\x93\xc6\xec\x87\x03\xd8\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa0\x1b\xd4\xd9"
          "\x94\x92\x49\x2e\x62\xf1\x30\x93\xc6\xec\x87\x03",
          "\x34\x08\xeb\x2b\x13\xa9\xb7\x6b\xef\xce\xdf\x69\x94\x22\xd6\x1f", 1,
          32, 640 },
        { 96, 256, 128, 254,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x40\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x38"
          "\x0e\xf9\x3a\xeb\x61\xaa\x30\x7f\x14\x13\x23\xc3\x8e\x06\x85\xf6\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x3f\x76\x9a"
          "\x30\xe8\x95\x1f\xf2\xfb\x36\x5f\xa7\x80\xfd\xde\x7e\x7a\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xf7\x43\x7a\x72\x04"
          "\xc1\x54\xc5\xdc\xc7\x1b\xce\x4d\xfa\xd2\xbe",
          "\xd9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa1"
          "\x09\xd7\x3c\x65\x44\x42\x8c\xfa\xc0\xb2\xd8\xc7\xbb\xef\x0b\xe1\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\xbc\x29"
          "\xc3\x02\xea\x4f\x3b\x66\x1c\x58\x4d\x61\x3d\x5f\x03\xe1\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\xbc\x29\xc3\x02"
          "\xea\x4f\x3b\x66\x1c\x58\x4d\x61\x3d\x5f\x03",
          "\x09\xf4\xf2\xa3\x93\x6d\x74\x61\xa6\x7c\xe0\x22\x17\x6b\xb8\xdd", 1,
          32, 768 },
        { 96, 256, 128, 255,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x40\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x06"
          "\x0e\xf9\x3a\xeb\x61\xaa\x30\x7f\x14\x13\x23\xc3\x8e\x06\x85\xee\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x2b\xca\x70"
          "\xbf\xcd\xf1\x17\x1a\xb6\x11\xd1\x2b\xed\x5d\x62\x7a\x62\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xe3\xff\x90\xfd\x21"
          "\xa5\x5c\x2d\x91\xe0\x95\x42\x20\x5a\x6e\xba",
          "\xd9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9f"
          "\x09\xd7\x3c\x65\x44\x42\x8c\xfa\xc0\xb2\xd8\xc7\xbb\xef\x0b\xf9\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x84\x00\xc3"
          "\x4c\x27\x8e\x47\xd3\x2b\x3b\xd6\xc1\x0c\x9d\xe3\x07\xf9\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x84\x00\xc3\x4c\x27"
          "\x8e\x47\xd3\x2b\x3b\xd6\xc1\x0c\x9d\xe3\x07",
          "\x2e\xb2\x67\x9a\xad\xfd\x82\x4a\x5f\xd8\xfa\x2e\x4a\x55\xa6\x5c", 1,
          32, 768 },
        { 96, 256, 128, 256,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x56\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x6c"
          "\x7e\x13\x12\xc6\x77\x4f\xae\x7d\x1e\x5d\x0c\xc6\x09\x02\x8f\xf5\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x81\xc9\xe6"
          "\x1c\xbe\xee\xd5\x54\x6b\x1c\xe5\xd8\xfe\xf2\x1a\x7a\x79\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\x49\xfc\x06\x5e\x52"
          "\xba\x9e\x63\x4c\xed\xa1\xb1\x33\xf5\x16\xba",
          "\xcf\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5"
          "\x79\x3d\x14\x48\x52\xa7\x12\xf8\xca\xfc\xf7\xc2\x3c\xeb\x01\xe2\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x03\x55"
          "\xef\x54\x91\x85\x9d\xf6\x36\xe2\x32\x1f\x32\x9b\x07\xe2\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x03\x55\xef\x54"
          "\x91\x85\x9d\xf6\x36\xe2\x32\x1f\x32\x9b\x07",
          "\x5e\x89\x34\x9f\x6b\x01\x1c\xd6\xe2\x4e\xe6\xac\x2f\x59\x0c\x21", 1,
          32, 768 },
        { 96, 256, 128, 257,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x2e\xa8\x41\x0b\x4d\xca\x8c\x9d\x53\x69\xa0\x33\xd8\xdb\x61\xe4\x6c"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xf0\xf5"
          "\x8e\x8b\xba\x6c\xf1\xa5\x21\x46\x27\x3d\x8f\xe0\xc4\xfc\x5a\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x7c\x12\x95\x4d"
          "\xd7\xff\x32\x95\x03\x8b\x0f\x6e\x52\x19\x68\xc3",
          "\xb7\x46\xe0\x93\x5e\xe6\xa7\x75\x20\xda\x3f\x2b\x34\x8f\xd0\x45\xf5"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe7\x4d"
          "\x62\xee\x1a\xdd\x31\xd4\x4c\x6e\x7b\x75\x6e\xab\xc4\x0d\xf5\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe7\x4d\x62\xee"
          "\x1a\xdd\x31\xd4\x4c\x6e\x7b\x75\x6e\xab\xc4\x0d",
          "\xb2\x45\x37\xfc\xb0\xdc\xb6\x20\x0b\x02\x85\xca\xfc\x9c\x3a\x7d", 1,
          32, 640 },
        { 96, 256, 128, 258,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x17\x05\x9a\x7c\x88\x83\xa2\x8b\x90\xbd\x94\xae\x44\xd1\x54\x36\x62"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xa2\x30"
          "\x18\xbf\x8e\x68\xe4\x13\xe9\x9a\xc2\xd4\xab\x3f\x8d\xf1\x54\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x2e\xd7\x03\x79"
          "\xe3\xfb\x27\x23\xcb\x57\xea\x87\x76\xc6\x21\xce",
          "\x8e\xeb\x3b\xe4\x9b\xaf\x89\x63\xe3\x0e\x0b\xb6\xa8\x85\xe5\x97\xfb"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb5\x88"
          "\xf4\xda\x2e\xd9\x24\x62\x84\xb2\x9e\x9c\x4a\x74\x8d\x00\xfb\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb5\x88\xf4\xda"
          "\x2e\xd9\x24\x62\x84\xb2\x9e\x9c\x4a\x74\x8d\x00",
          "\x43\x30\x04\x00\xea\x36\xe7\x20\x36\x11\x53\xce\x0c\x5d\x63\x7d", 1,
          32, 640 },
        { 96, 256, 128, 259,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\xaa\xa1\xb2\x58\xfd\x4b\x54\xb4\x97\xb5\x20\x80\x6a\x66\xd7\xaa\x68"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\x99\x13"
          "\x2a\x23\x4a\x8c\x78\x9b\xf8\x54\x45\x47\x94\x0e\xc3\xf3\x5e\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x15\xf4\x31\xe5"
          "\x27\x1f\xbb\xab\xda\x99\x6d\x14\x49\xf7\x6f\xcc",
          "\x33\x4f\x13\xc0\xee\x67\x7f\x5c\xe4\x06\xbf\x98\x86\x32\x66\x0b\xf1"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\xab"
          "\xc6\x46\xea\x3d\xb8\xea\x95\x7c\x19\x0f\x75\x45\xc3\x02\xf1\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\xab\xc6\x46"
          "\xea\x3d\xb8\xea\x95\x7c\x19\x0f\x75\x45\xc3\x02",
          "\xd7\x9a\x03\x10\x12\x4a\xdc\x30\xc6\xb6\x4c\xde\xf8\x99\x3e\x8d", 1,
          32, 640 },
        { 96, 256, 128, 260,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x4c\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\xbb"
          "\x53\x57\xed\x31\x4a\xd7\x40\xb9\x91\x0f\xad\x6f\x01\xd7\x81\xf0\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\xc8\x04\x2b"
          "\x41\x4f\xdd\x1b\xba\x3a\x6c\x93\x6b\x7e\xd6\x78\x79\x7c\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\x00\x31\xcb\x03\xa3"
          "\x89\x50\x8d\x1d\x9d\xd7\x02\xb3\xd1\x74\xb9",
          "\xd5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x22"
          "\x54\x79\xeb\xbf\x6f\x3f\xfc\x3c\x45\xae\x56\x6b\x34\x3e\x0f\xe7\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x67\xce\x98"
          "\xb2\xa5\xa2\x4b\x73\xa7\x46\x94\x81\x9f\x16\xf9\x04\xe7\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x67\xce\x98\xb2\xa5"
          "\xa2\x4b\x73\xa7\x46\x94\x81\x9f\x16\xf9\x04",
          "\xe6\x02\x2c\xc3\xba\x20\xe3\xf9\x06\x5f\xdf\xcc\x43\xa9\xdc\x40", 1,
          32, 768 },
        { 96, 256, 128, 261,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x66\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\xf6"
          "\x42\x96\x97\x5a\xf7\xfc\xed\x16\x81\x81\xf7\x6c\x65\x08\xe1\xc9\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x49\x75\x06"
          "\x0f\x7d\xde\xf4\xa0\x98\x69\x93\x33\xb3\x0f\xbf\x7c\x45\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\x81\x40\xe6\x4d\x91"
          "\x8a\xbf\x97\xbf\x98\xd7\x5a\x7e\x08\xb3\xbc",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f"
          "\x45\xb8\x91\xd4\xd2\x14\x51\x93\x55\x20\x0c\x68\x50\xe1\x6f\xde\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe6\xbf\xb5"
          "\xfc\x97\xa1\xa4\x69\x05\x43\x94\xd9\x52\xcf\x3e\x01\xde\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe6\xbf\xb5\xfc\x97"
          "\xa1\xa4\x69\x05\x43\x94\xd9\x52\xcf\x3e\x01",
          "\x35\x3e\x30\x4f\xd8\x55\x32\x86\xb2\x6e\x0d\x59\x94\x2f\xe7\xcd", 1,
          32, 768 },
        { 96, 256, 128, 262,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x98\x41\xcf\xc9\x27\xa5\x7d\xc4\x91\xab\x35\x42\x7f\xf9\x35\xe6\x6e"
          "\xf8\xd1\xf9\x71\xda\x17\x43\x7a\x2b\x5e\x04\xfb\xca\x16\x71\xa6\x83"
          "\xc8\xf9\xf9\xe6\x78\x0f\xda\x49\x40\xdd\xed\xd7\x6b\xf2\x58\x35\x4c"
          "\x0c\x15\x80\xaf\x36\x62\xd5\xf8\x15\x1e\x3f\x7e\x82\x2a\x64\xd3\x3f"
          "\x94\x75\xbb\x3f\xf8\x84\x68\x8e\x30\x2e\xc7\xcd",
          "\x01\xaf\x6e\x51\x34\x89\x56\x2c\xe2\x18\xaa\x5a\x93\xad\x84\x47\xf7"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb1\x3b"
          "\x24\x9c\x59\x57\xb8\x7e\xb7\x61\x1c\x95\x0c\x9c\x6b\x03\xf7\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb1\x3b\x24\x9c"
          "\x59\x57\xb8\x7e\xb7\x61\x1c\x95\x0c\x9c\x6b\x03",
          "\x0a\xeb\x04\xec\xf7\xde\xf4\x0c\x42\x02\x5b\xba\xe5\x50\x91\x69", 1,
          32, 640 },
        { 96, 256, 128, 263,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x42\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x0b"
          "\x61\xbf\x9b\x7c\xaf\x83\xcc\x34\xda\x62\x55\x93\x51\x42\x89\xe8\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x69\x6a\x5c"
          "\x7f\xb9\xda\x9c\xd4\xa3\x9c\x85\x91\x08\x6d\xb4\x2d\x64\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xa1\x5f\xbc\x3d\x55"
          "\x8e\xd7\xe3\x84\x6d\xc1\xf8\xc5\x6a\xb8\xed",
          "\xdb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x92"
          "\x66\x91\x9d\xf2\x8a\x6b\x70\xb1\x0e\xc3\xae\x97\x64\xab\x07\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc6\xa0\xef"
          "\x8c\x53\xa5\xcc\x1d\x3e\xb6\x82\x7b\xe9\xad\x35\x50\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc6\xa0\xef\x8c\x53"
          "\xa5\xcc\x1d\x3e\xb6\x82\x7b\xe9\xad\x35\x50",
          "\x8f\xc4\xf7\x7a\x6e\xe0\x52\xa4\xc3\x14\x78\x0b\x8d\xf9\xa2\xd0", 1,
          32, 768 },
        { 96, 256, 128, 264,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x4b\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\xf2"
          "\x8e\x4d\x0f\x20\xca\x16\x44\x47\x0c\x9c\xda\xc6\x00\x08\x87\xed\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x14\x64\x77"
          "\x5b\xac\xd5\xc6\x9f\xe2\x6e\x1a\x74\x96\x8e\xa2\x7e\x61\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xdc\x51\x97\x19\x40"
          "\x81\x8d\xa8\xc5\x9f\x5e\x1d\x5b\x89\xae\xbe",
          "\xd2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b"
          "\x89\x63\x09\xae\xef\xfe\xf8\xc2\xd8\x3d\x21\xc2\x35\xe1\x09\xfa\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbb\xae\xc4"
          "\xa8\x46\xaa\x96\x56\x7f\x44\x1d\x9e\x77\x4e\x23\x03\xfa\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbb\xae\xc4\xa8\x46"
          "\xaa\x96\x56\x7f\x44\x1d\x9e\x77\x4e\x23\x03",
          "\x23\x2f\xf7\x8a\x96\xf3\x47\xb4\x53\xba\x71\x1b\x79\x36\x7e\xe0", 1,
          32, 768 },
        { 96, 256, 128, 265,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x2d\xd4\xcd\x40",
          "\xff\xff\xff\xff",
          "\x4d\x11\x5e\x67\xec\xd3\xd4\x17\x8c\x4c\x60\xe7\x13\xab\x4e\x5e\x6e"
          "\xe6\x28\xfc\x4b\x58\x30\x18\x4c\xd2\x93\x36\x4a\x21\x3e\x84\xfe\x47"
          "\x13\x9a\x5f\x4e\x3f\x8e\x92\xd7\xa3\xb7\x1e\xb4\xff\x0e\x29\xdb\x95"
          "\x3a\xd5\x45\x8f\xea\x61\xf0\x13\xea\x18\x54\xfe\x75\x72\xa0\x08\x5c"
          "\x32\xdd\xfc\xbe\xb0\x1a\x8b\xe4\xc3\x4d\x53\x31\xe1\xee\x75\x78\x39"
          "\x11\xc4\xdd\x46\x01\x57\x83\xd5\x53\xf2\xb5",
          "\xd4\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf7"
          "\xe1\x06\xfa\xc5\x7d\xd8\xa4\xc9\x06\x32\xcd\x4e\x14\xd7\x0a\xe9\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x86\x11\x26"
          "\xc9\x3f\x3a\xdf\x23\xfc\xda\x14\x00\xf9\x94\x7f\x08\xe9\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x86\x11\x26\xc9\x3f"
          "\x3a\xdf\x23\xfc\xda\x14\x00\xf9\x94\x7f\x08",
          "\xe0\x0d\x2e\x8b\xae\x5d\x09\xc2\x8e\x9b\xf5\x94\x09\x54\x5d\x09", 1,
          32, 768 },
        { 96, 256, 128, 266,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x19\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xbc"
          "\x28\x6f\xd9\x79\x80\x79\x51\xb1\x83\xa1\x88\x93\x0a\xd1\x5e\xdc\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x89\x0e\x65"
          "\x9f\xd3\x02\x8c\x90\x4e\x65\x01\x8f\xdf\xd6\x03\x83\x33\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x33\xb7\xfb\x50\xc3"
          "\xe7\xeb\xca\x97\x0f\x6f\x89\xa8\x8a\x82\xd6",
          "\xf9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01"
          "\x5d\x15\x65\x92\x4f\x6c\x74\x18\xde\x9b\xab\xf8\xbe\x44\x07\xed\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x11\x0e"
          "\x5e\x1c\x04\x68\xcb\xaa\xd9\x9c\x8a\xbe\xff\xff\x07\xed\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x11\x0e\x5e\x1c"
          "\x04\x68\xcb\xaa\xd9\x9c\x8a\xbe\xff\xff\x07",
          "\x47\xe5\xd4\x29\x42\x39\xdb\x73\xb8\x36\xc0\x40\x70\xff\x5b\x2d", 1,
          32, 768 },
        { 96, 256, 128, 267,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x83"
          "\x9f\x81\x1a\xd0\x31\x0c\x77\x05\x2f\x45\x32\x0b\x0d\x95\x60\xc4\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x70\xd6\xb1"
          "\x4f\xd2\x09\xfe\xdf\x26\x1f\xd1\xd2\x50\xd3\x47\x8d\x2b\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xca\x6f\x2f\x80\xc2"
          "\xec\x99\x85\xff\x75\xbf\xd4\x27\x8f\xc6\xd8",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3e"
          "\xea\xfb\xa6\x3b\xfe\x19\x52\xac\x72\x7f\x11\x60\xb9\x00\x39\xf5\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd7\xc9\xda"
          "\x8e\x1d\x0f\x1a\x84\xc2\xa3\x4c\xd7\x31\xfa\xbb\x09\xf5\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd7\xc9\xda\x8e\x1d"
          "\x0f\x1a\x84\xc2\xa3\x4c\xd7\x31\xfa\xbb\x09",
          "\x23\x2c\x88\x2f\x7a\x1a\x2f\x80\x8c\xcf\x26\x49\x6c\xff\x5b\x3d", 1,
          32, 768 },
        { 96, 256, 128, 268,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x97\x31\x1c\xd6\xe2\xd2\x5a\x7b\x4e\xaa\x16\xf0\xa6\x1c\xa6\x24\x6b"
          "\x8a\x85\x43\x14\x30\xea\xda\x56\xa2\xc5\xdc\x94\x4b\x6a\xa6\x95\x13"
          "\x63\x10\xb6\xb6\xb5\xc1\x7c\x9f\x8c\x02\xba\x7d\x0a\xeb\x71\xe0\x94"
          "\x3e\x30\xf9\x1b\xa4\x1b\x43\x62\xfa\x9e\xd6\x03\x7b\x7a\x32\x9e\xe1"
          "\xa0\xaf\x16\x0f\xc7\x6d\x3d\xe7\xe9\x91\x02\xc3",
          "\x77\x10\x78\xb7\xd5\x9f\xe2\x50\x9a\xeb\x0b\x0e\x34\x84\x4c\x61\xd6"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa4\x1c"
          "\x2c\xb9\xeb\xa7\x86\x6f\x50\x68\x4b\x1b\x05\xe3\xab\x00\xd6\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa4\x1c\x2c\xb9"
          "\xeb\xa7\x86\x6f\x50\x68\x4b\x1b\x05\xe3\xab\x00",
          "\xd7\x1b\xc7\x0d\x5a\xdc\x74\xe7\xdf\xd8\x94\x06\xfc\x15\xf0\x44", 1,
          32, 640 },
        { 96, 256, 128, 269,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x34\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x74"
          "\xcf\x7e\x9d\x82\xb7\xe8\xed\x9e\xc9\x65\xf6\xea\x31\x09\x51\xdc\x10"
          "\x49\x40\xe0\x8a\x42\x22\x55\x68\x28\xeb\xa4\x59\xf6\x5a\x4a\x00\x6d"
          "\x28\x72\x9d\x95\xd7\x9d\x23\x72\xf7\x7a\xee\xab\x35",
          "\xd4\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc9"
          "\xba\x04\x21\x69\x78\xfd\xc8\x37\x94\x5f\xd5\x81\x85\x9c\x08\xed\x1f"
          "\x06\xe9\xbd\x9b\x71\x8c\x79\x9f\xef\xf2\x1b\xc7\x57\xb1\xed\x1f\x06"
          "\xe9\xbd\x9b\x71\x8c\x79\x9f\xef\xf2\x1b\xc7\x57\xb1",
          "\x21\xe6\x39\x87\xd4\x94\x67\x3f\x30\x40\xae\x9d\xe2\xbc\x0d\xa0", 1,
          32, 512 },
        { 96, 256, 128, 270,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\xe7\x2b\x83\x51\x4e\x5e\x50\x50\x90\x70\x35\x9c\x1c\xac\x7e\x1c\x42"
          "\x8a\x85\x43\x14\x30\xea\xda\x56\xa2\xc5\xdc\x94\x4b\x6a\xa6\xda\xd3"
          "\x59\x50\xd8\xa9\xb5\x5a\x47\x2f\x9b\xb8\x86\x0a\x52\x63\x58\xe0\x94"
          "\x3e\x30\xf9\x1b\xa4\x1b\x43\x62\xfa\x9e\xd6\x03\x7b\x35\xf2\xa4\xa1"
          "\xce\xb0\x16\x94\xfc\xdd\x2a\x5d\xd5\xe6\x5a\x4b",
          "\x07\x0a\xe7\x30\x79\x13\xe8\x7b\x44\x31\x28\x62\x8e\x34\x94\x59\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xeb\xdc"
          "\x16\xf9\x85\xb8\x86\xf4\x6b\xd8\x5c\xa1\x39\x94\xf3\x88\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xeb\xdc\x16\xf9"
          "\x85\xb8\x86\xf4\x6b\xd8\x5c\xa1\x39\x94\xf3\x88",
          "\xe4\xfb\x94\x5d\x6a\x2d\x0b\x94\x78\x34\x31\x7c\xc4\x15\xf0\x24", 1,
          32, 640 },
        { 96, 256, 128, 271,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x8c\x61\x65\xf4\x45\x44\x35\x88\x04\x1b\x6e\x04\x4f\xb6\xba\xae\x72"
          "\x8a\x85\x43\x14\x30\xea\xda\x56\xa2\xc5\xdc\x94\x4b\x6a\xa6\x88\x1a"
          "\x54\xc0\x95\x16\xa1\xf1\xca\xe7\xb9\xdd\x71\x13\x0e\xe1\x68\xe0\x94"
          "\x3e\x30\xf9\x1b\xa4\x1b\x43\x62\xfa\x9e\xd6\x03\x7b\x67\x3b\xa9\x31"
          "\x83\x0f\x02\x3f\x71\x15\x08\x38\x22\xff\x06\xc9",
          "\x6c\x40\x01\x95\x72\x09\x8d\xa3\xd0\x5a\x73\xfa\xdd\x2e\x50\xeb\xcf"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x15"
          "\x1b\x69\xc8\x07\x92\x5f\xe6\x10\x7e\xc4\xce\x8d\xaf\x0a\xcf\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x15\x1b\x69"
          "\xc8\x07\x92\x5f\xe6\x10\x7e\xc4\xce\x8d\xaf\x0a",
          "\xc0\x42\x48\x63\xa2\x0e\x5f\xa0\x4c\xcd\x97\x84\xc0\x15\xf0\x34", 1,
          32, 640 },
        { 96, 256, 128, 272,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x18\xe3\x61\x74\x54\x5f\xa7\xec\x9e\xa9\xf0\x5d\x70\x57\xc5\xca\x63"
          "\x8a\x85\x43\x14\x30\xea\xda\x56\xa2\xc5\xdc\x94\x4b\x6a\xa6\x43\x4e"
          "\x1c\x5e\x71\x00\x5b\x69\x0c\xa5\xcb\x8d\x58\x0b\x89\xed\x79\xe0\x94"
          "\x3e\x30\xf9\x1b\xa4\x1b\x43\x62\xfa\x9e\xd6\x03\x7b\xac\x6f\xe1\xaf"
          "\x67\x19\xf8\xa7\xb7\x57\x7a\x68\x0b\xe7\x81\xc5",
          "\xf8\xc2\x05\x15\x63\x12\x1f\xc7\x4a\xe8\xed\xa3\xe2\xcf\x2f\x8f\xde"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x41"
          "\x53\xf7\x2c\x11\x68\xc7\x20\x52\x0c\x94\xe7\x95\x28\x06\xde\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x41\x53\xf7"
          "\x2c\x11\x68\xc7\x20\x52\x0c\x94\xe7\x95\x28\x06",
          "\xaa\x72\x93\xff\xe5\xdb\x30\xa3\x1f\x25\x81\xe0\xe7\xae\x56\xed", 1,
          32, 640 },
        { 96, 256, 128, 273,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x12\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x54"
          "\x30\x5d\xff\x6b\x61\xc4\x0b\x77\x5c\x35\x2d\x02\x5c\x1a\x56\xd7\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\xbc\xe5\x74"
          "\xe9\xe1\x1a\xfe\xdb\xdc\xa0\x21\xe5\x3b\xb9\x18\x83\x38\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x06\x5c\xea\x26\xf1"
          "\xff\x99\x81\x05\xca\x4f\xe3\x4c\xe5\x99\xd6",
          "\xf2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe9"
          "\x45\x27\x43\x80\xae\xd1\x2e\xde\x01\x0f\x0e\x69\xe8\x8f\x0f\xe6\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1b\xfa\x1f"
          "\x28\x2e\x1c\x1a\x80\x38\x1c\xbc\xe0\x5a\x90\xe4\x07\xe6\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1b\xfa\x1f\x28\x2e"
          "\x1c\x1a\x80\x38\x1c\xbc\xe0\x5a\x90\xe4\x07",
          "\x42\xe5\xd4\x3d\x1e\x80\x8e\x79\xf0\x17\x14\x4d\x44\x98\xc2\x35", 1,
          32, 768 },
        { 96, 256, 128, 274,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xdf"
          "\x05\x99\x19\x4b\x0c\xe8\x90\xcc\x1d\x8e\xb3\x83\xb5\x7f\x38\xdc\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x35\xdf\x81"
          "\x07\x7d\x06\x80\x77\xce\x80\x5e\xa5\x92\xf6\xf8\x88\x33\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x8f\x66\x1f\xc8\x6d"
          "\xe3\xe7\x2d\x17\xea\x30\xa3\xe5\xaa\x79\xdd",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x62"
          "\x70\xe3\xa5\xa0\xc3\xfd\xb5\x65\x40\xb4\x90\xe8\x01\xea\x61\xed\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x92\xc0\xea"
          "\xc6\xb2\x00\x64\x2c\x2a\x3c\xc3\xa0\xf3\xdf\x04\x0c\xed\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x92\xc0\xea\xc6\xb2"
          "\x00\x64\x2c\x2a\x3c\xc3\xa0\xf3\xdf\x04\x0c",
          "\x6c\xf2\xf9\x23\x0a\xf8\x67\x9e\x7e\xcb\x19\x42\x13\x62\xfc\xe3", 1,
          32, 768 },
        { 96, 256, 128, 275,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x39\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x40"
          "\x92\xe1\xf9\xa2\x2c\x8b\x18\x18\x4d\x80\x5c\x12\x8a\xde\x57\xc7\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x64\xfe\x8b"
          "\x9b\xdd\x21\x5a\x62\x09\x73\xaf\xfe\xfe\x93\x39\x85\x28\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xde\x47\x15\x54\xcd"
          "\xc4\x3d\x38\xd0\x19\xc1\xf8\x89\xcf\xb8\xd0",
          "\xd9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfd"
          "\xe7\x9b\x45\x49\xe3\x9e\x3d\xb1\x10\xba\x7f\x79\x3e\x4b\x0e\xf6\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\xe1\xe0"
          "\x5a\x12\x27\xbe\x39\xed\xcf\x32\xfb\x9f\xba\xc5\x01\xf6\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\xe1\xe0\x5a\x12"
          "\x27\xbe\x39\xed\xcf\x32\xfb\x9f\xba\xc5\x01",
          "\x6d\x46\xd2\x23\x0a\x98\x48\xd5\x18\xf9\xd9\x4b\xb2\xc4\x9c\xaa", 1,
          32, 768 },
        { 96, 256, 128, 276,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x12\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x32"
          "\x7f\x3a\x1b\xef\xb4\x28\x7c\x17\x45\x03\x91\xed\x0e\xb8\x54\xd6\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x14\x60\xd3"
          "\x54\x5c\x29\xdd\xc7\x90\x71\x1b\x8e\x75\x33\x69\x85\x39\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xae\xd9\x4d\x9b\x4c"
          "\xcc\xba\x9d\x49\x1b\x75\x88\x02\x6f\xe8\xd0",
          "\xf2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8f"
          "\x0a\x40\xa7\x04\x7b\x3d\x59\xbe\x18\x39\xb2\x86\xba\x2d\x0d\xe7\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb3\x7f\xb8"
          "\x95\x93\x2f\x39\x9c\x74\xcd\x86\x8b\x14\x1a\x95\x01\xe7\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb3\x7f\xb8\x95\x93"
          "\x2f\x39\x9c\x74\xcd\x86\x8b\x14\x1a\x95\x01",
          "\x74\xdd\xa1\x2e\x05\x58\x87\x7b\xc0\xe4\x0c\x3e\xac\xe0\xaf\x29", 1,
          32, 768 },
        { 96, 256, 128, 277,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1b\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x85"
          "\xb6\x76\x64\xee\x49\xfa\x34\x7f\xbf\xd2\xdd\x92\x00\x7c\x57\xde\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\xfb\x27\xee"
          "\x07\x5b\x3c\x0f\x0f\x68\x2b\xab\xdd\xe6\x3d\xad\x87\x31\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x41\x9e\x70\xc8\x4b"
          "\xd9\x68\x55\xb1\x41\xc5\xdb\x91\x61\x2c\xd2",
          "\xfb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38"
          "\xc3\x0c\xd8\x05\x86\xef\x11\xd6\xe2\xe8\xfe\xf9\xb4\xe9\x0e\xef\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\x38\x85"
          "\xc6\x94\x3a\xeb\x54\x8c\x97\x36\xd8\x87\x14\x51\x03\xef\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\x38\x85\xc6\x94"
          "\x3a\xeb\x54\x8c\x97\x36\xd8\x87\x14\x51\x03",
          "\x50\x24\x55\x34\x3d\x39\xdb\x87\x94\x7d\x73\x46\xa8\xe0\xaf\x39", 1,
          32, 768 },
        { 96, 256, 128, 278,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x36\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x11"
          "\x32\x81\x1b\x2f\x18\x32\x1b\xa9\x9b\x12\x43\x2c\x7f\x86\x5a\xa3\x35"
          "\x2c\xd2\xd7\xac\x70\xb4\xc6\xf5\x41\x97\x67\x92\x6e\x20\x35\x25\x08"
          "\xba\x45\xbb\xa7\x41\x0e\xbe\x1b\x8b\xb9\x25\x33\x4f",
          "\xd6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xac"
          "\x47\xfb\xa7\xc4\xd7\x27\x3e\x00\xc6\x28\x60\x47\xcb\x13\x03\x92\x3a"
          "\x63\x7b\x8a\xbd\x43\x1a\xea\x02\x86\x8e\xd8\x0c\xcf\xcb\x92\x3a\x63"
          "\x7b\x8a\xbd\x43\x1a\xea\x02\x86\x8e\xd8\x0c\xcf\xcb",
          "\x14\xfb\xa1\x49\xd1\xc0\xed\xc8\xaa\x66\x58\x51\x12\x6b\x5a\xfd", 1,
          32, 512 },
        { 96, 256, 128, 279,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xf9"
          "\x99\x46\x10\x58\xf6\xd7\x73\x3e\x5c\xd0\xd1\x63\x9d\x90\x25\xcb\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x52\x0a\x0d"
          "\xa5\x04\x39\xdb\x00\xe2\x89\xe1\x79\x13\x42\x06\x8e\x24\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xe8\xb3\x93\x6a\x14"
          "\xdc\xbc\x5a\x3b\xe3\x8f\x7f\x64\x1e\x87\xdb",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44"
          "\xec\x3c\xac\xb3\x39\xc2\x56\x97\x01\xea\xf2\x08\x29\x05\x7c\xfa\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x15\x66"
          "\x64\xcb\x3f\x3f\x5b\x06\x35\x7c\x7c\x72\x6b\xfa\x0a\xfa\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x15\x66\x64\xcb"
          "\x3f\x3f\x5b\x06\x35\x7c\x7c\x72\x6b\xfa\x0a",
          "\xbf\x7f\xbd\x42\x2c\xbf\x0e\x70\x0f\xd1\x60\x5b\xe8\xfd\x21\x2f", 1,
          32, 768 },
        { 96, 256, 128, 280,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x15\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xcc"
          "\x16\x29\xa4\x0c\xd1\x1e\xaf\xdf\x04\x13\x8b\x45\xaf\xe4\x58\xef\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x34\x0a\xc9"
          "\xb4\x5a\x58\x96\xa4\x18\xa8\xce\xe8\x03\x2e\x07\x8f\x00\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x8e\xb3\x57\x7b\x4a"
          "\xbd\xf1\xfe\xc1\xc2\xa0\xee\x74\x72\x86\xda",
          "\xf5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71"
          "\x63\x53\x18\xe7\x1e\x0b\x8a\x76\x59\x29\xa8\x2e\x1b\x71\x01\xde\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x93\x15\xa2"
          "\x75\x95\x5e\x72\xff\xfc\x14\x53\xed\x62\x07\xfb\x0b\xde\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x93\x15\xa2\x75\x95"
          "\x5e\x72\xff\xfc\x14\x53\xed\x62\x07\xfb\x0b",
          "\xc6\xf2\x32\x04\x86\x5b\x0a\xdd\xe0\x07\x00\x37\xd6\x53\x8d\xd3", 1,
          32, 768 },
        { 96, 256, 128, 281,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x31\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xff"
          "\x74\x6e\xf5\x3e\xc3\x35\x7c\xbc\x3c\x3c\xe4\xab\x1d\x2d\x51\xed\x9e"
          "\xb4\x56\xdc\x9d\x9b\x59\xf6\x56\xa5\xd2\xd9\x74\xd2\x6a\x7b\x8e\x90"
          "\x3e\x4e\x8a\x4c\xac\x3e\x1d\xff\xce\x07\xc3\x8f\x05",
          "\xd1\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42"
          "\x01\x14\x49\xd5\x0c\x20\x59\x15\x61\x06\xc7\xc0\xa9\xb8\x08\xdc\x91"
          "\xfb\xff\x81\x8c\xa8\xf7\xda\xa1\x62\xcb\x66\xea\x73\x81\xdc\x91\xfb"
          "\xff\x81\x8c\xa8\xf7\xda\xa1\x62\xcb\x66\xea\x73\x81",
          "\x8c\xff\x61\xb7\xb3\x91\x9e\xd6\xbd\xe7\x2b\x36\xe0\xd3\x13\x26", 1,
          32, 512 },
        { 96, 256, 128, 282,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x19\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xbf"
          "\x28\x6f\xd9\x79\x80\x79\x51\xb1\x83\xa1\x88\x93\x0a\xd1\x5e\xce\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x64\x41\x3d"
          "\x71\x93\x9b\x9c\xb0\xa4\xd3\x2e\xf1\x15\xda\x9e\x10\x21\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xde\xf8\xa3\xbe\x83"
          "\x7e\xfb\xea\x7d\xb9\x40\xf7\x62\x86\x1f\x45",
          "\xf9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x02"
          "\x5d\x15\x65\x92\x4f\x6c\x74\x18\xde\x9b\xab\xf8\xbe\x44\x07\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x5e\x56"
          "\xb0\x5c\x9d\x78\xeb\x40\x6f\xb3\xf4\x74\xf3\x62\x94\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x5e\x56\xb0\x5c"
          "\x9d\x78\xeb\x40\x6f\xb3\xf4\x74\xf3\x62\x94",
          "\x36\x9c\xf1\x70\x11\xca\xe4\x75\x39\xe2\x72\x3f\x01\x0c\xf9\x80", 1,
          32, 768 },
        { 96, 256, 128, 283,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x19\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xbd"
          "\x28\x6f\xd9\x79\x80\x79\x51\xb1\x83\xa1\x88\x93\x0a\xd1\x5e\xe3\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\xf2\x5e\x78"
          "\xfe\x1b\x53\xae\x41\x6d\x1f\xbc\x69\x85\x22\x61\x8f\x0c\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x48\xe7\xe6\x31\x0b"
          "\xb6\xc9\x1b\xb4\x75\xd2\x6f\xf2\x7e\xe0\xda",
          "\xf9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00"
          "\x5d\x15\x65\x92\x4f\x6c\x74\x18\xde\x9b\xab\xf8\xbe\x44\x07\xd2\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x55\x41\x13"
          "\x3f\xd4\x55\x4a\x1a\x89\xa3\x21\x6c\xe4\x0b\x9d\x0b\xd2\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x55\x41\x13\x3f\xd4"
          "\x55\x4a\x1a\x89\xa3\x21\x6c\xe4\x0b\x9d\x0b",
          "\x53\x2e\xb8\xe2\x72\xa8\xd1\x71\x37\x8b\x0d\x42\xdf\xf2\xbe\xd9", 1,
          32, 768 },
        { 96, 256, 128, 284,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x32\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x25"
          "\x8d\x5d\x3e\x44\x16\x83\xf5\x46\xbe\xba\x2e\x23\x75\x5f\x5c\xce\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x9d\x13\xfd"
          "\xf8\xfa\x89\x98\x36\xfa\x5c\x41\x0d\x4c\xcd\x25\xea\x21\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x27\xaa\x63\x37\xea"
          "\x6c\xff\x6c\x23\x36\x2f\x0b\x3b\x91\xa4\xbf",
          "\xd2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x98"
          "\xf8\x27\x82\xaf\xd9\x96\xd0\xef\xe3\x80\x0d\x48\xc1\xca\x05\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x0c\x96"
          "\x39\x35\x8f\x7c\x6d\x1e\xe0\xdc\x08\x2d\xe4\xd9\x6e\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x0c\x96\x39\x35"
          "\x8f\x7c\x6d\x1e\xe0\xdc\x08\x2d\xe4\xd9\x6e",
          "\xd1\xbe\x74\x26\xcd\x12\x44\x6f\xe5\x2e\x8d\x45\x33\x1e\x08\x35", 1,
          32, 768 },
        { 96, 256, 128, 285,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xd6"
          "\x4a\xdd\x2a\xa3\xc5\xa3\x0a\x31\xd9\xe6\x5e\x90\xf9\x3a\xd1\xcb\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\xde\x9a\xea"
          "\xb8\x61\x44\xd5\x46\x48\x11\xb2\x37\x3b\xa4\xcc\x83\x24\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x64\x23\x74\x77\x71"
          "\xa1\xb2\x1c\x91\x7b\xdc\x31\x4c\xf8\x4d\xd6",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b"
          "\x3f\xa7\x96\x48\x0a\xb6\x2f\x98\x84\xdc\x7d\xfb\x4d\xaf\x88\xfa\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x85\x81"
          "\x79\xae\x42\x31\x1d\xac\xad\x2f\x32\x5a\x8d\x30\x07\xfa\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x85\x81\x79\xae"
          "\x42\x31\x1d\xac\xad\x2f\x32\x5a\x8d\x30\x07",
          "\x62\x63\x0c\x18\xde\x8c\x10\x87\x6a\xdb\x9f\x30\xf3\x00\x96\x3f", 1,
          32, 768 },
        { 96, 256, 128, 286,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xcc"
          "\x34\x92\x27\x2b\x8a\x4b\x11\x2a\x4e\x7d\x7c\xcf\x09\x26\x92\xce\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x30\xce\x67"
          "\x8e\x93\x75\xb2\xaf\x0b\x82\xc2\xd2\xfb\xd7\x92\x8c\x21\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x8a\x77\xf9\x41\x83"
          "\x90\xd5\xf5\xd2\xe8\xac\xd4\x8c\x8b\x13\xd9",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71"
          "\x41\xe8\x9b\xc0\x45\x5e\x34\x83\x13\x47\x5f\xa4\xbd\xb3\xcb\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x97\xd1\x0c"
          "\x4f\x5c\x73\x56\xf4\xef\x3e\x5f\xd7\x9a\xfe\x6e\x08\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x97\xd1\x0c\x4f\x5c"
          "\x73\x56\xf4\xef\x3e\x5f\xd7\x9a\xfe\x6e\x08",
          "\xfe\xb6\x41\x2b\x90\x31\xf0\x76\xed\xdc\xd9\x42\x6f\xff\x5b\x31", 1,
          32, 768 },
        { 96, 256, 128, 287,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x34\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x72"
          "\x2b\x65\x49\xc9\xdf\x0f\x4b\x04\xb5\xf7\x43\x22\x03\xfa\x54\xce\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x87\xde\x18"
          "\x6c\xd2\x8e\x43\x54\x4c\x73\xde\x62\x8f\xd1\xd6\x0e\x21\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x3d\x67\x86\xa3\xc2"
          "\x6b\x24\x0e\x95\x19\xb0\x64\xf8\x8d\x57\x5b",
          "\xd4\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf"
          "\x5e\x1f\xf5\x22\x10\x1a\x6e\xad\xe8\xcd\x60\x49\xb7\x6f\x0d\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\xc1\x73"
          "\xad\x1d\x88\xa7\x0f\xa8\xcf\x43\x67\xee\xf8\x2a\x8a\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\xc1\x73\xad\x1d"
          "\x88\xa7\x0f\xa8\xcf\x43\x67\xee\xf8\x2a\x8a",
          "\xda\xfd\xf4\x30\xc8\x12\x44\x83\xc1\x75\x40\x4b\x6b\xff\x5b\x41", 1,
          32, 768 },
        { 96, 256, 128, 288,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x3d\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xc5"
          "\x62\x96\x99\xcf\xd4\xd9\x03\x6c\xef\x47\x8e\xd7\x05\xbe\x56\x50\xf5"
          "\x75\x88\x2c\x38\x00\xf7\x57\xea\x6e\x0f\x8c\x6d\x47\xac\xc6\xe5\x51"
          "\xe0\xbe\x2f\xd7\x02\x9f\xa1\x34\x13\x52\xda\x1a\xc3",
          "\xdd\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x78"
          "\x17\xec\x25\x24\x1b\xcc\x26\xc5\xb2\x7d\xad\xbc\xb1\x2b\x0f\x61\xfa"
          "\x3a\x21\x71\x29\x33\x59\x7b\x1d\xa9\x16\x33\xf3\xe6\x47\x61\xfa\x3a"
          "\x21\x71\x29\x33\x59\x7b\x1d\xa9\x16\x33\xf3\xe6\x47",
          "\xf8\x80\x0c\x5b\x62\x83\xdd\xdf\xc4\x1f\x93\x5c\x01\xbd\x0d\x24", 1,
          32, 512 },
        { 96, 256, 128, 289,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x66"
          "\xd6\x24\xf2\x88\xf5\x29\x41\xca\x24\x86\x5c\xe9\x6f\x0d\x97\x36\xff"
          "\x33\xa2\x7c\x23\xf4\x97\x6f\xc7\x4f\x1f\xcd\x82\xf5\xcc\xa0\xef\x17"
          "\xca\xee\x34\x23\x62\xa7\x8c\x15\x03\x13\x35\xa8\xa3",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb"
          "\xa3\x5e\x4e\x63\x3a\x3c\x64\x63\x79\xbc\x7f\x82\xdb\x98\xce\x07\xf0"
          "\x7c\x0b\x21\x32\xc7\x39\x43\x30\x88\x06\x72\x1c\x54\x27\x07\xf0\x7c"
          "\x0b\x21\x32\xc7\x39\x43\x30\x88\x06\x72\x1c\x54\x27",
          "\x38\xbf\xb8\x31\x8c\x62\x7d\x86\xc3\x4b\xab\x1f\x1e\xbd\x0d\xb0", 1,
          32, 512 },
        { 96, 256, 128, 290,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\xf4\xeb\xbe\x3f\xca\x96\xbc\x48\x85\xb3\x55\x82\xc4\x3e\x0e\xb3\x58"
          "\x8a\x85\x43\x14\x30\xea\xda\x56\xa2\xc5\xdc\x94\x4b\x6a\xa6\xb4\x57"
          "\x0e\x84\x46\xe8\x86\xbc\xbf\xf8\x2a\x24\xf4\x9b\xe5\xed\x42\xe0\x94"
          "\x3e\x30\xf9\x1b\xa4\x1b\x43\x62\xfa\x9e\xd6\x03\x7b\x5b\x76\xf3\x75"
          "\x50\xf1\x25\x72\x04\x0a\x9b\xc1\xa7\x77\xed\xc5",
          "\x14\xca\xda\x5e\xfd\xdb\x04\x63\x51\xf2\x48\x7c\x56\xa6\xe4\xf6\xe5"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x58"
          "\x41\x2d\x1b\xf9\xb5\x12\x93\x0f\xed\x3d\x4b\x05\x44\x06\xe5\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x58\x41\x2d"
          "\x1b\xf9\xb5\x12\x93\x0f\xed\x3d\x4b\x05\x44\x06",
          "\xaf\x72\x93\xeb\x09\x95\x7d\x9d\xe7\x43\x2d\xd4\x13\x16\xf0\xe4", 1,
          32, 640 },
        { 96, 256, 128, 291,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1a\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x57"
          "\x1a\x3f\xca\x3c\xda\x7d\xef\x4c\x93\xd4\xa3\x82\xca\x3a\x57\xea\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\x76\xcd\xdb"
          "\xee\x2f\x18\x57\x76\x17\x4f\x6d\xf3\xbb\xe5\xb3\x81\x05\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\xcc\x74\x45\x21\x3f"
          "\xfd\x30\x2c\xce\x25\x03\xf5\xcc\xb9\x32\xd4",
          "\xfa\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea"
          "\x6f\x45\x76\xd7\x15\x68\xca\xe5\xce\xee\x80\xe9\x7e\xaf\x0e\xdb\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd1\xd2\xb0"
          "\x2f\xe0\x1e\xb3\x2d\xf3\xf3\xf0\xf6\xda\xcc\x4f\x05\xdb\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd1\xd2\xb0\x2f\xe0"
          "\x1e\xb3\x2d\xf3\xf3\xf0\xf6\xda\xcc\x4f\x05",
          "\xe1\x78\xb0\xd5\xeb\x9b\xc5\x51\xfa\x64\x5c\x49\xf9\xf1\x76\x67", 1,
          32, 768 },
        { 96, 256, 128, 292,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x1f\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\xbe"
          "\x31\xa5\x01\x53\x6a\x7c\x91\xe4\xa1\x02\xcc\x27\xcd\xfe\x09\xd2\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\xdd\x94\x16"
          "\xa1\x2e\x2f\x81\xbd\xee\x02\x3d\x46\x2f\xee\xf7\x83\x3d\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x67\x2d\x88\x6e\x3e"
          "\xca\xe6\xe7\x37\x68\x53\x40\x58\xb2\x76\xd6",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03"
          "\x44\xdf\xbd\xb8\xa5\x69\xb4\x4d\xfc\x38\xef\x4c\x79\x6b\x50\xe3\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\x8b\x7d"
          "\x60\xe1\x29\x65\xe6\x0a\xbe\xa0\x43\x4e\xc7\x0b\x07\xe3\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7a\x8b\x7d\x60\xe1"
          "\x29\x65\xe6\x0a\xbe\xa0\x43\x4e\xc7\x0b\x07",
          "\xbd\xbf\x63\xdb\x23\x7d\x19\x5e\xce\xfd\xc2\x51\xf5\xf1\x76\x77", 1,
          32, 768 },
        { 96, 256, 128, 293,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x03\xe7\x6f\x6f",
          "\xff\xff\xff\xff",
          "\x3e\xde\x9b\x9e\xc8\xb2\x47\xd4\x2b\xbe\xe2\x01\x6d\x67\x15\xba\x85"
          "\x67\xa7\xfd\xe8\x12\xa3\xaa\x2f\x55\x2a\x33\xc1\x71\x8c\x58\xe2\xf0"
          "\xb0\x56\xa2\xee\xcc\x51\xd3\x08\x38\xe6\x40\x61\x5e\x14\xbb\x87\x29"
          "\xfd\x14\x8f\x23\xb2\xa9\x16\xb7\xf4\x0f\x2f\x29\x81\x0d\xd1\x4d\xa7"
          "\xb4\xf7\x6f\x9f\x68\xfa\x89\x03\x13\x8d\x56\x3c\x01\x3e\xb7\x32\x04"
          "\x6a\x44\xe8\x70\x7c\xd9\xf2\x78\x73\xa8\xd4",
          "\xde\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38"
          "\x12\xdd\x41\x03\xdd\xb6\x8f\x86\x08\x10\x10\xaa\xc5\x19\x01\xd3\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x98\x42"
          "\x3c\xdb\x89\xc7\xe9\x4d\xaa\x2a\xf1\x6e\x06\xd5\x05\xd3\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x98\x42\x3c\xdb"
          "\x89\xc7\xe9\x4d\xaa\x2a\xf1\x6e\x06\xd5\x05",
          "\xb4\xcc\xb4\x22\xbc\x5f\x72\x64\xaf\xf7\x3f\x36\x75\xff\x5b\x19", 1,
          32, 768 },
        { 0, 256, 128, 294,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "", "", "", "", "", 0, 0, 0 },
        { 64, 256, 128, 295,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07", "", "", "", "", 0, 0, 0 },
        { 88, 256, 128, 296,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a", "", "", "", "", 0, 0,
          0 },
        { 104, 256, 128, 297,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c", "", "", "",
          "", 0, 0, 0 },
        { 112, 256, 128, 298,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d", "", "",
          "", "", 0, 0, 0 },
        { 128, 256, 128, 299,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "", "", "", "", 0, 0, 0 },
        { 160, 256, 128, 300,
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13",
          "", "", "", "", 0, 0, 0 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};
