/*****************************************************************************
 Copyright (c) 2022-2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* Vectors from https://github.com/google/wycheproof */
/* AES-GCM, 0.8r12 */
#include "aead_test.h"
const struct aead_test aes_gcm_test_json[] = {
        { 96, 128, 128, 1,
          "\x5b\x96\x04\xfe\x14\xea\xdb\xa9\x31\xb0\xcc\xf3\x48\x43\xda\xb9",
          "\x02\x83\x18\xab\xc1\x82\x40\x29\x13\x81\x41\xa2", "",
          "\x00\x1d\x0c\x23\x12\x87\xc1\x18\x27\x84\x55\x4c\xa3\xa2\x19\x08",
          "\x26\x07\x3c\xc1\xd8\x51\xbe\xff\x17\x63\x84\xdc\x98\x96\xd5\xff",
          "\x0a\x3e\xa7\xa5\x48\x7c\xb5\xf7\xd7\x0f\xb6\xc5\x8d\x03\x85\x54", 1,
          0, 128 },
        { 96, 128, 128, 2,
          "\x5b\x96\x04\xfe\x14\xea\xdb\xa9\x31\xb0\xcc\xf3\x48\x43\xda\xb9",
          "\x92\x1d\x25\x07\xfa\x80\x07\xb7\xbd\x06\x7d\x34",
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x00\x1d\x0c\x23\x12\x87\xc1\x18\x27\x84\x55\x4c\xa3\xa2\x19\x08",
          "\x49\xd8\xb9\x78\x3e\x91\x19\x13\xd8\x70\x94\xd1\xf6\x3c\xc7\x65",
          "\x1e\x34\x8b\xa0\x7c\xca\x2c\xf0\x4c\x61\x8c\xb4\xd4\x3a\x5b\x92", 1,
          128, 128 },
        { 96, 128, 128, 3,
          "\xaa\x02\x3d\x04\x78\xdc\xb2\xb2\x31\x24\x98\x29\x3d\x9a\x91\x29",
          "\x04\x32\xbc\x49\xac\x34\x41\x20\x81\x28\x81\x27",
          "\xaa\xc3\x92\x31\x12\x98\x72\xa2",
          "\x20\x35\xaf\x31\x3d\x13\x46\xab\x00\x15\x4f\xea\x78\x32\x21\x05",
          "\xee\xa9\x45\xf3\xd0\xf9\x8c\xc0\xfb\xab\x47\x2a\x0c\xf2\x4e\x87",
          "\x4b\xb9\xb4\x81\x25\x19\xda\xdf\x9e\x12\x32\x01\x6d\x06\x81\x33", 1,
          64, 128 },
        { 96, 128, 128, 4,
          "\xbe\xdc\xfb\x5a\x01\x1e\xbc\x84\x60\x0f\xcb\x29\x6c\x15\xaf\x0d",
          "\x43\x8a\x54\x7a\x94\xea\x88\xdc\xe4\x6c\x6c\x85", "", "", "",
          "\x96\x02\x47\xba\x5c\xde\x02\xe4\x1a\x31\x3c\x4c\x01\x36\xed\xc3", 1,
          0, 0 },
        { 96, 128, 128, 5,
          "\x38\x4e\xa4\x16\xac\x3c\x2f\x51\xa7\x6e\x7d\x82\x26\x34\x6d\x4e",
          "\xb3\x0c\x08\x47\x27\xad\x1c\x59\x2a\xc2\x1d\x12", "", "\x35",
          "\x54",
          "\x7c\x1e\x4a\xe8\x8b\xb2\x7e\x56\x38\x34\x3c\xb9\xfd\x3f\x63\x37", 1,
          0, 8 },
        { 96, 128, 128, 6,
          "\xca\xe3\x1c\xd9\xf5\x55\x26\xeb\x03\x82\x41\xfc\x44\xca\xc1\xe5",
          "\xb5\xe0\x06\xde\xd5\x53\x11\x0e\x6d\xc5\x65\x29", "",
          "\xd1\x09\x89\xf2\xc5\x2e\x94\xad",
          "\xa0\x36\xea\xd0\x31\x93\x90\x3f",
          "\x3b\x62\x69\x40\xe0\xe9\xf0\xcb\xea\x8e\x18\xc4\x37\xfd\x60\x11", 1,
          0, 64 },
        { 96, 128, 128, 7,
          "\xdd\x61\x97\xcd\x63\xc9\x63\x91\x9c\xf0\xc2\x73\xef\x6b\x28\xbf",
          "\xec\xb0\xc4\x2f\x70\x00\xef\x0e\x6f\x95\xf2\x4d", "",
          "\x4d\xcc\x14\x85\x36\x58\x66\xe2\x5a\xc3\xf2\xca\x6a\xba\x97",
          "\x8a\x99\x92\x38\x8e\x73\x5f\x80\xee\x18\xf4\xa6\x3c\x10\xad",
          "\x14\x86\xa9\x1c\xcc\xf9\x2c\x9a\x5b\x00\xf7\xb0\xe0\x34\x89\x1c", 1,
          0, 120 },
        { 96, 128, 128, 8,
          "\xff\xdf\x42\x28\x36\x1e\xa1\xf8\x16\x58\x52\x13\x6b\x34\x80\xf7",
          "\x0e\x16\x66\xf2\xdc\x65\x2f\x77\x08\xfb\x8f\x0d", "",
          "\x25\xb1\x2e\x28\xac\x0e\xf6\xea\xd0\x22\x6a\x3b\x22\x88\xc8\x00",
          "\xf7\xbd\x37\x9d\x13\x04\x77\x17\x6b\x8b\xb3\xcb\x23\xdb\xbb\xaa",
          "\x1e\xe6\x51\x3c\xe3\x0c\x78\x73\xf5\x9d\xd4\x35\x0a\x58\x8f\x42", 1,
          0, 128 },
        { 96, 128, 128, 9,
          "\xc1\x5e\xd2\x27\xdd\x2e\x23\x7e\xcd\x08\x7e\xaa\xaa\xd1\x9e\xa4",
          "\x96\x5f\xf6\x64\x31\x16\xac\x14\x43\xa2\xde\xc7", "",
          "\xfe\xe6\x2f\xde\x97\x3f\xe0\x25\xad\x6b\x32\x2d\xcd\xf3\xc6\x3f"
          "\xc7",
          "\x0d\xe5\x1f\xe4\xf7\xf2\xd1\xf0\xf9\x17\x56\x9f\x5c\x6d\x1b\x00"
          "\x9c",
          "\x6c\xd8\x52\x14\x22\xc0\x17\x7e\x83\xef\x1b\x7a\x84\x5d\x97\xdb", 1,
          0, 136 },
        { 96, 128, 128, 10,
          "\xa8\xee\x11\xb2\x6d\x7c\xeb\x7f\x17\xea\xa1\xe4\xb8\x3a\x2c\xf6",
          "\xfb\xbc\x04\xfd\x6e\x02\x5b\x71\x93\xeb\x57\xf6", "",
          "\xc0\x8f\x08\x5e\x6a\x9e\x0e\xf3\x63\x62\x80\xc1\x1e\xcf\xad\xf0\xc1"
          "\xe7\x29\x19\xff\xc1\x7e\xaf",
          "\x7c\xd9\xf4\xe4\xf3\x65\x70\x4f\xff\x3b\x99\x00\xaa\x93\xba\x54\xb6"
          "\x72\xba\xc5\x54\x27\x56\x50",
          "\xf4\xeb\x19\x32\x41\x22\x6d\xb0\x17\xb3\x2e\xc3\x8c\xa4\x72\x17", 1,
          0, 192 },
        { 96, 128, 128, 11,
          "\x28\xff\x3d\xef\x08\x17\x93\x11\xe2\x73\x4c\x6d\x1c\x4e\x28\x71",
          "\x32\xbc\xb9\xb5\x69\xe3\xb8\x52\xd3\x7c\x76\x6a", "\xc3",
          "\xdf\xc6\x1a\x20\xdf\x85\x05\xb5\x3e\x3c\xd5\x9f\x25\x77\x0d\x50\x18"
          "\xad\xd3\xd6",
          "\xf5\x8d\x45\x32\x12\xc2\xc8\xa4\x36\xe9\x28\x36\x72\xf5\x79\xf1\x19"
          "\x12\x29\x78",
          "\x59\x01\x13\x1d\x07\x60\xc8\x71\x59\x01\xd8\x81\xfd\xfd\x3b\xc0", 1,
          8, 160 },
        { 96, 128, 128, 12,
          "\xe6\x3a\x43\x21\x6c\x08\x86\x72\x10\xe2\x48\x85\x9e\xb5\xe9\x9c",
          "\x9c\x3a\x42\x63\xd9\x83\x45\x66\x58\xaa\xd4\xb1",
          "\x83\x4a\xfd\xc5\xc7\x37\x18\x6b",
          "\xb1\x4d\xa5\x6b\x04\x62\xdc\x05\xb8\x71\xfc\x81\x52\x73\xff\x48\x10"
          "\xf9\x2f\x4b",
          "\xbf\x86\x46\x16\xc2\x34\x75\x09\xca\x9b\x10\x44\x63\x79\xb9\xbd\xbb"
          "\x3b\x8f\x64",
          "\xa9\x7d\x25\xb4\x90\x39\x0b\x53\xc5\xdb\x91\xf6\xee\x2a\x15\xb8", 1,
          64, 160 },
        { 96, 128, 128, 13,
          "\x38\x44\x98\x90\x23\x4e\xb8\xaf\xab\x0b\xbf\x82\xe2\x38\x54\x54",
          "\x33\xe9\x06\x58\x41\x6e\x7c\x1a\x7c\x00\x5f\x11",
          "\x40\x20\x85\x5c\x66\xac\x45\x95\x05\x83\x95\xf3\x67\x20\x1c\x4c",
          "\xf7\x62\x77\x6b\xf8\x31\x63\xb3\x23\xca\x63\xa6\xb3\xad\xea\xc1\xe1"
          "\x35\x72\x62",
          "\xa6\xf2\xef\x3c\x7e\xf7\x4a\x12\x6d\xd2\xd5\xf6\x67\x39\x64\xe2\x7d"
          "\x5b\x34\xb6",
          "\xb8\xbb\xdc\x4f\x50\x14\xbc\x75\x2c\x8b\x4e\x9b\x87\xf6\x50\xa3", 1,
          128, 160 },
        { 96, 128, 128, 14,
          "\x6a\x68\x67\x1d\xfe\x32\x3d\x41\x98\x94\x38\x1f\x85\xeb\x63\xfd",
          "\x9f\x0d\x85\xb6\x05\x71\x1f\x34\xcd\x2a\x35\xba",
          "\x76\xeb\x5f\x14\x72\x50\xfa\x3c\x12\xbf\xf0\xa6\xe3\x93\x4a\x0b\x16"
          "\x86\x0c\xf1\x16\x46\x77\x3b",
          "\x0f\xc6\x78\x99\xc3\xf1\xbb\xe1\x96\xd9\x0f\x1e\xca\x37\x97\x38\x92"
          "\x30\xaa\x37",
          "\xbd\x64\x80\x2c\xfe\xba\xeb\x48\x7d\x3a\x8f\x76\xce\x94\x3a\x37\xb3"
          "\x47\x2d\xd5",
          "\xfc\xe9\xa5\xb5\x30\xc7\xd7\xaf\x71\x8b\xe1\xec\x0a\xe9\xed\x4d", 1,
          192, 160 },
        { 96, 128, 128, 15,
          "\xe1\x22\x60\xfc\xd3\x55\xa5\x1a\x0d\x01\xbb\x1f\x6f\xa5\x38\xc2",
          "\x5d\xfc\x37\x36\x6f\x56\x88\x27\x51\x47\xd3\xf9", "",
          "\xd9\x02\xde\xea\xb1\x75\xc0\x08\x32\x9a\x33\xbf\xac\xcd\x5c\x0e\xb3"
          "\xa6\xa1\x52\xa1\x51\x0e\x7d\xb0\x4f\xa0\xaf\xf7\xce\x42\x88\x53\x0d"
          "\xb6\xa8\x0f\xa7\xfe\xa5\x82\xaa\x7d\x46\xd7\xd5\x6e\x70\x8d\x2b\xb0"
          "\xc5\xed\xd3\xd2\x66\x48\xd3\x36\xc3\x62\x0e\xa5\x5e",
          "\xd3\x3b\xf6\x72\x2f\xc2\x93\x84\xfa\xd7\x5f\x99\x02\x48\xb9\x52\x8e"
          "\x09\x59\xaa\x67\xec\x66\x86\x9d\xc3\x99\x6c\x67\xa2\xd5\x59\xe7\xd7"
          "\x7c\xe5\x95\x5f\x8c\xad\x2a\x4d\xf5\xfd\xc3\xac\xcc\xaf\xa7\xbc\x0d"
          "\xef\x53\xd8\x48\x11\x12\x56\x90\x3e\x5a\xdd\x04\x20",
          "\x8b\xc8\x33\xde\x51\x08\x63\xb4\xb4\x32\xc3\xcb\xf4\x5a\xa7\xcc", 1,
          0, 512 },
        { 96, 128, 128, 16,
          "\x3c\x55\xf8\x8e\x9f\xaa\x0d\x68\xab\x50\xd0\x2b\x47\x16\x12\x76",
          "\xd7\x67\xc4\x8d\x20\x37\xb4\xbd\x2c\x23\x1b\xbd", "",
          "\x5d\x6a\xdd\x48\xe7\xa5\x70\x4e\x54\xf9\xc2\x82\x9a\x9b\x42\x83\xdc"
          "\xe0\xd3\xa6\x5b\x13\x3e\xba\x37\x93\xc4\xfb\xfa\x1d\x8e\x3a\x25\x39"
          "\xd0\xd4\xf3\xde\x38\x15\x98\xce\x5b\x23\x60\x17\x3f\xbd\x14\x94\x76"
          "\xc3\x16\x92\xc5\xd6\xe8\x72\xfc\xe4\x02\x19\x37\x89\x49\xc2\xe7\x0b"
          "\x5f\x1b\x9f\x0a\x1d\x5f\x38\x35\x2a\xd8\x14\xb2\xa0\x35\xbb\x3f\x3f"
          "\x26\x42\x5d\x83\x1a\x2f\x7a\x5e\x65\xc5\xdf\xcd\x91\xa3\x15\xc2\xb2"
          "\x4f\x53\xa6\x62\x60\x5e\xa4\x08\x57\xdd\x98\x0e\x9b\xe5\xcd\xad\x00"
          "\x0c\x56\x9f\x2d\x20\x4d\x4b\xd3\xb0",
          "\x17\xd7\x2d\x90\xbd\x23\xe0\x76\xd8\x36\x4a\x87\xec\xb9\xac\x58\xac"
          "\xc5\xde\x46\x29\xbf\xd5\x90\x40\x9b\x8b\xf1\xfc\xd3\xa2\xf6\x02\x73"
          "\x1b\x46\x14\xce\xc1\x5e\x77\x3e\xa6\x5a\x65\xe7\x21\x09\x94\x25\x6b"
          "\xf5\x45\x0a\x25\xac\xb5\x27\x26\x9c\x06\x5f\x2e\x2f\x22\x79\xd1\xfe"
          "\x8b\x3e\xda\x98\xdc\xf8\x7b\x34\x8f\x15\x28\x37\x7b\xbd\xd2\x58\x35"
          "\x5d\x46\xe0\x35\x33\x04\x83\xd8\x09\x7e\x80\xc7\xde\x9b\xbb\x60\x6d"
          "\xdf\x72\x3f\x29\x09\x21\x7f\xfd\xd1\x8e\x8b\xdb\xd7\xb0\x80\x62\xf1"
          "\xdc\xba\x96\x0e\x5c\x0d\x29\x0f\x5f",
          "\x09\x0b\x8c\x2e\xc9\x8e\x41\x16\x18\x6d\x0e\x5f\xbe\xfe\xb9\xc2", 1,
          0, 1024 },
        { 96, 128, 128, 17,
          "\xa2\x94\xe7\x0f\xa2\xac\x10\xa1\xfb\x00\xc5\x88\xb8\x88\xb6\x73",
          "\xdf\xe2\x0d\x1c\x43\x50\xe6\x23\x5d\x98\x7a\xf1", "",
          "\x6e\xd1\xd7\xd6\x18\xd1\x58\x74\x1f\x52\x07\x80\x06\xf2\x84\x94\xba"
          "\x72\xa2\x45\x4f\x27\x16\x0a\xe8\x72\x27\x93\xfc\xeb\xc5\x38\xeb\xc2"
          "\xf6\x7c\x3a\xce\x3e\x0f\xe7\xc4\x7b\x9e\x74\xe0\x81\x18\x2b\x47\xc9"
          "\x30\x14\x4e\x3f\xc8\x0d\x0a\xd5\x06\x11\xc3\xaf\xcf\xe2\xdb\xc5\x27"
          "\x9e\xdb\xbb\xa0\x87\xc0\xe3\x90\x35\x5f\x3d\xaf\xfc\xd2\x5a\xd4\xde"
          "\xa0\x07\xc2\x84\xad\x92\xe7\xfc\xbe\xcb\x43\x8f\xb6\x06\x23\xff\x89"
          "\xa5\x99\xdc\xa2\xaa\xc1\x41\xb2\x66\x51\x38\x6c\xa5\x5b\x73\x9b\x94"
          "\x90\x1e\xf6\xdb\x60\x9c\x34\x4d\x8a\xcf\x45\x44\x56\x8e\x31\xbb\x09"
          "\x36\x11\x12\x75\x4b\x1c\x0c\x6a\x3c\x87\x5b\xd9\x45\x3b\x0e\xe0\x08"
          "\x14\x12\x15\x13\x98\xa2\x94\xec\xad\x75\xad\xd5\x21\x61\x1d\xb5\x28"
          "\x8b\x60\xac\x3c\x01\x28\xf6\xe9\x43\x66\xb6\x9e\x65\x9e\x6a\xa6\x6f"
          "\x05\x8a\x3a\x35\x71\x06\x4e\xdb\xb0\xf0\x5c\x11\xe5\xdd\xe9\x38\xfb"
          "\x46\xc3\x93\x5d\xd5\x19\x3a\x4e\x56\x64\x68\x8f\x0a\xe6\x7c\x29\xb7"
          "\xcc\x49\xa7\x96\x31\x40\xf8\x2e\x31\x1a\x20\xc9\x8c\xd3\x4f\xbc\xab"
          "\x7b\x4b\x51\x5a\xe8\x65\x57\xe6\x20\x99\xe3\xfc\x37\xb9\x59\x5c\x85"
          "\xa7\x5c",
          "\x5b\xc6\xdb\xaf\xc4\x01\x10\x1c\x7a\x08\xc8\x1d\x6c\x27\x91\xaa\x14"
          "\x7c\xe0\x93\xaa\xd1\x72\xbe\x18\x37\x9c\x74\x73\x84\xa5\x4a\x41\xa7"
          "\x47\xba\x95\x5c\xad\xe8\xfd\xfb\x89\x67\xaa\x80\x8b\x43\xfe\xe3\xd7"
          "\x57\xcc\x80\xf1\x11\x63\xb8\x00\xe5\xe5\x9d\xf9\x32\x75\x7f\x76\xc4"
          "\x0b\x3d\x9c\xba\x44\x9a\xaf\x11\xe4\xf8\x0e\x00\x3b\x1f\x38\x4e\xaf"
          "\xa4\xf7\x6e\x81\xb1\x3c\x09\xec\x1a\xd8\x8e\x76\x50\xc7\x50\xd4\x42"
          "\xfe\x46\xd2\x25\xa3\x73\xe8\xa1\xb5\x64\xb4\x91\x5a\x5c\x6c\x51\x3c"
          "\xfd\xfa\x22\xd9\x29\xd5\x74\x1c\xa5\xeb\xef\xae\xdc\xba\x63\x6c\x7c"
          "\x3b\xbe\xf1\x88\x63\xfd\xc1\x26\xb4\xb4\x51\x61\x10\x49\xc3\x5d\x81"
          "\x4f\xc2\xeb\x7e\x4b\x8f\x1a\x89\x95\xec\xb4\xa3\xc8\x66\x52\xa0\x68"
          "\xc0\xb2\xa3\xe1\xc5\x94\x1d\x59\xc2\x10\xb4\x58\xd5\xd5\xd3\xb0\x64"
          "\x20\xec\x20\x53\x46\x5c\xcc\xec\xa7\xc2\x0f\x67\x40\x49\x85\x46\x03"
          "\x79\xe2\xee\x80\x6a\x46\xe8\x40\x9d\xfa\xb2\xe0\xdd\x67\xea\x3c\xf4"
          "\x6d\x5a\xd4\xeb\x78\x75\x68\x27\x35\x8c\x3e\xf1\xfd\xbd\x07\xc3\x38"
          "\x34\xf3\xd9\xec\xa3\xff\x13\xb7\x44\xa0\x10\x59\xa6\xc1\x7a\x31\x5a"
          "\x8f\xd4",
          "\xc7\x58\x7e\x7d\xa4\x1b\xed\x68\x2c\x37\x37\x7e\xa4\x32\x40\x29", 1,
          0, 2056 },
        { 96, 128, 128, 18,
          "\xc4\xb0\x34\x35\xb9\x1f\xc5\x2e\x09\xef\xf2\x7e\x4d\xc3\xfb\x42",
          "\x50\x46\xe7\xe0\x8f\x07\x47\xe1\xef\xcc\xb0\x9e",
          "\x75\xfc\x90\x78\xb4\x88\xe9\x50\x3d\xcb\x56\x8c\x88\x2c\x9e\xec\x24"
          "\xd8\x0b\x04\xf0\x95\x8c\x82\xaa\xc8\x48\x4f\x02\x5c\x90\x43\x41\x48"
          "\xdb\x8e\x9b\xfe\x29\xc7\xe0\x71\xb7\x97\x45\x7c\xb1\x69\x5a\x5e\x5a"
          "\x63\x17\xb8\x36\x90\xba\x05\x38\xfb\x11\xe3\x25\xca",
          "\x8e\x88\x7b\x22\x4e\x8b\x89\xc8\x2e\x9a\x64\x1c\xf5\x79\xe6\x87\x9e"
          "\x11\x11\xc7",
          "\xb6\x78\x68\x12\x57\x4a\x25\x4e\xb4\x3b\x1c\xb1\xd1\x75\x35\x64\xc6"
          "\xb5\x20\xe9",
          "\xad\x8c\x09\x61\x0d\x50\x8f\x3d\x0f\x03\xcc\x52\x3c\x0d\x5f\xcc", 1,
          512, 160 },
        { 96, 128, 128, 19,
          "\x7e\x37\xd5\x6e\x6b\x1d\x01\x72\xd4\x0d\x64\xd6\x11\x1d\xd4\x24",
          "\x51\x7c\x55\xc2\xec\x9b\xfe\xa9\x0a\xdd\xc2\xbd",
          "\x8e\xd8\xa9\xbe\x4c\x3d\x32\xa5\x09\x84\x34\xee\x5c\x0c\x4f\xc2\x0f"
          "\x78\xef\x5e\x25\xed\x8b\x72\xa8\x40\xa4\x63\xe3\x6b\x67\xb8\x81\xe0"
          "\x48\xb5\xe4\x9f\x51\x5b\x25\x41\xad\x5c\xe4\xeb\xb3\xa9\x17\xc1\x6b"
          "\xcd\xc0\xdc\x3c\xb5\x2b\xb4\xed\x5a\x1d\xff\xcf\x1e\x18\x66\x54\x4e"
          "\x8d\xb1\x03\xb2\xad\x99\xc6\xfa\x6e\x7d\xe1\xd8\xb4\x5b\xff\x57\xec"
          "\x87\x2f\x1c\xfc\x78\xb0\xe4\x87\x0f\x6f\x20\x0f\xf1\x29\x1c\xae\x03"
          "\x3d\xef\xc3\x32\x7b\xa8\x27\x92\xba\x43\x8e\x35\xc4\xbf\xbb\x68\x4f"
          "\xec\x5c\xe5\xe3\xae\x16\x7d\x01\xd7",
          "\x6a\x7d\xea\x03\xc1\xbb\xa7\x0b\xe8\xc7\x3d\xa4\x7d\x5e\xe0\x6d\x72"
          "\xa2\x74\x30",
          "\xcf\xb6\x31\x79\x07\x67\xd0\x64\x5d\x8e\xc6\xf2\x3b\xf7\xfa\x8b\x19"
          "\xce\x79\xee",
          "\xc5\x76\x7d\xda\xa7\x47\x15\x84\x46\x23\x17\x66\xbd\x20\x49\x0c", 1,
          1024, 160 },
        { 96, 128, 128, 20,
          "\x30\x76\x74\x14\x08\xf7\x34\xce\x25\xd4\x8f\x98\x2e\x8b\x84\x4b",
          "\xa2\x71\x2e\xac\x5e\x06\xd3\xcc\x28\x64\xaa\x8b",
          "\x18\x52\x6e\x4e\xfd\x99\x5a\x0b\xf6\x40\x5d\x9f\x90\x67\x25\xc2\x90"
          "\x27\x89\x58\xd4\x95\x54\x97\x4d\x8f\xe0\x25\xe7\x86\x0d\xaa\x22\x5c"
          "\x12\x85\xb0\x57\x39\x16\xa4\xb6\x74\x1f\x7c\xc2\xe2\x9c\xe4\xe5\x25"
          "\xe1\x2f\x43\x6c\xb7\xce\x0a\xd4\x7d\xf3\xd0\xf5\xbd\x80\xfb\x27\xe4"
          "\x76\x35\xa4\x98\x5f\xda\xed\xf0\xe8\x21\xf1\xc8\x95\x99\x85\xca\xc4"
          "\x9c\x97\xa4\xa0\x24\x38\xd9\x2b\x4a\xfd\x4c\x85\x5d\xcc\x7e\xf4\x1e"
          "\xcf\xc3\x68\x66\x33\x4f\xcc\x05\xb2\xbb\x93\xef\x13\xf0\x0c\x5e\xa9"
          "\xb9\x21\xe8\xa5\x19\xd7\x7f\x64\x8e\x0e\xfe\x9b\x5a\x62\x30\x5a\x2e"
          "\xcf\x7d\x49\x99\x66\x3a\x6d\xdf\xca\x51\x7f\x1f\x36\xf0\x89\x9b\x0b"
          "\xde\xf9\xf4\x33\xc4\xbb\x26\x63\xc0\xcc\x1b\xb6\x16\xe7\xd1\x94\x9e"
          "\x52\x2b\xec\x85\x48\x5d\x37\x1d\x11\x34\xc9\x0e\xed\xe7\x5e\x86\x5d"
          "\xc7\xbe\x40\x5b\x54\xc3\x3f\x0a\xcb\xac\xe6\xcf\x78\x0c\x78\x03\x5b"
          "\x80\x35\xb6\xea\x3f\x56\x2a\x8d\x30\xa1\x56\xc1\x99\xfd\xaf\xd2\x5b"
          "\xe0\x6e\xe8\x95\x58\x11\x95\xef\x12\x5c\xb4\xe6\x29\xe4\xf1\x8e\x0b"
          "\xee\x97\x9d\x31\x51\x38\x96\xdb\x84\x66\xe4\x48\xe6\xb4\x60\x0a\x31"
          "\x67\x57",
          "\x41\x4e\xc6\xb1\x49\xe5\x47\x35\x30\x2d\xad\xa8\x88\xb9\x8b\x7f\xdb"
          "\x4c\x12\x7c",
          "\xe4\xd3\xf4\x89\x8c\xb3\xd9\x73\x26\x41\xd1\xf8\xd9\xd8\x89\xb2\xc9"
          "\x8a\xf9\x30",
          "\x76\xd4\xfb\xb6\x9d\x52\x9b\x64\x17\x5b\x32\x8b\xe0\x0b\x10\x68", 1,
          2056, 160 },
        { 96, 128, 128, 21,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "",
          "\xeb\xd4\xa3\xe1\x0c\xf6\xd4\x1c\x50\xae\xae\x00\x75\x63\xb0\x72",
          "\xf6\x2d\x84\xd6\x49\xe5\x6b\xc8\xcf\xed\xc5\xd7\x4a\x51\xe2\xf7",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          0, 128 },
        { 96, 128, 128, 22,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", "",
          "\xd5\x93\xc4\xd8\x22\x4f\x1b\x10\x0c\x35\xe4\xf6\xc4\x00\x65\x43",
          "\x43\x1f\x31\xe6\x84\x09\x31\xfd\x95\xf9\x4b\xf8\x82\x96\xff\x69",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          0, 128 },
        { 96, 128, 128, 23,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd9\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 24,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xda\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 25,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\x58\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 26,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x85\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 27,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\x3c\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 28,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x33\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 29,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x30\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 30,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\x69\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 31,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x89\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 32,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x08\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 33,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xe7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 34,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7b\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 35,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x87\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 36,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x84\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 37,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x06\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 38,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x82", 0,
          0, 128 },
        { 96, 128, 128, 39,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x81", 0,
          0, 128 },
        { 96, 128, 128, 40,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\xc3", 0,
          0, 128 },
        { 96, 128, 128, 41,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\xe9\x88\xc7\x7a\xd3\x86\x3e\x60\x03", 0,
          0, 128 },
        { 96, 128, 128, 42,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd9\x84\x7d\xbc\x32\x6a\x06\xe9\x89\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 43,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\x3c\x32\x6a\x06\x69\x88\xc7\x7a\xd3\x86\x3e\x60\x83", 0,
          0, 128 },
        { 96, 128, 128, 44,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd8\x84\x7d\xbc\x32\x6a\x06\x69\x88\xc7\x7a\xd3\x86\x3e\x60\x03", 0,
          0, 128 },
        { 96, 128, 128, 45,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\x27\x7b\x82\x43\xcd\x95\xf9\x16\x77\x38\x85\x2c\x79\xc1\x9f\x7c", 0,
          0, 128 },
        { 96, 128, 128, 46,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          0, 128 },
        { 96, 128, 128, 47,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          0, 128 },
        { 96, 128, 128, 48,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\x58\x04\xfd\x3c\xb2\xea\x86\x69\x08\x47\xfa\x53\x06\xbe\xe0\x03", 0,
          0, 128 },
        { 96, 128, 128, 49,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x15\x6d\x08\x1e\xd6\xb6\xb5\x5f\x46\x12\xf0\x21\xd8\x7b\x39",
          "\xd9\x85\x7c\xbd\x33\x6b\x07\xe8\x89\xc6\x7b\xd2\x87\x3f\x61\x82", 0,
          0, 128 },
        { 64, 128, 128, 50,
          "\xaa\x02\x3d\x04\x78\xdc\xb2\xb2\x31\x24\x98\x29\x3d\x9a\x91\x29",
          "\x04\x32\xbc\x49\xac\x34\x41\x20",
          "\xaa\xc3\x92\x31\x12\x98\x72\xa2",
          "\x20\x35\xaf\x31\x3d\x13\x46\xab\x00\x15\x4f\xea\x78\x32\x21\x05",
          "\x64\xc3\x6b\xb3\xb7\x32\x03\x4e\x3a\x7d\x04\xef\xc5\x19\x77\x85",
          "\xb7\xd0\xdd\x70\xb0\x0d\x65\xb9\x7c\xfd\x08\x0f\xf4\xb8\x19\xd1", 1,
          64, 128 },
        { 64, 128, 128, 51,
          "\xf3\x43\x47\x25\xc8\x2a\x7f\x8b\xb0\x7d\xf1\xf8\x12\x2f\xb6\xc9",
          "\x28\xe9\xb7\x85\x17\x24\xba\xe3", "", "", "",
          "\x44\xac\xa0\x0f\x42\xe4\x19\x9b\x82\x9a\x55\xe6\x9b\x07\x3d\x9e", 1,
          0, 0 },
        { 64, 128, 128, 52,
          "\xde\xb6\x22\x33\x55\x9b\x57\x47\x66\x02\xb5\xad\xac\x57\xc7\x7f",
          "\xd0\x84\x54\x7d\xe5\x5b\xbc\x15", "",
          "\xd8\x98\x6d\xf0\x24\x1e\xd3\x29\x75\x82\xc0\xc2\x39\xc7\x24\xcb",
          "\x03\xe1\xa1\x68\xa7\xe3\x77\xa9\x13\x87\x9b\x29\x6a\x1b\x5f\x9c",
          "\x32\x90\xaa\x95\xaf\x50\x5a\x74\x2f\x51\x7f\xab\xcc\x9b\x20\x94", 1,
          0, 128 },
        { 128, 128, 128, 53,
          "\x20\x34\xa8\x25\x47\x27\x6c\x83\xdd\x32\x12\xa8\x13\x57\x2b\xce",
          "\x32\x54\x20\x2d\x85\x47\x34\x81\x23\x98\x12\x7a\x3d\x13\x44\x21",
          "\x1a\x02\x93\xd8\xf9\x02\x19\x05\x89\x02\x13\x90\x13\x90\x81\x90\xbc"
          "\x49\x08\x90\xd3\xff\x12\xa3",
          "\x02\xef\xd2\xe5\x78\x23\x12\x82\x7e\xd5\xd2\x30\x18\x9a\x2a\x34\x2b"
          "\x27\x7c\xe0\x48\x46\x21\x93",
          "\x64\x06\x9c\x2d\x58\x69\x05\x61\xf2\x7e\xe1\x99\xe6\xb4\x79\xb6\x36"
          "\x9e\xec\x68\x86\x72\xbd\xe9",
          "\x9b\x7a\xba\xdd\x6e\x69\xc1\xd9\xec\x92\x57\x86\x53\x4f\x50\x75", 1,
          192, 192 },
        { 128, 128, 128, 54,
          "\xb6\x7b\x1a\x6e\xfd\xd4\x0d\x37\x08\x0f\xbe\x8f\x80\x47\xae\xb9",
          "\xfa\x29\x4b\x12\x99\x72\xf7\xfc\x5b\xbd\x5b\x96\xbb\xa8\x37\xc9",
          "", "", "",
          "\xa2\xcf\x26\x48\x15\x17\xec\x25\x08\x5c\x5b\x17\xd0\x78\x61\x83", 1,
          0, 0 },
        { 128, 128, 128, 55,
          "\x20\x9e\x6d\xbf\x2a\xd2\x6a\x10\x54\x45\xfc\x02\x07\xcd\x9e\x9a",
          "\x94\x77\x84\x9d\x6c\xcd\xfc\xa1\x12\xd9\x2e\x53\xfa\xe4\xa7\xca",
          "", "\x01", "\xfd",
          "\x03\x2d\xf7\xbb\xa5\xd8\xea\x1a\x14\xf1\x6f\x70\xbd\x0e\x14\xec", 1,
          0, 8 },
        { 128, 128, 128, 56,
          "\xa5\x49\x44\x2e\x35\x15\x40\x32\xd0\x7c\x86\x66\x00\x6a\xa6\xa2",
          "\x51\x71\x52\x45\x68\xe8\x1d\x97\xe8\xc4\xde\x4b\xa5\x6c\x10\xa0",
          "", "\x11\x82\xe9\x35\x96\xca\xc5\x60\x89\x46\x40\x0b\xc7\x3f\x3a",
          "\x2f\x33\x30\x87\xbd\xca\x58\x21\x9f\x9b\xfc\x27\x3e\x45\xcc",
          "\xe0\x6d\x1e\xf4\x73\x13\x29\x57\xad\x37\xea\xef\x29\x73\x3c\xa0", 1,
          0, 120 },
        { 128, 128, 128, 57,
          "\xcf\xb4\xc2\x6f\x12\x6f\x6a\x0a\xcb\x8e\x4e\x22\x0f\x6c\x56\xcd",
          "\x12\x75\x11\x54\x99\xae\x72\x22\x68\x51\x5b\xf0\xc1\x64\xb4\x9c",
          "",
          "\x09\xdf\xd7\xf0\x80\x27\x52\x57\xcf\x97\xe7\x6f\x96\x6b\x1a\xd9",
          "\xa7\x80\xbd\x01\xc8\x08\x85\x15\x6c\x88\xa9\x73\x26\x4c\x8e\xe5",
          "\x2a\xde\xff\xa6\x82\xc8\xd8\xa8\x1f\xad\xa7\xd9\xfc\xdd\x2e\xe2", 1,
          0, 128 },
        { 128, 128, 128, 58,
          "\x0b\x11\xef\x3a\x08\xc0\x29\x70\xf7\x42\x81\xc8\x60\x69\x1c\x75",
          "\x95\xc1\xdd\x8c\x0f\x17\x05\xec\xe6\x89\x37\x90\x1f\x7a\xdd\x7b",
          "",
          "\xf6\x93\xd4\xed\xd8\x25\xdb\xb0\x61\x8d\x91\x11\x31\x28\x88\x0d\xbe"
          "\xbb\x23\xe2\x5d\x00\xed\x1f\x07\x7d\x87\x0b\xe9\xcc\x75\x36",
          "\x7e\x47\xe1\x0f\xe3\xc6\xfb\xfa\x38\x17\x70\xea\xf5\xd4\x8d\x14\x82"
          "\xe7\x1e\x0c\x44\xdf\xf1\xe3\x0c\xa6\xf9\x5d\x92\x05\x20\x84",
          "\xd0\x14\x44\xfa\x5d\x9c\x49\x96\x29\xd1\x74\xff\x39\x27\xa1\xac", 1,
          0, 256 },
        { 128, 128, 128, 59,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xf9\x5f\xde\x4a\x75\x19\x13\x20\x2a\xee\xee\x32\xa0\xb5\x57\x53",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x00\x07\x8d\x10\x9d\x92\x14\x3f\xcd\x5d\xf5\x67\x21\xb8\x84\xfa\xc6"
          "\x4a\xc7\x76\x2c\xc0\x9e\xea\x2a\x3c\x68\xe9\x2a\x17\xbd\xb5\x75\xf8"
          "\x7b\xda\x18\xbe\x56\x4e",
          "\x15\x2a\x65\x04\x5f\xe6\x74\xf9\x76\x27\x42\x7a\xf5\xbe\x22\xda", 1,
          0, 320 },
        { 128, 128, 128, 60,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x7b\x95\xb8\xc3\x56\x81\x0a\x84\x71\x1d\x68\x15\x0a\x1b\x77\x50",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x84\xd4\xc9\xc0\x8b\x4f\x48\x28\x61\xe3\xa9\xc6\xc3\x5b\xc4\xd9\x1d"
          "\xf9\x27\x37\x45\x13\xbf\xd4\x9f\x43\x6b\xd7\x3f\x32\x52\x85\xda\xef"
          "\x4f\xf7\xe1\x3d\x46\xa6",
          "\x21\x3a\x3c\xb9\x38\x55\xd1\x8e\x69\x33\x7e\xee\x66\xae\xec\x07", 1,
          0, 320 },
        { 128, 128, 128, 61,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x1a\x55\x2e\x67\xcd\xc4\xdc\x1a\x33\xb8\x24\x87\x4e\xbf\x0b\xed",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x94\x8c\xa3\x7a\x8e\x66\x49\xe8\x8a\xef\xfb\x1c\x59\x8f\x36\x07\x00"
          "\x77\x02\x41\x7e\xa0\xe0\xbc\x3c\x60\xad\x5a\x94\x98\x86\xde\x96\x8c"
          "\xf5\x3e\xa6\x46\x2a\xed",
          "\x99\xb3\x81\xbf\xa2\xaf\x97\x51\xc3\x9d\x1b\x6e\x86\xd1\xbe\x6a", 1,
          0, 320 },
        { 128, 128, 128, 62,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xdd\x9d\x0b\x4a\x0c\x3d\x68\x15\x24\xbf\xfc\xa3\x1d\x90\x76\x61",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x64\xb1\x93\x14\xc3\x1a\xf4\x5a\xcc\xdf\x7e\x3c\x4d\xb7\x9f\x0d\x94"
          "\x8c\xa3\x7a\x8e\x66\x49\xe8\x8a\xef\xfb\x1c\x59\x8f\x36\x07\x00\x77"
          "\x02\x41\x7e\xa0\xe0\xbc",
          "\x52\x81\xef\xc7\xf1\x3a\xc8\xe1\x4c\xcf\x5d\xca\x7b\xfb\xfd\xd1", 1,
          0, 320 },
        { 128, 128, 128, 63,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x57\xc5\x64\x3c\x4e\x37\xb4\x04\x1d\xb7\x94\xcf\xe8\xe1\xf0\xf4",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x2b\xb6\x9c\x3e\x5d\x1f\x91\x81\x5c\x6b\x87\xa0\xd5\xbb\xea\x71\x64"
          "\xb1\x93\x14\xc3\x1a\xf4\x5a\xcc\xdf\x7e\x3c\x4d\xb7\x9f\x0d\x94\x8c"
          "\xa3\x7a\x8e\x66\x49\xe8",
          "\xa3\xea\x2c\x09\xee\x4f\x8c\x8a\x12\xf4\x5c\xdd\xf9\xae\xff\x81", 1,
          0, 320 },
        { 128, 128, 128, 64,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x99\x82\x1c\x2d\xd5\xda\xec\xde\xd0\x73\x00\xf5\x77\xf7\xaf\xf1",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x12\x7a\xf9\xb3\x9e\xcd\xfc\x57\xbb\x11\xa2\x84\x7c\x7c\x2d\x3d\x8f"
          "\x93\x8f\x40\xf8\x77\xe0\xc4\xaf\x37\xd0\xfe\x9a\xf0\x33\x05\x2b\xd5"
          "\x37\xc4\xae\x97\x8f\x60",
          "\x07\xeb\x2f\xe4\xa9\x58\xf8\x43\x4d\x40\x68\x48\x99\x50\x7c\x7c", 1,
          0, 320 },
        { 128, 128, 128, 65,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x5e\x4a\x39\x00\x14\x23\x58\xd1\xc7\x74\xd8\xd1\x24\xd8\xd2\x7d",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x0c\xf6\xae\x47\x15\x6b\x14\xdc\xe0\x3c\x8a\x07\xa2\xe1\x72\xb1\x12"
          "\x7a\xf9\xb3\x9e\xcd\xfc\x57\xbb\x11\xa2\x84\x7c\x7c\x2d\x3d\x8f\x93"
          "\x8f\x40\xf8\x77\xe0\xc4",
          "\xf1\x45\xc2\xdc\xaf\x33\x9e\xed\xe4\x27\xbe\x93\x43\x57\xea\xc0", 1,
          0, 320 },
        { 128, 128, 128, 66,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xd4\x12\x56\x76\x56\x29\x84\xc0\xfe\x7c\xb0\xbd\xd1\xa9\x54\xe8",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xf0\xc6\xff\xc1\x8b\xd4\x6d\xf5\x56\x91\x85\xa9\xaf\xd1\x69\xeb\x0c"
          "\xf6\xae\x47\x15\x6b\x14\xdc\xe0\x3c\x8a\x07\xa2\xe1\x72\xb1\x12\x7a"
          "\xf9\xb3\x9e\xcd\xfc\x57",
          "\xfa\xcd\x0b\xfe\x87\x01\xb7\xb4\xa2\xba\x96\xd9\x8a\xf5\x2b\xd9", 1,
          0, 320 },
        { 128, 128, 128, 67,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xb9\x7e\xc6\x2a\x5e\x59\x00\xcc\xf9\xe4\xbe\x33\x2e\x33\x60\x91",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xd6\x92\x8e\x09\x4c\x06\xe0\xa7\xc4\xdb\x42\x18\x4c\xf7\x52\x9e\x95"
          "\xde\x88\xb7\x67\xed\xeb\xe9\xb3\x43\x00\x0b\xe3\xda\xb4\x7e\xa0\x8b"
          "\x74\x42\x93\xee\xd6\x98",
          "\xa0\x3e\x72\x9d\xcf\xd7\xa0\x31\x55\x65\x5f\xec\xe8\xaf\xfd\x7e", 1,
          0, 320 },
        { 128, 128, 128, 68,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x7e\xb6\xe3\x07\x9f\xa0\xb4\xc3\xee\xe3\x66\x17\x7d\x1c\x1d\x1d",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xd8\x2c\xe5\x87\x71\xbf\x64\x87\x11\x6b\xf8\xe9\x64\x21\x87\x7e\xd6"
          "\x92\x8e\x09\x4c\x06\xe0\xa7\xc4\xdb\x42\x18\x4c\xf7\x52\x9e\x95\xde"
          "\x88\xb7\x67\xed\xeb\xe9",
          "\x1e\x43\x92\x68\x28\xbc\x9a\x16\x14\xc7\xb1\x63\x90\x96\xc1\x95", 1,
          0, 320 },
        { 128, 128, 128, 69,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x03\x14\xfc\xd1\x0f\xdd\x67\x5d\x3c\x61\x29\x62\xc9\x31\xf6\x35",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xa1\x97\xa3\x7a\x5d\x79\x69\x70\x78\x53\x6b\xc2\x7f\xe4\x6c\xd8\xd4"
          "\x75\x52\x6d\x90\x44\xaa\x94\xf0\x88\xa0\x54\xf8\xe3\x80\xc6\x4f\x79"
          "\x41\x47\x95\xc6\x14\x80",
          "\xf0\x8b\xad\xdf\x0b\x52\x85\xc9\x1f\xc0\x6a\x67\xfe\x47\x08\xca", 1,
          0, 320 },
        { 128, 128, 128, 70,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xc4\xdc\xd9\xfc\xce\x24\xd3\x52\x2b\x66\xf1\x46\x9a\x1e\x8b\xb9",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x14\x9f\xde\x9a\xbb\xd3\xa4\x3c\x25\x48\x57\x5e\x0d\xb9\xfb\x84\xa1"
          "\x97\xa3\x7a\x5d\x79\x69\x70\x78\x53\x6b\xc2\x7f\xe4\x6c\xd8\xd4\x75"
          "\x52\x6d\x90\x44\xaa\x94",
          "\x62\xa4\xb6\x87\x5c\x28\x83\x45\xd6\xa4\x54\x39\x9e\xac\x1a\xfa", 1,
          0, 320 },
        { 128, 128, 128, 71,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "",
          "\xbe\xc6\xfa\x05\xc1\x71\x8b\x9b\x84\xc4\x73\x45\xbb\xed\x7d\xcb",
          "\x45\xa3\xf8\x9d\x02\x91\x8b\xfd\x0c\x81\x61\x65\x8c\xcc\x97\x95",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          0, 128 },
        { 128, 128, 128, 72,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "",
          "\x4d\x82\x63\x9c\x39\xd3\xf3\x49\x0e\xe9\x03\xdd\x0b\xe7\xaf\xcf",
          "\x1c\xd5\xa0\x62\x14\x23\x5c\xeb\x04\x4d\x4b\xad\x7b\x04\x73\x12",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          0, 128 },
        { 96, 256, 128, 73,
          "\x92\xac\xe3\xe3\x48\xcd\x82\x10\x92\xcd\x92\x1a\xa3\x54\x63\x74\x29"
          "\x9a\xb4\x62\x09\x69\x1b\xc2\x8b\x87\x52\xd1\x7f\x12\x3c\x20",
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb",
          "\x00\x00\x00\x00\xff\xff\xff\xff",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09",
          "\xe2\x7a\xbd\xd2\xd2\xa5\x3d\x2f\x13\x6b",
          "\x9a\x4a\x25\x79\x52\x93\x01\xbc\xfb\x71\xc7\x8d\x40\x60\xf5\x2c", 1,
          64, 80 },
        { 96, 256, 128, 74,
          "\x29\xd3\xa4\x4f\x87\x23\xdc\x64\x02\x39\x10\x0c\x36\x54\x23\xa3\x12"
          "\x93\x4a\xc8\x02\x39\x21\x2a\xc3\xdf\x34\x21\xa2\x09\x81\x23",
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb",
          "\xaa\xbb\xcc\xdd\xee\xff", "", "",
          "\x2a\x7d\x77\xfa\x52\x6b\x82\x50\xcb\x29\x60\x78\x92\x6b\x50\x20", 1,
          48, 0 },
        { 96, 256, 128, 75,
          "\x80\xba\x31\x92\xc8\x03\xce\x96\x5e\xa3\x71\xd5\xff\x07\x3c\xf0\xf4"
          "\x3b\x6a\x2a\xb5\x76\xb2\x08\x42\x6e\x11\x40\x9c\x09\xb9\xb0",
          "\x4d\xa5\xbf\x8d\xfd\x58\x52\xc1\xea\x12\x37\x9d", "", "", "",
          "\x47\x71\xa7\xc4\x04\xa4\x72\x96\x6c\xea\x8f\x73\xc8\xbf\xe1\x7a", 1,
          0, 0 },
        { 96, 256, 128, 76,
          "\xcc\x56\xb6\x80\x55\x2e\xb7\x50\x08\xf5\x48\x4b\x4c\xb8\x03\xfa\x50"
          "\x63\xeb\xd6\xea\xb9\x1f\x6a\xb6\xae\xf4\x91\x6a\x76\x62\x73",
          "\x99\xe2\x3e\xc4\x89\x85\xbc\xcd\xee\xab\x60\xf1", "", "\x2a",
          "\x06",
          "\x63\x3c\x1e\x97\x03\xef\x74\x4f\xff\xfb\x40\xed\xf9\xd1\x43\x55", 1,
          0, 8 },
        { 96, 256, 128, 77,
          "\x51\xe4\xbf\x2b\xad\x92\xb7\xaf\xf1\xa4\xbc\x05\x55\x0b\xa8\x1d\xf4"
          "\xb9\x6f\xab\xf4\x1c\x12\xc7\xb0\x0e\x60\xe4\x8d\xb7\xe1\x52",
          "\x4f\x07\xaf\xed\xfd\xc3\xb6\xc2\x36\x18\x23\xd3", "",
          "\xbe\x33\x08\xf7\x2a\x2c\x6a\xed",
          "\xcf\x33\x2a\x12\xfd\xee\x80\x0b",
          "\x60\x2e\x8d\x7c\x47\x99\xd6\x2c\x14\x0c\x9b\xb8\x34\x87\x6b\x09", 1,
          0, 64 },
        { 96, 256, 128, 78,
          "\x67\x11\x96\x27\xbd\x98\x8e\xda\x90\x62\x19\xe0\x8c\x0d\x0d\x77\x9a"
          "\x07\xd2\x08\xce\x8a\x4f\xe0\x70\x9a\xf7\x55\xee\xec\x6d\xcb",
          "\x68\xab\x7f\xdb\xf6\x19\x01\xda\xd4\x61\xd2\x3c", "",
          "\x51\xf8\xc1\xf7\x31\xea\x14\xac\xdb\x21\x0a\x6d\x97\x3e\x07",
          "\x43\xfc\x10\x1b\xff\x4b\x32\xbf\xad\xd3\xda\xf5\x7a\x59\x0e",
          "\xec\x04\xaa\xcb\x71\x48\xa8\xb8\xbe\x44\xcb\x7e\xaf\x4e\xfa\x69", 1,
          0, 120 },
        { 96, 256, 128, 79,
          "\x59\xd4\xea\xfb\x4d\xe0\xcf\xc7\xd3\xdb\x99\xa8\xf5\x4b\x15\xd7\xb3"
          "\x9f\x0a\xcc\x8d\xa6\x97\x63\xb0\x19\xc1\x69\x9f\x87\x67\x4a",
          "\x2f\xcb\x1b\x38\xa9\x9e\x71\xb8\x47\x40\xad\x9b", "",
          "\x54\x9b\x36\x5a\xf9\x13\xf3\xb0\x81\x13\x1c\xcb\x6b\x82\x55\x88",
          "\xf5\x8c\x16\x69\x01\x22\xd7\x53\x56\x90\x7f\xd9\x6b\x57\x0f\xca",
          "\x28\x75\x2c\x20\x15\x30\x92\x81\x8f\xab\xa2\xa3\x34\x64\x0d\x6e", 1,
          0, 128 },
        { 96, 256, 128, 80,
          "\x3b\x24\x58\xd8\x17\x6e\x16\x21\xc0\xcc\x24\xc0\xc0\xe2\x4c\x1e\x80"
          "\xd7\x2f\x7e\xe9\x14\x9a\x4b\x16\x61\x76\x62\x96\x16\xd0\x11",
          "\x45\xaa\xa3\xe5\xd1\x6d\x2d\x42\xdc\x03\x44\x5d", "",
          "\x3f\xf1\x51\x4b\x1c\x50\x39\x15\x91\x8f\x0c\x0c\x31\x09\x4a\x6e"
          "\x1f",
          "\x73\xa6\xb6\xf4\x5f\x6c\xcc\x51\x31\xe0\x7f\x2c\xaa\x1f\x2e\x2f"
          "\x56",
          "\x2d\x73\x79\xec\x1d\xb5\x95\x2d\x4e\x95\xd3\x0c\x34\x0b\x1b\x1d", 1,
          0, 136 },
        { 96, 256, 128, 81,
          "\x02\x12\xa8\xde\x50\x07\xed\x87\xb3\x3f\x1a\x70\x90\xb6\x11\x4f\x9e"
          "\x08\xce\xfd\x96\x07\xf2\xc2\x76\xbd\xcf\xdb\xc5\xce\x9c\xd7",
          "\xe6\xb1\xad\xf2\xfd\x58\xa8\x76\x2c\x65\xf3\x1b", "",
          "\x10\xf1\xec\xf9\xc6\x05\x84\x66\x5d\x9a\xe5\xef\xe2\x79\xe7\xf7\x37"
          "\x7e\xea\x69\x16\xd2\xb1\x11",
          "\x08\x43\xff\xf5\x2d\x93\x4f\xc7\xa0\x71\xea\x62\xc0\xbd\x35\x1c\xe8"
          "\x56\x78\xcd\xe3\xea\x2c\x9e",
          "\x73\x55\xfd\xe5\x99\x00\x67\x15\x05\x38\x13\xce\x69\x62\x37\xa8", 1,
          0, 192 },
        { 96, 256, 128, 82,
          "\xb2\x79\xf5\x7e\x19\xc8\xf5\x3f\x2f\x96\x3f\x5f\x25\x19\xfd\xb7\xc1"
          "\x77\x9b\xe2\xca\x2b\x3a\xe8\xe1\x12\x8b\x7d\x6c\x62\x7f\xc4",
          "\x98\xbc\x2c\x74\x38\xd5\xcd\x76\x65\xd7\x6f\x6e", "\xc0",
          "\xfc\xc5\x15\xb2\x94\x40\x8c\x86\x45\xc9\x18\x3e\x3f\x4e\xce\xe5\x12"
          "\x78\x46\xd1",
          "\xeb\x55\x00\xe3\x82\x59\x52\x86\x6d\x91\x12\x53\xf8\xde\x86\x0c\x00"
          "\x83\x1c\x81",
          "\xec\xb6\x60\xe1\xfb\x05\x41\xec\x41\xe8\xd6\x8a\x64\x14\x1b\x3a", 1,
          8, 160 },
        { 96, 256, 128, 83,
          "\xcd\xcc\xfe\x3f\x46\xd7\x82\xef\x47\xdf\x4e\x72\xf0\xc0\x2d\x9c\x7f"
          "\x77\x4d\xef\x97\x0d\x23\x48\x6f\x11\xa5\x7f\x54\x24\x7f\x17",
          "\x37\x61\x87\x89\x46\x05\xa8\xd4\x5e\x30\xde\x51",
          "\x95\x68\x46\xa2\x09\xe0\x87\xed",
          "\xe2\x8e\x0e\x9f\x9d\x22\x46\x3a\xc0\xe4\x26\x39\xb5\x30\xf4\x21\x02"
          "\xfd\xed\x75",
          "\xfe\xca\x44\x95\x24\x47\x01\x5b\x5d\xf1\xf4\x56\xdf\x8c\xa4\xbb\x4e"
          "\xee\x2c\xe2",
          "\x08\x2e\x91\x92\x4d\xee\xb7\x78\x80\xe1\xb1\xc8\x4f\x9b\x8d\x30", 1,
          64, 160 },
        { 96, 256, 128, 84,
          "\xf3\x23\x64\xb1\xd3\x39\xd8\x2e\x4f\x13\x2d\x8f\x4a\x0e\xc1\xff\x7e"
          "\x74\x65\x17\xfa\x07\xef\x1a\x7f\x42\x2f\x4e\x25\xa4\x81\x94",
          "\x5a\x86\xa5\x0a\x0e\x8a\x17\x9c\x73\x4b\x99\x6d",
          "\xab\x2a\xc7\xc4\x4c\x60\xbd\xf8\x22\x8c\x78\x84\xad\xb2\x01\x84",
          "\x43\x89\x1b\xcc\xb5\x22\xb1\xe7\x2a\x6b\x53\xcf\x31\xc0\x74\xe9\xd6"
          "\xc2\xdf\x8e",
          "\x43\xdd\xa8\x32\xe9\x42\xe2\x86\xda\x31\x4d\xaa\x99\xbe\xf5\x07\x1d"
          "\x9d\x2c\x78",
          "\xc3\x92\x25\x83\x47\x6c\xed\x57\x54\x04\xdd\xb8\x5d\xd8\xcd\x44", 1,
          128, 160 },
        { 96, 256, 128, 85,
          "\xff\x00\x89\xee\x87\x0a\x4a\x39\xf6\x45\xb0\xa5\xda\x77\x4f\x7a\x59"
          "\x11\xe9\x69\x6f\xc9\xca\xd6\x46\x45\x2c\x2a\xa8\x59\x5a\x12",
          "\xbc\x2a\x77\x57\xd0\xce\x2d\x8b\x1f\x14\xcc\xd9",
          "\x97\x2a\xb4\xe0\x63\x90\xca\xae\x8f\x99\xdd\x6e\x21\x87\xbe\x6c\x7f"
          "\xf2\xc0\x8a\x24\xbe\x16\xef",
          "\x74\x8b\x28\x03\x16\x21\xd9\x5e\xe6\x18\x12\xb4\xb4\xf4\x7d\x04\xc6"
          "\xfc\x2f\xf3",
          "\xa9\x29\xee\x7e\x67\xc7\xa2\xf9\x1b\xbc\xec\x63\x89\xa3\xca\xf4\x3a"
          "\xb4\x93\x05",
          "\xeb\xec\x67\x74\xb9\x55\xe7\x89\x59\x1c\x82\x2d\xab\x73\x9e\x12", 1,
          192, 160 },
        { 96, 256, 128, 86,
          "\x5b\x1d\x10\x35\xc0\xb1\x7e\xe0\xb0\x44\x47\x67\xf8\x0a\x25\xb8\xc1"
          "\xb7\x41\xf4\xb5\x0a\x4d\x30\x52\x22\x6b\xaa\x1c\x6f\xb7\x01",
          "\xd6\x10\x40\xa3\x13\xed\x49\x28\x23\xcc\x06\x5b", "",
          "\xd0\x96\x80\x31\x81\xbe\xef\x9e\x00\x8f\xf8\x5d\x5d\xdc\x38\xdd\xac"
          "\xf0\xf0\x9e\xe5\xf7\xe0\x7f\x1e\x40\x79\xcb\x64\xd0\xdc\x8f\x5e\x67"
          "\x11\xcd\x49\x21\xa7\x88\x7d\xe7\x6e\x26\x78\xfd\xc6\x76\x18\xf1\x18"
          "\x55\x86\xbf\xea\x9d\x4c\x68\x5d\x50\xe4\xbb\x9a\x82",
          "\xc7\xd1\x91\xb6\x01\xf8\x6c\x28\xb6\xa1\xbd\xef\x6a\x57\xb4\xf6\xee"
          "\x3a\xe4\x17\xbc\x12\x5c\x38\x1c\xdf\x1c\x4d\xac\x18\x4e\xd1\xd8\x4f"
          "\x11\x96\x20\x6d\x62\xca\xd1\x12\xb0\x38\x84\x57\x20\xe0\x2c\x06\x11"
          "\x79\xa8\x83\x6f\x02\xb9\x3f\xa7\x00\x83\x79\xa6\xbf",
          "\xf1\x56\x12\xf6\xc4\x0f\x2e\x0d\xb6\xdc\x76\xfc\x48\x22\xfc\xfe", 1,
          0, 512 },
        { 96, 256, 128, 87,
          "\xd7\xad\xdd\x38\x89\xfa\xdf\x8c\x89\x3e\xee\x14\xba\x2b\x7e\xa5\xbf"
          "\x56\xb4\x49\x90\x48\x69\x61\x5b\xd0\x5d\x5f\x11\x4c\xf3\x77",
          "\x8a\x3a\xd2\x6b\x28\xcd\x13\xba\x65\x04\xe2\x60", "",
          "\xc8\x77\xa7\x6b\xf5\x95\x56\x07\x72\x16\x7c\x6e\x3b\xcc\x70\x53\x05"
          "\xdb\x9c\x6f\xcb\xeb\x90\xf4\xfe\xa8\x51\x16\x03\x8b\xc5\x3c\x3f\xa5"
          "\xb4\xb4\xea\x0d\xe5\xcc\x53\x4f\xbe\x1c\xf9\xae\x44\x82\x4c\x6c\x2c"
          "\x0a\x5c\x88\x5b\xd8\xc3\xcd\xc9\x06\xf1\x26\x75\x73\x7e\x43\x4b\x98"
          "\x3e\x1e\x23\x1a\x52\xa2\x75\xdb\x5f\xb1\xa0\xca\xc6\xa0\x7b\x3b\x7d"
          "\xcb\x19\x48\x2a\x5d\x3b\x06\xa9\x31\x7a\x54\x82\x6c\xea\x6b\x36\xfc"
          "\xe4\x52\xfa\x9b\x54\x75\xe2\xaa\xf2\x54\x99\x49\x9d\x8a\x89\x32\xa1"
          "\x9e\xb9\x87\xc9\x03\xbd\x85\x02\xfe",
          "\x53\xcc\x8c\x92\x0a\x85\xd1\xac\xcb\x88\x63\x6d\x08\xbb\xe4\x86\x9b"
          "\xfd\xd9\x6f\x43\x7b\x2e\xc9\x44\x51\x21\x73\xa9\xc0\xfe\x7a\x47\xf8"
          "\x43\x41\x33\x98\x9b\xa7\x7d\xda\x56\x1b\x7e\x37\x01\xb9\xa8\x3c\x3b"
          "\xa7\x66\x0c\x66\x6b\xa5\x9f\xef\x96\x59\x8e\xb6\x21\x54\x4c\x63\x80"
          "\x6d\x50\x9a\xc4\x76\x97\x41\x2f\x95\x64\xeb\x0a\x2e\x1f\x72\xf6\x59"
          "\x9f\x56\x66\xaf\x34\xcf\xfc\xa0\x65\x73\xff\xb4\xf4\x7b\x02\xf5\x9f"
          "\x21\xc6\x43\x63\xda\xec\xb9\x77\xb4\x41\x5f\x19\xfd\xda\x3c\x9a\xae"
          "\x50\x66\xa5\x7b\x66\x9f\xfa\xa2\x57",
          "\x5e\x63\x37\x4b\x51\x9e\x6c\x36\x08\x32\x19\x43\xd7\x90\xcf\x9a", 1,
          0, 1024 },
        { 96, 256, 128, 88,
          "\x31\x7b\xa3\x31\x30\x7f\x3a\x3d\x3d\x82\xee\x1f\xda\xb7\x0f\x62\xa1"
          "\x55\xaf\x14\xda\xf6\x31\x30\x7a\x61\xb1\x87\xd4\x13\xe5\x33",
          "\xa6\x68\x7c\xf5\x08\x35\x6b\x17\x46\x25\xde\xaa", "",
          "\x32\xc1\xd0\x91\x07\xc5\x99\xd3\xcc\xe4\xe7\x82\x17\x9c\x96\x6c\x6e"
          "\xf9\x63\x68\x9d\x45\x35\x1d\xbe\x0f\x6f\x88\x1d\xb2\x73\xe5\x4d\xb7"
          "\x6f\xc4\x8f\xdc\x5d\x30\xf0\x89\xda\x83\x83\x01\xa5\xf9\x24\xbb\xa3"
          "\xc0\x44\xe1\x9b\x3e\xd5\xaa\x6b\xe8\x71\x18\x55\x40\x04\xca\x30\xe0"
          "\x32\x43\x37\xd9\x87\x83\x94\x12\xbf\x8f\x8b\xbd\xd5\x37\x20\x5d\x4b"
          "\x0e\x21\x20\xe9\x65\x37\x32\x35\xd6\xcb\xd2\xfb\x37\x76\xba\x0a\x38"
          "\x4e\xc1\xd9\xb7\xc6\x31\xa0\x37\x9f\xf9\x97\xc3\xf9\x74\xa6\xf7\xbb"
          "\xf4\xfd\x23\x01\x62\x11\xf5\xfc\x10\xac\xad\xb5\xe4\x00\xd2\xff\x0f"
          "\xdf\xd1\x93\xf5\xc6\xfc\x6d\x4f\x72\x71\xdf\xd1\x34\x9e\xd8\x0f\xbe"
          "\xda\xeb\xb1\x55\xb9\xb0\x2f\xb3\x07\x44\x95\xd5\x5f\x9a\x24\x55\xf5"
          "\x9b\xf6\xf1\x13\x19\x1a\x02\x9c\x6b\x0b\xa7\x5d\x97\xcd\xc0\xc8\x4f"
          "\x13\x18\x36\x33\x7f\x29\xf9\xd9\x6c\xa4\x48\xee\xc0\xcc\x46\xd1\xca"
          "\x8b\x37\x35\x66\x19\x79\xd8\x33\x02\xfe\xc0\x8f\xff\xcf\x5e\x58\xf1"
          "\x2b\x1e\x70\x50\x65\x7b\x1b\x97\xc6\x4a\x4e\x07\xe3\x17\xf5\x54\xf8"
          "\x31\x0b\x6c\xcb\x49\xf3\x6d\x48\xc5\x78\x16\xd2\x49\x52\xaa\xda\x71"
          "\x1d\x4f",
          "\xd7\xee\xbc\x95\x87\xaa\x21\x13\x6f\xa3\x8b\x41\xcf\x0e\x2d\xb0\x3a"
          "\x7e\xa2\xba\x9e\xad\xdf\x83\xd3\x3f\x78\x10\x93\x61\x7b\xf5\x0f\x49"
          "\xb2\xbf\xe2\xf7\x17\x3b\x11\x39\x12\xe2\xe1\x77\x5f\x40\xed\xfe\xd8"
          "\xb3\xb0\x09\x9b\x9e\x1c\x22\x0d\xd1\x03\xbe\x61\x66\x21\x0b\x01\x02"
          "\x9f\xeb\x24\xed\x9e\x20\x61\x4e\xdd\xc3\xce\xbe\x41\xb0\x07\x9a\x9a"
          "\x8c\x11\x7b\x59\x6c\x90\x28\x8e\xff\xd3\x79\x6f\xbd\x0c\x7e\x8e\xab"
          "\x00\x60\x9a\x64\xbe\x3a\xd9\x59\x7c\xdb\xf3\xa8\x18\xc2\x60\xcd\x93"
          "\x8b\xdf\x23\x2e\x40\x59\xae\x35\xa2\x57\x1a\x83\x88\x87\xfc\x19\x69"
          "\x12\x17\x94\x86\xe0\x46\xa6\x22\x27\xa4\xca\xdd\xce\x38\xcb\xbc\x37"
          "\x58\x7b\xb9\x43\x9e\xc6\x37\x60\x2b\x68\x18\xc5\xcb\xe3\xc7\x1a\x7c"
          "\x41\x43\x96\x05\x33\xdc\x74\x17\x4b\xd3\x15\xc8\xdb\x22\x7b\x69\xb5"
          "\x5b\xb7\xfc\x30\xba\x1d\x52\x13\xa7\x52\xec\x33\x92\x50\x43\xce\xfb"
          "\xc1\xa6\x29\x43\xee\x5f\x34\xd5\xda\x01\x79\x9e\x69\x09\x4d\x73\x2a"
          "\xef\x52\xf8\xe0\x36\x98\x0d\x00\x70\xe2\x2e\x17\x3c\x67\xc4\xbb\xcc"
          "\xa6\x1c\xc1\xee\xdb\xd6\x01\x65\x16\xc5\x92\x14\x48\x19\xdf\x13\x20"
          "\x4d\xee",
          "\xbf\x05\x40\xd3\x4b\x20\xf7\x61\x10\x1b\xc6\x08\xb0\x24\x58\xf2", 1,
          0, 2056 },
        { 96, 256, 128, 89,
          "\x2c\xe6\xb4\xc1\x5f\x85\xfb\x2d\xa5\xcc\x6c\x26\x94\x91\xee\xf2\x81"
          "\x98\x03\x09\x18\x12\x49\xeb\xf2\x83\x2b\xd6\xd0\x73\x2d\x0b",
          "\xc0\x64\xfa\xe9\x17\x3b\x17\x3f\xd6\xf1\x1f\x34",
          "\x49\x8d\x30\x75\xb0\x9f\xed\x99\x82\x80\x58\x3d\x61\xbb\x36\xb6\xce"
          "\x41\xf1\x30\x06\x3b\x80\x82\x4d\x15\x86\xe1\x43\xd3\x49\xb1\x26\xb1"
          "\x6a\xa1\x0f\xe5\x73\x43\xed\x22\x3d\x63\x64\xee\x60\x22\x57\xfe\x31"
          "\x3a\x7f\xc9\xbf\x90\x88\xf0\x27\x79\x5b\x8d\xc1\xd3",
          "\xf8\xa2\x7a\x4b\xaf\x00\xdc\x05\x55\xd2\x22\xf2\xfa\x4f\xb4\x2d\xc6"
          "\x66\xea\x3c",
          "\xae\xd5\x8d\x8a\x25\x2f\x74\x0d\xba\x4b\xf6\xd3\x67\x73\xbd\x5b\x41"
          "\x23\x4b\xba",
          "\x01\xf9\x3d\x74\x56\xaa\x18\x4e\xbb\x49\xbe\xa4\x72\xb6\xd6\x5d", 1,
          512, 160 },
        { 96, 256, 128, 90,
          "\x44\xc8\xd0\xcd\xb8\xf7\xe7\x36\xcf\xd9\x97\xc8\x72\xa5\xd9\xc5\xef"
          "\x30\xaf\xbe\x44\xb6\x56\x66\x06\xb9\x0a\xa5\xe3\xe8\xb7\x97",
          "\x6f\x39\xaf\xba\x02\x1e\x4c\x36\xeb\x92\x96\x2e",
          "\x98\xd1\xca\x17\x88\xcb\xeb\x30\x0e\xa5\xc6\xb1\xee\xc9\x5e\xb2\x34"
          "\x71\x77\x20\x14\x00\x91\x3d\x45\x22\x56\x22\xb6\x27\x3e\xec\x8a\x74"
          "\xc3\xf1\x2c\x8d\x52\x48\xda\xbe\xe5\x86\x22\x97\x86\xff\x19\x2c\x4d"
          "\xf0\xc7\x95\x47\xf7\xad\x6a\x92\xd7\x8d\x9f\x89\x52\x75\x86\x35\x78"
          "\x3a\xdd\x2a\x59\x77\xd3\x86\xe0\xae\xf7\x64\x82\x21\x1d\x2c\x3a\xe9"
          "\x8d\xe4\xba\xad\xb3\xf8\xb3\x5b\x51\x04\x64\x75\x5d\xc7\x5c\xeb\x2b"
          "\xf2\x5b\x23\x33\x17\x52\x3f\x39\x9a\x6c\x50\x7d\xb2\x14\xf0\x85\xfa"
          "\x28\x18\xf0\xd3\x70\x2b\x10\x95\x2b",
          "\x2e\x6f\x40\xf9\xd3\x72\x58\x36\xac\x0c\x85\x81\x77\x93\x8f\xd6\x7b"
          "\xe1\x94\x32",
          "\xb4\x24\x28\xf8\x09\x4e\xf7\xe6\x5c\x9e\x8c\x45\xef\x3e\x95\xc2\x8c"
          "\xe0\x7d\x72",
          "\x32\xb2\x5d\xfb\xb8\x96\xd0\xf9\xd7\x9c\x82\x3b\xdd\x8e\x5d\x06", 1,
          1024, 160 },
        { 96, 256, 128, 91,
          "\xe4\x00\x03\xd6\xe0\x8a\xb8\x0b\x4b\xfc\x84\x00\xef\x11\x29\x45\xa9"
          "\x01\xec\x64\xa1\xb6\x53\x6c\xa9\x26\x65\x09\x0d\x60\x8b\xc4",
          "\x9f\x09\x5d\xaf\xe6\xf6\xe0\xfb\xaf\xbb\xe0\x2e",
          "\x42\x2d\x5e\xfc\xff\xe3\x64\x90\x59\x84\x53\x3f\x0a\x57\x9d\x80\xb1"
          "\x8b\xda\x7b\x29\xe6\xe4\x64\x98\xef\xfb\xa5\x3c\x35\x01\x12\xc0\xbb"
          "\xb8\xdc\x4c\xe0\x3b\xb0\xc6\x9e\x1d\x0b\xaa\x19\xf0\x63\x71\x08\xaa"
          "\x4a\x16\xb0\x9a\x28\x1f\x23\x28\x39\xd8\x7b\x6d\x0e\x42\xbe\x1b\xaa"
          "\x7c\x67\xf1\xbe\x97\x0e\xa1\x69\xd3\x96\x0b\x9f\xe0\xa6\x1f\x11\xcd"
          "\x2e\xb7\x39\x8c\x19\xe6\x41\xfe\xb4\x3f\x77\x8e\x25\x7a\x39\x70\x63"
          "\xdb\x5b\x3a\x67\x07\xe9\xdb\x62\x38\x70\x54\xf9\xf9\xd4\x4f\x14\x35"
          "\x83\xe6\x3e\xda\xd4\x5a\x00\x25\x1e\x51\x73\xd7\x50\x5f\x22\xa8\xbc"
          "\xe2\x32\xe5\x6c\x2c\x27\x6a\x58\x03\x3a\xe3\x0d\x5d\xbf\x4e\x35\xa8"
          "\x62\xe4\x2a\xf5\x73\xbe\x38\xc6\x40\x6d\x9b\x4c\x7a\xcb\xf2\x75\xfe"
          "\x36\xc0\xec\xf2\xc4\x64\x28\x98\xa3\x0e\x61\x46\xfa\xc9\x92\xa1\x64"
          "\x05\xf9\x83\x12\x12\x6b\x7a\x37\x22\xf5\xdf\xb7\xdd\x4e\x49\x11\xc1"
          "\x42\x6b\x2e\x01\xd0\x4e\x9b\xe6\xdb\x37\x71\x10\x0f\x7d\x7d\x42\x82"
          "\xe4\xea\x58\x5f\x36\x46\x24\x1e\x80\x7c\xa6\x4f\x06\xa7\xfa\x9b\x70"
          "\x03\xd7\x10\xb8\x01\xd6\x6f\x51\x7d\x2d\x5e\xbd\x74\x08\x72\xde\xba"
          "\x13\xd0",
          "\x38\xc3\xf4\x4b\xc5\x76\x5d\xe1\xf3\xd1\xc3\x68\x4c\xd0\x9c\xdd\xef"
          "\xaf\x29\x8d",
          "\xd4\xa7\x9f\x72\x94\x87\x93\x59\x50\xec\x03\x2e\x69\x0a\xb8\xfe\x25"
          "\xc4\x15\x8e",
          "\x87\x6d\x2f\x33\x4f\x47\x96\x8b\x10\xc1\x03\x85\x9d\x43\x6d\xb8", 1,
          2056, 160 },
        { 96, 256, 128, 92,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "",
          "\x56\x10\x08\xfa\x07\xa6\x8f\x5c\x61\x28\x5c\xd0\x13\x46\x4e\xaf",
          "\x23\x29\x3e\x9b\x07\xca\x7d\x1b\x0c\xae\x7c\xc4\x89\xa9\x73\xb3",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          0, 128 },
        { 96, 256, 128, 93,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", "",
          "\xc6\x15\x22\x44\xce\xa1\x97\x8d\x3e\x0b\xc2\x74\xcf\x8c\x0b\x3b",
          "\x7c\xb6\xfc\x7c\x6a\xbc\x00\x9e\xfe\x95\x51\xa9\x9f\x36\xa4\x21",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          0, 128 },
        { 96, 256, 128, 94,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9d\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 95,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9e\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 96,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x1c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 97,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe9\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 98,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\x76\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 99,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd9\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 100,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xda\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 101,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\x71\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 102,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbe\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 103,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\x3f\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 104,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\xa8\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 105,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x73\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 106,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xeb\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 107,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xe8\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 108,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\x6a\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 109,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdc", 0,
          0, 128 },
        { 96, 256, 128, 110,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\xdf", 0,
          0, 128 },
        { 96, 256, 128, 111,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\x9d", 0,
          0, 128 },
        { 96, 256, 128, 112,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbf\x88\x72\x32\xea\xb5\x90\x5d", 0,
          0, 128 },
        { 96, 256, 128, 113,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9d\xe8\xfe\xf6\xd8\xab\x1b\xf1\xbe\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 114,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\x76\xd8\xab\x1b\x71\xbf\x88\x72\x32\xea\xb5\x90\xdd", 0,
          0, 128 },
        { 96, 256, 128, 115,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9c\xe8\xfe\xf6\xd8\xab\x1b\x71\xbf\x88\x72\x32\xea\xb5\x90\x5d", 0,
          0, 128 },
        { 96, 256, 128, 116,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x63\x17\x01\x09\x27\x54\xe4\x0e\x40\x77\x8d\xcd\x15\x4a\x6f\x22", 0,
          0, 128 },
        { 96, 256, 128, 117,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          0, 128 },
        { 96, 256, 128, 118,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          0, 128 },
        { 96, 256, 128, 119,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x1c\x68\x7e\x76\x58\x2b\x9b\x71\x3f\x08\xf2\xb2\x6a\x35\x10\x5d", 0,
          0, 128 },
        { 96, 256, 128, 120,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\x06\x14\x57\xc0\x75\x9f\xc1\x74\x9f\x17\x4e\xe1\xcc\xad\xfa",
          "\x9d\xe9\xff\xf7\xd9\xaa\x1a\xf0\xbe\x89\x73\x33\xeb\xb4\x91\xdc", 0,
          0, 128 },
        { 128, 192, 128, 121,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x02\x9e\x0e\x77\x7d\xb0\x92\xb1\x25\x35\xd0\x43\x01\x2f\x09\xba",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xf8\x3c\xee\x46\x73\x36\xe1\xa0\x9b\x75\xf2\x4e\x9b\x43\x85\xc9\x9c"
          "\x13\xe6\xaf\x72\x22\x56\xa6\x61\x29\xec\xe9\x61\xfe\x80\x3b\x16\x7b"
          "\xad\x20\x6f\x50\x17\xfb",
          "\x09\x33\x8a\x42\xf0\xac\xc1\x4f\x97\xc0\x64\xf5\x2f\x5f\x16\x88", 1,
          0, 320 },
        { 128, 192, 128, 122,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xf1\xbe\x3b\x06\xb7\xfe\xac\x07\xe7\xea\xb6\x29\xf5\x56\x04\x7b",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x0b\x32\xb6\x48\xa2\xc2\x8e\x9e\xdd\x7c\xee\x08\xee\xeb\x90\x00\x34"
          "\xca\xe7\x21\x5e\x5a\xb1\xe2\x01\xbd\x2e\xed\x10\x32\xc5\xa9\x78\x66"
          "\xba\x58\x2a\x34\x58\xa4",
          "\x90\xbe\x36\x06\xde\x58\xbd\x77\x8f\xa5\xbe\xff\x4a\x41\x02\xbd", 1,
          0, 320 },
        { 128, 192, 128, 123,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xde\x9e\xb6\x3b\x1d\xae\xd3\x21\xa1\x1b\x75\x47\xcc\x9e\x22\x3c",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x57\x5e\x2e\xce\xc2\xb3\xc7\x2d\x4e\x80\x83\x0d\x0d\x85\x9a\xd9\xe4"
          "\x2c\x29\xc4\xa6\x8d\x8d\x9d\x8d\x23\x43\x4d\xe2\xcd\x07\x73\x3b\xe4"
          "\x9d\x62\xac\x1a\xe0\x85",
          "\x6e\x4d\x63\x96\x12\x5a\x10\xdf\x54\x43\xbd\x0c\xbc\x85\x66\xd1", 1,
          0, 320 },
        { 128, 192, 128, 124,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x40\xbb\x0a\xbe\xbc\x48\x3f\xf6\xd5\x67\x12\x41\xff\x5d\x66\xc6",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x2a\x81\x88\x88\xd1\xf0\x9f\x32\xaa\x7b\xee\xdd\x28\x69\xb4\x46\x57"
          "\x5e\x2e\xce\xc2\xb3\xc7\x2d\x4e\x80\x83\x0d\x0d\x85\x9a\xd9\xe4\x2c"
          "\x29\xc4\xa6\x8d\x8d\x9d",
          "\xdc\x48\x1f\x17\x25\x45\x26\x8e\xff\x63\xab\x04\x90\x40\x3d\xc3", 1,
          0, 320 },
        { 128, 192, 128, 125,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x20\xd5\xcf\x30\x5e\x63\x0a\x8f\x49\xe3\xbb\x4b\xab\x18\xab\xc9",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x96\xd3\x6b\x79\x5f\x8e\x7e\xdf\x6a\x8e\x0d\xbc\xd2\x0d\x6c\x07\x2a"
          "\x81\x88\x88\xd1\xf0\x9f\x32\xaa\x7b\xee\xdd\x28\x69\xb4\x46\x57\x5e"
          "\x2e\xce\xc2\xb3\xc7\x2d",
          "\x8a\x3a\x22\xbf\x25\x92\x95\x8b\x93\x02\x92\xaa\x47\xf5\x90\xe8", 1,
          0, 320 },
        { 128, 192, 128, 126,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x25\x53\x58\xa7\x1a\x0e\x57\x31\xf6\xdd\x6c\xe2\x8e\x15\x8a\xe6",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xcf\xce\x3d\x92\x0f\x0e\x01\xf0\xbb\x49\xa7\x51\x95\x5b\x23\x6d\x1b"
          "\x88\x7b\xae\xfd\x25\xc4\x7f\x41\x30\x3c\x46\xd5\xc7\xbf\x9c\xa4\xc2"
          "\xc4\x5a\x8f\x1e\x66\x56",
          "\x2d\xb9\xdc\x1b\x7f\xd3\x15\xdf\x1c\x95\x43\x24\x32\xfc\xf4\x74", 1,
          0, 320 },
        { 128, 192, 128, 127,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xbb\x76\xe4\x22\xbb\xe8\xbb\xe6\x82\xa1\x0b\xe4\xbd\xd6\xce\x1c",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x69\xa2\x41\x69\x79\x2e\x9a\x07\xf6\xe6\xf4\x73\x6f\xa9\x72\xdc\xcf"
          "\xce\x3d\x92\x0f\x0e\x01\xf0\xbb\x49\xa7\x51\x95\x5b\x23\x6d\x1b\x88"
          "\x7b\xae\xfd\x25\xc4\x7f",
          "\x82\xad\x96\x7f\x7a\xc1\x90\x84\x35\x4f\x69\xa7\x51\x44\x3f\xb2", 1,
          0, 320 },
        { 128, 192, 128, 128,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xdb\x18\x21\xac\x59\xc3\x8e\x9f\x1e\x25\xa2\xee\xe9\x93\x03\x13",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x4e\x44\x17\xa8\x3b\xea\xc1\xeb\x7e\x24\x45\x6a\x05\xf6\xba\x55\x69"
          "\xa2\x41\x69\x79\x2e\x9a\x07\xf6\xe6\xf4\x73\x6f\xa9\x72\xdc\xcf\xce"
          "\x3d\x92\x0f\x0e\x01\xf0",
          "\x47\x2d\x5d\xd5\x82\xdc\x05\xef\x5f\xc4\x96\xb6\x12\x02\x3c\xb2", 1,
          0, 320 },
        { 128, 192, 128, 129,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xf7\xa0\x2e\xcc\xa0\x30\x64\xb2\xef\x3c\xce\x9f\xea\xb7\x9f\x07",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x6f\x8e\x17\x4e\xfc\xa3\x09\x72\x99\xf7\x84\xef\xd4\xca\xff\x0b\xf1"
          "\x68\xc3\xe5\x16\x5b\x9a\xd3\xd2\x00\x62\x00\x98\x48\x04\x4e\xef\x8f"
          "\x31\xf7\xd2\xfe\xad\x05",
          "\xca\xff\x72\x38\x26\xdf\x15\x09\x34\xae\xe3\x20\x1b\xa1\x75\xe7", 1,
          0, 320 },
        { 128, 192, 128, 130,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x69\x85\x92\x49\x01\xd6\x88\x65\x9b\x40\xa9\x99\xd9\x74\xdb\xfd",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xaf\x19\x30\x90\xce\x3d\x43\xa3\x88\xa1\xd2\x94\xa0\x96\x16\x90\x6f"
          "\x8e\x17\x4e\xfc\xa3\x09\x72\x99\xf7\x84\xef\xd4\xca\xff\x0b\xf1\x68"
          "\xc3\xe5\x16\x5b\x9a\xd3",
          "\x3b\x08\x95\x8b\xe1\x28\x6c\x2b\x4a\xcb\xa0\x2b\x36\x74\xad\xb2", 1,
          0, 320 },
        { 128, 192, 128, 131,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x3f\x11\x88\x54\x6c\x65\xed\x0f\xc5\x5e\x75\x03\x2c\x68\xee\x44",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x5d\xec\xcf\x83\x8b\x2c\xf5\xf8\x69\xc9\x0d\x2a\x61\x11\x60\xb1\xe5"
          "\x78\xab\x81\x21\xb9\x37\x35\xcb\xa4\xa1\x93\x06\x47\xb8\xc4\xc8\x4b"
          "\xf7\x76\x33\x3e\xe4\x5a",
          "\xc1\x4d\x52\x20\x8f\x0f\x51\xb8\x16\xa4\x89\x71\xea\xf8\xff\x7e", 1,
          0, 320 },
        { 128, 192, 128, 132,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xa1\x34\x34\xd1\xcd\x83\x01\xd8\xb1\x22\x12\x05\x1f\xab\xaa\xbe",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xd2\xca\xe1\x68\x4a\xa4\x07\xa1\x3a\x2e\x2d\xa5\x35\x7e\x29\xf5\x5d"
          "\xec\xcf\x83\x8b\x2c\xf5\xf8\x69\xc9\x0d\x2a\x61\x11\x60\xb1\xe5\x78"
          "\xab\x81\x21\xb9\x37\x35",
          "\xea\x2d\x01\x80\x99\xcd\x79\x25\xc5\x07\xce\xf0\xce\xdd\xb0\xae", 1,
          0, 320 },
        { 128, 192, 128, 133,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "",
          "\x5c\x7d\x3f\x81\xd4\xb5\x05\x5e\xd6\xf8\xdb\x53\x61\x45\x87\xa4",
          "\x54\x1b\x83\x5d\xc8\x28\xd5\x41\x07\x3f\x7d\x7d\x75\x04\xeb\xf5",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          0, 128 },
        { 128, 192, 128, 134,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "",
          "\x6a\x34\x7a\xd1\x19\x0e\x72\xed\xe6\x11\x04\x4e\x74\x75\xf0\xeb",
          "\xa3\xf3\x61\x54\x33\x1c\x19\x66\x24\x56\x4b\xc3\x95\xe4\x9c\x3b",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          0, 128 },
        { 128, 192, 128, 135,
          "\xfa\xe2\xa1\x41\x97\xc7\xd1\x14\x00\x61\xfe\x7c\x3d\x11\xd9\xf7\x7c"
          "\x79\x56\x2e\x35\x93\xa9\x9b",
          "\xbc\x28\x43\x39\x53\x77\x2d\x57\xbb\xd9\x33\x10\x0c\xd4\x7a\x56",
          "", "", "",
          "\x1b\xb9\x43\x31\xf2\x6c\xad\x24\x03\x6c\xfe\xff\x34\xb8\x9a\xaf", 1,
          0, 0 },
        { 128, 192, 128, 136,
          "\xce\xe9\xab\xbc\x26\xb6\x3e\x16\x9f\x0c\xed\x62\x1f\xe2\x1d\x95\x90"
          "\x4e\x75\xb8\x81\xd9\x3e\x6b",
          "\x1e\x82\x59\xe0\xa4\x3e\x57\x10\x68\xf7\x01\xcd\x20\x64\xfc\x0c",
          "", "\x46", "\xdc",
          "\xaf\x1f\x55\x35\xb1\x25\xb3\x4f\xc4\x66\x90\x2e\xa4\x0c\xb3\xa2", 1,
          0, 8 },
        { 128, 192, 128, 137,
          "\x18\x9f\x0b\xd3\x90\xba\x40\x63\x25\x86\xa4\x5c\x39\x73\x5c\x2b\x87"
          "\x11\x33\x29\xc8\x00\xf3\x94",
          "\xc8\x44\x42\xd6\x97\x5f\x03\x59\x73\x7d\xe0\xfa\x82\x8f\x95\x8e",
          "", "\xb4\xbc\xd7\xb8\xee\xca\x30\x50\xdd\x17\x68\x2c\x6a\x91\x4e",
          "\x2a\xab\x5c\x87\xdc\xb4\xa4\xda\xe4\xe9\x75\xdd\xb6\x5a\xab",
          "\x6b\x03\xb7\x55\x7c\x71\x31\xe2\x35\x2e\x49\x5d\x54\xe6\x1a\xef", 1,
          0, 120 },
        { 128, 192, 128, 138,
          "\xb0\x72\x4f\x15\xdf\x5b\x79\x2c\x2f\x49\xbc\x51\xdf\x0a\xc5\xaa\xd6"
          "\x9b\xe0\x03\x09\x81\x61\x3c",
          "\x13\xcd\x52\x6e\xc7\x7b\x58\xf6\x2d\x48\xd0\x3f\x8b\x88\xf2\xb8",
          "",
          "\x8d\xa3\xab\x9c\x3d\x19\x5b\x04\xdf\x45\x2a\xd2\x39\x53\xda\x4d",
          "\xd1\x27\xfd\x2e\x67\xc0\x88\x7d\x90\xeb\x92\xb9\x1f\x35\x7d\x97",
          "\xeb\x05\xbd\xa9\x37\xfa\xee\xd2\x7f\x88\x33\x29\x5d\x4b\xa5\x59", 1,
          0, 128 },
        { 128, 192, 128, 139,
          "\x99\x87\x50\xba\x78\x48\x41\xe4\x0a\x7c\x5b\x03\x98\x57\x32\xb6\x39"
          "\x7e\x54\x59\xa3\x84\x39\x54",
          "\x1d\x3d\x62\xec\xcd\x8a\xc5\xe8\x96\xf2\x65\x4a\x7f\x60\x6f\xc9",
          "",
          "\x2f\x60\xca\x34\x94\xa9\x58\xdc\x3e\x6e\xbe\xb5\xd0\xb4\xe6\xdd\xa0"
          "\xd0\xc4\x33\x1a\xb9\xc9\x57\xf6\x42\x2a\x51\x00\x87\x8e\xbf",
          "\x34\x4c\x2c\xea\x17\xb0\x6c\xb3\xda\x27\x2e\x22\xa2\x2a\x3a\x71\xee"
          "\x0e\xaa\x19\x59\xa7\xfa\xcf\xff\x46\x46\x60\xdd\xcc\xed\xd1",
          "\xba\xb7\xfb\xf4\x99\xff\x06\xaa\xd5\xf7\x57\xb1\xc1\xa4\xfc\xc0", 1,
          0, 256 },
        { 96, 192, 128, 140,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "",
          "\x0b\x4d\xbb\xba\x89\x82\xe0\xf6\x49\xf8\xba\x85\xf3\xaa\x06\x1b",
          "\x3f\x87\x5c\x9b\xd7\xd8\x51\x14\x48\x45\x94\x68\xe3\x98\xc3\xb2",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          0, 128 },
        { 96, 192, 128, 141,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", "",
          "\x1a\xe9\x36\x88\xef\x7e\x26\x50\xa9\x34\x2a\xd4\x71\x8b\x27\x80",
          "\x21\x0d\xab\xea\x43\x64\xc6\xd5\xb3\x42\x9e\x77\x43\x32\x29\x36",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          0, 128 },
        { 96, 192, 128, 142,
          "\x50\x19\xeb\x9f\xef\x82\xe5\x75\x0b\x63\x17\x58\xf0\x21\x3e\x3e\x5f"
          "\xcc\xa1\x27\x48\xb4\x0e\xb4",
          "\xff\x0d\xdb\x0a\x0d\x7b\x36\xd2\x19\xda\x12\xb5", "", "", "",
          "\x79\x71\x28\x4e\x6c\x9e\x6a\xac\x34\x6f\xe2\xb7\xa0\xa0\x64\xc2", 1,
          0, 0 },
        { 96, 192, 128, 143,
          "\x21\x21\x8a\xf7\x90\x42\x8f\x80\x24\xd3\xe7\xe1\x42\x8c\x9f\xcf\x57"
          "\x8c\x21\x66\x36\xd6\x0e\x73",
          "\x34\x04\x7b\xc3\x9b\x9c\x60\x83\x84\xdf\xf5\xb8", "", "\xe3",
          "\xfe",
          "\x2e\x98\x2e\x24\xb8\x1c\xd1\x20\xd3\x5a\x70\xfe\x69\x35\xe6\x65", 1,
          0, 8 },
        { 96, 192, 128, 144,
          "\x3a\x8b\xf5\x43\xc4\x80\x92\x56\x32\x11\x82\x45\xbc\xbf\x5d\x01\x52"
          "\x2b\x98\x7a\x31\xa3\x3d\xa3",
          "\x4e\xbc\x13\xcf\x46\x36\xcc\x7c\x45\xe5\x60\xa7", "",
          "\x53\xfc\x72\xe7\x1b\x59\xee\xb3",
          "\x99\xf2\xff\x1c\x8a\x44\xe5\xf2",
          "\x68\x70\xf1\x04\xdd\xc5\x14\x47\x7b\x40\x03\x36\xfb\x01\x86\x0e", 1,
          0, 64 },
        { 96, 192, 128, 145,
          "\x92\xf4\xd2\x67\x2f\xce\xec\x43\x96\x3c\xcf\xfb\x17\xe6\xea\x75\x78"
          "\xb1\x14\x18\xb0\x6a\x3b\x82",
          "\x6e\x7f\xf7\xf0\x79\x76\x85\xcf\xc4\x4b\x05\xff", "",
          "\xc3\xec\x16\xad\xb1\x84\xaf\xfa\x8a\xe9\x73\x8b\xff\xb9\x16",
          "\xaf\xe8\xef\x41\x59\x1b\xfc\xc0\x0d\xb3\xc8\x80\xce\xb1\x86",
          "\x29\xff\xf7\xf2\x85\x76\x86\x45\xc9\xc8\xbf\x7a\x47\x1c\x93\x93", 1,
          0, 120 },
        { 96, 192, 128, 146,
          "\xbc\xb6\xbc\x5e\xe6\x74\x3d\xf1\x39\x6a\x34\x63\x93\x27\xb2\x58\x09"
          "\xec\x9c\x81\xdd\x6a\x0c\x0e",
          "\xbe\x03\x26\xd2\x3b\xdc\x2c\x64\x64\x8d\x13\xf4", "",
          "\x80\x47\x4a\x3a\x3b\x80\x95\x60\xee\xe2\xce\x7a\x7a\x33\xea\x07",
          "\x90\x33\x9d\xca\x02\xef\x71\x7f\x16\x03\x99\x4a\xee\x6c\xf6\xd2",
          "\xe3\xd3\x3e\x01\xce\x64\xf2\x71\x78\x31\x47\xde\x22\x62\x28\xbc", 1,
          0, 128 },
        { 96, 192, 128, 147,
          "\x5e\x1d\x28\x21\x3e\x09\x25\x36\x52\x5b\xba\xe0\x9e\x21\x4a\xf4\xc8"
          "\x91\xe2\x02\xb2\xb4\xfa\x4f",
          "\xb6\xbe\x6c\xd0\x68\x12\x35\xd8\x26\xaa\x28\xea", "",
          "\x53\xd5\x94\x33\xa7\xdb\x7f\x41\xb3\x1c\xcb\x6d\x4a\x2d\x78\x99"
          "\x65",
          "\xb9\x8e\xd6\x32\x16\x79\x94\x1a\x3e\x52\x18\x34\x29\x66\x86\xad"
          "\x98",
          "\x9f\x50\xc0\x3e\x05\x5e\x51\x97\x12\xc5\x82\xec\x9d\xb3\x23\x5b", 1,
          0, 136 },
        { 96, 192, 128, 148,
          "\x7f\x67\x2d\x85\xe1\x51\xaa\x49\x0b\xc0\xee\xc8\xf6\x6b\x5e\x5b\xee"
          "\x74\xaf\x11\x64\x2b\xe3\xff",
          "\xb0\x22\x06\x70\x48\x50\x5b\x20\x94\x62\x16\xef", "",
          "\xef\x64\x12\xc7\x2b\x03\xc6\x43\xfa\x02\x56\x5a\x0a\xe2\x37\x8a\x93"
          "\x11\xc1\x1a\x84\x06\x5f\x80",
          "\xad\xdd\x30\x36\x51\x11\x9e\x52\xf6\x17\x0d\xfc\x7a\x91\x50\x64\x25"
          "\x3d\x57\x53\x29\x87\xb9\xab",
          "\xfa\x04\x84\xf8\xba\xa9\x5f\x5b\x7a\x31\xc5\x6d\x1b\x34\xc5\x8b", 1,
          0, 192 },
        { 96, 192, 128, 149,
          "\x96\x9f\xed\x50\x68\x54\x1d\x65\x41\x8c\x2c\x1d\xe8\xfe\x1f\x84\x5e"
          "\x03\x60\x30\x49\x6e\x12\x72",
          "\x81\x7f\xe5\x1c\x31\xf2\x87\x91\x41\xa3\x43\x35", "\xcb",
          "\x3d\x82\x33\x19\x1a\x28\x23\xbf\x76\x7e\x99\x16\x7b\x1d\x4a\xf4\xf4"
          "\x84\x84\x58",
          "\x0d\x2c\x3a\x3c\x0c\xc4\xb4\x0e\x70\xed\x45\xe1\x88\xe3\x56\xa0\xe1"
          "\x53\x3b\x31",
          "\x92\x90\x9a\x80\xe9\x05\x40\xe1\x87\x8a\xb5\x9e\xf3\x00\x07\x2b", 1,
          8, 160 },
        { 96, 192, 128, 150,
          "\xfa\x5b\x9b\x41\xf9\x3f\x8b\x68\x2c\x04\xba\x81\x6c\x3f\xec\xc2\x4e"
          "\xec\x09\x5b\x04\xdd\x74\x97",
          "\x62\xb9\xcf\x1e\x92\x3b\xc1\x13\x8d\x05\xd2\x05",
          "\x2e\xd8\x48\x71\x53\xe2\x1b\x12",
          "\x18\x15\x98\x41\x81\x3a\x69\xfc\x0f\x8f\x42\x29\xe1\x67\x8d\xa7\xc9"
          "\x01\x67\x11",
          "\xc7\xc1\xcb\xb8\x5c\xe2\xa0\xa3\xf3\x2c\xb9\xef\x01\xad\x45\xec\x11"
          "\x18\xb6\x6d",
          "\x25\x33\x17\xf9\x8b\xda\xb8\x75\x31\xec\xe2\x04\x75\xcd\x9e\xbb", 1,
          64, 160 },
        { 96, 192, 128, 151,
          "\xfb\xfb\x39\x56\x62\x78\x7e\x2d\x25\xa2\xe7\x51\x0f\x81\x8e\x82\x59"
          "\x36\xa3\x51\x14\xe2\x37\xc9",
          "\x3f\x1a\x1e\x02\xe9\x0a\x4b\xa7\xa1\xdb\x9d\xf2",
          "\x74\x31\x8d\x88\x76\x52\x82\x43\xf1\x94\x4b\x73\xeb\x77\xe9\x6e",
          "\x29\x52\xa3\xd6\x41\x07\xd5\xcb\xb9\x60\x22\x39\xd0\x5a\x5c\x5c\x22"
          "\x2c\xf7\x2b",
          "\xec\xf5\xe4\x03\xf1\x9c\x00\x7c\x8d\xa7\xa4\x56\xca\xf0\xa6\xd7\x57"
          "\x62\x82\x9b",
          "\xe0\x87\x7a\x10\x0f\x9d\xd9\xd6\x79\x5f\x0e\x74\xc5\x6a\x9f\xab", 1,
          128, 160 },
        { 96, 192, 128, 152,
          "\x5d\x8e\x9c\x22\x22\x31\x6c\x9e\xd5\xff\x94\x51\x3c\xc9\x57\x43\x6a"
          "\xe4\x47\xa6\xe1\xa7\x3a\x29",
          "\x08\x02\xae\x86\xc7\x5a\x73\xbf\x79\x56\x15\x21",
          "\x5c\xa3\x54\xa4\xcb\x8e\x4f\xc9\x79\x8a\xa2\x09\xad\x4f\x73\x9d\xc7"
          "\xc2\x32\xfd\xd1\xf2\x25\x84",
          "\x42\xb4\x43\x9e\x1d\x21\x16\xf8\x34\xb9\x1c\x51\x6a\x26\x29\x9d\xf2"
          "\x79\x95\x6b",
          "\x94\xd8\x44\xd9\x8b\x94\x67\xda\xa7\xe8\xdd\xe7\xf4\x29\x00\x37\x35"
          "\x4d\x7f\xb2",
          "\x62\x19\x66\x38\x59\x0c\xef\x42\x9d\x6b\x1d\x1a\x59\x83\x9c\x02", 1,
          192, 160 },
        { 96, 192, 128, 153,
          "\xcc\xbd\x0f\x50\x98\x25\xa5\xf3\x58\xa1\x4a\xac\x04\x4a\xe2\x82\x6b"
          "\xb2\xc9\xea\xaa\xaa\x07\x7f",
          "\x91\x89\xa7\x1a\xc3\x59\xb7\x3c\x8c\x08\xdf\x22", "",
          "\xa1\xed\x10\x07\xb5\x2e\x36\xec\x0f\x70\x10\x9c\x68\xda\x72\xee\x7b"
          "\x67\x5c\x85\x5e\x3e\x49\x56\xd2\xdc\xf9\xd1\x2f\x67\x5d\x69\x33\xf6"
          "\x77\xdd\xcc\x58\xfa\xce\x85\x76\x99\xd2\xe3\xd9\x0a\xdc\xb8\xc6\xc5"
          "\x7c\x9d\x88\xb5\xdf\xcf\x35\x6d\xe4\xc0\xb6\x3f\x0e",
          "\xe9\x91\x5b\xc5\xae\xa6\x3c\x8b\xc0\x14\xf2\xae\x6a\x49\x86\xb0\x31"
          "\x15\xff\x1f\x34\xad\x6c\x0a\xcd\x74\xff\xca\x07\xc4\x53\xec\x3f\x3c"
          "\xe6\x90\x2d\x5f\xf3\x38\xc5\x88\xa3\x4a\x1c\x3b\x30\xef\x75\x3e\xc7"
          "\x00\x15\x72\xcb\xfe\xaf\xe6\x90\xfd\x00\xf5\x9b\x02",
          "\xfb\xf1\x9b\x6b\x90\xe2\xd9\xdf\x7e\xad\x0c\x3b\xc6\xe3\x75\xa2", 1,
          0, 512 },
        { 96, 192, 128, 154,
          "\xd0\x45\xc6\xeb\x17\x3f\x44\x08\x43\xfa\xec\x3e\x93\x74\x60\x2a\x94"
          "\xee\x3f\x71\x76\x31\x22\x08",
          "\x98\xe9\x15\x3d\xac\xa2\x52\x2e\x31\x62\xcb\x15", "",
          "\x3f\x0b\x30\xdc\x96\x3a\x82\xd1\x82\xc0\x35\xb5\xa8\x23\x06\x0f\x07"
          "\xc4\x12\x37\x92\xe6\xce\xe6\xbf\x91\xfe\xa3\xc5\x2f\xa6\x6b\xb6\xa9"
          "\x3e\xa6\xcc\xe9\xf4\x81\x3e\xb9\x5b\xf1\x8f\x81\x6c\x00\xad\x4f\xb5"
          "\x69\x32\x82\x7a\x39\xef\xb2\xfe\x56\x80\x4e\x60\x4a\x60\x67\x74\xee"
          "\x92\xad\x46\xcd\x8c\x17\x2a\x0d\x2b\xde\xa2\xfc\x99\xf6\x7c\xd8\x2c"
          "\x60\x24\xc3\x15\xcf\xee\x6d\xbb\x8d\x27\xf7\x45\xc9\xd0\xce\x9b\xf5"
          "\xd0\x97\x24\xf4\xbe\xd0\x03\xcf\x39\x47\x83\x48\xb3\x30\x4b\xaa\x4e"
          "\xcc\x99\x74\xfc\x4f\x3f\xf9\x3f\x95",
          "\x96\x63\xe6\xf9\x8b\x27\x68\x44\x8e\x6d\xd0\xdd\x78\x0e\x14\x56\x68"
          "\xaf\x5b\x00\x22\x57\xe3\x53\x21\x38\x68\xc9\xcd\x9f\xd3\xa1\xe9\x42"
          "\x75\x30\x32\x75\x41\x77\x5a\x09\x31\x23\x07\x6d\x34\x98\x5d\xb3\xaa"
          "\x24\x8c\xd5\x5e\x53\x26\x09\xd1\xa3\x92\x74\xc4\x92\x16\xea\x20\xfb"
          "\xab\x71\x9b\x9c\x7e\x31\x0b\x27\x87\x7b\x9a\x33\xd1\xb6\x9a\xb7\x47"
          "\xaf\xac\x94\x4d\x1e\x97\xea\x78\x93\x67\x82\x1c\x33\x1f\x00\xb5\xd6"
          "\x18\x40\x2b\xfc\x57\x88\x4d\x18\xed\xbd\x60\xc4\xdf\xe2\x18\xc0\x80"
          "\x80\xb8\xe3\x47\x9f\xf8\x4b\xdf\xb5",
          "\xfc\x2f\xf6\x2a\x41\xbd\xb7\x9a\xfc\x36\x98\x42\xe4\xec\xca\xbf", 1,
          0, 1024 },
        { 96, 192, 128, 155,
          "\xe6\x02\x18\x8a\xbf\x6a\x91\xf3\xe2\x58\x83\x8c\xea\x6b\xef\xef\xfc"
          "\xf6\x25\x7a\x50\x9c\x3e\x95",
          "\x9e\x35\xd3\xef\x18\x97\xc5\xfe\x3f\x64\x72\x04", "",
          "\x3b\x9a\x6e\xdc\x44\x84\x8c\x07\x23\x41\xfd\x4a\xf5\x1e\xc1\x16\xac"
          "\x32\x8f\x69\xcc\x5a\x33\x54\xe4\x92\x99\xfb\x2e\x5d\x22\xfa\x00\x84"
          "\xe3\x0b\x36\xec\xaf\x54\x30\x93\x97\xb2\xb4\x98\xd6\x86\x08\x7f\x34"
          "\x57\x69\x8c\x36\x39\xe7\x3c\xa1\x8c\x78\xc3\xe0\x21\xd6\x73\x98\x6c"
          "\xfc\x2c\xeb\x4d\x07\xe6\x69\x71\xe9\x76\xf5\x8f\x03\x36\xf8\x2c\x7f"
          "\xc0\xd5\x2d\x66\x61\x0f\x26\xca\x3b\xfe\x53\xc0\xb0\x1c\xf7\xc2\x07"
          "\x30\x6d\xb9\x04\xc1\xad\x30\x0a\xb9\x5c\x56\xfd\xe8\x20\xa8\xed\xd2"
          "\x56\xf2\xb9\x90\x6b\x31\x2b\xf7\xaf\x5e\xf4\xa8\x06\xf6\x18\xdd\xfc"
          "\xb6\x71\x79\xb0\x3f\xff\x80\xa2\x45\xc3\x8d\x8f\x4c\xff\x28\x75\xb7"
          "\x1a\x0b\xf6\x91\x29\xca\xf9\x71\x21\x46\x2e\x05\x01\xec\x65\x74\xed"
          "\xe9\x47\x06\xf4\xa0\x4d\x2f\xb3\x01\xd4\x15\xc2\x2e\xa1\x21\x57\xd2"
          "\xe9\x19\xbc\x7a\x01\x69\xa5\xad\x5c\x7b\xb5\x76\x1a\x85\x31\xab\xbe"
          "\x77\xd6\x6a\x48\x71\xb3\xf2\x7a\x71\x70\xf0\x99\x04\x4b\x9f\xdc\x50"
          "\xa8\xcb\x3b\x89\x42\x52\xa5\x01\xcc\x89\x6a\xc4\x79\x3b\xdb\x47\x8b"
          "\xb1\xcb\x99\xc0\x23\x41\xd7\x23\x8d\xd8\xd5\x93\xcf\xda\x02\xf7\xd5"
          "\x20\xd7",
          "\x16\x71\x83\x66\x16\x75\x67\x76\x25\xbe\xd2\xd5\xf5\x5f\x72\x8d\xab"
          "\x80\xd7\xf0\x6f\x62\x9d\x99\xe5\x8b\x45\x06\x9f\xe9\xd7\x42\x8e\x89"
          "\x61\x56\x1b\x11\x24\x5c\x70\x9a\xc9\xeb\xb5\xc5\x9a\xc2\xa8\x9d\x83"
          "\x75\xd8\xa0\x1d\x84\x9c\x77\x33\xa1\xb4\x82\x52\x99\x27\xe3\xf1\xa1"
          "\xa5\x3f\x63\xa4\xbe\x08\xa1\x1c\x94\x1c\x63\x4c\xd4\x03\x73\xc4\x2f"
          "\xfb\x24\x49\xc6\x41\xbc\x9e\x39\xea\xfb\xcf\x9c\x0f\xba\x67\x7e\x36"
          "\x49\x6f\x73\xfc\x70\xaa\x09\x72\x22\x49\x01\xab\x04\xb0\xa1\x96\xab"
          "\x74\x52\x62\x02\x1b\x23\x13\xa8\x46\x41\x87\xfe\xce\xc4\x3a\xdb\x40"
          "\x62\x58\xbd\xdc\xd8\xc9\xd0\x4d\xc2\xae\x29\xe6\x5d\x54\xa8\x9d\xd0"
          "\xf1\x75\x2d\x6d\x95\x0d\xbf\x7d\xa4\xde\xa0\xa7\xb9\x46\x55\x79\x50"
          "\x3f\xc8\xec\x44\x51\xf4\xb3\x98\x78\xac\x47\x54\xa1\xaa\xf7\xb0\xb7"
          "\x3f\xee\x11\x21\x3c\xb8\xe6\x01\xfc\x60\x39\x39\x3f\x72\xe0\xe0\x79"
          "\xee\x97\xec\xc6\x10\x24\x17\x57\xda\x2d\xb2\xf5\x1d\x5e\xd1\x21\x48"
          "\x15\x40\xef\xf4\x72\x87\x74\x4d\xac\x43\x37\x5c\x4f\x48\xa4\x6a\xf7"
          "\x01\x90\x45\x3a\x17\xc3\xc7\x8d\x73\x5b\xa1\xd1\xfc\x76\xa3\x30\xe6"
          "\xcb\xed",
          "\xc7\x20\x35\x31\x4f\x43\xd2\x56\xf8\xd8\x45\xeb\x69\x6b\xd9\x43", 1,
          0, 2056 },
        { 96, 192, 128, 156,
          "\x55\xa4\xca\x52\x64\x43\x35\x7a\xc7\xc8\x96\xd9\xa6\x7c\xf7\xd4\x67"
          "\xf6\x92\x1d\x69\x00\x2d\x3a",
          "\xdb\xa2\x33\xcc\xbc\x79\x92\xe6\x4e\x82\xcf\xa3",
          "\xdf\x73\x7c\xd7\x7d\x31\xeb\x90\x97\xa1\x7c\x31\xb4\xc9\x28\x89\xef"
          "\x1f\x32\xb7\x46\x4e\x26\x20\xe9\x00\x71\x92\xea\x67\x5b\x9a\xd6\x91"
          "\x05\x27\xff\xec\xee\x24\x52\xbe\x02\x48\xfa\xb7\x56\x08\xc7\xfd\xca"
          "\x08\xe8\x65\x80\x32\x2a\xac\x1d\x6a\x11\xb9\x6e\xcf",
          "\x4e\x56\xd1\xea\x53\x8c\xf4\x9c\xad\x49\x95\x9e\x88\x4e\xb5\x40\xc8"
          "\x46\x55\x6c",
          "\x3f\x57\xec\x1b\x41\x4f\x74\x81\x8f\xea\xd9\xf3\x5a\xa1\x67\x94\x02"
          "\xc3\xe7\x50",
          "\x97\xb8\x9b\x29\x14\x19\xe3\x2c\xf6\x54\xea\x63\x0a\x3a\xd0\x14", 1,
          512, 160 },
        { 96, 192, 128, 157,
          "\xf3\x81\xd0\xff\xd3\x37\x3a\x1a\xa0\x2e\xdd\x1d\x7f\xa7\x48\xe9\x19"
          "\x08\xfe\x53\x4b\xef\x73\xd2",
          "\x10\xaa\xec\x0d\xe4\xad\x75\x37\x6b\xe9\xfd\x41",
          "\x77\x39\xaa\xd7\x39\x9d\x9c\x0f\x0a\x3c\x95\xb4\x03\x88\x8f\x00\x72"
          "\xd9\x4a\xcb\x76\xff\x57\x6e\x05\xf4\xa0\x63\x12\x0b\x84\xe7\x22\xb4"
          "\xd5\xcd\x43\xa5\x8e\x4a\xba\xb4\x44\xcb\x8c\xed\x11\x2f\x3d\xbd\x89"
          "\x93\xb8\x31\xc3\x9b\x4e\xdb\x76\xe9\x2e\xb3\x3e\xe2\x4c\x59\x22\xb5"
          "\x65\x52\x68\x5f\x3b\x0f\x4c\xf2\x2e\x0e\x11\x62\x8f\x6a\x3d\x33\xef"
          "\xf9\xde\xf7\xec\x52\x71\x12\xdf\xaf\xcf\x12\x28\x14\xe3\xd1\xaa\xf6"
          "\x6c\x3f\x97\x05\x26\x51\x10\x88\xbf\xfe\xf8\x10\x1d\x1c\xef\x83\x32"
          "\x68\xff\x80\x38\x7d\xf3\x05\x57\xf7",
          "\x65\x3a\x3f\x03\x3c\x27\x75\xe0\x8f\xef\x73\xcf\x80\xf5\xe2\x69\x9f"
          "\xb3\x60\xcb",
          "\x55\x65\xc6\xd0\x9c\x4c\x92\x4d\x61\xc0\xef\x80\x8f\xb0\xea\x14\x4f"
          "\xfb\x47\x38",
          "\x12\xb7\x2e\xc1\xd9\xc3\x2f\xb2\x2c\x13\xc4\x0b\x33\x79\x6f\xa9", 1,
          1024, 160 },
        { 96, 192, 128, 158,
          "\x8f\x27\xb1\xc3\xb3\xd7\x02\x3c\x76\xee\x66\xc7\x68\xa3\xe9\x2d\x49"
          "\x71\xe2\x5f\x72\x9d\x87\x88",
          "\x12\x44\x40\x40\xca\xed\xe6\x72\x85\xe4\x90\xd7",
          "\x58\xfd\x02\xac\x23\xec\x7f\xa5\xb9\x46\x0f\x60\xbf\xc8\x5b\x4b\xeb"
          "\xba\x70\x03\x9a\x8f\x83\x26\x1d\x6c\xc4\xf5\x60\x10\x7c\x10\xbc\x69"
          "\x54\x8a\x5d\x61\x52\x88\x2f\xb4\x65\xfd\x59\xfb\x81\x64\xd7\xc9\x45"
          "\x23\xc3\xdd\x42\x06\xd3\x30\x64\xf5\x19\x1b\xd3\x1f\x0c\x48\xfe\x03"
          "\xd7\x46\x0e\x99\x5c\x93\x17\x5b\x57\xcb\x03\xf5\x87\x11\xad\xc9\x46"
          "\x32\x03\x1c\x43\x05\x27\x23\x67\xb4\x28\x9c\x72\x5d\x9c\xb7\xae\x9b"
          "\xa9\x96\xb3\xa0\x79\x17\x45\x08\xc1\xea\xe8\x16\x2a\x0b\xac\x44\x6c"
          "\x1e\x53\xfe\x0c\x40\x2b\x69\x12\xdf\xd6\x70\x2a\xdd\xcc\xad\xa3\x0a"
          "\x5c\x01\x0f\xc2\x2c\x2c\x75\xe4\x32\x26\x37\x8e\xc7\xf4\xb3\xb7\x1c"
          "\xcc\x71\xf3\x2a\xb1\xad\xc8\x77\xcc\x7b\x0a\x18\x0c\x75\xd3\x85\xc0"
          "\xf7\x1a\x0b\x29\x1a\x1c\xcc\xf4\xbe\x47\xe2\x72\x24\x9d\x61\xff\xbf"
          "\x05\x9c\x4f\x7b\xe7\x4e\xba\x07\xd5\xe1\xbe\x3a\x74\x38\x45\x8a\x61"
          "\x1f\xe5\x8c\xee\x4f\x94\x6e\x25\xde\xe0\x3e\x64\x85\x23\x55\x66\xf2"
          "\x0e\xd5\x55\xbe\x32\xcd\x57\xa9\x4e\x52\x2d\x21\x68\xea\xe2\x3c\x45"
          "\x87\x37\x1a\x2d\x14\x5f\x41\x8c\x59\xe7\xbb\xc4\x64\xa3\xbd\x88\xb8"
          "\x91\x9b",
          "\x0d\xf6\xe7\x50\x09\x2b\x9a\xc5\x76\xdd\xe6\x60\x06\xa4\xca\xb2\x11"
          "\x6e\xee\x21",
          "\xc6\x87\x7b\x03\x55\x2e\x97\xd9\xa1\xe6\x55\x7f\x90\xdc\x7a\xdd\xe1"
          "\x5a\x2f\x43",
          "\x25\x36\x27\x2b\xee\x74\x46\x82\x00\x41\x85\x4e\x10\xb4\x9a\x03", 1,
          2056, 160 },
        { 96, 192, 128, 159,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb5\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 160,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb6\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 161,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\x34\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 162,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe5\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 163,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\xdb\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 164,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2e\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 165,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2d\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 166,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\xcc\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 167,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x79\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 168,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\xf8\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 169,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xd3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 170,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x59\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 171,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0c\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 172,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0f\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 173,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x8d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 174,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x65", 0,
          0, 128 },
        { 96, 192, 128, 175,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x66", 0,
          0, 128 },
        { 96, 192, 128, 176,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\x24", 0,
          0, 128 },
        { 96, 192, 128, 177,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x78\xf3\x58\xda\x0d\x99\xcb\xe4", 0,
          0, 128 },
        { 96, 192, 128, 178,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb5\xe4\x4c\x5b\x2f\xe9\x0e\x4c\x79\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 179,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\xdb\x2f\xe9\x0e\xcc\x78\xf3\x58\xda\x0d\x99\xcb\x64", 0,
          0, 128 },
        { 96, 192, 128, 180,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb4\xe4\x4c\x5b\x2f\xe9\x0e\xcc\x78\xf3\x58\xda\x0d\x99\xcb\xe4", 0,
          0, 128 },
        { 96, 192, 128, 181,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\x4b\x1b\xb3\xa4\xd0\x16\xf1\xb3\x87\x0c\xa7\x25\xf2\x66\x34\x9b", 0,
          0, 128 },
        { 96, 192, 128, 182,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          0, 128 },
        { 96, 192, 128, 183,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          0, 128 },
        { 96, 192, 128, 184,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\x34\x64\xcc\xdb\xaf\x69\x8e\xcc\xf8\x73\xd8\x5a\x8d\x19\x4b\xe4", 0,
          0, 128 },
        { 96, 192, 128, 185,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x45\x82\x56\x84\x2d\xfd\x29\x7f\x30\xbd\x2f\x8f\x15\xc9\x2d\xb0",
          "\xb5\xe5\x4d\x5a\x2e\xe8\x0f\x4d\x79\xf2\x59\xdb\x0c\x98\xca\x65", 0,
          0, 128 },
        { 128, 256, 128, 186,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x5c\x2e\xa9\xb6\x95\xfc\xf6\xe2\x64\xb9\x60\x74\xd6\xbf\xa5\x72",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x28\xe1\xc5\x23\x2f\x4e\xe8\x16\x1d\xbe\x4c\x03\x63\x09\xe0\xb3\x25"
          "\x4e\x92\x12\xbe\xf0\xa9\x34\x31\xce\x5e\x56\x04\xc8\xf6\xa7\x3c\x18"
          "\xa3\x18\x30\x18\xb7\x70",
          "\xd5\x80\x8a\x1b\xd1\x1a\x01\x12\x9b\xf3\xc6\x91\x9a\xff\x23\x39", 1,
          0, 320 },
        { 128, 256, 128, 187,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x57\xb3\xa8\x1f\x2c\x36\xb6\xb0\x65\x77\xca\x0f\xba\xb8\xfa\x8e",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xcc\xee\xbe\xb4\xfe\x4c\xd9\x0c\x51\x4e\x52\xd2\x32\x7a\x2e\xcd\x75"
          "\x39\x36\x61\x00\x6c\xf2\x47\x6d\x86\x20\x14\x9a\xef\x3d\x1c\xdc\xe4"
          "\x91\xff\xf3\xe7\xa7\xa3",
          "\x81\x32\xe8\x65\xb6\x9d\x64\xef\x37\xdb\x26\x1f\x80\xcb\xbe\x24", 1,
          0, 320 },
        { 128, 256, 128, 188,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\xce\x20\xa7\xe8\x70\x69\x6a\x5e\x68\x53\x3c\x46\x5b\xad\x2b\xa1",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x4f\x43\x50\x56\x5d\x91\xd9\xaa\x8c\x5f\x40\x48\x55\x04\x92\xad\x6d"
          "\x6f\xda\xbf\x66\xda\x5d\x1e\x2a\xf7\xbf\xe1\xa8\xaa\xda\xa0\xba\xa3"
          "\xde\x38\xa4\x1d\x97\x13",
          "\x15\x5d\xa6\x44\x1e\xc0\x71\xef\x2d\x8e\x6c\xff\xba\xcc\x1c\x7c", 1,
          0, 320 },
        { 128, 256, 128, 189,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x91\x8e\x3c\x19\xdb\xdf\xee\x2d\xb1\x81\x56\xc5\xb9\x3f\x3d\x75",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x83\x16\xa5\x31\x67\xb6\xde\x1a\x75\x75\x70\x06\x93\xff\xef\x27\x4f"
          "\x43\x50\x56\x5d\x91\xd9\xaa\x8c\x5f\x40\x48\x55\x04\x92\xad\x6d\x6f"
          "\xda\xbf\x66\xda\x5d\x1e",
          "\x6c\x57\x4a\xa6\xa2\x49\x0c\xc3\xb2\xf2\xf8\xf0\xff\xbc\x56\xc4", 1,
          0, 320 },
        { 128, 256, 128, 190,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x71\x7d\x90\x0b\x27\x04\x62\xb9\xdb\xf7\xe9\x41\x9e\x89\x06\x09",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x51\x75\x92\x75\x13\xe7\x51\xeb\x30\x9f\x45\xbc\x2e\xf2\x25\xf2\x83"
          "\x16\xa5\x31\x67\xb6\xde\x1a\x75\x75\x70\x06\x93\xff\xef\x27\x4f\x43"
          "\x50\x56\x5d\x91\xd9\xaa",
          "\x80\x82\xa7\x61\xe1\xd7\x55\x34\x4b\xf2\x96\x22\x14\x4e\x7d\x39", 1,
          0, 320 },
        { 128, 256, 128, 191,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\xec\xd5\x21\x20\xaf\x24\x0e\x9b\x4b\xf3\xb9\xd1\xee\xb4\x94\x34",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x36\xb3\xfb\xec\xd0\x91\x78\xd0\x45\x27\xfb\x37\x54\x4f\x55\x79\xd2"
          "\x0d\x60\xa4\x12\x66\xf6\x85\xc4\x80\x98\xe1\xa5\x28\x04\xca\x38\x7d"
          "\x90\x70\x9d\x32\x68\xdd",
          "\x03\x3e\x0e\xf2\x95\x3e\xbf\xd8\x42\x57\x37\xc7\xd3\x93\xf8\x9a", 1,
          0, 320 },
        { 128, 256, 128, 192,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\xb3\x7b\xba\xd1\x04\x92\x8a\xe8\x92\x21\xd3\x52\x0c\x26\x82\xe0",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x16\x92\x9b\x77\x30\x51\xf1\x2b\x0a\xda\xc9\x5f\x65\xe2\x1a\x7f\x36"
          "\xb3\xfb\xec\xd0\x91\x78\xd0\x45\x27\xfb\x37\x54\x4f\x55\x79\xd2\x0d"
          "\x60\xa4\x12\x66\xf6\x85",
          "\xca\x44\x8b\xb7\xe5\x2e\x89\x7e\xca\x23\x4e\xf3\x43\xd0\x57\xd0", 1,
          0, 320 },
        { 128, 256, 128, 193,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x53\x88\x16\xc3\xf8\x49\x06\x7c\xf8\x57\x6c\xd6\x2b\x90\xb9\x9c",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x6d\x3f\xae\xfa\xf6\x91\xd5\x81\x63\x84\x6f\x8d\x4b\x9f\xfd\x59\x16"
          "\x92\x9b\x77\x30\x51\xf1\x2b\x0a\xda\xc9\x5f\x65\xe2\x1a\x7f\x36\xb3"
          "\xfb\xec\xd0\x91\x78\xd0",
          "\x84\xf4\x97\x40\xe6\x75\x7f\x63\xdd\x0d\xf7\xcb\x76\x56\xd0\xef", 1,
          0, 320 },
        { 128, 256, 128, 194,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\xd1\x0e\x63\x19\x43\xcd\x3b\xda\xba\xba\xb2\xbb\xd1\x39\x51\xc0",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xd6\x01\x96\xc2\xd1\x4f\xcf\x30\xc0\x99\x1d\x27\x21\xdd\xc5\x2d\x38"
          "\x5f\x40\x7a\x16\x69\x1d\xad\xe8\x2c\x90\x23\xc8\x55\xfd\x8e\x2e\x8f"
          "\xbb\x56\x21\x02\xf0\x18",
          "\x87\x7e\x15\xd9\x88\x9e\x69\xa9\x9f\xcc\x6d\x72\x74\x65\xc3\x91", 1,
          0, 320 },
        { 128, 256, 128, 195,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x8e\xa0\xf8\xe8\xe8\x7b\xbf\xa9\x63\x68\xd8\x38\x33\xab\x47\x14",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x94\x8f\xbc\xec\xa1\x2a\x6e\x4f\xab\xb7\x9b\x6d\x96\x5e\x33\x6f\xd6"
          "\x01\x96\xc2\xd1\x4f\xcf\x30\xc0\x99\x1d\x27\x21\xdd\xc5\x2d\x38\x5f"
          "\x40\x7a\x16\x69\x1d\xad",
          "\xcd\x57\x57\x62\x69\x45\x97\x6b\xa9\xf0\x26\x4b\xd6\xbe\xe8\x94", 1,
          0, 320 },
        { 128, 256, 128, 196,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x7b\x2d\xf4\xfb\xed\x1d\xe2\x72\x7e\xb2\x48\x98\xe5\xde\xab\xb9",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\xa1\xa0\x12\x06\x60\xff\x52\xe6\xb1\x70\x0b\x12\xc5\x4d\x2d\x33\xb9"
          "\x4b\x00\xcd\x78\x82\xd8\x85\x7d\x84\xe6\xe1\x83\xa1\xde\xa6\xee\x85"
          "\xa7\xda\x84\xfb\xc3\x5d",
          "\xb0\x15\xd7\x2d\xa6\x2c\x81\xcb\x4d\x26\x72\x53\xb2\x0d\xb9\xe5", 1,
          0, 320 },
        { 128, 256, 128, 197,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x24\x83\x6f\x0a\x46\xab\x66\x01\xa7\x60\x22\x1b\x07\x4c\xbd\x6d",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00",
          "\x5e\x34\x34\xb4\x5e\xdb\xf0\xd1\xf6\xe0\x2d\x11\x44\xdb\xf8\x67\xa1"
          "\xa0\x12\x06\x60\xff\x52\xe6\xb1\x70\x0b\x12\xc5\x4d\x2d\x33\xb9\x4b"
          "\x00\xcd\x78\x82\xd8\x85",
          "\xee\x74\xcc\xb3\x0d\x64\x9e\xbf\x69\x16\xd0\x5a\x7d\xbe\x56\x96", 1,
          0, 320 },
        { 128, 256, 128, 198,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "",
          "\x8d\x74\xf1\xc9\x72\x43\xd3\x62\x57\x7f\xf3\x76\xc3\x93\xd2\xdc",
          "\x26\x5c\x42\xe2\xb9\x6e\xa1\xde\x9c\x24\xf7\x18\x2e\x33\x73\x90",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1,
          0, 128 },
        { 128, 256, 128, 199,
          "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x10"
          "\x21\x32\x43\x54\x65\x76\x87\x98\xa9\xba\xcb\xdc\xed\xfe\x0f",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "",
          "\x88\x4d\xf0\xe7\x6f\x3c\xe2\x27\xbf\x95\x95\xd1\x03\x82\x5a\x46",
          "\x98\x8f\x47\x66\x8e\xa6\x50\xcb\xaa\x67\x14\x71\x1a\xbe\x26\x8d",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 1,
          0, 128 },
        { 128, 256, 128, 200,
          "\xb4\xcd\x11\xdb\x0b\x3e\x0b\x9b\x34\xea\xfd\x9f\xe0\x27\x74\x69\x76"
          "\x37\x91\x55\xe7\x61\x16\xaf\xde\x1b\x96\xd2\x12\x98\xe3\x4f",
          "\x00\xc4\x9f\x4e\xbb\x07\x39\x3f\x07\xeb\xc3\x82\x5f\x7b\x08\x30",
          "", "", "",
          "\x30\x6f\xe8\xc9\x64\x5c\xc8\x49\x82\x3e\x33\x3a\x68\x5b\x90\xb2", 1,
          0, 0 },
        { 128, 256, 128, 201,
          "\xb7\x79\x7e\xb0\xc1\xa6\x08\x9a\xd5\x45\x2d\x81\xfd\xb1\x48\x28\xc0"
          "\x40\xdd\xc4\x58\x9c\x32\xb5\x65\xaa\xd8\xcb\x4d\xe3\xe4\xa0",
          "\x0a\xd5\x70\xd8\x86\x39\x18\xfe\x89\x12\x4e\x09\xd1\x25\xa2\x71",
          "", "\xed", "\x3f",
          "\xfd\x8f\x59\x3b\x83\x31\x4e\x33\xc5\xa7\x2e\xfb\xeb\x70\x95\xe8", 1,
          0, 8 },
        { 128, 256, 128, 202,
          "\x4c\x01\x0d\x95\x61\xc7\x23\x4c\x30\x8c\x01\xce\xa3\x04\x0c\x92\x5a"
          "\x9f\x32\x4d\xc9\x58\xff\x90\x4a\xe3\x9b\x37\xe6\x0e\x1e\x03",
          "\x2a\x55\xca\xa1\x37\xc5\xb0\xb6\x6c\xf3\x80\x9e\xb8\xf7\x30\xc4",
          "", "\x2a\x09\x3c\x9e\xd7\x2b\x8f\xf4\x99\x42\x01\xe9\xf9\xe0\x10",
          "\x04\x13\x41\x07\x8f\x04\x39\xe5\x0b\x43\xc9\x91\x63\x51\x17",
          "\x5b\x8a\x2f\x2d\xa2\x0e\xf6\x57\xc9\x03\xda\x88\xef\x5f\x57\xbb", 1,
          0, 120 },
        { 128, 256, 128, 203,
          "\xe7\xf7\xa4\x8d\xf9\x9e\xdd\x92\xb8\x1f\x50\x86\x18\xaa\x96\x52\x6b"
          "\x27\x9d\xeb\xd9\xdd\xb2\x92\xd3\x85\xdd\xba\xe8\x0b\x22\x59",
          "\x7e\xe3\x76\x91\x0f\x08\xf4\x97\xaa\x6c\x3a\xa7\x11\x36\x97\xfd",
          "",
          "\x5e\x51\xdb\xbb\x86\x1b\x5e\xc6\x07\x51\xc0\x99\x6e\x00\x52\x7f",
          "\x46\x94\x78\xd4\x48\xf7\xe9\x7d\x75\x55\x41\xaa\x09\xad\x95\xb0",
          "\x25\x4a\xda\x5c\xf6\x62\xd9\x0c\x5e\x11\xb2\xbd\x9c\x4d\xb4\xc4", 1,
          0, 128 },
        { 128, 256, 128, 204,
          "\x4f\x84\x78\x2b\xfb\xb6\x4a\x97\x3c\x3d\xe3\xdc\xfa\x34\x30\x36\x7f"
          "\xd6\x8b\xc0\xb4\xc3\xb3\x1e\x5d\x7c\x81\x41\xba\x3e\x6a\x67",
          "\x5d\x1b\xde\x6f\xa0\x99\x4b\x33\xef\xd8\xf2\x3f\x53\x12\x48\xa7",
          "",
          "\x78\xcb\x66\x50\xa1\x90\x8a\x84\x21\x01\xea\x85\x80\x4f\xed\x00\xcc"
          "\x56\xfb\xda\xfa\xfb\xa0\xef\x4d\x1c\xa6\x07\xdc\xae\x57\xb6",
          "\xcb\x96\x02\x01\xfa\x5a\xd4\x1d\x41\xd1\xc2\xc8\x03\x7c\x71\xd5\x2b"
          "\x72\xe7\x6b\x16\xb5\x89\xd7\x1b\x97\x66\x27\xc9\x73\x4c\x9d",
          "\x8d\xfc\xe1\x64\x67\xc3\xa6\xeb\xb3\xe7\x24\x2c\x9a\x55\x19\x62", 1,
          0, 256 },
        { 120, 128, 128, 205,
          "\x34\xc7\x4e\x28\x18\x29\x48\xe0\x3a\xf0\x2a\x01\xf4\x6e\xb4\xf7",
          "\xb0\xa7\x31\x19\xa9\x7d\x62\x38\x06\xb4\x9d\x45\xdd\xf4\xc7", "",
          "\xfe\x82\xba\x66\xcf\x2e\x26\x57\x41\xf2\xc8\x6c",
          "\x2b\xc3\xef\x8e\x74\x02\xb4\x63\x1f\x48\xe9\xbe",
          "\x4b\x6f\x6f\x5b\xe2\x91\xa9\x0b\x9e\x93\xa8\xa8\x2d\xdb\xc8\xd8", 1,
          0, 96 },
        { 160, 128, 128, 206,
          "\x55\xcb\x7c\xac\x77\xef\xe1\x8a\x1e\xa3\xb3\x0c\x65\xf3\xf3\x46",
          "\xe2\x2b\x6b\x14\x4a\xb2\x6b\x57\x81\x31\x6e\x7a\x42\xa7\x62\x02\xac"
          "\x4b\x22\x78",
          "", "\x2f\x3d\x11\xea\x32\xbf\x5b\xc7\x2c\xbe\x2b\x8d",
          "\x4f\xe1\x3e\xf2\x9f\x11\x8f\x85\xa6\x31\x88\xf8",
          "\x05\x97\x5b\x17\x53\x16\xdf\x80\x45\x88\x9f\x43\xe0\xc8\x57\xe0", 1,
          0, 96 },
        { 120, 192, 128, 207,
          "\x66\xf7\x5a\xcb\xd8\xd3\xac\xf7\xaf\x47\xd1\x3e\x83\x84\xc2\x80\x9d"
          "\x6b\x91\x50\x3a\x7f\x29\x4b",
          "\xed\xf9\x3e\x16\x29\x4f\x15\xed\xed\x83\x80\x8f\x09\x32\x0e", "",
          "\xa9\x00\xc8\x6b\x6b\x7e\x0e\x55\x63\xf8\xf8\x26",
          "\x9a\xf1\xa0\x22\xc6\x1c\x43\x15\xaa\x0e\x92\x3e",
          "\x20\x52\x9b\xff\x3c\x59\x22\x2e\xc3\x33\x53\xaf\x33\x7b\x1d\x40", 1,
          0, 96 },
        { 160, 192, 128, 208,
          "\xef\x2e\x29\x9d\xd4\xec\xd7\xe3\xb9\xcc\x62\x78\x09\x22\xcc\x2c\x89"
          "\xf7\x88\x40\x56\x4d\x12\x76",
          "\x13\x0c\x14\xc8\x39\xe3\x5b\x7d\x56\xb3\x35\x0b\x19\x4b\x0d\xa3\x42"
          "\xe6\xb6\x5d",
          "", "\x03\xf5\x95\x79\xb1\x44\x37\x19\x95\x83\x27\x0e",
          "\x07\x3a\x52\x91\xb1\x1d\xf3\x79\xf3\x1b\x4f\x16",
          "\x17\x20\x59\x99\x49\x1b\xd4\xc1\xd6\xc7\xec\x3e\x56\x77\x9c\x32", 1,
          0, 96 },
        { 120, 256, 128, 209,
          "\xe9\x8b\x06\x69\xa6\x45\xeb\x14\xcd\x06\xdf\x69\x68\xfc\x5f\x10\xed"
          "\xc9\xf5\x4f\xee\xd2\x64\xe3\xd4\x10\xcd\xc6\x1b\x72\xef\x51",
          "\x17\xca\x25\x0f\xb7\x33\x87\x75\x56\x26\x32\x23\xea\xdd\xe1", "",
          "\xf3\x84\xb3\xed\x7b\x27\x46\x41\xf5\xdb\x60\xcf",
          "\xfc\x21\x36\x02\xaa\x42\x3b\x87\xd7\xc2\xa8\x74",
          "\x36\xb1\x5b\xab\x69\x23\xb1\x72\x18\xfe\x1c\x24\x04\x8e\x23\x91", 1,
          0, 96 },
        { 160, 256, 128, 210,
          "\x84\x9b\x3e\x6b\x8c\xdd\x85\xbd\xcf\xb8\xeb\x70\x1a\xa5\x52\x2a\xe2"
          "\x34\x0f\xbe\x52\x14\xe3\x89\x62\x2c\xef\x76\x97\x92\x25\xc4",
          "\x0f\x9d\x6e\xd7\xee\xf3\x62\xdf\xa4\xa7\xdf\xa5\xc0\xf7\x4c\x5b\x27"
          "\xbd\x4e\xbf",
          "", "\x8c\x55\x64\xe5\x30\x51\xc0\xde\x27\x31\x99\xb4",
          "\xc1\xd7\x62\x33\xe8\xc5\x04\x2e\x92\xbf\x8d\x32",
          "\x7c\xf0\x36\xd2\x35\xd3\xb2\xdd\x34\x9a\x8c\x80\x4b\x65\x14\x4a", 1,
          0, 96 },
        { 256, 128, 128, 211,
          "\x59\x27\xba\xe7\x48\xbb\x69\xd8\x1b\x5a\x72\x4e\x0a\x16\x56\x52",
          "\x36\x5e\x0b\x96\x93\x2b\x13\x30\x6f\x92\xe9\xbb\x23\x84\x71\x65\xbc"
          "\xbf\x5d\x35\xe4\x5a\x83\xd7\x5c\x86\xec\xca\x70\x13\x1f\x4c",
          "", "\x31\x6b\xf9\x9b\xfa\xfc\x76\xf1\xbf\xc0\xb0\x3c",
          "\x53\x48\xaf\x57\xfa\xfe\x24\x85\xb4\x3f\x2b\xc4",
          "\x01\x9a\x96\xc5\x37\x3c\x03\x16\x26\xb6\xc0\x30\x0d\x4c\xf7\x8b", 1,
          0, 96 },
        { 512, 128, 128, 212,
          "\xdb\xd3\x67\x6f\x29\x34\x09\x27\x3f\x27\xb3\x75\xe0\x37\x93\xa3",
          "\x96\x7f\xa7\xc9\x90\xeb\x2b\xec\xbd\x45\x08\x35\xe2\x8e\xa3\xa9\x00"
          "\x0c\x72\x16\x28\x5c\xfa\x76\x96\xe8\xc3\xda\xc3\xce\x95\x2a\x1f\xe6"
          "\x38\xd7\xc8\xc7\x3e\x1d\x70\x8d\xce\x01\xb5\xa2\x0f\xcc\x9a\xa0\x11"
          "\x94\x9d\x2a\x83\x5f\x77\x74\x23\xc1\x72\xfa\x3a\xa0",
          "", "\x62\x5e\xfe\xdb\x8b\x7f\x1a\xa6\x22\x38\xa8\xf2",
          "\xf5\x59\xb7\x0f\xe1\x14\x9c\xb3\x44\x06\xa2\xc7",
          "\x94\x18\x0d\xdb\x7b\xb1\x99\x5a\xbe\x02\x19\xea\xb5\xce\x23\x2f", 1,
          0, 96 },
        { 1024, 128, 128, 213,
          "\x7e\x5a\x39\xdc\xda\x7e\x06\x69\x88\xf1\x9a\xdf\x4d\xe4\xd5\x01",
          "\x49\x43\x56\xc3\x45\x9d\x60\xe3\xa8\x34\x33\xc9\xbc\xf2\xc0\x45\x4a"
          "\x76\x3e\x49\x6e\x4e\xc9\x9b\xfb\xe4\xbb\xb8\x3a\x4f\xda\x76\xb5\x42"
          "\x21\x38\x99\xdc\xf5\x52\x1c\xd9\xbb\xbe\x5d\x11\x54\x5b\xda\x44\xa3"
          "\xf4\xa6\x81\xce\x28\x43\xac\xea\x73\x0d\x83\xd3\x93\x0e\xa3\x09\x91"
          "\xee\x1a\x68\xeb\xf6\xd1\xa5\xa4\x0f\x9b\x02\xa1\xaa\xb0\x91\x29\x8d"
          "\xf8\xdd\x68\x9d\xc7\x61\x3b\xcb\xff\x94\xd3\x5f\x2c\xa4\x33\x77\xd8"
          "\x16\x18\x56\x2b\xcf\x65\x73\x41\x1e\xc9\xbc\x97\xc5\xa6\x27\x6b\x55"
          "\x40\x54\xc0\xfa\x78\x70\x73\xd0\x67",
          "", "\xb0\x47\x29\xb4\xad\xba\xac\x63\xc2\xaa\xf8\xd8",
          "\x52\x91\xdd\x4d\xa9\x1c\xcc\x2e\x77\x30\x6d\x83",
          "\xa7\xf7\xb2\x1a\x3b\x7e\xce\x50\x9e\x92\x26\x47\xfd\x90\x5f\x06", 1,
          0, 96 },
        { 2056, 128, 128, 214,
          "\xea\xc3\xf2\x8c\xd9\x37\xff\x29\xeb\x61\x58\xa3\x72\x1b\x51\x45",
          "\x6f\xd2\x60\xbb\xa8\x73\x39\x53\x9c\x37\xdc\x68\xfd\xc3\x65\x6f\x63"
          "\xc8\x30\x28\xcb\x8a\xdc\xb5\x31\x08\x5e\x98\xbd\x57\x0c\x6b\x73\x5d"
          "\x0c\xc4\xb4\xb9\x24\x69\x60\x00\xa2\xd8\x93\x62\x1a\xe6\x4d\xcc\xe9"
          "\x92\xb5\x62\xb8\x9a\x52\x85\x64\x3a\x08\xfe\xbc\xcb\xc5\x22\x43\xcb"
          "\xfc\x8d\x45\x21\x2e\x04\x7b\x00\xc8\x7c\x6b\x6b\xf1\x75\xf8\xbb\x67"
          "\x8e\xc5\x5c\x10\x91\x31\x5c\xbe\xcb\x8b\x85\x70\x0f\x4a\x46\x53\x62"
          "\x3f\xb7\x8e\x63\xcf\xff\x7d\x62\x35\xe4\x8e\x98\x32\xc9\xf0\x71\x6d"
          "\x10\x99\x2f\xc5\xb0\xad\x4e\x69\x72\xbb\xee\xb1\xad\x67\x0c\xd7\xec"
          "\x8f\xac\x82\xe0\x7e\xa5\xa6\x4f\x97\x61\xa3\x97\x14\xaa\xa7\x3a\xff"
          "\xd2\xcb\x19\x0a\x7a\xc2\xdf\x5e\x5d\xce\xa6\x81\x2a\xe2\xc8\x72\xc7"
          "\xac\x70\x45\x3c\x5e\x7e\xc4\xd0\xb5\xb1\x8c\x6f\xf3\xbf\xb9\xae\x15"
          "\xfe\xa4\x4c\xf3\x92\x61\x5b\x80\x03\x4e\xda\xe5\x96\xb8\x82\x1f\x97"
          "\xfc\xa5\x8d\x16\x7f\xb4\x4a\x09\x3b\x0c\x00\x9a\x0b\xd5\x63\x13\x55"
          "\xb0\xcb\x25\xd9\x3b\xa9\xb7\x9b\x00\x63\x01\xd9\x9d\xb6\x57\xe8\x01"
          "\x93\x3f\xc2\x76\x4a\x0c\xe6\x50\xea\xf5\xa1\x29\x9e\xfe\x60\xcb\x53"
          "\xb6\x34",
          "", "\x09\x89\x12\xa3\x02\x77\x33\x77\xb9\xc2\x6a\xc3",
          "\xe3\xbe\x94\x71\x53\xa2\x6a\x3a\x54\xe3\x01\x5c",
          "\xfd\x04\x2b\xdd\xe2\x2f\x67\xc4\xfd\x29\x8d\x5d\xc0\x86\x76\x06", 1,
          0, 96 },
        { 256, 192, 128, 215,
          "\x8f\x9e\xbc\x67\xa9\xa6\x43\x0c\x2b\x0c\xee\xaf\x98\x3e\x13\x56\x96"
          "\x4b\xb9\x28\x63\x5b\x9c\xa4",
          "\x36\xe4\xb3\x81\x57\x4d\x17\x1c\x77\x69\xa7\x88\xcb\xc1\x47\x22\x4f"
          "\xab\xd8\xb7\x73\xf1\x6b\x8a\xe8\x4d\x8f\x26\x03\xaa\xa4\x40",
          "", "\xa3\xa9\x6e\xe9\x4f\x94\xca\xa8\x1e\xbc\xd6\x6d",
          "\x8c\x2a\x98\x23\xa3\xb3\xd4\x13\xbe\x69\x63\x87",
          "\xfa\xaf\x01\xce\xb4\x0a\x7e\x14\x5e\x8f\xe6\x5a\xa9\xaf\x58\xc0", 1,
          0, 96 },
        { 512, 192, 128, 216,
          "\xf4\xbb\xdf\xd0\x6f\x7f\xb1\x43\x48\x80\xe4\x16\x6d\x38\xd5\x6e\x02"
          "\xa3\xf0\xdf\x0d\x53\x01\xce",
          "\x90\x74\x3b\xd5\xd7\x94\xd5\x2a\xc8\x48\xb7\xe2\x38\x45\x45\xa2\x58"
          "\x46\xac\xf1\x43\xbe\x84\xc0\xea\xd0\x43\x2f\xcf\x31\x72\x63\x1c\xf5"
          "\x8d\x0c\xa7\x85\x71\xc0\x30\x53\xc1\xe1\xb8\x5e\xd7\x9c\xb5\x30\x3d"
          "\x0e\x3a\x98\xff\x4f\x56\xc4\xf0\xa5\xeb\x4f\x0e\xac",
          "", "\x39\xd2\xab\xe6\x69\x7f\x17\xec\x27\xf2\xa3\x9c",
          "\xa6\x60\xea\x5b\xf0\x7a\x78\xfe\xa0\x12\x01\x73",
          "\x74\x04\xfc\x7b\x73\x54\x69\x44\x28\x23\x6f\x20\x3c\x13\x02\x44", 1,
          0, 96 },
        { 1024, 192, 128, 217,
          "\x17\x61\xc7\x77\x98\xef\x9c\xdf\xa4\x05\x53\xf3\x46\x14\xfe\x74\x02"
          "\x21\x20\x87\xf0\x50\x94\x11",
          "\xfb\xb3\xea\xb3\x79\xc9\xb8\x68\x9d\xc3\x0b\x07\x13\x69\x0e\x55\xd5"
          "\x1c\x95\x6c\xa3\x6f\xbc\xc7\x3e\xee\xee\x16\xa4\x6d\x7c\x41\xa7\xa9"
          "\x62\x6e\x68\xe2\x5d\x68\x5c\x00\x8c\x19\xd3\xb2\xb1\x79\x2b\xdc\x99"
          "\xc3\x54\x41\xa6\xfc\xac\x35\xe0\xd6\x44\x6d\xd9\x14\xf5\x43\xab\xd9"
          "\xec\xd6\xb0\xcb\x52\x01\xc2\x43\x02\x6c\x4f\x13\x64\x1d\x67\xc8\xd8"
          "\xcd\x51\x14\xb6\xe1\x1e\xbb\xc6\xb1\xde\xe2\xa1\x8d\xb2\x15\x0a\x5a"
          "\x57\x5d\xcd\x21\x64\x8e\x03\x37\xda\xdb\xcc\xd3\xde\xff\xd6\xd9\x79"
          "\xe0\x3e\x6b\x9d\xdf\xee\x0a\xbd\xc2",
          "", "\x35\xca\x4e\xb4\x63\xa2\x00\x01\x38\x21\x0b\x4d",
          "\xf4\x00\x13\x2f\xf3\x8c\x04\xed\x74\x7d\xde\x34",
          "\xca\x15\x34\xe7\xdd\x03\x36\xbb\xb3\x2a\x79\x83\x0c\x71\xa4\x47", 1,
          0, 96 },
        { 2056, 192, 128, 218,
          "\xf7\x95\xec\xe7\xde\x18\x81\xfb\xc6\x84\x3e\xb7\x40\xf8\x12\xe4\x1e"
          "\x3f\xc4\x9f\xf6\xc7\xb9\x40",
          "\x35\x69\xfc\xa7\xc9\xd0\x6e\x2a\x03\xfe\xd1\xaa\xc2\x48\x4f\xd4\x41"
          "\x6c\xa0\x7d\x55\xec\xbb\x33\x3e\xc6\x74\xf0\xea\x5c\x6e\x75\xa1\x0d"
          "\xfb\x9c\x73\x8b\x69\xda\xb2\xed\xa1\x0a\xda\x72\x1a\x61\xc7\xf0\x2b"
          "\x7e\x7f\x79\xe8\xa9\xe2\xdc\x36\xb3\xfd\xf6\x09\xe4\x36\x05\x4c\x82"
          "\xa7\x74\xec\x61\x7d\xce\xec\x84\xa5\x77\x03\x7f\xf1\xa3\xf1\x20\xd9"
          "\x81\x8d\x04\x20\x63\xac\xb3\x6c\x95\x84\xe8\x1e\xc9\x4f\x11\xf1\xee"
          "\x24\x0f\x2e\x45\xe9\x44\x69\x4a\x9c\x8e\x53\x5a\xcb\xb0\x1d\x93\x95"
          "\x84\x11\xcf\xf6\x8e\x3d\x32\xf8\x93\x17\x46\xa4\xa0\xce\xce\x65\xe9"
          "\x3c\x51\xc7\x0b\x31\x11\x03\x4b\x68\x67\xb4\x07\xe0\x14\x7f\x97\xc5"
          "\x76\xd3\xed\x8c\xec\x7e\x8e\xc2\x6e\x95\x64\x3e\x46\xe9\x7e\xa3\x59"
          "\x5c\x9c\x31\x72\xb4\x85\x6f\x2d\x2b\x6d\xc8\x56\x46\x66\xdd\xac\x92"
          "\xc7\x94\xff\xb2\xd4\xdc\x7f\x46\x17\x61\xf0\xe3\x26\x65\x0f\x48\xd3"
          "\x27\x60\x4e\x09\x5b\xd8\x75\x40\x72\x11\x6c\x96\x36\x0d\x09\xf0\x10"
          "\xac\x2f\x39\xeb\x96\xb2\x27\xf3\xd7\x38\xde\xb7\x56\xc8\x69\x94\x60"
          "\xd8\x8c\xf7\x16\x17\x0a\xe1\x52\x67\xb1\x4f\x4a\x89\x16\x47\x20\xf1"
          "\xc6\x02",
          "", "\x22\xdb\xd8\x03\x7a\xa0\x5b\x14\xcf\x81\xdd\x23",
          "\x13\xa9\x5a\x06\xc1\xbe\xd4\x84\x5a\xf9\xc7\x01",
          "\x03\x37\x98\x36\xb0\xc8\x2f\x64\xa1\xbc\xcd\xcd\x76\x3a\xcb\xbc", 1,
          0, 96 },
        { 256, 256, 128, 219,
          "\xee\x41\x71\x91\x7d\x23\x37\x49\x68\x12\xa2\x78\x4d\x6a\x71\x30\x0e"
          "\x6b\x8c\x1a\xc3\xb1\xef\x58\xce\xe7\x7c\x22\x9a\xea\xf2\xc5",
          "\xe8\x26\xa7\x93\x61\xf9\xd5\x82\xb6\x44\x50\xe3\xed\xc8\x25\x89\x48"
          "\x78\x53\xd5\xb2\x2f\xea\xa0\xc8\x89\x87\x5b\xd0\xd8\x7c\xd4",
          "", "\x94\xd2\xf8\x69\x7f\xac\xaa\xa1\x91\xba\x61\x7a",
          "\xa2\x95\xc2\xcb\x27\xce\x23\xd2\x68\x74\xad\xe1",
          "\x04\x65\x0a\x78\xbb\xb6\x1d\xb3\x37\xc9\xc3\x2a\xa3\xe7\xb6\xfa", 1,
          0, 96 },
        { 512, 256, 128, 220,
          "\x13\x2c\x59\xb4\xbc\xb8\xaf\xb3\x16\x37\x73\x4a\x81\x10\x5b\xb2\xc9"
          "\x87\x8f\x32\x0a\xce\x90\x76\xd5\xfd\x7c\x5d\x21\x6c\x8d\x12",
          "\xec\x51\xee\x18\xcf\xb4\x68\x97\xd3\x66\x6c\x7d\xf3\x5c\x29\xca\x5d"
          "\x89\x82\x41\xc4\xa3\x4f\x89\x3e\xb1\xdb\x5d\x5c\x6b\x76\xe2\x46\x17"
          "\x45\x9d\x11\x53\x86\x81\x54\x43\x7a\x0e\x95\xaa\x3c\x26\xe9\x56\xb4"
          "\x94\xa5\x2d\xd5\xac\x3b\x93\x31\x11\x6c\x7c\x77\x5f",
          "", "\x12\xc7\xbe\x00\xfa\xcd\xa4\x95\x96\xe1\x91\x34",
          "\x9c\xdc\xfc\x3a\xaa\x8d\x46\x6f\x25\x58\x8e\x4b",
          "\x7e\x80\xf5\x1e\x71\x80\xf1\xcd\x3b\xa8\x43\x49\x88\x8f\xcd\x5c", 1,
          0, 96 },
        { 1024, 256, 128, 221,
          "\x7b\x0b\x12\x49\x19\x01\xd6\x2d\x09\x7f\xa2\x6d\xc7\x1e\x15\xcf\xac"
          "\xaf\xa3\x22\x67\x19\xe4\x71\x26\xd9\x9c\x79\xd9\x8e\xc2\x22",
          "\x7d\x08\xb2\x26\xb4\xa5\xd0\x3f\x6f\x8c\xb3\xa3\xcb\x8d\x1c\xe3\x1b"
          "\x05\x9d\xc5\x11\x23\x85\x27\x5e\x38\xa1\x5c\x97\xe0\xf2\x40\x22\xb2"
          "\x49\xa5\xf7\x01\x9e\xa5\x77\x19\x8c\xb2\x6a\xc6\x4e\x82\xb2\xb0\x46"
          "\x81\x53\x7c\x41\x98\x77\x5a\x52\x3b\x0e\x64\x94\xb8\x4f\xeb\xae\xf3"
          "\x39\x9b\x35\xc2\x7b\x09\x69\xfa\x43\x57\x2b\xf5\x82\x7a\x76\x3a\xac"
          "\x1a\xf6\x95\x26\xf3\x7e\x38\xac\xb5\xd3\x54\xf2\xb6\x84\x87\xf2\x75"
          "\xf4\x36\x1e\xd3\x90\x73\xf7\xdd\x66\x53\xac\x17\xc0\x79\x41\x18\xa0"
          "\xcf\x14\x32\x93\xac\x0b\xe6\x62\x29",
          "", "\xc8\x03\x12\x59\x07\x00\xc3\xbb\xfa\xcd\x1a\x40",
          "\x3f\x3c\x15\x1e\x98\x4d\x05\x94\x62\xf9\xe5\xa0",
          "\xe5\x59\xf5\xf7\x55\xaa\x29\x21\x71\xcc\x35\xfb\xf9\x11\xa6\x4f", 1,
          0, 96 },
        { 2056, 256, 128, 222,
          "\x3b\xc3\xbf\x39\xd0\xd5\xff\xd9\x4c\xca\x2b\x45\xc6\x78\xa2\xd0\x49"
          "\x15\x1e\xd2\xba\xbc\x71\x3b\xe5\x3c\xb6\x6f\x54\xa1\x63\x37",
          "\x92\xc2\xce\xe7\xe9\x13\x8b\x18\x6d\xa5\x1f\x14\x6f\xb2\x1f\xd5\xb4"
          "\x91\xf1\xa1\x9e\xef\x61\xd4\xed\x14\xce\x6b\x21\xb0\x4f\xdb\x6f\xf8"
          "\xeb\xb6\x0f\xdd\xc5\x59\x26\xe7\xbd\xa2\xa8\xf3\x5c\x61\x0b\xb7\x95"
          "\x23\x24\x12\x73\x9d\x6c\x2d\x74\x45\x8e\xf5\xa1\xa1\xcd\xe9\xbf\x17"
          "\xe4\x7e\x3b\x00\xdb\x0b\x05\x04\xd5\x6d\xc8\xb8\xd3\xde\x23\xf7\xc3"
          "\xa5\xd5\x2e\x8d\x0a\xab\x1e\x64\x40\x5a\xaa\x85\x2e\xc2\xdd\x66\x7e"
          "\xd9\xc1\xfd\x8d\xc1\xfd\xbb\xc8\x71\x2c\x7a\x38\xf3\x0f\xae\xab\x59"
          "\x4f\x33\x89\x7b\x41\xb1\x72\x0f\x3c\x2f\x95\x4e\xd9\x1c\xa4\x50\xd8"
          "\x2c\x3d\xcd\x35\x85\x8c\x60\x8a\xd4\x2f\x36\x83\x2e\x56\xb0\x48\x21"
          "\xa1\x32\xf7\x2e\x0d\xa7\xb6\x2c\xbd\x39\x25\x25\x0f\x64\xfb\xb3\xf5"
          "\xc4\x78\x34\x95\x89\x30\x97\xad\xc0\x9a\x32\xd7\x76\xe0\x4b\xf7\x25"
          "\x58\xd3\x78\x30\xb3\x72\x34\x1f\x65\x36\xd8\xee\x9d\xf4\xa8\x2e\x40"
          "\x74\xe7\x77\x4a\xb6\x91\x7a\x04\xfa\x8c\x49\x9e\xb4\xb4\x6a\x92\xde"
          "\xf3\x65\xda\x8b\x5e\xb1\xe0\xb4\x38\x77\x95\x07\xd1\xf5\x27\x2a\x6e"
          "\x86\x29\xa3\xf9\xc7\xbd\x48\x62\xc5\x69\x1e\xe8\xb5\x6b\xfe\x29\x2d"
          "\xeb\x4e",
          "", "\x81\x25\xee\x76\x37\xd7\xd0\xe0\x3b\xba\xcf\x35",
          "\x54\x96\xae\x94\xc3\x32\x2e\xbf\x95\x9e\xa9\xa9",
          "\x70\x71\x7c\xc0\x0f\xd1\xff\xa5\x9b\xb0\x43\x29\x22\x6a\x0c\x0a", 1,
          0, 96 },
        { 0, 128, 128, 223,
          "\x8f\x3f\x52\xe3\xc7\x5c\x58\xf5\xcb\x26\x1f\x51\x8f\x4a\xd3\x0a",
          "", "", "", "",
          "\xcf\x71\x97\x8f\xfc\xc7\x78\xf3\xc8\x5a\xc9\xc3\x1b\x6f\xe1\x91", 0,
          0, 0 },
        { 0, 128, 128, 224,
          "\x2a\x4b\xf9\x0e\x56\xb7\x0f\xdd\x86\x49\xd7\x75\xc0\x89\xde\x3b",
          "", "",
          "\x32\x4c\xed\x6c\xd1\x5e\xcc\x5b\x37\x41\x54\x1e\x22\xc1\x8a\xd9",
          "\x00\xa2\x9f\x0a\x5e\x2e\x74\x90\x27\x9d\x1f\xaf\x8b\x88\x1c\x7b",
          "\xa2\xc7\xe8\xd7\xa1\x9b\x88\x4f\x74\x2d\xfe\xc3\xe7\x6c\x75\xee", 0,
          0, 128 },
        { 0, 192, 128, 225,
          "\x0b\x18\xd2\x13\x37\x03\x5c\x7b\xaa\x08\x21\x1b\x70\x2f\xa7\x80\xac"
          "\x7c\x09\xbe\x8f\x9e\xd1\x1f",
          "", "", "", "",
          "\xca\x69\xa2\xeb\x3a\x09\x6e\xa3\x6b\x10\x15\xd5\xdf\xff\xf5\x32", 0,
          0, 0 },
        { 0, 192, 128, 226,
          "\xba\x76\xd5\x94\xa6\xdf\x91\x5b\xb7\xab\x7e\x6d\x1a\x8d\x02\x4b\x27"
          "\x96\x33\x6c\x1b\x83\x28\xa9",
          "", "",
          "\xd6\x2f\x30\x27\x42\xd6\x1d\x82\x3e\xa9\x91\xb9\x34\x30\xd5\x89",
          "\x50\x9b\x06\x58\xd0\x9f\x7a\x5b\xb9\xdb\x43\xb7\x0c\x83\x87\xf7",
          "\x2c\x94\x88\xd5\x3a\x0b\x2b\x53\x08\xc2\x75\x7d\xfa\xc7\x21\x9f", 0,
          0, 128 },
        { 0, 256, 128, 227,
          "\x3f\x8c\xa4\x7b\x9a\x94\x05\x82\x64\x4e\x8e\xcf\x9c\x2d\x44\xe8\x13"
          "\x83\x77\xa8\x37\x9c\x5c\x11\xaa\xfe\x7f\xec\x19\x85\x6c\xf1",
          "", "", "", "",
          "\x17\x26\xaa\x69\x5f\xba\xa2\x1a\x1d\xb8\x84\x55\xc6\x70\xa4\xb0", 0,
          0, 0 },
        { 0, 256, 128, 228,
          "\x76\x60\xd1\x09\x66\xc6\x50\x39\x03\xa5\x52\xdd\xe2\xa8\x09\xed\xe9"
          "\xda\x49\x0e\x5e\x5c\xc3\xe3\x49\xda\x99\x96\x71\x80\x98\x83",
          "", "",
          "\xc3\x14\x23\x53\x41\xde\xbf\xaf\xa1\x52\x6b\xb6\x10\x44\xa7\xf1",
          "\x77\x72\xea\x35\x89\x01\xf5\x71\xd3\xd3\x5c\x19\x49\x76\x39\xd9",
          "\x8f\xe0\x52\x0a\xd7\x44\xa1\x1f\x0c\xcf\xd2\x28\x45\x43\x63\xfa", 0,
          0, 128 },
        { 8, 128, 128, 229,
          "\x59\xa2\x84\xf5\x0a\xed\xd8\xd3\xe2\xa9\x16\x37\xd3\x81\x55\x79",
          "\x80", "", "", "",
          "\xaf\x49\x8f\x70\x1d\x24\x70\x69\x5f\x6e\x7c\x83\x27\xa2\x39\x8b", 1,
          0, 0 },
        { 8, 128, 128, 230,
          "\xfe\xc5\x8a\xa8\xcf\x06\xbf\xe0\x5d\xe8\x29\xf2\x7e\xc7\x76\x93",
          "\x9d", "",
          "\xf2\xd9\x9a\x9f\x89\x33\x78\xe0\x75\x7d\x27\xc2\xe3\xa3\x10\x1b",
          "\x0a\x24\x61\x2a\x9d\x1c\xbe\x96\x7d\xbf\xe8\x04\xbf\x84\x40\xe5",
          "\x96\xe6\xfd\x2c\xdc\x70\x7e\x3e\xe0\xa1\xc9\x0d\x34\xc9\xc3\x6c", 1,
          0, 128 },
        { 16, 128, 128, 231,
          "\x88\xa9\x72\xcc\xe9\xea\xf5\xa7\x81\x3c\xe8\x14\x9d\x0c\x1d\x0e",
          "\x0f\x2f", "", "", "",
          "\x4c\xcf\x1e\xfb\x4d\xa0\x5b\x4a\xe4\x45\x2a\xea\x42\xf5\x42\x4b", 1,
          0, 0 },
        { 16, 128, 128, 232,
          "\xb4\x39\x67\xee\x93\x3e\x46\x32\xbd\x65\x62\xba\x12\x01\xbf\x83",
          "\x87\x60", "",
          "\x5a\x6a\xd6\xdb\x70\x59\x1d\x1e\x52\x0b\x01\x22\xf0\x50\x21\xa0",
          "\xba\x3e\x7f\x8b\x29\x99\x99\x5c\x7f\xc4\x00\x6c\xa4\xf4\x75\xff",
          "\x98\xf4\x7a\x52\x79\xce\xbb\xca\xc2\x14\x51\x57\x10\xf6\xcd\x8a", 1,
          0, 128 },
        { 32, 128, 128, 233,
          "\x4e\x9a\x97\xd3\xed\x54\xc7\xb5\x46\x10\x79\x3a\xb0\x50\x52\xe1",
          "\xcc\x85\x19\x57", "", "", "",
          "\xe5\x74\xb3\x55\xbd\xa2\x98\x0e\x04\x7e\x58\x4f\xeb\x16\x76\xca", 1,
          0, 0 },
        { 32, 128, 128, 234,
          "\xd8\x3c\x1d\x7a\x97\xc4\x3f\x18\x24\x09\xa4\xaa\x56\x09\xc1\xb1",
          "\x7b\x5f\xae\xb2", "",
          "\xc8\xf0\x7b\xa1\xd6\x55\x54\xa9\xbd\x40\x39\x0c\x30\xc5\x52\x9c",
          "\x1b\x84\xba\xea\x9d\xf1\xe6\x5b\xee\x7b\x49\xe4\xa8\xcd\xa1\xec",
          "\x5c\x0b\xb7\x9d\x82\x40\x04\x1e\xdc\xe0\xf9\x4b\xd4\xbb\x38\x4f", 1,
          0, 128 },
        { 48, 128, 128, 235,
          "\xc6\xa7\x05\x67\x7a\xff\xb4\x9e\x27\x6d\x95\x11\xca\xa4\x61\x45",
          "\x4a\xd8\x0c\x28\x54\xfb", "", "", "",
          "\x1e\x2e\xd7\x2a\xf5\x90\xca\xfb\x86\x47\xd1\x85\x86\x5f\x54\x63", 1,
          0, 0 },
        { 48, 128, 128, 236,
          "\xeb\xa7\x69\x9b\x56\xcc\x0a\xa2\xf6\x6a\x2a\x5b\xe9\x94\x44\x13",
          "\xd1\xda\xfc\x8d\xe3\xe3", "",
          "\xd0\x21\xe5\x3d\x90\x98\xa2\xdf\x3d\x6b\x90\x3c\xda\xd0\xcd\x9c",
          "\x18\x29\x1a\xa8\xdc\x7b\x07\x44\x8a\xa8\xf7\x1b\xb8\xe3\x80\xbf",
          "\x9c\x0e\x22\xe5\xc4\x1b\x10\x39\xff\x56\x61\xff\xae\xfa\x8e\x0f", 1,
          0, 128 },
        { 8, 192, 128, 237,
          "\xc7\x0c\xe3\x8e\x84\xe5\xf5\x3e\xd4\x1c\x3f\x0d\x2c\xa4\x93\x41\x2a"
          "\xd3\x2c\xb0\x4c\x6e\x2e\xfa",
          "\xcb", "", "", "",
          "\x08\xd9\x6e\xdb\x5e\x22\x87\x4c\xd1\x0c\xb2\x25\x6c\xa0\x4b\xc6", 1,
          0, 0 },
        { 8, 192, 128, 238,
          "\x74\xc8\x16\xb8\x3d\xfd\x28\x72\x10\xa3\xe2\xc6\xda\x8d\x30\x53\xbb"
          "\xfb\xd9\xb1\x56\xd3\xfd\xd8",
          "\x0f", "",
          "\xf2\xb7\xb2\xc9\xb3\x12\xcf\x2a\xf7\x8f\x00\x3d\xf1\x5c\x8e\x19",
          "\x6c\x5e\x79\x6b\xa9\xa3\xdd\xc6\x4f\x40\x1e\x68\xd1\x35\x10\x1d",
          "\x96\xa1\x32\xed\x43\x92\x4e\x98\xfe\xb8\x88\xff\x68\x2b\xda\xef", 1,
          0, 128 },
        { 16, 192, 128, 239,
          "\xcb\xf4\x5b\xa4\x88\x93\x2a\xea\x1a\x10\xe5\x86\x2f\x92\xe4\xa7\xe2"
          "\x77\xbd\xa9\xf3\x4a\xf6\xd0",
          "\x75\xe5", "", "", "",
          "\x1f\x0d\x23\x07\x0f\xcd\x74\x8e\x25\xbf\x64\x54\xf5\xc9\x13\x6e", 1,
          0, 0 },
        { 16, 192, 128, 240,
          "\xe1\xc0\x44\x6f\x11\xae\x6a\xa4\xfa\x25\x4f\x9a\x84\x6f\xc6\xe1\x3e"
          "\x45\xe5\x37\xe4\x7f\x20\x42",
          "\x89\x89", "",
          "\x3a\x2f\x5a\xd0\xeb\x21\x6e\x54\x6e\x0b\xca\xa3\x77\xb6\xcb\xc7",
          "\x55\x0b\x48\xa4\x3e\x82\x1f\xd7\x6f\x49\xf0\xf1\xa8\x97\xae\xad",
          "\xf6\xe0\xa9\x79\x48\x1f\x99\x57\xdd\xad\x0f\x21\xa7\x77\xa7\x3a", 1,
          0, 128 },
        { 32, 192, 128, 241,
          "\x56\x75\x63\xbf\x4c\xf1\x54\x90\x22\x75\xa5\x3b\xc5\x7c\xd6\xdd\x7b"
          "\x37\x0d\x27\x01\x1b\xda\xc8",
          "\x68\xd7\xfc\x38", "", "", "",
          "\x14\x75\x56\x3e\x32\x12\xf3\xb5\xe4\x00\x62\x56\x9a\xfd\x71\xe3", 1,
          0, 0 },
        { 32, 192, 128, 242,
          "\x83\x4d\x0b\xb6\x01\x17\x08\x65\xa7\x81\x39\x42\x8a\x15\x03\x69\x5a"
          "\x6a\x29\x1e\xbd\x74\x7c\xd1",
          "\xbb\x9d\x2a\xa3", "",
          "\x6f\x79\xe1\x8b\x4a\xcd\x5a\x03\xd3\xa5\xf7\xe1\xa8\xd0\xf1\x83",
          "\x30\x91\x33\xe7\x61\x59\xfe\x8a\x41\xb2\x08\x43\x48\x65\x11\xab",
          "\x03\xab\x26\x99\x3b\x70\x19\x10\xa2\xe8\xec\xcc\xd2\xba\x9e\x52", 1,
          0, 128 },
        { 48, 192, 128, 243,
          "\x99\xfb\x18\xf5\xba\x43\x0b\xb9\xea\x94\x29\x68\xec\xb7\x99\xb4\x34"
          "\x06\xe1\xaf\x4b\x64\x25\xa1",
          "\xa9\x84\xbd\xcd\xca\xe2", "", "", "",
          "\xd7\xb9\xa6\xb5\x8a\x97\x98\x29\x16\xe8\x32\x19\xfb\xf7\x1b\x1e", 1,
          0, 0 },
        { 48, 192, 128, 244,
          "\xb7\x7b\x24\x2a\xa0\xd5\x1c\x92\xfd\xa0\x13\xe0\xcb\x0e\xf2\x43\x73"
          "\x99\xac\xe5\xd3\xf5\x07\xe4",
          "\x52\xaa\x01\xe0\xd0\xd6", "",
          "\x4b\xa5\x41\xa9\x91\x47\x29\x21\x61\x53\x80\x13\x40\xab\x17\x79",
          "\xe0\x82\x61\xe4\x6e\xaf\x90\xd9\x78\xea\x8f\x78\x89\xbc\xcd\x4f",
          "\xc0\x52\xa5\x5d\xf3\x92\x6a\x50\x99\x0a\x53\x2e\xfe\x3d\x80\xec", 1,
          0, 128 },
        { 64, 192, 128, 245,
          "\xd7\x45\x99\xb3\xd2\xdb\x81\x65\x3d\xe4\x3b\x52\xfc\x99\x4c\x50\xd0"
          "\xbe\x75\x9f\xab\x87\xc3\x3a",
          "\xd1\xc6\x1c\xf8\x53\x25\x31\xb5", "", "", "",
          "\xf9\x4f\x20\x49\xa6\x56\x0c\x47\x0b\x3a\x7c\xa7\xbb\xc3\x1a\x3d", 1,
          0, 0 },
        { 64, 192, 128, 246,
          "\x0b\x17\x71\x98\xc8\xb4\x19\xbf\x74\xac\xc3\xbc\x65\xb5\xfb\x3d\x09"
          "\xa9\x15\xff\x71\xad\xd7\x54",
          "\x8f\x07\x5c\xbc\xda\x98\x31\xc3", "",
          "\xc4\xb1\xe0\x5c\xa3\xd5\x91\xf9\x54\x3e\x64\xde\x3f\xc6\x82\xac",
          "\x3c\x6e\xc0\xab\x1b\x82\x7b\xf2\x38\xa5\x38\x4f\xb7\xe2\x12\xce",
          "\x7d\xb7\x40\x22\x24\xfd\x58\x3e\x31\x2b\xc0\xe6\x1c\xf1\x13\x66", 1,
          0, 128 },
        { 8, 256, 128, 247,
          "\x8f\x9a\x38\xc1\x01\x49\x66\xe4\xd9\xae\x73\x61\x39\xc5\xe7\x9b\x99"
          "\x34\x58\x74\xf4\x2d\x4c\x7d\x2c\x81\xaa\x67\x97\xc4\x17\xc0",
          "\xa9", "", "", "",
          "\x2a\x26\x8b\xf3\xa7\x5f\xd7\xb0\x0b\xa2\x30\xb9\x04\xbb\xb0\x14", 1,
          0, 0 },
        { 8, 256, 128, 248,
          "\x14\x4c\xd8\x27\x92\x29\xe8\xbb\x2d\xe9\x9d\x24\xe6\x15\x30\x66\x63"
          "\x91\x3f\xe9\x17\x7f\xcd\x27\x0f\xaf\xec\x49\x3d\x43\xbc\xa1",
          "\xb3", "",
          "\x97\x62\x29\xf5\x53\x8f\x96\x36\x47\x6d\x69\xf0\xc3\x28\xe2\x9d",
          "\x7b\xea\x30\xec\xc2\xf7\x3f\x8e\x12\x12\x63\xb3\x79\x66\x95\x4c",
          "\x8b\xba\xd4\xad\xc5\x4b\x37\xa2\xb2\xf0\xf6\xe8\x61\x75\x48\xc9", 1,
          0, 128 },
        { 16, 256, 128, 249,
          "\x7d\x31\x86\x1f\x9d\x35\x36\xe1\x40\x16\xa3\x21\x6b\x10\x42\xe0\xd2"
          "\xf7\xd4\x61\x43\x14\x26\x8b\x6f\x83\x4e\xc7\xf3\x8b\xbb\x65",
          "\xc3\x32", "", "", "",
          "\x1d\x97\x8a\x69\x31\x20\xc1\x1f\x6d\x51\xa3\xed\x88\xcd\x4a\xce", 1,
          0, 0 },
        { 16, 256, 128, 250,
          "\x22\xb3\x5f\xe9\x62\x3e\xe1\x1f\x8b\x60\xb6\xd2\x2d\xb3\x76\x5b\x66"
          "\x6e\xd9\x72\xfa\x7c\xcd\x92\xb4\x5f\x22\xde\xee\x02\xca\xb1",
          "\xda\x6c", "",
          "\x53\x41\xc7\x8e\x4c\xe5\xbf\x8f\xbc\x3e\x07\x7d\x19\x90\xdd\x5d",
          "\x9c\x39\xf5\xb1\x10\x36\x1e\x9a\x77\x0c\xc5\xe8\xb0\xf4\x44\xbb",
          "\xb6\x3f\xf4\x3c\x12\x07\x3e\xc5\x57\x2b\x1b\xe7\x0f\x17\xe2\x31", 1,
          0, 128 },
        { 32, 256, 128, 251,
          "\xc2\x24\xe0\xbb\xa3\xd7\xa9\x91\x65\xf7\x99\x6b\x67\xa0\xfc\xe3\xe1"
          "\x2f\x2c\x01\x17\x9b\x19\x7b\x69\xb7\xe6\x28\xbc\xa9\x20\x96",
          "\x6b\x30\x14\x5e", "", "", "",
          "\xae\x6f\x7c\x9a\x29\xf0\xd8\x20\x4c\xa5\x0b\x14\xa1\xe0\xdc\xf2", 1,
          0, 0 },
        { 32, 256, 128, 252,
          "\x09\x3e\xb1\x23\x43\x53\x7e\xe8\xe9\x1c\x1f\x71\x5b\x86\x26\x03\xf8"
          "\xda\xf9\xd4\xe1\xd7\xd6\x72\x12\xa9\xd6\x8e\x5a\xac\x93\x58",
          "\x51\x10\x60\x4c", "",
          "\x33\xef\xb5\x8c\x91\xe8\xc7\x02\x71\x87\x0e\xc0\x0f\xe2\xe2\x02",
          "\xf7\x3f\x72\xf9\x76\xa2\x96\xba\x3c\xa9\x4b\xc6\xeb\x08\xcd\x46",
          "\xb8\x24\xc3\x3c\x13\xf2\x89\x42\x96\x59\xaa\x01\x7c\x63\x2f\x71", 1,
          0, 128 },
        { 48, 256, 128, 253,
          "\x98\xe6\xf8\xab\x67\x3e\x80\x4e\x86\x5e\x32\x40\x3a\x65\x51\xbf\x80"
          "\x7a\x95\x93\x43\xc6\x0d\x34\x55\x93\x60\xbc\x29\x5e\xcb\x5b",
          "\xd4\xd8\x57\x51\x08\x88", "", "", "",
          "\x3d\xb1\x67\x25\xfa\xfc\x82\x8d\x41\x4a\xb6\x1c\x16\xa6\xc3\x8f", 1,
          0, 0 },
        { 48, 256, 128, 254,
          "\x0b\xd0\xe8\xe7\x78\x11\x66\xe1\xd8\x76\xde\xc8\xfa\xd3\x4b\xa9\x5b"
          "\x03\x2a\x27\xca\xc0\x55\x15\x95\x11\x60\x91\x00\x59\x47\xb7",
          "\x1b\xdc\xd4\x4b\x66\x3e", "",
          "\x91\x22\x22\x63\xb1\x2c\xf5\x61\x6a\x04\x9c\xbe\x29\xab\x9b\x5b",
          "\xed\x46\x3f\x4f\x43\x33\x6a\xf3\xf4\xd7\xe0\x87\x70\x20\x11\x45",
          "\xc8\xfc\x39\x90\x6a\xca\x0c\x64\xe1\x4a\x43\xff\x75\x0a\xbd\x8a", 1,
          0, 128 },
        { 64, 256, 128, 255,
          "\x61\xba\x69\x48\x97\x92\x5d\x1b\x41\x74\xd4\x04\x01\x46\x9c\x3e\xf2"
          "\x67\xcd\xb9\xf8\x29\xed\xb1\xa1\x06\x18\xc1\x6d\x66\x60\x59",
          "\x0d\x10\xc5\xc8\x4b\x88\xd6\x88", "", "", "",
          "\x13\x11\xf9\xf8\x30\xd7\x29\xc1\x89\xb7\x4e\xc4\xf9\x08\x0f\xa1", 1,
          0, 0 },
        { 64, 256, 128, 256,
          "\x11\x58\x84\xf6\x93\xb1\x55\x56\x3e\x9b\xfb\x3b\x07\xca\xcb\x2f\x7f"
          "\x7c\xaa\x9b\xfe\x51\xf8\x9e\x23\xfe\xb5\xa9\x46\x8b\xfd\xd0",
          "\x04\x10\x21\x99\xef\x21\xe1\xdf", "",
          "\x82\xe3\xe6\x04\xd2\xbe\x8f\xca\xb7\x4f\x63\x8d\x1e\x70\xf2\x4c",
          "\x7e\x0d\xd6\xc7\x2a\xec\x49\xf8\x9c\xc6\xa8\x00\x60\xc0\xb1\x70",
          "\xaf\x68\xa3\x7c\xfe\xfe\xcc\x4a\xb9\x9b\xa5\x0a\x53\x53\xed\xca", 1,
          0, 128 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};
