/*
 * Copyright (C) 2021-2023 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

// This is a generated file - please don't modify directly
#pragma once
#include "wsl_compute_helper_types_tokens.h"

template <TOK StrT>
struct Demarshaller;

template <>
struct Demarshaller<TOK_S_GT_SUBSLICE_INFO> {
    template <typename GT_SUBSLICE_INFOT>
    static bool demarshall(GT_SUBSLICE_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                    dst.Enabled = readTokValue<decltype(dst.Enabled)>(*tok);
                } break;
                case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                    dst.EuEnabledCount = readTokValue<decltype(dst.EuEnabledCount)>(*tok);
                } break;
                case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                    dst.EuEnabledMask = readTokValue<decltype(dst.EuEnabledMask)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_SUBSLICE_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_DUALSUBSLICE_INFO> {
    template <typename GT_DUALSUBSLICE_INFOT>
    static bool demarshall(GT_DUALSUBSLICE_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBB_GT_DUALSUBSLICE_INFO__ENABLED: {
                    dst.Enabled = readTokValue<decltype(dst.Enabled)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_DUALSUBSLICE_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GT_DUALSUBSLICE_INFO__SUB_SLICE: {
                    uint32_t arrayElementIdSubSlice = varLen->arrayElementId;
                    const TokenHeader *tokSubSlice = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSubSliceEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSubSlice < tokSubSliceEnd) {
                        if (false == tokSubSlice->flags.flag4IsVariableLength) {
                            switch (tokSubSlice->id) {
                            default:
                                if (tokSubSlice->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                dst.SubSlice[arrayElementIdSubSlice].Enabled = readTokValue<decltype(dst.SubSlice[arrayElementIdSubSlice].Enabled)>(*tokSubSlice);
                            } break;
                            case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                dst.SubSlice[arrayElementIdSubSlice].EuEnabledCount = readTokValue<decltype(dst.SubSlice[arrayElementIdSubSlice].EuEnabledCount)>(*tokSubSlice);
                            } break;
                            case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                dst.SubSlice[arrayElementIdSubSlice].EuEnabledMask = readTokValue<decltype(dst.SubSlice[arrayElementIdSubSlice].EuEnabledMask)>(*tokSubSlice);
                            } break;
                            };
                            tokSubSlice = tokSubSlice + 1 + tokSubSlice->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSlice);
                            if (tokSubSlice->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokSubSlice = tokSubSlice + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSubSlice == tokSubSliceEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_SLICE_INFO> {
    template <typename GT_SLICE_INFOT>
    static bool demarshall(GT_SLICE_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBB_GT_SLICE_INFO__ENABLED: {
                    dst.Enabled = readTokValue<decltype(dst.Enabled)>(*tok);
                } break;
                case TOK_FBD_GT_SLICE_INFO__SUB_SLICE_ENABLED_COUNT: {
                    dst.SubSliceEnabledCount = readTokValue<decltype(dst.SubSliceEnabledCount)>(*tok);
                } break;
                case TOK_FBD_GT_SLICE_INFO__DUAL_SUB_SLICE_ENABLED_COUNT: {
                    dst.DualSubSliceEnabledCount = readTokValue<decltype(dst.DualSubSliceEnabledCount)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_SLICE_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GT_SLICE_INFO__SUB_SLICE_INFO: {
                    uint32_t arrayElementIdSubSliceInfo = varLen->arrayElementId;
                    const TokenHeader *tokSubSliceInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSubSliceInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSubSliceInfo < tokSubSliceInfoEnd) {
                        if (false == tokSubSliceInfo->flags.flag4IsVariableLength) {
                            switch (tokSubSliceInfo->id) {
                            default:
                                if (tokSubSliceInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                dst.SubSliceInfo[arrayElementIdSubSliceInfo].Enabled = readTokValue<decltype(dst.SubSliceInfo[arrayElementIdSubSliceInfo].Enabled)>(*tokSubSliceInfo);
                            } break;
                            case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                dst.SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledCount = readTokValue<decltype(dst.SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledCount)>(*tokSubSliceInfo);
                            } break;
                            case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                dst.SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledMask = readTokValue<decltype(dst.SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledMask)>(*tokSubSliceInfo);
                            } break;
                            };
                            tokSubSliceInfo = tokSubSliceInfo + 1 + tokSubSliceInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSliceInfo);
                            if (tokSubSliceInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokSubSliceInfo = tokSubSliceInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSubSliceInfo == tokSubSliceInfoEnd);
                } break;
                case TOK_FS_GT_SLICE_INFO__DSSINFO: {
                    uint32_t arrayElementIdDSSInfo = varLen->arrayElementId;
                    const TokenHeader *tokDSSInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokDSSInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokDSSInfo < tokDSSInfoEnd) {
                        if (false == tokDSSInfo->flags.flag4IsVariableLength) {
                            switch (tokDSSInfo->id) {
                            default:
                                if (tokDSSInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBB_GT_DUALSUBSLICE_INFO__ENABLED: {
                                dst.DSSInfo[arrayElementIdDSSInfo].Enabled = readTokValue<decltype(dst.DSSInfo[arrayElementIdDSSInfo].Enabled)>(*tokDSSInfo);
                            } break;
                            };
                            tokDSSInfo = tokDSSInfo + 1 + tokDSSInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokDSSInfo);
                            switch (tokDSSInfo->id) {
                            default:
                                if (tokDSSInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_DUALSUBSLICE_INFO__SUB_SLICE: {
                                uint32_t arrayElementIdSubSlice = varLen->arrayElementId;
                                const TokenHeader *tokSubSlice = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSubSliceEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSubSlice < tokSubSliceEnd) {
                                    if (false == tokSubSlice->flags.flag4IsVariableLength) {
                                        switch (tokSubSlice->id) {
                                        default:
                                            if (tokSubSlice->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                            dst.DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].Enabled = readTokValue<decltype(dst.DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].Enabled)>(*tokSubSlice);
                                        } break;
                                        case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                            dst.DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledCount = readTokValue<decltype(dst.DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledCount)>(*tokSubSlice);
                                        } break;
                                        case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                            dst.DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledMask = readTokValue<decltype(dst.DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledMask)>(*tokSubSlice);
                                        } break;
                                        };
                                        tokSubSlice = tokSubSlice + 1 + tokSubSlice->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSlice);
                                        if (tokSubSlice->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSubSlice = tokSubSlice + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSubSlice == tokSubSliceEnd);
                            } break;
                            };
                            tokDSSInfo = tokDSSInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokDSSInfo == tokDSSInfoEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_VEBOX_INFO> {
    template <typename GT_VEBOX_INFOT>
    static bool demarshall(GT_VEBOX_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GT_VEBOX_INFO__NUMBER_OF_VEBOX_ENABLED: {
                    dst.NumberOfVEBoxEnabled = readTokValue<decltype(dst.NumberOfVEBoxEnabled)>(*tok);
                } break;
                case TOK_FBB_GT_VEBOX_INFO__IS_VALID: {
                    dst.IsValid = readTokValue<decltype(dst.IsValid)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_VEBOX_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GT_VEBOX_INFO__INSTANCES: {
                    const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokInstances < tokInstancesEnd) {
                        if (false == tokInstances->flags.flag4IsVariableLength) {
                            switch (tokInstances->id) {
                            default:
                                if (tokInstances->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBOX_ENABLE_MASK: {
                                dst.Instances.VEBoxEnableMask = readTokValue<decltype(dst.Instances.VEBoxEnableMask)>(*tokInstances);
                            } break;
                            };
                            tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                            switch (tokInstances->id) {
                            default:
                                if (tokInstances->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_VEBOX_INFO__VEBOX_INSTANCES__BITS: {
                                const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokBits < tokBitsEnd) {
                                    if (false == tokBits->flags.flag4IsVariableLength) {
                                        switch (tokBits->id) {
                                        default:
                                            if (tokBits->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX0ENABLED: {
                                            dst.Instances.Bits.VEBox0Enabled = readTokValue<decltype(dst.Instances.Bits.VEBox0Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX1ENABLED: {
                                            dst.Instances.Bits.VEBox1Enabled = readTokValue<decltype(dst.Instances.Bits.VEBox1Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX2ENABLED: {
                                            dst.Instances.Bits.VEBox2Enabled = readTokValue<decltype(dst.Instances.Bits.VEBox2Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX3ENABLED: {
                                            dst.Instances.Bits.VEBox3Enabled = readTokValue<decltype(dst.Instances.Bits.VEBox3Enabled)>(*tokBits);
                                        } break;
                                        };
                                        tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                        if (tokBits->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokBits == tokBitsEnd);
                            } break;
                            };
                            tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokInstances == tokInstancesEnd);
                } break;
                case TOK_FS_GT_VEBOX_INFO__SFCSUPPORT: {
                    const TokenHeader *tokSFCSupport = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSFCSupportEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSFCSupport < tokSFCSupportEnd) {
                        if (false == tokSFCSupport->flags.flag4IsVariableLength) {
                            switch (tokSFCSupport->id) {
                            default:
                                if (tokSFCSupport->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__VALUE: {
                                dst.SFCSupport.Value = readTokValue<decltype(dst.SFCSupport.Value)>(*tokSFCSupport);
                            } break;
                            };
                            tokSFCSupport = tokSFCSupport + 1 + tokSFCSupport->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSFCSupport);
                            switch (tokSFCSupport->id) {
                            default:
                                if (tokSFCSupport->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_VEBOX_INFO__ANONYMOUS3862__SFC_SUPPORTED_BITS: {
                                const TokenHeader *tokSfcSupportedBits = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSfcSupportedBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSfcSupportedBits < tokSfcSupportedBitsEnd) {
                                    if (false == tokSfcSupportedBits->flags.flag4IsVariableLength) {
                                        switch (tokSfcSupportedBits->id) {
                                        default:
                                            if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX0: {
                                            dst.SFCSupport.SfcSupportedBits.VEBox0 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VEBox0)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX1: {
                                            dst.SFCSupport.SfcSupportedBits.VEBox1 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VEBox1)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX2: {
                                            dst.SFCSupport.SfcSupportedBits.VEBox2 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VEBox2)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX3: {
                                            dst.SFCSupport.SfcSupportedBits.VEBox3 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VEBox3)>(*tokSfcSupportedBits);
                                        } break;
                                        };
                                        tokSfcSupportedBits = tokSfcSupportedBits + 1 + tokSfcSupportedBits->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSfcSupportedBits);
                                        if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSfcSupportedBits = tokSfcSupportedBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSfcSupportedBits == tokSfcSupportedBitsEnd);
                            } break;
                            };
                            tokSFCSupport = tokSFCSupport + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSFCSupport == tokSFCSupportEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_VDBOX_INFO> {
    template <typename GT_VDBOX_INFOT>
    static bool demarshall(GT_VDBOX_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GT_VDBOX_INFO__NUMBER_OF_VDBOX_ENABLED: {
                    dst.NumberOfVDBoxEnabled = readTokValue<decltype(dst.NumberOfVDBoxEnabled)>(*tok);
                } break;
                case TOK_FBB_GT_VDBOX_INFO__IS_VALID: {
                    dst.IsValid = readTokValue<decltype(dst.IsValid)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_VDBOX_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GT_VDBOX_INFO__INSTANCES: {
                    const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokInstances < tokInstancesEnd) {
                        if (false == tokInstances->flags.flag4IsVariableLength) {
                            switch (tokInstances->id) {
                            default:
                                if (tokInstances->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBOX_ENABLE_MASK: {
                                dst.Instances.VDBoxEnableMask = readTokValue<decltype(dst.Instances.VDBoxEnableMask)>(*tokInstances);
                            } break;
                            };
                            tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                            switch (tokInstances->id) {
                            default:
                                if (tokInstances->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_VDBOX_INFO__VDBOX_INSTANCES__BITS: {
                                const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokBits < tokBitsEnd) {
                                    if (false == tokBits->flags.flag4IsVariableLength) {
                                        switch (tokBits->id) {
                                        default:
                                            if (tokBits->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX0ENABLED: {
                                            dst.Instances.Bits.VDBox0Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox0Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX1ENABLED: {
                                            dst.Instances.Bits.VDBox1Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox1Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX2ENABLED: {
                                            dst.Instances.Bits.VDBox2Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox2Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX3ENABLED: {
                                            dst.Instances.Bits.VDBox3Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox3Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX4ENABLED: {
                                            dst.Instances.Bits.VDBox4Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox4Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX5ENABLED: {
                                            dst.Instances.Bits.VDBox5Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox5Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX6ENABLED: {
                                            dst.Instances.Bits.VDBox6Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox6Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX7ENABLED: {
                                            dst.Instances.Bits.VDBox7Enabled = readTokValue<decltype(dst.Instances.Bits.VDBox7Enabled)>(*tokBits);
                                        } break;
                                        };
                                        tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                        if (tokBits->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokBits == tokBitsEnd);
                            } break;
                            };
                            tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokInstances == tokInstancesEnd);
                } break;
                case TOK_FS_GT_VDBOX_INFO__SFCSUPPORT: {
                    const TokenHeader *tokSFCSupport = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSFCSupportEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSFCSupport < tokSFCSupportEnd) {
                        if (false == tokSFCSupport->flags.flag4IsVariableLength) {
                            switch (tokSFCSupport->id) {
                            default:
                                if (tokSFCSupport->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__VALUE: {
                                dst.SFCSupport.Value = readTokValue<decltype(dst.SFCSupport.Value)>(*tokSFCSupport);
                            } break;
                            };
                            tokSFCSupport = tokSFCSupport + 1 + tokSFCSupport->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSFCSupport);
                            switch (tokSFCSupport->id) {
                            default:
                                if (tokSFCSupport->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_VDBOX_INFO__ANONYMOUS5662__SFC_SUPPORTED_BITS: {
                                const TokenHeader *tokSfcSupportedBits = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSfcSupportedBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSfcSupportedBits < tokSfcSupportedBitsEnd) {
                                    if (false == tokSfcSupportedBits->flags.flag4IsVariableLength) {
                                        switch (tokSfcSupportedBits->id) {
                                        default:
                                            if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX0: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox0 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox0)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX1: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox1 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox1)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX2: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox2 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox2)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX3: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox3 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox3)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX4: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox4 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox4)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX5: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox5 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox5)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX6: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox6 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox6)>(*tokSfcSupportedBits);
                                        } break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX7: {
                                            dst.SFCSupport.SfcSupportedBits.VDBox7 = readTokValue<decltype(dst.SFCSupport.SfcSupportedBits.VDBox7)>(*tokSfcSupportedBits);
                                        } break;
                                        };
                                        tokSfcSupportedBits = tokSfcSupportedBits + 1 + tokSfcSupportedBits->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSfcSupportedBits);
                                        if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSfcSupportedBits = tokSfcSupportedBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSfcSupportedBits == tokSfcSupportedBitsEnd);
                            } break;
                            };
                            tokSFCSupport = tokSFCSupport + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSFCSupport == tokSFCSupportEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_CCS_INFO> {
    template <typename GT_CCS_INFOT>
    static bool demarshall(GT_CCS_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GT_CCS_INFO__NUMBER_OF_CCSENABLED: {
                    dst.NumberOfCCSEnabled = readTokValue<decltype(dst.NumberOfCCSEnabled)>(*tok);
                } break;
                case TOK_FBB_GT_CCS_INFO__IS_VALID: {
                    dst.IsValid = readTokValue<decltype(dst.IsValid)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_CCS_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GT_CCS_INFO__INSTANCES: {
                    const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokInstances < tokInstancesEnd) {
                        if (false == tokInstances->flags.flag4IsVariableLength) {
                            switch (tokInstances->id) {
                            default:
                                if (tokInstances->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSENABLE_MASK: {
                                dst.Instances.CCSEnableMask = readTokValue<decltype(dst.Instances.CCSEnableMask)>(*tokInstances);
                            } break;
                            };
                            tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                            switch (tokInstances->id) {
                            default:
                                if (tokInstances->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_CCS_INFO__CCSINSTANCES__BITS: {
                                const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokBits < tokBitsEnd) {
                                    if (false == tokBits->flags.flag4IsVariableLength) {
                                        switch (tokBits->id) {
                                        default:
                                            if (tokBits->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS0ENABLED: {
                                            dst.Instances.Bits.CCS0Enabled = readTokValue<decltype(dst.Instances.Bits.CCS0Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS1ENABLED: {
                                            dst.Instances.Bits.CCS1Enabled = readTokValue<decltype(dst.Instances.Bits.CCS1Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS2ENABLED: {
                                            dst.Instances.Bits.CCS2Enabled = readTokValue<decltype(dst.Instances.Bits.CCS2Enabled)>(*tokBits);
                                        } break;
                                        case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS3ENABLED: {
                                            dst.Instances.Bits.CCS3Enabled = readTokValue<decltype(dst.Instances.Bits.CCS3Enabled)>(*tokBits);
                                        } break;
                                        };
                                        tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                        if (tokBits->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokBits == tokBitsEnd);
                            } break;
                            };
                            tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokInstances == tokInstancesEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_MULTI_TILE_ARCH_INFO> {
    template <typename GT_MULTI_TILE_ARCH_INFOT>
    static bool demarshall(GT_MULTI_TILE_ARCH_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__TILE_COUNT: {
                    dst.TileCount = readTokValue<decltype(dst.TileCount)>(*tok);
                } break;
                case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE0: {
                    dst.Tile0 = readTokValue<decltype(dst.Tile0)>(*tok);
                } break;
                case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE1: {
                    dst.Tile1 = readTokValue<decltype(dst.Tile1)>(*tok);
                } break;
                case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE2: {
                    dst.Tile2 = readTokValue<decltype(dst.Tile2)>(*tok);
                } break;
                case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE3: {
                    dst.Tile3 = readTokValue<decltype(dst.Tile3)>(*tok);
                } break;
                case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__TILE_MASK: {
                    dst.TileMask = readTokValue<decltype(dst.TileMask)>(*tok);
                } break;
                case TOK_FBB_GT_MULTI_TILE_ARCH_INFO__IS_VALID: {
                    dst.IsValid = readTokValue<decltype(dst.IsValid)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_MULTI_TILE_ARCH_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_SQIDI_INFO> {
    template <typename GT_SQIDI_INFOT>
    static bool demarshall(GT_SQIDI_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GT_SQIDI_INFO__NUMBEROF_SQIDI: {
                    dst.NumberofSQIDI = readTokValue<decltype(dst.NumberofSQIDI)>(*tok);
                } break;
                case TOK_FBD_GT_SQIDI_INFO__NUMBEROF_DOORBELL_PER_SQIDI: {
                    dst.NumberofDoorbellPerSQIDI = readTokValue<decltype(dst.NumberofDoorbellPerSQIDI)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_SQIDI_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_CACHE_TYPES> {
    template <typename _GT_CACHE_TYPEST>
    static bool demarshall(_GT_CACHE_TYPEST &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__L3: {
                    dst.L3 = readTokValue<decltype(dst.L3)>(*tok);
                } break;
                case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__LLC: {
                    dst.LLC = readTokValue<decltype(dst.LLC)>(*tok);
                } break;
                case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__E_DRAM: {
                    dst.eDRAM = readTokValue<decltype(dst.eDRAM)>(*tok);
                } break;
                case TOK_FBD_GT_CACHE_TYPES__CACHE_TYPE_MASK: {
                    dst.CacheTypeMask = readTokValue<decltype(dst.CacheTypeMask)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_CACHE_TYPES:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GT_SYSTEM_INFO> {
    template <typename GT_SYSTEM_INFOT>
    static bool demarshall(GT_SYSTEM_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GT_SYSTEM_INFO__EUCOUNT: {
                    dst.EUCount = readTokValue<decltype(dst.EUCount)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__THREAD_COUNT: {
                    dst.ThreadCount = readTokValue<decltype(dst.ThreadCount)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__SLICE_COUNT: {
                    dst.SliceCount = readTokValue<decltype(dst.SliceCount)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__SUB_SLICE_COUNT: {
                    dst.SubSliceCount = readTokValue<decltype(dst.SubSliceCount)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__DUAL_SUB_SLICE_COUNT: {
                    dst.DualSubSliceCount = readTokValue<decltype(dst.DualSubSliceCount)>(*tok);
                } break;
                case TOK_FBQ_GT_SYSTEM_INFO__L3CACHE_SIZE_IN_KB: {
                    dst.L3CacheSizeInKb = readTokValue<decltype(dst.L3CacheSizeInKb)>(*tok);
                } break;
                case TOK_FBQ_GT_SYSTEM_INFO__LLCCACHE_SIZE_IN_KB: {
                    dst.LLCCacheSizeInKb = readTokValue<decltype(dst.LLCCacheSizeInKb)>(*tok);
                } break;
                case TOK_FBQ_GT_SYSTEM_INFO__EDRAM_SIZE_IN_KB: {
                    dst.EdramSizeInKb = readTokValue<decltype(dst.EdramSizeInKb)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__L3BANK_COUNT: {
                    dst.L3BankCount = readTokValue<decltype(dst.L3BankCount)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__MAX_FILL_RATE: {
                    dst.MaxFillRate = readTokValue<decltype(dst.MaxFillRate)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__EU_COUNT_PER_POOL_MAX: {
                    dst.EuCountPerPoolMax = readTokValue<decltype(dst.EuCountPerPoolMax)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__EU_COUNT_PER_POOL_MIN: {
                    dst.EuCountPerPoolMin = readTokValue<decltype(dst.EuCountPerPoolMin)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__TOTAL_VS_THREADS: {
                    dst.TotalVsThreads = readTokValue<decltype(dst.TotalVsThreads)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__TOTAL_HS_THREADS: {
                    dst.TotalHsThreads = readTokValue<decltype(dst.TotalHsThreads)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__TOTAL_DS_THREADS: {
                    dst.TotalDsThreads = readTokValue<decltype(dst.TotalDsThreads)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__TOTAL_GS_THREADS: {
                    dst.TotalGsThreads = readTokValue<decltype(dst.TotalGsThreads)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__TOTAL_PS_THREADS_WINDOWER_RANGE: {
                    dst.TotalPsThreadsWindowerRange = readTokValue<decltype(dst.TotalPsThreadsWindowerRange)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__TOTAL_VS_THREADS_POCS: {
                    dst.TotalVsThreads_Pocs = readTokValue<decltype(dst.TotalVsThreads_Pocs)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__CSR_SIZE_IN_MB: {
                    dst.CsrSizeInMb = readTokValue<decltype(dst.CsrSizeInMb)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__MAX_EU_PER_SUB_SLICE: {
                    dst.MaxEuPerSubSlice = readTokValue<decltype(dst.MaxEuPerSubSlice)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__MAX_SLICES_SUPPORTED: {
                    dst.MaxSlicesSupported = readTokValue<decltype(dst.MaxSlicesSupported)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__MAX_SUB_SLICES_SUPPORTED: {
                    dst.MaxSubSlicesSupported = readTokValue<decltype(dst.MaxSubSlicesSupported)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__MAX_DUAL_SUB_SLICES_SUPPORTED: {
                    dst.MaxDualSubSlicesSupported = readTokValue<decltype(dst.MaxDualSubSlicesSupported)>(*tok);
                } break;
                case TOK_FBB_GT_SYSTEM_INFO__IS_L3HASH_MODE_ENABLED: {
                    dst.IsL3HashModeEnabled = readTokValue<decltype(dst.IsL3HashModeEnabled)>(*tok);
                } break;
                case TOK_FBB_GT_SYSTEM_INFO__IS_DYNAMICALLY_POPULATED: {
                    dst.IsDynamicallyPopulated = readTokValue<decltype(dst.IsDynamicallyPopulated)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__RESERVED_CCSWAYS: {
                    dst.ReservedCCSWays = readTokValue<decltype(dst.ReservedCCSWays)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__NUM_THREADS_PER_EU: {
                    dst.NumThreadsPerEu = readTokValue<decltype(dst.NumThreadsPerEu)>(*tok);
                } break;
                case TOK_FBD_GT_SYSTEM_INFO__MAX_VECS: {
                    dst.MaxVECS = readTokValue<decltype(dst.MaxVECS)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GT_SYSTEM_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GT_SYSTEM_INFO__SLICE_INFO: {
                    uint32_t arrayElementIdSliceInfo = varLen->arrayElementId;
                    const TokenHeader *tokSliceInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSliceInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    static constexpr auto maxDstSlicesInfo = sizeof(dst.SystemInfo.SliceInfo) / sizeof(dst.SystemInfo.SliceInfo[0]);
                    if (arrayElementIdSliceInfo >= maxDstSlicesInfo) {
                        tokSliceInfo = tokSliceInfoEnd;
                    }
                    while (tokSliceInfo < tokSliceInfoEnd) {
                        if (false == tokSliceInfo->flags.flag4IsVariableLength) {
                            switch (tokSliceInfo->id) {
                            default:
                                if (tokSliceInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBB_GT_SLICE_INFO__ENABLED: {
                                dst.SliceInfo[arrayElementIdSliceInfo].Enabled = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].Enabled)>(*tokSliceInfo);
                            } break;
                            case TOK_FBD_GT_SLICE_INFO__SUB_SLICE_ENABLED_COUNT: {
                                dst.SliceInfo[arrayElementIdSliceInfo].SubSliceEnabledCount = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].SubSliceEnabledCount)>(*tokSliceInfo);
                            } break;
                            case TOK_FBD_GT_SLICE_INFO__DUAL_SUB_SLICE_ENABLED_COUNT: {
                                dst.SliceInfo[arrayElementIdSliceInfo].DualSubSliceEnabledCount = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].DualSubSliceEnabledCount)>(*tokSliceInfo);
                            } break;
                            };
                            tokSliceInfo = tokSliceInfo + 1 + tokSliceInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSliceInfo);
                            switch (tokSliceInfo->id) {
                            default:
                                if (tokSliceInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_SLICE_INFO__SUB_SLICE_INFO: {
                                uint32_t arrayElementIdSubSliceInfo = varLen->arrayElementId;
                                const TokenHeader *tokSubSliceInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSubSliceInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSubSliceInfo < tokSubSliceInfoEnd) {
                                    if (false == tokSubSliceInfo->flags.flag4IsVariableLength) {
                                        switch (tokSubSliceInfo->id) {
                                        default:
                                            if (tokSubSliceInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                            dst.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].Enabled = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].Enabled)>(*tokSubSliceInfo);
                                        } break;
                                        case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                            dst.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledCount = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledCount)>(*tokSubSliceInfo);
                                        } break;
                                        case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                            dst.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledMask = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledMask)>(*tokSubSliceInfo);
                                        } break;
                                        };
                                        tokSubSliceInfo = tokSubSliceInfo + 1 + tokSubSliceInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSliceInfo);
                                        if (tokSubSliceInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSubSliceInfo = tokSubSliceInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSubSliceInfo == tokSubSliceInfoEnd);
                            } break;
                            case TOK_FS_GT_SLICE_INFO__DSSINFO: {
                                uint32_t arrayElementIdDSSInfo = varLen->arrayElementId;
                                const TokenHeader *tokDSSInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokDSSInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokDSSInfo < tokDSSInfoEnd) {
                                    if (false == tokDSSInfo->flags.flag4IsVariableLength) {
                                        switch (tokDSSInfo->id) {
                                        default:
                                            if (tokDSSInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBB_GT_DUALSUBSLICE_INFO__ENABLED: {
                                            dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].Enabled = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].Enabled)>(*tokDSSInfo);
                                        } break;
                                        };
                                        tokDSSInfo = tokDSSInfo + 1 + tokDSSInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokDSSInfo);
                                        switch (tokDSSInfo->id) {
                                        default:
                                            if (tokDSSInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_DUALSUBSLICE_INFO__SUB_SLICE: {
                                            uint32_t arrayElementIdSubSlice = varLen->arrayElementId;
                                            const TokenHeader *tokSubSlice = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSubSliceEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSubSlice < tokSubSliceEnd) {
                                                if (false == tokSubSlice->flags.flag4IsVariableLength) {
                                                    switch (tokSubSlice->id) {
                                                    default:
                                                        if (tokSubSlice->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                                        dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].Enabled = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].Enabled)>(*tokSubSlice);
                                                    } break;
                                                    case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                                        dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledCount = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledCount)>(*tokSubSlice);
                                                    } break;
                                                    case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                                        dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledMask = readTokValue<decltype(dst.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledMask)>(*tokSubSlice);
                                                    } break;
                                                    };
                                                    tokSubSlice = tokSubSlice + 1 + tokSubSlice->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSlice);
                                                    if (tokSubSlice->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokSubSlice = tokSubSlice + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSubSlice == tokSubSliceEnd);
                                        } break;
                                        };
                                        tokDSSInfo = tokDSSInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokDSSInfo == tokDSSInfoEnd);
                            } break;
                            };
                            tokSliceInfo = tokSliceInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSliceInfo == tokSliceInfoEnd);
                } break;
                case TOK_FS_GT_SYSTEM_INFO__SQIDI_INFO: {
                    const TokenHeader *tokSqidiInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSqidiInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSqidiInfo < tokSqidiInfoEnd) {
                        if (false == tokSqidiInfo->flags.flag4IsVariableLength) {
                            switch (tokSqidiInfo->id) {
                            default:
                                if (tokSqidiInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_SQIDI_INFO__NUMBEROF_SQIDI: {
                                dst.SqidiInfo.NumberofSQIDI = readTokValue<decltype(dst.SqidiInfo.NumberofSQIDI)>(*tokSqidiInfo);
                            } break;
                            case TOK_FBD_GT_SQIDI_INFO__NUMBEROF_DOORBELL_PER_SQIDI: {
                                dst.SqidiInfo.NumberofDoorbellPerSQIDI = readTokValue<decltype(dst.SqidiInfo.NumberofDoorbellPerSQIDI)>(*tokSqidiInfo);
                            } break;
                            };
                            tokSqidiInfo = tokSqidiInfo + 1 + tokSqidiInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSqidiInfo);
                            if (tokSqidiInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokSqidiInfo = tokSqidiInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSqidiInfo == tokSqidiInfoEnd);
                } break;
                case TOK_FS_GT_SYSTEM_INFO__CCSINFO: {
                    const TokenHeader *tokCCSInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokCCSInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokCCSInfo < tokCCSInfoEnd) {
                        if (false == tokCCSInfo->flags.flag4IsVariableLength) {
                            switch (tokCCSInfo->id) {
                            default:
                                if (tokCCSInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_CCS_INFO__NUMBER_OF_CCSENABLED: {
                                dst.CCSInfo.NumberOfCCSEnabled = readTokValue<decltype(dst.CCSInfo.NumberOfCCSEnabled)>(*tokCCSInfo);
                            } break;
                            case TOK_FBB_GT_CCS_INFO__IS_VALID: {
                                dst.CCSInfo.IsValid = readTokValue<decltype(dst.CCSInfo.IsValid)>(*tokCCSInfo);
                            } break;
                            };
                            tokCCSInfo = tokCCSInfo + 1 + tokCCSInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCCSInfo);
                            switch (tokCCSInfo->id) {
                            default:
                                if (tokCCSInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_CCS_INFO__INSTANCES: {
                                const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokInstances < tokInstancesEnd) {
                                    if (false == tokInstances->flags.flag4IsVariableLength) {
                                        switch (tokInstances->id) {
                                        default:
                                            if (tokInstances->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSENABLE_MASK: {
                                            dst.CCSInfo.Instances.CCSEnableMask = readTokValue<decltype(dst.CCSInfo.Instances.CCSEnableMask)>(*tokInstances);
                                        } break;
                                        };
                                        tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                                        switch (tokInstances->id) {
                                        default:
                                            if (tokInstances->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_CCS_INFO__CCSINSTANCES__BITS: {
                                            const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokBits < tokBitsEnd) {
                                                if (false == tokBits->flags.flag4IsVariableLength) {
                                                    switch (tokBits->id) {
                                                    default:
                                                        if (tokBits->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS0ENABLED: {
                                                        dst.CCSInfo.Instances.Bits.CCS0Enabled = readTokValue<decltype(dst.CCSInfo.Instances.Bits.CCS0Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS1ENABLED: {
                                                        dst.CCSInfo.Instances.Bits.CCS1Enabled = readTokValue<decltype(dst.CCSInfo.Instances.Bits.CCS1Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS2ENABLED: {
                                                        dst.CCSInfo.Instances.Bits.CCS2Enabled = readTokValue<decltype(dst.CCSInfo.Instances.Bits.CCS2Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS3ENABLED: {
                                                        dst.CCSInfo.Instances.Bits.CCS3Enabled = readTokValue<decltype(dst.CCSInfo.Instances.Bits.CCS3Enabled)>(*tokBits);
                                                    } break;
                                                    };
                                                    tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                                    if (tokBits->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokBits == tokBitsEnd);
                                        } break;
                                        };
                                        tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokInstances == tokInstancesEnd);
                            } break;
                            };
                            tokCCSInfo = tokCCSInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokCCSInfo == tokCCSInfoEnd);
                } break;
                case TOK_FS_GT_SYSTEM_INFO__MULTI_TILE_ARCH_INFO: {
                    const TokenHeader *tokMultiTileArchInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokMultiTileArchInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokMultiTileArchInfo < tokMultiTileArchInfoEnd) {
                        if (false == tokMultiTileArchInfo->flags.flag4IsVariableLength) {
                            switch (tokMultiTileArchInfo->id) {
                            default:
                                if (tokMultiTileArchInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__TILE_COUNT: {
                                dst.MultiTileArchInfo.TileCount = readTokValue<decltype(dst.MultiTileArchInfo.TileCount)>(*tokMultiTileArchInfo);
                            } break;
                            case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE0: {
                                dst.MultiTileArchInfo.Tile0 = readTokValue<decltype(dst.MultiTileArchInfo.Tile0)>(*tokMultiTileArchInfo);
                            } break;
                            case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE1: {
                                dst.MultiTileArchInfo.Tile1 = readTokValue<decltype(dst.MultiTileArchInfo.Tile1)>(*tokMultiTileArchInfo);
                            } break;
                            case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE2: {
                                dst.MultiTileArchInfo.Tile2 = readTokValue<decltype(dst.MultiTileArchInfo.Tile2)>(*tokMultiTileArchInfo);
                            } break;
                            case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE3: {
                                dst.MultiTileArchInfo.Tile3 = readTokValue<decltype(dst.MultiTileArchInfo.Tile3)>(*tokMultiTileArchInfo);
                            } break;
                            case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__TILE_MASK: {
                                dst.MultiTileArchInfo.TileMask = readTokValue<decltype(dst.MultiTileArchInfo.TileMask)>(*tokMultiTileArchInfo);
                            } break;
                            case TOK_FBB_GT_MULTI_TILE_ARCH_INFO__IS_VALID: {
                                dst.MultiTileArchInfo.IsValid = readTokValue<decltype(dst.MultiTileArchInfo.IsValid)>(*tokMultiTileArchInfo);
                            } break;
                            };
                            tokMultiTileArchInfo = tokMultiTileArchInfo + 1 + tokMultiTileArchInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMultiTileArchInfo);
                            if (tokMultiTileArchInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokMultiTileArchInfo = tokMultiTileArchInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokMultiTileArchInfo == tokMultiTileArchInfoEnd);
                } break;
                case TOK_FS_GT_SYSTEM_INFO__VDBOX_INFO: {
                    const TokenHeader *tokVDBoxInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokVDBoxInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokVDBoxInfo < tokVDBoxInfoEnd) {
                        if (false == tokVDBoxInfo->flags.flag4IsVariableLength) {
                            switch (tokVDBoxInfo->id) {
                            default:
                                if (tokVDBoxInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_VDBOX_INFO__NUMBER_OF_VDBOX_ENABLED: {
                                dst.VDBoxInfo.NumberOfVDBoxEnabled = readTokValue<decltype(dst.VDBoxInfo.NumberOfVDBoxEnabled)>(*tokVDBoxInfo);
                            } break;
                            case TOK_FBB_GT_VDBOX_INFO__IS_VALID: {
                                dst.VDBoxInfo.IsValid = readTokValue<decltype(dst.VDBoxInfo.IsValid)>(*tokVDBoxInfo);
                            } break;
                            };
                            tokVDBoxInfo = tokVDBoxInfo + 1 + tokVDBoxInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokVDBoxInfo);
                            switch (tokVDBoxInfo->id) {
                            default:
                                if (tokVDBoxInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_VDBOX_INFO__INSTANCES: {
                                const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokInstances < tokInstancesEnd) {
                                    if (false == tokInstances->flags.flag4IsVariableLength) {
                                        switch (tokInstances->id) {
                                        default:
                                            if (tokInstances->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBOX_ENABLE_MASK: {
                                            dst.VDBoxInfo.Instances.VDBoxEnableMask = readTokValue<decltype(dst.VDBoxInfo.Instances.VDBoxEnableMask)>(*tokInstances);
                                        } break;
                                        };
                                        tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                                        switch (tokInstances->id) {
                                        default:
                                            if (tokInstances->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_VDBOX_INFO__VDBOX_INSTANCES__BITS: {
                                            const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokBits < tokBitsEnd) {
                                                if (false == tokBits->flags.flag4IsVariableLength) {
                                                    switch (tokBits->id) {
                                                    default:
                                                        if (tokBits->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX0ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox0Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox0Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX1ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox1Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox1Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX2ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox2Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox2Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX3ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox3Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox3Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX4ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox4Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox4Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX5ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox5Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox5Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX6ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox6Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox6Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX7ENABLED: {
                                                        dst.VDBoxInfo.Instances.Bits.VDBox7Enabled = readTokValue<decltype(dst.VDBoxInfo.Instances.Bits.VDBox7Enabled)>(*tokBits);
                                                    } break;
                                                    };
                                                    tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                                    if (tokBits->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokBits == tokBitsEnd);
                                        } break;
                                        };
                                        tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokInstances == tokInstancesEnd);
                            } break;
                            case TOK_FS_GT_VDBOX_INFO__SFCSUPPORT: {
                                const TokenHeader *tokSFCSupport = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSFCSupportEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSFCSupport < tokSFCSupportEnd) {
                                    if (false == tokSFCSupport->flags.flag4IsVariableLength) {
                                        switch (tokSFCSupport->id) {
                                        default:
                                            if (tokSFCSupport->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__VALUE: {
                                            dst.VDBoxInfo.SFCSupport.Value = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.Value)>(*tokSFCSupport);
                                        } break;
                                        };
                                        tokSFCSupport = tokSFCSupport + 1 + tokSFCSupport->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSFCSupport);
                                        switch (tokSFCSupport->id) {
                                        default:
                                            if (tokSFCSupport->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_VDBOX_INFO__ANONYMOUS5662__SFC_SUPPORTED_BITS: {
                                            const TokenHeader *tokSfcSupportedBits = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSfcSupportedBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSfcSupportedBits < tokSfcSupportedBitsEnd) {
                                                if (false == tokSfcSupportedBits->flags.flag4IsVariableLength) {
                                                    switch (tokSfcSupportedBits->id) {
                                                    default:
                                                        if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX0: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX1: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX2: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX3: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX4: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX5: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX6: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX7: {
                                                        dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7 = readTokValue<decltype(dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7)>(*tokSfcSupportedBits);
                                                    } break;
                                                    };
                                                    tokSfcSupportedBits = tokSfcSupportedBits + 1 + tokSfcSupportedBits->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSfcSupportedBits);
                                                    if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokSfcSupportedBits = tokSfcSupportedBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSfcSupportedBits == tokSfcSupportedBitsEnd);
                                        } break;
                                        };
                                        tokSFCSupport = tokSFCSupport + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSFCSupport == tokSFCSupportEnd);
                            } break;
                            };
                            tokVDBoxInfo = tokVDBoxInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokVDBoxInfo == tokVDBoxInfoEnd);
                } break;
                case TOK_FS_GT_SYSTEM_INFO__VEBOX_INFO: {
                    const TokenHeader *tokVEBoxInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokVEBoxInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokVEBoxInfo < tokVEBoxInfoEnd) {
                        if (false == tokVEBoxInfo->flags.flag4IsVariableLength) {
                            switch (tokVEBoxInfo->id) {
                            default:
                                if (tokVEBoxInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_VEBOX_INFO__NUMBER_OF_VEBOX_ENABLED: {
                                dst.VEBoxInfo.NumberOfVEBoxEnabled = readTokValue<decltype(dst.VEBoxInfo.NumberOfVEBoxEnabled)>(*tokVEBoxInfo);
                            } break;
                            case TOK_FBB_GT_VEBOX_INFO__IS_VALID: {
                                dst.VEBoxInfo.IsValid = readTokValue<decltype(dst.VEBoxInfo.IsValid)>(*tokVEBoxInfo);
                            } break;
                            };
                            tokVEBoxInfo = tokVEBoxInfo + 1 + tokVEBoxInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokVEBoxInfo);
                            switch (tokVEBoxInfo->id) {
                            default:
                                if (tokVEBoxInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_VEBOX_INFO__INSTANCES: {
                                const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokInstances < tokInstancesEnd) {
                                    if (false == tokInstances->flags.flag4IsVariableLength) {
                                        switch (tokInstances->id) {
                                        default:
                                            if (tokInstances->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBOX_ENABLE_MASK: {
                                            dst.VEBoxInfo.Instances.VEBoxEnableMask = readTokValue<decltype(dst.VEBoxInfo.Instances.VEBoxEnableMask)>(*tokInstances);
                                        } break;
                                        };
                                        tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                                        switch (tokInstances->id) {
                                        default:
                                            if (tokInstances->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_VEBOX_INFO__VEBOX_INSTANCES__BITS: {
                                            const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokBits < tokBitsEnd) {
                                                if (false == tokBits->flags.flag4IsVariableLength) {
                                                    switch (tokBits->id) {
                                                    default:
                                                        if (tokBits->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX0ENABLED: {
                                                        dst.VEBoxInfo.Instances.Bits.VEBox0Enabled = readTokValue<decltype(dst.VEBoxInfo.Instances.Bits.VEBox0Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX1ENABLED: {
                                                        dst.VEBoxInfo.Instances.Bits.VEBox1Enabled = readTokValue<decltype(dst.VEBoxInfo.Instances.Bits.VEBox1Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX2ENABLED: {
                                                        dst.VEBoxInfo.Instances.Bits.VEBox2Enabled = readTokValue<decltype(dst.VEBoxInfo.Instances.Bits.VEBox2Enabled)>(*tokBits);
                                                    } break;
                                                    case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX3ENABLED: {
                                                        dst.VEBoxInfo.Instances.Bits.VEBox3Enabled = readTokValue<decltype(dst.VEBoxInfo.Instances.Bits.VEBox3Enabled)>(*tokBits);
                                                    } break;
                                                    };
                                                    tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                                    if (tokBits->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokBits == tokBitsEnd);
                                        } break;
                                        };
                                        tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokInstances == tokInstancesEnd);
                            } break;
                            case TOK_FS_GT_VEBOX_INFO__SFCSUPPORT: {
                                const TokenHeader *tokSFCSupport = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSFCSupportEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSFCSupport < tokSFCSupportEnd) {
                                    if (false == tokSFCSupport->flags.flag4IsVariableLength) {
                                        switch (tokSFCSupport->id) {
                                        default:
                                            if (tokSFCSupport->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__VALUE: {
                                            dst.VEBoxInfo.SFCSupport.Value = readTokValue<decltype(dst.VEBoxInfo.SFCSupport.Value)>(*tokSFCSupport);
                                        } break;
                                        };
                                        tokSFCSupport = tokSFCSupport + 1 + tokSFCSupport->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSFCSupport);
                                        switch (tokSFCSupport->id) {
                                        default:
                                            if (tokSFCSupport->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_VEBOX_INFO__ANONYMOUS3862__SFC_SUPPORTED_BITS: {
                                            const TokenHeader *tokSfcSupportedBits = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSfcSupportedBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSfcSupportedBits < tokSfcSupportedBitsEnd) {
                                                if (false == tokSfcSupportedBits->flags.flag4IsVariableLength) {
                                                    switch (tokSfcSupportedBits->id) {
                                                    default:
                                                        if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX0: {
                                                        dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0 = readTokValue<decltype(dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX1: {
                                                        dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1 = readTokValue<decltype(dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX2: {
                                                        dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2 = readTokValue<decltype(dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2)>(*tokSfcSupportedBits);
                                                    } break;
                                                    case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX3: {
                                                        dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3 = readTokValue<decltype(dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3)>(*tokSfcSupportedBits);
                                                    } break;
                                                    };
                                                    tokSfcSupportedBits = tokSfcSupportedBits + 1 + tokSfcSupportedBits->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSfcSupportedBits);
                                                    if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokSfcSupportedBits = tokSfcSupportedBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSfcSupportedBits == tokSfcSupportedBitsEnd);
                                        } break;
                                        };
                                        tokSFCSupport = tokSFCSupport + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSFCSupport == tokSFCSupportEnd);
                            } break;
                            };
                            tokVEBoxInfo = tokVEBoxInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokVEBoxInfo == tokVEBoxInfoEnd);
                } break;
                case TOK_FS_GT_SYSTEM_INFO__CACHE_TYPES: {
                    const TokenHeader *tokCacheTypes = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokCacheTypesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokCacheTypes < tokCacheTypesEnd) {
                        if (false == tokCacheTypes->flags.flag4IsVariableLength) {
                            switch (tokCacheTypes->id) {
                            default:
                                if (tokCacheTypes->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__L3: {
                                dst.CacheTypes.L3 = readTokValue<decltype(dst.CacheTypes.L3)>(*tokCacheTypes);
                            } break;
                            case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__LLC: {
                                dst.CacheTypes.LLC = readTokValue<decltype(dst.CacheTypes.LLC)>(*tokCacheTypes);
                            } break;
                            case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__E_DRAM: {
                                dst.CacheTypes.eDRAM = readTokValue<decltype(dst.CacheTypes.eDRAM)>(*tokCacheTypes);
                            } break;
                            case TOK_FBD_GT_CACHE_TYPES__CACHE_TYPE_MASK: {
                                dst.CacheTypes.CacheTypeMask = readTokValue<decltype(dst.CacheTypes.CacheTypeMask)>(*tokCacheTypes);
                            } break;
                            };
                            tokCacheTypes = tokCacheTypes + 1 + tokCacheTypes->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCacheTypes);
                            if (tokCacheTypes->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokCacheTypes = tokCacheTypes + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokCacheTypes == tokCacheTypesEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_SKU_FEATURE_TABLE> {
    template <typename _SKU_FEATURE_TABLET>
    static bool demarshall(_SKU_FEATURE_TABLET &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_ULT: {
                    dst.FtrULT = readTokValue<decltype(dst.FtrULT)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_LCIA: {
                    dst.FtrLCIA = readTokValue<decltype(dst.FtrLCIA)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSRING: {
                    dst.FtrCCSRing = readTokValue<decltype(dst.FtrCCSRing)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSNODE: {
                    dst.FtrCCSNode = readTokValue<decltype(dst.FtrCCSNode)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSMULTI_INSTANCE: {
                    dst.FtrCCSMultiInstance = readTokValue<decltype(dst.FtrCCSMultiInstance)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS11155__FTR_DISPLAY_DISABLED: {
                    dst.FtrDisplayDisabled = readTokValue<decltype(dst.FtrDisplayDisabled)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21584__FTR_POOLED_EU_ENABLED: {
                    dst.FtrPooledEuEnabled = readTokValue<decltype(dst.FtrPooledEuEnabled)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_MID_BATCH_PREEMPT: {
                    dst.FtrGpGpuMidBatchPreempt = readTokValue<decltype(dst.FtrGpGpuMidBatchPreempt)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_THREAD_GROUP_LEVEL_PREEMPT: {
                    dst.FtrGpGpuThreadGroupLevelPreempt = readTokValue<decltype(dst.FtrGpGpuThreadGroupLevelPreempt)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_MID_THREAD_LEVEL_PREEMPT: {
                    dst.FtrGpGpuMidThreadLevelPreempt = readTokValue<decltype(dst.FtrGpGpuMidThreadLevelPreempt)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PPGTT: {
                    dst.FtrPPGTT = readTokValue<decltype(dst.FtrPPGTT)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_IA32E_GFX_PTES: {
                    dst.FtrIA32eGfxPTEs = readTokValue<decltype(dst.FtrIA32eGfxPTEs)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_MEM_TYPE_MOCS_DEFER_PAT: {
                    dst.FtrMemTypeMocsDeferPAT = readTokValue<decltype(dst.FtrMemTypeMocsDeferPAT)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PML4SUPPORT: {
                    dst.FtrPml4Support = readTokValue<decltype(dst.FtrPml4Support)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_SVM: {
                    dst.FtrSVM = readTokValue<decltype(dst.FtrSVM)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TILE_MAPPED_RESOURCE: {
                    dst.FtrTileMappedResource = readTokValue<decltype(dst.FtrTileMappedResource)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TRANSLATION_TABLE: {
                    dst.FtrTranslationTable = readTokValue<decltype(dst.FtrTranslationTable)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_USER_MODE_TRANSLATION_TABLE: {
                    dst.FtrUserModeTranslationTable = readTokValue<decltype(dst.FtrUserModeTranslationTable)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_NULL_PAGES: {
                    dst.FtrNullPages = readTokValue<decltype(dst.FtrNullPages)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_L3IACOHERENCY: {
                    dst.FtrL3IACoherency = readTokValue<decltype(dst.FtrL3IACoherency)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_EDRAM: {
                    dst.FtrEDram = readTokValue<decltype(dst.FtrEDram)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LLCBYPASS: {
                    dst.FtrLLCBypass = readTokValue<decltype(dst.FtrLLCBypass)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CENTRAL_CACHE_POLICY: {
                    dst.FtrCentralCachePolicy = readTokValue<decltype(dst.FtrCentralCachePolicy)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2GPU_MMU: {
                    dst.FtrWddm2GpuMmu = readTokValue<decltype(dst.FtrWddm2GpuMmu)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2SVM: {
                    dst.FtrWddm2Svm = readTokValue<decltype(dst.FtrWddm2Svm)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_STANDARD_MIP_TAIL_FORMAT: {
                    dst.FtrStandardMipTailFormat = readTokValue<decltype(dst.FtrStandardMipTailFormat)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2_1_64KB_PAGES: {
                    dst.FtrWddm2_1_64kbPages = readTokValue<decltype(dst.FtrWddm2_1_64kbPages)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_E2ECOMPRESSION: {
                    dst.FtrE2ECompression = readTokValue<decltype(dst.FtrE2ECompression)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LINEAR_CCS: {
                    dst.FtrLinearCCS = readTokValue<decltype(dst.FtrLinearCCS)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LOCAL_MEMORY: {
                    dst.FtrLocalMemory = readTokValue<decltype(dst.FtrLocalMemory)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PPGTT64KBWALK_OPTIMIZATION: {
                    dst.FtrPpgtt64KBWalkOptimization = readTokValue<decltype(dst.FtrPpgtt64KBWalkOptimization)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TILE_Y: {
                    dst.FtrTileY = readTokValue<decltype(dst.FtrTileY)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_FLAT_PHYS_CCS: {
                    dst.FtrFlatPhysCCS = readTokValue<decltype(dst.FtrFlatPhysCCS)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_MULTI_TILE_ARCH: {
                    dst.FtrMultiTileArch = readTokValue<decltype(dst.FtrMultiTileArch)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LOCAL_MEMORY_ALLOWS4KB: {
                    dst.FtrLocalMemoryAllows4KB = readTokValue<decltype(dst.FtrLocalMemoryAllows4KB)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_DISPLAY_XTILING: {
                    dst.FtrDisplayXTiling = readTokValue<decltype(dst.FtrDisplayXTiling)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CAMERA_CAPTURE_CACHING: {
                    dst.FtrCameraCaptureCaching = readTokValue<decltype(dst.FtrCameraCaptureCaching)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_KMD_DAF: {
                    dst.FtrKmdDaf = readTokValue<decltype(dst.FtrKmdDaf)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_FRAME_BUFFER_LLC: {
                    dst.FtrFrameBufferLLC = readTokValue<decltype(dst.FtrFrameBufferLLC)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_DRIVER_FLR: {
                    dst.FtrDriverFLR = readTokValue<decltype(dst.FtrDriverFLR)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC_LDR2D: {
                    dst.FtrAstcLdr2D = readTokValue<decltype(dst.FtrAstcLdr2D)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC_HDR2D: {
                    dst.FtrAstcHdr2D = readTokValue<decltype(dst.FtrAstcHdr2D)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC3D: {
                    dst.FtrAstc3D = readTokValue<decltype(dst.FtrAstc3D)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_FBC: {
                    dst.FtrFbc = readTokValue<decltype(dst.FtrFbc)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS54736__FTR_REND_COMP: {
                    dst.FtrRendComp = readTokValue<decltype(dst.FtrRendComp)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS54736__FTR_DISPLAY_YTILING: {
                    dst.FtrDisplayYTiling = readTokValue<decltype(dst.FtrDisplayYTiling)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_S3D: {
                    dst.FtrS3D = readTokValue<decltype(dst.FtrS3D)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_DISPLAY_ENGINE_S3D: {
                    dst.FtrDisplayEngineS3d = readTokValue<decltype(dst.FtrDisplayEngineS3d)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS89755__FTR_VGT: {
                    dst.FtrVgt = readTokValue<decltype(dst.FtrVgt)>(*tok);
                } break;
                case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS91822__FTR_ASSIGNED_GPU_TILE: {
                    dst.FtrAssignedGpuTile = readTokValue<decltype(dst.FtrAssignedGpuTile)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_SKU_FEATURE_TABLE:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_WA_TABLE> {
    template <typename _WA_TABLET>
    static bool demarshall(_WA_TABLET &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_WA_TABLE__WA_ALIGN_INDEX_BUFFER: {
                    dst.WaAlignIndexBuffer = readTokValue<decltype(dst.WaAlignIndexBuffer)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_SEND_MIFLUSHBEFORE_VFE: {
                    dst.WaSendMIFLUSHBeforeVFE = readTokValue<decltype(dst.WaSendMIFLUSHBeforeVFE)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DISABLE_PER_CTXT_PREEMPTION_GRANULARITY_CONTROL: {
                    dst.WaDisablePerCtxtPreemptionGranularityControl = readTokValue<decltype(dst.WaDisablePerCtxtPreemptionGranularityControl)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DISABLE_LSQCROPERFFOR_OCL: {
                    dst.WaDisableLSQCROPERFforOCL = readTokValue<decltype(dst.WaDisableLSQCROPERFforOCL)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_VALIGN2FOR96BPP_FORMATS: {
                    dst.WaValign2For96bppFormats = readTokValue<decltype(dst.WaValign2For96bppFormats)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_VALIGN2FOR_R8G8B8UINTFORMAT: {
                    dst.WaValign2ForR8G8B8UINTFormat = readTokValue<decltype(dst.WaValign2ForR8G8B8UINTFormat)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_CSRUNCACHABLE: {
                    dst.WaCSRUncachable = readTokValue<decltype(dst.WaCSRUncachable)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DISABLE_FUSED_THREAD_SCHEDULING: {
                    dst.WaDisableFusedThreadScheduling = readTokValue<decltype(dst.WaDisableFusedThreadScheduling)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_MODIFY_VFESTATE_AFTER_GPGPUPREEMPTION: {
                    dst.WaModifyVFEStateAfterGPGPUPreemption = readTokValue<decltype(dst.WaModifyVFEStateAfterGPGPUPreemption)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_CURSOR16K: {
                    dst.WaCursor16K = readTokValue<decltype(dst.WaCursor16K)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA8K_ALIGNFOR_ASYNC_FLIP: {
                    dst.Wa8kAlignforAsyncFlip = readTokValue<decltype(dst.Wa8kAlignforAsyncFlip)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA29BIT_DISPLAY_ADDR_LIMIT: {
                    dst.Wa29BitDisplayAddrLimit = readTokValue<decltype(dst.Wa29BitDisplayAddrLimit)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_ALIGN_CONTEXT_IMAGE: {
                    dst.WaAlignContextImage = readTokValue<decltype(dst.WaAlignContextImage)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_FORCE_GLOBAL_GTT: {
                    dst.WaForceGlobalGTT = readTokValue<decltype(dst.WaForceGlobalGTT)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_REPORT_PERF_COUNT_FORCE_GLOBAL_GTT: {
                    dst.WaReportPerfCountForceGlobalGTT = readTokValue<decltype(dst.WaReportPerfCountForceGlobalGTT)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_OA_ADDRESS_TRANSLATION: {
                    dst.WaOaAddressTranslation = readTokValue<decltype(dst.WaOaAddressTranslation)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA2ROW_VERTICAL_ALIGNMENT: {
                    dst.Wa2RowVerticalAlignment = readTokValue<decltype(dst.Wa2RowVerticalAlignment)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_PPGTT_ALIAS_GLOBAL_GTT_SPACE: {
                    dst.WaPpgttAliasGlobalGttSpace = readTokValue<decltype(dst.WaPpgttAliasGlobalGttSpace)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_CLEAR_FENCE_REGISTERS_AT_DRIVER_INIT: {
                    dst.WaClearFenceRegistersAtDriverInit = readTokValue<decltype(dst.WaClearFenceRegistersAtDriverInit)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_RESTRICT_PITCH128KB: {
                    dst.WaRestrictPitch128KB = readTokValue<decltype(dst.WaRestrictPitch128KB)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_AVOID_LLC: {
                    dst.WaAvoidLLC = readTokValue<decltype(dst.WaAvoidLLC)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_AVOID_L3: {
                    dst.WaAvoidL3 = readTokValue<decltype(dst.WaAvoidL3)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA16TILE_FENCES_ONLY: {
                    dst.Wa16TileFencesOnly = readTokValue<decltype(dst.Wa16TileFencesOnly)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA16MBOABUFFER_ALIGNMENT: {
                    dst.Wa16MBOABufferAlignment = readTokValue<decltype(dst.Wa16MBOABufferAlignment)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_TRANSLATION_TABLE_UNAVAILABLE: {
                    dst.WaTranslationTableUnavailable = readTokValue<decltype(dst.WaTranslationTableUnavailable)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_NO_MINIMIZED_TRIVIAL_SURFACE_PADDING: {
                    dst.WaNoMinimizedTrivialSurfacePadding = readTokValue<decltype(dst.WaNoMinimizedTrivialSurfacePadding)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_NO_BUFFER_SAMPLER_PADDING: {
                    dst.WaNoBufferSamplerPadding = readTokValue<decltype(dst.WaNoBufferSamplerPadding)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_SURFACE_STATE_PLANAR_YOFFSET_ALIGN_BY2: {
                    dst.WaSurfaceStatePlanarYOffsetAlignBy2 = readTokValue<decltype(dst.WaSurfaceStatePlanarYOffsetAlignBy2)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_GTT_CACHING_OFF_BY_DEFAULT: {
                    dst.WaGttCachingOffByDefault = readTokValue<decltype(dst.WaGttCachingOffByDefault)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_TOUCH_ALL_SVM_MEMORY: {
                    dst.WaTouchAllSvmMemory = readTokValue<decltype(dst.WaTouchAllSvmMemory)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_IOBADDRESS_MUST_BE_VALID_IN_HW_CONTEXT: {
                    dst.WaIOBAddressMustBeValidInHwContext = readTokValue<decltype(dst.WaIOBAddressMustBeValidInHwContext)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_FLUSH_TLB_AFTER_CPU_GGTT_WRITES: {
                    dst.WaFlushTlbAfterCpuGgttWrites = readTokValue<decltype(dst.WaFlushTlbAfterCpuGgttWrites)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_MSAA8X_TILE_YDEPTH_PITCH_ALIGNMENT: {
                    dst.WaMsaa8xTileYDepthPitchAlignment = readTokValue<decltype(dst.WaMsaa8xTileYDepthPitchAlignment)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DISABLE_NULL_PAGE_AS_DUMMY: {
                    dst.WaDisableNullPageAsDummy = readTokValue<decltype(dst.WaDisableNullPageAsDummy)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_USE_VALIGN16ON_TILE_XYBPP816: {
                    dst.WaUseVAlign16OnTileXYBpp816 = readTokValue<decltype(dst.WaUseVAlign16OnTileXYBpp816)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_GTT_PAT0: {
                    dst.WaGttPat0 = readTokValue<decltype(dst.WaGttPat0)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_GTT_PAT0WB: {
                    dst.WaGttPat0WB = readTokValue<decltype(dst.WaGttPat0WB)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_MEM_TYPE_IS_MAX_OF_PAT_AND_MOCS: {
                    dst.WaMemTypeIsMaxOfPatAndMocs = readTokValue<decltype(dst.WaMemTypeIsMaxOfPatAndMocs)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_GTT_PAT0GTT_WB_OVER_OS_IOMMU_ELLC_ONLY: {
                    dst.WaGttPat0GttWbOverOsIommuEllcOnly = readTokValue<decltype(dst.WaGttPat0GttWbOverOsIommuEllcOnly)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_ADD_DUMMY_PAGE_FOR_DISPLAY_PREFETCH: {
                    dst.WaAddDummyPageForDisplayPrefetch = readTokValue<decltype(dst.WaAddDummyPageForDisplayPrefetch)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_LLCCACHING_UNSUPPORTED: {
                    dst.WaLLCCachingUnsupported = readTokValue<decltype(dst.WaLLCCachingUnsupported)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DOUBLE_FAST_CLEAR_WIDTH_ALIGNMENT: {
                    dst.WaDoubleFastClearWidthAlignment = readTokValue<decltype(dst.WaDoubleFastClearWidthAlignment)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_COMPRESSED_RESOURCE_REQUIRES_CONST_VA21: {
                    dst.WaCompressedResourceRequiresConstVA21 = readTokValue<decltype(dst.WaCompressedResourceRequiresConstVA21)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DISREGARD_PLATFORM_CHECKS: {
                    dst.WaDisregardPlatformChecks = readTokValue<decltype(dst.WaDisregardPlatformChecks)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_LOSSLESS_COMPRESSION_SURFACE_STRIDE: {
                    dst.WaLosslessCompressionSurfaceStride = readTokValue<decltype(dst.WaLosslessCompressionSurfaceStride)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_FBC_LINEAR_SURFACE_STRIDE: {
                    dst.WaFbcLinearSurfaceStride = readTokValue<decltype(dst.WaFbcLinearSurfaceStride)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA4K_ALIGN_UVOFFSET_NV12LINEAR_SURFACE: {
                    dst.Wa4kAlignUVOffsetNV12LinearSurface = readTokValue<decltype(dst.Wa4kAlignUVOffsetNV12LinearSurface)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_ASTC_CORRUPTION_FOR_ODD_COMPRESSED_BLOCK_SIZE_X: {
                    dst.WaAstcCorruptionForOddCompressedBlockSizeX = readTokValue<decltype(dst.WaAstcCorruptionForOddCompressedBlockSizeX)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_AUX_TABLE16KGRANULAR: {
                    dst.WaAuxTable16KGranular = readTokValue<decltype(dst.WaAuxTable16KGranular)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_ENCRYPTED_EDRAM_ONLY_PARTIALS: {
                    dst.WaEncryptedEdramOnlyPartials = readTokValue<decltype(dst.WaEncryptedEdramOnlyPartials)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_DISABLE_EDRAM_FOR_DISPLAY_RT: {
                    dst.WaDisableEdramForDisplayRT = readTokValue<decltype(dst.WaDisableEdramForDisplayRT)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_LIMIT128BMEDIA_COMPR: {
                    dst.WaLimit128BMediaCompr = readTokValue<decltype(dst.WaLimit128BMediaCompr)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_UNTYPED_BUFFER_COMPRESSION: {
                    dst.WaUntypedBufferCompression = readTokValue<decltype(dst.WaUntypedBufferCompression)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_SAMPLER_CACHE_FLUSH_BETWEEN_REDESCRIBED_SURFACE_READS: {
                    dst.WaSamplerCacheFlushBetweenRedescribedSurfaceReads = readTokValue<decltype(dst.WaSamplerCacheFlushBetweenRedescribedSurfaceReads)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA_ALIGN_YUVRESOURCE_TO_LCU: {
                    dst.WaAlignYUVResourceToLCU = readTokValue<decltype(dst.WaAlignYUVResourceToLCU)>(*tok);
                } break;
                case TOK_FBD_WA_TABLE__WA32BPP_TILE_Y2DCOLOR_NO_HALIGN4: {
                    dst.Wa32bppTileY2DColorNoHAlign4 = readTokValue<decltype(dst.Wa32bppTileY2DColorNoHAlign4)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_WA_TABLE:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_PLATFORM_STR> {
    template <typename PLATFORM_STRT>
    static bool demarshall(PLATFORM_STRT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                    dst.eProductFamily = readTokValue<decltype(dst.eProductFamily)>(*tok);
                } break;
                case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                    dst.ePCHProductFamily = readTokValue<decltype(dst.ePCHProductFamily)>(*tok);
                } break;
                case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                    dst.eDisplayCoreFamily = readTokValue<decltype(dst.eDisplayCoreFamily)>(*tok);
                } break;
                case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                    dst.eRenderCoreFamily = readTokValue<decltype(dst.eRenderCoreFamily)>(*tok);
                } break;
                case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                    dst.ePlatformType = readTokValue<decltype(dst.ePlatformType)>(*tok);
                } break;
                case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                    dst.usDeviceID = readTokValue<decltype(dst.usDeviceID)>(*tok);
                } break;
                case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                    dst.usRevId = readTokValue<decltype(dst.usRevId)>(*tok);
                } break;
                case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                    dst.usDeviceID_PCH = readTokValue<decltype(dst.usDeviceID_PCH)>(*tok);
                } break;
                case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                    dst.usRevId_PCH = readTokValue<decltype(dst.usRevId_PCH)>(*tok);
                } break;
                case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                    dst.eGTType = readTokValue<decltype(dst.eGTType)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_PLATFORM_STR:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_KMD_CAPS_INFO> {
    template <typename __KMD_CAPS_INFOT>
    static bool demarshall(__KMD_CAPS_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_KMD_CAPS_INFO__GAMMA_RGB256X3X16: {
                    dst.Gamma_Rgb256x3x16 = readTokValue<decltype(dst.Gamma_Rgb256x3x16)>(*tok);
                } break;
                case TOK_FBD_KMD_CAPS_INFO__GDIACCELERATION: {
                    dst.GDIAcceleration = readTokValue<decltype(dst.GDIAcceleration)>(*tok);
                } break;
                case TOK_FBD_KMD_CAPS_INFO__OS_MANAGED_HW_CONTEXT: {
                    dst.OsManagedHwContext = readTokValue<decltype(dst.OsManagedHwContext)>(*tok);
                } break;
                case TOK_FBD_KMD_CAPS_INFO__GRAPHICS_PREEMPTION_GRANULARITY: {
                    dst.GraphicsPreemptionGranularity = readTokValue<decltype(dst.GraphicsPreemptionGranularity)>(*tok);
                } break;
                case TOK_FBD_KMD_CAPS_INFO__COMPUTE_PREEMPTION_GRANULARITY: {
                    dst.ComputePreemptionGranularity = readTokValue<decltype(dst.ComputePreemptionGranularity)>(*tok);
                } break;
                case TOK_FBD_KMD_CAPS_INFO__INSTRUMENTATION_IS_ENABLED: {
                    dst.InstrumentationIsEnabled = readTokValue<decltype(dst.InstrumentationIsEnabled)>(*tok);
                } break;
                case TOK_FBD_KMD_CAPS_INFO__DRIVER_STORE_ENABLED: {
                    dst.DriverStoreEnabled = readTokValue<decltype(dst.DriverStoreEnabled)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_KMD_CAPS_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_KMD_OVERLAY_OVERRIDE> {
    template <typename __KMD_OVERLAY_OVERRIDET>
    static bool demarshall(__KMD_OVERLAY_OVERRIDET &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_KMD_OVERLAY_OVERRIDE__OVERRIDE_OVERLAY_CAPS: {
                    dst.OverrideOverlayCaps = readTokValue<decltype(dst.OverrideOverlayCaps)>(*tok);
                } break;
                case TOK_FBD_KMD_OVERLAY_OVERRIDE__RGBOVERLAY: {
                    dst.RGBOverlay = readTokValue<decltype(dst.RGBOverlay)>(*tok);
                } break;
                case TOK_FBD_KMD_OVERLAY_OVERRIDE__YUY2OVERLAY: {
                    dst.YUY2Overlay = readTokValue<decltype(dst.YUY2Overlay)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_KMD_OVERLAY_OVERRIDE:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_KMD_OVERLAY_CAPS_INFO> {
    template <typename __KMD_OVERLAY_CAPS_INFOT>
    static bool demarshall(__KMD_OVERLAY_CAPS_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__CAPS_VALUE: {
                    dst.CapsValue = readTokValue<decltype(dst.CapsValue)>(*tok);
                } break;
                case TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_OVERLAY_DISPLAY_WIDTH: {
                    dst.MaxOverlayDisplayWidth = readTokValue<decltype(dst.MaxOverlayDisplayWidth)>(*tok);
                } break;
                case TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_OVERLAY_DISPLAY_HEIGHT: {
                    dst.MaxOverlayDisplayHeight = readTokValue<decltype(dst.MaxOverlayDisplayHeight)>(*tok);
                } break;
                case TOK_FBC_KMD_OVERLAY_CAPS_INFO__HWSCALER_EXISTS: {
                    dst.HWScalerExists = readTokValue<decltype(dst.HWScalerExists)>(*tok);
                } break;
                case TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_HWSCALER_STRIDE: {
                    dst.MaxHWScalerStride = readTokValue<decltype(dst.MaxHWScalerStride)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_KMD_OVERLAY_CAPS_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__CAPS: {
                    const TokenHeader *tokCaps = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokCapsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokCaps < tokCapsEnd) {
                        if (false == tokCaps->flags.flag4IsVariableLength) {
                            switch (tokCaps->id) {
                            default:
                                if (tokCaps->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__FULL_RANGE_RGB: {
                                dst.Caps.FullRangeRGB = readTokValue<decltype(dst.Caps.FullRangeRGB)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__LIMITED_RANGE_RGB: {
                                dst.Caps.LimitedRangeRGB = readTokValue<decltype(dst.Caps.LimitedRangeRGB)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT601: {
                                dst.Caps.YCbCr_BT601 = readTokValue<decltype(dst.Caps.YCbCr_BT601)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT709: {
                                dst.Caps.YCbCr_BT709 = readTokValue<decltype(dst.Caps.YCbCr_BT709)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT601_XV_YCC: {
                                dst.Caps.YCbCr_BT601_xvYCC = readTokValue<decltype(dst.Caps.YCbCr_BT601_xvYCC)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT709_XV_YCC: {
                                dst.Caps.YCbCr_BT709_xvYCC = readTokValue<decltype(dst.Caps.YCbCr_BT709_xvYCC)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__STRETCH_X: {
                                dst.Caps.StretchX = readTokValue<decltype(dst.Caps.StretchX)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__STRETCH_Y: {
                                dst.Caps.StretchY = readTokValue<decltype(dst.Caps.StretchY)>(*tokCaps);
                            } break;
                            };
                            tokCaps = tokCaps + 1 + tokCaps->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCaps);
                            if (tokCaps->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokCaps = tokCaps + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokCaps == tokCapsEnd);
                } break;
                case TOK_FS_KMD_OVERLAY_CAPS_INFO__OVOVERRIDE: {
                    const TokenHeader *tokOVOverride = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokOVOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokOVOverride < tokOVOverrideEnd) {
                        if (false == tokOVOverride->flags.flag4IsVariableLength) {
                            switch (tokOVOverride->id) {
                            default:
                                if (tokOVOverride->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_KMD_OVERLAY_OVERRIDE__OVERRIDE_OVERLAY_CAPS: {
                                dst.OVOverride.OverrideOverlayCaps = readTokValue<decltype(dst.OVOverride.OverrideOverlayCaps)>(*tokOVOverride);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_OVERRIDE__RGBOVERLAY: {
                                dst.OVOverride.RGBOverlay = readTokValue<decltype(dst.OVOverride.RGBOverlay)>(*tokOVOverride);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_OVERRIDE__YUY2OVERLAY: {
                                dst.OVOverride.YUY2Overlay = readTokValue<decltype(dst.OVOverride.YUY2Overlay)>(*tokOVOverride);
                            } break;
                            };
                            tokOVOverride = tokOVOverride + 1 + tokOVOverride->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOVOverride);
                            if (tokOVOverride->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokOVOverride = tokOVOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokOVOverride == tokOVOverrideEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_FRAME_RATE> {
    template <typename FRAME_RATET>
    static bool demarshall(FRAME_RATET &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_FRAME_RATE__UI_NUMERATOR: {
                    dst.uiNumerator = readTokValue<decltype(dst.uiNumerator)>(*tok);
                } break;
                case TOK_FBD_FRAME_RATE__UI_DENOMINATOR: {
                    dst.uiDenominator = readTokValue<decltype(dst.uiDenominator)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_FRAME_RATE:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_KM_DEFERRED_WAIT_INFO> {
    template <typename _KM_DEFERRED_WAIT_INFOT>
    static bool demarshall(_KM_DEFERRED_WAIT_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_KM_DEFERRED_WAIT_INFO__FEATURE_SUPPORTED: {
                    dst.FeatureSupported = readTokValue<decltype(dst.FeatureSupported)>(*tok);
                } break;
                case TOK_FBD_KM_DEFERRED_WAIT_INFO__ACTIVE_DISPLAY: {
                    dst.ActiveDisplay = readTokValue<decltype(dst.ActiveDisplay)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_KM_DEFERRED_WAIT_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_GFX_PARTITIONING> {
    template <typename __GMM_GFX_PARTITIONINGT>
    static bool demarshall(__GMM_GFX_PARTITIONINGT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                if (tok->flags.flag3IsMandatory) {
                    return false;
                }
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_GFX_PARTITIONING:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_GFX_PARTITIONING__STANDARD: {
                    const TokenHeader *tokStandard = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokStandardEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokStandard < tokStandardEnd) {
                        if (false == tokStandard->flags.flag4IsVariableLength) {
                            switch (tokStandard->id) {
                            default:
                                if (tokStandard->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                dst.Standard.Base = readTokValue<decltype(dst.Standard.Base)>(*tokStandard);
                            } break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                dst.Standard.Limit = readTokValue<decltype(dst.Standard.Limit)>(*tokStandard);
                            } break;
                            };
                            tokStandard = tokStandard + 1 + tokStandard->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokStandard);
                            if (tokStandard->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokStandard = tokStandard + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokStandard == tokStandardEnd);
                } break;
                case TOK_FS_GMM_GFX_PARTITIONING__STANDARD64KB: {
                    const TokenHeader *tokStandard64KB = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokStandard64KBEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokStandard64KB < tokStandard64KBEnd) {
                        if (false == tokStandard64KB->flags.flag4IsVariableLength) {
                            switch (tokStandard64KB->id) {
                            default:
                                if (tokStandard64KB->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                dst.Standard64KB.Base = readTokValue<decltype(dst.Standard64KB.Base)>(*tokStandard64KB);
                            } break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                dst.Standard64KB.Limit = readTokValue<decltype(dst.Standard64KB.Limit)>(*tokStandard64KB);
                            } break;
                            };
                            tokStandard64KB = tokStandard64KB + 1 + tokStandard64KB->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokStandard64KB);
                            if (tokStandard64KB->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokStandard64KB = tokStandard64KB + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokStandard64KB == tokStandard64KBEnd);
                } break;
                case TOK_FS_GMM_GFX_PARTITIONING__SVM: {
                    const TokenHeader *tokSVM = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSVMEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSVM < tokSVMEnd) {
                        if (false == tokSVM->flags.flag4IsVariableLength) {
                            switch (tokSVM->id) {
                            default:
                                if (tokSVM->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                dst.SVM.Base = readTokValue<decltype(dst.SVM.Base)>(*tokSVM);
                            } break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                dst.SVM.Limit = readTokValue<decltype(dst.SVM.Limit)>(*tokSVM);
                            } break;
                            };
                            tokSVM = tokSVM + 1 + tokSVM->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSVM);
                            if (tokSVM->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokSVM = tokSVM + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSVM == tokSVMEnd);
                } break;
                case TOK_FS_GMM_GFX_PARTITIONING__TR: {
                    const TokenHeader *tokTR = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokTREnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokTR < tokTREnd) {
                        if (false == tokTR->flags.flag4IsVariableLength) {
                            switch (tokTR->id) {
                            default:
                                if (tokTR->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                dst.TR.Base = readTokValue<decltype(dst.TR.Base)>(*tokTR);
                            } break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                dst.TR.Limit = readTokValue<decltype(dst.TR.Limit)>(*tokTR);
                            } break;
                            };
                            tokTR = tokTR + 1 + tokTR->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTR);
                            if (tokTR->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokTR = tokTR + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokTR == tokTREnd);
                } break;
                case TOK_FS_GMM_GFX_PARTITIONING__HEAP32: {
                    uint32_t arrayElementIdHeap32 = varLen->arrayElementId;
                    const TokenHeader *tokHeap32 = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokHeap32End = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokHeap32 < tokHeap32End) {
                        if (false == tokHeap32->flags.flag4IsVariableLength) {
                            switch (tokHeap32->id) {
                            default:
                                if (tokHeap32->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                dst.Heap32[arrayElementIdHeap32].Base = readTokValue<decltype(dst.Heap32[arrayElementIdHeap32].Base)>(*tokHeap32);
                            } break;
                            case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                dst.Heap32[arrayElementIdHeap32].Limit = readTokValue<decltype(dst.Heap32[arrayElementIdHeap32].Limit)>(*tokHeap32);
                            } break;
                            };
                            tokHeap32 = tokHeap32 + 1 + tokHeap32->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokHeap32);
                            if (tokHeap32->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokHeap32 = tokHeap32 + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokHeap32 == tokHeap32End);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_ADAPTER_BDF> {
    template <typename _ADAPTER_BDF_T>
    static bool demarshall(_ADAPTER_BDF_T &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__BUS: {
                    dst.Bus = readTokValue<decltype(dst.Bus)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__DEVICE: {
                    dst.Device = readTokValue<decltype(dst.Device)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__FUNCTION: {
                    dst.Function = readTokValue<decltype(dst.Function)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__DATA: {
                    dst.Data = readTokValue<decltype(dst.Data)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_ADAPTER_BDF:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_ADAPTER_INFO> {
    template <typename _ADAPTER_INFOT>
    static bool demarshall(_ADAPTER_INFOT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_ADAPTER_INFO__KMD_VERSION_INFO: {
                    dst.KmdVersionInfo = readTokValue<decltype(dst.KmdVersionInfo)>(*tok);
                } break;
                case TOK_FBC_ADAPTER_INFO__DEVICE_REGISTRY_PATH: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.DeviceRegistryPath)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.DeviceRegistryPath, sizeof(dst.DeviceRegistryPath), srcData, sizeof(dst.DeviceRegistryPath));
                } break;
                case TOK_FBD_ADAPTER_INFO__GFX_TIME_STAMP_FREQ: {
                    dst.GfxTimeStampFreq = readTokValue<decltype(dst.GfxTimeStampFreq)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__GFX_CORE_FREQUENCY: {
                    dst.GfxCoreFrequency = readTokValue<decltype(dst.GfxCoreFrequency)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__FSBFREQUENCY: {
                    dst.FSBFrequency = readTokValue<decltype(dst.FSBFrequency)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__MIN_RENDER_FREQ: {
                    dst.MinRenderFreq = readTokValue<decltype(dst.MinRenderFreq)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__MAX_RENDER_FREQ: {
                    dst.MaxRenderFreq = readTokValue<decltype(dst.MaxRenderFreq)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__PACKAGE_TDP: {
                    dst.PackageTdp = readTokValue<decltype(dst.PackageTdp)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__MAX_FILL_RATE: {
                    dst.MaxFillRate = readTokValue<decltype(dst.MaxFillRate)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__NUMBER_OF_EUS: {
                    dst.NumberOfEUs = readTokValue<decltype(dst.NumberOfEUs)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__DW_RELEASE_TARGET: {
                    dst.dwReleaseTarget = readTokValue<decltype(dst.dwReleaseTarget)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__SIZE_OF_DMA_BUFFER: {
                    dst.SizeOfDmaBuffer = readTokValue<decltype(dst.SizeOfDmaBuffer)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__PATCH_LOCATION_LIST_SIZE: {
                    dst.PatchLocationListSize = readTokValue<decltype(dst.PatchLocationListSize)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__ALLOCATION_LIST_SIZE: {
                    dst.AllocationListSize = readTokValue<decltype(dst.AllocationListSize)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__SMALL_PATCH_LOCATION_LIST_SIZE: {
                    dst.SmallPatchLocationListSize = readTokValue<decltype(dst.SmallPatchLocationListSize)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__DEFAULT_CMD_BUFFER_SIZE: {
                    dst.DefaultCmdBufferSize = readTokValue<decltype(dst.DefaultCmdBufferSize)>(*tok);
                } break;
                case TOK_FBQ_ADAPTER_INFO__GFX_MEMORY_SIZE: {
                    dst.GfxMemorySize = readTokValue<decltype(dst.GfxMemorySize)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__SYSTEM_MEMORY_SIZE: {
                    dst.SystemMemorySize = readTokValue<decltype(dst.SystemMemorySize)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__CACHE_LINE_SIZE: {
                    dst.CacheLineSize = readTokValue<decltype(dst.CacheLineSize)>(*tok);
                } break;
                case TOK_FE_ADAPTER_INFO__PROCESSOR_FAMILY: {
                    dst.ProcessorFamily = readTokValue<decltype(dst.ProcessorFamily)>(*tok);
                } break;
                case TOK_FBC_ADAPTER_INFO__IS_HTSUPPORTED: {
                    dst.IsHTSupported = readTokValue<decltype(dst.IsHTSupported)>(*tok);
                } break;
                case TOK_FBC_ADAPTER_INFO__IS_MUTI_CORE_CPU: {
                    dst.IsMutiCoreCpu = readTokValue<decltype(dst.IsMutiCoreCpu)>(*tok);
                } break;
                case TOK_FBC_ADAPTER_INFO__IS_VTDSUPPORTED: {
                    dst.IsVTDSupported = readTokValue<decltype(dst.IsVTDSupported)>(*tok);
                } break;
                case TOK_FBD_ADAPTER_INFO__REGISTRY_PATH_LENGTH: {
                    dst.RegistryPathLength = readTokValue<decltype(dst.RegistryPathLength)>(*tok);
                } break;
                case TOK_FBQ_ADAPTER_INFO__DEDICATED_VIDEO_MEMORY: {
                    dst.DedicatedVideoMemory = readTokValue<decltype(dst.DedicatedVideoMemory)>(*tok);
                } break;
                case TOK_FBQ_ADAPTER_INFO__SYSTEM_SHARED_MEMORY: {
                    dst.SystemSharedMemory = readTokValue<decltype(dst.SystemSharedMemory)>(*tok);
                } break;
                case TOK_FBQ_ADAPTER_INFO__SYSTEM_VIDEO_MEMORY: {
                    dst.SystemVideoMemory = readTokValue<decltype(dst.SystemVideoMemory)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_ADAPTER_INFO:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_ADAPTER_INFO__GFX_PLATFORM: {
                    const TokenHeader *tokGfxPlatform = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokGfxPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokGfxPlatform < tokGfxPlatformEnd) {
                        if (false == tokGfxPlatform->flags.flag4IsVariableLength) {
                            switch (tokGfxPlatform->id) {
                            default:
                                if (tokGfxPlatform->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                dst.GfxPlatform.eProductFamily = readTokValue<decltype(dst.GfxPlatform.eProductFamily)>(*tokGfxPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                dst.GfxPlatform.ePCHProductFamily = readTokValue<decltype(dst.GfxPlatform.ePCHProductFamily)>(*tokGfxPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                dst.GfxPlatform.eDisplayCoreFamily = readTokValue<decltype(dst.GfxPlatform.eDisplayCoreFamily)>(*tokGfxPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                dst.GfxPlatform.eRenderCoreFamily = readTokValue<decltype(dst.GfxPlatform.eRenderCoreFamily)>(*tokGfxPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                dst.GfxPlatform.ePlatformType = readTokValue<decltype(dst.GfxPlatform.ePlatformType)>(*tokGfxPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                dst.GfxPlatform.usDeviceID = readTokValue<decltype(dst.GfxPlatform.usDeviceID)>(*tokGfxPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                dst.GfxPlatform.usRevId = readTokValue<decltype(dst.GfxPlatform.usRevId)>(*tokGfxPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                dst.GfxPlatform.usDeviceID_PCH = readTokValue<decltype(dst.GfxPlatform.usDeviceID_PCH)>(*tokGfxPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                dst.GfxPlatform.usRevId_PCH = readTokValue<decltype(dst.GfxPlatform.usRevId_PCH)>(*tokGfxPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                dst.GfxPlatform.eGTType = readTokValue<decltype(dst.GfxPlatform.eGTType)>(*tokGfxPlatform);
                            } break;
                            };
                            tokGfxPlatform = tokGfxPlatform + 1 + tokGfxPlatform->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGfxPlatform);
                            switch (tokGfxPlatform->id) {
                            default:
                                if (tokGfxPlatform->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_PLATFORM_STR__S_RENDER_BLOCK_ID: {
                                const TokenHeader *tokSRenderBlockID = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSRenderBlockIDEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSRenderBlockID < tokSRenderBlockIDEnd) {
                                    if (false == tokSRenderBlockID->flags.flag4IsVariableLength) {
                                        switch (tokSRenderBlockID->id) {
                                        default:
                                            if (tokSRenderBlockID->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GFX_GMD_ID_DEF__ANONYMOUS7345__VALUE:
                                            dst.GfxPlatform.sRenderBlockID.Value = readTokValue<decltype(dst.GfxPlatform.sRenderBlockID.Value)>(*tokSRenderBlockID);
                                            break;
                                        };
                                        tokSRenderBlockID = tokSRenderBlockID + 1 + tokSRenderBlockID->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSRenderBlockID);
                                        tokSRenderBlockID = tokSRenderBlockID + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSRenderBlockID == tokSRenderBlockIDEnd);
                            } break;
                            };
                            tokGfxPlatform = tokGfxPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokGfxPlatform == tokGfxPlatformEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__SKU_TABLE: {
                    const TokenHeader *tokSkuTable = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSkuTableEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSkuTable < tokSkuTableEnd) {
                        if (false == tokSkuTable->flags.flag4IsVariableLength) {
                            switch (tokSkuTable->id) {
                            default:
                                if (tokSkuTable->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_ULT: {
                                dst.SkuTable.FtrULT = readTokValue<decltype(dst.SkuTable.FtrULT)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_LCIA: {
                                dst.SkuTable.FtrLCIA = readTokValue<decltype(dst.SkuTable.FtrLCIA)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSRING: {
                                dst.SkuTable.FtrCCSRing = readTokValue<decltype(dst.SkuTable.FtrCCSRing)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSNODE: {
                                dst.SkuTable.FtrCCSNode = readTokValue<decltype(dst.SkuTable.FtrCCSNode)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSMULTI_INSTANCE: {
                                dst.SkuTable.FtrCCSMultiInstance = readTokValue<decltype(dst.SkuTable.FtrCCSMultiInstance)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS11155__FTR_DISPLAY_DISABLED: {
                                dst.SkuTable.FtrDisplayDisabled = readTokValue<decltype(dst.SkuTable.FtrDisplayDisabled)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21584__FTR_POOLED_EU_ENABLED: {
                                dst.SkuTable.FtrPooledEuEnabled = readTokValue<decltype(dst.SkuTable.FtrPooledEuEnabled)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_MID_BATCH_PREEMPT: {
                                dst.SkuTable.FtrGpGpuMidBatchPreempt = readTokValue<decltype(dst.SkuTable.FtrGpGpuMidBatchPreempt)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_THREAD_GROUP_LEVEL_PREEMPT: {
                                dst.SkuTable.FtrGpGpuThreadGroupLevelPreempt = readTokValue<decltype(dst.SkuTable.FtrGpGpuThreadGroupLevelPreempt)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_MID_THREAD_LEVEL_PREEMPT: {
                                dst.SkuTable.FtrGpGpuMidThreadLevelPreempt = readTokValue<decltype(dst.SkuTable.FtrGpGpuMidThreadLevelPreempt)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PPGTT: {
                                dst.SkuTable.FtrPPGTT = readTokValue<decltype(dst.SkuTable.FtrPPGTT)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_IA32E_GFX_PTES: {
                                dst.SkuTable.FtrIA32eGfxPTEs = readTokValue<decltype(dst.SkuTable.FtrIA32eGfxPTEs)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_MEM_TYPE_MOCS_DEFER_PAT: {
                                dst.SkuTable.FtrMemTypeMocsDeferPAT = readTokValue<decltype(dst.SkuTable.FtrMemTypeMocsDeferPAT)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PML4SUPPORT: {
                                dst.SkuTable.FtrPml4Support = readTokValue<decltype(dst.SkuTable.FtrPml4Support)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_SVM: {
                                dst.SkuTable.FtrSVM = readTokValue<decltype(dst.SkuTable.FtrSVM)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TILE_MAPPED_RESOURCE: {
                                dst.SkuTable.FtrTileMappedResource = readTokValue<decltype(dst.SkuTable.FtrTileMappedResource)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TRANSLATION_TABLE: {
                                dst.SkuTable.FtrTranslationTable = readTokValue<decltype(dst.SkuTable.FtrTranslationTable)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_USER_MODE_TRANSLATION_TABLE: {
                                dst.SkuTable.FtrUserModeTranslationTable = readTokValue<decltype(dst.SkuTable.FtrUserModeTranslationTable)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_NULL_PAGES: {
                                dst.SkuTable.FtrNullPages = readTokValue<decltype(dst.SkuTable.FtrNullPages)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_L3IACOHERENCY: {
                                dst.SkuTable.FtrL3IACoherency = readTokValue<decltype(dst.SkuTable.FtrL3IACoherency)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_EDRAM: {
                                dst.SkuTable.FtrEDram = readTokValue<decltype(dst.SkuTable.FtrEDram)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LLCBYPASS: {
                                dst.SkuTable.FtrLLCBypass = readTokValue<decltype(dst.SkuTable.FtrLLCBypass)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CENTRAL_CACHE_POLICY: {
                                dst.SkuTable.FtrCentralCachePolicy = readTokValue<decltype(dst.SkuTable.FtrCentralCachePolicy)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2GPU_MMU: {
                                dst.SkuTable.FtrWddm2GpuMmu = readTokValue<decltype(dst.SkuTable.FtrWddm2GpuMmu)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2SVM: {
                                dst.SkuTable.FtrWddm2Svm = readTokValue<decltype(dst.SkuTable.FtrWddm2Svm)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_STANDARD_MIP_TAIL_FORMAT: {
                                dst.SkuTable.FtrStandardMipTailFormat = readTokValue<decltype(dst.SkuTable.FtrStandardMipTailFormat)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2_1_64KB_PAGES: {
                                dst.SkuTable.FtrWddm2_1_64kbPages = readTokValue<decltype(dst.SkuTable.FtrWddm2_1_64kbPages)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_E2ECOMPRESSION: {
                                dst.SkuTable.FtrE2ECompression = readTokValue<decltype(dst.SkuTable.FtrE2ECompression)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LINEAR_CCS: {
                                dst.SkuTable.FtrLinearCCS = readTokValue<decltype(dst.SkuTable.FtrLinearCCS)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LOCAL_MEMORY: {
                                dst.SkuTable.FtrLocalMemory = readTokValue<decltype(dst.SkuTable.FtrLocalMemory)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PPGTT64KBWALK_OPTIMIZATION: {
                                dst.SkuTable.FtrPpgtt64KBWalkOptimization = readTokValue<decltype(dst.SkuTable.FtrPpgtt64KBWalkOptimization)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TILE_Y: {
                                dst.SkuTable.FtrTileY = readTokValue<decltype(dst.SkuTable.FtrTileY)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_FLAT_PHYS_CCS: {
                                dst.SkuTable.FtrFlatPhysCCS = readTokValue<decltype(dst.SkuTable.FtrFlatPhysCCS)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_MULTI_TILE_ARCH: {
                                dst.SkuTable.FtrMultiTileArch = readTokValue<decltype(dst.SkuTable.FtrMultiTileArch)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LOCAL_MEMORY_ALLOWS4KB: {
                                dst.SkuTable.FtrLocalMemoryAllows4KB = readTokValue<decltype(dst.SkuTable.FtrLocalMemoryAllows4KB)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_DISPLAY_XTILING: {
                                dst.SkuTable.FtrDisplayXTiling = readTokValue<decltype(dst.SkuTable.FtrDisplayXTiling)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CAMERA_CAPTURE_CACHING: {
                                dst.SkuTable.FtrCameraCaptureCaching = readTokValue<decltype(dst.SkuTable.FtrCameraCaptureCaching)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_KMD_DAF: {
                                dst.SkuTable.FtrKmdDaf = readTokValue<decltype(dst.SkuTable.FtrKmdDaf)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_FRAME_BUFFER_LLC: {
                                dst.SkuTable.FtrFrameBufferLLC = readTokValue<decltype(dst.SkuTable.FtrFrameBufferLLC)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_DRIVER_FLR: {
                                dst.SkuTable.FtrDriverFLR = readTokValue<decltype(dst.SkuTable.FtrDriverFLR)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC_LDR2D: {
                                dst.SkuTable.FtrAstcLdr2D = readTokValue<decltype(dst.SkuTable.FtrAstcLdr2D)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC_HDR2D: {
                                dst.SkuTable.FtrAstcHdr2D = readTokValue<decltype(dst.SkuTable.FtrAstcHdr2D)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC3D: {
                                dst.SkuTable.FtrAstc3D = readTokValue<decltype(dst.SkuTable.FtrAstc3D)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_FBC: {
                                dst.SkuTable.FtrFbc = readTokValue<decltype(dst.SkuTable.FtrFbc)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS54736__FTR_REND_COMP: {
                                dst.SkuTable.FtrRendComp = readTokValue<decltype(dst.SkuTable.FtrRendComp)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS54736__FTR_DISPLAY_YTILING: {
                                dst.SkuTable.FtrDisplayYTiling = readTokValue<decltype(dst.SkuTable.FtrDisplayYTiling)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_S3D: {
                                dst.SkuTable.FtrS3D = readTokValue<decltype(dst.SkuTable.FtrS3D)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_DISPLAY_ENGINE_S3D: {
                                dst.SkuTable.FtrDisplayEngineS3d = readTokValue<decltype(dst.SkuTable.FtrDisplayEngineS3d)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS89755__FTR_VGT: {
                                dst.SkuTable.FtrVgt = readTokValue<decltype(dst.SkuTable.FtrVgt)>(*tokSkuTable);
                            } break;
                            case TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS91822__FTR_ASSIGNED_GPU_TILE: {
                                dst.SkuTable.FtrAssignedGpuTile = readTokValue<decltype(dst.SkuTable.FtrAssignedGpuTile)>(*tokSkuTable);
                            } break;
                            };
                            tokSkuTable = tokSkuTable + 1 + tokSkuTable->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSkuTable);
                            if (tokSkuTable->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokSkuTable = tokSkuTable + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSkuTable == tokSkuTableEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__WA_TABLE: {
                    const TokenHeader *tokWaTable = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokWaTableEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokWaTable < tokWaTableEnd) {
                        if (false == tokWaTable->flags.flag4IsVariableLength) {
                            switch (tokWaTable->id) {
                            default:
                                if (tokWaTable->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_WA_TABLE__WA_ALIGN_INDEX_BUFFER: {
                                dst.WaTable.WaAlignIndexBuffer = readTokValue<decltype(dst.WaTable.WaAlignIndexBuffer)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_SEND_MIFLUSHBEFORE_VFE: {
                                dst.WaTable.WaSendMIFLUSHBeforeVFE = readTokValue<decltype(dst.WaTable.WaSendMIFLUSHBeforeVFE)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DISABLE_PER_CTXT_PREEMPTION_GRANULARITY_CONTROL: {
                                dst.WaTable.WaDisablePerCtxtPreemptionGranularityControl = readTokValue<decltype(dst.WaTable.WaDisablePerCtxtPreemptionGranularityControl)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DISABLE_LSQCROPERFFOR_OCL: {
                                dst.WaTable.WaDisableLSQCROPERFforOCL = readTokValue<decltype(dst.WaTable.WaDisableLSQCROPERFforOCL)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_VALIGN2FOR96BPP_FORMATS: {
                                dst.WaTable.WaValign2For96bppFormats = readTokValue<decltype(dst.WaTable.WaValign2For96bppFormats)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_VALIGN2FOR_R8G8B8UINTFORMAT: {
                                dst.WaTable.WaValign2ForR8G8B8UINTFormat = readTokValue<decltype(dst.WaTable.WaValign2ForR8G8B8UINTFormat)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_CSRUNCACHABLE: {
                                dst.WaTable.WaCSRUncachable = readTokValue<decltype(dst.WaTable.WaCSRUncachable)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DISABLE_FUSED_THREAD_SCHEDULING: {
                                dst.WaTable.WaDisableFusedThreadScheduling = readTokValue<decltype(dst.WaTable.WaDisableFusedThreadScheduling)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_MODIFY_VFESTATE_AFTER_GPGPUPREEMPTION: {
                                dst.WaTable.WaModifyVFEStateAfterGPGPUPreemption = readTokValue<decltype(dst.WaTable.WaModifyVFEStateAfterGPGPUPreemption)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_CURSOR16K: {
                                dst.WaTable.WaCursor16K = readTokValue<decltype(dst.WaTable.WaCursor16K)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA8K_ALIGNFOR_ASYNC_FLIP: {
                                dst.WaTable.Wa8kAlignforAsyncFlip = readTokValue<decltype(dst.WaTable.Wa8kAlignforAsyncFlip)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA29BIT_DISPLAY_ADDR_LIMIT: {
                                dst.WaTable.Wa29BitDisplayAddrLimit = readTokValue<decltype(dst.WaTable.Wa29BitDisplayAddrLimit)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_ALIGN_CONTEXT_IMAGE: {
                                dst.WaTable.WaAlignContextImage = readTokValue<decltype(dst.WaTable.WaAlignContextImage)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_FORCE_GLOBAL_GTT: {
                                dst.WaTable.WaForceGlobalGTT = readTokValue<decltype(dst.WaTable.WaForceGlobalGTT)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_REPORT_PERF_COUNT_FORCE_GLOBAL_GTT: {
                                dst.WaTable.WaReportPerfCountForceGlobalGTT = readTokValue<decltype(dst.WaTable.WaReportPerfCountForceGlobalGTT)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_OA_ADDRESS_TRANSLATION: {
                                dst.WaTable.WaOaAddressTranslation = readTokValue<decltype(dst.WaTable.WaOaAddressTranslation)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA2ROW_VERTICAL_ALIGNMENT: {
                                dst.WaTable.Wa2RowVerticalAlignment = readTokValue<decltype(dst.WaTable.Wa2RowVerticalAlignment)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_PPGTT_ALIAS_GLOBAL_GTT_SPACE: {
                                dst.WaTable.WaPpgttAliasGlobalGttSpace = readTokValue<decltype(dst.WaTable.WaPpgttAliasGlobalGttSpace)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_CLEAR_FENCE_REGISTERS_AT_DRIVER_INIT: {
                                dst.WaTable.WaClearFenceRegistersAtDriverInit = readTokValue<decltype(dst.WaTable.WaClearFenceRegistersAtDriverInit)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_RESTRICT_PITCH128KB: {
                                dst.WaTable.WaRestrictPitch128KB = readTokValue<decltype(dst.WaTable.WaRestrictPitch128KB)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_AVOID_LLC: {
                                dst.WaTable.WaAvoidLLC = readTokValue<decltype(dst.WaTable.WaAvoidLLC)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_AVOID_L3: {
                                dst.WaTable.WaAvoidL3 = readTokValue<decltype(dst.WaTable.WaAvoidL3)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA16TILE_FENCES_ONLY: {
                                dst.WaTable.Wa16TileFencesOnly = readTokValue<decltype(dst.WaTable.Wa16TileFencesOnly)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA16MBOABUFFER_ALIGNMENT: {
                                dst.WaTable.Wa16MBOABufferAlignment = readTokValue<decltype(dst.WaTable.Wa16MBOABufferAlignment)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_TRANSLATION_TABLE_UNAVAILABLE: {
                                dst.WaTable.WaTranslationTableUnavailable = readTokValue<decltype(dst.WaTable.WaTranslationTableUnavailable)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_NO_MINIMIZED_TRIVIAL_SURFACE_PADDING: {
                                dst.WaTable.WaNoMinimizedTrivialSurfacePadding = readTokValue<decltype(dst.WaTable.WaNoMinimizedTrivialSurfacePadding)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_NO_BUFFER_SAMPLER_PADDING: {
                                dst.WaTable.WaNoBufferSamplerPadding = readTokValue<decltype(dst.WaTable.WaNoBufferSamplerPadding)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_SURFACE_STATE_PLANAR_YOFFSET_ALIGN_BY2: {
                                dst.WaTable.WaSurfaceStatePlanarYOffsetAlignBy2 = readTokValue<decltype(dst.WaTable.WaSurfaceStatePlanarYOffsetAlignBy2)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_GTT_CACHING_OFF_BY_DEFAULT: {
                                dst.WaTable.WaGttCachingOffByDefault = readTokValue<decltype(dst.WaTable.WaGttCachingOffByDefault)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_TOUCH_ALL_SVM_MEMORY: {
                                dst.WaTable.WaTouchAllSvmMemory = readTokValue<decltype(dst.WaTable.WaTouchAllSvmMemory)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_IOBADDRESS_MUST_BE_VALID_IN_HW_CONTEXT: {
                                dst.WaTable.WaIOBAddressMustBeValidInHwContext = readTokValue<decltype(dst.WaTable.WaIOBAddressMustBeValidInHwContext)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_FLUSH_TLB_AFTER_CPU_GGTT_WRITES: {
                                dst.WaTable.WaFlushTlbAfterCpuGgttWrites = readTokValue<decltype(dst.WaTable.WaFlushTlbAfterCpuGgttWrites)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_MSAA8X_TILE_YDEPTH_PITCH_ALIGNMENT: {
                                dst.WaTable.WaMsaa8xTileYDepthPitchAlignment = readTokValue<decltype(dst.WaTable.WaMsaa8xTileYDepthPitchAlignment)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DISABLE_NULL_PAGE_AS_DUMMY: {
                                dst.WaTable.WaDisableNullPageAsDummy = readTokValue<decltype(dst.WaTable.WaDisableNullPageAsDummy)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_USE_VALIGN16ON_TILE_XYBPP816: {
                                dst.WaTable.WaUseVAlign16OnTileXYBpp816 = readTokValue<decltype(dst.WaTable.WaUseVAlign16OnTileXYBpp816)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_GTT_PAT0: {
                                dst.WaTable.WaGttPat0 = readTokValue<decltype(dst.WaTable.WaGttPat0)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_GTT_PAT0WB: {
                                dst.WaTable.WaGttPat0WB = readTokValue<decltype(dst.WaTable.WaGttPat0WB)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_MEM_TYPE_IS_MAX_OF_PAT_AND_MOCS: {
                                dst.WaTable.WaMemTypeIsMaxOfPatAndMocs = readTokValue<decltype(dst.WaTable.WaMemTypeIsMaxOfPatAndMocs)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_GTT_PAT0GTT_WB_OVER_OS_IOMMU_ELLC_ONLY: {
                                dst.WaTable.WaGttPat0GttWbOverOsIommuEllcOnly = readTokValue<decltype(dst.WaTable.WaGttPat0GttWbOverOsIommuEllcOnly)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_ADD_DUMMY_PAGE_FOR_DISPLAY_PREFETCH: {
                                dst.WaTable.WaAddDummyPageForDisplayPrefetch = readTokValue<decltype(dst.WaTable.WaAddDummyPageForDisplayPrefetch)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_LLCCACHING_UNSUPPORTED: {
                                dst.WaTable.WaLLCCachingUnsupported = readTokValue<decltype(dst.WaTable.WaLLCCachingUnsupported)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DOUBLE_FAST_CLEAR_WIDTH_ALIGNMENT: {
                                dst.WaTable.WaDoubleFastClearWidthAlignment = readTokValue<decltype(dst.WaTable.WaDoubleFastClearWidthAlignment)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_COMPRESSED_RESOURCE_REQUIRES_CONST_VA21: {
                                dst.WaTable.WaCompressedResourceRequiresConstVA21 = readTokValue<decltype(dst.WaTable.WaCompressedResourceRequiresConstVA21)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DISREGARD_PLATFORM_CHECKS: {
                                dst.WaTable.WaDisregardPlatformChecks = readTokValue<decltype(dst.WaTable.WaDisregardPlatformChecks)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_LOSSLESS_COMPRESSION_SURFACE_STRIDE: {
                                dst.WaTable.WaLosslessCompressionSurfaceStride = readTokValue<decltype(dst.WaTable.WaLosslessCompressionSurfaceStride)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_FBC_LINEAR_SURFACE_STRIDE: {
                                dst.WaTable.WaFbcLinearSurfaceStride = readTokValue<decltype(dst.WaTable.WaFbcLinearSurfaceStride)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA4K_ALIGN_UVOFFSET_NV12LINEAR_SURFACE: {
                                dst.WaTable.Wa4kAlignUVOffsetNV12LinearSurface = readTokValue<decltype(dst.WaTable.Wa4kAlignUVOffsetNV12LinearSurface)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_ASTC_CORRUPTION_FOR_ODD_COMPRESSED_BLOCK_SIZE_X: {
                                dst.WaTable.WaAstcCorruptionForOddCompressedBlockSizeX = readTokValue<decltype(dst.WaTable.WaAstcCorruptionForOddCompressedBlockSizeX)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_AUX_TABLE16KGRANULAR: {
                                dst.WaTable.WaAuxTable16KGranular = readTokValue<decltype(dst.WaTable.WaAuxTable16KGranular)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_ENCRYPTED_EDRAM_ONLY_PARTIALS: {
                                dst.WaTable.WaEncryptedEdramOnlyPartials = readTokValue<decltype(dst.WaTable.WaEncryptedEdramOnlyPartials)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_DISABLE_EDRAM_FOR_DISPLAY_RT: {
                                dst.WaTable.WaDisableEdramForDisplayRT = readTokValue<decltype(dst.WaTable.WaDisableEdramForDisplayRT)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_LIMIT128BMEDIA_COMPR: {
                                dst.WaTable.WaLimit128BMediaCompr = readTokValue<decltype(dst.WaTable.WaLimit128BMediaCompr)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_UNTYPED_BUFFER_COMPRESSION: {
                                dst.WaTable.WaUntypedBufferCompression = readTokValue<decltype(dst.WaTable.WaUntypedBufferCompression)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_SAMPLER_CACHE_FLUSH_BETWEEN_REDESCRIBED_SURFACE_READS: {
                                dst.WaTable.WaSamplerCacheFlushBetweenRedescribedSurfaceReads = readTokValue<decltype(dst.WaTable.WaSamplerCacheFlushBetweenRedescribedSurfaceReads)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA_ALIGN_YUVRESOURCE_TO_LCU: {
                                dst.WaTable.WaAlignYUVResourceToLCU = readTokValue<decltype(dst.WaTable.WaAlignYUVResourceToLCU)>(*tokWaTable);
                            } break;
                            case TOK_FBD_WA_TABLE__WA32BPP_TILE_Y2DCOLOR_NO_HALIGN4: {
                                dst.WaTable.Wa32bppTileY2DColorNoHAlign4 = readTokValue<decltype(dst.WaTable.Wa32bppTileY2DColorNoHAlign4)>(*tokWaTable);
                            } break;
                            };
                            tokWaTable = tokWaTable + 1 + tokWaTable->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWaTable);
                            if (tokWaTable->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokWaTable = tokWaTable + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokWaTable == tokWaTableEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__OUTPUT_FRAME_RATE: {
                    const TokenHeader *tokOutputFrameRate = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokOutputFrameRateEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokOutputFrameRate < tokOutputFrameRateEnd) {
                        if (false == tokOutputFrameRate->flags.flag4IsVariableLength) {
                            switch (tokOutputFrameRate->id) {
                            default:
                                if (tokOutputFrameRate->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_FRAME_RATE__UI_NUMERATOR: {
                                dst.OutputFrameRate.uiNumerator = readTokValue<decltype(dst.OutputFrameRate.uiNumerator)>(*tokOutputFrameRate);
                            } break;
                            case TOK_FBD_FRAME_RATE__UI_DENOMINATOR: {
                                dst.OutputFrameRate.uiDenominator = readTokValue<decltype(dst.OutputFrameRate.uiDenominator)>(*tokOutputFrameRate);
                            } break;
                            };
                            tokOutputFrameRate = tokOutputFrameRate + 1 + tokOutputFrameRate->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOutputFrameRate);
                            if (tokOutputFrameRate->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokOutputFrameRate = tokOutputFrameRate + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokOutputFrameRate == tokOutputFrameRateEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__INPUT_FRAME_RATE: {
                    const TokenHeader *tokInputFrameRate = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokInputFrameRateEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokInputFrameRate < tokInputFrameRateEnd) {
                        if (false == tokInputFrameRate->flags.flag4IsVariableLength) {
                            switch (tokInputFrameRate->id) {
                            default:
                                if (tokInputFrameRate->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_FRAME_RATE__UI_NUMERATOR: {
                                dst.InputFrameRate.uiNumerator = readTokValue<decltype(dst.InputFrameRate.uiNumerator)>(*tokInputFrameRate);
                            } break;
                            case TOK_FBD_FRAME_RATE__UI_DENOMINATOR: {
                                dst.InputFrameRate.uiDenominator = readTokValue<decltype(dst.InputFrameRate.uiDenominator)>(*tokInputFrameRate);
                            } break;
                            };
                            tokInputFrameRate = tokInputFrameRate + 1 + tokInputFrameRate->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInputFrameRate);
                            if (tokInputFrameRate->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokInputFrameRate = tokInputFrameRate + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokInputFrameRate == tokInputFrameRateEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__CAPS: {
                    const TokenHeader *tokCaps = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokCapsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokCaps < tokCapsEnd) {
                        if (false == tokCaps->flags.flag4IsVariableLength) {
                            switch (tokCaps->id) {
                            default:
                                if (tokCaps->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_KMD_CAPS_INFO__GAMMA_RGB256X3X16: {
                                dst.Caps.Gamma_Rgb256x3x16 = readTokValue<decltype(dst.Caps.Gamma_Rgb256x3x16)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_CAPS_INFO__GDIACCELERATION: {
                                dst.Caps.GDIAcceleration = readTokValue<decltype(dst.Caps.GDIAcceleration)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_CAPS_INFO__OS_MANAGED_HW_CONTEXT: {
                                dst.Caps.OsManagedHwContext = readTokValue<decltype(dst.Caps.OsManagedHwContext)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_CAPS_INFO__GRAPHICS_PREEMPTION_GRANULARITY: {
                                dst.Caps.GraphicsPreemptionGranularity = readTokValue<decltype(dst.Caps.GraphicsPreemptionGranularity)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_CAPS_INFO__COMPUTE_PREEMPTION_GRANULARITY: {
                                dst.Caps.ComputePreemptionGranularity = readTokValue<decltype(dst.Caps.ComputePreemptionGranularity)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_CAPS_INFO__INSTRUMENTATION_IS_ENABLED: {
                                dst.Caps.InstrumentationIsEnabled = readTokValue<decltype(dst.Caps.InstrumentationIsEnabled)>(*tokCaps);
                            } break;
                            case TOK_FBD_KMD_CAPS_INFO__DRIVER_STORE_ENABLED: {
                                dst.Caps.DriverStoreEnabled = readTokValue<decltype(dst.Caps.DriverStoreEnabled)>(*tokCaps);
                            } break;
                            };
                            tokCaps = tokCaps + 1 + tokCaps->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCaps);
                            if (tokCaps->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokCaps = tokCaps + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokCaps == tokCapsEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__OVERLAY_CAPS: {
                    const TokenHeader *tokOverlayCaps = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokOverlayCapsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokOverlayCaps < tokOverlayCapsEnd) {
                        if (false == tokOverlayCaps->flags.flag4IsVariableLength) {
                            switch (tokOverlayCaps->id) {
                            default:
                                if (tokOverlayCaps->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__CAPS_VALUE: {
                                dst.OverlayCaps.CapsValue = readTokValue<decltype(dst.OverlayCaps.CapsValue)>(*tokOverlayCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_OVERLAY_DISPLAY_WIDTH: {
                                dst.OverlayCaps.MaxOverlayDisplayWidth = readTokValue<decltype(dst.OverlayCaps.MaxOverlayDisplayWidth)>(*tokOverlayCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_OVERLAY_DISPLAY_HEIGHT: {
                                dst.OverlayCaps.MaxOverlayDisplayHeight = readTokValue<decltype(dst.OverlayCaps.MaxOverlayDisplayHeight)>(*tokOverlayCaps);
                            } break;
                            case TOK_FBC_KMD_OVERLAY_CAPS_INFO__HWSCALER_EXISTS: {
                                dst.OverlayCaps.HWScalerExists = readTokValue<decltype(dst.OverlayCaps.HWScalerExists)>(*tokOverlayCaps);
                            } break;
                            case TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_HWSCALER_STRIDE: {
                                dst.OverlayCaps.MaxHWScalerStride = readTokValue<decltype(dst.OverlayCaps.MaxHWScalerStride)>(*tokOverlayCaps);
                            } break;
                            };
                            tokOverlayCaps = tokOverlayCaps + 1 + tokOverlayCaps->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOverlayCaps);
                            switch (tokOverlayCaps->id) {
                            default:
                                if (tokOverlayCaps->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__CAPS: {
                                const TokenHeader *tokCaps = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokCapsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokCaps < tokCapsEnd) {
                                    if (false == tokCaps->flags.flag4IsVariableLength) {
                                        switch (tokCaps->id) {
                                        default:
                                            if (tokCaps->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__FULL_RANGE_RGB: {
                                            dst.OverlayCaps.Caps.FullRangeRGB = readTokValue<decltype(dst.OverlayCaps.Caps.FullRangeRGB)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__LIMITED_RANGE_RGB: {
                                            dst.OverlayCaps.Caps.LimitedRangeRGB = readTokValue<decltype(dst.OverlayCaps.Caps.LimitedRangeRGB)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT601: {
                                            dst.OverlayCaps.Caps.YCbCr_BT601 = readTokValue<decltype(dst.OverlayCaps.Caps.YCbCr_BT601)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT709: {
                                            dst.OverlayCaps.Caps.YCbCr_BT709 = readTokValue<decltype(dst.OverlayCaps.Caps.YCbCr_BT709)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT601_XV_YCC: {
                                            dst.OverlayCaps.Caps.YCbCr_BT601_xvYCC = readTokValue<decltype(dst.OverlayCaps.Caps.YCbCr_BT601_xvYCC)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT709_XV_YCC: {
                                            dst.OverlayCaps.Caps.YCbCr_BT709_xvYCC = readTokValue<decltype(dst.OverlayCaps.Caps.YCbCr_BT709_xvYCC)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__STRETCH_X: {
                                            dst.OverlayCaps.Caps.StretchX = readTokValue<decltype(dst.OverlayCaps.Caps.StretchX)>(*tokCaps);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__STRETCH_Y: {
                                            dst.OverlayCaps.Caps.StretchY = readTokValue<decltype(dst.OverlayCaps.Caps.StretchY)>(*tokCaps);
                                        } break;
                                        };
                                        tokCaps = tokCaps + 1 + tokCaps->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCaps);
                                        if (tokCaps->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokCaps = tokCaps + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokCaps == tokCapsEnd);
                            } break;
                            case TOK_FS_KMD_OVERLAY_CAPS_INFO__OVOVERRIDE: {
                                const TokenHeader *tokOVOverride = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokOVOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokOVOverride < tokOVOverrideEnd) {
                                    if (false == tokOVOverride->flags.flag4IsVariableLength) {
                                        switch (tokOVOverride->id) {
                                        default:
                                            if (tokOVOverride->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_KMD_OVERLAY_OVERRIDE__OVERRIDE_OVERLAY_CAPS: {
                                            dst.OverlayCaps.OVOverride.OverrideOverlayCaps = readTokValue<decltype(dst.OverlayCaps.OVOverride.OverrideOverlayCaps)>(*tokOVOverride);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_OVERRIDE__RGBOVERLAY: {
                                            dst.OverlayCaps.OVOverride.RGBOverlay = readTokValue<decltype(dst.OverlayCaps.OVOverride.RGBOverlay)>(*tokOVOverride);
                                        } break;
                                        case TOK_FBD_KMD_OVERLAY_OVERRIDE__YUY2OVERLAY: {
                                            dst.OverlayCaps.OVOverride.YUY2Overlay = readTokValue<decltype(dst.OverlayCaps.OVOverride.YUY2Overlay)>(*tokOVOverride);
                                        } break;
                                        };
                                        tokOVOverride = tokOVOverride + 1 + tokOVOverride->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOVOverride);
                                        if (tokOVOverride->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokOVOverride = tokOVOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokOVOverride == tokOVOverrideEnd);
                            } break;
                            };
                            tokOverlayCaps = tokOverlayCaps + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokOverlayCaps == tokOverlayCapsEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__SYSTEM_INFO: {
                    const TokenHeader *tokSystemInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSystemInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSystemInfo < tokSystemInfoEnd) {
                        if (false == tokSystemInfo->flags.flag4IsVariableLength) {
                            switch (tokSystemInfo->id) {
                            default:
                                if (tokSystemInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GT_SYSTEM_INFO__EUCOUNT: {
                                dst.SystemInfo.EUCount = readTokValue<decltype(dst.SystemInfo.EUCount)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__THREAD_COUNT: {
                                dst.SystemInfo.ThreadCount = readTokValue<decltype(dst.SystemInfo.ThreadCount)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__SLICE_COUNT: {
                                dst.SystemInfo.SliceCount = readTokValue<decltype(dst.SystemInfo.SliceCount)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__SUB_SLICE_COUNT: {
                                dst.SystemInfo.SubSliceCount = readTokValue<decltype(dst.SystemInfo.SubSliceCount)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__DUAL_SUB_SLICE_COUNT: {
                                dst.SystemInfo.DualSubSliceCount = readTokValue<decltype(dst.SystemInfo.DualSubSliceCount)>(*tokSystemInfo);
                            } break;
                            case TOK_FBQ_GT_SYSTEM_INFO__L3CACHE_SIZE_IN_KB: {
                                dst.SystemInfo.L3CacheSizeInKb = readTokValue<decltype(dst.SystemInfo.L3CacheSizeInKb)>(*tokSystemInfo);
                            } break;
                            case TOK_FBQ_GT_SYSTEM_INFO__LLCCACHE_SIZE_IN_KB: {
                                dst.SystemInfo.LLCCacheSizeInKb = readTokValue<decltype(dst.SystemInfo.LLCCacheSizeInKb)>(*tokSystemInfo);
                            } break;
                            case TOK_FBQ_GT_SYSTEM_INFO__EDRAM_SIZE_IN_KB: {
                                dst.SystemInfo.EdramSizeInKb = readTokValue<decltype(dst.SystemInfo.EdramSizeInKb)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__L3BANK_COUNT: {
                                dst.SystemInfo.L3BankCount = readTokValue<decltype(dst.SystemInfo.L3BankCount)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__MAX_FILL_RATE: {
                                dst.SystemInfo.MaxFillRate = readTokValue<decltype(dst.SystemInfo.MaxFillRate)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__EU_COUNT_PER_POOL_MAX: {
                                dst.SystemInfo.EuCountPerPoolMax = readTokValue<decltype(dst.SystemInfo.EuCountPerPoolMax)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__EU_COUNT_PER_POOL_MIN: {
                                dst.SystemInfo.EuCountPerPoolMin = readTokValue<decltype(dst.SystemInfo.EuCountPerPoolMin)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__TOTAL_VS_THREADS: {
                                dst.SystemInfo.TotalVsThreads = readTokValue<decltype(dst.SystemInfo.TotalVsThreads)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__TOTAL_HS_THREADS: {
                                dst.SystemInfo.TotalHsThreads = readTokValue<decltype(dst.SystemInfo.TotalHsThreads)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__TOTAL_DS_THREADS: {
                                dst.SystemInfo.TotalDsThreads = readTokValue<decltype(dst.SystemInfo.TotalDsThreads)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__TOTAL_GS_THREADS: {
                                dst.SystemInfo.TotalGsThreads = readTokValue<decltype(dst.SystemInfo.TotalGsThreads)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__TOTAL_PS_THREADS_WINDOWER_RANGE: {
                                dst.SystemInfo.TotalPsThreadsWindowerRange = readTokValue<decltype(dst.SystemInfo.TotalPsThreadsWindowerRange)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__TOTAL_VS_THREADS_POCS: {
                                dst.SystemInfo.TotalVsThreads_Pocs = readTokValue<decltype(dst.SystemInfo.TotalVsThreads_Pocs)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__CSR_SIZE_IN_MB: {
                                dst.SystemInfo.CsrSizeInMb = readTokValue<decltype(dst.SystemInfo.CsrSizeInMb)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__MAX_EU_PER_SUB_SLICE: {
                                dst.SystemInfo.MaxEuPerSubSlice = readTokValue<decltype(dst.SystemInfo.MaxEuPerSubSlice)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__MAX_SLICES_SUPPORTED: {
                                dst.SystemInfo.MaxSlicesSupported = readTokValue<decltype(dst.SystemInfo.MaxSlicesSupported)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__MAX_SUB_SLICES_SUPPORTED: {
                                dst.SystemInfo.MaxSubSlicesSupported = readTokValue<decltype(dst.SystemInfo.MaxSubSlicesSupported)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__MAX_DUAL_SUB_SLICES_SUPPORTED: {
                                dst.SystemInfo.MaxDualSubSlicesSupported = readTokValue<decltype(dst.SystemInfo.MaxDualSubSlicesSupported)>(*tokSystemInfo);
                            } break;
                            case TOK_FBB_GT_SYSTEM_INFO__IS_L3HASH_MODE_ENABLED: {
                                dst.SystemInfo.IsL3HashModeEnabled = readTokValue<decltype(dst.SystemInfo.IsL3HashModeEnabled)>(*tokSystemInfo);
                            } break;
                            case TOK_FBB_GT_SYSTEM_INFO__IS_DYNAMICALLY_POPULATED: {
                                dst.SystemInfo.IsDynamicallyPopulated = readTokValue<decltype(dst.SystemInfo.IsDynamicallyPopulated)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__RESERVED_CCSWAYS: {
                                dst.SystemInfo.ReservedCCSWays = readTokValue<decltype(dst.SystemInfo.ReservedCCSWays)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__NUM_THREADS_PER_EU: {
                                dst.SystemInfo.NumThreadsPerEu = readTokValue<decltype(dst.SystemInfo.NumThreadsPerEu)>(*tokSystemInfo);
                            } break;
                            case TOK_FBD_GT_SYSTEM_INFO__MAX_VECS: {
                                dst.SystemInfo.MaxVECS = readTokValue<decltype(dst.SystemInfo.MaxVECS)>(*tokSystemInfo);
                            } break;
                            };
                            tokSystemInfo = tokSystemInfo + 1 + tokSystemInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSystemInfo);
                            switch (tokSystemInfo->id) {
                            default:
                                if (tokSystemInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GT_SYSTEM_INFO__SLICE_INFO: {
                                uint32_t arrayElementIdSliceInfo = varLen->arrayElementId;
                                const TokenHeader *tokSliceInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSliceInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                static constexpr auto maxDstSlicesInfo = sizeof(dst.SystemInfo.SliceInfo) / sizeof(dst.SystemInfo.SliceInfo[0]);
                                if (arrayElementIdSliceInfo >= maxDstSlicesInfo) {
                                    tokSliceInfo = tokSliceInfoEnd;
                                }
                                while (tokSliceInfo < tokSliceInfoEnd) {
                                    if (false == tokSliceInfo->flags.flag4IsVariableLength) {
                                        switch (tokSliceInfo->id) {
                                        default:
                                            if (tokSliceInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBB_GT_SLICE_INFO__ENABLED: {
                                            dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].Enabled = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].Enabled)>(*tokSliceInfo);
                                        } break;
                                        case TOK_FBD_GT_SLICE_INFO__SUB_SLICE_ENABLED_COUNT: {
                                            dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceEnabledCount = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceEnabledCount)>(*tokSliceInfo);
                                        } break;
                                        case TOK_FBD_GT_SLICE_INFO__DUAL_SUB_SLICE_ENABLED_COUNT: {
                                            dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DualSubSliceEnabledCount = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DualSubSliceEnabledCount)>(*tokSliceInfo);
                                        } break;
                                        };
                                        tokSliceInfo = tokSliceInfo + 1 + tokSliceInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSliceInfo);
                                        switch (tokSliceInfo->id) {
                                        default:
                                            if (tokSliceInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_SLICE_INFO__SUB_SLICE_INFO: {
                                            uint32_t arrayElementIdSubSliceInfo = varLen->arrayElementId;
                                            const TokenHeader *tokSubSliceInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSubSliceInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSubSliceInfo < tokSubSliceInfoEnd) {
                                                if (false == tokSubSliceInfo->flags.flag4IsVariableLength) {
                                                    switch (tokSubSliceInfo->id) {
                                                    default:
                                                        if (tokSubSliceInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                                        dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].Enabled = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].Enabled)>(*tokSubSliceInfo);
                                                    } break;
                                                    case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                                        dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledCount = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledCount)>(*tokSubSliceInfo);
                                                    } break;
                                                    case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                                        dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledMask = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].SubSliceInfo[arrayElementIdSubSliceInfo].EuEnabledMask)>(*tokSubSliceInfo);
                                                    } break;
                                                    };
                                                    tokSubSliceInfo = tokSubSliceInfo + 1 + tokSubSliceInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSliceInfo);
                                                    if (tokSubSliceInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokSubSliceInfo = tokSubSliceInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSubSliceInfo == tokSubSliceInfoEnd);
                                        } break;
                                        case TOK_FS_GT_SLICE_INFO__DSSINFO: {
                                            uint32_t arrayElementIdDSSInfo = varLen->arrayElementId;
                                            const TokenHeader *tokDSSInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokDSSInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokDSSInfo < tokDSSInfoEnd) {
                                                if (false == tokDSSInfo->flags.flag4IsVariableLength) {
                                                    switch (tokDSSInfo->id) {
                                                    default:
                                                        if (tokDSSInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBB_GT_DUALSUBSLICE_INFO__ENABLED: {
                                                        dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].Enabled = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].Enabled)>(*tokDSSInfo);
                                                    } break;
                                                    };
                                                    tokDSSInfo = tokDSSInfo + 1 + tokDSSInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokDSSInfo);
                                                    switch (tokDSSInfo->id) {
                                                    default:
                                                        if (tokDSSInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GT_DUALSUBSLICE_INFO__SUB_SLICE: {
                                                        uint32_t arrayElementIdSubSlice = varLen->arrayElementId;
                                                        const TokenHeader *tokSubSlice = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokSubSliceEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokSubSlice < tokSubSliceEnd) {
                                                            if (false == tokSubSlice->flags.flag4IsVariableLength) {
                                                                switch (tokSubSlice->id) {
                                                                default:
                                                                    if (tokSubSlice->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBB_GT_SUBSLICE_INFO__ENABLED: {
                                                                    dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].Enabled = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].Enabled)>(*tokSubSlice);
                                                                } break;
                                                                case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT: {
                                                                    dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledCount = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledCount)>(*tokSubSlice);
                                                                } break;
                                                                case TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK: {
                                                                    dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledMask = readTokValue<decltype(dst.SystemInfo.SliceInfo[arrayElementIdSliceInfo].DSSInfo[arrayElementIdDSSInfo].SubSlice[arrayElementIdSubSlice].EuEnabledMask)>(*tokSubSlice);
                                                                } break;
                                                                };
                                                                tokSubSlice = tokSubSlice + 1 + tokSubSlice->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSubSlice);
                                                                if (tokSubSlice->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokSubSlice = tokSubSlice + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokSubSlice == tokSubSliceEnd);
                                                    } break;
                                                    };
                                                    tokDSSInfo = tokDSSInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokDSSInfo == tokDSSInfoEnd);
                                        } break;
                                        };
                                        tokSliceInfo = tokSliceInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSliceInfo == tokSliceInfoEnd);
                            } break;
                            case TOK_FS_GT_SYSTEM_INFO__SQIDI_INFO: {
                                const TokenHeader *tokSqidiInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSqidiInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSqidiInfo < tokSqidiInfoEnd) {
                                    if (false == tokSqidiInfo->flags.flag4IsVariableLength) {
                                        switch (tokSqidiInfo->id) {
                                        default:
                                            if (tokSqidiInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_SQIDI_INFO__NUMBEROF_SQIDI: {
                                            dst.SystemInfo.SqidiInfo.NumberofSQIDI = readTokValue<decltype(dst.SystemInfo.SqidiInfo.NumberofSQIDI)>(*tokSqidiInfo);
                                        } break;
                                        case TOK_FBD_GT_SQIDI_INFO__NUMBEROF_DOORBELL_PER_SQIDI: {
                                            dst.SystemInfo.SqidiInfo.NumberofDoorbellPerSQIDI = readTokValue<decltype(dst.SystemInfo.SqidiInfo.NumberofDoorbellPerSQIDI)>(*tokSqidiInfo);
                                        } break;
                                        };
                                        tokSqidiInfo = tokSqidiInfo + 1 + tokSqidiInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSqidiInfo);
                                        if (tokSqidiInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSqidiInfo = tokSqidiInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSqidiInfo == tokSqidiInfoEnd);
                            } break;
                            case TOK_FS_GT_SYSTEM_INFO__CCSINFO: {
                                const TokenHeader *tokCCSInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokCCSInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokCCSInfo < tokCCSInfoEnd) {
                                    if (false == tokCCSInfo->flags.flag4IsVariableLength) {
                                        switch (tokCCSInfo->id) {
                                        default:
                                            if (tokCCSInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_CCS_INFO__NUMBER_OF_CCSENABLED: {
                                            dst.SystemInfo.CCSInfo.NumberOfCCSEnabled = readTokValue<decltype(dst.SystemInfo.CCSInfo.NumberOfCCSEnabled)>(*tokCCSInfo);
                                        } break;
                                        case TOK_FBB_GT_CCS_INFO__IS_VALID: {
                                            dst.SystemInfo.CCSInfo.IsValid = readTokValue<decltype(dst.SystemInfo.CCSInfo.IsValid)>(*tokCCSInfo);
                                        } break;
                                        };
                                        tokCCSInfo = tokCCSInfo + 1 + tokCCSInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCCSInfo);
                                        switch (tokCCSInfo->id) {
                                        default:
                                            if (tokCCSInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_CCS_INFO__INSTANCES: {
                                            const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokInstances < tokInstancesEnd) {
                                                if (false == tokInstances->flags.flag4IsVariableLength) {
                                                    switch (tokInstances->id) {
                                                    default:
                                                        if (tokInstances->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSENABLE_MASK: {
                                                        dst.SystemInfo.CCSInfo.Instances.CCSEnableMask = readTokValue<decltype(dst.SystemInfo.CCSInfo.Instances.CCSEnableMask)>(*tokInstances);
                                                    } break;
                                                    };
                                                    tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                                                    switch (tokInstances->id) {
                                                    default:
                                                        if (tokInstances->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GT_CCS_INFO__CCSINSTANCES__BITS: {
                                                        const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokBits < tokBitsEnd) {
                                                            if (false == tokBits->flags.flag4IsVariableLength) {
                                                                switch (tokBits->id) {
                                                                default:
                                                                    if (tokBits->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS0ENABLED: {
                                                                    dst.SystemInfo.CCSInfo.Instances.Bits.CCS0Enabled = readTokValue<decltype(dst.SystemInfo.CCSInfo.Instances.Bits.CCS0Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS1ENABLED: {
                                                                    dst.SystemInfo.CCSInfo.Instances.Bits.CCS1Enabled = readTokValue<decltype(dst.SystemInfo.CCSInfo.Instances.Bits.CCS1Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS2ENABLED: {
                                                                    dst.SystemInfo.CCSInfo.Instances.Bits.CCS2Enabled = readTokValue<decltype(dst.SystemInfo.CCSInfo.Instances.Bits.CCS2Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS3ENABLED: {
                                                                    dst.SystemInfo.CCSInfo.Instances.Bits.CCS3Enabled = readTokValue<decltype(dst.SystemInfo.CCSInfo.Instances.Bits.CCS3Enabled)>(*tokBits);
                                                                } break;
                                                                };
                                                                tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                                                if (tokBits->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokBits == tokBitsEnd);
                                                    } break;
                                                    };
                                                    tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokInstances == tokInstancesEnd);
                                        } break;
                                        };
                                        tokCCSInfo = tokCCSInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokCCSInfo == tokCCSInfoEnd);
                            } break;
                            case TOK_FS_GT_SYSTEM_INFO__MULTI_TILE_ARCH_INFO: {
                                const TokenHeader *tokMultiTileArchInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokMultiTileArchInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokMultiTileArchInfo < tokMultiTileArchInfoEnd) {
                                    if (false == tokMultiTileArchInfo->flags.flag4IsVariableLength) {
                                        switch (tokMultiTileArchInfo->id) {
                                        default:
                                            if (tokMultiTileArchInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__TILE_COUNT: {
                                            dst.SystemInfo.MultiTileArchInfo.TileCount = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.TileCount)>(*tokMultiTileArchInfo);
                                        } break;
                                        case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE0: {
                                            dst.SystemInfo.MultiTileArchInfo.Tile0 = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.Tile0)>(*tokMultiTileArchInfo);
                                        } break;
                                        case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE1: {
                                            dst.SystemInfo.MultiTileArchInfo.Tile1 = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.Tile1)>(*tokMultiTileArchInfo);
                                        } break;
                                        case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE2: {
                                            dst.SystemInfo.MultiTileArchInfo.Tile2 = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.Tile2)>(*tokMultiTileArchInfo);
                                        } break;
                                        case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE3: {
                                            dst.SystemInfo.MultiTileArchInfo.Tile3 = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.Tile3)>(*tokMultiTileArchInfo);
                                        } break;
                                        case TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__TILE_MASK: {
                                            dst.SystemInfo.MultiTileArchInfo.TileMask = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.TileMask)>(*tokMultiTileArchInfo);
                                        } break;
                                        case TOK_FBB_GT_MULTI_TILE_ARCH_INFO__IS_VALID: {
                                            dst.SystemInfo.MultiTileArchInfo.IsValid = readTokValue<decltype(dst.SystemInfo.MultiTileArchInfo.IsValid)>(*tokMultiTileArchInfo);
                                        } break;
                                        };
                                        tokMultiTileArchInfo = tokMultiTileArchInfo + 1 + tokMultiTileArchInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMultiTileArchInfo);
                                        if (tokMultiTileArchInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokMultiTileArchInfo = tokMultiTileArchInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokMultiTileArchInfo == tokMultiTileArchInfoEnd);
                            } break;
                            case TOK_FS_GT_SYSTEM_INFO__VDBOX_INFO: {
                                const TokenHeader *tokVDBoxInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokVDBoxInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokVDBoxInfo < tokVDBoxInfoEnd) {
                                    if (false == tokVDBoxInfo->flags.flag4IsVariableLength) {
                                        switch (tokVDBoxInfo->id) {
                                        default:
                                            if (tokVDBoxInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VDBOX_INFO__NUMBER_OF_VDBOX_ENABLED: {
                                            dst.SystemInfo.VDBoxInfo.NumberOfVDBoxEnabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.NumberOfVDBoxEnabled)>(*tokVDBoxInfo);
                                        } break;
                                        case TOK_FBB_GT_VDBOX_INFO__IS_VALID: {
                                            dst.SystemInfo.VDBoxInfo.IsValid = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.IsValid)>(*tokVDBoxInfo);
                                        } break;
                                        };
                                        tokVDBoxInfo = tokVDBoxInfo + 1 + tokVDBoxInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokVDBoxInfo);
                                        switch (tokVDBoxInfo->id) {
                                        default:
                                            if (tokVDBoxInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_VDBOX_INFO__INSTANCES: {
                                            const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokInstances < tokInstancesEnd) {
                                                if (false == tokInstances->flags.flag4IsVariableLength) {
                                                    switch (tokInstances->id) {
                                                    default:
                                                        if (tokInstances->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBOX_ENABLE_MASK: {
                                                        dst.SystemInfo.VDBoxInfo.Instances.VDBoxEnableMask = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.VDBoxEnableMask)>(*tokInstances);
                                                    } break;
                                                    };
                                                    tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                                                    switch (tokInstances->id) {
                                                    default:
                                                        if (tokInstances->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GT_VDBOX_INFO__VDBOX_INSTANCES__BITS: {
                                                        const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokBits < tokBitsEnd) {
                                                            if (false == tokBits->flags.flag4IsVariableLength) {
                                                                switch (tokBits->id) {
                                                                default:
                                                                    if (tokBits->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX0ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox0Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox0Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX1ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox1Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox1Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX2ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox2Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox2Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX3ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox3Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox3Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX4ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox4Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox4Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX5ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox5Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox5Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX6ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox6Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox6Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX7ENABLED: {
                                                                    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox7Enabled = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox7Enabled)>(*tokBits);
                                                                } break;
                                                                };
                                                                tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                                                if (tokBits->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokBits == tokBitsEnd);
                                                    } break;
                                                    };
                                                    tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokInstances == tokInstancesEnd);
                                        } break;
                                        case TOK_FS_GT_VDBOX_INFO__SFCSUPPORT: {
                                            const TokenHeader *tokSFCSupport = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSFCSupportEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSFCSupport < tokSFCSupportEnd) {
                                                if (false == tokSFCSupport->flags.flag4IsVariableLength) {
                                                    switch (tokSFCSupport->id) {
                                                    default:
                                                        if (tokSFCSupport->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__VALUE: {
                                                        dst.SystemInfo.VDBoxInfo.SFCSupport.Value = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.Value)>(*tokSFCSupport);
                                                    } break;
                                                    };
                                                    tokSFCSupport = tokSFCSupport + 1 + tokSFCSupport->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSFCSupport);
                                                    switch (tokSFCSupport->id) {
                                                    default:
                                                        if (tokSFCSupport->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GT_VDBOX_INFO__ANONYMOUS5662__SFC_SUPPORTED_BITS: {
                                                        const TokenHeader *tokSfcSupportedBits = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokSfcSupportedBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokSfcSupportedBits < tokSfcSupportedBitsEnd) {
                                                            if (false == tokSfcSupportedBits->flags.flag4IsVariableLength) {
                                                                switch (tokSfcSupportedBits->id) {
                                                                default:
                                                                    if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX0: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX1: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX2: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX3: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX4: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX5: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX6: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX7: {
                                                                    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7 = readTokValue<decltype(dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7)>(*tokSfcSupportedBits);
                                                                } break;
                                                                };
                                                                tokSfcSupportedBits = tokSfcSupportedBits + 1 + tokSfcSupportedBits->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSfcSupportedBits);
                                                                if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokSfcSupportedBits = tokSfcSupportedBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokSfcSupportedBits == tokSfcSupportedBitsEnd);
                                                    } break;
                                                    };
                                                    tokSFCSupport = tokSFCSupport + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSFCSupport == tokSFCSupportEnd);
                                        } break;
                                        };
                                        tokVDBoxInfo = tokVDBoxInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokVDBoxInfo == tokVDBoxInfoEnd);
                            } break;
                            case TOK_FS_GT_SYSTEM_INFO__VEBOX_INFO: {
                                const TokenHeader *tokVEBoxInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokVEBoxInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokVEBoxInfo < tokVEBoxInfoEnd) {
                                    if (false == tokVEBoxInfo->flags.flag4IsVariableLength) {
                                        switch (tokVEBoxInfo->id) {
                                        default:
                                            if (tokVEBoxInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_VEBOX_INFO__NUMBER_OF_VEBOX_ENABLED: {
                                            dst.SystemInfo.VEBoxInfo.NumberOfVEBoxEnabled = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.NumberOfVEBoxEnabled)>(*tokVEBoxInfo);
                                        } break;
                                        case TOK_FBB_GT_VEBOX_INFO__IS_VALID: {
                                            dst.SystemInfo.VEBoxInfo.IsValid = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.IsValid)>(*tokVEBoxInfo);
                                        } break;
                                        };
                                        tokVEBoxInfo = tokVEBoxInfo + 1 + tokVEBoxInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokVEBoxInfo);
                                        switch (tokVEBoxInfo->id) {
                                        default:
                                            if (tokVEBoxInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GT_VEBOX_INFO__INSTANCES: {
                                            const TokenHeader *tokInstances = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokInstancesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokInstances < tokInstancesEnd) {
                                                if (false == tokInstances->flags.flag4IsVariableLength) {
                                                    switch (tokInstances->id) {
                                                    default:
                                                        if (tokInstances->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBOX_ENABLE_MASK: {
                                                        dst.SystemInfo.VEBoxInfo.Instances.VEBoxEnableMask = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.Instances.VEBoxEnableMask)>(*tokInstances);
                                                    } break;
                                                    };
                                                    tokInstances = tokInstances + 1 + tokInstances->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInstances);
                                                    switch (tokInstances->id) {
                                                    default:
                                                        if (tokInstances->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GT_VEBOX_INFO__VEBOX_INSTANCES__BITS: {
                                                        const TokenHeader *tokBits = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokBits < tokBitsEnd) {
                                                            if (false == tokBits->flags.flag4IsVariableLength) {
                                                                switch (tokBits->id) {
                                                                default:
                                                                    if (tokBits->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX0ENABLED: {
                                                                    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox0Enabled = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox0Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX1ENABLED: {
                                                                    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox1Enabled = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox1Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX2ENABLED: {
                                                                    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox2Enabled = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox2Enabled)>(*tokBits);
                                                                } break;
                                                                case TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX3ENABLED: {
                                                                    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox3Enabled = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox3Enabled)>(*tokBits);
                                                                } break;
                                                                };
                                                                tokBits = tokBits + 1 + tokBits->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokBits);
                                                                if (tokBits->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokBits = tokBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokBits == tokBitsEnd);
                                                    } break;
                                                    };
                                                    tokInstances = tokInstances + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokInstances == tokInstancesEnd);
                                        } break;
                                        case TOK_FS_GT_VEBOX_INFO__SFCSUPPORT: {
                                            const TokenHeader *tokSFCSupport = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSFCSupportEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSFCSupport < tokSFCSupportEnd) {
                                                if (false == tokSFCSupport->flags.flag4IsVariableLength) {
                                                    switch (tokSFCSupport->id) {
                                                    default:
                                                        if (tokSFCSupport->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__VALUE: {
                                                        dst.SystemInfo.VEBoxInfo.SFCSupport.Value = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.SFCSupport.Value)>(*tokSFCSupport);
                                                    } break;
                                                    };
                                                    tokSFCSupport = tokSFCSupport + 1 + tokSFCSupport->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSFCSupport);
                                                    switch (tokSFCSupport->id) {
                                                    default:
                                                        if (tokSFCSupport->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GT_VEBOX_INFO__ANONYMOUS3862__SFC_SUPPORTED_BITS: {
                                                        const TokenHeader *tokSfcSupportedBits = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokSfcSupportedBitsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokSfcSupportedBits < tokSfcSupportedBitsEnd) {
                                                            if (false == tokSfcSupportedBits->flags.flag4IsVariableLength) {
                                                                switch (tokSfcSupportedBits->id) {
                                                                default:
                                                                    if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX0: {
                                                                    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0 = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX1: {
                                                                    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1 = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX2: {
                                                                    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2 = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2)>(*tokSfcSupportedBits);
                                                                } break;
                                                                case TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX3: {
                                                                    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3 = readTokValue<decltype(dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3)>(*tokSfcSupportedBits);
                                                                } break;
                                                                };
                                                                tokSfcSupportedBits = tokSfcSupportedBits + 1 + tokSfcSupportedBits->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSfcSupportedBits);
                                                                if (tokSfcSupportedBits->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokSfcSupportedBits = tokSfcSupportedBits + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokSfcSupportedBits == tokSfcSupportedBitsEnd);
                                                    } break;
                                                    };
                                                    tokSFCSupport = tokSFCSupport + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSFCSupport == tokSFCSupportEnd);
                                        } break;
                                        };
                                        tokVEBoxInfo = tokVEBoxInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokVEBoxInfo == tokVEBoxInfoEnd);
                            } break;
                            case TOK_FS_GT_SYSTEM_INFO__CACHE_TYPES: {
                                const TokenHeader *tokCacheTypes = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokCacheTypesEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokCacheTypes < tokCacheTypesEnd) {
                                    if (false == tokCacheTypes->flags.flag4IsVariableLength) {
                                        switch (tokCacheTypes->id) {
                                        default:
                                            if (tokCacheTypes->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__L3: {
                                            dst.SystemInfo.CacheTypes.L3 = readTokValue<decltype(dst.SystemInfo.CacheTypes.L3)>(*tokCacheTypes);
                                        } break;
                                        case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__LLC: {
                                            dst.SystemInfo.CacheTypes.LLC = readTokValue<decltype(dst.SystemInfo.CacheTypes.LLC)>(*tokCacheTypes);
                                        } break;
                                        case TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__E_DRAM: {
                                            dst.SystemInfo.CacheTypes.eDRAM = readTokValue<decltype(dst.SystemInfo.CacheTypes.eDRAM)>(*tokCacheTypes);
                                        } break;
                                        case TOK_FBD_GT_CACHE_TYPES__CACHE_TYPE_MASK: {
                                            dst.SystemInfo.CacheTypes.CacheTypeMask = readTokValue<decltype(dst.SystemInfo.CacheTypes.CacheTypeMask)>(*tokCacheTypes);
                                        } break;
                                        };
                                        tokCacheTypes = tokCacheTypes + 1 + tokCacheTypes->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCacheTypes);
                                        if (tokCacheTypes->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokCacheTypes = tokCacheTypes + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokCacheTypes == tokCacheTypesEnd);
                            } break;
                            };
                            tokSystemInfo = tokSystemInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSystemInfo == tokSystemInfoEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__DEFERRED_WAIT_INFO: {
                    const TokenHeader *tokDeferredWaitInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokDeferredWaitInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokDeferredWaitInfo < tokDeferredWaitInfoEnd) {
                        if (false == tokDeferredWaitInfo->flags.flag4IsVariableLength) {
                            switch (tokDeferredWaitInfo->id) {
                            default:
                                if (tokDeferredWaitInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_KM_DEFERRED_WAIT_INFO__FEATURE_SUPPORTED: {
                                dst.DeferredWaitInfo.FeatureSupported = readTokValue<decltype(dst.DeferredWaitInfo.FeatureSupported)>(*tokDeferredWaitInfo);
                            } break;
                            case TOK_FBD_KM_DEFERRED_WAIT_INFO__ACTIVE_DISPLAY: {
                                dst.DeferredWaitInfo.ActiveDisplay = readTokValue<decltype(dst.DeferredWaitInfo.ActiveDisplay)>(*tokDeferredWaitInfo);
                            } break;
                            };
                            tokDeferredWaitInfo = tokDeferredWaitInfo + 1 + tokDeferredWaitInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokDeferredWaitInfo);
                            if (tokDeferredWaitInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokDeferredWaitInfo = tokDeferredWaitInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokDeferredWaitInfo == tokDeferredWaitInfoEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__GFX_PARTITION: {
                    const TokenHeader *tokGfxPartition = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokGfxPartitionEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokGfxPartition < tokGfxPartitionEnd) {
                        if (false == tokGfxPartition->flags.flag4IsVariableLength) {
                            if (tokGfxPartition->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokGfxPartition = tokGfxPartition + 1 + tokGfxPartition->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGfxPartition);
                            switch (tokGfxPartition->id) {
                            default:
                                if (tokGfxPartition->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_GFX_PARTITIONING__STANDARD: {
                                const TokenHeader *tokStandard = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokStandardEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokStandard < tokStandardEnd) {
                                    if (false == tokStandard->flags.flag4IsVariableLength) {
                                        switch (tokStandard->id) {
                                        default:
                                            if (tokStandard->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                            dst.GfxPartition.Standard.Base = readTokValue<decltype(dst.GfxPartition.Standard.Base)>(*tokStandard);
                                        } break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                            dst.GfxPartition.Standard.Limit = readTokValue<decltype(dst.GfxPartition.Standard.Limit)>(*tokStandard);
                                        } break;
                                        };
                                        tokStandard = tokStandard + 1 + tokStandard->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokStandard);
                                        if (tokStandard->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokStandard = tokStandard + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokStandard == tokStandardEnd);
                            } break;
                            case TOK_FS_GMM_GFX_PARTITIONING__STANDARD64KB: {
                                const TokenHeader *tokStandard64KB = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokStandard64KBEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokStandard64KB < tokStandard64KBEnd) {
                                    if (false == tokStandard64KB->flags.flag4IsVariableLength) {
                                        switch (tokStandard64KB->id) {
                                        default:
                                            if (tokStandard64KB->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                            dst.GfxPartition.Standard64KB.Base = readTokValue<decltype(dst.GfxPartition.Standard64KB.Base)>(*tokStandard64KB);
                                        } break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                            dst.GfxPartition.Standard64KB.Limit = readTokValue<decltype(dst.GfxPartition.Standard64KB.Limit)>(*tokStandard64KB);
                                        } break;
                                        };
                                        tokStandard64KB = tokStandard64KB + 1 + tokStandard64KB->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokStandard64KB);
                                        if (tokStandard64KB->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokStandard64KB = tokStandard64KB + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokStandard64KB == tokStandard64KBEnd);
                            } break;
                            case TOK_FS_GMM_GFX_PARTITIONING__SVM: {
                                const TokenHeader *tokSVM = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSVMEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSVM < tokSVMEnd) {
                                    if (false == tokSVM->flags.flag4IsVariableLength) {
                                        switch (tokSVM->id) {
                                        default:
                                            if (tokSVM->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                            dst.GfxPartition.SVM.Base = readTokValue<decltype(dst.GfxPartition.SVM.Base)>(*tokSVM);
                                        } break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                            dst.GfxPartition.SVM.Limit = readTokValue<decltype(dst.GfxPartition.SVM.Limit)>(*tokSVM);
                                        } break;
                                        };
                                        tokSVM = tokSVM + 1 + tokSVM->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSVM);
                                        if (tokSVM->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSVM = tokSVM + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSVM == tokSVMEnd);
                            } break;
                            case TOK_FS_GMM_GFX_PARTITIONING__HEAP32: {
                                uint32_t arrayElementIdHeap32 = varLen->arrayElementId;
                                const TokenHeader *tokHeap32 = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokHeap32End = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokHeap32 < tokHeap32End) {
                                    if (false == tokHeap32->flags.flag4IsVariableLength) {
                                        switch (tokHeap32->id) {
                                        default:
                                            if (tokHeap32->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE: {
                                            dst.GfxPartition.Heap32[arrayElementIdHeap32].Base = readTokValue<decltype(dst.GfxPartition.Heap32[arrayElementIdHeap32].Base)>(*tokHeap32);
                                        } break;
                                        case TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT: {
                                            dst.GfxPartition.Heap32[arrayElementIdHeap32].Limit = readTokValue<decltype(dst.GfxPartition.Heap32[arrayElementIdHeap32].Limit)>(*tokHeap32);
                                        } break;
                                        };
                                        tokHeap32 = tokHeap32 + 1 + tokHeap32->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokHeap32);
                                        if (tokHeap32->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokHeap32 = tokHeap32 + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokHeap32 == tokHeap32End);
                            } break;
                            };
                            tokGfxPartition = tokGfxPartition + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokGfxPartition == tokGfxPartitionEnd);
                } break;
                case TOK_FS_ADAPTER_INFO__ST_ADAPTER_BDF: {
                    const TokenHeader *tokStAdapterBDF = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokStAdapterBDFEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokStAdapterBDF < tokStAdapterBDFEnd) {
                        if (false == tokStAdapterBDF->flags.flag4IsVariableLength) {
                            switch (tokStAdapterBDF->id) {
                            default:
                                if (tokStAdapterBDF->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__BUS: {
                                dst.stAdapterBDF.Bus = readTokValue<decltype(dst.stAdapterBDF.Bus)>(*tokStAdapterBDF);
                            } break;
                            case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__DEVICE: {
                                dst.stAdapterBDF.Device = readTokValue<decltype(dst.stAdapterBDF.Device)>(*tokStAdapterBDF);
                            } break;
                            case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__FUNCTION: {
                                dst.stAdapterBDF.Function = readTokValue<decltype(dst.stAdapterBDF.Function)>(*tokStAdapterBDF);
                            } break;
                            case TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__DATA: {
                                dst.stAdapterBDF.Data = readTokValue<decltype(dst.stAdapterBDF.Data)>(*tokStAdapterBDF);
                            } break;
                            };
                            tokStAdapterBDF = tokStAdapterBDF + 1 + tokStAdapterBDF->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokStAdapterBDF);
                            if (tokStAdapterBDF->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokStAdapterBDF = tokStAdapterBDF + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokStAdapterBDF == tokStAdapterBDFEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_CREATECONTEXT_PVTDATA> {
    template <typename _CREATECONTEXT_PVTDATAT>
    static bool demarshall(_CREATECONTEXT_PVTDATAT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_PBQ_CREATECONTEXT_PVTDATA__ANONYMOUS18449__P_HW_CONTEXT_ID: {
                    dst.pHwContextId = readTokValue<decltype(dst.pHwContextId)>(*tok);
                } break;
                case TOK_FBD_CREATECONTEXT_PVTDATA__NUMBER_OF_HW_CONTEXT_IDS: {
                    dst.NumberOfHwContextIds = readTokValue<decltype(dst.NumberOfHwContextIds)>(*tok);
                } break;
                case TOK_FBD_CREATECONTEXT_PVTDATA__PROCESS_ID: {
                    dst.ProcessID = readTokValue<decltype(dst.ProcessID)>(*tok);
                } break;
                case TOK_FBC_CREATECONTEXT_PVTDATA__IS_PROTECTED_PROCESS: {
                    dst.IsProtectedProcess = readTokValue<decltype(dst.IsProtectedProcess)>(*tok);
                } break;
                case TOK_FBC_CREATECONTEXT_PVTDATA__IS_DWM: {
                    dst.IsDwm = readTokValue<decltype(dst.IsDwm)>(*tok);
                } break;
                case TOK_FBC_CREATECONTEXT_PVTDATA__IS_MEDIA_USAGE: {
                    dst.IsMediaUsage = readTokValue<decltype(dst.IsMediaUsage)>(*tok);
                } break;
                case TOK_FBC_CREATECONTEXT_PVTDATA__GPU_VACONTEXT: {
                    dst.GpuVAContext = readTokValue<decltype(dst.GpuVAContext)>(*tok);
                } break;
                case TOK_FBC_CREATECONTEXT_PVTDATA__NO_RING_FLUSHES: {
                    dst.NoRingFlushes = readTokValue<decltype(dst.NoRingFlushes)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_CREATECONTEXT_PVTDATA:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_COMMAND_BUFFER_HEADER_REC> {
    template <typename COMMAND_BUFFER_HEADER_RECT>
    static bool demarshall(COMMAND_BUFFER_HEADER_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_CONTEXT_TYPE: {
                    dst.UmdContextType = readTokValue<decltype(dst.UmdContextType)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_PATCH_LIST: {
                    dst.UmdPatchList = readTokValue<decltype(dst.UmdPatchList)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_REQUESTED_SLICE_STATE: {
                    dst.UmdRequestedSliceState = readTokValue<decltype(dst.UmdRequestedSliceState)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_REQUESTED_SUBSLICE_COUNT: {
                    dst.UmdRequestedSubsliceCount = readTokValue<decltype(dst.UmdRequestedSubsliceCount)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_REQUESTED_EUCOUNT: {
                    dst.UmdRequestedEUCount = readTokValue<decltype(dst.UmdRequestedEUCount)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__USES_RESOURCE_STREAMER: {
                    dst.UsesResourceStreamer = readTokValue<decltype(dst.UsesResourceStreamer)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__NEEDS_MID_BATCH_PRE_EMPTION_SUPPORT: {
                    dst.NeedsMidBatchPreEmptionSupport = readTokValue<decltype(dst.NeedsMidBatchPreEmptionSupport)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__USES_GPGPUPIPELINE: {
                    dst.UsesGPGPUPipeline = readTokValue<decltype(dst.UsesGPGPUPipeline)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__REQUIRES_COHERENCY: {
                    dst.RequiresCoherency = readTokValue<decltype(dst.RequiresCoherency)>(*tok);
                } break;
                case TOK_FBD_COMMAND_BUFFER_HEADER_REC__PERF_TAG: {
                    dst.PerfTag = readTokValue<decltype(dst.PerfTag)>(*tok);
                } break;
                case TOK_FBQ_COMMAND_BUFFER_HEADER_REC__MONITOR_FENCE_VA: {
                    dst.MonitorFenceVA = readTokValue<decltype(dst.MonitorFenceVA)>(*tok);
                } break;
                case TOK_FBQ_COMMAND_BUFFER_HEADER_REC__MONITOR_FENCE_VALUE: {
                    dst.MonitorFenceValue = readTokValue<decltype(dst.MonitorFenceValue)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_COMMAND_BUFFER_HEADER_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_RESOURCE_FLAG_REC> {
    template <typename GMM_RESOURCE_FLAG_RECT>
    static bool demarshall(GMM_RESOURCE_FLAG_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                if (tok->flags.flag3IsMandatory) {
                    return false;
                }
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_RESOURCE_FLAG_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                    const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokGpu < tokGpuEnd) {
                        if (false == tokGpu->flags.flag4IsVariableLength) {
                            switch (tokGpu->id) {
                            default:
                                if (tokGpu->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                dst.Gpu.CameraCapture = readTokValue<decltype(dst.Gpu.CameraCapture)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                dst.Gpu.CCS = readTokValue<decltype(dst.Gpu.CCS)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                dst.Gpu.ColorDiscard = readTokValue<decltype(dst.Gpu.ColorDiscard)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                dst.Gpu.ColorSeparation = readTokValue<decltype(dst.Gpu.ColorSeparation)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                dst.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.Gpu.ColorSeparationRGBX)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                dst.Gpu.Constant = readTokValue<decltype(dst.Gpu.Constant)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                dst.Gpu.Depth = readTokValue<decltype(dst.Gpu.Depth)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                dst.Gpu.FlipChain = readTokValue<decltype(dst.Gpu.FlipChain)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                dst.Gpu.FlipChainPreferred = readTokValue<decltype(dst.Gpu.FlipChainPreferred)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                dst.Gpu.HistoryBuffer = readTokValue<decltype(dst.Gpu.HistoryBuffer)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                dst.Gpu.HiZ = readTokValue<decltype(dst.Gpu.HiZ)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                dst.Gpu.Index = readTokValue<decltype(dst.Gpu.Index)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                dst.Gpu.IndirectClearColor = readTokValue<decltype(dst.Gpu.IndirectClearColor)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                dst.Gpu.InstructionFlat = readTokValue<decltype(dst.Gpu.InstructionFlat)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                dst.Gpu.InterlacedScan = readTokValue<decltype(dst.Gpu.InterlacedScan)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                dst.Gpu.MCS = readTokValue<decltype(dst.Gpu.MCS)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                dst.Gpu.MMC = readTokValue<decltype(dst.Gpu.MMC)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                dst.Gpu.MotionComp = readTokValue<decltype(dst.Gpu.MotionComp)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                dst.Gpu.NoRestriction = readTokValue<decltype(dst.Gpu.NoRestriction)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                dst.Gpu.Overlay = readTokValue<decltype(dst.Gpu.Overlay)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                dst.Gpu.Presentable = readTokValue<decltype(dst.Gpu.Presentable)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                dst.Gpu.ProceduralTexture = readTokValue<decltype(dst.Gpu.ProceduralTexture)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                dst.Gpu.Query = readTokValue<decltype(dst.Gpu.Query)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                dst.Gpu.RenderTarget = readTokValue<decltype(dst.Gpu.RenderTarget)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                dst.Gpu.S3d = readTokValue<decltype(dst.Gpu.S3d)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                dst.Gpu.S3dDx = readTokValue<decltype(dst.Gpu.S3dDx)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                dst.Gpu.__S3dNonPacked = readTokValue<decltype(dst.Gpu.__S3dNonPacked)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                dst.Gpu.__S3dWidi = readTokValue<decltype(dst.Gpu.__S3dWidi)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                dst.Gpu.ScratchFlat = readTokValue<decltype(dst.Gpu.ScratchFlat)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                dst.Gpu.SeparateStencil = readTokValue<decltype(dst.Gpu.SeparateStencil)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                dst.Gpu.State = readTokValue<decltype(dst.Gpu.State)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                dst.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                dst.Gpu.Stream = readTokValue<decltype(dst.Gpu.Stream)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                dst.Gpu.TextApi = readTokValue<decltype(dst.Gpu.TextApi)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                dst.Gpu.Texture = readTokValue<decltype(dst.Gpu.Texture)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                dst.Gpu.TiledResource = readTokValue<decltype(dst.Gpu.TiledResource)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                dst.Gpu.TilePool = readTokValue<decltype(dst.Gpu.TilePool)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                dst.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.Gpu.UnifiedAuxSurface)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                dst.Gpu.Vertex = readTokValue<decltype(dst.Gpu.Vertex)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                dst.Gpu.Video = readTokValue<decltype(dst.Gpu.Video)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                dst.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                dst.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                dst.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.Gpu.__MsaaTileMcs)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                dst.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                dst.Gpu.__Remaining = readTokValue<decltype(dst.Gpu.__Remaining)>(*tokGpu);
                            } break;
                            };
                            tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                            if (tokGpu->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokGpu == tokGpuEnd);
                } break;
                case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                    const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokInfo < tokInfoEnd) {
                        if (false == tokInfo->flags.flag4IsVariableLength) {
                            switch (tokInfo->id) {
                            default:
                                if (tokInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                dst.Info.AllowVirtualPadding = readTokValue<decltype(dst.Info.AllowVirtualPadding)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                dst.Info.BigPage = readTokValue<decltype(dst.Info.BigPage)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                dst.Info.Cacheable = readTokValue<decltype(dst.Info.Cacheable)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                dst.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                dst.Info.CornerTexelMode = readTokValue<decltype(dst.Info.CornerTexelMode)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                dst.Info.ExistingSysMem = readTokValue<decltype(dst.Info.ExistingSysMem)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                dst.Info.ForceResidency = readTokValue<decltype(dst.Info.ForceResidency)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                dst.Info.Gfdt = readTokValue<decltype(dst.Info.Gfdt)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                dst.Info.GttMapType = readTokValue<decltype(dst.Info.GttMapType)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                dst.Info.HardwareProtected = readTokValue<decltype(dst.Info.HardwareProtected)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                dst.Info.KernelModeMapped = readTokValue<decltype(dst.Info.KernelModeMapped)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                dst.Info.LayoutBelow = readTokValue<decltype(dst.Info.LayoutBelow)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                dst.Info.LayoutMono = readTokValue<decltype(dst.Info.LayoutMono)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                dst.Info.LayoutRight = readTokValue<decltype(dst.Info.LayoutRight)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                dst.Info.LocalOnly = readTokValue<decltype(dst.Info.LocalOnly)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                dst.Info.Linear = readTokValue<decltype(dst.Info.Linear)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                dst.Info.MediaCompressed = readTokValue<decltype(dst.Info.MediaCompressed)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                dst.Info.NoOptimizationPadding = readTokValue<decltype(dst.Info.NoOptimizationPadding)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                dst.Info.NoPhysMemory = readTokValue<decltype(dst.Info.NoPhysMemory)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                dst.Info.NotLockable = readTokValue<decltype(dst.Info.NotLockable)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                dst.Info.NonLocalOnly = readTokValue<decltype(dst.Info.NonLocalOnly)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                dst.Info.StdSwizzle = readTokValue<decltype(dst.Info.StdSwizzle)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                dst.Info.PseudoStdSwizzle = readTokValue<decltype(dst.Info.PseudoStdSwizzle)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                dst.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.Info.Undefined64KBSwizzle)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                dst.Info.RedecribedPlanes = readTokValue<decltype(dst.Info.RedecribedPlanes)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                dst.Info.RenderCompressed = readTokValue<decltype(dst.Info.RenderCompressed)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                dst.Info.Rotated = readTokValue<decltype(dst.Info.Rotated)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                dst.Info.Shared = readTokValue<decltype(dst.Info.Shared)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                dst.Info.SoftwareProtected = readTokValue<decltype(dst.Info.SoftwareProtected)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                dst.Info.SVM = readTokValue<decltype(dst.Info.SVM)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                dst.Info.Tile4 = readTokValue<decltype(dst.Info.Tile4)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                dst.Info.Tile64 = readTokValue<decltype(dst.Info.Tile64)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                dst.Info.TiledW = readTokValue<decltype(dst.Info.TiledW)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                dst.Info.TiledX = readTokValue<decltype(dst.Info.TiledX)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                dst.Info.TiledY = readTokValue<decltype(dst.Info.TiledY)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                dst.Info.TiledYf = readTokValue<decltype(dst.Info.TiledYf)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                dst.Info.TiledYs = readTokValue<decltype(dst.Info.TiledYs)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                dst.Info.WddmProtected = readTokValue<decltype(dst.Info.WddmProtected)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                dst.Info.XAdapter = readTokValue<decltype(dst.Info.XAdapter)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                dst.Info.__PreallocatedResInfo = readTokValue<decltype(dst.Info.__PreallocatedResInfo)>(*tokInfo);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                dst.Info.__PreWddm2SVM = readTokValue<decltype(dst.Info.__PreWddm2SVM)>(*tokInfo);
                            } break;
                            };
                            tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                            if (tokInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokInfo == tokInfoEnd);
                } break;
                case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                    const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokWa < tokWaEnd) {
                        if (false == tokWa->flags.flag4IsVariableLength) {
                            switch (tokWa->id) {
                            default:
                                if (tokWa->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                dst.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                dst.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                dst.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                dst.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.Wa.NoBufferSamplerPadding)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                dst.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                dst.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                dst.Wa.DisablePackedMipTail = readTokValue<decltype(dst.Wa.DisablePackedMipTail)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                dst.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                dst.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                dst.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.Wa.DisableDisplayCcsCompression)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                dst.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.Wa.PreGen12FastClearOnly)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                dst.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.Wa.ForceStdAllocAlign)>(*tokWa);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                dst.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                            } break;
                            };
                            tokWa = tokWa + 1 + tokWa->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                            if (tokWa->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokWa == tokWaEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_RESOURCE_MSAA_INFO_REC> {
    template <typename GMM_RESOURCE_MSAA_INFO_RECT>
    static bool demarshall(GMM_RESOURCE_MSAA_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                    dst.SamplePattern = readTokValue<decltype(dst.SamplePattern)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                    dst.NumSamples = readTokValue<decltype(dst.NumSamples)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_RESOURCE_MSAA_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_RESOURCE_ALIGNMENT_REC> {
    template <typename GMM_RESOURCE_ALIGNMENT_RECT>
    static bool demarshall(GMM_RESOURCE_ALIGNMENT_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                    dst.ArraySpacingSingleLod = readTokValue<decltype(dst.ArraySpacingSingleLod)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                    dst.BaseAlignment = readTokValue<decltype(dst.BaseAlignment)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                    dst.HAlign = readTokValue<decltype(dst.HAlign)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                    dst.VAlign = readTokValue<decltype(dst.VAlign)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                    dst.DAlign = readTokValue<decltype(dst.DAlign)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                    dst.MipTailStartLod = readTokValue<decltype(dst.MipTailStartLod)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                    dst.PackedMipStartLod = readTokValue<decltype(dst.PackedMipStartLod)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                    dst.PackedMipWidth = readTokValue<decltype(dst.PackedMipWidth)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                    dst.PackedMipHeight = readTokValue<decltype(dst.PackedMipHeight)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                    dst.QPitch = readTokValue<decltype(dst.QPitch)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_RESOURCE_ALIGNMENT_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_S3D_INFO_REC> {
    template <typename GMM_S3D_INFO_RECT>
    static bool demarshall(GMM_S3D_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                    dst.DisplayModeHeight = readTokValue<decltype(dst.DisplayModeHeight)>(*tok);
                } break;
                case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                    dst.NumBlankActiveLines = readTokValue<decltype(dst.NumBlankActiveLines)>(*tok);
                } break;
                case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                    dst.RFrameOffset = readTokValue<decltype(dst.RFrameOffset)>(*tok);
                } break;
                case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                    dst.BlankAreaOffset = readTokValue<decltype(dst.BlankAreaOffset)>(*tok);
                } break;
                case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                    dst.TallBufferHeight = readTokValue<decltype(dst.TallBufferHeight)>(*tok);
                } break;
                case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                    dst.TallBufferSize = readTokValue<decltype(dst.TallBufferSize)>(*tok);
                } break;
                case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                    dst.IsRFrame = readTokValue<decltype(dst.IsRFrame)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_S3D_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_MULTI_TILE_ARCH_REC> {
    template <typename GMM_MULTI_TILE_ARCH_RECT>
    static bool demarshall(GMM_MULTI_TILE_ARCH_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__ENABLE: {
                    dst.Enable = readTokValue<decltype(dst.Enable)>(*tok);
                } break;
                case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__TILE_INSTANCED: {
                    dst.TileInstanced = readTokValue<decltype(dst.TileInstanced)>(*tok);
                } break;
                case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__GPU_VA_MAPPING_SET: {
                    dst.GpuVaMappingSet = readTokValue<decltype(dst.GpuVaMappingSet)>(*tok);
                } break;
                case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__LOCAL_MEM_ELIGIBILITY_SET: {
                    dst.LocalMemEligibilitySet = readTokValue<decltype(dst.LocalMemEligibilitySet)>(*tok);
                } break;
                case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__LOCAL_MEM_PREFERRED_SET: {
                    dst.LocalMemPreferredSet = readTokValue<decltype(dst.LocalMemPreferredSet)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_MULTI_TILE_ARCH_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_PLANAR_OFFSET_INFO_REC> {
    template <typename GMM_PLANAR_OFFSET_INFO_RECT>
    static bool demarshall(GMM_PLANAR_OFFSET_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                    dst.ArrayQPitch = readTokValue<decltype(dst.ArrayQPitch)>(*tok);
                } break;
                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.X)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.X, sizeof(dst.X), srcData, sizeof(dst.X));
                } break;
                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.Y)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.Y, sizeof(dst.Y), srcData, sizeof(dst.Y));
                } break;
                case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                    dst.NoOfPlanes = readTokValue<decltype(dst.NoOfPlanes)>(*tok);
                } break;
                case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                    dst.IsTileAlignedPlanes = readTokValue<decltype(dst.IsTileAlignedPlanes)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_PLANAR_OFFSET_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                    const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokUnAligned < tokUnAlignedEnd) {
                        if (false == tokUnAligned->flags.flag4IsVariableLength) {
                            switch (tokUnAligned->id) {
                            default:
                                if (tokUnAligned->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.UnAligned.Height)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.UnAligned.Height, sizeof(dst.UnAligned.Height), srcData, sizeof(dst.UnAligned.Height));
                            } break;
                            };
                            tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                            if (tokUnAligned->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_2D_TEXTURE_OFFSET_INFO_REC> {
    template <typename GMM_2D_TEXTURE_OFFSET_INFO_RECT>
    static bool demarshall(GMM_2D_TEXTURE_OFFSET_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                    dst.ArrayQPitchLock = readTokValue<decltype(dst.ArrayQPitchLock)>(*tok);
                } break;
                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                    dst.ArrayQPitchRender = readTokValue<decltype(dst.ArrayQPitchRender)>(*tok);
                } break;
                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.Offset)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.Offset, sizeof(dst.Offset), srcData, sizeof(dst.Offset));
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_2D_TEXTURE_OFFSET_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_3D_TEXTURE_OFFSET_INFO_REC> {
    template <typename GMM_3D_TEXTURE_OFFSET_INFO_RECT>
    static bool demarshall(GMM_3D_TEXTURE_OFFSET_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                    dst.Mip0SlicePitch = readTokValue<decltype(dst.Mip0SlicePitch)>(*tok);
                } break;
                case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.Offset)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.Offset, sizeof(dst.Offset), srcData, sizeof(dst.Offset));
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_3D_TEXTURE_OFFSET_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_OFFSET_INFO_REC> {
    template <typename GMM_OFFSET_INFO_RECT>
    static bool demarshall(GMM_OFFSET_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                if (tok->flags.flag3IsMandatory) {
                    return false;
                }
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_OFFSET_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                    const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                        if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                            switch (tokTexture3DOffsetInfo->id) {
                            default:
                                if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                dst.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                            } break;
                            case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.Texture3DOffsetInfo.Offset)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.Texture3DOffsetInfo.Offset, sizeof(dst.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.Texture3DOffsetInfo.Offset));
                            } break;
                            };
                            tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                            if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                } break;
                case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                    const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                        if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                            switch (tokTexture2DOffsetInfo->id) {
                            default:
                                if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                dst.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                            } break;
                            case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                dst.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                            } break;
                            case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.Texture2DOffsetInfo.Offset)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.Texture2DOffsetInfo.Offset, sizeof(dst.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.Texture2DOffsetInfo.Offset));
                            } break;
                            };
                            tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                            if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                } break;
                case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                    const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokPlane < tokPlaneEnd) {
                        if (false == tokPlane->flags.flag4IsVariableLength) {
                            switch (tokPlane->id) {
                            default:
                                if (tokPlane->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                dst.Plane.ArrayQPitch = readTokValue<decltype(dst.Plane.ArrayQPitch)>(*tokPlane);
                            } break;
                            case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.Plane.X)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.Plane.X, sizeof(dst.Plane.X), srcData, sizeof(dst.Plane.X));
                            } break;
                            case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.Plane.Y)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.Plane.Y, sizeof(dst.Plane.Y), srcData, sizeof(dst.Plane.Y));
                            } break;
                            case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                dst.Plane.NoOfPlanes = readTokValue<decltype(dst.Plane.NoOfPlanes)>(*tokPlane);
                            } break;
                            case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                dst.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.Plane.IsTileAlignedPlanes)>(*tokPlane);
                            } break;
                            };
                            tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                            switch (tokPlane->id) {
                            default:
                                if (tokPlane->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokUnAligned < tokUnAlignedEnd) {
                                    if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                        switch (tokUnAligned->id) {
                                        default:
                                            if (tokUnAligned->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.Plane.UnAligned.Height)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.Plane.UnAligned.Height, sizeof(dst.Plane.UnAligned.Height), srcData, sizeof(dst.Plane.UnAligned.Height));
                                        } break;
                                        };
                                        tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                        if (tokUnAligned->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                            } break;
                            };
                            tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokPlane == tokPlaneEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_TEXTURE_INFO_REC> {
    template <typename GMM_TEXTURE_INFO_RECT>
    static bool demarshall(GMM_TEXTURE_INFO_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                    dst.Type = readTokValue<decltype(dst.Type)>(*tok);
                } break;
                case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                    dst.Format = readTokValue<decltype(dst.Format)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                    dst.BitsPerPixel = readTokValue<decltype(dst.BitsPerPixel)>(*tok);
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                    dst.BaseWidth = readTokValue<decltype(dst.BaseWidth)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                    dst.BaseHeight = readTokValue<decltype(dst.BaseHeight)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                    dst.Depth = readTokValue<decltype(dst.Depth)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                    dst.MaxLod = readTokValue<decltype(dst.MaxLod)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                    dst.ArraySize = readTokValue<decltype(dst.ArraySize)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                    dst.CpTag = readTokValue<decltype(dst.CpTag)>(*tok);
                } break;
                case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.MmcMode)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.MmcMode, sizeof(dst.MmcMode), srcData, sizeof(dst.MmcMode));
                } break;
                case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tok).getValue<char>();
                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tok).getValueSizeInBytes();
                    if (srcSize < sizeof(dst.MmcHint)) {
                        return false;
                    }
                    WCH_SAFE_COPY(dst.MmcHint, sizeof(dst.MmcHint), srcData, sizeof(dst.MmcHint));
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                    dst.Pitch = readTokValue<decltype(dst.Pitch)>(*tok);
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                    dst.OverridePitch = readTokValue<decltype(dst.OverridePitch)>(*tok);
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                    dst.Size = readTokValue<decltype(dst.Size)>(*tok);
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                    dst.CCSize = readTokValue<decltype(dst.CCSize)>(*tok);
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                    dst.UnpaddedSize = readTokValue<decltype(dst.UnpaddedSize)>(*tok);
                } break;
                case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                    dst.SizeReportToOS = readTokValue<decltype(dst.SizeReportToOS)>(*tok);
                } break;
                case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                    dst.TileMode = readTokValue<decltype(dst.TileMode)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN: {
                    dst.CCSModeAlign = readTokValue<decltype(dst.CCSModeAlign)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS: {
                    dst.LegacyFlags = readTokValue<decltype(dst.LegacyFlags)>(*tok);
                } break;
                case TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH: {
                    dst.MaximumRenamingListLength = readTokValue<decltype(dst.MaximumRenamingListLength)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_TEXTURE_INFO_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS: {
                    const TokenHeader *tokFlags = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokFlagsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokFlags < tokFlagsEnd) {
                        if (false == tokFlags->flags.flag4IsVariableLength) {
                            if (tokFlags->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokFlags = tokFlags + 1 + tokFlags->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokFlags);
                            switch (tokFlags->id) {
                            default:
                                if (tokFlags->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                                const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokGpu < tokGpuEnd) {
                                    if (false == tokGpu->flags.flag4IsVariableLength) {
                                        switch (tokGpu->id) {
                                        default:
                                            if (tokGpu->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                            dst.Flags.Gpu.CameraCapture = readTokValue<decltype(dst.Flags.Gpu.CameraCapture)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                            dst.Flags.Gpu.CCS = readTokValue<decltype(dst.Flags.Gpu.CCS)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                            dst.Flags.Gpu.ColorDiscard = readTokValue<decltype(dst.Flags.Gpu.ColorDiscard)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                            dst.Flags.Gpu.ColorSeparation = readTokValue<decltype(dst.Flags.Gpu.ColorSeparation)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                            dst.Flags.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.Flags.Gpu.ColorSeparationRGBX)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                            dst.Flags.Gpu.Constant = readTokValue<decltype(dst.Flags.Gpu.Constant)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                            dst.Flags.Gpu.Depth = readTokValue<decltype(dst.Flags.Gpu.Depth)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                            dst.Flags.Gpu.FlipChain = readTokValue<decltype(dst.Flags.Gpu.FlipChain)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                            dst.Flags.Gpu.FlipChainPreferred = readTokValue<decltype(dst.Flags.Gpu.FlipChainPreferred)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                            dst.Flags.Gpu.HistoryBuffer = readTokValue<decltype(dst.Flags.Gpu.HistoryBuffer)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                            dst.Flags.Gpu.HiZ = readTokValue<decltype(dst.Flags.Gpu.HiZ)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                            dst.Flags.Gpu.Index = readTokValue<decltype(dst.Flags.Gpu.Index)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                            dst.Flags.Gpu.IndirectClearColor = readTokValue<decltype(dst.Flags.Gpu.IndirectClearColor)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                            dst.Flags.Gpu.InstructionFlat = readTokValue<decltype(dst.Flags.Gpu.InstructionFlat)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                            dst.Flags.Gpu.InterlacedScan = readTokValue<decltype(dst.Flags.Gpu.InterlacedScan)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                            dst.Flags.Gpu.MCS = readTokValue<decltype(dst.Flags.Gpu.MCS)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                            dst.Flags.Gpu.MMC = readTokValue<decltype(dst.Flags.Gpu.MMC)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                            dst.Flags.Gpu.MotionComp = readTokValue<decltype(dst.Flags.Gpu.MotionComp)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                            dst.Flags.Gpu.NoRestriction = readTokValue<decltype(dst.Flags.Gpu.NoRestriction)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                            dst.Flags.Gpu.Overlay = readTokValue<decltype(dst.Flags.Gpu.Overlay)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                            dst.Flags.Gpu.Presentable = readTokValue<decltype(dst.Flags.Gpu.Presentable)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                            dst.Flags.Gpu.ProceduralTexture = readTokValue<decltype(dst.Flags.Gpu.ProceduralTexture)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                            dst.Flags.Gpu.Query = readTokValue<decltype(dst.Flags.Gpu.Query)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                            dst.Flags.Gpu.RenderTarget = readTokValue<decltype(dst.Flags.Gpu.RenderTarget)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                            dst.Flags.Gpu.S3d = readTokValue<decltype(dst.Flags.Gpu.S3d)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                            dst.Flags.Gpu.S3dDx = readTokValue<decltype(dst.Flags.Gpu.S3dDx)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                            dst.Flags.Gpu.__S3dNonPacked = readTokValue<decltype(dst.Flags.Gpu.__S3dNonPacked)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                            dst.Flags.Gpu.__S3dWidi = readTokValue<decltype(dst.Flags.Gpu.__S3dWidi)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                            dst.Flags.Gpu.ScratchFlat = readTokValue<decltype(dst.Flags.Gpu.ScratchFlat)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                            dst.Flags.Gpu.SeparateStencil = readTokValue<decltype(dst.Flags.Gpu.SeparateStencil)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                            dst.Flags.Gpu.State = readTokValue<decltype(dst.Flags.Gpu.State)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                            dst.Flags.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.Flags.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                            dst.Flags.Gpu.Stream = readTokValue<decltype(dst.Flags.Gpu.Stream)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                            dst.Flags.Gpu.TextApi = readTokValue<decltype(dst.Flags.Gpu.TextApi)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                            dst.Flags.Gpu.Texture = readTokValue<decltype(dst.Flags.Gpu.Texture)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                            dst.Flags.Gpu.TiledResource = readTokValue<decltype(dst.Flags.Gpu.TiledResource)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                            dst.Flags.Gpu.TilePool = readTokValue<decltype(dst.Flags.Gpu.TilePool)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                            dst.Flags.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.Flags.Gpu.UnifiedAuxSurface)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                            dst.Flags.Gpu.Vertex = readTokValue<decltype(dst.Flags.Gpu.Vertex)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                            dst.Flags.Gpu.Video = readTokValue<decltype(dst.Flags.Gpu.Video)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                            dst.Flags.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.Flags.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                            dst.Flags.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.Flags.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                            dst.Flags.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.Flags.Gpu.__MsaaTileMcs)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                            dst.Flags.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.Flags.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                            dst.Flags.Gpu.__Remaining = readTokValue<decltype(dst.Flags.Gpu.__Remaining)>(*tokGpu);
                                        } break;
                                        };
                                        tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                                        if (tokGpu->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokGpu == tokGpuEnd);
                            } break;
                            case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                                const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokInfo < tokInfoEnd) {
                                    if (false == tokInfo->flags.flag4IsVariableLength) {
                                        switch (tokInfo->id) {
                                        default:
                                            if (tokInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                            dst.Flags.Info.AllowVirtualPadding = readTokValue<decltype(dst.Flags.Info.AllowVirtualPadding)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                            dst.Flags.Info.BigPage = readTokValue<decltype(dst.Flags.Info.BigPage)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                            dst.Flags.Info.Cacheable = readTokValue<decltype(dst.Flags.Info.Cacheable)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                            dst.Flags.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.Flags.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                            dst.Flags.Info.CornerTexelMode = readTokValue<decltype(dst.Flags.Info.CornerTexelMode)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                            dst.Flags.Info.ExistingSysMem = readTokValue<decltype(dst.Flags.Info.ExistingSysMem)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                            dst.Flags.Info.ForceResidency = readTokValue<decltype(dst.Flags.Info.ForceResidency)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                            dst.Flags.Info.Gfdt = readTokValue<decltype(dst.Flags.Info.Gfdt)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                            dst.Flags.Info.GttMapType = readTokValue<decltype(dst.Flags.Info.GttMapType)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                            dst.Flags.Info.HardwareProtected = readTokValue<decltype(dst.Flags.Info.HardwareProtected)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                            dst.Flags.Info.KernelModeMapped = readTokValue<decltype(dst.Flags.Info.KernelModeMapped)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                            dst.Flags.Info.LayoutBelow = readTokValue<decltype(dst.Flags.Info.LayoutBelow)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                            dst.Flags.Info.LayoutMono = readTokValue<decltype(dst.Flags.Info.LayoutMono)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                            dst.Flags.Info.LayoutRight = readTokValue<decltype(dst.Flags.Info.LayoutRight)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                            dst.Flags.Info.LocalOnly = readTokValue<decltype(dst.Flags.Info.LocalOnly)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                            dst.Flags.Info.Linear = readTokValue<decltype(dst.Flags.Info.Linear)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                            dst.Flags.Info.MediaCompressed = readTokValue<decltype(dst.Flags.Info.MediaCompressed)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                            dst.Flags.Info.NoOptimizationPadding = readTokValue<decltype(dst.Flags.Info.NoOptimizationPadding)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                            dst.Flags.Info.NoPhysMemory = readTokValue<decltype(dst.Flags.Info.NoPhysMemory)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                            dst.Flags.Info.NotLockable = readTokValue<decltype(dst.Flags.Info.NotLockable)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                            dst.Flags.Info.NonLocalOnly = readTokValue<decltype(dst.Flags.Info.NonLocalOnly)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                            dst.Flags.Info.StdSwizzle = readTokValue<decltype(dst.Flags.Info.StdSwizzle)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                            dst.Flags.Info.PseudoStdSwizzle = readTokValue<decltype(dst.Flags.Info.PseudoStdSwizzle)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                            dst.Flags.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.Flags.Info.Undefined64KBSwizzle)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                            dst.Flags.Info.RedecribedPlanes = readTokValue<decltype(dst.Flags.Info.RedecribedPlanes)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                            dst.Flags.Info.RenderCompressed = readTokValue<decltype(dst.Flags.Info.RenderCompressed)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                            dst.Flags.Info.Rotated = readTokValue<decltype(dst.Flags.Info.Rotated)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                            dst.Flags.Info.Shared = readTokValue<decltype(dst.Flags.Info.Shared)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                            dst.Flags.Info.SoftwareProtected = readTokValue<decltype(dst.Flags.Info.SoftwareProtected)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                            dst.Flags.Info.SVM = readTokValue<decltype(dst.Flags.Info.SVM)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                            dst.Flags.Info.Tile4 = readTokValue<decltype(dst.Flags.Info.Tile4)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                            dst.Flags.Info.Tile64 = readTokValue<decltype(dst.Flags.Info.Tile64)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                            dst.Flags.Info.TiledW = readTokValue<decltype(dst.Flags.Info.TiledW)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                            dst.Flags.Info.TiledX = readTokValue<decltype(dst.Flags.Info.TiledX)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                            dst.Flags.Info.TiledY = readTokValue<decltype(dst.Flags.Info.TiledY)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                            dst.Flags.Info.TiledYf = readTokValue<decltype(dst.Flags.Info.TiledYf)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                            dst.Flags.Info.TiledYs = readTokValue<decltype(dst.Flags.Info.TiledYs)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                            dst.Flags.Info.WddmProtected = readTokValue<decltype(dst.Flags.Info.WddmProtected)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                            dst.Flags.Info.XAdapter = readTokValue<decltype(dst.Flags.Info.XAdapter)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                            dst.Flags.Info.__PreallocatedResInfo = readTokValue<decltype(dst.Flags.Info.__PreallocatedResInfo)>(*tokInfo);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                            dst.Flags.Info.__PreWddm2SVM = readTokValue<decltype(dst.Flags.Info.__PreWddm2SVM)>(*tokInfo);
                                        } break;
                                        };
                                        tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                                        if (tokInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokInfo == tokInfoEnd);
                            } break;
                            case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                                const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokWa < tokWaEnd) {
                                    if (false == tokWa->flags.flag4IsVariableLength) {
                                        switch (tokWa->id) {
                                        default:
                                            if (tokWa->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                            dst.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                            dst.Flags.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.Flags.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                            dst.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                            dst.Flags.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.Flags.Wa.NoBufferSamplerPadding)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                            dst.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                            dst.Flags.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.Flags.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                            dst.Flags.Wa.DisablePackedMipTail = readTokValue<decltype(dst.Flags.Wa.DisablePackedMipTail)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                            dst.Flags.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.Flags.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                            dst.Flags.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.Flags.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                            dst.Flags.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.Flags.Wa.DisableDisplayCcsCompression)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                            dst.Flags.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.Flags.Wa.PreGen12FastClearOnly)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                            dst.Flags.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.Flags.Wa.ForceStdAllocAlign)>(*tokWa);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                            dst.Flags.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.Flags.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                                        } break;
                                        };
                                        tokWa = tokWa + 1 + tokWa->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                                        if (tokWa->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokWa == tokWaEnd);
                            } break;
                            };
                            tokFlags = tokFlags + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokFlags == tokFlagsEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY: {
                    const TokenHeader *tokCachePolicy = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokCachePolicyEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokCachePolicy < tokCachePolicyEnd) {
                        if (false == tokCachePolicy->flags.flag4IsVariableLength) {
                            switch (tokCachePolicy->id) {
                            default:
                                if (tokCachePolicy->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE: {
                                dst.CachePolicy.Usage = readTokValue<decltype(dst.CachePolicy.Usage)>(*tokCachePolicy);
                            } break;
                            };
                            tokCachePolicy = tokCachePolicy + 1 + tokCachePolicy->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCachePolicy);
                            if (tokCachePolicy->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokCachePolicy = tokCachePolicy + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokCachePolicy == tokCachePolicyEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__MSAA: {
                    const TokenHeader *tokMSAA = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokMSAAEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokMSAA < tokMSAAEnd) {
                        if (false == tokMSAA->flags.flag4IsVariableLength) {
                            switch (tokMSAA->id) {
                            default:
                                if (tokMSAA->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                                dst.MSAA.SamplePattern = readTokValue<decltype(dst.MSAA.SamplePattern)>(*tokMSAA);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                                dst.MSAA.NumSamples = readTokValue<decltype(dst.MSAA.NumSamples)>(*tokMSAA);
                            } break;
                            };
                            tokMSAA = tokMSAA + 1 + tokMSAA->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMSAA);
                            if (tokMSAA->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokMSAA = tokMSAA + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokMSAA == tokMSAAEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT: {
                    const TokenHeader *tokAlignment = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokAlignmentEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokAlignment < tokAlignmentEnd) {
                        if (false == tokAlignment->flags.flag4IsVariableLength) {
                            switch (tokAlignment->id) {
                            default:
                                if (tokAlignment->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                                dst.Alignment.ArraySpacingSingleLod = readTokValue<decltype(dst.Alignment.ArraySpacingSingleLod)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                                dst.Alignment.BaseAlignment = readTokValue<decltype(dst.Alignment.BaseAlignment)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                                dst.Alignment.HAlign = readTokValue<decltype(dst.Alignment.HAlign)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                                dst.Alignment.VAlign = readTokValue<decltype(dst.Alignment.VAlign)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                                dst.Alignment.DAlign = readTokValue<decltype(dst.Alignment.DAlign)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                                dst.Alignment.MipTailStartLod = readTokValue<decltype(dst.Alignment.MipTailStartLod)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                                dst.Alignment.PackedMipStartLod = readTokValue<decltype(dst.Alignment.PackedMipStartLod)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                                dst.Alignment.PackedMipWidth = readTokValue<decltype(dst.Alignment.PackedMipWidth)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                                dst.Alignment.PackedMipHeight = readTokValue<decltype(dst.Alignment.PackedMipHeight)>(*tokAlignment);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                                dst.Alignment.QPitch = readTokValue<decltype(dst.Alignment.QPitch)>(*tokAlignment);
                            } break;
                            };
                            tokAlignment = tokAlignment + 1 + tokAlignment->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAlignment);
                            if (tokAlignment->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokAlignment = tokAlignment + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokAlignment == tokAlignmentEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO: {
                    const TokenHeader *tokOffsetInfo = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokOffsetInfo < tokOffsetInfoEnd) {
                        if (false == tokOffsetInfo->flags.flag4IsVariableLength) {
                            if (tokOffsetInfo->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokOffsetInfo = tokOffsetInfo + 1 + tokOffsetInfo->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOffsetInfo);
                            switch (tokOffsetInfo->id) {
                            default:
                                if (tokOffsetInfo->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                                const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                                    if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                                        switch (tokTexture3DOffsetInfo->id) {
                                        default:
                                            if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                            dst.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                                        } break;
                                        case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.OffsetInfo.Texture3DOffsetInfo.Offset)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(dst.OffsetInfo.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.OffsetInfo.Texture3DOffsetInfo.Offset));
                                        } break;
                                        };
                                        tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                                        if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                            } break;
                            case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                                const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                                    if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                                        switch (tokTexture2DOffsetInfo->id) {
                                        default:
                                            if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                            dst.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                                        } break;
                                        case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                            dst.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                                        } break;
                                        case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.OffsetInfo.Texture2DOffsetInfo.Offset)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(dst.OffsetInfo.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.OffsetInfo.Texture2DOffsetInfo.Offset));
                                        } break;
                                        };
                                        tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                                        if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                            } break;
                            case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                                const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlane < tokPlaneEnd) {
                                    if (false == tokPlane->flags.flag4IsVariableLength) {
                                        switch (tokPlane->id) {
                                        default:
                                            if (tokPlane->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                            dst.OffsetInfo.Plane.ArrayQPitch = readTokValue<decltype(dst.OffsetInfo.Plane.ArrayQPitch)>(*tokPlane);
                                        } break;
                                        case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.OffsetInfo.Plane.X)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.OffsetInfo.Plane.X, sizeof(dst.OffsetInfo.Plane.X), srcData, sizeof(dst.OffsetInfo.Plane.X));
                                        } break;
                                        case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.OffsetInfo.Plane.Y)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.OffsetInfo.Plane.Y, sizeof(dst.OffsetInfo.Plane.Y), srcData, sizeof(dst.OffsetInfo.Plane.Y));
                                        } break;
                                        case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                            dst.OffsetInfo.Plane.NoOfPlanes = readTokValue<decltype(dst.OffsetInfo.Plane.NoOfPlanes)>(*tokPlane);
                                        } break;
                                        case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                            dst.OffsetInfo.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.OffsetInfo.Plane.IsTileAlignedPlanes)>(*tokPlane);
                                        } break;
                                        };
                                        tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                                        switch (tokPlane->id) {
                                        default:
                                            if (tokPlane->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                            const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokUnAligned < tokUnAlignedEnd) {
                                                if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                                    switch (tokUnAligned->id) {
                                                    default:
                                                        if (tokUnAligned->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.OffsetInfo.Plane.UnAligned.Height)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.OffsetInfo.Plane.UnAligned.Height, sizeof(dst.OffsetInfo.Plane.UnAligned.Height), srcData, sizeof(dst.OffsetInfo.Plane.UnAligned.Height));
                                                    } break;
                                                    };
                                                    tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                                    if (tokUnAligned->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                                        } break;
                                        };
                                        tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlane == tokPlaneEnd);
                            } break;
                            };
                            tokOffsetInfo = tokOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokOffsetInfo == tokOffsetInfoEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__S3D: {
                    const TokenHeader *tokS3d = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokS3dEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokS3d < tokS3dEnd) {
                        if (false == tokS3d->flags.flag4IsVariableLength) {
                            switch (tokS3d->id) {
                            default:
                                if (tokS3d->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                                dst.S3d.DisplayModeHeight = readTokValue<decltype(dst.S3d.DisplayModeHeight)>(*tokS3d);
                            } break;
                            case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                                dst.S3d.NumBlankActiveLines = readTokValue<decltype(dst.S3d.NumBlankActiveLines)>(*tokS3d);
                            } break;
                            case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                                dst.S3d.RFrameOffset = readTokValue<decltype(dst.S3d.RFrameOffset)>(*tokS3d);
                            } break;
                            case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                                dst.S3d.BlankAreaOffset = readTokValue<decltype(dst.S3d.BlankAreaOffset)>(*tokS3d);
                            } break;
                            case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                                dst.S3d.TallBufferHeight = readTokValue<decltype(dst.S3d.TallBufferHeight)>(*tokS3d);
                            } break;
                            case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                                dst.S3d.TallBufferSize = readTokValue<decltype(dst.S3d.TallBufferSize)>(*tokS3d);
                            } break;
                            case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                                dst.S3d.IsRFrame = readTokValue<decltype(dst.S3d.IsRFrame)>(*tokS3d);
                            } break;
                            };
                            tokS3d = tokS3d + 1 + tokS3d->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokS3d);
                            if (tokS3d->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokS3d = tokS3d + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokS3d == tokS3dEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE: {
                    const TokenHeader *tokSegmentOverride = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSegmentOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSegmentOverride < tokSegmentOverrideEnd) {
                        if (false == tokSegmentOverride->flags.flag4IsVariableLength) {
                            switch (tokSegmentOverride->id) {
                            default:
                                if (tokSegmentOverride->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1: {
                                dst.SegmentOverride.Seg1 = readTokValue<decltype(dst.SegmentOverride.Seg1)>(*tokSegmentOverride);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT: {
                                dst.SegmentOverride.Evict = readTokValue<decltype(dst.SegmentOverride.Evict)>(*tokSegmentOverride);
                            } break;
                            };
                            tokSegmentOverride = tokSegmentOverride + 1 + tokSegmentOverride->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSegmentOverride);
                            if (tokSegmentOverride->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokSegmentOverride = tokSegmentOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSegmentOverride == tokSegmentOverrideEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM: {
#if _DEBUG || _RELEASE_INTERNAL
                    const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokPlatform < tokPlatformEnd) {
                        if (false == tokPlatform->flags.flag4IsVariableLength) {
                            switch (tokPlatform->id) {
                            default:
                                if (tokPlatform->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                dst.Platform.eProductFamily = readTokValue<decltype(dst.Platform.eProductFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                dst.Platform.ePCHProductFamily = readTokValue<decltype(dst.Platform.ePCHProductFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                dst.Platform.eDisplayCoreFamily = readTokValue<decltype(dst.Platform.eDisplayCoreFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                dst.Platform.eRenderCoreFamily = readTokValue<decltype(dst.Platform.eRenderCoreFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                dst.Platform.ePlatformType = readTokValue<decltype(dst.Platform.ePlatformType)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                dst.Platform.usDeviceID = readTokValue<decltype(dst.Platform.usDeviceID)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                dst.Platform.usRevId = readTokValue<decltype(dst.Platform.usRevId)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                dst.Platform.usDeviceID_PCH = readTokValue<decltype(dst.Platform.usDeviceID_PCH)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                dst.Platform.usRevId_PCH = readTokValue<decltype(dst.Platform.usRevId_PCH)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                dst.Platform.eGTType = readTokValue<decltype(dst.Platform.eGTType)>(*tokPlatform);
                            } break;
                            };
                            tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                            if (tokPlatform->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM: {
                    const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokExistingSysMem < tokExistingSysMemEnd) {
                        if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                            switch (tokExistingSysMem->id) {
                            default:
                                if (tokExistingSysMem->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED: {
                                dst.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED: {
                                dst.ExistingSysMem.IsPageAligned = readTokValue<decltype(dst.ExistingSysMem.IsPageAligned)>(*tokExistingSysMem);
                            } break;
                            };
                            tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                            if (tokExistingSysMem->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                } break;
                case TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM: {
#if !(_DEBUG || _RELEASE_INTERNAL)
                    const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokPlatform < tokPlatformEnd) {
                        if (false == tokPlatform->flags.flag4IsVariableLength) {
                            switch (tokPlatform->id) {
                            default:
                                if (tokPlatform->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                dst.__Platform.eProductFamily = readTokValue<decltype(dst.__Platform.eProductFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                dst.__Platform.ePCHProductFamily = readTokValue<decltype(dst.__Platform.ePCHProductFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                dst.__Platform.eDisplayCoreFamily = readTokValue<decltype(dst.__Platform.eDisplayCoreFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                dst.__Platform.eRenderCoreFamily = readTokValue<decltype(dst.__Platform.eRenderCoreFamily)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                dst.__Platform.ePlatformType = readTokValue<decltype(dst.__Platform.ePlatformType)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                dst.__Platform.usDeviceID = readTokValue<decltype(dst.__Platform.usDeviceID)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                dst.__Platform.usRevId = readTokValue<decltype(dst.__Platform.usRevId)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                dst.__Platform.usDeviceID_PCH = readTokValue<decltype(dst.__Platform.usDeviceID_PCH)>(*tokPlatform);
                            } break;
                            case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                dst.__Platform.usRevId_PCH = readTokValue<decltype(dst.__Platform.usRevId_PCH)>(*tokPlatform);
                            } break;
                            case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                dst.__Platform.eGTType = readTokValue<decltype(dst.__Platform.eGTType)>(*tokPlatform);
                            } break;
                            };
                            tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                            if (tokPlatform->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_EXISTING_SYS_MEM_REC> {
    template <typename GMM_EXISTING_SYS_MEM_RECT>
    static bool demarshall(GMM_EXISTING_SYS_MEM_RECT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_EXISTING_SYS_MEM: {
                    dst.pExistingSysMem = readTokValue<decltype(dst.pExistingSysMem)>(*tok);
                } break;
                case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_VIRT_ADDRESS: {
                    dst.pVirtAddress = readTokValue<decltype(dst.pVirtAddress)>(*tok);
                } break;
                case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_GFX_ALIGNED_VIRT_ADDRESS: {
                    dst.pGfxAlignedVirtAddress = readTokValue<decltype(dst.pGfxAlignedVirtAddress)>(*tok);
                } break;
                case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__SIZE: {
                    dst.Size = readTokValue<decltype(dst.Size)>(*tok);
                } break;
                case TOK_FBC_GMM_EXISTING_SYS_MEM_REC__IS_GMM_ALLOCATED: {
                    dst.IsGmmAllocated = readTokValue<decltype(dst.IsGmmAllocated)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_EXISTING_SYS_MEM_REC:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_RESOURCE_INFO_COMMON_STRUCT> {
    template <typename GmmResourceInfoCommonStructT>
    static bool demarshall(GmmResourceInfoCommonStructT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_FE_GMM_RESOURCE_INFO_COMMON_STRUCT__CLIENT_TYPE: {
                    dst.ClientType = readTokValue<decltype(dst.ClientType)>(*tok);
                } break;
                case TOK_FBD_GMM_RESOURCE_INFO_COMMON_STRUCT__ROTATE_INFO: {
                    dst.RotateInfo = readTokValue<decltype(dst.RotateInfo)>(*tok);
                } break;
                case TOK_FBQ_GMM_RESOURCE_INFO_COMMON_STRUCT__SVM_ADDRESS: {
                    dst.SvmAddress = readTokValue<decltype(dst.SvmAddress)>(*tok);
                } break;
                case TOK_FBQ_GMM_RESOURCE_INFO_COMMON_STRUCT__P_PRIVATE_DATA: {
                    dst.pPrivateData = readTokValue<decltype(dst.pPrivateData)>(*tok);
                } break;
                };
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_RESOURCE_INFO_COMMON_STRUCT:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__SURF: {
                    const TokenHeader *tokSurf = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokSurfEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokSurf < tokSurfEnd) {
                        if (false == tokSurf->flags.flag4IsVariableLength) {
                            switch (tokSurf->id) {
                            default:
                                if (tokSurf->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                                dst.Surf.Type = readTokValue<decltype(dst.Surf.Type)>(*tokSurf);
                            } break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                                dst.Surf.Format = readTokValue<decltype(dst.Surf.Format)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                                dst.Surf.BitsPerPixel = readTokValue<decltype(dst.Surf.BitsPerPixel)>(*tokSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                                dst.Surf.BaseWidth = readTokValue<decltype(dst.Surf.BaseWidth)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                                dst.Surf.BaseHeight = readTokValue<decltype(dst.Surf.BaseHeight)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                                dst.Surf.Depth = readTokValue<decltype(dst.Surf.Depth)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                                dst.Surf.MaxLod = readTokValue<decltype(dst.Surf.MaxLod)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                                dst.Surf.ArraySize = readTokValue<decltype(dst.Surf.ArraySize)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                                dst.Surf.CpTag = readTokValue<decltype(dst.Surf.CpTag)>(*tokSurf);
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.Surf.MmcMode)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.Surf.MmcMode, sizeof(dst.Surf.MmcMode), srcData, sizeof(dst.Surf.MmcMode));
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.Surf.MmcHint)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.Surf.MmcHint, sizeof(dst.Surf.MmcHint), srcData, sizeof(dst.Surf.MmcHint));
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                                dst.Surf.Pitch = readTokValue<decltype(dst.Surf.Pitch)>(*tokSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                                dst.Surf.OverridePitch = readTokValue<decltype(dst.Surf.OverridePitch)>(*tokSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                                dst.Surf.Size = readTokValue<decltype(dst.Surf.Size)>(*tokSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                                dst.Surf.CCSize = readTokValue<decltype(dst.Surf.CCSize)>(*tokSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                                dst.Surf.UnpaddedSize = readTokValue<decltype(dst.Surf.UnpaddedSize)>(*tokSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                                dst.Surf.SizeReportToOS = readTokValue<decltype(dst.Surf.SizeReportToOS)>(*tokSurf);
                            } break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                                dst.Surf.TileMode = readTokValue<decltype(dst.Surf.TileMode)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN: {
                                dst.Surf.CCSModeAlign = readTokValue<decltype(dst.Surf.CCSModeAlign)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS: {
                                dst.Surf.LegacyFlags = readTokValue<decltype(dst.Surf.LegacyFlags)>(*tokSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH: {
                                dst.Surf.MaximumRenamingListLength = readTokValue<decltype(dst.Surf.MaximumRenamingListLength)>(*tokSurf);
                            } break;
                            };
                            tokSurf = tokSurf + 1 + tokSurf->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSurf);
                            switch (tokSurf->id) {
                            default:
                                if (tokSurf->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS: {
                                const TokenHeader *tokFlags = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokFlagsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokFlags < tokFlagsEnd) {
                                    if (false == tokFlags->flags.flag4IsVariableLength) {
                                        if (tokFlags->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokFlags = tokFlags + 1 + tokFlags->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokFlags);
                                        switch (tokFlags->id) {
                                        default:
                                            if (tokFlags->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                                            const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokGpu < tokGpuEnd) {
                                                if (false == tokGpu->flags.flag4IsVariableLength) {
                                                    switch (tokGpu->id) {
                                                    default:
                                                        if (tokGpu->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                                        dst.Surf.Flags.Gpu.CameraCapture = readTokValue<decltype(dst.Surf.Flags.Gpu.CameraCapture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                                        dst.Surf.Flags.Gpu.CCS = readTokValue<decltype(dst.Surf.Flags.Gpu.CCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                                        dst.Surf.Flags.Gpu.ColorDiscard = readTokValue<decltype(dst.Surf.Flags.Gpu.ColorDiscard)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                                        dst.Surf.Flags.Gpu.ColorSeparation = readTokValue<decltype(dst.Surf.Flags.Gpu.ColorSeparation)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                                        dst.Surf.Flags.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.Surf.Flags.Gpu.ColorSeparationRGBX)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                                        dst.Surf.Flags.Gpu.Constant = readTokValue<decltype(dst.Surf.Flags.Gpu.Constant)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                                        dst.Surf.Flags.Gpu.Depth = readTokValue<decltype(dst.Surf.Flags.Gpu.Depth)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                                        dst.Surf.Flags.Gpu.FlipChain = readTokValue<decltype(dst.Surf.Flags.Gpu.FlipChain)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                                        dst.Surf.Flags.Gpu.FlipChainPreferred = readTokValue<decltype(dst.Surf.Flags.Gpu.FlipChainPreferred)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                                        dst.Surf.Flags.Gpu.HistoryBuffer = readTokValue<decltype(dst.Surf.Flags.Gpu.HistoryBuffer)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                                        dst.Surf.Flags.Gpu.HiZ = readTokValue<decltype(dst.Surf.Flags.Gpu.HiZ)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                                        dst.Surf.Flags.Gpu.Index = readTokValue<decltype(dst.Surf.Flags.Gpu.Index)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                                        dst.Surf.Flags.Gpu.IndirectClearColor = readTokValue<decltype(dst.Surf.Flags.Gpu.IndirectClearColor)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                                        dst.Surf.Flags.Gpu.InstructionFlat = readTokValue<decltype(dst.Surf.Flags.Gpu.InstructionFlat)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                                        dst.Surf.Flags.Gpu.InterlacedScan = readTokValue<decltype(dst.Surf.Flags.Gpu.InterlacedScan)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                                        dst.Surf.Flags.Gpu.MCS = readTokValue<decltype(dst.Surf.Flags.Gpu.MCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                                        dst.Surf.Flags.Gpu.MMC = readTokValue<decltype(dst.Surf.Flags.Gpu.MMC)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                                        dst.Surf.Flags.Gpu.MotionComp = readTokValue<decltype(dst.Surf.Flags.Gpu.MotionComp)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                                        dst.Surf.Flags.Gpu.NoRestriction = readTokValue<decltype(dst.Surf.Flags.Gpu.NoRestriction)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                                        dst.Surf.Flags.Gpu.Overlay = readTokValue<decltype(dst.Surf.Flags.Gpu.Overlay)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                                        dst.Surf.Flags.Gpu.Presentable = readTokValue<decltype(dst.Surf.Flags.Gpu.Presentable)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                                        dst.Surf.Flags.Gpu.ProceduralTexture = readTokValue<decltype(dst.Surf.Flags.Gpu.ProceduralTexture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                                        dst.Surf.Flags.Gpu.Query = readTokValue<decltype(dst.Surf.Flags.Gpu.Query)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                                        dst.Surf.Flags.Gpu.RenderTarget = readTokValue<decltype(dst.Surf.Flags.Gpu.RenderTarget)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                                        dst.Surf.Flags.Gpu.S3d = readTokValue<decltype(dst.Surf.Flags.Gpu.S3d)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                                        dst.Surf.Flags.Gpu.S3dDx = readTokValue<decltype(dst.Surf.Flags.Gpu.S3dDx)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                                        dst.Surf.Flags.Gpu.__S3dNonPacked = readTokValue<decltype(dst.Surf.Flags.Gpu.__S3dNonPacked)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                                        dst.Surf.Flags.Gpu.__S3dWidi = readTokValue<decltype(dst.Surf.Flags.Gpu.__S3dWidi)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                                        dst.Surf.Flags.Gpu.ScratchFlat = readTokValue<decltype(dst.Surf.Flags.Gpu.ScratchFlat)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                                        dst.Surf.Flags.Gpu.SeparateStencil = readTokValue<decltype(dst.Surf.Flags.Gpu.SeparateStencil)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                                        dst.Surf.Flags.Gpu.State = readTokValue<decltype(dst.Surf.Flags.Gpu.State)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                                        dst.Surf.Flags.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.Surf.Flags.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                                        dst.Surf.Flags.Gpu.Stream = readTokValue<decltype(dst.Surf.Flags.Gpu.Stream)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                                        dst.Surf.Flags.Gpu.TextApi = readTokValue<decltype(dst.Surf.Flags.Gpu.TextApi)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                                        dst.Surf.Flags.Gpu.Texture = readTokValue<decltype(dst.Surf.Flags.Gpu.Texture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                                        dst.Surf.Flags.Gpu.TiledResource = readTokValue<decltype(dst.Surf.Flags.Gpu.TiledResource)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                                        dst.Surf.Flags.Gpu.TilePool = readTokValue<decltype(dst.Surf.Flags.Gpu.TilePool)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                                        dst.Surf.Flags.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.Surf.Flags.Gpu.UnifiedAuxSurface)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                                        dst.Surf.Flags.Gpu.Vertex = readTokValue<decltype(dst.Surf.Flags.Gpu.Vertex)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                                        dst.Surf.Flags.Gpu.Video = readTokValue<decltype(dst.Surf.Flags.Gpu.Video)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                                        dst.Surf.Flags.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.Surf.Flags.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                                        dst.Surf.Flags.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.Surf.Flags.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                                        dst.Surf.Flags.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.Surf.Flags.Gpu.__MsaaTileMcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                                        dst.Surf.Flags.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.Surf.Flags.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                                        dst.Surf.Flags.Gpu.__Remaining = readTokValue<decltype(dst.Surf.Flags.Gpu.__Remaining)>(*tokGpu);
                                                    } break;
                                                    };
                                                    tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                                                    if (tokGpu->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokGpu == tokGpuEnd);
                                        } break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                                            const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokInfo < tokInfoEnd) {
                                                if (false == tokInfo->flags.flag4IsVariableLength) {
                                                    switch (tokInfo->id) {
                                                    default:
                                                        if (tokInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                                        dst.Surf.Flags.Info.AllowVirtualPadding = readTokValue<decltype(dst.Surf.Flags.Info.AllowVirtualPadding)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                                        dst.Surf.Flags.Info.BigPage = readTokValue<decltype(dst.Surf.Flags.Info.BigPage)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                                        dst.Surf.Flags.Info.Cacheable = readTokValue<decltype(dst.Surf.Flags.Info.Cacheable)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                                        dst.Surf.Flags.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.Surf.Flags.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                                        dst.Surf.Flags.Info.CornerTexelMode = readTokValue<decltype(dst.Surf.Flags.Info.CornerTexelMode)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                                        dst.Surf.Flags.Info.ExistingSysMem = readTokValue<decltype(dst.Surf.Flags.Info.ExistingSysMem)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                                        dst.Surf.Flags.Info.ForceResidency = readTokValue<decltype(dst.Surf.Flags.Info.ForceResidency)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                                        dst.Surf.Flags.Info.Gfdt = readTokValue<decltype(dst.Surf.Flags.Info.Gfdt)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                                        dst.Surf.Flags.Info.GttMapType = readTokValue<decltype(dst.Surf.Flags.Info.GttMapType)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                                        dst.Surf.Flags.Info.HardwareProtected = readTokValue<decltype(dst.Surf.Flags.Info.HardwareProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                                        dst.Surf.Flags.Info.KernelModeMapped = readTokValue<decltype(dst.Surf.Flags.Info.KernelModeMapped)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                                        dst.Surf.Flags.Info.LayoutBelow = readTokValue<decltype(dst.Surf.Flags.Info.LayoutBelow)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                                        dst.Surf.Flags.Info.LayoutMono = readTokValue<decltype(dst.Surf.Flags.Info.LayoutMono)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                                        dst.Surf.Flags.Info.LayoutRight = readTokValue<decltype(dst.Surf.Flags.Info.LayoutRight)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                                        dst.Surf.Flags.Info.LocalOnly = readTokValue<decltype(dst.Surf.Flags.Info.LocalOnly)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                                        dst.Surf.Flags.Info.Linear = readTokValue<decltype(dst.Surf.Flags.Info.Linear)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                                        dst.Surf.Flags.Info.MediaCompressed = readTokValue<decltype(dst.Surf.Flags.Info.MediaCompressed)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                                        dst.Surf.Flags.Info.NoOptimizationPadding = readTokValue<decltype(dst.Surf.Flags.Info.NoOptimizationPadding)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                                        dst.Surf.Flags.Info.NoPhysMemory = readTokValue<decltype(dst.Surf.Flags.Info.NoPhysMemory)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                                        dst.Surf.Flags.Info.NotLockable = readTokValue<decltype(dst.Surf.Flags.Info.NotLockable)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                                        dst.Surf.Flags.Info.NonLocalOnly = readTokValue<decltype(dst.Surf.Flags.Info.NonLocalOnly)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                                        dst.Surf.Flags.Info.StdSwizzle = readTokValue<decltype(dst.Surf.Flags.Info.StdSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                                        dst.Surf.Flags.Info.PseudoStdSwizzle = readTokValue<decltype(dst.Surf.Flags.Info.PseudoStdSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                                        dst.Surf.Flags.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.Surf.Flags.Info.Undefined64KBSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                                        dst.Surf.Flags.Info.RedecribedPlanes = readTokValue<decltype(dst.Surf.Flags.Info.RedecribedPlanes)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                                        dst.Surf.Flags.Info.RenderCompressed = readTokValue<decltype(dst.Surf.Flags.Info.RenderCompressed)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                                        dst.Surf.Flags.Info.Rotated = readTokValue<decltype(dst.Surf.Flags.Info.Rotated)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                                        dst.Surf.Flags.Info.Shared = readTokValue<decltype(dst.Surf.Flags.Info.Shared)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                                        dst.Surf.Flags.Info.SoftwareProtected = readTokValue<decltype(dst.Surf.Flags.Info.SoftwareProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                                        dst.Surf.Flags.Info.SVM = readTokValue<decltype(dst.Surf.Flags.Info.SVM)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                                        dst.Surf.Flags.Info.Tile4 = readTokValue<decltype(dst.Surf.Flags.Info.Tile4)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                                        dst.Surf.Flags.Info.Tile64 = readTokValue<decltype(dst.Surf.Flags.Info.Tile64)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                                        dst.Surf.Flags.Info.TiledW = readTokValue<decltype(dst.Surf.Flags.Info.TiledW)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                                        dst.Surf.Flags.Info.TiledX = readTokValue<decltype(dst.Surf.Flags.Info.TiledX)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                                        dst.Surf.Flags.Info.TiledY = readTokValue<decltype(dst.Surf.Flags.Info.TiledY)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                                        dst.Surf.Flags.Info.TiledYf = readTokValue<decltype(dst.Surf.Flags.Info.TiledYf)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                                        dst.Surf.Flags.Info.TiledYs = readTokValue<decltype(dst.Surf.Flags.Info.TiledYs)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                                        dst.Surf.Flags.Info.WddmProtected = readTokValue<decltype(dst.Surf.Flags.Info.WddmProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                                        dst.Surf.Flags.Info.XAdapter = readTokValue<decltype(dst.Surf.Flags.Info.XAdapter)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                                        dst.Surf.Flags.Info.__PreallocatedResInfo = readTokValue<decltype(dst.Surf.Flags.Info.__PreallocatedResInfo)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                                        dst.Surf.Flags.Info.__PreWddm2SVM = readTokValue<decltype(dst.Surf.Flags.Info.__PreWddm2SVM)>(*tokInfo);
                                                    } break;
                                                    };
                                                    tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                                                    if (tokInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokInfo == tokInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                                            const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokWa < tokWaEnd) {
                                                if (false == tokWa->flags.flag4IsVariableLength) {
                                                    switch (tokWa->id) {
                                                    default:
                                                        if (tokWa->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                                        dst.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                                        dst.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                                        dst.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                                        dst.Surf.Flags.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.Surf.Flags.Wa.NoBufferSamplerPadding)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                                        dst.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                                        dst.Surf.Flags.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.Surf.Flags.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                                        dst.Surf.Flags.Wa.DisablePackedMipTail = readTokValue<decltype(dst.Surf.Flags.Wa.DisablePackedMipTail)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                                        dst.Surf.Flags.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.Surf.Flags.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                                        dst.Surf.Flags.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.Surf.Flags.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                                        dst.Surf.Flags.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.Surf.Flags.Wa.DisableDisplayCcsCompression)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                                        dst.Surf.Flags.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.Surf.Flags.Wa.PreGen12FastClearOnly)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                                        dst.Surf.Flags.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.Surf.Flags.Wa.ForceStdAllocAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                                        dst.Surf.Flags.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.Surf.Flags.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                                                    } break;
                                                    };
                                                    tokWa = tokWa + 1 + tokWa->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                                                    if (tokWa->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokWa == tokWaEnd);
                                        } break;
                                        };
                                        tokFlags = tokFlags + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokFlags == tokFlagsEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY: {
                                const TokenHeader *tokCachePolicy = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokCachePolicyEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokCachePolicy < tokCachePolicyEnd) {
                                    if (false == tokCachePolicy->flags.flag4IsVariableLength) {
                                        switch (tokCachePolicy->id) {
                                        default:
                                            if (tokCachePolicy->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE: {
                                            dst.Surf.CachePolicy.Usage = readTokValue<decltype(dst.Surf.CachePolicy.Usage)>(*tokCachePolicy);
                                        } break;
                                        };
                                        tokCachePolicy = tokCachePolicy + 1 + tokCachePolicy->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCachePolicy);
                                        if (tokCachePolicy->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokCachePolicy = tokCachePolicy + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokCachePolicy == tokCachePolicyEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__MSAA: {
                                const TokenHeader *tokMSAA = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokMSAAEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokMSAA < tokMSAAEnd) {
                                    if (false == tokMSAA->flags.flag4IsVariableLength) {
                                        switch (tokMSAA->id) {
                                        default:
                                            if (tokMSAA->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                                            dst.Surf.MSAA.SamplePattern = readTokValue<decltype(dst.Surf.MSAA.SamplePattern)>(*tokMSAA);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                                            dst.Surf.MSAA.NumSamples = readTokValue<decltype(dst.Surf.MSAA.NumSamples)>(*tokMSAA);
                                        } break;
                                        };
                                        tokMSAA = tokMSAA + 1 + tokMSAA->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMSAA);
                                        if (tokMSAA->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokMSAA = tokMSAA + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokMSAA == tokMSAAEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT: {
                                const TokenHeader *tokAlignment = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokAlignmentEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokAlignment < tokAlignmentEnd) {
                                    if (false == tokAlignment->flags.flag4IsVariableLength) {
                                        switch (tokAlignment->id) {
                                        default:
                                            if (tokAlignment->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                                            dst.Surf.Alignment.ArraySpacingSingleLod = readTokValue<decltype(dst.Surf.Alignment.ArraySpacingSingleLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                                            dst.Surf.Alignment.BaseAlignment = readTokValue<decltype(dst.Surf.Alignment.BaseAlignment)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                                            dst.Surf.Alignment.HAlign = readTokValue<decltype(dst.Surf.Alignment.HAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                                            dst.Surf.Alignment.VAlign = readTokValue<decltype(dst.Surf.Alignment.VAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                                            dst.Surf.Alignment.DAlign = readTokValue<decltype(dst.Surf.Alignment.DAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                                            dst.Surf.Alignment.MipTailStartLod = readTokValue<decltype(dst.Surf.Alignment.MipTailStartLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                                            dst.Surf.Alignment.PackedMipStartLod = readTokValue<decltype(dst.Surf.Alignment.PackedMipStartLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                                            dst.Surf.Alignment.PackedMipWidth = readTokValue<decltype(dst.Surf.Alignment.PackedMipWidth)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                                            dst.Surf.Alignment.PackedMipHeight = readTokValue<decltype(dst.Surf.Alignment.PackedMipHeight)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                                            dst.Surf.Alignment.QPitch = readTokValue<decltype(dst.Surf.Alignment.QPitch)>(*tokAlignment);
                                        } break;
                                        };
                                        tokAlignment = tokAlignment + 1 + tokAlignment->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAlignment);
                                        if (tokAlignment->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokAlignment = tokAlignment + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokAlignment == tokAlignmentEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO: {
                                const TokenHeader *tokOffsetInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokOffsetInfo < tokOffsetInfoEnd) {
                                    if (false == tokOffsetInfo->flags.flag4IsVariableLength) {
                                        if (tokOffsetInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokOffsetInfo = tokOffsetInfo + 1 + tokOffsetInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOffsetInfo);
                                        switch (tokOffsetInfo->id) {
                                        default:
                                            if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                                            const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                                                if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                                                    switch (tokTexture3DOffsetInfo->id) {
                                                    default:
                                                        if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                                        dst.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.Surf.OffsetInfo.Texture3DOffsetInfo.Offset)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.Surf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(dst.Surf.OffsetInfo.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.Surf.OffsetInfo.Texture3DOffsetInfo.Offset));
                                                    } break;
                                                    };
                                                    tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                                                    if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                                            const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                                                if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                                                    switch (tokTexture2DOffsetInfo->id) {
                                                    default:
                                                        if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                                        dst.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                                        dst.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.Surf.OffsetInfo.Texture2DOffsetInfo.Offset)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.Surf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(dst.Surf.OffsetInfo.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.Surf.OffsetInfo.Texture2DOffsetInfo.Offset));
                                                    } break;
                                                    };
                                                    tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                                                    if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                                            const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlane < tokPlaneEnd) {
                                                if (false == tokPlane->flags.flag4IsVariableLength) {
                                                    switch (tokPlane->id) {
                                                    default:
                                                        if (tokPlane->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                                        dst.Surf.OffsetInfo.Plane.ArrayQPitch = readTokValue<decltype(dst.Surf.OffsetInfo.Plane.ArrayQPitch)>(*tokPlane);
                                                    } break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.Surf.OffsetInfo.Plane.X)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.Surf.OffsetInfo.Plane.X, sizeof(dst.Surf.OffsetInfo.Plane.X), srcData, sizeof(dst.Surf.OffsetInfo.Plane.X));
                                                    } break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.Surf.OffsetInfo.Plane.Y)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.Surf.OffsetInfo.Plane.Y, sizeof(dst.Surf.OffsetInfo.Plane.Y), srcData, sizeof(dst.Surf.OffsetInfo.Plane.Y));
                                                    } break;
                                                    case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                                        dst.Surf.OffsetInfo.Plane.NoOfPlanes = readTokValue<decltype(dst.Surf.OffsetInfo.Plane.NoOfPlanes)>(*tokPlane);
                                                    } break;
                                                    case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                                        dst.Surf.OffsetInfo.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.Surf.OffsetInfo.Plane.IsTileAlignedPlanes)>(*tokPlane);
                                                    } break;
                                                    };
                                                    tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                                                    switch (tokPlane->id) {
                                                    default:
                                                        if (tokPlane->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                                        const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokUnAligned < tokUnAlignedEnd) {
                                                            if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                                                switch (tokUnAligned->id) {
                                                                default:
                                                                    if (tokUnAligned->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.Surf.OffsetInfo.Plane.UnAligned.Height)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.Surf.OffsetInfo.Plane.UnAligned.Height, sizeof(dst.Surf.OffsetInfo.Plane.UnAligned.Height), srcData, sizeof(dst.Surf.OffsetInfo.Plane.UnAligned.Height));
                                                                } break;
                                                                };
                                                                tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                                                if (tokUnAligned->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                                                    } break;
                                                    };
                                                    tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlane == tokPlaneEnd);
                                        } break;
                                        };
                                        tokOffsetInfo = tokOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokOffsetInfo == tokOffsetInfoEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__S3D: {
                                const TokenHeader *tokS3d = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokS3dEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokS3d < tokS3dEnd) {
                                    if (false == tokS3d->flags.flag4IsVariableLength) {
                                        switch (tokS3d->id) {
                                        default:
                                            if (tokS3d->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                                            dst.Surf.S3d.DisplayModeHeight = readTokValue<decltype(dst.Surf.S3d.DisplayModeHeight)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                                            dst.Surf.S3d.NumBlankActiveLines = readTokValue<decltype(dst.Surf.S3d.NumBlankActiveLines)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                                            dst.Surf.S3d.RFrameOffset = readTokValue<decltype(dst.Surf.S3d.RFrameOffset)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                                            dst.Surf.S3d.BlankAreaOffset = readTokValue<decltype(dst.Surf.S3d.BlankAreaOffset)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                                            dst.Surf.S3d.TallBufferHeight = readTokValue<decltype(dst.Surf.S3d.TallBufferHeight)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                                            dst.Surf.S3d.TallBufferSize = readTokValue<decltype(dst.Surf.S3d.TallBufferSize)>(*tokS3d);
                                        } break;
                                        case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                                            dst.Surf.S3d.IsRFrame = readTokValue<decltype(dst.Surf.S3d.IsRFrame)>(*tokS3d);
                                        } break;
                                        };
                                        tokS3d = tokS3d + 1 + tokS3d->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokS3d);
                                        if (tokS3d->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokS3d = tokS3d + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokS3d == tokS3dEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE: {
                                const TokenHeader *tokSegmentOverride = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSegmentOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSegmentOverride < tokSegmentOverrideEnd) {
                                    if (false == tokSegmentOverride->flags.flag4IsVariableLength) {
                                        switch (tokSegmentOverride->id) {
                                        default:
                                            if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1: {
                                            dst.Surf.SegmentOverride.Seg1 = readTokValue<decltype(dst.Surf.SegmentOverride.Seg1)>(*tokSegmentOverride);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT: {
                                            dst.Surf.SegmentOverride.Evict = readTokValue<decltype(dst.Surf.SegmentOverride.Evict)>(*tokSegmentOverride);
                                        } break;
                                        };
                                        tokSegmentOverride = tokSegmentOverride + 1 + tokSegmentOverride->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSegmentOverride);
                                        if (tokSegmentOverride->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSegmentOverride = tokSegmentOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSegmentOverride == tokSegmentOverrideEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM: {
#if _DEBUG || _RELEASE_INTERNAL
                                const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlatform < tokPlatformEnd) {
                                    if (false == tokPlatform->flags.flag4IsVariableLength) {
                                        switch (tokPlatform->id) {
                                        default:
                                            if (tokPlatform->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                            dst.Surf.Platform.eProductFamily = readTokValue<decltype(dst.Surf.Platform.eProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                            dst.Surf.Platform.ePCHProductFamily = readTokValue<decltype(dst.Surf.Platform.ePCHProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                            dst.Surf.Platform.eDisplayCoreFamily = readTokValue<decltype(dst.Surf.Platform.eDisplayCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                            dst.Surf.Platform.eRenderCoreFamily = readTokValue<decltype(dst.Surf.Platform.eRenderCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                            dst.Surf.Platform.ePlatformType = readTokValue<decltype(dst.Surf.Platform.ePlatformType)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                            dst.Surf.Platform.usDeviceID = readTokValue<decltype(dst.Surf.Platform.usDeviceID)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                            dst.Surf.Platform.usRevId = readTokValue<decltype(dst.Surf.Platform.usRevId)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                            dst.Surf.Platform.usDeviceID_PCH = readTokValue<decltype(dst.Surf.Platform.usDeviceID_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                            dst.Surf.Platform.usRevId_PCH = readTokValue<decltype(dst.Surf.Platform.usRevId_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                            dst.Surf.Platform.eGTType = readTokValue<decltype(dst.Surf.Platform.eGTType)>(*tokPlatform);
                                        } break;
                                        };
                                        tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                        if (tokPlatform->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM: {
                                const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokExistingSysMem < tokExistingSysMemEnd) {
                                    if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                                        switch (tokExistingSysMem->id) {
                                        default:
                                            if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED: {
                                            dst.Surf.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.Surf.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED: {
                                            dst.Surf.ExistingSysMem.IsPageAligned = readTokValue<decltype(dst.Surf.ExistingSysMem.IsPageAligned)>(*tokExistingSysMem);
                                        } break;
                                        };
                                        tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                                        if (tokExistingSysMem->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM: {
#if !(_DEBUG || _RELEASE_INTERNAL)
                                const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlatform < tokPlatformEnd) {
                                    if (false == tokPlatform->flags.flag4IsVariableLength) {
                                        switch (tokPlatform->id) {
                                        default:
                                            if (tokPlatform->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                            dst.Surf.__Platform.eProductFamily = readTokValue<decltype(dst.Surf.__Platform.eProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                            dst.Surf.__Platform.ePCHProductFamily = readTokValue<decltype(dst.Surf.__Platform.ePCHProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                            dst.Surf.__Platform.eDisplayCoreFamily = readTokValue<decltype(dst.Surf.__Platform.eDisplayCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                            dst.Surf.__Platform.eRenderCoreFamily = readTokValue<decltype(dst.Surf.__Platform.eRenderCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                            dst.Surf.__Platform.ePlatformType = readTokValue<decltype(dst.Surf.__Platform.ePlatformType)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                            dst.Surf.__Platform.usDeviceID = readTokValue<decltype(dst.Surf.__Platform.usDeviceID)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                            dst.Surf.__Platform.usRevId = readTokValue<decltype(dst.Surf.__Platform.usRevId)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                            dst.Surf.__Platform.usDeviceID_PCH = readTokValue<decltype(dst.Surf.__Platform.usDeviceID_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                            dst.Surf.__Platform.usRevId_PCH = readTokValue<decltype(dst.Surf.__Platform.usRevId_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                            dst.Surf.__Platform.eGTType = readTokValue<decltype(dst.Surf.__Platform.eGTType)>(*tokPlatform);
                                        } break;
                                        };
                                        tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                        if (tokPlatform->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                            } break;
                            };
                            tokSurf = tokSurf + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokSurf == tokSurfEnd);
                } break;
                case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__AUX_SURF: {
                    const TokenHeader *tokAuxSurf = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokAuxSurfEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokAuxSurf < tokAuxSurfEnd) {
                        if (false == tokAuxSurf->flags.flag4IsVariableLength) {
                            switch (tokAuxSurf->id) {
                            default:
                                if (tokAuxSurf->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                                dst.AuxSurf.Type = readTokValue<decltype(dst.AuxSurf.Type)>(*tokAuxSurf);
                            } break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                                dst.AuxSurf.Format = readTokValue<decltype(dst.AuxSurf.Format)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                                dst.AuxSurf.BitsPerPixel = readTokValue<decltype(dst.AuxSurf.BitsPerPixel)>(*tokAuxSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                                dst.AuxSurf.BaseWidth = readTokValue<decltype(dst.AuxSurf.BaseWidth)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                                dst.AuxSurf.BaseHeight = readTokValue<decltype(dst.AuxSurf.BaseHeight)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                                dst.AuxSurf.Depth = readTokValue<decltype(dst.AuxSurf.Depth)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                                dst.AuxSurf.MaxLod = readTokValue<decltype(dst.AuxSurf.MaxLod)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                                dst.AuxSurf.ArraySize = readTokValue<decltype(dst.AuxSurf.ArraySize)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                                dst.AuxSurf.CpTag = readTokValue<decltype(dst.AuxSurf.CpTag)>(*tokAuxSurf);
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.AuxSurf.MmcMode)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.AuxSurf.MmcMode, sizeof(dst.AuxSurf.MmcMode), srcData, sizeof(dst.AuxSurf.MmcMode));
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.AuxSurf.MmcHint)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.AuxSurf.MmcHint, sizeof(dst.AuxSurf.MmcHint), srcData, sizeof(dst.AuxSurf.MmcHint));
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                                dst.AuxSurf.Pitch = readTokValue<decltype(dst.AuxSurf.Pitch)>(*tokAuxSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                                dst.AuxSurf.OverridePitch = readTokValue<decltype(dst.AuxSurf.OverridePitch)>(*tokAuxSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                                dst.AuxSurf.Size = readTokValue<decltype(dst.AuxSurf.Size)>(*tokAuxSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                                dst.AuxSurf.CCSize = readTokValue<decltype(dst.AuxSurf.CCSize)>(*tokAuxSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                                dst.AuxSurf.UnpaddedSize = readTokValue<decltype(dst.AuxSurf.UnpaddedSize)>(*tokAuxSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                                dst.AuxSurf.SizeReportToOS = readTokValue<decltype(dst.AuxSurf.SizeReportToOS)>(*tokAuxSurf);
                            } break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                                dst.AuxSurf.TileMode = readTokValue<decltype(dst.AuxSurf.TileMode)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN: {
                                dst.AuxSurf.CCSModeAlign = readTokValue<decltype(dst.AuxSurf.CCSModeAlign)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS: {
                                dst.AuxSurf.LegacyFlags = readTokValue<decltype(dst.AuxSurf.LegacyFlags)>(*tokAuxSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH: {
                                dst.AuxSurf.MaximumRenamingListLength = readTokValue<decltype(dst.AuxSurf.MaximumRenamingListLength)>(*tokAuxSurf);
                            } break;
                            };
                            tokAuxSurf = tokAuxSurf + 1 + tokAuxSurf->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAuxSurf);
                            switch (tokAuxSurf->id) {
                            default:
                                if (tokAuxSurf->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS: {
                                const TokenHeader *tokFlags = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokFlagsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokFlags < tokFlagsEnd) {
                                    if (false == tokFlags->flags.flag4IsVariableLength) {
                                        if (tokFlags->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokFlags = tokFlags + 1 + tokFlags->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokFlags);
                                        switch (tokFlags->id) {
                                        default:
                                            if (tokFlags->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                                            const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokGpu < tokGpuEnd) {
                                                if (false == tokGpu->flags.flag4IsVariableLength) {
                                                    switch (tokGpu->id) {
                                                    default:
                                                        if (tokGpu->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                                        dst.AuxSurf.Flags.Gpu.CameraCapture = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.CameraCapture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                                        dst.AuxSurf.Flags.Gpu.CCS = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.CCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                                        dst.AuxSurf.Flags.Gpu.ColorDiscard = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.ColorDiscard)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                                        dst.AuxSurf.Flags.Gpu.ColorSeparation = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.ColorSeparation)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                                        dst.AuxSurf.Flags.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.ColorSeparationRGBX)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                                        dst.AuxSurf.Flags.Gpu.Constant = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Constant)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                                        dst.AuxSurf.Flags.Gpu.Depth = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Depth)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                                        dst.AuxSurf.Flags.Gpu.FlipChain = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.FlipChain)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                                        dst.AuxSurf.Flags.Gpu.FlipChainPreferred = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.FlipChainPreferred)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                                        dst.AuxSurf.Flags.Gpu.HistoryBuffer = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.HistoryBuffer)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                                        dst.AuxSurf.Flags.Gpu.HiZ = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.HiZ)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                                        dst.AuxSurf.Flags.Gpu.Index = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Index)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                                        dst.AuxSurf.Flags.Gpu.IndirectClearColor = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.IndirectClearColor)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                                        dst.AuxSurf.Flags.Gpu.InstructionFlat = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.InstructionFlat)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                                        dst.AuxSurf.Flags.Gpu.InterlacedScan = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.InterlacedScan)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                                        dst.AuxSurf.Flags.Gpu.MCS = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.MCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                                        dst.AuxSurf.Flags.Gpu.MMC = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.MMC)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                                        dst.AuxSurf.Flags.Gpu.MotionComp = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.MotionComp)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                                        dst.AuxSurf.Flags.Gpu.NoRestriction = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.NoRestriction)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                                        dst.AuxSurf.Flags.Gpu.Overlay = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Overlay)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                                        dst.AuxSurf.Flags.Gpu.Presentable = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Presentable)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                                        dst.AuxSurf.Flags.Gpu.ProceduralTexture = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.ProceduralTexture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                                        dst.AuxSurf.Flags.Gpu.Query = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Query)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                                        dst.AuxSurf.Flags.Gpu.RenderTarget = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.RenderTarget)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                                        dst.AuxSurf.Flags.Gpu.S3d = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.S3d)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                                        dst.AuxSurf.Flags.Gpu.S3dDx = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.S3dDx)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                                        dst.AuxSurf.Flags.Gpu.__S3dNonPacked = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__S3dNonPacked)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                                        dst.AuxSurf.Flags.Gpu.__S3dWidi = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__S3dWidi)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                                        dst.AuxSurf.Flags.Gpu.ScratchFlat = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.ScratchFlat)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                                        dst.AuxSurf.Flags.Gpu.SeparateStencil = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.SeparateStencil)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                                        dst.AuxSurf.Flags.Gpu.State = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.State)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                                        dst.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                                        dst.AuxSurf.Flags.Gpu.Stream = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Stream)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                                        dst.AuxSurf.Flags.Gpu.TextApi = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.TextApi)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                                        dst.AuxSurf.Flags.Gpu.Texture = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Texture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                                        dst.AuxSurf.Flags.Gpu.TiledResource = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.TiledResource)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                                        dst.AuxSurf.Flags.Gpu.TilePool = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.TilePool)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                                        dst.AuxSurf.Flags.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.UnifiedAuxSurface)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                                        dst.AuxSurf.Flags.Gpu.Vertex = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Vertex)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                                        dst.AuxSurf.Flags.Gpu.Video = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.Video)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                                        dst.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                                        dst.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                                        dst.AuxSurf.Flags.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__MsaaTileMcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                                        dst.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                                        dst.AuxSurf.Flags.Gpu.__Remaining = readTokValue<decltype(dst.AuxSurf.Flags.Gpu.__Remaining)>(*tokGpu);
                                                    } break;
                                                    };
                                                    tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                                                    if (tokGpu->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokGpu == tokGpuEnd);
                                        } break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                                            const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokInfo < tokInfoEnd) {
                                                if (false == tokInfo->flags.flag4IsVariableLength) {
                                                    switch (tokInfo->id) {
                                                    default:
                                                        if (tokInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                                        dst.AuxSurf.Flags.Info.AllowVirtualPadding = readTokValue<decltype(dst.AuxSurf.Flags.Info.AllowVirtualPadding)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                                        dst.AuxSurf.Flags.Info.BigPage = readTokValue<decltype(dst.AuxSurf.Flags.Info.BigPage)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                                        dst.AuxSurf.Flags.Info.Cacheable = readTokValue<decltype(dst.AuxSurf.Flags.Info.Cacheable)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                                        dst.AuxSurf.Flags.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.AuxSurf.Flags.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                                        dst.AuxSurf.Flags.Info.CornerTexelMode = readTokValue<decltype(dst.AuxSurf.Flags.Info.CornerTexelMode)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                                        dst.AuxSurf.Flags.Info.ExistingSysMem = readTokValue<decltype(dst.AuxSurf.Flags.Info.ExistingSysMem)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                                        dst.AuxSurf.Flags.Info.ForceResidency = readTokValue<decltype(dst.AuxSurf.Flags.Info.ForceResidency)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                                        dst.AuxSurf.Flags.Info.Gfdt = readTokValue<decltype(dst.AuxSurf.Flags.Info.Gfdt)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                                        dst.AuxSurf.Flags.Info.GttMapType = readTokValue<decltype(dst.AuxSurf.Flags.Info.GttMapType)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                                        dst.AuxSurf.Flags.Info.HardwareProtected = readTokValue<decltype(dst.AuxSurf.Flags.Info.HardwareProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                                        dst.AuxSurf.Flags.Info.KernelModeMapped = readTokValue<decltype(dst.AuxSurf.Flags.Info.KernelModeMapped)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                                        dst.AuxSurf.Flags.Info.LayoutBelow = readTokValue<decltype(dst.AuxSurf.Flags.Info.LayoutBelow)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                                        dst.AuxSurf.Flags.Info.LayoutMono = readTokValue<decltype(dst.AuxSurf.Flags.Info.LayoutMono)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                                        dst.AuxSurf.Flags.Info.LayoutRight = readTokValue<decltype(dst.AuxSurf.Flags.Info.LayoutRight)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                                        dst.AuxSurf.Flags.Info.LocalOnly = readTokValue<decltype(dst.AuxSurf.Flags.Info.LocalOnly)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                                        dst.AuxSurf.Flags.Info.Linear = readTokValue<decltype(dst.AuxSurf.Flags.Info.Linear)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                                        dst.AuxSurf.Flags.Info.MediaCompressed = readTokValue<decltype(dst.AuxSurf.Flags.Info.MediaCompressed)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                                        dst.AuxSurf.Flags.Info.NoOptimizationPadding = readTokValue<decltype(dst.AuxSurf.Flags.Info.NoOptimizationPadding)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                                        dst.AuxSurf.Flags.Info.NoPhysMemory = readTokValue<decltype(dst.AuxSurf.Flags.Info.NoPhysMemory)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                                        dst.AuxSurf.Flags.Info.NotLockable = readTokValue<decltype(dst.AuxSurf.Flags.Info.NotLockable)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                                        dst.AuxSurf.Flags.Info.NonLocalOnly = readTokValue<decltype(dst.AuxSurf.Flags.Info.NonLocalOnly)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                                        dst.AuxSurf.Flags.Info.StdSwizzle = readTokValue<decltype(dst.AuxSurf.Flags.Info.StdSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                                        dst.AuxSurf.Flags.Info.PseudoStdSwizzle = readTokValue<decltype(dst.AuxSurf.Flags.Info.PseudoStdSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                                        dst.AuxSurf.Flags.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.AuxSurf.Flags.Info.Undefined64KBSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                                        dst.AuxSurf.Flags.Info.RedecribedPlanes = readTokValue<decltype(dst.AuxSurf.Flags.Info.RedecribedPlanes)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                                        dst.AuxSurf.Flags.Info.RenderCompressed = readTokValue<decltype(dst.AuxSurf.Flags.Info.RenderCompressed)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                                        dst.AuxSurf.Flags.Info.Rotated = readTokValue<decltype(dst.AuxSurf.Flags.Info.Rotated)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                                        dst.AuxSurf.Flags.Info.Shared = readTokValue<decltype(dst.AuxSurf.Flags.Info.Shared)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                                        dst.AuxSurf.Flags.Info.SoftwareProtected = readTokValue<decltype(dst.AuxSurf.Flags.Info.SoftwareProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                                        dst.AuxSurf.Flags.Info.SVM = readTokValue<decltype(dst.AuxSurf.Flags.Info.SVM)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                                        dst.AuxSurf.Flags.Info.Tile4 = readTokValue<decltype(dst.AuxSurf.Flags.Info.Tile4)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                                        dst.AuxSurf.Flags.Info.Tile64 = readTokValue<decltype(dst.AuxSurf.Flags.Info.Tile64)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                                        dst.AuxSurf.Flags.Info.TiledW = readTokValue<decltype(dst.AuxSurf.Flags.Info.TiledW)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                                        dst.AuxSurf.Flags.Info.TiledX = readTokValue<decltype(dst.AuxSurf.Flags.Info.TiledX)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                                        dst.AuxSurf.Flags.Info.TiledY = readTokValue<decltype(dst.AuxSurf.Flags.Info.TiledY)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                                        dst.AuxSurf.Flags.Info.TiledYf = readTokValue<decltype(dst.AuxSurf.Flags.Info.TiledYf)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                                        dst.AuxSurf.Flags.Info.TiledYs = readTokValue<decltype(dst.AuxSurf.Flags.Info.TiledYs)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                                        dst.AuxSurf.Flags.Info.WddmProtected = readTokValue<decltype(dst.AuxSurf.Flags.Info.WddmProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                                        dst.AuxSurf.Flags.Info.XAdapter = readTokValue<decltype(dst.AuxSurf.Flags.Info.XAdapter)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                                        dst.AuxSurf.Flags.Info.__PreallocatedResInfo = readTokValue<decltype(dst.AuxSurf.Flags.Info.__PreallocatedResInfo)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                                        dst.AuxSurf.Flags.Info.__PreWddm2SVM = readTokValue<decltype(dst.AuxSurf.Flags.Info.__PreWddm2SVM)>(*tokInfo);
                                                    } break;
                                                    };
                                                    tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                                                    if (tokInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokInfo == tokInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                                            const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokWa < tokWaEnd) {
                                                if (false == tokWa->flags.flag4IsVariableLength) {
                                                    switch (tokWa->id) {
                                                    default:
                                                        if (tokWa->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                                        dst.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                                        dst.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                                        dst.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                                        dst.AuxSurf.Flags.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.AuxSurf.Flags.Wa.NoBufferSamplerPadding)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                                        dst.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                                        dst.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                                        dst.AuxSurf.Flags.Wa.DisablePackedMipTail = readTokValue<decltype(dst.AuxSurf.Flags.Wa.DisablePackedMipTail)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                                        dst.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                                        dst.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                                        dst.AuxSurf.Flags.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.AuxSurf.Flags.Wa.DisableDisplayCcsCompression)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                                        dst.AuxSurf.Flags.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.AuxSurf.Flags.Wa.PreGen12FastClearOnly)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                                        dst.AuxSurf.Flags.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.AuxSurf.Flags.Wa.ForceStdAllocAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                                        dst.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                                                    } break;
                                                    };
                                                    tokWa = tokWa + 1 + tokWa->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                                                    if (tokWa->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokWa == tokWaEnd);
                                        } break;
                                        };
                                        tokFlags = tokFlags + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokFlags == tokFlagsEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY: {
                                const TokenHeader *tokCachePolicy = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokCachePolicyEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokCachePolicy < tokCachePolicyEnd) {
                                    if (false == tokCachePolicy->flags.flag4IsVariableLength) {
                                        switch (tokCachePolicy->id) {
                                        default:
                                            if (tokCachePolicy->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE: {
                                            dst.AuxSurf.CachePolicy.Usage = readTokValue<decltype(dst.AuxSurf.CachePolicy.Usage)>(*tokCachePolicy);
                                        } break;
                                        };
                                        tokCachePolicy = tokCachePolicy + 1 + tokCachePolicy->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCachePolicy);
                                        if (tokCachePolicy->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokCachePolicy = tokCachePolicy + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokCachePolicy == tokCachePolicyEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__MSAA: {
                                const TokenHeader *tokMSAA = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokMSAAEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokMSAA < tokMSAAEnd) {
                                    if (false == tokMSAA->flags.flag4IsVariableLength) {
                                        switch (tokMSAA->id) {
                                        default:
                                            if (tokMSAA->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                                            dst.AuxSurf.MSAA.SamplePattern = readTokValue<decltype(dst.AuxSurf.MSAA.SamplePattern)>(*tokMSAA);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                                            dst.AuxSurf.MSAA.NumSamples = readTokValue<decltype(dst.AuxSurf.MSAA.NumSamples)>(*tokMSAA);
                                        } break;
                                        };
                                        tokMSAA = tokMSAA + 1 + tokMSAA->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMSAA);
                                        if (tokMSAA->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokMSAA = tokMSAA + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokMSAA == tokMSAAEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT: {
                                const TokenHeader *tokAlignment = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokAlignmentEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokAlignment < tokAlignmentEnd) {
                                    if (false == tokAlignment->flags.flag4IsVariableLength) {
                                        switch (tokAlignment->id) {
                                        default:
                                            if (tokAlignment->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                                            dst.AuxSurf.Alignment.ArraySpacingSingleLod = readTokValue<decltype(dst.AuxSurf.Alignment.ArraySpacingSingleLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                                            dst.AuxSurf.Alignment.BaseAlignment = readTokValue<decltype(dst.AuxSurf.Alignment.BaseAlignment)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                                            dst.AuxSurf.Alignment.HAlign = readTokValue<decltype(dst.AuxSurf.Alignment.HAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                                            dst.AuxSurf.Alignment.VAlign = readTokValue<decltype(dst.AuxSurf.Alignment.VAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                                            dst.AuxSurf.Alignment.DAlign = readTokValue<decltype(dst.AuxSurf.Alignment.DAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                                            dst.AuxSurf.Alignment.MipTailStartLod = readTokValue<decltype(dst.AuxSurf.Alignment.MipTailStartLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                                            dst.AuxSurf.Alignment.PackedMipStartLod = readTokValue<decltype(dst.AuxSurf.Alignment.PackedMipStartLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                                            dst.AuxSurf.Alignment.PackedMipWidth = readTokValue<decltype(dst.AuxSurf.Alignment.PackedMipWidth)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                                            dst.AuxSurf.Alignment.PackedMipHeight = readTokValue<decltype(dst.AuxSurf.Alignment.PackedMipHeight)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                                            dst.AuxSurf.Alignment.QPitch = readTokValue<decltype(dst.AuxSurf.Alignment.QPitch)>(*tokAlignment);
                                        } break;
                                        };
                                        tokAlignment = tokAlignment + 1 + tokAlignment->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAlignment);
                                        if (tokAlignment->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokAlignment = tokAlignment + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokAlignment == tokAlignmentEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO: {
                                const TokenHeader *tokOffsetInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokOffsetInfo < tokOffsetInfoEnd) {
                                    if (false == tokOffsetInfo->flags.flag4IsVariableLength) {
                                        if (tokOffsetInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokOffsetInfo = tokOffsetInfo + 1 + tokOffsetInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOffsetInfo);
                                        switch (tokOffsetInfo->id) {
                                        default:
                                            if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                                            const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                                                if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                                                    switch (tokTexture3DOffsetInfo->id) {
                                                    default:
                                                        if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                                        dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
                                                    } break;
                                                    };
                                                    tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                                                    if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                                            const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                                                if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                                                    switch (tokTexture2DOffsetInfo->id) {
                                                    default:
                                                        if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                                        dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                                        dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
                                                    } break;
                                                    };
                                                    tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                                                    if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                                            const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlane < tokPlaneEnd) {
                                                if (false == tokPlane->flags.flag4IsVariableLength) {
                                                    switch (tokPlane->id) {
                                                    default:
                                                        if (tokPlane->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                                        dst.AuxSurf.OffsetInfo.Plane.ArrayQPitch = readTokValue<decltype(dst.AuxSurf.OffsetInfo.Plane.ArrayQPitch)>(*tokPlane);
                                                    } break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSurf.OffsetInfo.Plane.X)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Plane.X, sizeof(dst.AuxSurf.OffsetInfo.Plane.X), srcData, sizeof(dst.AuxSurf.OffsetInfo.Plane.X));
                                                    } break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSurf.OffsetInfo.Plane.Y)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Plane.Y, sizeof(dst.AuxSurf.OffsetInfo.Plane.Y), srcData, sizeof(dst.AuxSurf.OffsetInfo.Plane.Y));
                                                    } break;
                                                    case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                                        dst.AuxSurf.OffsetInfo.Plane.NoOfPlanes = readTokValue<decltype(dst.AuxSurf.OffsetInfo.Plane.NoOfPlanes)>(*tokPlane);
                                                    } break;
                                                    case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                                        dst.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes)>(*tokPlane);
                                                    } break;
                                                    };
                                                    tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                                                    switch (tokPlane->id) {
                                                    default:
                                                        if (tokPlane->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                                        const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokUnAligned < tokUnAlignedEnd) {
                                                            if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                                                switch (tokUnAligned->id) {
                                                                default:
                                                                    if (tokUnAligned->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.AuxSurf.OffsetInfo.Plane.UnAligned.Height)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(dst.AuxSurf.OffsetInfo.Plane.UnAligned.Height), srcData, sizeof(dst.AuxSurf.OffsetInfo.Plane.UnAligned.Height));
                                                                } break;
                                                                };
                                                                tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                                                if (tokUnAligned->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                                                    } break;
                                                    };
                                                    tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlane == tokPlaneEnd);
                                        } break;
                                        };
                                        tokOffsetInfo = tokOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokOffsetInfo == tokOffsetInfoEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__S3D: {
                                const TokenHeader *tokS3d = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokS3dEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokS3d < tokS3dEnd) {
                                    if (false == tokS3d->flags.flag4IsVariableLength) {
                                        switch (tokS3d->id) {
                                        default:
                                            if (tokS3d->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                                            dst.AuxSurf.S3d.DisplayModeHeight = readTokValue<decltype(dst.AuxSurf.S3d.DisplayModeHeight)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                                            dst.AuxSurf.S3d.NumBlankActiveLines = readTokValue<decltype(dst.AuxSurf.S3d.NumBlankActiveLines)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                                            dst.AuxSurf.S3d.RFrameOffset = readTokValue<decltype(dst.AuxSurf.S3d.RFrameOffset)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                                            dst.AuxSurf.S3d.BlankAreaOffset = readTokValue<decltype(dst.AuxSurf.S3d.BlankAreaOffset)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                                            dst.AuxSurf.S3d.TallBufferHeight = readTokValue<decltype(dst.AuxSurf.S3d.TallBufferHeight)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                                            dst.AuxSurf.S3d.TallBufferSize = readTokValue<decltype(dst.AuxSurf.S3d.TallBufferSize)>(*tokS3d);
                                        } break;
                                        case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                                            dst.AuxSurf.S3d.IsRFrame = readTokValue<decltype(dst.AuxSurf.S3d.IsRFrame)>(*tokS3d);
                                        } break;
                                        };
                                        tokS3d = tokS3d + 1 + tokS3d->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokS3d);
                                        if (tokS3d->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokS3d = tokS3d + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokS3d == tokS3dEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE: {
                                const TokenHeader *tokSegmentOverride = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSegmentOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSegmentOverride < tokSegmentOverrideEnd) {
                                    if (false == tokSegmentOverride->flags.flag4IsVariableLength) {
                                        switch (tokSegmentOverride->id) {
                                        default:
                                            if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1: {
                                            dst.AuxSurf.SegmentOverride.Seg1 = readTokValue<decltype(dst.AuxSurf.SegmentOverride.Seg1)>(*tokSegmentOverride);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT: {
                                            dst.AuxSurf.SegmentOverride.Evict = readTokValue<decltype(dst.AuxSurf.SegmentOverride.Evict)>(*tokSegmentOverride);
                                        } break;
                                        };
                                        tokSegmentOverride = tokSegmentOverride + 1 + tokSegmentOverride->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSegmentOverride);
                                        if (tokSegmentOverride->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSegmentOverride = tokSegmentOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSegmentOverride == tokSegmentOverrideEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM: {
#if _DEBUG || _RELEASE_INTERNAL
                                const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlatform < tokPlatformEnd) {
                                    if (false == tokPlatform->flags.flag4IsVariableLength) {
                                        switch (tokPlatform->id) {
                                        default:
                                            if (tokPlatform->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                            dst.AuxSurf.Platform.eProductFamily = readTokValue<decltype(dst.AuxSurf.Platform.eProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                            dst.AuxSurf.Platform.ePCHProductFamily = readTokValue<decltype(dst.AuxSurf.Platform.ePCHProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                            dst.AuxSurf.Platform.eDisplayCoreFamily = readTokValue<decltype(dst.AuxSurf.Platform.eDisplayCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                            dst.AuxSurf.Platform.eRenderCoreFamily = readTokValue<decltype(dst.AuxSurf.Platform.eRenderCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                            dst.AuxSurf.Platform.ePlatformType = readTokValue<decltype(dst.AuxSurf.Platform.ePlatformType)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                            dst.AuxSurf.Platform.usDeviceID = readTokValue<decltype(dst.AuxSurf.Platform.usDeviceID)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                            dst.AuxSurf.Platform.usRevId = readTokValue<decltype(dst.AuxSurf.Platform.usRevId)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                            dst.AuxSurf.Platform.usDeviceID_PCH = readTokValue<decltype(dst.AuxSurf.Platform.usDeviceID_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                            dst.AuxSurf.Platform.usRevId_PCH = readTokValue<decltype(dst.AuxSurf.Platform.usRevId_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                            dst.AuxSurf.Platform.eGTType = readTokValue<decltype(dst.AuxSurf.Platform.eGTType)>(*tokPlatform);
                                        } break;
                                        };
                                        tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                        if (tokPlatform->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM: {
                                const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokExistingSysMem < tokExistingSysMemEnd) {
                                    if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                                        switch (tokExistingSysMem->id) {
                                        default:
                                            if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED: {
                                            dst.AuxSurf.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.AuxSurf.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED: {
                                            dst.AuxSurf.ExistingSysMem.IsPageAligned = readTokValue<decltype(dst.AuxSurf.ExistingSysMem.IsPageAligned)>(*tokExistingSysMem);
                                        } break;
                                        };
                                        tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                                        if (tokExistingSysMem->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM: {
#if !(_DEBUG || _RELEASE_INTERNAL)
                                const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlatform < tokPlatformEnd) {
                                    if (false == tokPlatform->flags.flag4IsVariableLength) {
                                        switch (tokPlatform->id) {
                                        default:
                                            if (tokPlatform->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                            dst.AuxSurf.__Platform.eProductFamily = readTokValue<decltype(dst.AuxSurf.__Platform.eProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                            dst.AuxSurf.__Platform.ePCHProductFamily = readTokValue<decltype(dst.AuxSurf.__Platform.ePCHProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                            dst.AuxSurf.__Platform.eDisplayCoreFamily = readTokValue<decltype(dst.AuxSurf.__Platform.eDisplayCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                            dst.AuxSurf.__Platform.eRenderCoreFamily = readTokValue<decltype(dst.AuxSurf.__Platform.eRenderCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                            dst.AuxSurf.__Platform.ePlatformType = readTokValue<decltype(dst.AuxSurf.__Platform.ePlatformType)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                            dst.AuxSurf.__Platform.usDeviceID = readTokValue<decltype(dst.AuxSurf.__Platform.usDeviceID)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                            dst.AuxSurf.__Platform.usRevId = readTokValue<decltype(dst.AuxSurf.__Platform.usRevId)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                            dst.AuxSurf.__Platform.usDeviceID_PCH = readTokValue<decltype(dst.AuxSurf.__Platform.usDeviceID_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                            dst.AuxSurf.__Platform.usRevId_PCH = readTokValue<decltype(dst.AuxSurf.__Platform.usRevId_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                            dst.AuxSurf.__Platform.eGTType = readTokValue<decltype(dst.AuxSurf.__Platform.eGTType)>(*tokPlatform);
                                        } break;
                                        };
                                        tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                        if (tokPlatform->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                            } break;
                            };
                            tokAuxSurf = tokAuxSurf + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokAuxSurf == tokAuxSurfEnd);
                } break;
                case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__AUX_SEC_SURF: {
                    const TokenHeader *tokAuxSecSurf = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokAuxSecSurfEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokAuxSecSurf < tokAuxSecSurfEnd) {
                        if (false == tokAuxSecSurf->flags.flag4IsVariableLength) {
                            switch (tokAuxSecSurf->id) {
                            default:
                                if (tokAuxSecSurf->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                                dst.AuxSecSurf.Type = readTokValue<decltype(dst.AuxSecSurf.Type)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                                dst.AuxSecSurf.Format = readTokValue<decltype(dst.AuxSecSurf.Format)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                                dst.AuxSecSurf.BitsPerPixel = readTokValue<decltype(dst.AuxSecSurf.BitsPerPixel)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                                dst.AuxSecSurf.BaseWidth = readTokValue<decltype(dst.AuxSecSurf.BaseWidth)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                                dst.AuxSecSurf.BaseHeight = readTokValue<decltype(dst.AuxSecSurf.BaseHeight)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                                dst.AuxSecSurf.Depth = readTokValue<decltype(dst.AuxSecSurf.Depth)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                                dst.AuxSecSurf.MaxLod = readTokValue<decltype(dst.AuxSecSurf.MaxLod)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                                dst.AuxSecSurf.ArraySize = readTokValue<decltype(dst.AuxSecSurf.ArraySize)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                                dst.AuxSecSurf.CpTag = readTokValue<decltype(dst.AuxSecSurf.CpTag)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.AuxSecSurf.MmcMode)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.AuxSecSurf.MmcMode, sizeof(dst.AuxSecSurf.MmcMode), srcData, sizeof(dst.AuxSecSurf.MmcMode));
                            } break;
                            case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValue<char>();
                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValueSizeInBytes();
                                if (srcSize < sizeof(dst.AuxSecSurf.MmcHint)) {
                                    return false;
                                }
                                WCH_SAFE_COPY(dst.AuxSecSurf.MmcHint, sizeof(dst.AuxSecSurf.MmcHint), srcData, sizeof(dst.AuxSecSurf.MmcHint));
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                                dst.AuxSecSurf.Pitch = readTokValue<decltype(dst.AuxSecSurf.Pitch)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                                dst.AuxSecSurf.OverridePitch = readTokValue<decltype(dst.AuxSecSurf.OverridePitch)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                                dst.AuxSecSurf.Size = readTokValue<decltype(dst.AuxSecSurf.Size)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                                dst.AuxSecSurf.CCSize = readTokValue<decltype(dst.AuxSecSurf.CCSize)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                                dst.AuxSecSurf.UnpaddedSize = readTokValue<decltype(dst.AuxSecSurf.UnpaddedSize)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                                dst.AuxSecSurf.SizeReportToOS = readTokValue<decltype(dst.AuxSecSurf.SizeReportToOS)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                                dst.AuxSecSurf.TileMode = readTokValue<decltype(dst.AuxSecSurf.TileMode)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN: {
                                dst.AuxSecSurf.CCSModeAlign = readTokValue<decltype(dst.AuxSecSurf.CCSModeAlign)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS: {
                                dst.AuxSecSurf.LegacyFlags = readTokValue<decltype(dst.AuxSecSurf.LegacyFlags)>(*tokAuxSecSurf);
                            } break;
                            case TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH: {
                                dst.AuxSecSurf.MaximumRenamingListLength = readTokValue<decltype(dst.AuxSecSurf.MaximumRenamingListLength)>(*tokAuxSecSurf);
                            } break;
                            };
                            tokAuxSecSurf = tokAuxSecSurf + 1 + tokAuxSecSurf->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAuxSecSurf);
                            switch (tokAuxSecSurf->id) {
                            default:
                                if (tokAuxSecSurf->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS: {
                                const TokenHeader *tokFlags = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokFlagsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokFlags < tokFlagsEnd) {
                                    if (false == tokFlags->flags.flag4IsVariableLength) {
                                        if (tokFlags->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokFlags = tokFlags + 1 + tokFlags->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokFlags);
                                        switch (tokFlags->id) {
                                        default:
                                            if (tokFlags->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                                            const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokGpu < tokGpuEnd) {
                                                if (false == tokGpu->flags.flag4IsVariableLength) {
                                                    switch (tokGpu->id) {
                                                    default:
                                                        if (tokGpu->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                                        dst.AuxSecSurf.Flags.Gpu.CameraCapture = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.CameraCapture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                                        dst.AuxSecSurf.Flags.Gpu.CCS = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.CCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                                        dst.AuxSecSurf.Flags.Gpu.ColorDiscard = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.ColorDiscard)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                                        dst.AuxSecSurf.Flags.Gpu.ColorSeparation = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.ColorSeparation)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                                        dst.AuxSecSurf.Flags.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.ColorSeparationRGBX)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                                        dst.AuxSecSurf.Flags.Gpu.Constant = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Constant)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                                        dst.AuxSecSurf.Flags.Gpu.Depth = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Depth)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                                        dst.AuxSecSurf.Flags.Gpu.FlipChain = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.FlipChain)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                                        dst.AuxSecSurf.Flags.Gpu.FlipChainPreferred = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.FlipChainPreferred)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                                        dst.AuxSecSurf.Flags.Gpu.HistoryBuffer = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.HistoryBuffer)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                                        dst.AuxSecSurf.Flags.Gpu.HiZ = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.HiZ)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                                        dst.AuxSecSurf.Flags.Gpu.Index = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Index)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                                        dst.AuxSecSurf.Flags.Gpu.IndirectClearColor = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.IndirectClearColor)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                                        dst.AuxSecSurf.Flags.Gpu.InstructionFlat = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.InstructionFlat)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                                        dst.AuxSecSurf.Flags.Gpu.InterlacedScan = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.InterlacedScan)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                                        dst.AuxSecSurf.Flags.Gpu.MCS = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.MCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                                        dst.AuxSecSurf.Flags.Gpu.MMC = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.MMC)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                                        dst.AuxSecSurf.Flags.Gpu.MotionComp = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.MotionComp)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                                        dst.AuxSecSurf.Flags.Gpu.NoRestriction = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.NoRestriction)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                                        dst.AuxSecSurf.Flags.Gpu.Overlay = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Overlay)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                                        dst.AuxSecSurf.Flags.Gpu.Presentable = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Presentable)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                                        dst.AuxSecSurf.Flags.Gpu.ProceduralTexture = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.ProceduralTexture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                                        dst.AuxSecSurf.Flags.Gpu.Query = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Query)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                                        dst.AuxSecSurf.Flags.Gpu.RenderTarget = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.RenderTarget)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                                        dst.AuxSecSurf.Flags.Gpu.S3d = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.S3d)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                                        dst.AuxSecSurf.Flags.Gpu.S3dDx = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.S3dDx)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                                        dst.AuxSecSurf.Flags.Gpu.__S3dNonPacked = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__S3dNonPacked)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                                        dst.AuxSecSurf.Flags.Gpu.__S3dWidi = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__S3dWidi)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                                        dst.AuxSecSurf.Flags.Gpu.ScratchFlat = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.ScratchFlat)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                                        dst.AuxSecSurf.Flags.Gpu.SeparateStencil = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.SeparateStencil)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                                        dst.AuxSecSurf.Flags.Gpu.State = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.State)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                                        dst.AuxSecSurf.Flags.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                                        dst.AuxSecSurf.Flags.Gpu.Stream = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Stream)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                                        dst.AuxSecSurf.Flags.Gpu.TextApi = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.TextApi)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                                        dst.AuxSecSurf.Flags.Gpu.Texture = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Texture)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                                        dst.AuxSecSurf.Flags.Gpu.TiledResource = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.TiledResource)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                                        dst.AuxSecSurf.Flags.Gpu.TilePool = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.TilePool)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                                        dst.AuxSecSurf.Flags.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.UnifiedAuxSurface)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                                        dst.AuxSecSurf.Flags.Gpu.Vertex = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Vertex)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                                        dst.AuxSecSurf.Flags.Gpu.Video = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.Video)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                                        dst.AuxSecSurf.Flags.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                                        dst.AuxSecSurf.Flags.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                                        dst.AuxSecSurf.Flags.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__MsaaTileMcs)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                                        dst.AuxSecSurf.Flags.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                                        dst.AuxSecSurf.Flags.Gpu.__Remaining = readTokValue<decltype(dst.AuxSecSurf.Flags.Gpu.__Remaining)>(*tokGpu);
                                                    } break;
                                                    };
                                                    tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                                                    if (tokGpu->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokGpu == tokGpuEnd);
                                        } break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                                            const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokInfo < tokInfoEnd) {
                                                if (false == tokInfo->flags.flag4IsVariableLength) {
                                                    switch (tokInfo->id) {
                                                    default:
                                                        if (tokInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                                        dst.AuxSecSurf.Flags.Info.AllowVirtualPadding = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.AllowVirtualPadding)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                                        dst.AuxSecSurf.Flags.Info.BigPage = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.BigPage)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                                        dst.AuxSecSurf.Flags.Info.Cacheable = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Cacheable)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                                        dst.AuxSecSurf.Flags.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                                        dst.AuxSecSurf.Flags.Info.CornerTexelMode = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.CornerTexelMode)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                                        dst.AuxSecSurf.Flags.Info.ExistingSysMem = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.ExistingSysMem)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                                        dst.AuxSecSurf.Flags.Info.ForceResidency = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.ForceResidency)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                                        dst.AuxSecSurf.Flags.Info.Gfdt = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Gfdt)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                                        dst.AuxSecSurf.Flags.Info.GttMapType = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.GttMapType)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                                        dst.AuxSecSurf.Flags.Info.HardwareProtected = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.HardwareProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                                        dst.AuxSecSurf.Flags.Info.KernelModeMapped = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.KernelModeMapped)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                                        dst.AuxSecSurf.Flags.Info.LayoutBelow = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.LayoutBelow)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                                        dst.AuxSecSurf.Flags.Info.LayoutMono = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.LayoutMono)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                                        dst.AuxSecSurf.Flags.Info.LayoutRight = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.LayoutRight)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                                        dst.AuxSecSurf.Flags.Info.LocalOnly = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.LocalOnly)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                                        dst.AuxSecSurf.Flags.Info.Linear = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Linear)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                                        dst.AuxSecSurf.Flags.Info.MediaCompressed = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.MediaCompressed)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                                        dst.AuxSecSurf.Flags.Info.NoOptimizationPadding = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.NoOptimizationPadding)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                                        dst.AuxSecSurf.Flags.Info.NoPhysMemory = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.NoPhysMemory)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                                        dst.AuxSecSurf.Flags.Info.NotLockable = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.NotLockable)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                                        dst.AuxSecSurf.Flags.Info.NonLocalOnly = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.NonLocalOnly)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                                        dst.AuxSecSurf.Flags.Info.StdSwizzle = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.StdSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                                        dst.AuxSecSurf.Flags.Info.PseudoStdSwizzle = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.PseudoStdSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                                        dst.AuxSecSurf.Flags.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Undefined64KBSwizzle)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                                        dst.AuxSecSurf.Flags.Info.RedecribedPlanes = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.RedecribedPlanes)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                                        dst.AuxSecSurf.Flags.Info.RenderCompressed = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.RenderCompressed)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                                        dst.AuxSecSurf.Flags.Info.Rotated = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Rotated)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                                        dst.AuxSecSurf.Flags.Info.Shared = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Shared)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                                        dst.AuxSecSurf.Flags.Info.SoftwareProtected = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.SoftwareProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                                        dst.AuxSecSurf.Flags.Info.SVM = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.SVM)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                                        dst.AuxSecSurf.Flags.Info.Tile4 = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Tile4)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                                        dst.AuxSecSurf.Flags.Info.Tile64 = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.Tile64)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                                        dst.AuxSecSurf.Flags.Info.TiledW = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.TiledW)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                                        dst.AuxSecSurf.Flags.Info.TiledX = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.TiledX)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                                        dst.AuxSecSurf.Flags.Info.TiledY = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.TiledY)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                                        dst.AuxSecSurf.Flags.Info.TiledYf = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.TiledYf)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                                        dst.AuxSecSurf.Flags.Info.TiledYs = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.TiledYs)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                                        dst.AuxSecSurf.Flags.Info.WddmProtected = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.WddmProtected)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                                        dst.AuxSecSurf.Flags.Info.XAdapter = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.XAdapter)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                                        dst.AuxSecSurf.Flags.Info.__PreallocatedResInfo = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.__PreallocatedResInfo)>(*tokInfo);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                                        dst.AuxSecSurf.Flags.Info.__PreWddm2SVM = readTokValue<decltype(dst.AuxSecSurf.Flags.Info.__PreWddm2SVM)>(*tokInfo);
                                                    } break;
                                                    };
                                                    tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                                                    if (tokInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokInfo == tokInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                                            const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokWa < tokWaEnd) {
                                                if (false == tokWa->flags.flag4IsVariableLength) {
                                                    switch (tokWa->id) {
                                                    default:
                                                        if (tokWa->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                                        dst.AuxSecSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                                        dst.AuxSecSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                                        dst.AuxSecSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                                        dst.AuxSecSurf.Flags.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.NoBufferSamplerPadding)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                                        dst.AuxSecSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                                        dst.AuxSecSurf.Flags.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                                        dst.AuxSecSurf.Flags.Wa.DisablePackedMipTail = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.DisablePackedMipTail)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                                        dst.AuxSecSurf.Flags.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                                        dst.AuxSecSurf.Flags.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                                        dst.AuxSecSurf.Flags.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.DisableDisplayCcsCompression)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                                        dst.AuxSecSurf.Flags.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.PreGen12FastClearOnly)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                                        dst.AuxSecSurf.Flags.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.ForceStdAllocAlign)>(*tokWa);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                                        dst.AuxSecSurf.Flags.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.AuxSecSurf.Flags.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                                                    } break;
                                                    };
                                                    tokWa = tokWa + 1 + tokWa->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                                                    if (tokWa->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokWa == tokWaEnd);
                                        } break;
                                        };
                                        tokFlags = tokFlags + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokFlags == tokFlagsEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY: {
                                const TokenHeader *tokCachePolicy = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokCachePolicyEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokCachePolicy < tokCachePolicyEnd) {
                                    if (false == tokCachePolicy->flags.flag4IsVariableLength) {
                                        switch (tokCachePolicy->id) {
                                        default:
                                            if (tokCachePolicy->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE: {
                                            dst.AuxSecSurf.CachePolicy.Usage = readTokValue<decltype(dst.AuxSecSurf.CachePolicy.Usage)>(*tokCachePolicy);
                                        } break;
                                        };
                                        tokCachePolicy = tokCachePolicy + 1 + tokCachePolicy->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCachePolicy);
                                        if (tokCachePolicy->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokCachePolicy = tokCachePolicy + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokCachePolicy == tokCachePolicyEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__MSAA: {
                                const TokenHeader *tokMSAA = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokMSAAEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokMSAA < tokMSAAEnd) {
                                    if (false == tokMSAA->flags.flag4IsVariableLength) {
                                        switch (tokMSAA->id) {
                                        default:
                                            if (tokMSAA->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                                            dst.AuxSecSurf.MSAA.SamplePattern = readTokValue<decltype(dst.AuxSecSurf.MSAA.SamplePattern)>(*tokMSAA);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                                            dst.AuxSecSurf.MSAA.NumSamples = readTokValue<decltype(dst.AuxSecSurf.MSAA.NumSamples)>(*tokMSAA);
                                        } break;
                                        };
                                        tokMSAA = tokMSAA + 1 + tokMSAA->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMSAA);
                                        if (tokMSAA->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokMSAA = tokMSAA + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokMSAA == tokMSAAEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT: {
                                const TokenHeader *tokAlignment = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokAlignmentEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokAlignment < tokAlignmentEnd) {
                                    if (false == tokAlignment->flags.flag4IsVariableLength) {
                                        switch (tokAlignment->id) {
                                        default:
                                            if (tokAlignment->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                                            dst.AuxSecSurf.Alignment.ArraySpacingSingleLod = readTokValue<decltype(dst.AuxSecSurf.Alignment.ArraySpacingSingleLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                                            dst.AuxSecSurf.Alignment.BaseAlignment = readTokValue<decltype(dst.AuxSecSurf.Alignment.BaseAlignment)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                                            dst.AuxSecSurf.Alignment.HAlign = readTokValue<decltype(dst.AuxSecSurf.Alignment.HAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                                            dst.AuxSecSurf.Alignment.VAlign = readTokValue<decltype(dst.AuxSecSurf.Alignment.VAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                                            dst.AuxSecSurf.Alignment.DAlign = readTokValue<decltype(dst.AuxSecSurf.Alignment.DAlign)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                                            dst.AuxSecSurf.Alignment.MipTailStartLod = readTokValue<decltype(dst.AuxSecSurf.Alignment.MipTailStartLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                                            dst.AuxSecSurf.Alignment.PackedMipStartLod = readTokValue<decltype(dst.AuxSecSurf.Alignment.PackedMipStartLod)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                                            dst.AuxSecSurf.Alignment.PackedMipWidth = readTokValue<decltype(dst.AuxSecSurf.Alignment.PackedMipWidth)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                                            dst.AuxSecSurf.Alignment.PackedMipHeight = readTokValue<decltype(dst.AuxSecSurf.Alignment.PackedMipHeight)>(*tokAlignment);
                                        } break;
                                        case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                                            dst.AuxSecSurf.Alignment.QPitch = readTokValue<decltype(dst.AuxSecSurf.Alignment.QPitch)>(*tokAlignment);
                                        } break;
                                        };
                                        tokAlignment = tokAlignment + 1 + tokAlignment->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAlignment);
                                        if (tokAlignment->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokAlignment = tokAlignment + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokAlignment == tokAlignmentEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO: {
                                const TokenHeader *tokOffsetInfo = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokOffsetInfo < tokOffsetInfoEnd) {
                                    if (false == tokOffsetInfo->flags.flag4IsVariableLength) {
                                        if (tokOffsetInfo->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokOffsetInfo = tokOffsetInfo + 1 + tokOffsetInfo->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOffsetInfo);
                                        switch (tokOffsetInfo->id) {
                                        default:
                                            if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                                            const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                                                if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                                                    switch (tokTexture3DOffsetInfo->id) {
                                                    default:
                                                        if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                                        dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
                                                    } break;
                                                    };
                                                    tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                                                    if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                                            const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                                                if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                                                    switch (tokTexture2DOffsetInfo->id) {
                                                    default:
                                                        if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                                        dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                                        dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                                                    } break;
                                                    case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
                                                    } break;
                                                    };
                                                    tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                                                    if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                                            const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlane < tokPlaneEnd) {
                                                if (false == tokPlane->flags.flag4IsVariableLength) {
                                                    switch (tokPlane->id) {
                                                    default:
                                                        if (tokPlane->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                                        dst.AuxSecSurf.OffsetInfo.Plane.ArrayQPitch = readTokValue<decltype(dst.AuxSecSurf.OffsetInfo.Plane.ArrayQPitch)>(*tokPlane);
                                                    } break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSecSurf.OffsetInfo.Plane.X)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Plane.X, sizeof(dst.AuxSecSurf.OffsetInfo.Plane.X), srcData, sizeof(dst.AuxSecSurf.OffsetInfo.Plane.X));
                                                    } break;
                                                    case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                                        auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                        auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                        if (srcSize < sizeof(dst.AuxSecSurf.OffsetInfo.Plane.Y)) {
                                                            return false;
                                                        }
                                                        WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Plane.Y, sizeof(dst.AuxSecSurf.OffsetInfo.Plane.Y), srcData, sizeof(dst.AuxSecSurf.OffsetInfo.Plane.Y));
                                                    } break;
                                                    case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                                        dst.AuxSecSurf.OffsetInfo.Plane.NoOfPlanes = readTokValue<decltype(dst.AuxSecSurf.OffsetInfo.Plane.NoOfPlanes)>(*tokPlane);
                                                    } break;
                                                    case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                                        dst.AuxSecSurf.OffsetInfo.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.AuxSecSurf.OffsetInfo.Plane.IsTileAlignedPlanes)>(*tokPlane);
                                                    } break;
                                                    };
                                                    tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                                                    switch (tokPlane->id) {
                                                    default:
                                                        if (tokPlane->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                                        const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokUnAligned < tokUnAlignedEnd) {
                                                            if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                                                switch (tokUnAligned->id) {
                                                                default:
                                                                    if (tokUnAligned->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(dst.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height), srcData, sizeof(dst.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height));
                                                                } break;
                                                                };
                                                                tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                                                if (tokUnAligned->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                                                    } break;
                                                    };
                                                    tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlane == tokPlaneEnd);
                                        } break;
                                        };
                                        tokOffsetInfo = tokOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokOffsetInfo == tokOffsetInfoEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__S3D: {
                                const TokenHeader *tokS3d = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokS3dEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokS3d < tokS3dEnd) {
                                    if (false == tokS3d->flags.flag4IsVariableLength) {
                                        switch (tokS3d->id) {
                                        default:
                                            if (tokS3d->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                                            dst.AuxSecSurf.S3d.DisplayModeHeight = readTokValue<decltype(dst.AuxSecSurf.S3d.DisplayModeHeight)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                                            dst.AuxSecSurf.S3d.NumBlankActiveLines = readTokValue<decltype(dst.AuxSecSurf.S3d.NumBlankActiveLines)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                                            dst.AuxSecSurf.S3d.RFrameOffset = readTokValue<decltype(dst.AuxSecSurf.S3d.RFrameOffset)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                                            dst.AuxSecSurf.S3d.BlankAreaOffset = readTokValue<decltype(dst.AuxSecSurf.S3d.BlankAreaOffset)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                                            dst.AuxSecSurf.S3d.TallBufferHeight = readTokValue<decltype(dst.AuxSecSurf.S3d.TallBufferHeight)>(*tokS3d);
                                        } break;
                                        case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                                            dst.AuxSecSurf.S3d.TallBufferSize = readTokValue<decltype(dst.AuxSecSurf.S3d.TallBufferSize)>(*tokS3d);
                                        } break;
                                        case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                                            dst.AuxSecSurf.S3d.IsRFrame = readTokValue<decltype(dst.AuxSecSurf.S3d.IsRFrame)>(*tokS3d);
                                        } break;
                                        };
                                        tokS3d = tokS3d + 1 + tokS3d->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokS3d);
                                        if (tokS3d->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokS3d = tokS3d + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokS3d == tokS3dEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE: {
                                const TokenHeader *tokSegmentOverride = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSegmentOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSegmentOverride < tokSegmentOverrideEnd) {
                                    if (false == tokSegmentOverride->flags.flag4IsVariableLength) {
                                        switch (tokSegmentOverride->id) {
                                        default:
                                            if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1: {
                                            dst.AuxSecSurf.SegmentOverride.Seg1 = readTokValue<decltype(dst.AuxSecSurf.SegmentOverride.Seg1)>(*tokSegmentOverride);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT: {
                                            dst.AuxSecSurf.SegmentOverride.Evict = readTokValue<decltype(dst.AuxSecSurf.SegmentOverride.Evict)>(*tokSegmentOverride);
                                        } break;
                                        };
                                        tokSegmentOverride = tokSegmentOverride + 1 + tokSegmentOverride->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSegmentOverride);
                                        if (tokSegmentOverride->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokSegmentOverride = tokSegmentOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSegmentOverride == tokSegmentOverrideEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM: {
#if _DEBUG || _RELEASE_INTERNAL
                                const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlatform < tokPlatformEnd) {
                                    if (false == tokPlatform->flags.flag4IsVariableLength) {
                                        switch (tokPlatform->id) {
                                        default:
                                            if (tokPlatform->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                            dst.AuxSecSurf.Platform.eProductFamily = readTokValue<decltype(dst.AuxSecSurf.Platform.eProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                            dst.AuxSecSurf.Platform.ePCHProductFamily = readTokValue<decltype(dst.AuxSecSurf.Platform.ePCHProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                            dst.AuxSecSurf.Platform.eDisplayCoreFamily = readTokValue<decltype(dst.AuxSecSurf.Platform.eDisplayCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                            dst.AuxSecSurf.Platform.eRenderCoreFamily = readTokValue<decltype(dst.AuxSecSurf.Platform.eRenderCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                            dst.AuxSecSurf.Platform.ePlatformType = readTokValue<decltype(dst.AuxSecSurf.Platform.ePlatformType)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                            dst.AuxSecSurf.Platform.usDeviceID = readTokValue<decltype(dst.AuxSecSurf.Platform.usDeviceID)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                            dst.AuxSecSurf.Platform.usRevId = readTokValue<decltype(dst.AuxSecSurf.Platform.usRevId)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                            dst.AuxSecSurf.Platform.usDeviceID_PCH = readTokValue<decltype(dst.AuxSecSurf.Platform.usDeviceID_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                            dst.AuxSecSurf.Platform.usRevId_PCH = readTokValue<decltype(dst.AuxSecSurf.Platform.usRevId_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                            dst.AuxSecSurf.Platform.eGTType = readTokValue<decltype(dst.AuxSecSurf.Platform.eGTType)>(*tokPlatform);
                                        } break;
                                        };
                                        tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                        if (tokPlatform->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM: {
                                const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokExistingSysMem < tokExistingSysMemEnd) {
                                    if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                                        switch (tokExistingSysMem->id) {
                                        default:
                                            if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED: {
                                            dst.AuxSecSurf.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.AuxSecSurf.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED: {
                                            dst.AuxSecSurf.ExistingSysMem.IsPageAligned = readTokValue<decltype(dst.AuxSecSurf.ExistingSysMem.IsPageAligned)>(*tokExistingSysMem);
                                        } break;
                                        };
                                        tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                                        if (tokExistingSysMem->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                            } break;
                            case TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM: {
#if !(_DEBUG || _RELEASE_INTERNAL)
                                const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokPlatform < tokPlatformEnd) {
                                    if (false == tokPlatform->flags.flag4IsVariableLength) {
                                        switch (tokPlatform->id) {
                                        default:
                                            if (tokPlatform->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                            dst.AuxSecSurf.__Platform.eProductFamily = readTokValue<decltype(dst.AuxSecSurf.__Platform.eProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                            dst.AuxSecSurf.__Platform.ePCHProductFamily = readTokValue<decltype(dst.AuxSecSurf.__Platform.ePCHProductFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                            dst.AuxSecSurf.__Platform.eDisplayCoreFamily = readTokValue<decltype(dst.AuxSecSurf.__Platform.eDisplayCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                            dst.AuxSecSurf.__Platform.eRenderCoreFamily = readTokValue<decltype(dst.AuxSecSurf.__Platform.eRenderCoreFamily)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                            dst.AuxSecSurf.__Platform.ePlatformType = readTokValue<decltype(dst.AuxSecSurf.__Platform.ePlatformType)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                            dst.AuxSecSurf.__Platform.usDeviceID = readTokValue<decltype(dst.AuxSecSurf.__Platform.usDeviceID)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                            dst.AuxSecSurf.__Platform.usRevId = readTokValue<decltype(dst.AuxSecSurf.__Platform.usRevId)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                            dst.AuxSecSurf.__Platform.usDeviceID_PCH = readTokValue<decltype(dst.AuxSecSurf.__Platform.usDeviceID_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                            dst.AuxSecSurf.__Platform.usRevId_PCH = readTokValue<decltype(dst.AuxSecSurf.__Platform.usRevId_PCH)>(*tokPlatform);
                                        } break;
                                        case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                            dst.AuxSecSurf.__Platform.eGTType = readTokValue<decltype(dst.AuxSecSurf.__Platform.eGTType)>(*tokPlatform);
                                        } break;
                                        };
                                        tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                        if (tokPlatform->flags.flag3IsMandatory) {
                                            return false;
                                        }
                                        tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                            } break;
                            };
                            tokAuxSecSurf = tokAuxSecSurf + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokAuxSecSurf == tokAuxSecSurfEnd);
                } break;
                case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__EXISTING_SYS_MEM: {
                    const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokExistingSysMem < tokExistingSysMemEnd) {
                        if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                            switch (tokExistingSysMem->id) {
                            default:
                                if (tokExistingSysMem->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_EXISTING_SYS_MEM: {
                                dst.ExistingSysMem.pExistingSysMem = readTokValue<decltype(dst.ExistingSysMem.pExistingSysMem)>(*tokExistingSysMem);
                            } break;
                            case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_VIRT_ADDRESS: {
                                dst.ExistingSysMem.pVirtAddress = readTokValue<decltype(dst.ExistingSysMem.pVirtAddress)>(*tokExistingSysMem);
                            } break;
                            case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_GFX_ALIGNED_VIRT_ADDRESS: {
                                dst.ExistingSysMem.pGfxAlignedVirtAddress = readTokValue<decltype(dst.ExistingSysMem.pGfxAlignedVirtAddress)>(*tokExistingSysMem);
                            } break;
                            case TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__SIZE: {
                                dst.ExistingSysMem.Size = readTokValue<decltype(dst.ExistingSysMem.Size)>(*tokExistingSysMem);
                            } break;
                            case TOK_FBC_GMM_EXISTING_SYS_MEM_REC__IS_GMM_ALLOCATED: {
                                dst.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                            } break;
                            };
                            tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                            if (tokExistingSysMem->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                } break;
                case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__MULTI_TILE_ARCH: {
                    const TokenHeader *tokMultiTileArch = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokMultiTileArchEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokMultiTileArch < tokMultiTileArchEnd) {
                        if (false == tokMultiTileArch->flags.flag4IsVariableLength) {
                            switch (tokMultiTileArch->id) {
                            default:
                                if (tokMultiTileArch->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__ENABLE: {
                                dst.MultiTileArch.Enable = readTokValue<decltype(dst.MultiTileArch.Enable)>(*tokMultiTileArch);
                            } break;
                            case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__TILE_INSTANCED: {
                                dst.MultiTileArch.TileInstanced = readTokValue<decltype(dst.MultiTileArch.TileInstanced)>(*tokMultiTileArch);
                            } break;
                            case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__GPU_VA_MAPPING_SET: {
                                dst.MultiTileArch.GpuVaMappingSet = readTokValue<decltype(dst.MultiTileArch.GpuVaMappingSet)>(*tokMultiTileArch);
                            } break;
                            case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__LOCAL_MEM_ELIGIBILITY_SET: {
                                dst.MultiTileArch.LocalMemEligibilitySet = readTokValue<decltype(dst.MultiTileArch.LocalMemEligibilitySet)>(*tokMultiTileArch);
                            } break;
                            case TOK_FBC_GMM_MULTI_TILE_ARCH_REC__LOCAL_MEM_PREFERRED_SET: {
                                dst.MultiTileArch.LocalMemPreferredSet = readTokValue<decltype(dst.MultiTileArch.LocalMemPreferredSet)>(*tokMultiTileArch);
                            } break;
                            };
                            tokMultiTileArch = tokMultiTileArch + 1 + tokMultiTileArch->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMultiTileArch);
                            if (tokMultiTileArch->flags.flag3IsMandatory) {
                                return false;
                            }
                            tokMultiTileArch = tokMultiTileArch + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                        }
                    }
                    WCH_ASSERT(tokMultiTileArch == tokMultiTileArchEnd);
                } break;
                };
                tok = tok + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
            }
        }
        WCH_ASSERT(tok == srcTokensEnd);
        return true;
    }
};

template <>
struct Demarshaller<TOK_S_GMM_RESOURCE_INFO_WIN_STRUCT> {
    template <typename GmmResourceInfoWinStructT>
    static bool demarshall(GmmResourceInfoWinStructT &dst, const TokenHeader *srcTokensBeg, const TokenHeader *srcTokensEnd) {
        const TokenHeader *tok = srcTokensBeg;
        while (tok < srcTokensEnd) {
            if (false == tok->flags.flag4IsVariableLength) {
                if (tok->flags.flag3IsMandatory) {
                    return false;
                }
                tok = tok + 1 + tok->valueDwordCount;
            } else {
                auto varLen = reinterpret_cast<const TokenVariableLength *>(tok);
                switch (tok->id) {
                default:
                    if (tok->flags.flag3IsMandatory) {
                        return false;
                    }
                    break;
                case TOK_S_GMM_RESOURCE_INFO_WIN_STRUCT:
                    if (false == demarshall(dst, varLen->getValue<TokenHeader>(), varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader))) {
                        return false;
                    }
                    break;
                case TOK_FS_GMM_RESOURCE_INFO_WIN_STRUCT__GMM_RESOURCE_INFO_COMMON: {
                    const TokenHeader *tokGmmResourceInfoCommon = varLen->getValue<TokenHeader>();
                    const TokenHeader *tokGmmResourceInfoCommonEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                    while (tokGmmResourceInfoCommon < tokGmmResourceInfoCommonEnd) {
                        if (false == tokGmmResourceInfoCommon->flags.flag4IsVariableLength) {
                            switch (tokGmmResourceInfoCommon->id) {
                            default:
                                if (tokGmmResourceInfoCommon->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FE_GMM_RESOURCE_INFO_COMMON_STRUCT__CLIENT_TYPE: {
                                dst.GmmResourceInfoCommon.ClientType = readTokValue<decltype(dst.GmmResourceInfoCommon.ClientType)>(*tokGmmResourceInfoCommon);
                            } break;
                            case TOK_FBD_GMM_RESOURCE_INFO_COMMON_STRUCT__ROTATE_INFO: {
                                dst.GmmResourceInfoCommon.RotateInfo = readTokValue<decltype(dst.GmmResourceInfoCommon.RotateInfo)>(*tokGmmResourceInfoCommon);
                            } break;
                            case TOK_FBQ_GMM_RESOURCE_INFO_COMMON_STRUCT__SVM_ADDRESS: {
                                dst.GmmResourceInfoCommon.SvmAddress = readTokValue<decltype(dst.GmmResourceInfoCommon.SvmAddress)>(*tokGmmResourceInfoCommon);
                            } break;
                            case TOK_FBQ_GMM_RESOURCE_INFO_COMMON_STRUCT__P_PRIVATE_DATA: {
                                dst.GmmResourceInfoCommon.pPrivateData = readTokValue<decltype(dst.GmmResourceInfoCommon.pPrivateData)>(*tokGmmResourceInfoCommon);
                            } break;
                            };
                            tokGmmResourceInfoCommon = tokGmmResourceInfoCommon + 1 + tokGmmResourceInfoCommon->valueDwordCount;
                        } else {
                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGmmResourceInfoCommon);
                            switch (tokGmmResourceInfoCommon->id) {
                            default:
                                if (tokGmmResourceInfoCommon->flags.flag3IsMandatory) {
                                    return false;
                                }
                                break;
                            case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__SURF: {
                                const TokenHeader *tokSurf = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokSurfEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokSurf < tokSurfEnd) {
                                    if (false == tokSurf->flags.flag4IsVariableLength) {
                                        switch (tokSurf->id) {
                                        default:
                                            if (tokSurf->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                                            dst.GmmResourceInfoCommon.Surf.Type = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Type)>(*tokSurf);
                                        } break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                                            dst.GmmResourceInfoCommon.Surf.Format = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Format)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                                            dst.GmmResourceInfoCommon.Surf.BitsPerPixel = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.BitsPerPixel)>(*tokSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                                            dst.GmmResourceInfoCommon.Surf.BaseWidth = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.BaseWidth)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                                            dst.GmmResourceInfoCommon.Surf.BaseHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.BaseHeight)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                                            dst.GmmResourceInfoCommon.Surf.Depth = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Depth)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                                            dst.GmmResourceInfoCommon.Surf.MaxLod = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.MaxLod)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                                            dst.GmmResourceInfoCommon.Surf.ArraySize = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.ArraySize)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                                            dst.GmmResourceInfoCommon.Surf.CpTag = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.CpTag)>(*tokSurf);
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.MmcMode)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.MmcMode, sizeof(dst.GmmResourceInfoCommon.Surf.MmcMode), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.MmcMode));
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokSurf).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.MmcHint)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.MmcHint, sizeof(dst.GmmResourceInfoCommon.Surf.MmcHint), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.MmcHint));
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                                            dst.GmmResourceInfoCommon.Surf.Pitch = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Pitch)>(*tokSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                                            dst.GmmResourceInfoCommon.Surf.OverridePitch = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OverridePitch)>(*tokSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                                            dst.GmmResourceInfoCommon.Surf.Size = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Size)>(*tokSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                                            dst.GmmResourceInfoCommon.Surf.CCSize = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.CCSize)>(*tokSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                                            dst.GmmResourceInfoCommon.Surf.UnpaddedSize = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.UnpaddedSize)>(*tokSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                                            dst.GmmResourceInfoCommon.Surf.SizeReportToOS = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.SizeReportToOS)>(*tokSurf);
                                        } break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                                            dst.GmmResourceInfoCommon.Surf.TileMode = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.TileMode)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN: {
                                            dst.GmmResourceInfoCommon.Surf.CCSModeAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.CCSModeAlign)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS: {
                                            dst.GmmResourceInfoCommon.Surf.LegacyFlags = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.LegacyFlags)>(*tokSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH: {
                                            dst.GmmResourceInfoCommon.Surf.MaximumRenamingListLength = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.MaximumRenamingListLength)>(*tokSurf);
                                        } break;
                                        };
                                        tokSurf = tokSurf + 1 + tokSurf->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSurf);
                                        switch (tokSurf->id) {
                                        default:
                                            if (tokSurf->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS: {
                                            const TokenHeader *tokFlags = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokFlagsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokFlags < tokFlagsEnd) {
                                                if (false == tokFlags->flags.flag4IsVariableLength) {
                                                    if (tokFlags->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokFlags = tokFlags + 1 + tokFlags->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokFlags);
                                                    switch (tokFlags->id) {
                                                    default:
                                                        if (tokFlags->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                                                        const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokGpu < tokGpuEnd) {
                                                            if (false == tokGpu->flags.flag4IsVariableLength) {
                                                                switch (tokGpu->id) {
                                                                default:
                                                                    if (tokGpu->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.CameraCapture = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.CameraCapture)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.CCS = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.CCS)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorDiscard = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorDiscard)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparation = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparation)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparationRGBX)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Constant = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Constant)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Depth = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Depth)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChain = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChain)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChainPreferred = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChainPreferred)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.HistoryBuffer = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.HistoryBuffer)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.HiZ = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.HiZ)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Index = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Index)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.IndirectClearColor = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.IndirectClearColor)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.InstructionFlat = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.InstructionFlat)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.InterlacedScan = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.InterlacedScan)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MCS = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MCS)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MMC = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MMC)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MotionComp = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MotionComp)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.NoRestriction = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.NoRestriction)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Overlay = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Overlay)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Presentable = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Presentable)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ProceduralTexture = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ProceduralTexture)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Query = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Query)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.RenderTarget = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.RenderTarget)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.S3d = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.S3d)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.S3dDx = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.S3dDx)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dNonPacked = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dNonPacked)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dWidi = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dWidi)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ScratchFlat = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ScratchFlat)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.SeparateStencil = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.SeparateStencil)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.State = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.State)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Stream = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Stream)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TextApi = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TextApi)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Texture = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Texture)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TiledResource = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TiledResource)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TilePool = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TilePool)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.UnifiedAuxSurface)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Vertex = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Vertex)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Video = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Video)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__MsaaTileMcs)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__Remaining = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__Remaining)>(*tokGpu);
                                                                } break;
                                                                };
                                                                tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                                                                if (tokGpu->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokGpu == tokGpuEnd);
                                                    } break;
                                                    case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                                                        const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokInfo < tokInfoEnd) {
                                                            if (false == tokInfo->flags.flag4IsVariableLength) {
                                                                switch (tokInfo->id) {
                                                                default:
                                                                    if (tokInfo->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.AllowVirtualPadding = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.AllowVirtualPadding)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.BigPage = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.BigPage)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Cacheable = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Cacheable)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.CornerTexelMode = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.CornerTexelMode)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.ExistingSysMem = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.ExistingSysMem)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.ForceResidency = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.ForceResidency)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Gfdt = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Gfdt)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.GttMapType = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.GttMapType)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.HardwareProtected = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.HardwareProtected)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.KernelModeMapped = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.KernelModeMapped)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutBelow = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutBelow)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutMono = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutMono)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutRight = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutRight)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.LocalOnly = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.LocalOnly)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Linear = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Linear)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.MediaCompressed = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.MediaCompressed)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.NoOptimizationPadding = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.NoOptimizationPadding)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.NoPhysMemory = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.NoPhysMemory)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.NotLockable = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.NotLockable)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.NonLocalOnly = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.NonLocalOnly)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.StdSwizzle = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.StdSwizzle)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.PseudoStdSwizzle = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.PseudoStdSwizzle)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Undefined64KBSwizzle)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.RedecribedPlanes = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.RedecribedPlanes)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.RenderCompressed = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.RenderCompressed)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Rotated = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Rotated)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Shared = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Shared)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.SoftwareProtected = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.SoftwareProtected)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.SVM = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.SVM)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Tile4 = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Tile4)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.Tile64 = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.Tile64)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledW = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledW)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledX = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledX)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledY = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledY)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledYf = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledYf)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledYs = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledYs)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.WddmProtected = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.WddmProtected)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.XAdapter = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.XAdapter)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.__PreallocatedResInfo = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.__PreallocatedResInfo)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Info.__PreWddm2SVM = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Info.__PreWddm2SVM)>(*tokInfo);
                                                                } break;
                                                                };
                                                                tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                                                                if (tokInfo->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokInfo == tokInfoEnd);
                                                    } break;
                                                    case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                                                        const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokWa < tokWaEnd) {
                                                            if (false == tokWa->flags.flag4IsVariableLength) {
                                                                switch (tokWa->id) {
                                                                default:
                                                                    if (tokWa->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.NoBufferSamplerPadding)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisablePackedMipTail = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisablePackedMipTail)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsCompression)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.PreGen12FastClearOnly)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.ForceStdAllocAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                                                    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Flags.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                                                                } break;
                                                                };
                                                                tokWa = tokWa + 1 + tokWa->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                                                                if (tokWa->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokWa == tokWaEnd);
                                                    } break;
                                                    };
                                                    tokFlags = tokFlags + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokFlags == tokFlagsEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY: {
                                            const TokenHeader *tokCachePolicy = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokCachePolicyEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokCachePolicy < tokCachePolicyEnd) {
                                                if (false == tokCachePolicy->flags.flag4IsVariableLength) {
                                                    switch (tokCachePolicy->id) {
                                                    default:
                                                        if (tokCachePolicy->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE: {
                                                        dst.GmmResourceInfoCommon.Surf.CachePolicy.Usage = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.CachePolicy.Usage)>(*tokCachePolicy);
                                                    } break;
                                                    };
                                                    tokCachePolicy = tokCachePolicy + 1 + tokCachePolicy->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCachePolicy);
                                                    if (tokCachePolicy->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokCachePolicy = tokCachePolicy + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokCachePolicy == tokCachePolicyEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__MSAA: {
                                            const TokenHeader *tokMSAA = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokMSAAEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokMSAA < tokMSAAEnd) {
                                                if (false == tokMSAA->flags.flag4IsVariableLength) {
                                                    switch (tokMSAA->id) {
                                                    default:
                                                        if (tokMSAA->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                                                        dst.GmmResourceInfoCommon.Surf.MSAA.SamplePattern = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.MSAA.SamplePattern)>(*tokMSAA);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                                                        dst.GmmResourceInfoCommon.Surf.MSAA.NumSamples = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.MSAA.NumSamples)>(*tokMSAA);
                                                    } break;
                                                    };
                                                    tokMSAA = tokMSAA + 1 + tokMSAA->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMSAA);
                                                    if (tokMSAA->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokMSAA = tokMSAA + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokMSAA == tokMSAAEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT: {
                                            const TokenHeader *tokAlignment = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokAlignmentEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokAlignment < tokAlignmentEnd) {
                                                if (false == tokAlignment->flags.flag4IsVariableLength) {
                                                    switch (tokAlignment->id) {
                                                    default:
                                                        if (tokAlignment->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.ArraySpacingSingleLod = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.ArraySpacingSingleLod)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.BaseAlignment = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.BaseAlignment)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.HAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.HAlign)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.VAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.VAlign)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.DAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.DAlign)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.MipTailStartLod = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.MipTailStartLod)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipStartLod = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipStartLod)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipWidth = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipWidth)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipHeight)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                                                        dst.GmmResourceInfoCommon.Surf.Alignment.QPitch = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Alignment.QPitch)>(*tokAlignment);
                                                    } break;
                                                    };
                                                    tokAlignment = tokAlignment + 1 + tokAlignment->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAlignment);
                                                    if (tokAlignment->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokAlignment = tokAlignment + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokAlignment == tokAlignmentEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO: {
                                            const TokenHeader *tokOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokOffsetInfo < tokOffsetInfoEnd) {
                                                if (false == tokOffsetInfo->flags.flag4IsVariableLength) {
                                                    if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokOffsetInfo = tokOffsetInfo + 1 + tokOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOffsetInfo);
                                                    switch (tokOffsetInfo->id) {
                                                    default:
                                                        if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                                                        const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                                                            if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                                                                switch (tokTexture3DOffsetInfo->id) {
                                                                default:
                                                                    if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                                                    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                                                                } break;
                                                                case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset));
                                                                } break;
                                                                };
                                                                tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                                                                if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                                                    } break;
                                                    case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                                                        const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                                                            if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                                                                switch (tokTexture2DOffsetInfo->id) {
                                                                default:
                                                                    if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                                                    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                                                                } break;
                                                                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                                                    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                                                                } break;
                                                                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset));
                                                                } break;
                                                                };
                                                                tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                                                                if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                                                    } break;
                                                    case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                                                        const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokPlane < tokPlaneEnd) {
                                                            if (false == tokPlane->flags.flag4IsVariableLength) {
                                                                switch (tokPlane->id) {
                                                                default:
                                                                    if (tokPlane->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                                                    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.ArrayQPitch = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.ArrayQPitch)>(*tokPlane);
                                                                } break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X));
                                                                } break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y));
                                                                } break;
                                                                case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                                                    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.NoOfPlanes = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.NoOfPlanes)>(*tokPlane);
                                                                } break;
                                                                case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                                                    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.IsTileAlignedPlanes)>(*tokPlane);
                                                                } break;
                                                                };
                                                                tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                                                                switch (tokPlane->id) {
                                                                default:
                                                                    if (tokPlane->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                                                    const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                                                    const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                                    while (tokUnAligned < tokUnAlignedEnd) {
                                                                        if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                                                            switch (tokUnAligned->id) {
                                                                            default:
                                                                                if (tokUnAligned->flags.flag3IsMandatory) {
                                                                                    return false;
                                                                                }
                                                                                break;
                                                                            case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                                                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                                                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                                                                if (srcSize < sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height)) {
                                                                                    return false;
                                                                                }
                                                                                WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height), srcData, sizeof(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height));
                                                                            } break;
                                                                            };
                                                                            tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                                                        } else {
                                                                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                                                            if (tokUnAligned->flags.flag3IsMandatory) {
                                                                                return false;
                                                                            }
                                                                            tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                                        }
                                                                    }
                                                                    WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                                                                } break;
                                                                };
                                                                tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokPlane == tokPlaneEnd);
                                                    } break;
                                                    };
                                                    tokOffsetInfo = tokOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokOffsetInfo == tokOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__S3D: {
                                            const TokenHeader *tokS3d = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokS3dEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokS3d < tokS3dEnd) {
                                                if (false == tokS3d->flags.flag4IsVariableLength) {
                                                    switch (tokS3d->id) {
                                                    default:
                                                        if (tokS3d->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.DisplayModeHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.DisplayModeHeight)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.NumBlankActiveLines = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.NumBlankActiveLines)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.RFrameOffset = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.RFrameOffset)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.BlankAreaOffset = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.BlankAreaOffset)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.TallBufferHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.TallBufferHeight)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.TallBufferSize = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.TallBufferSize)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                                                        dst.GmmResourceInfoCommon.Surf.S3d.IsRFrame = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.S3d.IsRFrame)>(*tokS3d);
                                                    } break;
                                                    };
                                                    tokS3d = tokS3d + 1 + tokS3d->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokS3d);
                                                    if (tokS3d->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokS3d = tokS3d + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokS3d == tokS3dEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE: {
                                            const TokenHeader *tokSegmentOverride = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSegmentOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSegmentOverride < tokSegmentOverrideEnd) {
                                                if (false == tokSegmentOverride->flags.flag4IsVariableLength) {
                                                    switch (tokSegmentOverride->id) {
                                                    default:
                                                        if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1: {
                                                        dst.GmmResourceInfoCommon.Surf.SegmentOverride.Seg1 = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.SegmentOverride.Seg1)>(*tokSegmentOverride);
                                                    } break;
                                                    case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT: {
                                                        dst.GmmResourceInfoCommon.Surf.SegmentOverride.Evict = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.SegmentOverride.Evict)>(*tokSegmentOverride);
                                                    } break;
                                                    };
                                                    tokSegmentOverride = tokSegmentOverride + 1 + tokSegmentOverride->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSegmentOverride);
                                                    if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokSegmentOverride = tokSegmentOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSegmentOverride == tokSegmentOverrideEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM: {
#if _DEBUG || _RELEASE_INTERNAL
                                            const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlatform < tokPlatformEnd) {
                                                if (false == tokPlatform->flags.flag4IsVariableLength) {
                                                    switch (tokPlatform->id) {
                                                    default:
                                                        if (tokPlatform->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.eProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.eProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.ePCHProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.ePCHProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.eDisplayCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.eDisplayCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.eRenderCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.eRenderCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.ePlatformType = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.ePlatformType)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.usDeviceID = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.usDeviceID)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.usRevId = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.usRevId)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.usDeviceID_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.usDeviceID_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.usRevId_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.usRevId_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                                        dst.GmmResourceInfoCommon.Surf.Platform.eGTType = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.Platform.eGTType)>(*tokPlatform);
                                                    } break;
                                                    };
                                                    tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                                    if (tokPlatform->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM: {
                                            const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokExistingSysMem < tokExistingSysMemEnd) {
                                                if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                                                    switch (tokExistingSysMem->id) {
                                                    default:
                                                        if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED: {
                                                        dst.GmmResourceInfoCommon.Surf.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                                                    } break;
                                                    case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED: {
                                                        dst.GmmResourceInfoCommon.Surf.ExistingSysMem.IsPageAligned = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.ExistingSysMem.IsPageAligned)>(*tokExistingSysMem);
                                                    } break;
                                                    };
                                                    tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                                                    if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM: {
#if !(_DEBUG || _RELEASE_INTERNAL)
                                            const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlatform < tokPlatformEnd) {
                                                if (false == tokPlatform->flags.flag4IsVariableLength) {
                                                    switch (tokPlatform->id) {
                                                    default:
                                                        if (tokPlatform->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.eProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.eProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.ePCHProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.ePCHProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.eDisplayCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.eDisplayCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.eRenderCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.eRenderCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.ePlatformType = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.ePlatformType)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.usDeviceID = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.usDeviceID)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.usRevId = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.usRevId)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.usDeviceID_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.usDeviceID_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.usRevId_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.usRevId_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                                        dst.GmmResourceInfoCommon.Surf.__Platform.eGTType = readTokValue<decltype(dst.GmmResourceInfoCommon.Surf.__Platform.eGTType)>(*tokPlatform);
                                                    } break;
                                                    };
                                                    tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                                    if (tokPlatform->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                                        } break;
                                        };
                                        tokSurf = tokSurf + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokSurf == tokSurfEnd);
                            } break;
                            case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__AUX_SURF: {
                                const TokenHeader *tokAuxSurf = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokAuxSurfEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokAuxSurf < tokAuxSurfEnd) {
                                    if (false == tokAuxSurf->flags.flag4IsVariableLength) {
                                        switch (tokAuxSurf->id) {
                                        default:
                                            if (tokAuxSurf->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                                            dst.GmmResourceInfoCommon.AuxSurf.Type = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Type)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                                            dst.GmmResourceInfoCommon.AuxSurf.Format = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Format)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                                            dst.GmmResourceInfoCommon.AuxSurf.BitsPerPixel = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.BitsPerPixel)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                                            dst.GmmResourceInfoCommon.AuxSurf.BaseWidth = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.BaseWidth)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                                            dst.GmmResourceInfoCommon.AuxSurf.BaseHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.BaseHeight)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                                            dst.GmmResourceInfoCommon.AuxSurf.Depth = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Depth)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                                            dst.GmmResourceInfoCommon.AuxSurf.MaxLod = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.MaxLod)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                                            dst.GmmResourceInfoCommon.AuxSurf.ArraySize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.ArraySize)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                                            dst.GmmResourceInfoCommon.AuxSurf.CpTag = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.CpTag)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.MmcMode)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.MmcMode, sizeof(dst.GmmResourceInfoCommon.AuxSurf.MmcMode), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.MmcMode));
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSurf).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.MmcHint)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.MmcHint, sizeof(dst.GmmResourceInfoCommon.AuxSurf.MmcHint), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.MmcHint));
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                                            dst.GmmResourceInfoCommon.AuxSurf.Pitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Pitch)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                                            dst.GmmResourceInfoCommon.AuxSurf.OverridePitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OverridePitch)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                                            dst.GmmResourceInfoCommon.AuxSurf.Size = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Size)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                                            dst.GmmResourceInfoCommon.AuxSurf.CCSize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.CCSize)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                                            dst.GmmResourceInfoCommon.AuxSurf.UnpaddedSize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.UnpaddedSize)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                                            dst.GmmResourceInfoCommon.AuxSurf.SizeReportToOS = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.SizeReportToOS)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                                            dst.GmmResourceInfoCommon.AuxSurf.TileMode = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.TileMode)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN: {
                                            dst.GmmResourceInfoCommon.AuxSurf.CCSModeAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.CCSModeAlign)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS: {
                                            dst.GmmResourceInfoCommon.AuxSurf.LegacyFlags = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.LegacyFlags)>(*tokAuxSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH: {
                                            dst.GmmResourceInfoCommon.AuxSurf.MaximumRenamingListLength = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.MaximumRenamingListLength)>(*tokAuxSurf);
                                        } break;
                                        };
                                        tokAuxSurf = tokAuxSurf + 1 + tokAuxSurf->valueDwordCount;
                                    } else {
                                        auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAuxSurf);
                                        switch (tokAuxSurf->id) {
                                        default:
                                            if (tokAuxSurf->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS: {
                                            const TokenHeader *tokFlags = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokFlagsEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokFlags < tokFlagsEnd) {
                                                if (false == tokFlags->flags.flag4IsVariableLength) {
                                                    if (tokFlags->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokFlags = tokFlags + 1 + tokFlags->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokFlags);
                                                    switch (tokFlags->id) {
                                                    default:
                                                        if (tokFlags->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_RESOURCE_FLAG_REC__GPU: {
                                                        const TokenHeader *tokGpu = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokGpuEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokGpu < tokGpuEnd) {
                                                            if (false == tokGpu->flags.flag4IsVariableLength) {
                                                                switch (tokGpu->id) {
                                                                default:
                                                                    if (tokGpu->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CameraCapture = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CameraCapture)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CCS = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CCS)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorDiscard = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorDiscard)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparation = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparation)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparationRGBX = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparationRGBX)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Constant = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Constant)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Depth = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Depth)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChain = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChain)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChainPreferred = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChainPreferred)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HistoryBuffer = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HistoryBuffer)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HiZ = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HiZ)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Index = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Index)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.IndirectClearColor = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.IndirectClearColor)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InstructionFlat = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InstructionFlat)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InterlacedScan = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InterlacedScan)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MCS = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MCS)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MMC = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MMC)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MotionComp = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MotionComp)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.NoRestriction = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.NoRestriction)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Overlay = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Overlay)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Presentable = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Presentable)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ProceduralTexture = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ProceduralTexture)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Query = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Query)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.RenderTarget = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.RenderTarget)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3d = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3d)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3dDx = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3dDx)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dNonPacked = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dNonPacked)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dWidi = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dWidi)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ScratchFlat = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ScratchFlat)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.SeparateStencil = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.SeparateStencil)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.State = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.State)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Stream = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Stream)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TextApi = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TextApi)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Texture = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Texture)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TiledResource = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TiledResource)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TilePool = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TilePool)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.UnifiedAuxSurface = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.UnifiedAuxSurface)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Vertex = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Vertex)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Video = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Video)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__MsaaTileMcs = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__MsaaTileMcs)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS)>(*tokGpu);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__Remaining = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__Remaining)>(*tokGpu);
                                                                } break;
                                                                };
                                                                tokGpu = tokGpu + 1 + tokGpu->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokGpu);
                                                                if (tokGpu->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokGpu = tokGpu + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokGpu == tokGpuEnd);
                                                    } break;
                                                    case TOK_FS_GMM_RESOURCE_FLAG_REC__INFO: {
                                                        const TokenHeader *tokInfo = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokInfo < tokInfoEnd) {
                                                            if (false == tokInfo->flags.flag4IsVariableLength) {
                                                                switch (tokInfo->id) {
                                                                default:
                                                                    if (tokInfo->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.AllowVirtualPadding = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.AllowVirtualPadding)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.BigPage = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.BigPage)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Cacheable = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Cacheable)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ContigPhysMemoryForiDART = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ContigPhysMemoryForiDART)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.CornerTexelMode = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.CornerTexelMode)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ExistingSysMem = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ExistingSysMem)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ForceResidency = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ForceResidency)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Gfdt = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Gfdt)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.GttMapType = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.GttMapType)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.HardwareProtected = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.HardwareProtected)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.KernelModeMapped = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.KernelModeMapped)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutBelow = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutBelow)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutMono = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutMono)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutRight = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutRight)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LocalOnly = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LocalOnly)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Linear = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Linear)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.MediaCompressed = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.MediaCompressed)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoOptimizationPadding = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoOptimizationPadding)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoPhysMemory = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoPhysMemory)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NotLockable = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NotLockable)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NonLocalOnly = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NonLocalOnly)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.StdSwizzle = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.StdSwizzle)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.PseudoStdSwizzle = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.PseudoStdSwizzle)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Undefined64KBSwizzle = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Undefined64KBSwizzle)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.RedecribedPlanes = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.RedecribedPlanes)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.RenderCompressed = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.RenderCompressed)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Rotated = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Rotated)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Shared = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Shared)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.SoftwareProtected = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.SoftwareProtected)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.SVM = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.SVM)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile4 = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile4)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile64 = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile64)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledW = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledW)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledX = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledX)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledY = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledY)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYf = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYf)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYs = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYs)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.WddmProtected = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.WddmProtected)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.XAdapter = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.XAdapter)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreallocatedResInfo = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreallocatedResInfo)>(*tokInfo);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreWddm2SVM = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreWddm2SVM)>(*tokInfo);
                                                                } break;
                                                                };
                                                                tokInfo = tokInfo + 1 + tokInfo->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokInfo);
                                                                if (tokInfo->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokInfo = tokInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokInfo == tokInfoEnd);
                                                    } break;
                                                    case TOK_FS_GMM_RESOURCE_FLAG_REC__WA: {
                                                        const TokenHeader *tokWa = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokWaEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokWa < tokWaEnd) {
                                                            if (false == tokWa->flags.flag4IsVariableLength) {
                                                                switch (tokWa->id) {
                                                                default:
                                                                    if (tokWa->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoBufferSamplerPadding = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoBufferSamplerPadding)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisablePackedMipTail = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisablePackedMipTail)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4 = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsCompression = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsCompression)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.PreGen12FastClearOnly = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.PreGen12FastClearOnly)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__FORCE_STD_ALLOC_ALIGN: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ForceStdAllocAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ForceStdAllocAlign)>(*tokWa);
                                                                } break;
                                                                case TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DENIABLE_LOCAL_ONLY_FOR_COMPRESSION: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression)>(*tokWa);
                                                                } break;
                                                                };
                                                                tokWa = tokWa + 1 + tokWa->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokWa);
                                                                if (tokWa->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokWa = tokWa + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokWa == tokWaEnd);
                                                    } break;
                                                    };
                                                    tokFlags = tokFlags + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokFlags == tokFlagsEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY: {
                                            const TokenHeader *tokCachePolicy = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokCachePolicyEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokCachePolicy < tokCachePolicyEnd) {
                                                if (false == tokCachePolicy->flags.flag4IsVariableLength) {
                                                    switch (tokCachePolicy->id) {
                                                    default:
                                                        if (tokCachePolicy->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.CachePolicy.Usage = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.CachePolicy.Usage)>(*tokCachePolicy);
                                                    } break;
                                                    };
                                                    tokCachePolicy = tokCachePolicy + 1 + tokCachePolicy->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokCachePolicy);
                                                    if (tokCachePolicy->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokCachePolicy = tokCachePolicy + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokCachePolicy == tokCachePolicyEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__MSAA: {
                                            const TokenHeader *tokMSAA = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokMSAAEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokMSAA < tokMSAAEnd) {
                                                if (false == tokMSAA->flags.flag4IsVariableLength) {
                                                    switch (tokMSAA->id) {
                                                    default:
                                                        if (tokMSAA->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.MSAA.SamplePattern = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.MSAA.SamplePattern)>(*tokMSAA);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.MSAA.NumSamples = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.MSAA.NumSamples)>(*tokMSAA);
                                                    } break;
                                                    };
                                                    tokMSAA = tokMSAA + 1 + tokMSAA->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokMSAA);
                                                    if (tokMSAA->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokMSAA = tokMSAA + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokMSAA == tokMSAAEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT: {
                                            const TokenHeader *tokAlignment = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokAlignmentEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokAlignment < tokAlignmentEnd) {
                                                if (false == tokAlignment->flags.flag4IsVariableLength) {
                                                    switch (tokAlignment->id) {
                                                    default:
                                                        if (tokAlignment->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.ArraySpacingSingleLod = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.ArraySpacingSingleLod)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.BaseAlignment = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.BaseAlignment)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.HAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.HAlign)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.VAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.VAlign)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.DAlign = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.DAlign)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.MipTailStartLod = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.MipTailStartLod)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipStartLod = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipStartLod)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipWidth = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipWidth)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipHeight)>(*tokAlignment);
                                                    } break;
                                                    case TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Alignment.QPitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Alignment.QPitch)>(*tokAlignment);
                                                    } break;
                                                    };
                                                    tokAlignment = tokAlignment + 1 + tokAlignment->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokAlignment);
                                                    if (tokAlignment->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokAlignment = tokAlignment + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokAlignment == tokAlignmentEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO: {
                                            const TokenHeader *tokOffsetInfo = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokOffsetInfo < tokOffsetInfoEnd) {
                                                if (false == tokOffsetInfo->flags.flag4IsVariableLength) {
                                                    if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokOffsetInfo = tokOffsetInfo + 1 + tokOffsetInfo->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokOffsetInfo);
                                                    switch (tokOffsetInfo->id) {
                                                    default:
                                                        if (tokOffsetInfo->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO: {
                                                        const TokenHeader *tokTexture3DOffsetInfo = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokTexture3DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokTexture3DOffsetInfo < tokTexture3DOffsetInfoEnd) {
                                                            if (false == tokTexture3DOffsetInfo->flags.flag4IsVariableLength) {
                                                                switch (tokTexture3DOffsetInfo->id) {
                                                                default:
                                                                    if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch)>(*tokTexture3DOffsetInfo);
                                                                } break;
                                                                case TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture3DOffsetInfo).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
                                                                } break;
                                                                };
                                                                tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + 1 + tokTexture3DOffsetInfo->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture3DOffsetInfo);
                                                                if (tokTexture3DOffsetInfo->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokTexture3DOffsetInfo = tokTexture3DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokTexture3DOffsetInfo == tokTexture3DOffsetInfoEnd);
                                                    } break;
                                                    case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO: {
                                                        const TokenHeader *tokTexture2DOffsetInfo = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokTexture2DOffsetInfoEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokTexture2DOffsetInfo < tokTexture2DOffsetInfoEnd) {
                                                            if (false == tokTexture2DOffsetInfo->flags.flag4IsVariableLength) {
                                                                switch (tokTexture2DOffsetInfo->id) {
                                                                default:
                                                                    if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock)>(*tokTexture2DOffsetInfo);
                                                                } break;
                                                                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender)>(*tokTexture2DOffsetInfo);
                                                                } break;
                                                                case TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokTexture2DOffsetInfo).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
                                                                } break;
                                                                };
                                                                tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + 1 + tokTexture2DOffsetInfo->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokTexture2DOffsetInfo);
                                                                if (tokTexture2DOffsetInfo->flags.flag3IsMandatory) {
                                                                    return false;
                                                                }
                                                                tokTexture2DOffsetInfo = tokTexture2DOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokTexture2DOffsetInfo == tokTexture2DOffsetInfoEnd);
                                                    } break;
                                                    case TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE: {
                                                        const TokenHeader *tokPlane = varLen->getValue<TokenHeader>();
                                                        const TokenHeader *tokPlaneEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                        while (tokPlane < tokPlaneEnd) {
                                                            if (false == tokPlane->flags.flag4IsVariableLength) {
                                                                switch (tokPlane->id) {
                                                                default:
                                                                    if (tokPlane->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.ArrayQPitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.ArrayQPitch)>(*tokPlane);
                                                                } break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X));
                                                                } break;
                                                                case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y: {
                                                                    auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValue<char>();
                                                                    auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokPlane).getValueSizeInBytes();
                                                                    if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y)) {
                                                                        return false;
                                                                    }
                                                                    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y));
                                                                } break;
                                                                case TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.NoOfPlanes = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.NoOfPlanes)>(*tokPlane);
                                                                } break;
                                                                case TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES: {
                                                                    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes)>(*tokPlane);
                                                                } break;
                                                                };
                                                                tokPlane = tokPlane + 1 + tokPlane->valueDwordCount;
                                                            } else {
                                                                auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlane);
                                                                switch (tokPlane->id) {
                                                                default:
                                                                    if (tokPlane->flags.flag3IsMandatory) {
                                                                        return false;
                                                                    }
                                                                    break;
                                                                case TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED: {
                                                                    const TokenHeader *tokUnAligned = varLen->getValue<TokenHeader>();
                                                                    const TokenHeader *tokUnAlignedEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                                                    while (tokUnAligned < tokUnAlignedEnd) {
                                                                        if (false == tokUnAligned->flags.flag4IsVariableLength) {
                                                                            switch (tokUnAligned->id) {
                                                                            default:
                                                                                if (tokUnAligned->flags.flag3IsMandatory) {
                                                                                    return false;
                                                                                }
                                                                                break;
                                                                            case TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT: {
                                                                                auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValue<char>();
                                                                                auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokUnAligned).getValueSizeInBytes();
                                                                                if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height)) {
                                                                                    return false;
                                                                                }
                                                                                WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height));
                                                                            } break;
                                                                            };
                                                                            tokUnAligned = tokUnAligned + 1 + tokUnAligned->valueDwordCount;
                                                                        } else {
                                                                            auto varLen = reinterpret_cast<const TokenVariableLength *>(tokUnAligned);
                                                                            if (tokUnAligned->flags.flag3IsMandatory) {
                                                                                return false;
                                                                            }
                                                                            tokUnAligned = tokUnAligned + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                                        }
                                                                    }
                                                                    WCH_ASSERT(tokUnAligned == tokUnAlignedEnd);
                                                                } break;
                                                                };
                                                                tokPlane = tokPlane + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                            }
                                                        }
                                                        WCH_ASSERT(tokPlane == tokPlaneEnd);
                                                    } break;
                                                    };
                                                    tokOffsetInfo = tokOffsetInfo + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokOffsetInfo == tokOffsetInfoEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__S3D: {
                                            const TokenHeader *tokS3d = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokS3dEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokS3d < tokS3dEnd) {
                                                if (false == tokS3d->flags.flag4IsVariableLength) {
                                                    switch (tokS3d->id) {
                                                    default:
                                                        if (tokS3d->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.DisplayModeHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.DisplayModeHeight)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.NumBlankActiveLines = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.NumBlankActiveLines)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.RFrameOffset = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.RFrameOffset)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.BlankAreaOffset = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.BlankAreaOffset)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferHeight)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferSize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferSize)>(*tokS3d);
                                                    } break;
                                                    case TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.S3d.IsRFrame = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.S3d.IsRFrame)>(*tokS3d);
                                                    } break;
                                                    };
                                                    tokS3d = tokS3d + 1 + tokS3d->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokS3d);
                                                    if (tokS3d->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokS3d = tokS3d + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokS3d == tokS3dEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE: {
                                            const TokenHeader *tokSegmentOverride = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokSegmentOverrideEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokSegmentOverride < tokSegmentOverrideEnd) {
                                                if (false == tokSegmentOverride->flags.flag4IsVariableLength) {
                                                    switch (tokSegmentOverride->id) {
                                                    default:
                                                        if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Seg1 = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Seg1)>(*tokSegmentOverride);
                                                    } break;
                                                    case TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Evict = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Evict)>(*tokSegmentOverride);
                                                    } break;
                                                    };
                                                    tokSegmentOverride = tokSegmentOverride + 1 + tokSegmentOverride->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokSegmentOverride);
                                                    if (tokSegmentOverride->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokSegmentOverride = tokSegmentOverride + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokSegmentOverride == tokSegmentOverrideEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM: {
#if _DEBUG || _RELEASE_INTERNAL
                                            const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlatform < tokPlatformEnd) {
                                                if (false == tokPlatform->flags.flag4IsVariableLength) {
                                                    switch (tokPlatform->id) {
                                                    default:
                                                        if (tokPlatform->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.eProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.eProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.ePCHProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.ePCHProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.eDisplayCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.eDisplayCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.eRenderCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.eRenderCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.ePlatformType = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.ePlatformType)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.usRevId = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.usRevId)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.usRevId_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.usRevId_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.Platform.eGTType = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.Platform.eGTType)>(*tokPlatform);
                                                    } break;
                                                    };
                                                    tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                                    if (tokPlatform->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM: {
                                            const TokenHeader *tokExistingSysMem = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokExistingSysMemEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokExistingSysMem < tokExistingSysMemEnd) {
                                                if (false == tokExistingSysMem->flags.flag4IsVariableLength) {
                                                    switch (tokExistingSysMem->id) {
                                                    default:
                                                        if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsGmmAllocated = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsGmmAllocated)>(*tokExistingSysMem);
                                                    } break;
                                                    case TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsPageAligned = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsPageAligned)>(*tokExistingSysMem);
                                                    } break;
                                                    };
                                                    tokExistingSysMem = tokExistingSysMem + 1 + tokExistingSysMem->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokExistingSysMem);
                                                    if (tokExistingSysMem->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokExistingSysMem = tokExistingSysMem + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokExistingSysMem == tokExistingSysMemEnd);
                                        } break;
                                        case TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM: {
#if !(_DEBUG || _RELEASE_INTERNAL)
                                            const TokenHeader *tokPlatform = varLen->getValue<TokenHeader>();
                                            const TokenHeader *tokPlatformEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                            while (tokPlatform < tokPlatformEnd) {
                                                if (false == tokPlatform->flags.flag4IsVariableLength) {
                                                    switch (tokPlatform->id) {
                                                    default:
                                                        if (tokPlatform->flags.flag3IsMandatory) {
                                                            return false;
                                                        }
                                                        break;
                                                    case TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.eProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.eProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.ePCHProductFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.ePCHProductFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.eDisplayCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.eDisplayCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.eRenderCoreFamily = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.eRenderCoreFamily)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.ePlatformType = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.ePlatformType)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FBW_PLATFORM_STR__US_REV_ID_PCH: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId_PCH = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId_PCH)>(*tokPlatform);
                                                    } break;
                                                    case TOK_FE_PLATFORM_STR__E_GTTYPE: {
                                                        dst.GmmResourceInfoCommon.AuxSurf.__Platform.eGTType = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSurf.__Platform.eGTType)>(*tokPlatform);
                                                    } break;
                                                    };
                                                    tokPlatform = tokPlatform + 1 + tokPlatform->valueDwordCount;
                                                } else {
                                                    auto varLen = reinterpret_cast<const TokenVariableLength *>(tokPlatform);
                                                    if (tokPlatform->flags.flag3IsMandatory) {
                                                        return false;
                                                    }
                                                    tokPlatform = tokPlatform + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                                }
                                            }
                                            WCH_ASSERT(tokPlatform == tokPlatformEnd);
#endif
                                        } break;
                                        };
                                        tokAuxSurf = tokAuxSurf + sizeof(TokenVariableLength) / sizeof(uint32_t) + varLen->valuePaddedSizeInDwords;
                                    }
                                }
                                WCH_ASSERT(tokAuxSurf == tokAuxSurfEnd);
                            } break;
                            case TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__AUX_SEC_SURF: {
                                const TokenHeader *tokAuxSecSurf = varLen->getValue<TokenHeader>();
                                const TokenHeader *tokAuxSecSurfEnd = varLen->getValue<TokenHeader>() + varLen->valueLengthInBytes / sizeof(TokenHeader);
                                while (tokAuxSecSurf < tokAuxSecSurfEnd) {
                                    if (false == tokAuxSecSurf->flags.flag4IsVariableLength) {
                                        switch (tokAuxSecSurf->id) {
                                        default:
                                            if (tokAuxSecSurf->flags.flag3IsMandatory) {
                                                return false;
                                            }
                                            break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__TYPE: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.Type = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.Type)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.Format = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.Format)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.BitsPerPixel = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.BitsPerPixel)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.BaseWidth = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.BaseWidth)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.BaseHeight = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.BaseHeight)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.Depth = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.Depth)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.MaxLod = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.MaxLod)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.ArraySize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.ArraySize)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.CpTag = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.CpTag)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSecSurf.MmcMode)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.MmcMode, sizeof(dst.GmmResourceInfoCommon.AuxSecSurf.MmcMode), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSecSurf.MmcMode));
                                        } break;
                                        case TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT: {
                                            auto srcData = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValue<char>();
                                            auto srcSize = reinterpret_cast<const TokenArray<1> &>(*tokAuxSecSurf).getValueSizeInBytes();
                                            if (srcSize < sizeof(dst.GmmResourceInfoCommon.AuxSecSurf.MmcHint)) {
                                                return false;
                                            }
                                            WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.MmcHint, sizeof(dst.GmmResourceInfoCommon.AuxSecSurf.MmcHint), srcData, sizeof(dst.GmmResourceInfoCommon.AuxSecSurf.MmcHint));
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.Pitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.Pitch)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.OverridePitch = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.OverridePitch)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.Size = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.Size)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.CCSize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.CCSize)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.UnpaddedSize = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.UnpaddedSize)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.SizeReportToOS = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.SizeReportToOS)>(*tokAuxSecSurf);
                                        } break;
                                        case TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE: {
                                            dst.GmmResourceInfoCommon.AuxSecSurf.TileMode = readTokValue<decltype(dst.GmmResourceInfoCommon.AuxSecSurf.TileMode)>(*tokAuxSecSurf);
     