/* $Id$ $Revision$ */
/* vim:set shiftwidth=4 ts=8: */

/*************************************************************************
 * Copyright (c) 2011 AT&T Intellectual Property 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: See CVS logs. Details at http://www.graphviz.org/
 *************************************************************************/



#ifndef _VIS_INCLUDE
#define _VIS_INCLUDE

#include <pathgeom.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_BLD_pathplan) && defined(__EXPORT__)
#   define extern __EXPORT__
#endif

/* open a visibility graph 
 * Points in polygonal obstacles must be in clockwise order.
 */
    extern vconfig_t *Pobsopen(Ppoly_t ** obstacles, int n_obstacles);

/* close a visibility graph, freeing its storage */
    extern void Pobsclose(vconfig_t * config);

/* route a polyline from p0 to p1, avoiding obstacles.
 * if an endpoint is inside an obstacle, pass the polygon's index >=0
 * if the endpoint is not inside an obstacle, pass POLYID_NONE
 * if the endpoint location is not known, pass POLYID_UNKNOWN
 */

    extern int Pobspath(vconfig_t * config, Ppoint_t p0, int poly0,
			Ppoint_t p1, int poly1,
			Ppolyline_t * output_route);

#define POLYID_NONE		-1111
#define POLYID_UNKNOWN	-2222

#undef extern

#ifdef __cplusplus
}
#endif
#endif
