# The Singularity Image Format (SIF)

[![PkgGoDev](https://pkg.go.dev/badge/github.com/sylabs/sif/v2?status.svg)](https://pkg.go.dev/github.com/sylabs/sif/v2)
[![Build Status](https://circleci.com/gh/sylabs/sif.svg?style=shield)](https://circleci.com/gh/sylabs/workflows/sif)
[![Code Coverage](https://codecov.io/gh/sylabs/sif/branch/main/graph/badge.svg)](https://app.codecov.io/gh/sylabs/sif)
[![Go Report Card](https://goreportcard.com/badge/github.com/sylabs/sif)](https://goreportcard.com/report/github.com/sylabs/sif)
[![Powered By GoReleaser](https://img.shields.io/badge/powered%20by-goreleaser-green.svg)](https://github.com/goreleaser)

This module contains an open source implementation of the Singularity Image Format (SIF) that makes it easy to create complete and encapsulated container environments stored in a single file.

![SIF Image](doc/sif.png)

Unless otherwise noted, the SIF source files are distributed under the BSD-style license found in the [LICENSE.md](LICENSE.md) file.

## Install Siftool

Pre-built binaries are available with the [latest release](https://github.com/sylabs/sif/releases).

## Go Version Compatibility

This module aims to maintain support for the two most recent stable versions of Go. This corresponds to the Go [Release Maintenance Policy](https://go.dev/wiki/Go-Release-Cycle#release-maintenance) and [Security Policy](https://go.dev/doc/security/policy), ensuring critical bug fixes and security patches are available for all supported language versions.

## Contributing

SIF and [SingularityCE](https://github.com/sylabs/singularity) are the work of many contributors. We appreciate your help!

To contribute, please read the contribution guidelines found in the [CONTRIBUTING.md](CONTRIBUTING.md) file.
